// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/aiplatform/v1beta1/training_pipeline.proto

package aiplatformpb

import (
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	structpb "google.golang.org/protobuf/types/known/structpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The TrainingPipeline orchestrates tasks associated with training a Model. It
// always executes the training task, and optionally may also
// export data from Vertex AI's Dataset which becomes the training input,
// [upload][google.cloud.aiplatform.v1beta1.ModelService.UploadModel] the Model
// to Vertex AI, and evaluate the Model.
type TrainingPipeline struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Resource name of the TrainingPipeline.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The user-defined name of this TrainingPipeline.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Specifies Vertex AI owned input data that may be used for training the
	// Model. The TrainingPipeline's
	// [training_task_definition][google.cloud.aiplatform.v1beta1.TrainingPipeline.training_task_definition]
	// should make clear whether this config is used and if there are any special
	// requirements on how it should be filled. If nothing about this config is
	// mentioned in the
	// [training_task_definition][google.cloud.aiplatform.v1beta1.TrainingPipeline.training_task_definition],
	// then it should be assumed that the TrainingPipeline does not depend on this
	// configuration.
	InputDataConfig *InputDataConfig `protobuf:"bytes,3,opt,name=input_data_config,json=inputDataConfig,proto3" json:"input_data_config,omitempty"`
	// Required. A Google Cloud Storage path to the YAML file that defines the
	// training task which is responsible for producing the model artifact, and
	// may also include additional auxiliary work. The definition files that can
	// be used here are found in
	// gs://google-cloud-aiplatform/schema/trainingjob/definition/.
	// Note: The URI given on output will be immutable and probably different,
	// including the URI scheme, than the one given on input. The output URI will
	// point to a location where the user only has a read access.
	TrainingTaskDefinition string `protobuf:"bytes,4,opt,name=training_task_definition,json=trainingTaskDefinition,proto3" json:"training_task_definition,omitempty"`
	// Required. The training task's parameter(s), as specified in the
	// [training_task_definition][google.cloud.aiplatform.v1beta1.TrainingPipeline.training_task_definition]'s
	// `inputs`.
	TrainingTaskInputs *structpb.Value `protobuf:"bytes,5,opt,name=training_task_inputs,json=trainingTaskInputs,proto3" json:"training_task_inputs,omitempty"`
	// Output only. The metadata information as specified in the
	// [training_task_definition][google.cloud.aiplatform.v1beta1.TrainingPipeline.training_task_definition]'s
	// `metadata`. This metadata is an auxiliary runtime and final information
	// about the training task. While the pipeline is running this information is
	// populated only at a best effort basis. Only present if the
	// pipeline's
	// [training_task_definition][google.cloud.aiplatform.v1beta1.TrainingPipeline.training_task_definition]
	// contains `metadata` object.
	TrainingTaskMetadata *structpb.Value `protobuf:"bytes,6,opt,name=training_task_metadata,json=trainingTaskMetadata,proto3" json:"training_task_metadata,omitempty"`
	// Describes the Model that may be uploaded (via
	// [ModelService.UploadModel][google.cloud.aiplatform.v1beta1.ModelService.UploadModel])
	// by this TrainingPipeline. The TrainingPipeline's
	// [training_task_definition][google.cloud.aiplatform.v1beta1.TrainingPipeline.training_task_definition]
	// should make clear whether this Model description should be populated, and
	// if there are any special requirements regarding how it should be filled. If
	// nothing is mentioned in the
	// [training_task_definition][google.cloud.aiplatform.v1beta1.TrainingPipeline.training_task_definition],
	// then it should be assumed that this field should not be filled and the
	// training task either uploads the Model without a need of this information,
	// or that training task does not support uploading a Model as part of the
	// pipeline. When the Pipeline's state becomes `PIPELINE_STATE_SUCCEEDED` and
	// the trained Model had been uploaded into Vertex AI, then the
	// model_to_upload's resource
	// [name][google.cloud.aiplatform.v1beta1.Model.name] is populated. The Model
	// is always uploaded into the Project and Location in which this pipeline
	// is.
	ModelToUpload *Model `protobuf:"bytes,7,opt,name=model_to_upload,json=modelToUpload,proto3" json:"model_to_upload,omitempty"`
	// Optional. The ID to use for the uploaded Model, which will become the final
	// component of the model resource name.
	//
	// This value may be up to 63 characters, and valid characters are
	// `[a-z0-9_-]`. The first character cannot be a number or hyphen.
	ModelId string `protobuf:"bytes,22,opt,name=model_id,json=modelId,proto3" json:"model_id,omitempty"`
	// Optional. When specify this field, the `model_to_upload` will not be
	// uploaded as a new model, instead, it will become a new version of this
	// `parent_model`.
	ParentModel string `protobuf:"bytes,21,opt,name=parent_model,json=parentModel,proto3" json:"parent_model,omitempty"`
	// Output only. The detailed state of the pipeline.
	State PipelineState `protobuf:"varint,9,opt,name=state,proto3,enum=google.cloud.aiplatform.v1beta1.PipelineState" json:"state,omitempty"`
	// Output only. Only populated when the pipeline's state is
	// `PIPELINE_STATE_FAILED` or `PIPELINE_STATE_CANCELLED`.
	Error *status.Status `protobuf:"bytes,10,opt,name=error,proto3" json:"error,omitempty"`
	// Output only. Time when the TrainingPipeline was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,11,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Time when the TrainingPipeline for the first time entered the
	// `PIPELINE_STATE_RUNNING` state.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,12,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Output only. Time when the TrainingPipeline entered any of the following
	// states: `PIPELINE_STATE_SUCCEEDED`, `PIPELINE_STATE_FAILED`,
	// `PIPELINE_STATE_CANCELLED`.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,13,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. Time when the TrainingPipeline was most recently updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,14,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// The labels with user-defined metadata to organize TrainingPipelines.
	//
	// Label keys and values can be no longer than 64 characters
	// (Unicode codepoints), can only contain lowercase letters, numeric
	// characters, underscores and dashes. International characters are allowed.
	//
	// See https://goo.gl/xmQnxf for more information and examples of labels.
	Labels map[string]string `protobuf:"bytes,15,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Customer-managed encryption key spec for a TrainingPipeline. If set, this
	// TrainingPipeline will be secured by this key.
	//
	// Note: Model trained by this TrainingPipeline is also secured by this key if
	// [model_to_upload][google.cloud.aiplatform.v1beta1.TrainingPipeline.encryption_spec]
	// is not set separately.
	EncryptionSpec *EncryptionSpec `protobuf:"bytes,18,opt,name=encryption_spec,json=encryptionSpec,proto3" json:"encryption_spec,omitempty"`
}

func (x *TrainingPipeline) Reset() {
	*x = TrainingPipeline{}
	mi := &file_google_cloud_aiplatform_v1beta1_training_pipeline_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TrainingPipeline) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TrainingPipeline) ProtoMessage() {}

func (x *TrainingPipeline) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_training_pipeline_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TrainingPipeline.ProtoReflect.Descriptor instead.
func (*TrainingPipeline) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_training_pipeline_proto_rawDescGZIP(), []int{0}
}

func (x *TrainingPipeline) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *TrainingPipeline) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *TrainingPipeline) GetInputDataConfig() *InputDataConfig {
	if x != nil {
		return x.InputDataConfig
	}
	return nil
}

func (x *TrainingPipeline) GetTrainingTaskDefinition() string {
	if x != nil {
		return x.TrainingTaskDefinition
	}
	return ""
}

func (x *TrainingPipeline) GetTrainingTaskInputs() *structpb.Value {
	if x != nil {
		return x.TrainingTaskInputs
	}
	return nil
}

func (x *TrainingPipeline) GetTrainingTaskMetadata() *structpb.Value {
	if x != nil {
		return x.TrainingTaskMetadata
	}
	return nil
}

func (x *TrainingPipeline) GetModelToUpload() *Model {
	if x != nil {
		return x.ModelToUpload
	}
	return nil
}

func (x *TrainingPipeline) GetModelId() string {
	if x != nil {
		return x.ModelId
	}
	return ""
}

func (x *TrainingPipeline) GetParentModel() string {
	if x != nil {
		return x.ParentModel
	}
	return ""
}

func (x *TrainingPipeline) GetState() PipelineState {
	if x != nil {
		return x.State
	}
	return PipelineState_PIPELINE_STATE_UNSPECIFIED
}

func (x *TrainingPipeline) GetError() *status.Status {
	if x != nil {
		return x.Error
	}
	return nil
}

func (x *TrainingPipeline) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *TrainingPipeline) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *TrainingPipeline) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *TrainingPipeline) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *TrainingPipeline) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *TrainingPipeline) GetEncryptionSpec() *EncryptionSpec {
	if x != nil {
		return x.EncryptionSpec
	}
	return nil
}

// Specifies Vertex AI owned input data to be used for training, and
// possibly evaluating, the Model.
type InputDataConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The instructions how the input data should be split between the
	// training, validation and test sets.
	// If no split type is provided, the
	// [fraction_split][google.cloud.aiplatform.v1beta1.InputDataConfig.fraction_split]
	// is used by default.
	//
	// Types that are assignable to Split:
	//
	//	*InputDataConfig_FractionSplit
	//	*InputDataConfig_FilterSplit
	//	*InputDataConfig_PredefinedSplit
	//	*InputDataConfig_TimestampSplit
	//	*InputDataConfig_StratifiedSplit
	Split isInputDataConfig_Split `protobuf_oneof:"split"`
	// Only applicable to Custom and Hyperparameter Tuning TrainingPipelines.
	//
	// The destination of the training data to be written to.
	//
	// Supported destination file formats:
	//   - For non-tabular data: "jsonl".
	//   - For tabular data: "csv" and "bigquery".
	//
	// The following Vertex AI environment variables are passed to containers
	// or python modules of the training task when this field is set:
	//
	// * AIP_DATA_FORMAT : Exported data format.
	// * AIP_TRAINING_DATA_URI : Sharded exported training data uris.
	// * AIP_VALIDATION_DATA_URI : Sharded exported validation data uris.
	// * AIP_TEST_DATA_URI : Sharded exported test data uris.
	//
	// Types that are assignable to Destination:
	//
	//	*InputDataConfig_GcsDestination
	//	*InputDataConfig_BigqueryDestination
	Destination isInputDataConfig_Destination `protobuf_oneof:"destination"`
	// Required. The ID of the Dataset in the same Project and Location which data
	// will be used to train the Model. The Dataset must use schema compatible
	// with Model being trained, and what is compatible should be described in the
	// used TrainingPipeline's [training_task_definition]
	// [google.cloud.aiplatform.v1beta1.TrainingPipeline.training_task_definition].
	// For tabular Datasets, all their data is exported to training, to pick
	// and choose from.
	DatasetId string `protobuf:"bytes,1,opt,name=dataset_id,json=datasetId,proto3" json:"dataset_id,omitempty"`
	// Applicable only to Datasets that have DataItems and Annotations.
	//
	// A filter on Annotations of the Dataset. Only Annotations that both
	// match this filter and belong to DataItems not ignored by the split method
	// are used in respectively training, validation or test role, depending on
	// the role of the DataItem they are on (for the auto-assigned that role is
	// decided by Vertex AI). A filter with same syntax as the one used in
	// [ListAnnotations][google.cloud.aiplatform.v1beta1.DatasetService.ListAnnotations]
	// may be used, but note here it filters across all Annotations of the
	// Dataset, and not just within a single DataItem.
	AnnotationsFilter string `protobuf:"bytes,6,opt,name=annotations_filter,json=annotationsFilter,proto3" json:"annotations_filter,omitempty"`
	// Applicable only to custom training with Datasets that have DataItems and
	// Annotations.
	//
	// Cloud Storage URI that points to a YAML file describing the annotation
	// schema. The schema is defined as an OpenAPI 3.0.2 [Schema
	// Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
	// The schema files that can be used here are found in
	// gs://google-cloud-aiplatform/schema/dataset/annotation/ , note that the
	// chosen schema must be consistent with
	// [metadata][google.cloud.aiplatform.v1beta1.Dataset.metadata_schema_uri] of
	// the Dataset specified by
	// [dataset_id][google.cloud.aiplatform.v1beta1.InputDataConfig.dataset_id].
	//
	// Only Annotations that both match this schema and belong to DataItems not
	// ignored by the split method are used in respectively training, validation
	// or test role, depending on the role of the DataItem they are on.
	//
	// When used in conjunction with
	// [annotations_filter][google.cloud.aiplatform.v1beta1.InputDataConfig.annotations_filter],
	// the Annotations used for training are filtered by both
	// [annotations_filter][google.cloud.aiplatform.v1beta1.InputDataConfig.annotations_filter]
	// and
	// [annotation_schema_uri][google.cloud.aiplatform.v1beta1.InputDataConfig.annotation_schema_uri].
	AnnotationSchemaUri string `protobuf:"bytes,9,opt,name=annotation_schema_uri,json=annotationSchemaUri,proto3" json:"annotation_schema_uri,omitempty"`
	// Only applicable to Datasets that have SavedQueries.
	//
	// The ID of a SavedQuery (annotation set) under the Dataset specified by
	// [dataset_id][google.cloud.aiplatform.v1beta1.InputDataConfig.dataset_id]
	// used for filtering Annotations for training.
	//
	// Only Annotations that are associated with this SavedQuery are used in
	// respectively training. When used in conjunction with
	// [annotations_filter][google.cloud.aiplatform.v1beta1.InputDataConfig.annotations_filter],
	// the Annotations used for training are filtered by both
	// [saved_query_id][google.cloud.aiplatform.v1beta1.InputDataConfig.saved_query_id]
	// and
	// [annotations_filter][google.cloud.aiplatform.v1beta1.InputDataConfig.annotations_filter].
	//
	// Only one of
	// [saved_query_id][google.cloud.aiplatform.v1beta1.InputDataConfig.saved_query_id]
	// and
	// [annotation_schema_uri][google.cloud.aiplatform.v1beta1.InputDataConfig.annotation_schema_uri]
	// should be specified as both of them represent the same thing: problem type.
	SavedQueryId string `protobuf:"bytes,7,opt,name=saved_query_id,json=savedQueryId,proto3" json:"saved_query_id,omitempty"`
	// Whether to persist the ML use assignment to data item system labels.
	PersistMlUseAssignment bool `protobuf:"varint,11,opt,name=persist_ml_use_assignment,json=persistMlUseAssignment,proto3" json:"persist_ml_use_assignment,omitempty"`
}

func (x *InputDataConfig) Reset() {
	*x = InputDataConfig{}
	mi := &file_google_cloud_aiplatform_v1beta1_training_pipeline_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *InputDataConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InputDataConfig) ProtoMessage() {}

func (x *InputDataConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_training_pipeline_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InputDataConfig.ProtoReflect.Descriptor instead.
func (*InputDataConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_training_pipeline_proto_rawDescGZIP(), []int{1}
}

func (m *InputDataConfig) GetSplit() isInputDataConfig_Split {
	if m != nil {
		return m.Split
	}
	return nil
}

func (x *InputDataConfig) GetFractionSplit() *FractionSplit {
	if x, ok := x.GetSplit().(*InputDataConfig_FractionSplit); ok {
		return x.FractionSplit
	}
	return nil
}

func (x *InputDataConfig) GetFilterSplit() *FilterSplit {
	if x, ok := x.GetSplit().(*InputDataConfig_FilterSplit); ok {
		return x.FilterSplit
	}
	return nil
}

func (x *InputDataConfig) GetPredefinedSplit() *PredefinedSplit {
	if x, ok := x.GetSplit().(*InputDataConfig_PredefinedSplit); ok {
		return x.PredefinedSplit
	}
	return nil
}

func (x *InputDataConfig) GetTimestampSplit() *TimestampSplit {
	if x, ok := x.GetSplit().(*InputDataConfig_TimestampSplit); ok {
		return x.TimestampSplit
	}
	return nil
}

func (x *InputDataConfig) GetStratifiedSplit() *StratifiedSplit {
	if x, ok := x.GetSplit().(*InputDataConfig_StratifiedSplit); ok {
		return x.StratifiedSplit
	}
	return nil
}

func (m *InputDataConfig) GetDestination() isInputDataConfig_Destination {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (x *InputDataConfig) GetGcsDestination() *GcsDestination {
	if x, ok := x.GetDestination().(*InputDataConfig_GcsDestination); ok {
		return x.GcsDestination
	}
	return nil
}

func (x *InputDataConfig) GetBigqueryDestination() *BigQueryDestination {
	if x, ok := x.GetDestination().(*InputDataConfig_BigqueryDestination); ok {
		return x.BigqueryDestination
	}
	return nil
}

func (x *InputDataConfig) GetDatasetId() string {
	if x != nil {
		return x.DatasetId
	}
	return ""
}

func (x *InputDataConfig) GetAnnotationsFilter() string {
	if x != nil {
		return x.AnnotationsFilter
	}
	return ""
}

func (x *InputDataConfig) GetAnnotationSchemaUri() string {
	if x != nil {
		return x.AnnotationSchemaUri
	}
	return ""
}

func (x *InputDataConfig) GetSavedQueryId() string {
	if x != nil {
		return x.SavedQueryId
	}
	return ""
}

func (x *InputDataConfig) GetPersistMlUseAssignment() bool {
	if x != nil {
		return x.PersistMlUseAssignment
	}
	return false
}

type isInputDataConfig_Split interface {
	isInputDataConfig_Split()
}

type InputDataConfig_FractionSplit struct {
	// Split based on fractions defining the size of each set.
	FractionSplit *FractionSplit `protobuf:"bytes,2,opt,name=fraction_split,json=fractionSplit,proto3,oneof"`
}

type InputDataConfig_FilterSplit struct {
	// Split based on the provided filters for each set.
	FilterSplit *FilterSplit `protobuf:"bytes,3,opt,name=filter_split,json=filterSplit,proto3,oneof"`
}

type InputDataConfig_PredefinedSplit struct {
	// Supported only for tabular Datasets.
	//
	// Split based on a predefined key.
	PredefinedSplit *PredefinedSplit `protobuf:"bytes,4,opt,name=predefined_split,json=predefinedSplit,proto3,oneof"`
}

type InputDataConfig_TimestampSplit struct {
	// Supported only for tabular Datasets.
	//
	// Split based on the timestamp of the input data pieces.
	TimestampSplit *TimestampSplit `protobuf:"bytes,5,opt,name=timestamp_split,json=timestampSplit,proto3,oneof"`
}

type InputDataConfig_StratifiedSplit struct {
	// Supported only for tabular Datasets.
	//
	// Split based on the distribution of the specified column.
	StratifiedSplit *StratifiedSplit `protobuf:"bytes,12,opt,name=stratified_split,json=stratifiedSplit,proto3,oneof"`
}

func (*InputDataConfig_FractionSplit) isInputDataConfig_Split() {}

func (*InputDataConfig_FilterSplit) isInputDataConfig_Split() {}

func (*InputDataConfig_PredefinedSplit) isInputDataConfig_Split() {}

func (*InputDataConfig_TimestampSplit) isInputDataConfig_Split() {}

func (*InputDataConfig_StratifiedSplit) isInputDataConfig_Split() {}

type isInputDataConfig_Destination interface {
	isInputDataConfig_Destination()
}

type InputDataConfig_GcsDestination struct {
	// The Cloud Storage location where the training data is to be
	// written to. In the given directory a new directory is created with
	// name:
	// `dataset-<dataset-id>-<annotation-type>-<timestamp-of-training-call>`
	// where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format.
	// All training input data is written into that directory.
	//
	// The Vertex AI environment variables representing Cloud Storage
	// data URIs are represented in the Cloud Storage wildcard
	// format to support sharded data. e.g.: "gs://.../training-*.jsonl"
	//
	// * AIP_DATA_FORMAT = "jsonl" for non-tabular data, "csv" for tabular data
	// * AIP_TRAINING_DATA_URI =
	// "gcs_destination/dataset-<dataset-id>-<annotation-type>-<time>/training-*.${AIP_DATA_FORMAT}"
	//
	// * AIP_VALIDATION_DATA_URI =
	// "gcs_destination/dataset-<dataset-id>-<annotation-type>-<time>/validation-*.${AIP_DATA_FORMAT}"
	//
	// * AIP_TEST_DATA_URI =
	// "gcs_destination/dataset-<dataset-id>-<annotation-type>-<time>/test-*.${AIP_DATA_FORMAT}"
	GcsDestination *GcsDestination `protobuf:"bytes,8,opt,name=gcs_destination,json=gcsDestination,proto3,oneof"`
}

type InputDataConfig_BigqueryDestination struct {
	// Only applicable to custom training with tabular Dataset with BigQuery
	// source.
	//
	// The BigQuery project location where the training data is to be written
	// to. In the given project a new dataset is created with name
	// `dataset_<dataset-id>_<annotation-type>_<timestamp-of-training-call>`
	// where timestamp is in YYYY_MM_DDThh_mm_ss_sssZ format. All training
	// input data is written into that dataset. In the dataset three
	// tables are created, `training`, `validation` and `test`.
	//
	// * AIP_DATA_FORMAT = "bigquery".
	// * AIP_TRAINING_DATA_URI  =
	// "bigquery_destination.dataset_<dataset-id>_<annotation-type>_<time>.training"
	//
	// * AIP_VALIDATION_DATA_URI =
	// "bigquery_destination.dataset_<dataset-id>_<annotation-type>_<time>.validation"
	//
	// * AIP_TEST_DATA_URI =
	// "bigquery_destination.dataset_<dataset-id>_<annotation-type>_<time>.test"
	BigqueryDestination *BigQueryDestination `protobuf:"bytes,10,opt,name=bigquery_destination,json=bigqueryDestination,proto3,oneof"`
}

func (*InputDataConfig_GcsDestination) isInputDataConfig_Destination() {}

func (*InputDataConfig_BigqueryDestination) isInputDataConfig_Destination() {}

// Assigns the input data to training, validation, and test sets as per the
// given fractions. Any of `training_fraction`, `validation_fraction` and
// `test_fraction` may optionally be provided, they must sum to up to 1. If the
// provided ones sum to less than 1, the remainder is assigned to sets as
// decided by Vertex AI. If none of the fractions are set, by default roughly
// 80% of data is used for training, 10% for validation, and 10% for test.
type FractionSplit struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The fraction of the input data that is to be used to train the Model.
	TrainingFraction float64 `protobuf:"fixed64,1,opt,name=training_fraction,json=trainingFraction,proto3" json:"training_fraction,omitempty"`
	// The fraction of the input data that is to be used to validate the Model.
	ValidationFraction float64 `protobuf:"fixed64,2,opt,name=validation_fraction,json=validationFraction,proto3" json:"validation_fraction,omitempty"`
	// The fraction of the input data that is to be used to evaluate the Model.
	TestFraction float64 `protobuf:"fixed64,3,opt,name=test_fraction,json=testFraction,proto3" json:"test_fraction,omitempty"`
}

func (x *FractionSplit) Reset() {
	*x = FractionSplit{}
	mi := &file_google_cloud_aiplatform_v1beta1_training_pipeline_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FractionSplit) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FractionSplit) ProtoMessage() {}

func (x *FractionSplit) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_training_pipeline_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FractionSplit.ProtoReflect.Descriptor instead.
func (*FractionSplit) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_training_pipeline_proto_rawDescGZIP(), []int{2}
}

func (x *FractionSplit) GetTrainingFraction() float64 {
	if x != nil {
		return x.TrainingFraction
	}
	return 0
}

func (x *FractionSplit) GetValidationFraction() float64 {
	if x != nil {
		return x.ValidationFraction
	}
	return 0
}

func (x *FractionSplit) GetTestFraction() float64 {
	if x != nil {
		return x.TestFraction
	}
	return 0
}

// Assigns input data to training, validation, and test sets based on the given
// filters, data pieces not matched by any filter are ignored. Currently only
// supported for Datasets containing DataItems.
// If any of the filters in this message are to match nothing, then they can be
// set as '-' (the minus sign).
//
// Supported only for unstructured Datasets.
type FilterSplit struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A filter on DataItems of the Dataset. DataItems that match
	// this filter are used to train the Model. A filter with same syntax
	// as the one used in
	// [DatasetService.ListDataItems][google.cloud.aiplatform.v1beta1.DatasetService.ListDataItems]
	// may be used. If a single DataItem is matched by more than one of the
	// FilterSplit filters, then it is assigned to the first set that applies to
	// it in the training, validation, test order.
	TrainingFilter string `protobuf:"bytes,1,opt,name=training_filter,json=trainingFilter,proto3" json:"training_filter,omitempty"`
	// Required. A filter on DataItems of the Dataset. DataItems that match
	// this filter are used to validate the Model. A filter with same syntax
	// as the one used in
	// [DatasetService.ListDataItems][google.cloud.aiplatform.v1beta1.DatasetService.ListDataItems]
	// may be used. If a single DataItem is matched by more than one of the
	// FilterSplit filters, then it is assigned to the first set that applies to
	// it in the training, validation, test order.
	ValidationFilter string `protobuf:"bytes,2,opt,name=validation_filter,json=validationFilter,proto3" json:"validation_filter,omitempty"`
	// Required. A filter on DataItems of the Dataset. DataItems that match
	// this filter are used to test the Model. A filter with same syntax
	// as the one used in
	// [DatasetService.ListDataItems][google.cloud.aiplatform.v1beta1.DatasetService.ListDataItems]
	// may be used. If a single DataItem is matched by more than one of the
	// FilterSplit filters, then it is assigned to the first set that applies to
	// it in the training, validation, test order.
	TestFilter string `protobuf:"bytes,3,opt,name=test_filter,json=testFilter,proto3" json:"test_filter,omitempty"`
}

func (x *FilterSplit) Reset() {
	*x = FilterSplit{}
	mi := &file_google_cloud_aiplatform_v1beta1_training_pipeline_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FilterSplit) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FilterSplit) ProtoMessage() {}

func (x *FilterSplit) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_training_pipeline_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FilterSplit.ProtoReflect.Descriptor instead.
func (*FilterSplit) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_training_pipeline_proto_rawDescGZIP(), []int{3}
}

func (x *FilterSplit) GetTrainingFilter() string {
	if x != nil {
		return x.TrainingFilter
	}
	return ""
}

func (x *FilterSplit) GetValidationFilter() string {
	if x != nil {
		return x.ValidationFilter
	}
	return ""
}

func (x *FilterSplit) GetTestFilter() string {
	if x != nil {
		return x.TestFilter
	}
	return ""
}

// Assigns input data to training, validation, and test sets based on the
// value of a provided key.
//
// Supported only for tabular Datasets.
type PredefinedSplit struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The key is a name of one of the Dataset's data columns.
	// The value of the key (either the label's value or value in the column)
	// must be one of {`training`, `validation`, `test`}, and it defines to which
	// set the given piece of data is assigned. If for a piece of data the key
	// is not present or has an invalid value, that piece is ignored by the
	// pipeline.
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
}

func (x *PredefinedSplit) Reset() {
	*x = PredefinedSplit{}
	mi := &file_google_cloud_aiplatform_v1beta1_training_pipeline_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PredefinedSplit) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PredefinedSplit) ProtoMessage() {}

func (x *PredefinedSplit) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_training_pipeline_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PredefinedSplit.ProtoReflect.Descriptor instead.
func (*PredefinedSplit) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_training_pipeline_proto_rawDescGZIP(), []int{4}
}

func (x *PredefinedSplit) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

// Assigns input data to training, validation, and test sets based on a
// provided timestamps. The youngest data pieces are assigned to training set,
// next to validation set, and the oldest to the test set.
//
// Supported only for tabular Datasets.
type TimestampSplit struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The fraction of the input data that is to be used to train the Model.
	TrainingFraction float64 `protobuf:"fixed64,1,opt,name=training_fraction,json=trainingFraction,proto3" json:"training_fraction,omitempty"`
	// The fraction of the input data that is to be used to validate the Model.
	ValidationFraction float64 `protobuf:"fixed64,2,opt,name=validation_fraction,json=validationFraction,proto3" json:"validation_fraction,omitempty"`
	// The fraction of the input data that is to be used to evaluate the Model.
	TestFraction float64 `protobuf:"fixed64,3,opt,name=test_fraction,json=testFraction,proto3" json:"test_fraction,omitempty"`
	// Required. The key is a name of one of the Dataset's data columns.
	// The values of the key (the values in the column) must be in RFC 3339
	// `date-time` format, where `time-offset` = `"Z"`
	// (e.g. 1985-04-12T23:20:50.52Z). If for a piece of data the key is not
	// present or has an invalid value, that piece is ignored by the pipeline.
	Key string `protobuf:"bytes,4,opt,name=key,proto3" json:"key,omitempty"`
}

func (x *TimestampSplit) Reset() {
	*x = TimestampSplit{}
	mi := &file_google_cloud_aiplatform_v1beta1_training_pipeline_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TimestampSplit) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TimestampSplit) ProtoMessage() {}

func (x *TimestampSplit) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_training_pipeline_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TimestampSplit.ProtoReflect.Descriptor instead.
func (*TimestampSplit) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_training_pipeline_proto_rawDescGZIP(), []int{5}
}

func (x *TimestampSplit) GetTrainingFraction() float64 {
	if x != nil {
		return x.TrainingFraction
	}
	return 0
}

func (x *TimestampSplit) GetValidationFraction() float64 {
	if x != nil {
		return x.ValidationFraction
	}
	return 0
}

func (x *TimestampSplit) GetTestFraction() float64 {
	if x != nil {
		return x.TestFraction
	}
	return 0
}

func (x *TimestampSplit) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

// Assigns input data to the training, validation, and test sets so that the
// distribution of values found in the categorical column (as specified by the
// `key` field) is mirrored within each split. The fraction values determine
// the relative sizes of the splits.
//
// For example, if the specified column has three values, with 50% of the rows
// having value "A", 25% value "B", and 25% value "C", and the split fractions
// are specified as 80/10/10, then the training set will constitute 80% of the
// training data, with about 50% of the training set rows having the value "A"
// for the specified column, about 25% having the value "B", and about 25%
// having the value "C".
//
// Only the top 500 occurring values are used; any values not in the top
// 500 values are randomly assigned to a split. If less than three rows contain
// a specific value, those rows are randomly assigned.
//
// Supported only for tabular Datasets.
type StratifiedSplit struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The fraction of the input data that is to be used to train the Model.
	TrainingFraction float64 `protobuf:"fixed64,1,opt,name=training_fraction,json=trainingFraction,proto3" json:"training_fraction,omitempty"`
	// The fraction of the input data that is to be used to validate the Model.
	ValidationFraction float64 `protobuf:"fixed64,2,opt,name=validation_fraction,json=validationFraction,proto3" json:"validation_fraction,omitempty"`
	// The fraction of the input data that is to be used to evaluate the Model.
	TestFraction float64 `protobuf:"fixed64,3,opt,name=test_fraction,json=testFraction,proto3" json:"test_fraction,omitempty"`
	// Required. The key is a name of one of the Dataset's data columns.
	// The key provided must be for a categorical column.
	Key string `protobuf:"bytes,4,opt,name=key,proto3" json:"key,omitempty"`
}

func (x *StratifiedSplit) Reset() {
	*x = StratifiedSplit{}
	mi := &file_google_cloud_aiplatform_v1beta1_training_pipeline_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StratifiedSplit) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StratifiedSplit) ProtoMessage() {}

func (x *StratifiedSplit) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_training_pipeline_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StratifiedSplit.ProtoReflect.Descriptor instead.
func (*StratifiedSplit) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_training_pipeline_proto_rawDescGZIP(), []int{6}
}

func (x *StratifiedSplit) GetTrainingFraction() float64 {
	if x != nil {
		return x.TrainingFraction
	}
	return 0
}

func (x *StratifiedSplit) GetValidationFraction() float64 {
	if x != nil {
		return x.ValidationFraction
	}
	return 0
}

func (x *StratifiedSplit) GetTestFraction() float64 {
	if x != nil {
		return x.TestFraction
	}
	return 0
}

func (x *StratifiedSplit) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

var File_google_cloud_aiplatform_v1beta1_training_pipeline_proto protoreflect.FileDescriptor

var file_google_cloud_aiplatform_v1beta1_training_pipeline_proto_rawDesc = []byte{
	0x0a, 0x37, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x70, 0x69, 0x70, 0x65, 0x6c,
	0x69, 0x6e, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68,
	0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x35, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x28, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x69,
	0x6f, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x34, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75,
	0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0x90, 0x0a, 0x0a, 0x10, 0x54, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x50,
	0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x5c, 0x0a, 0x11, 0x69, 0x6e, 0x70, 0x75,
	0x74, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x44, 0x61, 0x74, 0x61, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x44, 0x61, 0x74, 0x61,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3d, 0x0a, 0x18, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69,
	0x6e, 0x67, 0x5f, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x16, 0x74,
	0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x54, 0x61, 0x73, 0x6b, 0x44, 0x65, 0x66, 0x69, 0x6e,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4d, 0x0a, 0x14, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e,
	0x67, 0x5f, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x12, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x54, 0x61, 0x73, 0x6b, 0x49, 0x6e,
	0x70, 0x75, 0x74, 0x73, 0x12, 0x51, 0x0a, 0x16, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67,
	0x5f, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x14, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x54, 0x61, 0x73, 0x6b, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x4e, 0x0a, 0x0f, 0x6d, 0x6f, 0x64, 0x65, 0x6c,
	0x5f, 0x74, 0x6f, 0x5f, 0x75, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x0d, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x54,
	0x6f, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x1e, 0x0a, 0x08, 0x6d, 0x6f, 0x64, 0x65, 0x6c,
	0x5f, 0x69, 0x64, 0x18, 0x16, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07,
	0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x49, 0x64, 0x12, 0x26, 0x0a, 0x0c, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x15, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12,
	0x49, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x2d, 0x0a, 0x05, 0x65, 0x72,
	0x72, 0x6f, 0x72, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3e, 0x0a, 0x0a, 0x73,
	0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65,
	0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07,
	0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x55, 0x0a, 0x06, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x18, 0x0f, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x69,
	0x6e, 0x69, 0x6e, 0x67, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x12, 0x58, 0x0a, 0x0f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73,
	0x70, 0x65, 0x63, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x6e, 0x63, 0x72,
	0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x52, 0x0e, 0x65, 0x6e, 0x63, 0x72,
	0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x7e, 0xea, 0x41, 0x7b, 0x0a, 0x2a, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x50, 0x69,
	0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x12, 0x4d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f,
	0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65,
	0x73, 0x2f, 0x7b, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x70, 0x69, 0x70, 0x65,
	0x6c, 0x69, 0x6e, 0x65, 0x7d, 0x22, 0x9e, 0x07, 0x0a, 0x0f, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x44,
	0x61, 0x74, 0x61, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x57, 0x0a, 0x0e, 0x66, 0x72, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x6c, 0x69, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x46, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x6c, 0x69,
	0x74, 0x48, 0x00, 0x52, 0x0d, 0x66, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x6c,
	0x69, 0x74, 0x12, 0x51, 0x0a, 0x0c, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x5f, 0x73, 0x70, 0x6c,
	0x69, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x46, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x53, 0x70, 0x6c, 0x69, 0x74, 0x48, 0x00, 0x52, 0x0b, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x53, 0x70, 0x6c, 0x69, 0x74, 0x12, 0x5d, 0x0a, 0x10, 0x70, 0x72, 0x65, 0x64, 0x65, 0x66, 0x69,
	0x6e, 0x65, 0x64, 0x5f, 0x73, 0x70, 0x6c, 0x69, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x50, 0x72, 0x65, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x64, 0x53, 0x70, 0x6c, 0x69,
	0x74, 0x48, 0x00, 0x52, 0x0f, 0x70, 0x72, 0x65, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x64, 0x53,
	0x70, 0x6c, 0x69, 0x74, 0x12, 0x5a, 0x0a, 0x0f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x5f, 0x73, 0x70, 0x6c, 0x69, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x53, 0x70, 0x6c, 0x69, 0x74, 0x48, 0x00,
	0x52, 0x0e, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x53, 0x70, 0x6c, 0x69, 0x74,
	0x12, 0x5d, 0x0a, 0x10, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x66, 0x69, 0x65, 0x64, 0x5f, 0x73,
	0x70, 0x6c, 0x69, 0x74, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x74, 0x72,
	0x61, 0x74, 0x69, 0x66, 0x69, 0x65, 0x64, 0x53, 0x70, 0x6c, 0x69, 0x74, 0x48, 0x00, 0x52, 0x0f,
	0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x66, 0x69, 0x65, 0x64, 0x53, 0x70, 0x6c, 0x69, 0x74, 0x12,
	0x5a, 0x0a, 0x0f, 0x67, 0x63, 0x73, 0x5f, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x63, 0x73, 0x44, 0x65,
	0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x01, 0x52, 0x0e, 0x67, 0x63, 0x73,
	0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x69, 0x0a, 0x14, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x42, 0x69, 0x67, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48,
	0x01, 0x52, 0x13, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x44, 0x65, 0x73, 0x74, 0x69,
	0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x22, 0x0a, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65,
	0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x09, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x49, 0x64, 0x12, 0x2d, 0x0a, 0x12, 0x61, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x32, 0x0a, 0x15, 0x61, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x5f, 0x75,
	0x72, 0x69, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x55, 0x72, 0x69, 0x12, 0x24, 0x0a,
	0x0e, 0x73, 0x61, 0x76, 0x65, 0x64, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x69, 0x64, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x73, 0x61, 0x76, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72,
	0x79, 0x49, 0x64, 0x12, 0x39, 0x0a, 0x19, 0x70, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x5f, 0x6d,
	0x6c, 0x5f, 0x75, 0x73, 0x65, 0x5f, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74,
	0x18, 0x0b, 0x20, 0x01, 0x28, 0x08, 0x52, 0x16, 0x70, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x4d,
	0x6c, 0x55, 0x73, 0x65, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x07,
	0x0a, 0x05, 0x73, 0x70, 0x6c, 0x69, 0x74, 0x42, 0x0d, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69,
	0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x92, 0x01, 0x0a, 0x0d, 0x46, 0x72, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x53, 0x70, 0x6c, 0x69, 0x74, 0x12, 0x2b, 0x0a, 0x11, 0x74, 0x72, 0x61, 0x69,
	0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x66, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x01, 0x52, 0x10, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x46, 0x72, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2f, 0x0a, 0x13, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x66, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x01, 0x52, 0x12, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x72,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x23, 0x0a, 0x0d, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x66,
	0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x01, 0x52, 0x0c, 0x74,
	0x65, 0x73, 0x74, 0x46, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x93, 0x01, 0x0a, 0x0b,
	0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x53, 0x70, 0x6c, 0x69, 0x74, 0x12, 0x2c, 0x0a, 0x0f, 0x74,
	0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x74, 0x72, 0x61, 0x69, 0x6e,
	0x69, 0x6e, 0x67, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x30, 0x0a, 0x11, 0x76, 0x61, 0x6c,
	0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10, 0x76, 0x61, 0x6c, 0x69, 0x64,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x24, 0x0a, 0x0b, 0x74,
	0x65, 0x73, 0x74, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x74, 0x65, 0x73, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x22, 0x28, 0x0a, 0x0f, 0x50, 0x72, 0x65, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x64, 0x53,
	0x70, 0x6c, 0x69, 0x74, 0x12, 0x15, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x22, 0xaa, 0x01, 0x0a, 0x0e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x53, 0x70, 0x6c, 0x69, 0x74, 0x12, 0x2b,
	0x0a, 0x11, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x66, 0x72, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x01, 0x52, 0x10, 0x74, 0x72, 0x61, 0x69, 0x6e,
	0x69, 0x6e, 0x67, 0x46, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2f, 0x0a, 0x13, 0x76,
	0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x66, 0x72, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x52, 0x12, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x46, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x23, 0x0a, 0x0d,
	0x74, 0x65, 0x73, 0x74, 0x5f, 0x66, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x01, 0x52, 0x0c, 0x74, 0x65, 0x73, 0x74, 0x46, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x15, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x22, 0xab, 0x01, 0x0a, 0x0f, 0x53, 0x74, 0x72,
	0x61, 0x74, 0x69, 0x66, 0x69, 0x65, 0x64, 0x53, 0x70, 0x6c, 0x69, 0x74, 0x12, 0x2b, 0x0a, 0x11,
	0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x66, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x01, 0x52, 0x10, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e,
	0x67, 0x46, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2f, 0x0a, 0x13, 0x76, 0x61, 0x6c,
	0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x66, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x52, 0x12, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x46, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x23, 0x0a, 0x0d, 0x74, 0x65,
	0x73, 0x74, 0x5f, 0x66, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x01, 0x52, 0x0c, 0x74, 0x65, 0x73, 0x74, 0x46, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x15, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x42, 0xec, 0x01, 0x0a, 0x23, 0x63, 0x6f, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x42, 0x15,
	0x54, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x43, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x70, 0x62, 0x3b,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x70, 0x62, 0xaa, 0x02, 0x1f, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x41, 0x49, 0x50, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x56, 0x31, 0x42, 0x65, 0x74, 0x61, 0x31, 0xca, 0x02,
	0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x41, 0x49,
	0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x5c, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0xea, 0x02, 0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x3a, 0x3a, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x3a, 0x3a, 0x56, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_aiplatform_v1beta1_training_pipeline_proto_rawDescOnce sync.Once
	file_google_cloud_aiplatform_v1beta1_training_pipeline_proto_rawDescData = file_google_cloud_aiplatform_v1beta1_training_pipeline_proto_rawDesc
)

func file_google_cloud_aiplatform_v1beta1_training_pipeline_proto_rawDescGZIP() []byte {
	file_google_cloud_aiplatform_v1beta1_training_pipeline_proto_rawDescOnce.Do(func() {
		file_google_cloud_aiplatform_v1beta1_training_pipeline_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_aiplatform_v1beta1_training_pipeline_proto_rawDescData)
	})
	return file_google_cloud_aiplatform_v1beta1_training_pipeline_proto_rawDescData
}

var file_google_cloud_aiplatform_v1beta1_training_pipeline_proto_msgTypes = make([]protoimpl.MessageInfo, 8)
var file_google_cloud_aiplatform_v1beta1_training_pipeline_proto_goTypes = []any{
	(*TrainingPipeline)(nil),      // 0: google.cloud.aiplatform.v1beta1.TrainingPipeline
	(*InputDataConfig)(nil),       // 1: google.cloud.aiplatform.v1beta1.InputDataConfig
	(*FractionSplit)(nil),         // 2: google.cloud.aiplatform.v1beta1.FractionSplit
	(*FilterSplit)(nil),           // 3: google.cloud.aiplatform.v1beta1.FilterSplit
	(*PredefinedSplit)(nil),       // 4: google.cloud.aiplatform.v1beta1.PredefinedSplit
	(*TimestampSplit)(nil),        // 5: google.cloud.aiplatform.v1beta1.TimestampSplit
	(*StratifiedSplit)(nil),       // 6: google.cloud.aiplatform.v1beta1.StratifiedSplit
	nil,                           // 7: google.cloud.aiplatform.v1beta1.TrainingPipeline.LabelsEntry
	(*structpb.Value)(nil),        // 8: google.protobuf.Value
	(*Model)(nil),                 // 9: google.cloud.aiplatform.v1beta1.Model
	(PipelineState)(0),            // 10: google.cloud.aiplatform.v1beta1.PipelineState
	(*status.Status)(nil),         // 11: google.rpc.Status
	(*timestamppb.Timestamp)(nil), // 12: google.protobuf.Timestamp
	(*EncryptionSpec)(nil),        // 13: google.cloud.aiplatform.v1beta1.EncryptionSpec
	(*GcsDestination)(nil),        // 14: google.cloud.aiplatform.v1beta1.GcsDestination
	(*BigQueryDestination)(nil),   // 15: google.cloud.aiplatform.v1beta1.BigQueryDestination
}
var file_google_cloud_aiplatform_v1beta1_training_pipeline_proto_depIdxs = []int32{
	1,  // 0: google.cloud.aiplatform.v1beta1.TrainingPipeline.input_data_config:type_name -> google.cloud.aiplatform.v1beta1.InputDataConfig
	8,  // 1: google.cloud.aiplatform.v1beta1.TrainingPipeline.training_task_inputs:type_name -> google.protobuf.Value
	8,  // 2: google.cloud.aiplatform.v1beta1.TrainingPipeline.training_task_metadata:type_name -> google.protobuf.Value
	9,  // 3: google.cloud.aiplatform.v1beta1.TrainingPipeline.model_to_upload:type_name -> google.cloud.aiplatform.v1beta1.Model
	10, // 4: google.cloud.aiplatform.v1beta1.TrainingPipeline.state:type_name -> google.cloud.aiplatform.v1beta1.PipelineState
	11, // 5: google.cloud.aiplatform.v1beta1.TrainingPipeline.error:type_name -> google.rpc.Status
	12, // 6: google.cloud.aiplatform.v1beta1.TrainingPipeline.create_time:type_name -> google.protobuf.Timestamp
	12, // 7: google.cloud.aiplatform.v1beta1.TrainingPipeline.start_time:type_name -> google.protobuf.Timestamp
	12, // 8: google.cloud.aiplatform.v1beta1.TrainingPipeline.end_time:type_name -> google.protobuf.Timestamp
	12, // 9: google.cloud.aiplatform.v1beta1.TrainingPipeline.update_time:type_name -> google.protobuf.Timestamp
	7,  // 10: google.cloud.aiplatform.v1beta1.TrainingPipeline.labels:type_name -> google.cloud.aiplatform.v1beta1.TrainingPipeline.LabelsEntry
	13, // 11: google.cloud.aiplatform.v1beta1.TrainingPipeline.encryption_spec:type_name -> google.cloud.aiplatform.v1beta1.EncryptionSpec
	2,  // 12: google.cloud.aiplatform.v1beta1.InputDataConfig.fraction_split:type_name -> google.cloud.aiplatform.v1beta1.FractionSplit
	3,  // 13: google.cloud.aiplatform.v1beta1.InputDataConfig.filter_split:type_name -> google.cloud.aiplatform.v1beta1.FilterSplit
	4,  // 14: google.cloud.aiplatform.v1beta1.InputDataConfig.predefined_split:type_name -> google.cloud.aiplatform.v1beta1.PredefinedSplit
	5,  // 15: google.cloud.aiplatform.v1beta1.InputDataConfig.timestamp_split:type_name -> google.cloud.aiplatform.v1beta1.TimestampSplit
	6,  // 16: google.cloud.aiplatform.v1beta1.InputDataConfig.stratified_split:type_name -> google.cloud.aiplatform.v1beta1.StratifiedSplit
	14, // 17: google.cloud.aiplatform.v1beta1.InputDataConfig.gcs_destination:type_name -> google.cloud.aiplatform.v1beta1.GcsDestination
	15, // 18: google.cloud.aiplatform.v1beta1.InputDataConfig.bigquery_destination:type_name -> google.cloud.aiplatform.v1beta1.BigQueryDestination
	19, // [19:19] is the sub-list for method output_type
	19, // [19:19] is the sub-list for method input_type
	19, // [19:19] is the sub-list for extension type_name
	19, // [19:19] is the sub-list for extension extendee
	0,  // [0:19] is the sub-list for field type_name
}

func init() { file_google_cloud_aiplatform_v1beta1_training_pipeline_proto_init() }
func file_google_cloud_aiplatform_v1beta1_training_pipeline_proto_init() {
	if File_google_cloud_aiplatform_v1beta1_training_pipeline_proto != nil {
		return
	}
	file_google_cloud_aiplatform_v1beta1_encryption_spec_proto_init()
	file_google_cloud_aiplatform_v1beta1_io_proto_init()
	file_google_cloud_aiplatform_v1beta1_model_proto_init()
	file_google_cloud_aiplatform_v1beta1_pipeline_state_proto_init()
	file_google_cloud_aiplatform_v1beta1_training_pipeline_proto_msgTypes[1].OneofWrappers = []any{
		(*InputDataConfig_FractionSplit)(nil),
		(*InputDataConfig_FilterSplit)(nil),
		(*InputDataConfig_PredefinedSplit)(nil),
		(*InputDataConfig_TimestampSplit)(nil),
		(*InputDataConfig_StratifiedSplit)(nil),
		(*InputDataConfig_GcsDestination)(nil),
		(*InputDataConfig_BigqueryDestination)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_aiplatform_v1beta1_training_pipeline_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   8,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_aiplatform_v1beta1_training_pipeline_proto_goTypes,
		DependencyIndexes: file_google_cloud_aiplatform_v1beta1_training_pipeline_proto_depIdxs,
		MessageInfos:      file_google_cloud_aiplatform_v1beta1_training_pipeline_proto_msgTypes,
	}.Build()
	File_google_cloud_aiplatform_v1beta1_training_pipeline_proto = out.File
	file_google_cloud_aiplatform_v1beta1_training_pipeline_proto_rawDesc = nil
	file_google_cloud_aiplatform_v1beta1_training_pipeline_proto_goTypes = nil
	file_google_cloud_aiplatform_v1beta1_training_pipeline_proto_depIdxs = nil
}
