// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

package aiplatform

import (
	"bytes"
	"context"
	"fmt"
	"log/slog"
	"math"
	"net/http"
	"net/url"

	aiplatformpb "cloud.google.com/go/aiplatform/apiv1beta1/aiplatformpb"
	iampb "cloud.google.com/go/iam/apiv1/iampb"
	"cloud.google.com/go/longrunning"
	lroauto "cloud.google.com/go/longrunning/autogen"
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	gax "github.com/googleapis/gax-go/v2"
	"google.golang.org/api/iterator"
	"google.golang.org/api/option"
	"google.golang.org/api/option/internaloption"
	gtransport "google.golang.org/api/transport/grpc"
	httptransport "google.golang.org/api/transport/http"
	locationpb "google.golang.org/genproto/googleapis/cloud/location"
	"google.golang.org/grpc"
	"google.golang.org/protobuf/encoding/protojson"
	"google.golang.org/protobuf/proto"
)

var newNotebookClientHook clientHook

// NotebookCallOptions contains the retry settings for each method of NotebookClient.
type NotebookCallOptions struct {
	CreateNotebookRuntimeTemplate []gax.CallOption
	GetNotebookRuntimeTemplate    []gax.CallOption
	ListNotebookRuntimeTemplates  []gax.CallOption
	DeleteNotebookRuntimeTemplate []gax.CallOption
	UpdateNotebookRuntimeTemplate []gax.CallOption
	AssignNotebookRuntime         []gax.CallOption
	GetNotebookRuntime            []gax.CallOption
	ListNotebookRuntimes          []gax.CallOption
	DeleteNotebookRuntime         []gax.CallOption
	UpgradeNotebookRuntime        []gax.CallOption
	StartNotebookRuntime          []gax.CallOption
	StopNotebookRuntime           []gax.CallOption
	CreateNotebookExecutionJob    []gax.CallOption
	GetNotebookExecutionJob       []gax.CallOption
	ListNotebookExecutionJobs     []gax.CallOption
	DeleteNotebookExecutionJob    []gax.CallOption
	GetLocation                   []gax.CallOption
	ListLocations                 []gax.CallOption
	GetIamPolicy                  []gax.CallOption
	SetIamPolicy                  []gax.CallOption
	TestIamPermissions            []gax.CallOption
	CancelOperation               []gax.CallOption
	DeleteOperation               []gax.CallOption
	GetOperation                  []gax.CallOption
	ListOperations                []gax.CallOption
	WaitOperation                 []gax.CallOption
}

func defaultNotebookGRPCClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("aiplatform.googleapis.com:443"),
		internaloption.WithDefaultEndpointTemplate("aiplatform.UNIVERSE_DOMAIN:443"),
		internaloption.WithDefaultMTLSEndpoint("aiplatform.mtls.googleapis.com:443"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://aiplatform.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableJwtWithScope(),
		internaloption.EnableNewAuthLibrary(),
		option.WithGRPCDialOption(grpc.WithDefaultCallOptions(
			grpc.MaxCallRecvMsgSize(math.MaxInt32))),
	}
}

func defaultNotebookCallOptions() *NotebookCallOptions {
	return &NotebookCallOptions{
		CreateNotebookRuntimeTemplate: []gax.CallOption{},
		GetNotebookRuntimeTemplate:    []gax.CallOption{},
		ListNotebookRuntimeTemplates:  []gax.CallOption{},
		DeleteNotebookRuntimeTemplate: []gax.CallOption{},
		UpdateNotebookRuntimeTemplate: []gax.CallOption{},
		AssignNotebookRuntime:         []gax.CallOption{},
		GetNotebookRuntime:            []gax.CallOption{},
		ListNotebookRuntimes:          []gax.CallOption{},
		DeleteNotebookRuntime:         []gax.CallOption{},
		UpgradeNotebookRuntime:        []gax.CallOption{},
		StartNotebookRuntime:          []gax.CallOption{},
		StopNotebookRuntime:           []gax.CallOption{},
		CreateNotebookExecutionJob:    []gax.CallOption{},
		GetNotebookExecutionJob:       []gax.CallOption{},
		ListNotebookExecutionJobs:     []gax.CallOption{},
		DeleteNotebookExecutionJob:    []gax.CallOption{},
		GetLocation:                   []gax.CallOption{},
		ListLocations:                 []gax.CallOption{},
		GetIamPolicy:                  []gax.CallOption{},
		SetIamPolicy:                  []gax.CallOption{},
		TestIamPermissions:            []gax.CallOption{},
		CancelOperation:               []gax.CallOption{},
		DeleteOperation:               []gax.CallOption{},
		GetOperation:                  []gax.CallOption{},
		ListOperations:                []gax.CallOption{},
		WaitOperation:                 []gax.CallOption{},
	}
}

func defaultNotebookRESTCallOptions() *NotebookCallOptions {
	return &NotebookCallOptions{
		CreateNotebookRuntimeTemplate: []gax.CallOption{},
		GetNotebookRuntimeTemplate:    []gax.CallOption{},
		ListNotebookRuntimeTemplates:  []gax.CallOption{},
		DeleteNotebookRuntimeTemplate: []gax.CallOption{},
		UpdateNotebookRuntimeTemplate: []gax.CallOption{},
		AssignNotebookRuntime:         []gax.CallOption{},
		GetNotebookRuntime:            []gax.CallOption{},
		ListNotebookRuntimes:          []gax.CallOption{},
		DeleteNotebookRuntime:         []gax.CallOption{},
		UpgradeNotebookRuntime:        []gax.CallOption{},
		StartNotebookRuntime:          []gax.CallOption{},
		StopNotebookRuntime:           []gax.CallOption{},
		CreateNotebookExecutionJob:    []gax.CallOption{},
		GetNotebookExecutionJob:       []gax.CallOption{},
		ListNotebookExecutionJobs:     []gax.CallOption{},
		DeleteNotebookExecutionJob:    []gax.CallOption{},
		GetLocation:                   []gax.CallOption{},
		ListLocations:                 []gax.CallOption{},
		GetIamPolicy:                  []gax.CallOption{},
		SetIamPolicy:                  []gax.CallOption{},
		TestIamPermissions:            []gax.CallOption{},
		CancelOperation:               []gax.CallOption{},
		DeleteOperation:               []gax.CallOption{},
		GetOperation:                  []gax.CallOption{},
		ListOperations:                []gax.CallOption{},
		WaitOperation:                 []gax.CallOption{},
	}
}

// internalNotebookClient is an interface that defines the methods available from Vertex AI API.
type internalNotebookClient interface {
	Close() error
	setGoogleClientInfo(...string)
	Connection() *grpc.ClientConn
	CreateNotebookRuntimeTemplate(context.Context, *aiplatformpb.CreateNotebookRuntimeTemplateRequest, ...gax.CallOption) (*CreateNotebookRuntimeTemplateOperation, error)
	CreateNotebookRuntimeTemplateOperation(name string) *CreateNotebookRuntimeTemplateOperation
	GetNotebookRuntimeTemplate(context.Context, *aiplatformpb.GetNotebookRuntimeTemplateRequest, ...gax.CallOption) (*aiplatformpb.NotebookRuntimeTemplate, error)
	ListNotebookRuntimeTemplates(context.Context, *aiplatformpb.ListNotebookRuntimeTemplatesRequest, ...gax.CallOption) *NotebookRuntimeTemplateIterator
	DeleteNotebookRuntimeTemplate(context.Context, *aiplatformpb.DeleteNotebookRuntimeTemplateRequest, ...gax.CallOption) (*DeleteNotebookRuntimeTemplateOperation, error)
	DeleteNotebookRuntimeTemplateOperation(name string) *DeleteNotebookRuntimeTemplateOperation
	UpdateNotebookRuntimeTemplate(context.Context, *aiplatformpb.UpdateNotebookRuntimeTemplateRequest, ...gax.CallOption) (*aiplatformpb.NotebookRuntimeTemplate, error)
	AssignNotebookRuntime(context.Context, *aiplatformpb.AssignNotebookRuntimeRequest, ...gax.CallOption) (*AssignNotebookRuntimeOperation, error)
	AssignNotebookRuntimeOperation(name string) *AssignNotebookRuntimeOperation
	GetNotebookRuntime(context.Context, *aiplatformpb.GetNotebookRuntimeRequest, ...gax.CallOption) (*aiplatformpb.NotebookRuntime, error)
	ListNotebookRuntimes(context.Context, *aiplatformpb.ListNotebookRuntimesRequest, ...gax.CallOption) *NotebookRuntimeIterator
	DeleteNotebookRuntime(context.Context, *aiplatformpb.DeleteNotebookRuntimeRequest, ...gax.CallOption) (*DeleteNotebookRuntimeOperation, error)
	DeleteNotebookRuntimeOperation(name string) *DeleteNotebookRuntimeOperation
	UpgradeNotebookRuntime(context.Context, *aiplatformpb.UpgradeNotebookRuntimeRequest, ...gax.CallOption) (*UpgradeNotebookRuntimeOperation, error)
	UpgradeNotebookRuntimeOperation(name string) *UpgradeNotebookRuntimeOperation
	StartNotebookRuntime(context.Context, *aiplatformpb.StartNotebookRuntimeRequest, ...gax.CallOption) (*StartNotebookRuntimeOperation, error)
	StartNotebookRuntimeOperation(name string) *StartNotebookRuntimeOperation
	StopNotebookRuntime(context.Context, *aiplatformpb.StopNotebookRuntimeRequest, ...gax.CallOption) (*StopNotebookRuntimeOperation, error)
	StopNotebookRuntimeOperation(name string) *StopNotebookRuntimeOperation
	CreateNotebookExecutionJob(context.Context, *aiplatformpb.CreateNotebookExecutionJobRequest, ...gax.CallOption) (*CreateNotebookExecutionJobOperation, error)
	CreateNotebookExecutionJobOperation(name string) *CreateNotebookExecutionJobOperation
	GetNotebookExecutionJob(context.Context, *aiplatformpb.GetNotebookExecutionJobRequest, ...gax.CallOption) (*aiplatformpb.NotebookExecutionJob, error)
	ListNotebookExecutionJobs(context.Context, *aiplatformpb.ListNotebookExecutionJobsRequest, ...gax.CallOption) *NotebookExecutionJobIterator
	DeleteNotebookExecutionJob(context.Context, *aiplatformpb.DeleteNotebookExecutionJobRequest, ...gax.CallOption) (*DeleteNotebookExecutionJobOperation, error)
	DeleteNotebookExecutionJobOperation(name string) *DeleteNotebookExecutionJobOperation
	GetLocation(context.Context, *locationpb.GetLocationRequest, ...gax.CallOption) (*locationpb.Location, error)
	ListLocations(context.Context, *locationpb.ListLocationsRequest, ...gax.CallOption) *LocationIterator
	GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest, ...gax.CallOption) (*iampb.Policy, error)
	SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest, ...gax.CallOption) (*iampb.Policy, error)
	TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest, ...gax.CallOption) (*iampb.TestIamPermissionsResponse, error)
	CancelOperation(context.Context, *longrunningpb.CancelOperationRequest, ...gax.CallOption) error
	DeleteOperation(context.Context, *longrunningpb.DeleteOperationRequest, ...gax.CallOption) error
	GetOperation(context.Context, *longrunningpb.GetOperationRequest, ...gax.CallOption) (*longrunningpb.Operation, error)
	ListOperations(context.Context, *longrunningpb.ListOperationsRequest, ...gax.CallOption) *OperationIterator
	WaitOperation(context.Context, *longrunningpb.WaitOperationRequest, ...gax.CallOption) (*longrunningpb.Operation, error)
}

// NotebookClient is a client for interacting with Vertex AI API.
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
//
// The interface for Vertex Notebook service (a.k.a. Colab on Workbench).
type NotebookClient struct {
	// The internal transport-dependent client.
	internalClient internalNotebookClient

	// The call options for this service.
	CallOptions *NotebookCallOptions

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient *lroauto.OperationsClient
}

// Wrapper methods routed to the internal client.

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *NotebookClient) Close() error {
	return c.internalClient.Close()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *NotebookClient) setGoogleClientInfo(keyval ...string) {
	c.internalClient.setGoogleClientInfo(keyval...)
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *NotebookClient) Connection() *grpc.ClientConn {
	return c.internalClient.Connection()
}

// CreateNotebookRuntimeTemplate creates a NotebookRuntimeTemplate.
func (c *NotebookClient) CreateNotebookRuntimeTemplate(ctx context.Context, req *aiplatformpb.CreateNotebookRuntimeTemplateRequest, opts ...gax.CallOption) (*CreateNotebookRuntimeTemplateOperation, error) {
	return c.internalClient.CreateNotebookRuntimeTemplate(ctx, req, opts...)
}

// CreateNotebookRuntimeTemplateOperation returns a new CreateNotebookRuntimeTemplateOperation from a given name.
// The name must be that of a previously created CreateNotebookRuntimeTemplateOperation, possibly from a different process.
func (c *NotebookClient) CreateNotebookRuntimeTemplateOperation(name string) *CreateNotebookRuntimeTemplateOperation {
	return c.internalClient.CreateNotebookRuntimeTemplateOperation(name)
}

// GetNotebookRuntimeTemplate gets a NotebookRuntimeTemplate.
func (c *NotebookClient) GetNotebookRuntimeTemplate(ctx context.Context, req *aiplatformpb.GetNotebookRuntimeTemplateRequest, opts ...gax.CallOption) (*aiplatformpb.NotebookRuntimeTemplate, error) {
	return c.internalClient.GetNotebookRuntimeTemplate(ctx, req, opts...)
}

// ListNotebookRuntimeTemplates lists NotebookRuntimeTemplates in a Location.
func (c *NotebookClient) ListNotebookRuntimeTemplates(ctx context.Context, req *aiplatformpb.ListNotebookRuntimeTemplatesRequest, opts ...gax.CallOption) *NotebookRuntimeTemplateIterator {
	return c.internalClient.ListNotebookRuntimeTemplates(ctx, req, opts...)
}

// DeleteNotebookRuntimeTemplate deletes a NotebookRuntimeTemplate.
func (c *NotebookClient) DeleteNotebookRuntimeTemplate(ctx context.Context, req *aiplatformpb.DeleteNotebookRuntimeTemplateRequest, opts ...gax.CallOption) (*DeleteNotebookRuntimeTemplateOperation, error) {
	return c.internalClient.DeleteNotebookRuntimeTemplate(ctx, req, opts...)
}

// DeleteNotebookRuntimeTemplateOperation returns a new DeleteNotebookRuntimeTemplateOperation from a given name.
// The name must be that of a previously created DeleteNotebookRuntimeTemplateOperation, possibly from a different process.
func (c *NotebookClient) DeleteNotebookRuntimeTemplateOperation(name string) *DeleteNotebookRuntimeTemplateOperation {
	return c.internalClient.DeleteNotebookRuntimeTemplateOperation(name)
}

// UpdateNotebookRuntimeTemplate updates a NotebookRuntimeTemplate.
func (c *NotebookClient) UpdateNotebookRuntimeTemplate(ctx context.Context, req *aiplatformpb.UpdateNotebookRuntimeTemplateRequest, opts ...gax.CallOption) (*aiplatformpb.NotebookRuntimeTemplate, error) {
	return c.internalClient.UpdateNotebookRuntimeTemplate(ctx, req, opts...)
}

// AssignNotebookRuntime assigns a NotebookRuntime to a user for a particular Notebook file. This
// method will either returns an existing assignment or generates a new one.
func (c *NotebookClient) AssignNotebookRuntime(ctx context.Context, req *aiplatformpb.AssignNotebookRuntimeRequest, opts ...gax.CallOption) (*AssignNotebookRuntimeOperation, error) {
	return c.internalClient.AssignNotebookRuntime(ctx, req, opts...)
}

// AssignNotebookRuntimeOperation returns a new AssignNotebookRuntimeOperation from a given name.
// The name must be that of a previously created AssignNotebookRuntimeOperation, possibly from a different process.
func (c *NotebookClient) AssignNotebookRuntimeOperation(name string) *AssignNotebookRuntimeOperation {
	return c.internalClient.AssignNotebookRuntimeOperation(name)
}

// GetNotebookRuntime gets a NotebookRuntime.
func (c *NotebookClient) GetNotebookRuntime(ctx context.Context, req *aiplatformpb.GetNotebookRuntimeRequest, opts ...gax.CallOption) (*aiplatformpb.NotebookRuntime, error) {
	return c.internalClient.GetNotebookRuntime(ctx, req, opts...)
}

// ListNotebookRuntimes lists NotebookRuntimes in a Location.
func (c *NotebookClient) ListNotebookRuntimes(ctx context.Context, req *aiplatformpb.ListNotebookRuntimesRequest, opts ...gax.CallOption) *NotebookRuntimeIterator {
	return c.internalClient.ListNotebookRuntimes(ctx, req, opts...)
}

// DeleteNotebookRuntime deletes a NotebookRuntime.
func (c *NotebookClient) DeleteNotebookRuntime(ctx context.Context, req *aiplatformpb.DeleteNotebookRuntimeRequest, opts ...gax.CallOption) (*DeleteNotebookRuntimeOperation, error) {
	return c.internalClient.DeleteNotebookRuntime(ctx, req, opts...)
}

// DeleteNotebookRuntimeOperation returns a new DeleteNotebookRuntimeOperation from a given name.
// The name must be that of a previously created DeleteNotebookRuntimeOperation, possibly from a different process.
func (c *NotebookClient) DeleteNotebookRuntimeOperation(name string) *DeleteNotebookRuntimeOperation {
	return c.internalClient.DeleteNotebookRuntimeOperation(name)
}

// UpgradeNotebookRuntime upgrades a NotebookRuntime.
func (c *NotebookClient) UpgradeNotebookRuntime(ctx context.Context, req *aiplatformpb.UpgradeNotebookRuntimeRequest, opts ...gax.CallOption) (*UpgradeNotebookRuntimeOperation, error) {
	return c.internalClient.UpgradeNotebookRuntime(ctx, req, opts...)
}

// UpgradeNotebookRuntimeOperation returns a new UpgradeNotebookRuntimeOperation from a given name.
// The name must be that of a previously created UpgradeNotebookRuntimeOperation, possibly from a different process.
func (c *NotebookClient) UpgradeNotebookRuntimeOperation(name string) *UpgradeNotebookRuntimeOperation {
	return c.internalClient.UpgradeNotebookRuntimeOperation(name)
}

// StartNotebookRuntime starts a NotebookRuntime.
func (c *NotebookClient) StartNotebookRuntime(ctx context.Context, req *aiplatformpb.StartNotebookRuntimeRequest, opts ...gax.CallOption) (*StartNotebookRuntimeOperation, error) {
	return c.internalClient.StartNotebookRuntime(ctx, req, opts...)
}

// StartNotebookRuntimeOperation returns a new StartNotebookRuntimeOperation from a given name.
// The name must be that of a previously created StartNotebookRuntimeOperation, possibly from a different process.
func (c *NotebookClient) StartNotebookRuntimeOperation(name string) *StartNotebookRuntimeOperation {
	return c.internalClient.StartNotebookRuntimeOperation(name)
}

// StopNotebookRuntime stops a NotebookRuntime.
func (c *NotebookClient) StopNotebookRuntime(ctx context.Context, req *aiplatformpb.StopNotebookRuntimeRequest, opts ...gax.CallOption) (*StopNotebookRuntimeOperation, error) {
	return c.internalClient.StopNotebookRuntime(ctx, req, opts...)
}

// StopNotebookRuntimeOperation returns a new StopNotebookRuntimeOperation from a given name.
// The name must be that of a previously created StopNotebookRuntimeOperation, possibly from a different process.
func (c *NotebookClient) StopNotebookRuntimeOperation(name string) *StopNotebookRuntimeOperation {
	return c.internalClient.StopNotebookRuntimeOperation(name)
}

// CreateNotebookExecutionJob creates a NotebookExecutionJob.
func (c *NotebookClient) CreateNotebookExecutionJob(ctx context.Context, req *aiplatformpb.CreateNotebookExecutionJobRequest, opts ...gax.CallOption) (*CreateNotebookExecutionJobOperation, error) {
	return c.internalClient.CreateNotebookExecutionJob(ctx, req, opts...)
}

// CreateNotebookExecutionJobOperation returns a new CreateNotebookExecutionJobOperation from a given name.
// The name must be that of a previously created CreateNotebookExecutionJobOperation, possibly from a different process.
func (c *NotebookClient) CreateNotebookExecutionJobOperation(name string) *CreateNotebookExecutionJobOperation {
	return c.internalClient.CreateNotebookExecutionJobOperation(name)
}

// GetNotebookExecutionJob gets a NotebookExecutionJob.
func (c *NotebookClient) GetNotebookExecutionJob(ctx context.Context, req *aiplatformpb.GetNotebookExecutionJobRequest, opts ...gax.CallOption) (*aiplatformpb.NotebookExecutionJob, error) {
	return c.internalClient.GetNotebookExecutionJob(ctx, req, opts...)
}

// ListNotebookExecutionJobs lists NotebookExecutionJobs in a Location.
func (c *NotebookClient) ListNotebookExecutionJobs(ctx context.Context, req *aiplatformpb.ListNotebookExecutionJobsRequest, opts ...gax.CallOption) *NotebookExecutionJobIterator {
	return c.internalClient.ListNotebookExecutionJobs(ctx, req, opts...)
}

// DeleteNotebookExecutionJob deletes a NotebookExecutionJob.
func (c *NotebookClient) DeleteNotebookExecutionJob(ctx context.Context, req *aiplatformpb.DeleteNotebookExecutionJobRequest, opts ...gax.CallOption) (*DeleteNotebookExecutionJobOperation, error) {
	return c.internalClient.DeleteNotebookExecutionJob(ctx, req, opts...)
}

// DeleteNotebookExecutionJobOperation returns a new DeleteNotebookExecutionJobOperation from a given name.
// The name must be that of a previously created DeleteNotebookExecutionJobOperation, possibly from a different process.
func (c *NotebookClient) DeleteNotebookExecutionJobOperation(name string) *DeleteNotebookExecutionJobOperation {
	return c.internalClient.DeleteNotebookExecutionJobOperation(name)
}

// GetLocation gets information about a location.
func (c *NotebookClient) GetLocation(ctx context.Context, req *locationpb.GetLocationRequest, opts ...gax.CallOption) (*locationpb.Location, error) {
	return c.internalClient.GetLocation(ctx, req, opts...)
}

// ListLocations lists information about the supported locations for this service.
func (c *NotebookClient) ListLocations(ctx context.Context, req *locationpb.ListLocationsRequest, opts ...gax.CallOption) *LocationIterator {
	return c.internalClient.ListLocations(ctx, req, opts...)
}

// GetIamPolicy gets the access control policy for a resource. Returns an empty policy
// if the resource exists and does not have a policy set.
func (c *NotebookClient) GetIamPolicy(ctx context.Context, req *iampb.GetIamPolicyRequest, opts ...gax.CallOption) (*iampb.Policy, error) {
	return c.internalClient.GetIamPolicy(ctx, req, opts...)
}

// SetIamPolicy sets the access control policy on the specified resource. Replaces
// any existing policy.
//
// Can return NOT_FOUND, INVALID_ARGUMENT, and PERMISSION_DENIED
// errors.
func (c *NotebookClient) SetIamPolicy(ctx context.Context, req *iampb.SetIamPolicyRequest, opts ...gax.CallOption) (*iampb.Policy, error) {
	return c.internalClient.SetIamPolicy(ctx, req, opts...)
}

// TestIamPermissions returns permissions that a caller has on the specified resource. If the
// resource does not exist, this will return an empty set of
// permissions, not a NOT_FOUND error.
//
// Note: This operation is designed to be used for building
// permission-aware UIs and command-line tools, not for authorization
// checking. This operation may “fail open” without warning.
func (c *NotebookClient) TestIamPermissions(ctx context.Context, req *iampb.TestIamPermissionsRequest, opts ...gax.CallOption) (*iampb.TestIamPermissionsResponse, error) {
	return c.internalClient.TestIamPermissions(ctx, req, opts...)
}

// CancelOperation is a utility method from google.longrunning.Operations.
func (c *NotebookClient) CancelOperation(ctx context.Context, req *longrunningpb.CancelOperationRequest, opts ...gax.CallOption) error {
	return c.internalClient.CancelOperation(ctx, req, opts...)
}

// DeleteOperation is a utility method from google.longrunning.Operations.
func (c *NotebookClient) DeleteOperation(ctx context.Context, req *longrunningpb.DeleteOperationRequest, opts ...gax.CallOption) error {
	return c.internalClient.DeleteOperation(ctx, req, opts...)
}

// GetOperation is a utility method from google.longrunning.Operations.
func (c *NotebookClient) GetOperation(ctx context.Context, req *longrunningpb.GetOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	return c.internalClient.GetOperation(ctx, req, opts...)
}

// ListOperations is a utility method from google.longrunning.Operations.
func (c *NotebookClient) ListOperations(ctx context.Context, req *longrunningpb.ListOperationsRequest, opts ...gax.CallOption) *OperationIterator {
	return c.internalClient.ListOperations(ctx, req, opts...)
}

// WaitOperation is a utility method from google.longrunning.Operations.
func (c *NotebookClient) WaitOperation(ctx context.Context, req *longrunningpb.WaitOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	return c.internalClient.WaitOperation(ctx, req, opts...)
}

// notebookGRPCClient is a client for interacting with Vertex AI API over gRPC transport.
//
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type notebookGRPCClient struct {
	// Connection pool of gRPC connections to the service.
	connPool gtransport.ConnPool

	// Points back to the CallOptions field of the containing NotebookClient
	CallOptions **NotebookCallOptions

	// The gRPC API client.
	notebookClient aiplatformpb.NotebookServiceClient

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient **lroauto.OperationsClient

	operationsClient longrunningpb.OperationsClient

	iamPolicyClient iampb.IAMPolicyClient

	locationsClient locationpb.LocationsClient

	// The x-goog-* metadata to be sent with each request.
	xGoogHeaders []string

	logger *slog.Logger
}

// NewNotebookClient creates a new notebook service client based on gRPC.
// The returned client must be Closed when it is done being used to clean up its underlying connections.
//
// The interface for Vertex Notebook service (a.k.a. Colab on Workbench).
func NewNotebookClient(ctx context.Context, opts ...option.ClientOption) (*NotebookClient, error) {
	clientOpts := defaultNotebookGRPCClientOptions()
	if newNotebookClientHook != nil {
		hookOpts, err := newNotebookClientHook(ctx, clientHookParams{})
		if err != nil {
			return nil, err
		}
		clientOpts = append(clientOpts, hookOpts...)
	}

	connPool, err := gtransport.DialPool(ctx, append(clientOpts, opts...)...)
	if err != nil {
		return nil, err
	}
	client := NotebookClient{CallOptions: defaultNotebookCallOptions()}

	c := &notebookGRPCClient{
		connPool:         connPool,
		notebookClient:   aiplatformpb.NewNotebookServiceClient(connPool),
		CallOptions:      &client.CallOptions,
		logger:           internaloption.GetLogger(opts),
		operationsClient: longrunningpb.NewOperationsClient(connPool),
		iamPolicyClient:  iampb.NewIAMPolicyClient(connPool),
		locationsClient:  locationpb.NewLocationsClient(connPool),
	}
	c.setGoogleClientInfo()

	client.internalClient = c

	client.LROClient, err = lroauto.NewOperationsClient(ctx, gtransport.WithConnPool(connPool))
	if err != nil {
		// This error "should not happen", since we are just reusing old connection pool
		// and never actually need to dial.
		// If this does happen, we could leak connp. However, we cannot close conn:
		// If the user invoked the constructor with option.WithGRPCConn,
		// we would close a connection that's still in use.
		// TODO: investigate error conditions.
		return nil, err
	}
	c.LROClient = &client.LROClient
	return &client, nil
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *notebookGRPCClient) Connection() *grpc.ClientConn {
	return c.connPool.Conn()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *notebookGRPCClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "grpc", grpc.Version, "pb", protoVersion)
	c.xGoogHeaders = []string{
		"x-goog-api-client", gax.XGoogHeader(kv...),
	}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *notebookGRPCClient) Close() error {
	return c.connPool.Close()
}

// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type notebookRESTClient struct {
	// The http endpoint to connect to.
	endpoint string

	// The http client.
	httpClient *http.Client

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient **lroauto.OperationsClient

	// The x-goog-* headers to be sent with each request.
	xGoogHeaders []string

	// Points back to the CallOptions field of the containing NotebookClient
	CallOptions **NotebookCallOptions

	logger *slog.Logger
}

// NewNotebookRESTClient creates a new notebook service rest client.
//
// The interface for Vertex Notebook service (a.k.a. Colab on Workbench).
func NewNotebookRESTClient(ctx context.Context, opts ...option.ClientOption) (*NotebookClient, error) {
	clientOpts := append(defaultNotebookRESTClientOptions(), opts...)
	httpClient, endpoint, err := httptransport.NewClient(ctx, clientOpts...)
	if err != nil {
		return nil, err
	}

	callOpts := defaultNotebookRESTCallOptions()
	c := &notebookRESTClient{
		endpoint:    endpoint,
		httpClient:  httpClient,
		CallOptions: &callOpts,
		logger:      internaloption.GetLogger(opts),
	}
	c.setGoogleClientInfo()

	lroOpts := []option.ClientOption{
		option.WithHTTPClient(httpClient),
		option.WithEndpoint(endpoint),
	}
	opClient, err := lroauto.NewOperationsRESTClient(ctx, lroOpts...)
	if err != nil {
		return nil, err
	}
	c.LROClient = &opClient

	return &NotebookClient{internalClient: c, CallOptions: callOpts}, nil
}

func defaultNotebookRESTClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("https://aiplatform.googleapis.com"),
		internaloption.WithDefaultEndpointTemplate("https://aiplatform.UNIVERSE_DOMAIN"),
		internaloption.WithDefaultMTLSEndpoint("https://aiplatform.mtls.googleapis.com"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://aiplatform.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableNewAuthLibrary(),
	}
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *notebookRESTClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "rest", "UNKNOWN", "pb", protoVersion)
	c.xGoogHeaders = []string{
		"x-goog-api-client", gax.XGoogHeader(kv...),
	}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *notebookRESTClient) Close() error {
	// Replace httpClient with nil to force cleanup.
	c.httpClient = nil
	return nil
}

// Connection returns a connection to the API service.
//
// Deprecated: This method always returns nil.
func (c *notebookRESTClient) Connection() *grpc.ClientConn {
	return nil
}
func (c *notebookGRPCClient) CreateNotebookRuntimeTemplate(ctx context.Context, req *aiplatformpb.CreateNotebookRuntimeTemplateRequest, opts ...gax.CallOption) (*CreateNotebookRuntimeTemplateOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateNotebookRuntimeTemplate[0:len((*c.CallOptions).CreateNotebookRuntimeTemplate):len((*c.CallOptions).CreateNotebookRuntimeTemplate)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.notebookClient.CreateNotebookRuntimeTemplate, req, settings.GRPC, c.logger, "CreateNotebookRuntimeTemplate")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateNotebookRuntimeTemplateOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *notebookGRPCClient) GetNotebookRuntimeTemplate(ctx context.Context, req *aiplatformpb.GetNotebookRuntimeTemplateRequest, opts ...gax.CallOption) (*aiplatformpb.NotebookRuntimeTemplate, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetNotebookRuntimeTemplate[0:len((*c.CallOptions).GetNotebookRuntimeTemplate):len((*c.CallOptions).GetNotebookRuntimeTemplate)], opts...)
	var resp *aiplatformpb.NotebookRuntimeTemplate
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.notebookClient.GetNotebookRuntimeTemplate, req, settings.GRPC, c.logger, "GetNotebookRuntimeTemplate")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *notebookGRPCClient) ListNotebookRuntimeTemplates(ctx context.Context, req *aiplatformpb.ListNotebookRuntimeTemplatesRequest, opts ...gax.CallOption) *NotebookRuntimeTemplateIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListNotebookRuntimeTemplates[0:len((*c.CallOptions).ListNotebookRuntimeTemplates):len((*c.CallOptions).ListNotebookRuntimeTemplates)], opts...)
	it := &NotebookRuntimeTemplateIterator{}
	req = proto.Clone(req).(*aiplatformpb.ListNotebookRuntimeTemplatesRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*aiplatformpb.NotebookRuntimeTemplate, string, error) {
		resp := &aiplatformpb.ListNotebookRuntimeTemplatesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.notebookClient.ListNotebookRuntimeTemplates, req, settings.GRPC, c.logger, "ListNotebookRuntimeTemplates")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetNotebookRuntimeTemplates(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *notebookGRPCClient) DeleteNotebookRuntimeTemplate(ctx context.Context, req *aiplatformpb.DeleteNotebookRuntimeTemplateRequest, opts ...gax.CallOption) (*DeleteNotebookRuntimeTemplateOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteNotebookRuntimeTemplate[0:len((*c.CallOptions).DeleteNotebookRuntimeTemplate):len((*c.CallOptions).DeleteNotebookRuntimeTemplate)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.notebookClient.DeleteNotebookRuntimeTemplate, req, settings.GRPC, c.logger, "DeleteNotebookRuntimeTemplate")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteNotebookRuntimeTemplateOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *notebookGRPCClient) UpdateNotebookRuntimeTemplate(ctx context.Context, req *aiplatformpb.UpdateNotebookRuntimeTemplateRequest, opts ...gax.CallOption) (*aiplatformpb.NotebookRuntimeTemplate, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "notebook_runtime_template.name", url.QueryEscape(req.GetNotebookRuntimeTemplate().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateNotebookRuntimeTemplate[0:len((*c.CallOptions).UpdateNotebookRuntimeTemplate):len((*c.CallOptions).UpdateNotebookRuntimeTemplate)], opts...)
	var resp *aiplatformpb.NotebookRuntimeTemplate
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.notebookClient.UpdateNotebookRuntimeTemplate, req, settings.GRPC, c.logger, "UpdateNotebookRuntimeTemplate")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *notebookGRPCClient) AssignNotebookRuntime(ctx context.Context, req *aiplatformpb.AssignNotebookRuntimeRequest, opts ...gax.CallOption) (*AssignNotebookRuntimeOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).AssignNotebookRuntime[0:len((*c.CallOptions).AssignNotebookRuntime):len((*c.CallOptions).AssignNotebookRuntime)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.notebookClient.AssignNotebookRuntime, req, settings.GRPC, c.logger, "AssignNotebookRuntime")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &AssignNotebookRuntimeOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *notebookGRPCClient) GetNotebookRuntime(ctx context.Context, req *aiplatformpb.GetNotebookRuntimeRequest, opts ...gax.CallOption) (*aiplatformpb.NotebookRuntime, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetNotebookRuntime[0:len((*c.CallOptions).GetNotebookRuntime):len((*c.CallOptions).GetNotebookRuntime)], opts...)
	var resp *aiplatformpb.NotebookRuntime
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.notebookClient.GetNotebookRuntime, req, settings.GRPC, c.logger, "GetNotebookRuntime")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *notebookGRPCClient) ListNotebookRuntimes(ctx context.Context, req *aiplatformpb.ListNotebookRuntimesRequest, opts ...gax.CallOption) *NotebookRuntimeIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListNotebookRuntimes[0:len((*c.CallOptions).ListNotebookRuntimes):len((*c.CallOptions).ListNotebookRuntimes)], opts...)
	it := &NotebookRuntimeIterator{}
	req = proto.Clone(req).(*aiplatformpb.ListNotebookRuntimesRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*aiplatformpb.NotebookRuntime, string, error) {
		resp := &aiplatformpb.ListNotebookRuntimesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.notebookClient.ListNotebookRuntimes, req, settings.GRPC, c.logger, "ListNotebookRuntimes")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetNotebookRuntimes(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *notebookGRPCClient) DeleteNotebookRuntime(ctx context.Context, req *aiplatformpb.DeleteNotebookRuntimeRequest, opts ...gax.CallOption) (*DeleteNotebookRuntimeOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteNotebookRuntime[0:len((*c.CallOptions).DeleteNotebookRuntime):len((*c.CallOptions).DeleteNotebookRuntime)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.notebookClient.DeleteNotebookRuntime, req, settings.GRPC, c.logger, "DeleteNotebookRuntime")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteNotebookRuntimeOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *notebookGRPCClient) UpgradeNotebookRuntime(ctx context.Context, req *aiplatformpb.UpgradeNotebookRuntimeRequest, opts ...gax.CallOption) (*UpgradeNotebookRuntimeOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpgradeNotebookRuntime[0:len((*c.CallOptions).UpgradeNotebookRuntime):len((*c.CallOptions).UpgradeNotebookRuntime)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.notebookClient.UpgradeNotebookRuntime, req, settings.GRPC, c.logger, "UpgradeNotebookRuntime")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpgradeNotebookRuntimeOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *notebookGRPCClient) StartNotebookRuntime(ctx context.Context, req *aiplatformpb.StartNotebookRuntimeRequest, opts ...gax.CallOption) (*StartNotebookRuntimeOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).StartNotebookRuntime[0:len((*c.CallOptions).StartNotebookRuntime):len((*c.CallOptions).StartNotebookRuntime)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.notebookClient.StartNotebookRuntime, req, settings.GRPC, c.logger, "StartNotebookRuntime")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &StartNotebookRuntimeOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *notebookGRPCClient) StopNotebookRuntime(ctx context.Context, req *aiplatformpb.StopNotebookRuntimeRequest, opts ...gax.CallOption) (*StopNotebookRuntimeOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).StopNotebookRuntime[0:len((*c.CallOptions).StopNotebookRuntime):len((*c.CallOptions).StopNotebookRuntime)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.notebookClient.StopNotebookRuntime, req, settings.GRPC, c.logger, "StopNotebookRuntime")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &StopNotebookRuntimeOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *notebookGRPCClient) CreateNotebookExecutionJob(ctx context.Context, req *aiplatformpb.CreateNotebookExecutionJobRequest, opts ...gax.CallOption) (*CreateNotebookExecutionJobOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateNotebookExecutionJob[0:len((*c.CallOptions).CreateNotebookExecutionJob):len((*c.CallOptions).CreateNotebookExecutionJob)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.notebookClient.CreateNotebookExecutionJob, req, settings.GRPC, c.logger, "CreateNotebookExecutionJob")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateNotebookExecutionJobOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *notebookGRPCClient) GetNotebookExecutionJob(ctx context.Context, req *aiplatformpb.GetNotebookExecutionJobRequest, opts ...gax.CallOption) (*aiplatformpb.NotebookExecutionJob, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetNotebookExecutionJob[0:len((*c.CallOptions).GetNotebookExecutionJob):len((*c.CallOptions).GetNotebookExecutionJob)], opts...)
	var resp *aiplatformpb.NotebookExecutionJob
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.notebookClient.GetNotebookExecutionJob, req, settings.GRPC, c.logger, "GetNotebookExecutionJob")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *notebookGRPCClient) ListNotebookExecutionJobs(ctx context.Context, req *aiplatformpb.ListNotebookExecutionJobsRequest, opts ...gax.CallOption) *NotebookExecutionJobIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListNotebookExecutionJobs[0:len((*c.CallOptions).ListNotebookExecutionJobs):len((*c.CallOptions).ListNotebookExecutionJobs)], opts...)
	it := &NotebookExecutionJobIterator{}
	req = proto.Clone(req).(*aiplatformpb.ListNotebookExecutionJobsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*aiplatformpb.NotebookExecutionJob, string, error) {
		resp := &aiplatformpb.ListNotebookExecutionJobsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.notebookClient.ListNotebookExecutionJobs, req, settings.GRPC, c.logger, "ListNotebookExecutionJobs")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetNotebookExecutionJobs(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *notebookGRPCClient) DeleteNotebookExecutionJob(ctx context.Context, req *aiplatformpb.DeleteNotebookExecutionJobRequest, opts ...gax.CallOption) (*DeleteNotebookExecutionJobOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteNotebookExecutionJob[0:len((*c.CallOptions).DeleteNotebookExecutionJob):len((*c.CallOptions).DeleteNotebookExecutionJob)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.notebookClient.DeleteNotebookExecutionJob, req, settings.GRPC, c.logger, "DeleteNotebookExecutionJob")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteNotebookExecutionJobOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *notebookGRPCClient) GetLocation(ctx context.Context, req *locationpb.GetLocationRequest, opts ...gax.CallOption) (*locationpb.Location, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetLocation[0:len((*c.CallOptions).GetLocation):len((*c.CallOptions).GetLocation)], opts...)
	var resp *locationpb.Location
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.locationsClient.GetLocation, req, settings.GRPC, c.logger, "GetLocation")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *notebookGRPCClient) ListLocations(ctx context.Context, req *locationpb.ListLocationsRequest, opts ...gax.CallOption) *LocationIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListLocations[0:len((*c.CallOptions).ListLocations):len((*c.CallOptions).ListLocations)], opts...)
	it := &LocationIterator{}
	req = proto.Clone(req).(*locationpb.ListLocationsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*locationpb.Location, string, error) {
		resp := &locationpb.ListLocationsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.locationsClient.ListLocations, req, settings.GRPC, c.logger, "ListLocations")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetLocations(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *notebookGRPCClient) GetIamPolicy(ctx context.Context, req *iampb.GetIamPolicyRequest, opts ...gax.CallOption) (*iampb.Policy, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "resource", url.QueryEscape(req.GetResource()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetIamPolicy[0:len((*c.CallOptions).GetIamPolicy):len((*c.CallOptions).GetIamPolicy)], opts...)
	var resp *iampb.Policy
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.iamPolicyClient.GetIamPolicy, req, settings.GRPC, c.logger, "GetIamPolicy")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *notebookGRPCClient) SetIamPolicy(ctx context.Context, req *iampb.SetIamPolicyRequest, opts ...gax.CallOption) (*iampb.Policy, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "resource", url.QueryEscape(req.GetResource()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).SetIamPolicy[0:len((*c.CallOptions).SetIamPolicy):len((*c.CallOptions).SetIamPolicy)], opts...)
	var resp *iampb.Policy
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.iamPolicyClient.SetIamPolicy, req, settings.GRPC, c.logger, "SetIamPolicy")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *notebookGRPCClient) TestIamPermissions(ctx context.Context, req *iampb.TestIamPermissionsRequest, opts ...gax.CallOption) (*iampb.TestIamPermissionsResponse, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "resource", url.QueryEscape(req.GetResource()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).TestIamPermissions[0:len((*c.CallOptions).TestIamPermissions):len((*c.CallOptions).TestIamPermissions)], opts...)
	var resp *iampb.TestIamPermissionsResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.iamPolicyClient.TestIamPermissions, req, settings.GRPC, c.logger, "TestIamPermissions")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *notebookGRPCClient) CancelOperation(ctx context.Context, req *longrunningpb.CancelOperationRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CancelOperation[0:len((*c.CallOptions).CancelOperation):len((*c.CallOptions).CancelOperation)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = executeRPC(ctx, c.operationsClient.CancelOperation, req, settings.GRPC, c.logger, "CancelOperation")
		return err
	}, opts...)
	return err
}

func (c *notebookGRPCClient) DeleteOperation(ctx context.Context, req *longrunningpb.DeleteOperationRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteOperation[0:len((*c.CallOptions).DeleteOperation):len((*c.CallOptions).DeleteOperation)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = executeRPC(ctx, c.operationsClient.DeleteOperation, req, settings.GRPC, c.logger, "DeleteOperation")
		return err
	}, opts...)
	return err
}

func (c *notebookGRPCClient) GetOperation(ctx context.Context, req *longrunningpb.GetOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetOperation[0:len((*c.CallOptions).GetOperation):len((*c.CallOptions).GetOperation)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.operationsClient.GetOperation, req, settings.GRPC, c.logger, "GetOperation")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *notebookGRPCClient) ListOperations(ctx context.Context, req *longrunningpb.ListOperationsRequest, opts ...gax.CallOption) *OperationIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListOperations[0:len((*c.CallOptions).ListOperations):len((*c.CallOptions).ListOperations)], opts...)
	it := &OperationIterator{}
	req = proto.Clone(req).(*longrunningpb.ListOperationsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*longrunningpb.Operation, string, error) {
		resp := &longrunningpb.ListOperationsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.operationsClient.ListOperations, req, settings.GRPC, c.logger, "ListOperations")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetOperations(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *notebookGRPCClient) WaitOperation(ctx context.Context, req *longrunningpb.WaitOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).WaitOperation[0:len((*c.CallOptions).WaitOperation):len((*c.CallOptions).WaitOperation)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.operationsClient.WaitOperation, req, settings.GRPC, c.logger, "WaitOperation")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

// CreateNotebookRuntimeTemplate creates a NotebookRuntimeTemplate.
func (c *notebookRESTClient) CreateNotebookRuntimeTemplate(ctx context.Context, req *aiplatformpb.CreateNotebookRuntimeTemplateRequest, opts ...gax.CallOption) (*CreateNotebookRuntimeTemplateOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetNotebookRuntimeTemplate()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1beta1/%v/notebookRuntimeTemplates", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetNotebookRuntimeTemplateId() != "" {
		params.Add("notebookRuntimeTemplateId", fmt.Sprintf("%v", req.GetNotebookRuntimeTemplateId()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "CreateNotebookRuntimeTemplate")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/ui/%s", resp.GetName())
	return &CreateNotebookRuntimeTemplateOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// GetNotebookRuntimeTemplate gets a NotebookRuntimeTemplate.
func (c *notebookRESTClient) GetNotebookRuntimeTemplate(ctx context.Context, req *aiplatformpb.GetNotebookRuntimeTemplateRequest, opts ...gax.CallOption) (*aiplatformpb.NotebookRuntimeTemplate, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1beta1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetNotebookRuntimeTemplate[0:len((*c.CallOptions).GetNotebookRuntimeTemplate):len((*c.CallOptions).GetNotebookRuntimeTemplate)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &aiplatformpb.NotebookRuntimeTemplate{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetNotebookRuntimeTemplate")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ListNotebookRuntimeTemplates lists NotebookRuntimeTemplates in a Location.
func (c *notebookRESTClient) ListNotebookRuntimeTemplates(ctx context.Context, req *aiplatformpb.ListNotebookRuntimeTemplatesRequest, opts ...gax.CallOption) *NotebookRuntimeTemplateIterator {
	it := &NotebookRuntimeTemplateIterator{}
	req = proto.Clone(req).(*aiplatformpb.ListNotebookRuntimeTemplatesRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*aiplatformpb.NotebookRuntimeTemplate, string, error) {
		resp := &aiplatformpb.ListNotebookRuntimeTemplatesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1beta1/%v/notebookRuntimeTemplates", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetOrderBy() != "" {
			params.Add("orderBy", fmt.Sprintf("%v", req.GetOrderBy()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}
		if req.GetReadMask() != nil {
			field, err := protojson.Marshal(req.GetReadMask())
			if err != nil {
				return nil, "", err
			}
			params.Add("readMask", string(field[1:len(field)-1]))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListNotebookRuntimeTemplates")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetNotebookRuntimeTemplates(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// DeleteNotebookRuntimeTemplate deletes a NotebookRuntimeTemplate.
func (c *notebookRESTClient) DeleteNotebookRuntimeTemplate(ctx context.Context, req *aiplatformpb.DeleteNotebookRuntimeTemplateRequest, opts ...gax.CallOption) (*DeleteNotebookRuntimeTemplateOperation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1beta1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "DeleteNotebookRuntimeTemplate")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/ui/%s", resp.GetName())
	return &DeleteNotebookRuntimeTemplateOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// UpdateNotebookRuntimeTemplate updates a NotebookRuntimeTemplate.
func (c *notebookRESTClient) UpdateNotebookRuntimeTemplate(ctx context.Context, req *aiplatformpb.UpdateNotebookRuntimeTemplateRequest, opts ...gax.CallOption) (*aiplatformpb.NotebookRuntimeTemplate, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetNotebookRuntimeTemplate()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1beta1/%v", req.GetNotebookRuntimeTemplate().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetUpdateMask() != nil {
		field, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(field[1:len(field)-1]))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "notebook_runtime_template.name", url.QueryEscape(req.GetNotebookRuntimeTemplate().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).UpdateNotebookRuntimeTemplate[0:len((*c.CallOptions).UpdateNotebookRuntimeTemplate):len((*c.CallOptions).UpdateNotebookRuntimeTemplate)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &aiplatformpb.NotebookRuntimeTemplate{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "UpdateNotebookRuntimeTemplate")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// AssignNotebookRuntime assigns a NotebookRuntime to a user for a particular Notebook file. This
// method will either returns an existing assignment or generates a new one.
func (c *notebookRESTClient) AssignNotebookRuntime(ctx context.Context, req *aiplatformpb.AssignNotebookRuntimeRequest, opts ...gax.CallOption) (*AssignNotebookRuntimeOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1beta1/%v/notebookRuntimes:assign", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "AssignNotebookRuntime")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/ui/%s", resp.GetName())
	return &AssignNotebookRuntimeOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// GetNotebookRuntime gets a NotebookRuntime.
func (c *notebookRESTClient) GetNotebookRuntime(ctx context.Context, req *aiplatformpb.GetNotebookRuntimeRequest, opts ...gax.CallOption) (*aiplatformpb.NotebookRuntime, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1beta1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetNotebookRuntime[0:len((*c.CallOptions).GetNotebookRuntime):len((*c.CallOptions).GetNotebookRuntime)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &aiplatformpb.NotebookRuntime{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetNotebookRuntime")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ListNotebookRuntimes lists NotebookRuntimes in a Location.
func (c *notebookRESTClient) ListNotebookRuntimes(ctx context.Context, req *aiplatformpb.ListNotebookRuntimesRequest, opts ...gax.CallOption) *NotebookRuntimeIterator {
	it := &NotebookRuntimeIterator{}
	req = proto.Clone(req).(*aiplatformpb.ListNotebookRuntimesRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*aiplatformpb.NotebookRuntime, string, error) {
		resp := &aiplatformpb.ListNotebookRuntimesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1beta1/%v/notebookRuntimes", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetOrderBy() != "" {
			params.Add("orderBy", fmt.Sprintf("%v", req.GetOrderBy()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}
		if req.GetReadMask() != nil {
			field, err := protojson.Marshal(req.GetReadMask())
			if err != nil {
				return nil, "", err
			}
			params.Add("readMask", string(field[1:len(field)-1]))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListNotebookRuntimes")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetNotebookRuntimes(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// DeleteNotebookRuntime deletes a NotebookRuntime.
func (c *notebookRESTClient) DeleteNotebookRuntime(ctx context.Context, req *aiplatformpb.DeleteNotebookRuntimeRequest, opts ...gax.CallOption) (*DeleteNotebookRuntimeOperation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1beta1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "DeleteNotebookRuntime")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/ui/%s", resp.GetName())
	return &DeleteNotebookRuntimeOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// UpgradeNotebookRuntime upgrades a NotebookRuntime.
func (c *notebookRESTClient) UpgradeNotebookRuntime(ctx context.Context, req *aiplatformpb.UpgradeNotebookRuntimeRequest, opts ...gax.CallOption) (*UpgradeNotebookRuntimeOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1beta1/%v:upgrade", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "UpgradeNotebookRuntime")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/ui/%s", resp.GetName())
	return &UpgradeNotebookRuntimeOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// StartNotebookRuntime starts a NotebookRuntime.
func (c *notebookRESTClient) StartNotebookRuntime(ctx context.Context, req *aiplatformpb.StartNotebookRuntimeRequest, opts ...gax.CallOption) (*StartNotebookRuntimeOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1beta1/%v:start", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "StartNotebookRuntime")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/ui/%s", resp.GetName())
	return &StartNotebookRuntimeOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// StopNotebookRuntime stops a NotebookRuntime.
func (c *notebookRESTClient) StopNotebookRuntime(ctx context.Context, req *aiplatformpb.StopNotebookRuntimeRequest, opts ...gax.CallOption) (*StopNotebookRuntimeOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1beta1/%v:stop", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "StopNotebookRuntime")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/ui/%s", resp.GetName())
	return &StopNotebookRuntimeOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// CreateNotebookExecutionJob creates a NotebookExecutionJob.
func (c *notebookRESTClient) CreateNotebookExecutionJob(ctx context.Context, req *aiplatformpb.CreateNotebookExecutionJobRequest, opts ...gax.CallOption) (*CreateNotebookExecutionJobOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetNotebookExecutionJob()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1beta1/%v/notebookExecutionJobs", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetNotebookExecutionJobId() != "" {
		params.Add("notebookExecutionJobId", fmt.Sprintf("%v", req.GetNotebookExecutionJobId()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "CreateNotebookExecutionJob")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/ui/%s", resp.GetName())
	return &CreateNotebookExecutionJobOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// GetNotebookExecutionJob gets a NotebookExecutionJob.
func (c *notebookRESTClient) GetNotebookExecutionJob(ctx context.Context, req *aiplatformpb.GetNotebookExecutionJobRequest, opts ...gax.CallOption) (*aiplatformpb.NotebookExecutionJob, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1beta1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetView() != 0 {
		params.Add("view", fmt.Sprintf("%v", req.GetView()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetNotebookExecutionJob[0:len((*c.CallOptions).GetNotebookExecutionJob):len((*c.CallOptions).GetNotebookExecutionJob)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &aiplatformpb.NotebookExecutionJob{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetNotebookExecutionJob")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ListNotebookExecutionJobs lists NotebookExecutionJobs in a Location.
func (c *notebookRESTClient) ListNotebookExecutionJobs(ctx context.Context, req *aiplatformpb.ListNotebookExecutionJobsRequest, opts ...gax.CallOption) *NotebookExecutionJobIterator {
	it := &NotebookExecutionJobIterator{}
	req = proto.Clone(req).(*aiplatformpb.ListNotebookExecutionJobsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*aiplatformpb.NotebookExecutionJob, string, error) {
		resp := &aiplatformpb.ListNotebookExecutionJobsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1beta1/%v/notebookExecutionJobs", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetOrderBy() != "" {
			params.Add("orderBy", fmt.Sprintf("%v", req.GetOrderBy()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}
		if req.GetView() != 0 {
			params.Add("view", fmt.Sprintf("%v", req.GetView()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListNotebookExecutionJobs")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetNotebookExecutionJobs(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// DeleteNotebookExecutionJob deletes a NotebookExecutionJob.
func (c *notebookRESTClient) DeleteNotebookExecutionJob(ctx context.Context, req *aiplatformpb.DeleteNotebookExecutionJobRequest, opts ...gax.CallOption) (*DeleteNotebookExecutionJobOperation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1beta1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "DeleteNotebookExecutionJob")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/ui/%s", resp.GetName())
	return &DeleteNotebookExecutionJobOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// GetLocation gets information about a location.
func (c *notebookRESTClient) GetLocation(ctx context.Context, req *locationpb.GetLocationRequest, opts ...gax.CallOption) (*locationpb.Location, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/ui/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetLocation[0:len((*c.CallOptions).GetLocation):len((*c.CallOptions).GetLocation)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &locationpb.Location{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetLocation")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ListLocations lists information about the supported locations for this service.
func (c *notebookRESTClient) ListLocations(ctx context.Context, req *locationpb.ListLocationsRequest, opts ...gax.CallOption) *LocationIterator {
	it := &LocationIterator{}
	req = proto.Clone(req).(*locationpb.ListLocationsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*locationpb.Location, string, error) {
		resp := &locationpb.ListLocationsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/ui/%v/locations", req.GetName())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListLocations")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetLocations(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// GetIamPolicy gets the access control policy for a resource. Returns an empty policy
// if the resource exists and does not have a policy set.
func (c *notebookRESTClient) GetIamPolicy(ctx context.Context, req *iampb.GetIamPolicyRequest, opts ...gax.CallOption) (*iampb.Policy, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1beta1/%v:getIamPolicy", req.GetResource())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "resource", url.QueryEscape(req.GetResource()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetIamPolicy[0:len((*c.CallOptions).GetIamPolicy):len((*c.CallOptions).GetIamPolicy)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &iampb.Policy{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "GetIamPolicy")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// SetIamPolicy sets the access control policy on the specified resource. Replaces
// any existing policy.
//
// Can return NOT_FOUND, INVALID_ARGUMENT, and PERMISSION_DENIED
// errors.
func (c *notebookRESTClient) SetIamPolicy(ctx context.Context, req *iampb.SetIamPolicyRequest, opts ...gax.CallOption) (*iampb.Policy, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1beta1/%v:setIamPolicy", req.GetResource())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "resource", url.QueryEscape(req.GetResource()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).SetIamPolicy[0:len((*c.CallOptions).SetIamPolicy):len((*c.CallOptions).SetIamPolicy)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &iampb.Policy{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "SetIamPolicy")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// TestIamPermissions returns permissions that a caller has on the specified resource. If the
// resource does not exist, this will return an empty set of
// permissions, not a NOT_FOUND error.
//
// Note: This operation is designed to be used for building
// permission-aware UIs and command-line tools, not for authorization
// checking. This operation may “fail open” without warning.
func (c *notebookRESTClient) TestIamPermissions(ctx context.Context, req *iampb.TestIamPermissionsRequest, opts ...gax.CallOption) (*iampb.TestIamPermissionsResponse, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1beta1/%v:testIamPermissions", req.GetResource())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "resource", url.QueryEscape(req.GetResource()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).TestIamPermissions[0:len((*c.CallOptions).TestIamPermissions):len((*c.CallOptions).TestIamPermissions)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &iampb.TestIamPermissionsResponse{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "TestIamPermissions")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// CancelOperation is a utility method from google.longrunning.Operations.
func (c *notebookRESTClient) CancelOperation(ctx context.Context, req *longrunningpb.CancelOperationRequest, opts ...gax.CallOption) error {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return err
	}
	baseUrl.Path += fmt.Sprintf("/ui/%v:cancel", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	return gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		_, err = executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "CancelOperation")
		return err
	}, opts...)
}

// DeleteOperation is a utility method from google.longrunning.Operations.
func (c *notebookRESTClient) DeleteOperation(ctx context.Context, req *longrunningpb.DeleteOperationRequest, opts ...gax.CallOption) error {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return err
	}
	baseUrl.Path += fmt.Sprintf("/ui/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	return gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		_, err = executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "DeleteOperation")
		return err
	}, opts...)
}

// GetOperation is a utility method from google.longrunning.Operations.
func (c *notebookRESTClient) GetOperation(ctx context.Context, req *longrunningpb.GetOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/ui/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetOperation[0:len((*c.CallOptions).GetOperation):len((*c.CallOptions).GetOperation)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetOperation")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ListOperations is a utility method from google.longrunning.Operations.
func (c *notebookRESTClient) ListOperations(ctx context.Context, req *longrunningpb.ListOperationsRequest, opts ...gax.CallOption) *OperationIterator {
	it := &OperationIterator{}
	req = proto.Clone(req).(*longrunningpb.ListOperationsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*longrunningpb.Operation, string, error) {
		resp := &longrunningpb.ListOperationsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/ui/%v/operations", req.GetName())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListOperations")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetOperations(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// WaitOperation is a utility method from google.longrunning.Operations.
func (c *notebookRESTClient) WaitOperation(ctx context.Context, req *longrunningpb.WaitOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/ui/%v:wait", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetTimeout() != nil {
		field, err := protojson.Marshal(req.GetTimeout())
		if err != nil {
			return nil, err
		}
		params.Add("timeout", string(field[1:len(field)-1]))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).WaitOperation[0:len((*c.CallOptions).WaitOperation):len((*c.CallOptions).WaitOperation)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "WaitOperation")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// AssignNotebookRuntimeOperation returns a new AssignNotebookRuntimeOperation from a given name.
// The name must be that of a previously created AssignNotebookRuntimeOperation, possibly from a different process.
func (c *notebookGRPCClient) AssignNotebookRuntimeOperation(name string) *AssignNotebookRuntimeOperation {
	return &AssignNotebookRuntimeOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// AssignNotebookRuntimeOperation returns a new AssignNotebookRuntimeOperation from a given name.
// The name must be that of a previously created AssignNotebookRuntimeOperation, possibly from a different process.
func (c *notebookRESTClient) AssignNotebookRuntimeOperation(name string) *AssignNotebookRuntimeOperation {
	override := fmt.Sprintf("/ui/%s", name)
	return &AssignNotebookRuntimeOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// CreateNotebookExecutionJobOperation returns a new CreateNotebookExecutionJobOperation from a given name.
// The name must be that of a previously created CreateNotebookExecutionJobOperation, possibly from a different process.
func (c *notebookGRPCClient) CreateNotebookExecutionJobOperation(name string) *CreateNotebookExecutionJobOperation {
	return &CreateNotebookExecutionJobOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateNotebookExecutionJobOperation returns a new CreateNotebookExecutionJobOperation from a given name.
// The name must be that of a previously created CreateNotebookExecutionJobOperation, possibly from a different process.
func (c *notebookRESTClient) CreateNotebookExecutionJobOperation(name string) *CreateNotebookExecutionJobOperation {
	override := fmt.Sprintf("/ui/%s", name)
	return &CreateNotebookExecutionJobOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// CreateNotebookRuntimeTemplateOperation returns a new CreateNotebookRuntimeTemplateOperation from a given name.
// The name must be that of a previously created CreateNotebookRuntimeTemplateOperation, possibly from a different process.
func (c *notebookGRPCClient) CreateNotebookRuntimeTemplateOperation(name string) *CreateNotebookRuntimeTemplateOperation {
	return &CreateNotebookRuntimeTemplateOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateNotebookRuntimeTemplateOperation returns a new CreateNotebookRuntimeTemplateOperation from a given name.
// The name must be that of a previously created CreateNotebookRuntimeTemplateOperation, possibly from a different process.
func (c *notebookRESTClient) CreateNotebookRuntimeTemplateOperation(name string) *CreateNotebookRuntimeTemplateOperation {
	override := fmt.Sprintf("/ui/%s", name)
	return &CreateNotebookRuntimeTemplateOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// DeleteNotebookExecutionJobOperation returns a new DeleteNotebookExecutionJobOperation from a given name.
// The name must be that of a previously created DeleteNotebookExecutionJobOperation, possibly from a different process.
func (c *notebookGRPCClient) DeleteNotebookExecutionJobOperation(name string) *DeleteNotebookExecutionJobOperation {
	return &DeleteNotebookExecutionJobOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteNotebookExecutionJobOperation returns a new DeleteNotebookExecutionJobOperation from a given name.
// The name must be that of a previously created DeleteNotebookExecutionJobOperation, possibly from a different process.
func (c *notebookRESTClient) DeleteNotebookExecutionJobOperation(name string) *DeleteNotebookExecutionJobOperation {
	override := fmt.Sprintf("/ui/%s", name)
	return &DeleteNotebookExecutionJobOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// DeleteNotebookRuntimeOperation returns a new DeleteNotebookRuntimeOperation from a given name.
// The name must be that of a previously created DeleteNotebookRuntimeOperation, possibly from a different process.
func (c *notebookGRPCClient) DeleteNotebookRuntimeOperation(name string) *DeleteNotebookRuntimeOperation {
	return &DeleteNotebookRuntimeOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteNotebookRuntimeOperation returns a new DeleteNotebookRuntimeOperation from a given name.
// The name must be that of a previously created DeleteNotebookRuntimeOperation, possibly from a different process.
func (c *notebookRESTClient) DeleteNotebookRuntimeOperation(name string) *DeleteNotebookRuntimeOperation {
	override := fmt.Sprintf("/ui/%s", name)
	return &DeleteNotebookRuntimeOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// DeleteNotebookRuntimeTemplateOperation returns a new DeleteNotebookRuntimeTemplateOperation from a given name.
// The name must be that of a previously created DeleteNotebookRuntimeTemplateOperation, possibly from a different process.
func (c *notebookGRPCClient) DeleteNotebookRuntimeTemplateOperation(name string) *DeleteNotebookRuntimeTemplateOperation {
	return &DeleteNotebookRuntimeTemplateOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteNotebookRuntimeTemplateOperation returns a new DeleteNotebookRuntimeTemplateOperation from a given name.
// The name must be that of a previously created DeleteNotebookRuntimeTemplateOperation, possibly from a different process.
func (c *notebookRESTClient) DeleteNotebookRuntimeTemplateOperation(name string) *DeleteNotebookRuntimeTemplateOperation {
	override := fmt.Sprintf("/ui/%s", name)
	return &DeleteNotebookRuntimeTemplateOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// StartNotebookRuntimeOperation returns a new StartNotebookRuntimeOperation from a given name.
// The name must be that of a previously created StartNotebookRuntimeOperation, possibly from a different process.
func (c *notebookGRPCClient) StartNotebookRuntimeOperation(name string) *StartNotebookRuntimeOperation {
	return &StartNotebookRuntimeOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// StartNotebookRuntimeOperation returns a new StartNotebookRuntimeOperation from a given name.
// The name must be that of a previously created StartNotebookRuntimeOperation, possibly from a different process.
func (c *notebookRESTClient) StartNotebookRuntimeOperation(name string) *StartNotebookRuntimeOperation {
	override := fmt.Sprintf("/ui/%s", name)
	return &StartNotebookRuntimeOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// StopNotebookRuntimeOperation returns a new StopNotebookRuntimeOperation from a given name.
// The name must be that of a previously created StopNotebookRuntimeOperation, possibly from a different process.
func (c *notebookGRPCClient) StopNotebookRuntimeOperation(name string) *StopNotebookRuntimeOperation {
	return &StopNotebookRuntimeOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// StopNotebookRuntimeOperation returns a new StopNotebookRuntimeOperation from a given name.
// The name must be that of a previously created StopNotebookRuntimeOperation, possibly from a different process.
func (c *notebookRESTClient) StopNotebookRuntimeOperation(name string) *StopNotebookRuntimeOperation {
	override := fmt.Sprintf("/ui/%s", name)
	return &StopNotebookRuntimeOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// UpgradeNotebookRuntimeOperation returns a new UpgradeNotebookRuntimeOperation from a given name.
// The name must be that of a previously created UpgradeNotebookRuntimeOperation, possibly from a different process.
func (c *notebookGRPCClient) UpgradeNotebookRuntimeOperation(name string) *UpgradeNotebookRuntimeOperation {
	return &UpgradeNotebookRuntimeOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpgradeNotebookRuntimeOperation returns a new UpgradeNotebookRuntimeOperation from a given name.
// The name must be that of a previously created UpgradeNotebookRuntimeOperation, possibly from a different process.
func (c *notebookRESTClient) UpgradeNotebookRuntimeOperation(name string) *UpgradeNotebookRuntimeOperation {
	override := fmt.Sprintf("/ui/%s", name)
	return &UpgradeNotebookRuntimeOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}
