// Code generated by protoc-gen-go.
// source: google.golang.org/cloud/bigtable/internal/data_proto/bigtable_data.proto
// DO NOT EDIT!

/*
Package google_bigtable_v1 is a generated protocol buffer package.

It is generated from these files:
	google.golang.org/cloud/bigtable/internal/data_proto/bigtable_data.proto

It has these top-level messages:
	Row
	Family
	Column
	Cell
	RowRange
	ColumnRange
	TimestampRange
	ValueRange
	RowFilter
	Mutation
	ReadModifyWriteRule
*/
package google_bigtable_v1

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// Specifies the complete (requested) contents of a single row of a table.
// Rows which exceed 256MiB in size cannot be read in full.
type Row struct {
	// The unique key which identifies this row within its table. This is the same
	// key that's used to identify the row in, for example, a MutateRowRequest.
	// May contain any non-empty byte string up to 4KiB in length.
	Key []byte `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// May be empty, but only if the entire row is empty.
	// The mutual ordering of column families is not specified.
	Families []*Family `protobuf:"bytes,2,rep,name=families" json:"families,omitempty"`
}

func (m *Row) Reset()                    { *m = Row{} }
func (m *Row) String() string            { return proto.CompactTextString(m) }
func (*Row) ProtoMessage()               {}
func (*Row) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *Row) GetFamilies() []*Family {
	if m != nil {
		return m.Families
	}
	return nil
}

// Specifies (some of) the contents of a single row/column family of a table.
type Family struct {
	// The unique key which identifies this family within its row. This is the
	// same key that's used to identify the family in, for example, a RowFilter
	// which sets its "family_name_regex_filter" field.
	// Must match [-_.a-zA-Z0-9]+, except that AggregatingRowProcessors may
	// produce cells in a sentinel family with an empty name.
	// Must be no greater than 64 characters in length.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// Must not be empty. Sorted in order of increasing "qualifier".
	Columns []*Column `protobuf:"bytes,2,rep,name=columns" json:"columns,omitempty"`
}

func (m *Family) Reset()                    { *m = Family{} }
func (m *Family) String() string            { return proto.CompactTextString(m) }
func (*Family) ProtoMessage()               {}
func (*Family) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *Family) GetColumns() []*Column {
	if m != nil {
		return m.Columns
	}
	return nil
}

// Specifies (some of) the contents of a single row/column of a table.
type Column struct {
	// The unique key which identifies this column within its family. This is the
	// same key that's used to identify the column in, for example, a RowFilter
	// which sets its "column_qualifier_regex_filter" field.
	// May contain any byte string, including the empty string, up to 16kiB in
	// length.
	Qualifier []byte `protobuf:"bytes,1,opt,name=qualifier,proto3" json:"qualifier,omitempty"`
	// Must not be empty. Sorted in order of decreasing "timestamp_micros".
	Cells []*Cell `protobuf:"bytes,2,rep,name=cells" json:"cells,omitempty"`
}

func (m *Column) Reset()                    { *m = Column{} }
func (m *Column) String() string            { return proto.CompactTextString(m) }
func (*Column) ProtoMessage()               {}
func (*Column) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *Column) GetCells() []*Cell {
	if m != nil {
		return m.Cells
	}
	return nil
}

// Specifies (some of) the contents of a single row/column/timestamp of a table.
type Cell struct {
	// The cell's stored timestamp, which also uniquely identifies it within
	// its column.
	// Values are always expressed in microseconds, but individual tables may set
	// a coarser "granularity" to further restrict the allowed values. For
	// example, a table which specifies millisecond granularity will only allow
	// values of "timestamp_micros" which are multiples of 1000.
	TimestampMicros int64 `protobuf:"varint,1,opt,name=timestamp_micros" json:"timestamp_micros,omitempty"`
	// The value stored in the cell.
	// May contain any byte string, including the empty string, up to 100MiB in
	// length.
	Value []byte `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	// Labels applied to the cell by a [RowFilter][google.bigtable.v1.RowFilter].
	Labels []string `protobuf:"bytes,3,rep,name=labels" json:"labels,omitempty"`
}

func (m *Cell) Reset()                    { *m = Cell{} }
func (m *Cell) String() string            { return proto.CompactTextString(m) }
func (*Cell) ProtoMessage()               {}
func (*Cell) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

// Specifies a contiguous range of rows.
type RowRange struct {
	// Inclusive lower bound. If left empty, interpreted as the empty string.
	StartKey []byte `protobuf:"bytes,2,opt,name=start_key,proto3" json:"start_key,omitempty"`
	// Exclusive upper bound. If left empty, interpreted as infinity.
	EndKey []byte `protobuf:"bytes,3,opt,name=end_key,proto3" json:"end_key,omitempty"`
}

func (m *RowRange) Reset()                    { *m = RowRange{} }
func (m *RowRange) String() string            { return proto.CompactTextString(m) }
func (*RowRange) ProtoMessage()               {}
func (*RowRange) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

// Specifies a contiguous range of columns within a single column family.
// The range spans from <column_family>:<start_qualifier> to
// <column_family>:<end_qualifier>, where both bounds can be either inclusive or
// exclusive.
type ColumnRange struct {
	// The name of the column family within which this range falls.
	FamilyName string `protobuf:"bytes,1,opt,name=family_name" json:"family_name,omitempty"`
	// The column qualifier at which to start the range (within 'column_family').
	// If neither field is set, interpreted as the empty string, inclusive.
	//
	// Types that are valid to be assigned to StartQualifier:
	//	*ColumnRange_StartQualifierInclusive
	//	*ColumnRange_StartQualifierExclusive
	StartQualifier isColumnRange_StartQualifier `protobuf_oneof:"start_qualifier"`
	// The column qualifier at which to end the range (within 'column_family').
	// If neither field is set, interpreted as the infinite string, exclusive.
	//
	// Types that are valid to be assigned to EndQualifier:
	//	*ColumnRange_EndQualifierInclusive
	//	*ColumnRange_EndQualifierExclusive
	EndQualifier isColumnRange_EndQualifier `protobuf_oneof:"end_qualifier"`
}

func (m *ColumnRange) Reset()                    { *m = ColumnRange{} }
func (m *ColumnRange) String() string            { return proto.CompactTextString(m) }
func (*ColumnRange) ProtoMessage()               {}
func (*ColumnRange) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

type isColumnRange_StartQualifier interface {
	isColumnRange_StartQualifier()
}
type isColumnRange_EndQualifier interface {
	isColumnRange_EndQualifier()
}

type ColumnRange_StartQualifierInclusive struct {
	StartQualifierInclusive []byte `protobuf:"bytes,2,opt,name=start_qualifier_inclusive,proto3,oneof"`
}
type ColumnRange_StartQualifierExclusive struct {
	StartQualifierExclusive []byte `protobuf:"bytes,3,opt,name=start_qualifier_exclusive,proto3,oneof"`
}
type ColumnRange_EndQualifierInclusive struct {
	EndQualifierInclusive []byte `protobuf:"bytes,4,opt,name=end_qualifier_inclusive,proto3,oneof"`
}
type ColumnRange_EndQualifierExclusive struct {
	EndQualifierExclusive []byte `protobuf:"bytes,5,opt,name=end_qualifier_exclusive,proto3,oneof"`
}

func (*ColumnRange_StartQualifierInclusive) isColumnRange_StartQualifier() {}
func (*ColumnRange_StartQualifierExclusive) isColumnRange_StartQualifier() {}
func (*ColumnRange_EndQualifierInclusive) isColumnRange_EndQualifier()     {}
func (*ColumnRange_EndQualifierExclusive) isColumnRange_EndQualifier()     {}

func (m *ColumnRange) GetStartQualifier() isColumnRange_StartQualifier {
	if m != nil {
		return m.StartQualifier
	}
	return nil
}
func (m *ColumnRange) GetEndQualifier() isColumnRange_EndQualifier {
	if m != nil {
		return m.EndQualifier
	}
	return nil
}

func (m *ColumnRange) GetStartQualifierInclusive() []byte {
	if x, ok := m.GetStartQualifier().(*ColumnRange_StartQualifierInclusive); ok {
		return x.StartQualifierInclusive
	}
	return nil
}

func (m *ColumnRange) GetStartQualifierExclusive() []byte {
	if x, ok := m.GetStartQualifier().(*ColumnRange_StartQualifierExclusive); ok {
		return x.StartQualifierExclusive
	}
	return nil
}

func (m *ColumnRange) GetEndQualifierInclusive() []byte {
	if x, ok := m.GetEndQualifier().(*ColumnRange_EndQualifierInclusive); ok {
		return x.EndQualifierInclusive
	}
	return nil
}

func (m *ColumnRange) GetEndQualifierExclusive() []byte {
	if x, ok := m.GetEndQualifier().(*ColumnRange_EndQualifierExclusive); ok {
		return x.EndQualifierExclusive
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*ColumnRange) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), []interface{}) {
	return _ColumnRange_OneofMarshaler, _ColumnRange_OneofUnmarshaler, []interface{}{
		(*ColumnRange_StartQualifierInclusive)(nil),
		(*ColumnRange_StartQualifierExclusive)(nil),
		(*ColumnRange_EndQualifierInclusive)(nil),
		(*ColumnRange_EndQualifierExclusive)(nil),
	}
}

func _ColumnRange_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*ColumnRange)
	// start_qualifier
	switch x := m.StartQualifier.(type) {
	case *ColumnRange_StartQualifierInclusive:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.StartQualifierInclusive)
	case *ColumnRange_StartQualifierExclusive:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.StartQualifierExclusive)
	case nil:
	default:
		return fmt.Errorf("ColumnRange.StartQualifier has unexpected type %T", x)
	}
	// end_qualifier
	switch x := m.EndQualifier.(type) {
	case *ColumnRange_EndQualifierInclusive:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.EndQualifierInclusive)
	case *ColumnRange_EndQualifierExclusive:
		b.EncodeVarint(5<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.EndQualifierExclusive)
	case nil:
	default:
		return fmt.Errorf("ColumnRange.EndQualifier has unexpected type %T", x)
	}
	return nil
}

func _ColumnRange_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*ColumnRange)
	switch tag {
	case 2: // start_qualifier.start_qualifier_inclusive
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.StartQualifier = &ColumnRange_StartQualifierInclusive{x}
		return true, err
	case 3: // start_qualifier.start_qualifier_exclusive
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.StartQualifier = &ColumnRange_StartQualifierExclusive{x}
		return true, err
	case 4: // end_qualifier.end_qualifier_inclusive
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.EndQualifier = &ColumnRange_EndQualifierInclusive{x}
		return true, err
	case 5: // end_qualifier.end_qualifier_exclusive
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.EndQualifier = &ColumnRange_EndQualifierExclusive{x}
		return true, err
	default:
		return false, nil
	}
}

// Specified a contiguous range of microsecond timestamps.
type TimestampRange struct {
	// Inclusive lower bound. If left empty, interpreted as 0.
	StartTimestampMicros int64 `protobuf:"varint,1,opt,name=start_timestamp_micros" json:"start_timestamp_micros,omitempty"`
	// Exclusive upper bound. If left empty, interpreted as infinity.
	EndTimestampMicros int64 `protobuf:"varint,2,opt,name=end_timestamp_micros" json:"end_timestamp_micros,omitempty"`
}

func (m *TimestampRange) Reset()                    { *m = TimestampRange{} }
func (m *TimestampRange) String() string            { return proto.CompactTextString(m) }
func (*TimestampRange) ProtoMessage()               {}
func (*TimestampRange) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

// Specifies a contiguous range of raw byte values.
type ValueRange struct {
	// The value at which to start the range.
	// If neither field is set, interpreted as the empty string, inclusive.
	//
	// Types that are valid to be assigned to StartValue:
	//	*ValueRange_StartValueInclusive
	//	*ValueRange_StartValueExclusive
	StartValue isValueRange_StartValue `protobuf_oneof:"start_value"`
	// The value at which to end the range.
	// If neither field is set, interpreted as the infinite string, exclusive.
	//
	// Types that are valid to be assigned to EndValue:
	//	*ValueRange_EndValueInclusive
	//	*ValueRange_EndValueExclusive
	EndValue isValueRange_EndValue `protobuf_oneof:"end_value"`
}

func (m *ValueRange) Reset()                    { *m = ValueRange{} }
func (m *ValueRange) String() string            { return proto.CompactTextString(m) }
func (*ValueRange) ProtoMessage()               {}
func (*ValueRange) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

type isValueRange_StartValue interface {
	isValueRange_StartValue()
}
type isValueRange_EndValue interface {
	isValueRange_EndValue()
}

type ValueRange_StartValueInclusive struct {
	StartValueInclusive []byte `protobuf:"bytes,1,opt,name=start_value_inclusive,proto3,oneof"`
}
type ValueRange_StartValueExclusive struct {
	StartValueExclusive []byte `protobuf:"bytes,2,opt,name=start_value_exclusive,proto3,oneof"`
}
type ValueRange_EndValueInclusive struct {
	EndValueInclusive []byte `protobuf:"bytes,3,opt,name=end_value_inclusive,proto3,oneof"`
}
type ValueRange_EndValueExclusive struct {
	EndValueExclusive []byte `protobuf:"bytes,4,opt,name=end_value_exclusive,proto3,oneof"`
}

func (*ValueRange_StartValueInclusive) isValueRange_StartValue() {}
func (*ValueRange_StartValueExclusive) isValueRange_StartValue() {}
func (*ValueRange_EndValueInclusive) isValueRange_EndValue()     {}
func (*ValueRange_EndValueExclusive) isValueRange_EndValue()     {}

func (m *ValueRange) GetStartValue() isValueRange_StartValue {
	if m != nil {
		return m.StartValue
	}
	return nil
}
func (m *ValueRange) GetEndValue() isValueRange_EndValue {
	if m != nil {
		return m.EndValue
	}
	return nil
}

func (m *ValueRange) GetStartValueInclusive() []byte {
	if x, ok := m.GetStartValue().(*ValueRange_StartValueInclusive); ok {
		return x.StartValueInclusive
	}
	return nil
}

func (m *ValueRange) GetStartValueExclusive() []byte {
	if x, ok := m.GetStartValue().(*ValueRange_StartValueExclusive); ok {
		return x.StartValueExclusive
	}
	return nil
}

func (m *ValueRange) GetEndValueInclusive() []byte {
	if x, ok := m.GetEndValue().(*ValueRange_EndValueInclusive); ok {
		return x.EndValueInclusive
	}
	return nil
}

func (m *ValueRange) GetEndValueExclusive() []byte {
	if x, ok := m.GetEndValue().(*ValueRange_EndValueExclusive); ok {
		return x.EndValueExclusive
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*ValueRange) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), []interface{}) {
	return _ValueRange_OneofMarshaler, _ValueRange_OneofUnmarshaler, []interface{}{
		(*ValueRange_StartValueInclusive)(nil),
		(*ValueRange_StartValueExclusive)(nil),
		(*ValueRange_EndValueInclusive)(nil),
		(*ValueRange_EndValueExclusive)(nil),
	}
}

func _ValueRange_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*ValueRange)
	// start_value
	switch x := m.StartValue.(type) {
	case *ValueRange_StartValueInclusive:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.StartValueInclusive)
	case *ValueRange_StartValueExclusive:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.StartValueExclusive)
	case nil:
	default:
		return fmt.Errorf("ValueRange.StartValue has unexpected type %T", x)
	}
	// end_value
	switch x := m.EndValue.(type) {
	case *ValueRange_EndValueInclusive:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.EndValueInclusive)
	case *ValueRange_EndValueExclusive:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.EndValueExclusive)
	case nil:
	default:
		return fmt.Errorf("ValueRange.EndValue has unexpected type %T", x)
	}
	return nil
}

func _ValueRange_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*ValueRange)
	switch tag {
	case 1: // start_value.start_value_inclusive
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.StartValue = &ValueRange_StartValueInclusive{x}
		return true, err
	case 2: // start_value.start_value_exclusive
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.StartValue = &ValueRange_StartValueExclusive{x}
		return true, err
	case 3: // end_value.end_value_inclusive
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.EndValue = &ValueRange_EndValueInclusive{x}
		return true, err
	case 4: // end_value.end_value_exclusive
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.EndValue = &ValueRange_EndValueExclusive{x}
		return true, err
	default:
		return false, nil
	}
}

// Takes a row as input and produces an alternate view of the row based on
// specified rules. For example, a RowFilter might trim down a row to include
// just the cells from columns matching a given regular expression, or might
// return all the cells of a row but not their values. More complicated filters
// can be composed out of these components to express requests such as, "within
// every column of a particular family, give just the two most recent cells
// which are older than timestamp X."
//
// There are two broad categories of RowFilters (true filters and transformers),
// as well as two ways to compose simple filters into more complex ones
// (chains and interleaves). They work as follows:
//
// * True filters alter the input row by excluding some of its cells wholesale
// from the output row. An example of a true filter is the "value_regex_filter",
// which excludes cells whose values don't match the specified pattern. All
// regex true filters use RE2 syntax (https://github.com/google/re2/wiki/Syntax)
// in raw byte mode (RE2::Latin1), and are evaluated as full matches. An
// important point to keep in mind is that RE2(.) is equivalent by default to
// RE2([^\n]), meaning that it does not match newlines. When attempting to match
// an arbitrary byte, you should therefore use the escape sequence '\C', which
// may need to be further escaped as '\\C' in your client language.
//
// * Transformers alter the input row by changing the values of some of its
// cells in the output, without excluding them completely. Currently, the only
// supported transformer is the "strip_value_transformer", which replaces every
// cell's value with the empty string.
//
// * Chains and interleaves are described in more detail in the
// RowFilter.Chain and RowFilter.Interleave documentation.
//
// The total serialized size of a RowFilter message must not
// exceed 4096 bytes, and RowFilters may not be nested within each other
// (in Chains or Interleaves) to a depth of more than 20.
type RowFilter struct {
	// Which of the possible RowFilter types to apply. If none are set, this
	// RowFilter returns all cells in the input row.
	//
	// Types that are valid to be assigned to Filter:
	//	*RowFilter_Chain_
	//	*RowFilter_Interleave_
	//	*RowFilter_Condition_
	//	*RowFilter_Sink
	//	*RowFilter_PassAllFilter
	//	*RowFilter_BlockAllFilter
	//	*RowFilter_RowKeyRegexFilter
	//	*RowFilter_RowSampleFilter
	//	*RowFilter_FamilyNameRegexFilter
	//	*RowFilter_ColumnQualifierRegexFilter
	//	*RowFilter_ColumnRangeFilter
	//	*RowFilter_TimestampRangeFilter
	//	*RowFilter_ValueRegexFilter
	//	*RowFilter_ValueRangeFilter
	//	*RowFilter_CellsPerRowOffsetFilter
	//	*RowFilter_CellsPerRowLimitFilter
	//	*RowFilter_CellsPerColumnLimitFilter
	//	*RowFilter_StripValueTransformer
	//	*RowFilter_ApplyLabelTransformer
	Filter isRowFilter_Filter `protobuf_oneof:"filter"`
}

func (m *RowFilter) Reset()                    { *m = RowFilter{} }
func (m *RowFilter) String() string            { return proto.CompactTextString(m) }
func (*RowFilter) ProtoMessage()               {}
func (*RowFilter) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

type isRowFilter_Filter interface {
	isRowFilter_Filter()
}

type RowFilter_Chain_ struct {
	Chain *RowFilter_Chain `protobuf:"bytes,1,opt,name=chain,oneof"`
}
type RowFilter_Interleave_ struct {
	Interleave *RowFilter_Interleave `protobuf:"bytes,2,opt,name=interleave,oneof"`
}
type RowFilter_Condition_ struct {
	Condition *RowFilter_Condition `protobuf:"bytes,3,opt,name=condition,oneof"`
}
type RowFilter_Sink struct {
	Sink bool `protobuf:"varint,16,opt,name=sink,oneof"`
}
type RowFilter_PassAllFilter struct {
	PassAllFilter bool `protobuf:"varint,17,opt,name=pass_all_filter,oneof"`
}
type RowFilter_BlockAllFilter struct {
	BlockAllFilter bool `protobuf:"varint,18,opt,name=block_all_filter,oneof"`
}
type RowFilter_RowKeyRegexFilter struct {
	RowKeyRegexFilter []byte `protobuf:"bytes,4,opt,name=row_key_regex_filter,proto3,oneof"`
}
type RowFilter_RowSampleFilter struct {
	RowSampleFilter float64 `protobuf:"fixed64,14,opt,name=row_sample_filter,oneof"`
}
type RowFilter_FamilyNameRegexFilter struct {
	FamilyNameRegexFilter string `protobuf:"bytes,5,opt,name=family_name_regex_filter,oneof"`
}
type RowFilter_ColumnQualifierRegexFilter struct {
	ColumnQualifierRegexFilter []byte `protobuf:"bytes,6,opt,name=column_qualifier_regex_filter,proto3,oneof"`
}
type RowFilter_ColumnRangeFilter struct {
	ColumnRangeFilter *ColumnRange `protobuf:"bytes,7,opt,name=column_range_filter,oneof"`
}
type RowFilter_TimestampRangeFilter struct {
	TimestampRangeFilter *TimestampRange `protobuf:"bytes,8,opt,name=timestamp_range_filter,oneof"`
}
type RowFilter_ValueRegexFilter struct {
	ValueRegexFilter []byte `protobuf:"bytes,9,opt,name=value_regex_filter,proto3,oneof"`
}
type RowFilter_ValueRangeFilter struct {
	ValueRangeFilter *ValueRange `protobuf:"bytes,15,opt,name=value_range_filter,oneof"`
}
type RowFilter_CellsPerRowOffsetFilter struct {
	CellsPerRowOffsetFilter int32 `protobuf:"varint,10,opt,name=cells_per_row_offset_filter,oneof"`
}
type RowFilter_CellsPerRowLimitFilter struct {
	CellsPerRowLimitFilter int32 `protobuf:"varint,11,opt,name=cells_per_row_limit_filter,oneof"`
}
type RowFilter_CellsPerColumnLimitFilter struct {
	CellsPerColumnLimitFilter int32 `protobuf:"varint,12,opt,name=cells_per_column_limit_filter,oneof"`
}
type RowFilter_StripValueTransformer struct {
	StripValueTransformer bool `protobuf:"varint,13,opt,name=strip_value_transformer,oneof"`
}
type RowFilter_ApplyLabelTransformer struct {
	ApplyLabelTransformer string `protobuf:"bytes,19,opt,name=apply_label_transformer,oneof"`
}

func (*RowFilter_Chain_) isRowFilter_Filter()                     {}
func (*RowFilter_Interleave_) isRowFilter_Filter()                {}
func (*RowFilter_Condition_) isRowFilter_Filter()                 {}
func (*RowFilter_Sink) isRowFilter_Filter()                       {}
func (*RowFilter_PassAllFilter) isRowFilter_Filter()              {}
func (*RowFilter_BlockAllFilter) isRowFilter_Filter()             {}
func (*RowFilter_RowKeyRegexFilter) isRowFilter_Filter()          {}
func (*RowFilter_RowSampleFilter) isRowFilter_Filter()            {}
func (*RowFilter_FamilyNameRegexFilter) isRowFilter_Filter()      {}
func (*RowFilter_ColumnQualifierRegexFilter) isRowFilter_Filter() {}
func (*RowFilter_ColumnRangeFilter) isRowFilter_Filter()          {}
func (*RowFilter_TimestampRangeFilter) isRowFilter_Filter()       {}
func (*RowFilter_ValueRegexFilter) isRowFilter_Filter()           {}
func (*RowFilter_ValueRangeFilter) isRowFilter_Filter()           {}
func (*RowFilter_CellsPerRowOffsetFilter) isRowFilter_Filter()    {}
func (*RowFilter_CellsPerRowLimitFilter) isRowFilter_Filter()     {}
func (*RowFilter_CellsPerColumnLimitFilter) isRowFilter_Filter()  {}
func (*RowFilter_StripValueTransformer) isRowFilter_Filter()      {}
func (*RowFilter_ApplyLabelTransformer) isRowFilter_Filter()      {}

func (m *RowFilter) GetFilter() isRowFilter_Filter {
	if m != nil {
		return m.Filter
	}
	return nil
}

func (m *RowFilter) GetChain() *RowFilter_Chain {
	if x, ok := m.GetFilter().(*RowFilter_Chain_); ok {
		return x.Chain
	}
	return nil
}

func (m *RowFilter) GetInterleave() *RowFilter_Interleave {
	if x, ok := m.GetFilter().(*RowFilter_Interleave_); ok {
		return x.Interleave
	}
	return nil
}

func (m *RowFilter) GetCondition() *RowFilter_Condition {
	if x, ok := m.GetFilter().(*RowFilter_Condition_); ok {
		return x.Condition
	}
	return nil
}

func (m *RowFilter) GetSink() bool {
	if x, ok := m.GetFilter().(*RowFilter_Sink); ok {
		return x.Sink
	}
	return false
}

func (m *RowFilter) GetPassAllFilter() bool {
	if x, ok := m.GetFilter().(*RowFilter_PassAllFilter); ok {
		return x.PassAllFilter
	}
	return false
}

func (m *RowFilter) GetBlockAllFilter() bool {
	if x, ok := m.GetFilter().(*RowFilter_BlockAllFilter); ok {
		return x.BlockAllFilter
	}
	return false
}

func (m *RowFilter) GetRowKeyRegexFilter() []byte {
	if x, ok := m.GetFilter().(*RowFilter_RowKeyRegexFilter); ok {
		return x.RowKeyRegexFilter
	}
	return nil
}

func (m *RowFilter) GetRowSampleFilter() float64 {
	if x, ok := m.GetFilter().(*RowFilter_RowSampleFilter); ok {
		return x.RowSampleFilter
	}
	return 0
}

func (m *RowFilter) GetFamilyNameRegexFilter() string {
	if x, ok := m.GetFilter().(*RowFilter_FamilyNameRegexFilter); ok {
		return x.FamilyNameRegexFilter
	}
	return ""
}

func (m *RowFilter) GetColumnQualifierRegexFilter() []byte {
	if x, ok := m.GetFilter().(*RowFilter_ColumnQualifierRegexFilter); ok {
		return x.ColumnQualifierRegexFilter
	}
	return nil
}

func (m *RowFilter) GetColumnRangeFilter() *ColumnRange {
	if x, ok := m.GetFilter().(*RowFilter_ColumnRangeFilter); ok {
		return x.ColumnRangeFilter
	}
	return nil
}

func (m *RowFilter) GetTimestampRangeFilter() *TimestampRange {
	if x, ok := m.GetFilter().(*RowFilter_TimestampRangeFilter); ok {
		return x.TimestampRangeFilter
	}
	return nil
}

func (m *RowFilter) GetValueRegexFilter() []byte {
	if x, ok := m.GetFilter().(*RowFilter_ValueRegexFilter); ok {
		return x.ValueRegexFilter
	}
	return nil
}

func (m *RowFilter) GetValueRangeFilter() *ValueRange {
	if x, ok := m.GetFilter().(*RowFilter_ValueRangeFilter); ok {
		return x.ValueRangeFilter
	}
	return nil
}

func (m *RowFilter) GetCellsPerRowOffsetFilter() int32 {
	if x, ok := m.GetFilter().(*RowFilter_CellsPerRowOffsetFilter); ok {
		return x.CellsPerRowOffsetFilter
	}
	return 0
}

func (m *RowFilter) GetCellsPerRowLimitFilter() int32 {
	if x, ok := m.GetFilter().(*RowFilter_CellsPerRowLimitFilter); ok {
		return x.CellsPerRowLimitFilter
	}
	return 0
}

func (m *RowFilter) GetCellsPerColumnLimitFilter() int32 {
	if x, ok := m.GetFilter().(*RowFilter_CellsPerColumnLimitFilter); ok {
		return x.CellsPerColumnLimitFilter
	}
	return 0
}

func (m *RowFilter) GetStripValueTransformer() bool {
	if x, ok := m.GetFilter().(*RowFilter_StripValueTransformer); ok {
		return x.StripValueTransformer
	}
	return false
}

func (m *RowFilter) GetApplyLabelTransformer() string {
	if x, ok := m.GetFilter().(*RowFilter_ApplyLabelTransformer); ok {
		return x.ApplyLabelTransformer
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*RowFilter) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), []interface{}) {
	return _RowFilter_OneofMarshaler, _RowFilter_OneofUnmarshaler, []interface{}{
		(*RowFilter_Chain_)(nil),
		(*RowFilter_Interleave_)(nil),
		(*RowFilter_Condition_)(nil),
		(*RowFilter_Sink)(nil),
		(*RowFilter_PassAllFilter)(nil),
		(*RowFilter_BlockAllFilter)(nil),
		(*RowFilter_RowKeyRegexFilter)(nil),
		(*RowFilter_RowSampleFilter)(nil),
		(*RowFilter_FamilyNameRegexFilter)(nil),
		(*RowFilter_ColumnQualifierRegexFilter)(nil),
		(*RowFilter_ColumnRangeFilter)(nil),
		(*RowFilter_TimestampRangeFilter)(nil),
		(*RowFilter_ValueRegexFilter)(nil),
		(*RowFilter_ValueRangeFilter)(nil),
		(*RowFilter_CellsPerRowOffsetFilter)(nil),
		(*RowFilter_CellsPerRowLimitFilter)(nil),
		(*RowFilter_CellsPerColumnLimitFilter)(nil),
		(*RowFilter_StripValueTransformer)(nil),
		(*RowFilter_ApplyLabelTransformer)(nil),
	}
}

func _RowFilter_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*RowFilter)
	// filter
	switch x := m.Filter.(type) {
	case *RowFilter_Chain_:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Chain); err != nil {
			return err
		}
	case *RowFilter_Interleave_:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Interleave); err != nil {
			return err
		}
	case *RowFilter_Condition_:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Condition); err != nil {
			return err
		}
	case *RowFilter_Sink:
		t := uint64(0)
		if x.Sink {
			t = 1
		}
		b.EncodeVarint(16<<3 | proto.WireVarint)
		b.EncodeVarint(t)
	case *RowFilter_PassAllFilter:
		t := uint64(0)
		if x.PassAllFilter {
			t = 1
		}
		b.EncodeVarint(17<<3 | proto.WireVarint)
		b.EncodeVarint(t)
	case *RowFilter_BlockAllFilter:
		t := uint64(0)
		if x.BlockAllFilter {
			t = 1
		}
		b.EncodeVarint(18<<3 | proto.WireVarint)
		b.EncodeVarint(t)
	case *RowFilter_RowKeyRegexFilter:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.RowKeyRegexFilter)
	case *RowFilter_RowSampleFilter:
		b.EncodeVarint(14<<3 | proto.WireFixed64)
		b.EncodeFixed64(math.Float64bits(x.RowSampleFilter))
	case *RowFilter_FamilyNameRegexFilter:
		b.EncodeVarint(5<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.FamilyNameRegexFilter)
	case *RowFilter_ColumnQualifierRegexFilter:
		b.EncodeVarint(6<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.ColumnQualifierRegexFilter)
	case *RowFilter_ColumnRangeFilter:
		b.EncodeVarint(7<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ColumnRangeFilter); err != nil {
			return err
		}
	case *RowFilter_TimestampRangeFilter:
		b.EncodeVarint(8<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TimestampRangeFilter); err != nil {
			return err
		}
	case *RowFilter_ValueRegexFilter:
		b.EncodeVarint(9<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.ValueRegexFilter)
	case *RowFilter_ValueRangeFilter:
		b.EncodeVarint(15<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ValueRangeFilter); err != nil {
			return err
		}
	case *RowFilter_CellsPerRowOffsetFilter:
		b.EncodeVarint(10<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.CellsPerRowOffsetFilter))
	case *RowFilter_CellsPerRowLimitFilter:
		b.EncodeVarint(11<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.CellsPerRowLimitFilter))
	case *RowFilter_CellsPerColumnLimitFilter:
		b.EncodeVarint(12<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.CellsPerColumnLimitFilter))
	case *RowFilter_StripValueTransformer:
		t := uint64(0)
		if x.StripValueTransformer {
			t = 1
		}
		b.EncodeVarint(13<<3 | proto.WireVarint)
		b.EncodeVarint(t)
	case *RowFilter_ApplyLabelTransformer:
		b.EncodeVarint(19<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.ApplyLabelTransformer)
	case nil:
	default:
		return fmt.Errorf("RowFilter.Filter has unexpected type %T", x)
	}
	return nil
}

func _RowFilter_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*RowFilter)
	switch tag {
	case 1: // filter.chain
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RowFilter_Chain)
		err := b.DecodeMessage(msg)
		m.Filter = &RowFilter_Chain_{msg}
		return true, err
	case 2: // filter.interleave
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RowFilter_Interleave)
		err := b.DecodeMessage(msg)
		m.Filter = &RowFilter_Interleave_{msg}
		return true, err
	case 3: // filter.condition
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RowFilter_Condition)
		err := b.DecodeMessage(msg)
		m.Filter = &RowFilter_Condition_{msg}
		return true, err
	case 16: // filter.sink
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Filter = &RowFilter_Sink{x != 0}
		return true, err
	case 17: // filter.pass_all_filter
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Filter = &RowFilter_PassAllFilter{x != 0}
		return true, err
	case 18: // filter.block_all_filter
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Filter = &RowFilter_BlockAllFilter{x != 0}
		return true, err
	case 4: // filter.row_key_regex_filter
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.Filter = &RowFilter_RowKeyRegexFilter{x}
		return true, err
	case 14: // filter.row_sample_filter
		if wire != proto.WireFixed64 {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeFixed64()
		m.Filter = &RowFilter_RowSampleFilter{math.Float64frombits(x)}
		return true, err
	case 5: // filter.family_name_regex_filter
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Filter = &RowFilter_FamilyNameRegexFilter{x}
		return true, err
	case 6: // filter.column_qualifier_regex_filter
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.Filter = &RowFilter_ColumnQualifierRegexFilter{x}
		return true, err
	case 7: // filter.column_range_filter
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ColumnRange)
		err := b.DecodeMessage(msg)
		m.Filter = &RowFilter_ColumnRangeFilter{msg}
		return true, err
	case 8: // filter.timestamp_range_filter
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(TimestampRange)
		err := b.DecodeMessage(msg)
		m.Filter = &RowFilter_TimestampRangeFilter{msg}
		return true, err
	case 9: // filter.value_regex_filter
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.Filter = &RowFilter_ValueRegexFilter{x}
		return true, err
	case 15: // filter.value_range_filter
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ValueRange)
		err := b.DecodeMessage(msg)
		m.Filter = &RowFilter_ValueRangeFilter{msg}
		return true, err
	case 10: // filter.cells_per_row_offset_filter
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Filter = &RowFilter_CellsPerRowOffsetFilter{int32(x)}
		return true, err
	case 11: // filter.cells_per_row_limit_filter
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Filter = &RowFilter_CellsPerRowLimitFilter{int32(x)}
		return true, err
	case 12: // filter.cells_per_column_limit_filter
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Filter = &RowFilter_CellsPerColumnLimitFilter{int32(x)}
		return true, err
	case 13: // filter.strip_value_transformer
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Filter = &RowFilter_StripValueTransformer{x != 0}
		return true, err
	case 19: // filter.apply_label_transformer
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Filter = &RowFilter_ApplyLabelTransformer{x}
		return true, err
	default:
		return false, nil
	}
}

// A RowFilter which sends rows through several RowFilters in sequence.
type RowFilter_Chain struct {
	// The elements of "filters" are chained together to process the input row:
	// in row -> f(0) -> intermediate row -> f(1) -> ... -> f(N) -> out row
	// The full chain is executed atomically.
	Filters []*RowFilter `protobuf:"bytes,1,rep,name=filters" json:"filters,omitempty"`
}

func (m *RowFilter_Chain) Reset()                    { *m = RowFilter_Chain{} }
func (m *RowFilter_Chain) String() string            { return proto.CompactTextString(m) }
func (*RowFilter_Chain) ProtoMessage()               {}
func (*RowFilter_Chain) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8, 0} }

func (m *RowFilter_Chain) GetFilters() []*RowFilter {
	if m != nil {
		return m.Filters
	}
	return nil
}

// A RowFilter which sends each row to each of several component
// RowFilters and interleaves the results.
type RowFilter_Interleave struct {
	// The elements of "filters" all process a copy of the input row, and the
	// results are pooled, sorted, and combined into a single output row.
	// If multiple cells are produced with the same column and timestamp,
	// they will all appear in the output row in an unspecified mutual order.
	// Consider the following example, with three filters:
	//
	//                              input row
	//                                  |
	//        -----------------------------------------------------
	//        |                         |                         |
	//       f(0)                      f(1)                      f(2)
	//        |                         |                         |
	// 1: foo,bar,10,x             foo,bar,10,z              far,bar,7,a
	// 2: foo,blah,11,z            far,blah,5,x              far,blah,5,x
	//        |                         |                         |
	//        -----------------------------------------------------
	//                                  |
	// 1:                        foo,bar,10,z     // could have switched with #2
	// 2:                        foo,bar,10,x     // could have switched with #1
	// 3:                        foo,blah,11,z
	// 4:                        far,bar,7,a
	// 5:                        far,blah,5,x     // identical to #6
	// 6:                        far,blah,5,x     // identical to #5
	// All interleaved filters are executed atomically.
	Filters []*RowFilter `protobuf:"bytes,1,rep,name=filters" json:"filters,omitempty"`
}

func (m *RowFilter_Interleave) Reset()                    { *m = RowFilter_Interleave{} }
func (m *RowFilter_Interleave) String() string            { return proto.CompactTextString(m) }
func (*RowFilter_Interleave) ProtoMessage()               {}
func (*RowFilter_Interleave) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8, 1} }

func (m *RowFilter_Interleave) GetFilters() []*RowFilter {
	if m != nil {
		return m.Filters
	}
	return nil
}

// A RowFilter which evaluates one of two possible RowFilters, depending on
// whether or not a predicate RowFilter outputs any cells from the input row.
//
// IMPORTANT NOTE: The predicate filter does not execute atomically with the
// true and false filters, which may lead to inconsistent or unexpected
// results. Additionally, Condition filters have poor performance, especially
// when filters are set for the false condition.
type RowFilter_Condition struct {
	// If "predicate_filter" outputs any cells, then "true_filter" will be
	// evaluated on the input row. Otherwise, "false_filter" will be evaluated.
	PredicateFilter *RowFilter `protobuf:"bytes,1,opt,name=predicate_filter" json:"predicate_filter,omitempty"`
	// The filter to apply to the input row if "predicate_filter" returns any
	// results. If not provided, no results will be returned in the true case.
	TrueFilter *RowFilter `protobuf:"bytes,2,opt,name=true_filter" json:"true_filter,omitempty"`
	// The filter to apply to the input row if "predicate_filter" does not
	// return any results. If not provided, no results will be returned in the
	// false case.
	FalseFilter *RowFilter `protobuf:"bytes,3,opt,name=false_filter" json:"false_filter,omitempty"`
}

func (m *RowFilter_Condition) Reset()                    { *m = RowFilter_Condition{} }
func (m *RowFilter_Condition) String() string            { return proto.CompactTextString(m) }
func (*RowFilter_Condition) ProtoMessage()               {}
func (*RowFilter_Condition) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8, 2} }

func (m *RowFilter_Condition) GetPredicateFilter() *RowFilter {
	if m != nil {
		return m.PredicateFilter
	}
	return nil
}

func (m *RowFilter_Condition) GetTrueFilter() *RowFilter {
	if m != nil {
		return m.TrueFilter
	}
	return nil
}

func (m *RowFilter_Condition) GetFalseFilter() *RowFilter {
	if m != nil {
		return m.FalseFilter
	}
	return nil
}

// Specifies a particular change to be made to the contents of a row.
type Mutation struct {
	// Which of the possible Mutation types to apply.
	//
	// Types that are valid to be assigned to Mutation:
	//	*Mutation_SetCell_
	//	*Mutation_DeleteFromColumn_
	//	*Mutation_DeleteFromFamily_
	//	*Mutation_DeleteFromRow_
	Mutation isMutation_Mutation `protobuf_oneof:"mutation"`
}

func (m *Mutation) Reset()                    { *m = Mutation{} }
func (m *Mutation) String() string            { return proto.CompactTextString(m) }
func (*Mutation) ProtoMessage()               {}
func (*Mutation) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

type isMutation_Mutation interface {
	isMutation_Mutation()
}

type Mutation_SetCell_ struct {
	SetCell *Mutation_SetCell `protobuf:"bytes,1,opt,name=set_cell,oneof"`
}
type Mutation_DeleteFromColumn_ struct {
	DeleteFromColumn *Mutation_DeleteFromColumn `protobuf:"bytes,2,opt,name=delete_from_column,oneof"`
}
type Mutation_DeleteFromFamily_ struct {
	DeleteFromFamily *Mutation_DeleteFromFamily `protobuf:"bytes,3,opt,name=delete_from_family,oneof"`
}
type Mutation_DeleteFromRow_ struct {
	DeleteFromRow *Mutation_DeleteFromRow `protobuf:"bytes,4,opt,name=delete_from_row,oneof"`
}

func (*Mutation_SetCell_) isMutation_Mutation()          {}
func (*Mutation_DeleteFromColumn_) isMutation_Mutation() {}
func (*Mutation_DeleteFromFamily_) isMutation_Mutation() {}
func (*Mutation_DeleteFromRow_) isMutation_Mutation()    {}

func (m *Mutation) GetMutation() isMutation_Mutation {
	if m != nil {
		return m.Mutation
	}
	return nil
}

func (m *Mutation) GetSetCell() *Mutation_SetCell {
	if x, ok := m.GetMutation().(*Mutation_SetCell_); ok {
		return x.SetCell
	}
	return nil
}

func (m *Mutation) GetDeleteFromColumn() *Mutation_DeleteFromColumn {
	if x, ok := m.GetMutation().(*Mutation_DeleteFromColumn_); ok {
		return x.DeleteFromColumn
	}
	return nil
}

func (m *Mutation) GetDeleteFromFamily() *Mutation_DeleteFromFamily {
	if x, ok := m.GetMutation().(*Mutation_DeleteFromFamily_); ok {
		return x.DeleteFromFamily
	}
	return nil
}

func (m *Mutation) GetDeleteFromRow() *Mutation_DeleteFromRow {
	if x, ok := m.GetMutation().(*Mutation_DeleteFromRow_); ok {
		return x.DeleteFromRow
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Mutation) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), []interface{}) {
	return _Mutation_OneofMarshaler, _Mutation_OneofUnmarshaler, []interface{}{
		(*Mutation_SetCell_)(nil),
		(*Mutation_DeleteFromColumn_)(nil),
		(*Mutation_DeleteFromFamily_)(nil),
		(*Mutation_DeleteFromRow_)(nil),
	}
}

func _Mutation_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Mutation)
	// mutation
	switch x := m.Mutation.(type) {
	case *Mutation_SetCell_:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.SetCell); err != nil {
			return err
		}
	case *Mutation_DeleteFromColumn_:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.DeleteFromColumn); err != nil {
			return err
		}
	case *Mutation_DeleteFromFamily_:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.DeleteFromFamily); err != nil {
			return err
		}
	case *Mutation_DeleteFromRow_:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.DeleteFromRow); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Mutation.Mutation has unexpected type %T", x)
	}
	return nil
}

func _Mutation_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Mutation)
	switch tag {
	case 1: // mutation.set_cell
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Mutation_SetCell)
		err := b.DecodeMessage(msg)
		m.Mutation = &Mutation_SetCell_{msg}
		return true, err
	case 2: // mutation.delete_from_column
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Mutation_DeleteFromColumn)
		err := b.DecodeMessage(msg)
		m.Mutation = &Mutation_DeleteFromColumn_{msg}
		return true, err
	case 3: // mutation.delete_from_family
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Mutation_DeleteFromFamily)
		err := b.DecodeMessage(msg)
		m.Mutation = &Mutation_DeleteFromFamily_{msg}
		return true, err
	case 4: // mutation.delete_from_row
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Mutation_DeleteFromRow)
		err := b.DecodeMessage(msg)
		m.Mutation = &Mutation_DeleteFromRow_{msg}
		return true, err
	default:
		return false, nil
	}
}

// A Mutation which sets the value of the specified cell.
type Mutation_SetCell struct {
	// The name of the family into which new data should be written.
	// Must match [-_.a-zA-Z0-9]+
	FamilyName string `protobuf:"bytes,1,opt,name=family_name" json:"family_name,omitempty"`
	// The qualifier of the column into which new data should be written.
	// Can be any byte string, including the empty string.
	ColumnQualifier []byte `protobuf:"bytes,2,opt,name=column_qualifier,proto3" json:"column_qualifier,omitempty"`
	// The timestamp of the cell into which new data should be written.
	// Use -1 for current Bigtable server time.
	// Otherwise, the client should set this value itself, noting that the
	// default value is a timestamp of zero if the field is left unspecified.
	// Values must match the "granularity" of the table (e.g. micros, millis).
	TimestampMicros int64 `protobuf:"varint,3,opt,name=timestamp_micros" json:"timestamp_micros,omitempty"`
	// The value to be written into the specified cell.
	Value []byte `protobuf:"bytes,4,opt,name=value,proto3" json:"value,omitempty"`
}

func (m *Mutation_SetCell) Reset()                    { *m = Mutation_SetCell{} }
func (m *Mutation_SetCell) String() string            { return proto.CompactTextString(m) }
func (*Mutation_SetCell) ProtoMessage()               {}
func (*Mutation_SetCell) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9, 0} }

// A Mutation which deletes cells from the specified column, optionally
// restricting the deletions to a given timestamp range.
type Mutation_DeleteFromColumn struct {
	// The name of the family from which cells should be deleted.
	// Must match [-_.a-zA-Z0-9]+
	FamilyName string `protobuf:"bytes,1,opt,name=family_name" json:"family_name,omitempty"`
	// The qualifier of the column from which cells should be deleted.
	// Can be any byte string, including the empty string.
	ColumnQualifier []byte `protobuf:"bytes,2,opt,name=column_qualifier,proto3" json:"column_qualifier,omitempty"`
	// The range of timestamps within which cells should be deleted.
	TimeRange *TimestampRange `protobuf:"bytes,3,opt,name=time_range" json:"time_range,omitempty"`
}

func (m *Mutation_DeleteFromColumn) Reset()                    { *m = Mutation_DeleteFromColumn{} }
func (m *Mutation_DeleteFromColumn) String() string            { return proto.CompactTextString(m) }
func (*Mutation_DeleteFromColumn) ProtoMessage()               {}
func (*Mutation_DeleteFromColumn) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9, 1} }

func (m *Mutation_DeleteFromColumn) GetTimeRange() *TimestampRange {
	if m != nil {
		return m.TimeRange
	}
	return nil
}

// A Mutation which deletes all cells from the specified column family.
type Mutation_DeleteFromFamily struct {
	// The name of the family from which cells should be deleted.
	// Must match [-_.a-zA-Z0-9]+
	FamilyName string `protobuf:"bytes,1,opt,name=family_name" json:"family_name,omitempty"`
}

func (m *Mutation_DeleteFromFamily) Reset()                    { *m = Mutation_DeleteFromFamily{} }
func (m *Mutation_DeleteFromFamily) String() string            { return proto.CompactTextString(m) }
func (*Mutation_DeleteFromFamily) ProtoMessage()               {}
func (*Mutation_DeleteFromFamily) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9, 2} }

// A Mutation which deletes all cells from the containing row.
type Mutation_DeleteFromRow struct {
}

func (m *Mutation_DeleteFromRow) Reset()                    { *m = Mutation_DeleteFromRow{} }
func (m *Mutation_DeleteFromRow) String() string            { return proto.CompactTextString(m) }
func (*Mutation_DeleteFromRow) ProtoMessage()               {}
func (*Mutation_DeleteFromRow) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9, 3} }

// Specifies an atomic read/modify/write operation on the latest value of the
// specified column.
type ReadModifyWriteRule struct {
	// The name of the family to which the read/modify/write should be applied.
	// Must match [-_.a-zA-Z0-9]+
	FamilyName string `protobuf:"bytes,1,opt,name=family_name" json:"family_name,omitempty"`
	// The qualifier of the column to which the read/modify/write should be
	// applied.
	// Can be any byte string, including the empty string.
	ColumnQualifier []byte `protobuf:"bytes,2,opt,name=column_qualifier,proto3" json:"column_qualifier,omitempty"`
	// The rule used to determine the column's new latest value from its current
	// latest value.
	//
	// Types that are valid to be assigned to Rule:
	//	*ReadModifyWriteRule_AppendValue
	//	*ReadModifyWriteRule_IncrementAmount
	Rule isReadModifyWriteRule_Rule `protobuf_oneof:"rule"`
}

func (m *ReadModifyWriteRule) Reset()                    { *m = ReadModifyWriteRule{} }
func (m *ReadModifyWriteRule) String() string            { return proto.CompactTextString(m) }
func (*ReadModifyWriteRule) ProtoMessage()               {}
func (*ReadModifyWriteRule) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

type isReadModifyWriteRule_Rule interface {
	isReadModifyWriteRule_Rule()
}

type ReadModifyWriteRule_AppendValue struct {
	AppendValue []byte `protobuf:"bytes,3,opt,name=append_value,proto3,oneof"`
}
type ReadModifyWriteRule_IncrementAmount struct {
	IncrementAmount int64 `protobuf:"varint,4,opt,name=increment_amount,oneof"`
}

func (*ReadModifyWriteRule_AppendValue) isReadModifyWriteRule_Rule()     {}
func (*ReadModifyWriteRule_IncrementAmount) isReadModifyWriteRule_Rule() {}

func (m *ReadModifyWriteRule) GetRule() isReadModifyWriteRule_Rule {
	if m != nil {
		return m.Rule
	}
	return nil
}

func (m *ReadModifyWriteRule) GetAppendValue() []byte {
	if x, ok := m.GetRule().(*ReadModifyWriteRule_AppendValue); ok {
		return x.AppendValue
	}
	return nil
}

func (m *ReadModifyWriteRule) GetIncrementAmount() int64 {
	if x, ok := m.GetRule().(*ReadModifyWriteRule_IncrementAmount); ok {
		return x.IncrementAmount
	}
	return 0
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*ReadModifyWriteRule) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), []interface{}) {
	return _ReadModifyWriteRule_OneofMarshaler, _ReadModifyWriteRule_OneofUnmarshaler, []interface{}{
		(*ReadModifyWriteRule_AppendValue)(nil),
		(*ReadModifyWriteRule_IncrementAmount)(nil),
	}
}

func _ReadModifyWriteRule_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*ReadModifyWriteRule)
	// rule
	switch x := m.Rule.(type) {
	case *ReadModifyWriteRule_AppendValue:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.AppendValue)
	case *ReadModifyWriteRule_IncrementAmount:
		b.EncodeVarint(4<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.IncrementAmount))
	case nil:
	default:
		return fmt.Errorf("ReadModifyWriteRule.Rule has unexpected type %T", x)
	}
	return nil
}

func _ReadModifyWriteRule_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*ReadModifyWriteRule)
	switch tag {
	case 3: // rule.append_value
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.Rule = &ReadModifyWriteRule_AppendValue{x}
		return true, err
	case 4: // rule.increment_amount
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Rule = &ReadModifyWriteRule_IncrementAmount{int64(x)}
		return true, err
	default:
		return false, nil
	}
}

func init() {
	proto.RegisterType((*Row)(nil), "google.bigtable.v1.Row")
	proto.RegisterType((*Family)(nil), "google.bigtable.v1.Family")
	proto.RegisterType((*Column)(nil), "google.bigtable.v1.Column")
	proto.RegisterType((*Cell)(nil), "google.bigtable.v1.Cell")
	proto.RegisterType((*RowRange)(nil), "google.bigtable.v1.RowRange")
	proto.RegisterType((*ColumnRange)(nil), "google.bigtable.v1.ColumnRange")
	proto.RegisterType((*TimestampRange)(nil), "google.bigtable.v1.TimestampRange")
	proto.RegisterType((*ValueRange)(nil), "google.bigtable.v1.ValueRange")
	proto.RegisterType((*RowFilter)(nil), "google.bigtable.v1.RowFilter")
	proto.RegisterType((*RowFilter_Chain)(nil), "google.bigtable.v1.RowFilter.Chain")
	proto.RegisterType((*RowFilter_Interleave)(nil), "google.bigtable.v1.RowFilter.Interleave")
	proto.RegisterType((*RowFilter_Condition)(nil), "google.bigtable.v1.RowFilter.Condition")
	proto.RegisterType((*Mutation)(nil), "google.bigtable.v1.Mutation")
	proto.RegisterType((*Mutation_SetCell)(nil), "google.bigtable.v1.Mutation.SetCell")
	proto.RegisterType((*Mutation_DeleteFromColumn)(nil), "google.bigtable.v1.Mutation.DeleteFromColumn")
	proto.RegisterType((*Mutation_DeleteFromFamily)(nil), "google.bigtable.v1.Mutation.DeleteFromFamily")
	proto.RegisterType((*Mutation_DeleteFromRow)(nil), "google.bigtable.v1.Mutation.DeleteFromRow")
	proto.RegisterType((*ReadModifyWriteRule)(nil), "google.bigtable.v1.ReadModifyWriteRule")
}

var fileDescriptor0 = []byte{
	// 1053 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0x94, 0x56, 0xdf, 0x72, 0xdb, 0xd4,
	0x13, 0xae, 0x2a, 0xc7, 0xb1, 0x57, 0x49, 0x9c, 0xc8, 0xfd, 0xe5, 0xe7, 0xba, 0x4d, 0x5a, 0xd4,
	0x32, 0xc9, 0x00, 0x55, 0x06, 0x97, 0xa1, 0x5c, 0x64, 0x0a, 0xa3, 0x84, 0x4c, 0x18, 0xa6, 0x4c,
	0x27, 0x30, 0x70, 0xa9, 0x39, 0xb6, 0x8f, 0xcd, 0x99, 0x1c, 0xe9, 0x18, 0x49, 0x4e, 0xeb, 0x3b,
	0x1e, 0x87, 0x1b, 0x1e, 0x84, 0x17, 0xe0, 0x96, 0x57, 0x61, 0xcf, 0x1f, 0xc9, 0x96, 0xa3, 0x1a,
	0xe7, 0x2a, 0xb1, 0xf6, 0xdb, 0x6f, 0x77, 0xbf, 0xb3, 0xbb, 0xe7, 0xc0, 0xe5, 0x58, 0x88, 0x31,
	0xa7, 0xfe, 0x58, 0x70, 0x12, 0x8f, 0x7d, 0x91, 0x8c, 0x4f, 0x06, 0x5c, 0x4c, 0x87, 0x27, 0x7d,
	0x36, 0xce, 0x48, 0x9f, 0xd3, 0x13, 0x16, 0x67, 0x34, 0x89, 0x09, 0x3f, 0x19, 0x92, 0x8c, 0x84,
	0x93, 0x44, 0x64, 0xa2, 0x30, 0x86, 0xf2, 0x9b, 0xaf, 0xbe, 0xb9, 0xae, 0x61, 0xca, 0x6d, 0xfe,
	0xcd, 0xe7, 0xde, 0x37, 0x60, 0x5f, 0x89, 0x77, 0xae, 0x03, 0xf6, 0x35, 0x9d, 0x75, 0xac, 0xa7,
	0xd6, 0xf1, 0x96, 0xfb, 0x19, 0x34, 0x46, 0x24, 0x62, 0x9c, 0xd1, 0xb4, 0x73, 0xff, 0xa9, 0x7d,
	0xec, 0xf4, 0xba, 0xfe, 0x6d, 0x57, 0xff, 0x42, 0x62, 0x66, 0xde, 0x19, 0xd4, 0xf5, 0x7f, 0xee,
	0x16, 0xd4, 0x62, 0x12, 0x51, 0xc5, 0xd2, 0x74, 0x3f, 0x85, 0xcd, 0x81, 0xe0, 0xd3, 0x28, 0x5e,
	0x49, 0x72, 0xa6, 0x20, 0xde, 0x39, 0xd4, 0xf5, 0x7f, 0xee, 0x1e, 0x34, 0x7f, 0x9b, 0x12, 0xce,
	0x46, 0x8c, 0x26, 0x26, 0x9f, 0x23, 0xd8, 0x18, 0x50, 0xce, 0x73, 0x9e, 0x4e, 0x25, 0x0f, 0x02,
	0xbc, 0xaf, 0xa1, 0x26, 0xff, 0xba, 0x1d, 0xd8, 0xcd, 0x58, 0x44, 0xd3, 0x8c, 0x44, 0x93, 0x30,
	0x62, 0x83, 0x44, 0xa4, 0x8a, 0xca, 0x76, 0xb7, 0x61, 0xe3, 0x86, 0xf0, 0x29, 0x45, 0x2a, 0xc9,
	0xbc, 0x03, 0x75, 0x4e, 0xfa, 0x14, 0xa9, 0x6d, 0xa4, 0x6e, 0x7a, 0x3e, 0x34, 0x50, 0x8d, 0x2b,
	0xd4, 0x99, 0xca, 0x44, 0x90, 0x20, 0xc9, 0x42, 0x29, 0x8c, 0x86, 0xb7, 0x60, 0x93, 0xc6, 0x43,
	0xf5, 0xc1, 0x96, 0x1f, 0xbc, 0xbf, 0x2d, 0x70, 0x74, 0xde, 0xda, 0xa7, 0x0d, 0x8e, 0x52, 0x6e,
	0x16, 0x2e, 0x08, 0xf1, 0x0c, 0x1e, 0x6a, 0xa2, 0xa2, 0xae, 0x90, 0xc5, 0x03, 0x3e, 0x4d, 0xd9,
	0x8d, 0xc9, 0xe3, 0xf2, 0x5e, 0x15, 0x88, 0xbe, 0xcf, 0x41, 0xb6, 0x01, 0x7d, 0x04, 0xff, 0x97,
	0xf1, 0xab, 0x78, 0x6a, 0x0a, 0x62, 0xdd, 0x86, 0xcc, 0x59, 0x36, 0x34, 0x24, 0xd8, 0x83, 0xd6,
	0x52, 0xa8, 0xa0, 0x05, 0xdb, 0x25, 0x2f, 0xef, 0x07, 0xd8, 0xf9, 0x29, 0x57, 0x50, 0x97, 0x76,
	0x08, 0xfb, 0xda, 0xeb, 0x03, 0xca, 0x3e, 0x86, 0x07, 0x92, 0xe2, 0x96, 0x55, 0x16, 0x68, 0x7b,
	0x7f, 0x58, 0x00, 0x3f, 0x4b, 0xe1, 0x35, 0xd9, 0x13, 0xf8, 0x9f, 0x26, 0x53, 0x87, 0xb1, 0x50,
	0x86, 0x65, 0x2a, 0x5d, 0x02, 0xcc, 0x8b, 0xc8, 0xf5, 0x3a, 0x80, 0xb6, 0x0c, 0xb7, 0xec, 0x6f,
	0x1b, 0x19, 0x4a, 0xe6, 0xb9, 0xb7, 0x51, 0x29, 0xd8, 0x06, 0x67, 0x81, 0x3e, 0x70, 0xa0, 0x59,
	0xa0, 0xbd, 0x7f, 0x1a, 0xd0, 0xc4, 0x26, 0xb8, 0x60, 0x1c, 0xa7, 0xca, 0xfd, 0x02, 0x7b, 0xef,
	0x57, 0xc2, 0x62, 0x95, 0x99, 0xd3, 0x7b, 0x56, 0xd5, 0x7b, 0x05, 0xda, 0x3f, 0x93, 0x50, 0xcc,
	0xee, 0x35, 0x80, 0x1a, 0x4a, 0x4e, 0x89, 0xc9, 0xd9, 0xe9, 0x1d, 0xaf, 0x76, 0xfd, 0xae, 0xc0,
	0xa3, 0xff, 0x29, 0x34, 0x07, 0x22, 0x1e, 0xb2, 0x8c, 0x89, 0x58, 0xd5, 0xe4, 0xf4, 0x8e, 0xfe,
	0x23, 0x72, 0x0e, 0x47, 0xef, 0x1d, 0xa8, 0xa5, 0x2c, 0xbe, 0xee, 0xec, 0xa2, 0x63, 0x03, 0x7f,
	0x3f, 0x84, 0xd6, 0x84, 0xa4, 0x69, 0x48, 0x38, 0x0f, 0x47, 0x0a, 0xde, 0xd9, 0x33, 0xa6, 0x2e,
	0xec, 0xf6, 0xb9, 0x18, 0x5c, 0x2f, 0xda, 0x5c, 0x63, 0x3b, 0x84, 0x07, 0x89, 0x78, 0x27, 0xbb,
	0x3d, 0x4c, 0xe8, 0x98, 0xbe, 0xcf, 0xed, 0x35, 0x73, 0x04, 0x8f, 0x60, 0x4f, 0xda, 0x53, 0x3c,
	0x6c, 0xdc, 0x33, 0xc6, 0xb8, 0x83, 0x46, 0x0b, 0x8d, 0x1e, 0x74, 0x16, 0x26, 0xa1, 0x4c, 0x20,
	0x1b, 0xb1, 0x89, 0x98, 0x23, 0x38, 0xd0, 0x1b, 0x62, 0xa1, 0x5d, 0x4b, 0xc0, 0xba, 0x89, 0xf4,
	0x1a, 0xda, 0x06, 0x98, 0xc8, 0xf6, 0xc9, 0xcd, 0x9b, 0x4a, 0x98, 0x27, 0x1f, 0x5e, 0x2b, 0xaa,
	0xd9, 0xd0, 0xff, 0x1c, 0xf6, 0xe7, 0x7d, 0x59, 0xa2, 0x68, 0x28, 0x0a, 0xaf, 0x8a, 0xa2, 0xdc,
	0xff, 0xc8, 0xf2, 0x18, 0x5c, 0xdd, 0x4f, 0xa5, 0x1c, 0x9b, 0x26, 0xc7, 0xd3, 0xc2, 0xba, 0xc8,
	0xdf, 0x52, 0xfc, 0x87, 0x55, 0xfc, 0xf3, 0x71, 0x40, 0xef, 0x8f, 0xe1, 0x91, 0x5a, 0x71, 0xe1,
	0x44, 0x6a, 0x80, 0xaa, 0x8a, 0xd1, 0x28, 0xa5, 0x59, 0x4e, 0x03, 0x48, 0xb3, 0x81, 0xb0, 0xe7,
	0xd0, 0x2d, 0xc3, 0x38, 0x8b, 0x58, 0x81, 0x72, 0x0c, 0x4a, 0xea, 0x5a, 0xa0, 0x8c, 0x70, 0x25,
	0xe0, 0x96, 0x01, 0xe2, 0xb2, 0x48, 0xb3, 0x84, 0x4d, 0xcc, 0x9c, 0x64, 0x98, 0x7a, 0x3a, 0x12,
	0x49, 0x84, 0x90, 0x6d, 0xd3, 0x04, 0x08, 0x21, 0x93, 0x09, 0x1e, 0xa3, 0xda, 0x93, 0x25, 0x48,
	0x5b, 0x1f, 0x63, 0xf7, 0x15, 0x6c, 0xa8, 0xbe, 0x77, 0x7d, 0xd8, 0xd4, 0x01, 0xe4, 0x4e, 0x90,
	0x9b, 0xfa, 0x60, 0x65, 0xcf, 0x76, 0x4f, 0x01, 0xe6, 0x5d, 0x7f, 0x67, 0xef, 0x3f, 0x2d, 0x68,
	0x16, 0x5d, 0xef, 0xbe, 0x82, 0xdd, 0x49, 0x42, 0x87, 0x6c, 0x40, 0xb2, 0x42, 0x7c, 0x3d, 0xb2,
	0xab, 0x69, 0xdc, 0x1e, 0x38, 0x59, 0x32, 0x2d, 0x7c, 0xee, 0xaf, 0xe3, 0xf3, 0x12, 0xb6, 0x46,
	0x84, 0xa7, 0x85, 0x93, 0xbd, 0x86, 0x53, 0xd0, 0x80, 0xba, 0x86, 0x7b, 0x7f, 0xd5, 0xa0, 0xf1,
	0x66, 0x9a, 0x11, 0x95, 0xf8, 0x57, 0xd0, 0x90, 0x07, 0x2d, 0x0f, 0xcc, 0x24, 0xfc, 0xbc, 0x8a,
	0x27, 0xc7, 0xfb, 0x3f, 0xd2, 0x4c, 0xde, 0x71, 0x78, 0x34, 0xdf, 0x83, 0x3b, 0xa4, 0x9c, 0xca,
	0x7a, 0x13, 0x11, 0x99, 0x83, 0x36, 0x05, 0xbc, 0x58, 0xc9, 0x71, 0xae, 0xdc, 0x2e, 0xd0, 0x4b,
	0xcf, 0xc9, 0x6d, 0x32, 0x3d, 0xbb, 0xa6, 0xb0, 0x75, 0xc9, 0xf4, 0x33, 0x00, 0xc9, 0xbe, 0x85,
	0xd6, 0x22, 0x19, 0x36, 0xaa, 0x5a, 0x1a, 0x4e, 0xef, 0x93, 0x35, 0x99, 0x50, 0x35, 0x6c, 0x2c,
	0x02, 0x9b, 0xa6, 0xda, 0xea, 0x8b, 0x15, 0xaf, 0xf9, 0xe5, 0xfd, 0x61, 0x2e, 0xea, 0xaa, 0x07,
	0x80, 0x5d, 0x7e, 0x00, 0xa8, 0x2d, 0xd6, 0x9d, 0xc1, 0xee, 0xb2, 0x18, 0x77, 0x8d, 0xf5, 0x25,
	0x80, 0x8c, 0xa5, 0xe7, 0xde, 0x28, 0xb6, 0xc6, 0x42, 0xe9, 0x1e, 0x2d, 0x86, 0x36, 0x2f, 0xa8,
	0xaa, 0xd0, 0x5d, 0xbc, 0x9c, 0x4b, 0xca, 0x04, 0x00, 0x8d, 0xc8, 0x68, 0xe6, 0xfd, 0x6e, 0x41,
	0xfb, 0x8a, 0x92, 0xe1, 0x1b, 0x31, 0x64, 0xa3, 0xd9, 0x2f, 0x09, 0xcb, 0xe8, 0xd5, 0x94, 0xd3,
	0xbb, 0x16, 0xb1, 0x0f, 0x5b, 0x38, 0xe6, 0xc5, 0x25, 0x58, 0xbc, 0x38, 0xf0, 0x7e, 0xc0, 0xcb,
	0x35, 0xa1, 0x11, 0x8d, 0xb3, 0x90, 0x44, 0x62, 0x1a, 0x67, 0x4a, 0x39, 0xfb, 0xf2, 0x5e, 0x50,
	0x87, 0x5a, 0x82, 0xa1, 0x82, 0x17, 0xb0, 0x3f, 0x10, 0x51, 0x45, 0xc5, 0xc1, 0x5e, 0x60, 0x7e,
	0x9c, 0xe3, 0x23, 0xf4, 0xad, 0x7c, 0x83, 0xbe, 0xb5, 0xfa, 0x75, 0xf5, 0x18, 0x7d, 0xf9, 0x6f,
	0x00, 0x00, 0x00, 0xff, 0xff, 0x98, 0x49, 0x33, 0xa8, 0xd8, 0x0a, 0x00, 0x00,
}
