// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by aliasgen. DO NOT EDIT.

// Package spanner aliases all exported identifiers in package
// "cloud.google.com/go/spanner/apiv1/spannerpb".
//
// Deprecated: Please use types in: cloud.google.com/go/spanner/apiv1/spannerpb.
// Please read https://github.com/googleapis/google-cloud-go/blob/main/migration.md
// for more details.
package spanner

import (
	src "cloud.google.com/go/spanner/apiv1/spannerpb"
	grpc "google.golang.org/grpc"
)

// Deprecated: Please use consts in: cloud.google.com/go/spanner/apiv1/spannerpb
const (
	ExecuteSqlRequest_NORMAL                                = src.ExecuteSqlRequest_NORMAL
	ExecuteSqlRequest_PLAN                                  = src.ExecuteSqlRequest_PLAN
	ExecuteSqlRequest_PROFILE                               = src.ExecuteSqlRequest_PROFILE
	PlanNode_KIND_UNSPECIFIED                               = src.PlanNode_KIND_UNSPECIFIED
	PlanNode_RELATIONAL                                     = src.PlanNode_RELATIONAL
	PlanNode_SCALAR                                         = src.PlanNode_SCALAR
	RequestOptions_PRIORITY_HIGH                            = src.RequestOptions_PRIORITY_HIGH
	RequestOptions_PRIORITY_LOW                             = src.RequestOptions_PRIORITY_LOW
	RequestOptions_PRIORITY_MEDIUM                          = src.RequestOptions_PRIORITY_MEDIUM
	RequestOptions_PRIORITY_UNSPECIFIED                     = src.RequestOptions_PRIORITY_UNSPECIFIED
	TransactionOptions_ReadWrite_OPTIMISTIC                 = src.TransactionOptions_ReadWrite_OPTIMISTIC
	TransactionOptions_ReadWrite_PESSIMISTIC                = src.TransactionOptions_ReadWrite_PESSIMISTIC
	TransactionOptions_ReadWrite_READ_LOCK_MODE_UNSPECIFIED = src.TransactionOptions_ReadWrite_READ_LOCK_MODE_UNSPECIFIED
	TypeAnnotationCode_PG_JSONB                             = src.TypeAnnotationCode_PG_JSONB
	TypeAnnotationCode_PG_NUMERIC                           = src.TypeAnnotationCode_PG_NUMERIC
	TypeAnnotationCode_TYPE_ANNOTATION_CODE_UNSPECIFIED     = src.TypeAnnotationCode_TYPE_ANNOTATION_CODE_UNSPECIFIED
	TypeCode_ARRAY                                          = src.TypeCode_ARRAY
	TypeCode_BOOL                                           = src.TypeCode_BOOL
	TypeCode_BYTES                                          = src.TypeCode_BYTES
	TypeCode_DATE                                           = src.TypeCode_DATE
	TypeCode_FLOAT64                                        = src.TypeCode_FLOAT64
	TypeCode_INT64                                          = src.TypeCode_INT64
	TypeCode_JSON                                           = src.TypeCode_JSON
	TypeCode_NUMERIC                                        = src.TypeCode_NUMERIC
	TypeCode_STRING                                         = src.TypeCode_STRING
	TypeCode_STRUCT                                         = src.TypeCode_STRUCT
	TypeCode_TIMESTAMP                                      = src.TypeCode_TIMESTAMP
	TypeCode_TYPE_CODE_UNSPECIFIED                          = src.TypeCode_TYPE_CODE_UNSPECIFIED
)

// Deprecated: Please use vars in: cloud.google.com/go/spanner/apiv1/spannerpb
var (
	ExecuteSqlRequest_QueryMode_name                = src.ExecuteSqlRequest_QueryMode_name
	ExecuteSqlRequest_QueryMode_value               = src.ExecuteSqlRequest_QueryMode_value
	File_google_spanner_v1_commit_response_proto    = src.File_google_spanner_v1_commit_response_proto
	File_google_spanner_v1_keys_proto               = src.File_google_spanner_v1_keys_proto
	File_google_spanner_v1_mutation_proto           = src.File_google_spanner_v1_mutation_proto
	File_google_spanner_v1_query_plan_proto         = src.File_google_spanner_v1_query_plan_proto
	File_google_spanner_v1_result_set_proto         = src.File_google_spanner_v1_result_set_proto
	File_google_spanner_v1_spanner_proto            = src.File_google_spanner_v1_spanner_proto
	File_google_spanner_v1_transaction_proto        = src.File_google_spanner_v1_transaction_proto
	File_google_spanner_v1_type_proto               = src.File_google_spanner_v1_type_proto
	PlanNode_Kind_name                              = src.PlanNode_Kind_name
	PlanNode_Kind_value                             = src.PlanNode_Kind_value
	RequestOptions_Priority_name                    = src.RequestOptions_Priority_name
	RequestOptions_Priority_value                   = src.RequestOptions_Priority_value
	TransactionOptions_ReadWrite_ReadLockMode_name  = src.TransactionOptions_ReadWrite_ReadLockMode_name
	TransactionOptions_ReadWrite_ReadLockMode_value = src.TransactionOptions_ReadWrite_ReadLockMode_value
	TypeAnnotationCode_name                         = src.TypeAnnotationCode_name
	TypeAnnotationCode_value                        = src.TypeAnnotationCode_value
	TypeCode_name                                   = src.TypeCode_name
	TypeCode_value                                  = src.TypeCode_value
)

// The request for
// [BatchCreateSessions][google.spanner.v1.Spanner.BatchCreateSessions].
//
// Deprecated: Please use types in: cloud.google.com/go/spanner/apiv1/spannerpb
type BatchCreateSessionsRequest = src.BatchCreateSessionsRequest

// The response for
// [BatchCreateSessions][google.spanner.v1.Spanner.BatchCreateSessions].
//
// Deprecated: Please use types in: cloud.google.com/go/spanner/apiv1/spannerpb
type BatchCreateSessionsResponse = src.BatchCreateSessionsResponse

// The request for
// [BeginTransaction][google.spanner.v1.Spanner.BeginTransaction].
//
// Deprecated: Please use types in: cloud.google.com/go/spanner/apiv1/spannerpb
type BeginTransactionRequest = src.BeginTransactionRequest

// The request for [Commit][google.spanner.v1.Spanner.Commit].
//
// Deprecated: Please use types in: cloud.google.com/go/spanner/apiv1/spannerpb
type CommitRequest = src.CommitRequest
type CommitRequest_SingleUseTransaction = src.CommitRequest_SingleUseTransaction
type CommitRequest_TransactionId = src.CommitRequest_TransactionId

// The response for [Commit][google.spanner.v1.Spanner.Commit].
//
// Deprecated: Please use types in: cloud.google.com/go/spanner/apiv1/spannerpb
type CommitResponse = src.CommitResponse

// Additional statistics about a commit.
//
// Deprecated: Please use types in: cloud.google.com/go/spanner/apiv1/spannerpb
type CommitResponse_CommitStats = src.CommitResponse_CommitStats

// The request for [CreateSession][google.spanner.v1.Spanner.CreateSession].
//
// Deprecated: Please use types in: cloud.google.com/go/spanner/apiv1/spannerpb
type CreateSessionRequest = src.CreateSessionRequest

// The request for [DeleteSession][google.spanner.v1.Spanner.DeleteSession].
//
// Deprecated: Please use types in: cloud.google.com/go/spanner/apiv1/spannerpb
type DeleteSessionRequest = src.DeleteSessionRequest

// The request for
// [ExecuteBatchDml][google.spanner.v1.Spanner.ExecuteBatchDml].
//
// Deprecated: Please use types in: cloud.google.com/go/spanner/apiv1/spannerpb
type ExecuteBatchDmlRequest = src.ExecuteBatchDmlRequest

// A single DML statement.
//
// Deprecated: Please use types in: cloud.google.com/go/spanner/apiv1/spannerpb
type ExecuteBatchDmlRequest_Statement = src.ExecuteBatchDmlRequest_Statement

// The response for
// [ExecuteBatchDml][google.spanner.v1.Spanner.ExecuteBatchDml]. Contains a
// list of [ResultSet][google.spanner.v1.ResultSet] messages, one for each DML
// statement that has successfully executed, in the same order as the
// statements in the request. If a statement fails, the status in the response
// body identifies the cause of the failure. To check for DML statements that
// failed, use the following approach: 1. Check the status in the response
// message. The [google.rpc.Code][google.rpc.Code] enum value `OK` indicates
// that all statements were executed successfully. 2. If the status was not
// `OK`, check the number of result sets in the response. If the response
// contains `N` [ResultSet][google.spanner.v1.ResultSet] messages, then
// statement `N+1` in the request failed. Example 1: * Request: 5 DML
// statements, all executed successfully. * Response: 5
// [ResultSet][google.spanner.v1.ResultSet] messages, with the status `OK`.
// Example 2: - Request: 5 DML statements. The third statement has a syntax
// error. - Response: 2 [ResultSet][google.spanner.v1.ResultSet] messages, and
// a syntax error (`INVALID_ARGUMENT`) status. The number of
// [ResultSet][google.spanner.v1.ResultSet] messages indicates that the third
// statement failed, and the fourth and fifth statements were not executed.
//
// Deprecated: Please use types in: cloud.google.com/go/spanner/apiv1/spannerpb
type ExecuteBatchDmlResponse = src.ExecuteBatchDmlResponse

// The request for [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql] and
// [ExecuteStreamingSql][google.spanner.v1.Spanner.ExecuteStreamingSql].
//
// Deprecated: Please use types in: cloud.google.com/go/spanner/apiv1/spannerpb
type ExecuteSqlRequest = src.ExecuteSqlRequest

// Mode in which the statement must be processed.
//
// Deprecated: Please use types in: cloud.google.com/go/spanner/apiv1/spannerpb
type ExecuteSqlRequest_QueryMode = src.ExecuteSqlRequest_QueryMode

// Query optimizer configuration.
//
// Deprecated: Please use types in: cloud.google.com/go/spanner/apiv1/spannerpb
type ExecuteSqlRequest_QueryOptions = src.ExecuteSqlRequest_QueryOptions

// The request for [GetSession][google.spanner.v1.Spanner.GetSession].
//
// Deprecated: Please use types in: cloud.google.com/go/spanner/apiv1/spannerpb
type GetSessionRequest = src.GetSessionRequest

// KeyRange represents a range of rows in a table or index. A range has a
// start key and an end key. These keys can be open or closed, indicating if
// the range includes rows with that key. Keys are represented by lists, where
// the ith value in the list corresponds to the ith component of the table or
// index primary key. Individual values are encoded as described
// [here][google.spanner.v1.TypeCode]. For example, consider the following
// table definition: CREATE TABLE UserEvents ( UserName STRING(MAX), EventDate
// STRING(10) ) PRIMARY KEY(UserName, EventDate); The following keys name rows
// in this table: ["Bob", "2014-09-23"] ["Alfred", "2015-06-12"] Since the
// `UserEvents` table's `PRIMARY KEY` clause names two columns, each
// `UserEvents` key has two elements; the first is the `UserName`, and the
// second is the `EventDate`. Key ranges with multiple components are
// interpreted lexicographically by component using the table or index key's
// declared sort order. For example, the following range returns all events for
// user `"Bob"` that occurred in the year 2015: "start_closed": ["Bob",
// "2015-01-01"] "end_closed": ["Bob", "2015-12-31"] Start and end keys can
// omit trailing key components. This affects the inclusion and exclusion of
// rows that exactly match the provided key components: if the key is closed,
// then rows that exactly match the provided components are included; if the
// key is open, then rows that exactly match are not included. For example, the
// following range includes all events for `"Bob"` that occurred during and
// after the year 2000: "start_closed": ["Bob", "2000-01-01"] "end_closed":
// ["Bob"] The next example retrieves all events for `"Bob"`: "start_closed":
// ["Bob"] "end_closed": ["Bob"] To retrieve events before the year 2000:
// "start_closed": ["Bob"] "end_open": ["Bob", "2000-01-01"] The following
// range includes all rows in the table: "start_closed": [] "end_closed": []
// This range returns all users whose `UserName` begins with any character from
// A to C: "start_closed": ["A"] "end_open": ["D"] This range returns all users
// whose `UserName` begins with B: "start_closed": ["B"] "end_open": ["C"] Key
// ranges honor column sort order. For example, suppose a table is defined as
// follows: CREATE TABLE DescendingSortedTable { Key INT64, ... ) PRIMARY
// KEY(Key DESC); The following range retrieves all rows with key values
// between 1 and 100 inclusive: "start_closed": ["100"] "end_closed": ["1"]
// Note that 100 is passed as the start, and 1 is passed as the end, because
// `Key` is a descending column in the schema.
//
// Deprecated: Please use types in: cloud.google.com/go/spanner/apiv1/spannerpb
type KeyRange = src.KeyRange
type KeyRange_EndClosed = src.KeyRange_EndClosed
type KeyRange_EndOpen = src.KeyRange_EndOpen
type KeyRange_StartClosed = src.KeyRange_StartClosed
type KeyRange_StartOpen = src.KeyRange_StartOpen

// `KeySet` defines a collection of Cloud Spanner keys and/or key ranges. All
// the keys are expected to be in the same table or index. The keys need not be
// sorted in any particular way. If the same key is specified multiple times in
// the set (for example if two ranges, two keys, or a key and a range overlap),
// Cloud Spanner behaves as if the key were only specified once.
//
// Deprecated: Please use types in: cloud.google.com/go/spanner/apiv1/spannerpb
type KeySet = src.KeySet

// The request for [ListSessions][google.spanner.v1.Spanner.ListSessions].
//
// Deprecated: Please use types in: cloud.google.com/go/spanner/apiv1/spannerpb
type ListSessionsRequest = src.ListSessionsRequest

// The response for [ListSessions][google.spanner.v1.Spanner.ListSessions].
//
// Deprecated: Please use types in: cloud.google.com/go/spanner/apiv1/spannerpb
type ListSessionsResponse = src.ListSessionsResponse

// A modification to one or more Cloud Spanner rows. Mutations can be applied
// to a Cloud Spanner database by sending them in a
// [Commit][google.spanner.v1.Spanner.Commit] call.
//
// Deprecated: Please use types in: cloud.google.com/go/spanner/apiv1/spannerpb
type Mutation = src.Mutation

// Arguments to [delete][google.spanner.v1.Mutation.delete] operations.
//
// Deprecated: Please use types in: cloud.google.com/go/spanner/apiv1/spannerpb
type Mutation_Delete = src.Mutation_Delete
type Mutation_Delete_ = src.Mutation_Delete_
type Mutation_Insert = src.Mutation_Insert
type Mutation_InsertOrUpdate = src.Mutation_InsertOrUpdate
type Mutation_Replace = src.Mutation_Replace
type Mutation_Update = src.Mutation_Update

// Arguments to [insert][google.spanner.v1.Mutation.insert],
// [update][google.spanner.v1.Mutation.update],
// [insert_or_update][google.spanner.v1.Mutation.insert_or_update], and
// [replace][google.spanner.v1.Mutation.replace] operations.
//
// Deprecated: Please use types in: cloud.google.com/go/spanner/apiv1/spannerpb
type Mutation_Write = src.Mutation_Write

// Partial results from a streaming read or SQL query. Streaming reads and SQL
// queries better tolerate large result sets, large rows, and large values, but
// are a little trickier to consume.
//
// Deprecated: Please use types in: cloud.google.com/go/spanner/apiv1/spannerpb
type PartialResultSet = src.PartialResultSet

// Information returned for each partition returned in a PartitionResponse.
//
// Deprecated: Please use types in: cloud.google.com/go/spanner/apiv1/spannerpb
type Partition = src.Partition

// Options for a PartitionQueryRequest and PartitionReadRequest.
//
// Deprecated: Please use types in: cloud.google.com/go/spanner/apiv1/spannerpb
type PartitionOptions = src.PartitionOptions

// The request for [PartitionQuery][google.spanner.v1.Spanner.PartitionQuery]
//
// Deprecated: Please use types in: cloud.google.com/go/spanner/apiv1/spannerpb
type PartitionQueryRequest = src.PartitionQueryRequest

// The request for [PartitionRead][google.spanner.v1.Spanner.PartitionRead]
//
// Deprecated: Please use types in: cloud.google.com/go/spanner/apiv1/spannerpb
type PartitionReadRequest = src.PartitionReadRequest

// The response for [PartitionQuery][google.spanner.v1.Spanner.PartitionQuery]
// or [PartitionRead][google.spanner.v1.Spanner.PartitionRead]
//
// Deprecated: Please use types in: cloud.google.com/go/spanner/apiv1/spannerpb
type PartitionResponse = src.PartitionResponse

// Node information for nodes appearing in a
// [QueryPlan.plan_nodes][google.spanner.v1.QueryPlan.plan_nodes].
//
// Deprecated: Please use types in: cloud.google.com/go/spanner/apiv1/spannerpb
type PlanNode = src.PlanNode

// Metadata associated with a parent-child relationship appearing in a
// [PlanNode][google.spanner.v1.PlanNode].
//
// Deprecated: Please use types in: cloud.google.com/go/spanner/apiv1/spannerpb
type PlanNode_ChildLink = src.PlanNode_ChildLink

// The kind of [PlanNode][google.spanner.v1.PlanNode]. Distinguishes between
// the two different kinds of nodes that can appear in a query plan.
//
// Deprecated: Please use types in: cloud.google.com/go/spanner/apiv1/spannerpb
type PlanNode_Kind = src.PlanNode_Kind

// Condensed representation of a node and its subtree. Only present for
// `SCALAR` [PlanNode(s)][google.spanner.v1.PlanNode].
//
// Deprecated: Please use types in: cloud.google.com/go/spanner/apiv1/spannerpb
type PlanNode_ShortRepresentation = src.PlanNode_ShortRepresentation

// Contains an ordered list of nodes appearing in the query plan.
//
// Deprecated: Please use types in: cloud.google.com/go/spanner/apiv1/spannerpb
type QueryPlan = src.QueryPlan

// The request for [Read][google.spanner.v1.Spanner.Read] and
// [StreamingRead][google.spanner.v1.Spanner.StreamingRead].
//
// Deprecated: Please use types in: cloud.google.com/go/spanner/apiv1/spannerpb
type ReadRequest = src.ReadRequest

// Common request options for various APIs.
//
// Deprecated: Please use types in: cloud.google.com/go/spanner/apiv1/spannerpb
type RequestOptions = src.RequestOptions

// The relative priority for requests. Note that priority is not applicable
// for [BeginTransaction][google.spanner.v1.Spanner.BeginTransaction]. The
// priority acts as a hint to the Cloud Spanner scheduler and does not
// guarantee priority or order of execution. For example: - Some parts of a
// write operation always execute at `PRIORITY_HIGH`, regardless of the
// specified priority. This may cause you to see an increase in high priority
// workload even when executing a low priority request. This can also
// potentially cause a priority inversion where a lower priority request will
// be fulfilled ahead of a higher priority request. - If a transaction contains
// multiple operations with different priorities, Cloud Spanner does not
// guarantee to process the higher priority operations first. There may be
// other constraints to satisfy, such as order of operations.
//
// Deprecated: Please use types in: cloud.google.com/go/spanner/apiv1/spannerpb
type RequestOptions_Priority = src.RequestOptions_Priority

// Results from [Read][google.spanner.v1.Spanner.Read] or
// [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql].
//
// Deprecated: Please use types in: cloud.google.com/go/spanner/apiv1/spannerpb
type ResultSet = src.ResultSet

// Metadata about a [ResultSet][google.spanner.v1.ResultSet] or
// [PartialResultSet][google.spanner.v1.PartialResultSet].
//
// Deprecated: Please use types in: cloud.google.com/go/spanner/apiv1/spannerpb
type ResultSetMetadata = src.ResultSetMetadata

// Additional statistics about a [ResultSet][google.spanner.v1.ResultSet] or
// [PartialResultSet][google.spanner.v1.PartialResultSet].
//
// Deprecated: Please use types in: cloud.google.com/go/spanner/apiv1/spannerpb
type ResultSetStats = src.ResultSetStats
type ResultSetStats_RowCountExact = src.ResultSetStats_RowCountExact
type ResultSetStats_RowCountLowerBound = src.ResultSetStats_RowCountLowerBound

// The request for [Rollback][google.spanner.v1.Spanner.Rollback].
//
// Deprecated: Please use types in: cloud.google.com/go/spanner/apiv1/spannerpb
type RollbackRequest = src.RollbackRequest

// A session in the Cloud Spanner API.
//
// Deprecated: Please use types in: cloud.google.com/go/spanner/apiv1/spannerpb
type Session = src.Session

// SpannerClient is the client API for Spanner service. For semantics around
// ctx use and closing/ending streaming RPCs, please refer to
// https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
//
// Deprecated: Please use types in: cloud.google.com/go/spanner/apiv1/spannerpb
type SpannerClient = src.SpannerClient

// SpannerServer is the server API for Spanner service.
//
// Deprecated: Please use types in: cloud.google.com/go/spanner/apiv1/spannerpb
type SpannerServer = src.SpannerServer
type Spanner_ExecuteStreamingSqlClient = src.Spanner_ExecuteStreamingSqlClient
type Spanner_ExecuteStreamingSqlServer = src.Spanner_ExecuteStreamingSqlServer
type Spanner_StreamingReadClient = src.Spanner_StreamingReadClient
type Spanner_StreamingReadServer = src.Spanner_StreamingReadServer

// `StructType` defines the fields of a
// [STRUCT][google.spanner.v1.TypeCode.STRUCT] type.
//
// Deprecated: Please use types in: cloud.google.com/go/spanner/apiv1/spannerpb
type StructType = src.StructType

// Message representing a single field of a struct.
//
// Deprecated: Please use types in: cloud.google.com/go/spanner/apiv1/spannerpb
type StructType_Field = src.StructType_Field

// A transaction.
//
// Deprecated: Please use types in: cloud.google.com/go/spanner/apiv1/spannerpb
type Transaction = src.Transaction

// Transactions: Each session can have at most one active transaction at a
// time (note that standalone reads and queries use a transaction internally
// and do count towards the one transaction limit). After the active
// transaction is completed, the session can immediately be re-used for the
// next transaction. It is not necessary to create a new session for each
// transaction. Transaction modes: Cloud Spanner supports three transaction
// modes: 1. Locking read-write. This type of transaction is the only way to
// write data into Cloud Spanner. These transactions rely on pessimistic
// locking and, if necessary, two-phase commit. Locking read-write transactions
// may abort, requiring the application to retry. 2. Snapshot read-only.
// Snapshot read-only transactions provide guaranteed consistency across
// several reads, but do not allow writes. Snapshot read-only transactions can
// be configured to read at timestamps in the past, or configured to perform a
// strong read (where Spanner will select a timestamp such that the read is
// guaranteed to see the effects of all transactions that have committed before
// the start of the read). Snapshot read-only transactions do not need to be
// committed. Queries on change streams must be performed with the snapshot
// read-only transaction mode, specifying a strong read. Please see
// [TransactionOptions.ReadOnly.strong][google.spanner.v1.TransactionOptions.ReadOnly.strong]
// for more details. 3. Partitioned DML. This type of transaction is used to
// execute a single Partitioned DML statement. Partitioned DML partitions the
// key space and runs the DML statement over each partition in parallel using
// separate, internal transactions that commit independently. Partitioned DML
// transactions do not need to be committed. For transactions that only read,
// snapshot read-only transactions provide simpler semantics and are almost
// always faster. In particular, read-only transactions do not take locks, so
// they do not conflict with read-write transactions. As a consequence of not
// taking locks, they also do not abort, so retry loops are not needed.
// Transactions may only read-write data in a single database. They may,
// however, read-write data in different tables within that database. Locking
// read-write transactions: Locking transactions may be used to atomically
// read-modify-write data anywhere in a database. This type of transaction is
// externally consistent. Clients should attempt to minimize the amount of time
// a transaction is active. Faster transactions commit with higher probability
// and cause less contention. Cloud Spanner attempts to keep read locks active
// as long as the transaction continues to do reads, and the transaction has
// not been terminated by [Commit][google.spanner.v1.Spanner.Commit] or
// [Rollback][google.spanner.v1.Spanner.Rollback]. Long periods of inactivity
// at the client may cause Cloud Spanner to release a transaction's locks and
// abort it. Conceptually, a read-write transaction consists of zero or more
// reads or SQL statements followed by
// [Commit][google.spanner.v1.Spanner.Commit]. At any time before
// [Commit][google.spanner.v1.Spanner.Commit], the client can send a
// [Rollback][google.spanner.v1.Spanner.Rollback] request to abort the
// transaction. Semantics: Cloud Spanner can commit the transaction if all read
// locks it acquired are still valid at commit time, and it is able to acquire
// write locks for all writes. Cloud Spanner can abort the transaction for any
// reason. If a commit attempt returns `ABORTED`, Cloud Spanner guarantees that
// the transaction has not modified any user data in Cloud Spanner. Unless the
// transaction commits, Cloud Spanner makes no guarantees about how long the
// transaction's locks were held for. It is an error to use Cloud Spanner locks
// for any sort of mutual exclusion other than between Cloud Spanner
// transactions themselves. Retrying aborted transactions: When a transaction
// aborts, the application can choose to retry the whole transaction again. To
// maximize the chances of successfully committing the retry, the client should
// execute the retry in the same session as the original attempt. The original
// session's lock priority increases with each consecutive abort, meaning that
// each attempt has a slightly better chance of success than the previous.
// Under some circumstances (for example, many transactions attempting to
// modify the same row(s)), a transaction can abort many times in a short
// period before successfully committing. Thus, it is not a good idea to cap
// the number of retries a transaction can attempt; instead, it is better to
// limit the total amount of time spent retrying. Idle transactions: A
// transaction is considered idle if it has no outstanding reads or SQL queries
// and has not started a read or SQL query within the last 10 seconds. Idle
// transactions can be aborted by Cloud Spanner so that they don't hold on to
// locks indefinitely. If an idle transaction is aborted, the commit will fail
// with error `ABORTED`. If this behavior is undesirable, periodically
// executing a simple SQL query in the transaction (for example, `SELECT 1`)
// prevents the transaction from becoming idle. Snapshot read-only
// transactions: Snapshot read-only transactions provides a simpler method than
// locking read-write transactions for doing several consistent reads. However,
// this type of transaction does not support writes. Snapshot transactions do
// not take locks. Instead, they work by choosing a Cloud Spanner timestamp,
// then executing all reads at that timestamp. Since they do not acquire locks,
// they do not block concurrent read-write transactions. Unlike locking
// read-write transactions, snapshot read-only transactions never abort. They
// can fail if the chosen read timestamp is garbage collected; however, the
// default garbage collection policy is generous enough that most applications
// do not need to worry about this in practice. Snapshot read-only transactions
// do not need to call [Commit][google.spanner.v1.Spanner.Commit] or
// [Rollback][google.spanner.v1.Spanner.Rollback] (and in fact are not
// permitted to do so). To execute a snapshot transaction, the client specifies
// a timestamp bound, which tells Cloud Spanner how to choose a read timestamp.
// The types of timestamp bound are: - Strong (the default). - Bounded
// staleness. - Exact staleness. If the Cloud Spanner database to be read is
// geographically distributed, stale read-only transactions can execute more
// quickly than strong or read-write transactions, because they are able to
// execute far from the leader replica. Each type of timestamp bound is
// discussed in detail below. Strong: Strong reads are guaranteed to see the
// effects of all transactions that have committed before the start of the
// read. Furthermore, all rows yielded by a single read are consistent with
// each other -- if any part of the read observes a transaction, all parts of
// the read see the transaction. Strong reads are not repeatable: two
// consecutive strong read-only transactions might return inconsistent results
// if there are concurrent writes. If consistency across reads is required, the
// reads should be executed within a transaction or at an exact read timestamp.
// Queries on change streams (see below for more details) must also specify the
// strong read timestamp bound. See
// [TransactionOptions.ReadOnly.strong][google.spanner.v1.TransactionOptions.ReadOnly.strong].
// Exact staleness: These timestamp bounds execute reads at a user-specified
// timestamp. Reads at a timestamp are guaranteed to see a consistent prefix of
// the global transaction history: they observe modifications done by all
// transactions with a commit timestamp less than or equal to the read
// timestamp, and observe none of the modifications done by transactions with a
// larger commit timestamp. They will block until all conflicting transactions
// that may be assigned commit timestamps <= the read timestamp have finished.
// The timestamp can either be expressed as an absolute Cloud Spanner commit
// timestamp or a staleness relative to the current time. These modes do not
// require a "negotiation phase" to pick a timestamp. As a result, they execute
// slightly faster than the equivalent boundedly stale concurrency modes. On
// the other hand, boundedly stale reads usually return fresher results. See
// [TransactionOptions.ReadOnly.read_timestamp][google.spanner.v1.TransactionOptions.ReadOnly.read_timestamp]
// and
// [TransactionOptions.ReadOnly.exact_staleness][google.spanner.v1.TransactionOptions.ReadOnly.exact_staleness].
// Bounded staleness: Bounded staleness modes allow Cloud Spanner to pick the
// read timestamp, subject to a user-provided staleness bound. Cloud Spanner
// chooses the newest timestamp within the staleness bound that allows
// execution of the reads at the closest available replica without blocking.
// All rows yielded are consistent with each other -- if any part of the read
// observes a transaction, all parts of the read see the transaction. Boundedly
// stale reads are not repeatable: two stale reads, even if they use the same
// staleness bound, can execute at different timestamps and thus return
// inconsistent results. Boundedly stale reads execute in two phases: the first
// phase negotiates a timestamp among all replicas needed to serve the read. In
// the second phase, reads are executed at the negotiated timestamp. As a
// result of the two phase execution, bounded staleness reads are usually a
// little slower than comparable exact staleness reads. However, they are
// typically able to return fresher results, and are more likely to execute at
// the closest replica. Because the timestamp negotiation requires up-front
// knowledge of which rows will be read, it can only be used with single-use
// read-only transactions. See
// [TransactionOptions.ReadOnly.max_staleness][google.spanner.v1.TransactionOptions.ReadOnly.max_staleness]
// and
// [TransactionOptions.ReadOnly.min_read_timestamp][google.spanner.v1.TransactionOptions.ReadOnly.min_read_timestamp].
// Old read timestamps and garbage collection: Cloud Spanner continuously
// garbage collects deleted and overwritten data in the background to reclaim
// storage space. This process is known as "version GC". By default, version GC
// reclaims versions after they are one hour old. Because of this, Cloud
// Spanner cannot perform reads at read timestamps more than one hour in the
// past. This restriction also applies to in-progress reads and/or SQL queries
// whose timestamp become too old while executing. Reads and SQL queries with
// too-old read timestamps fail with the error `FAILED_PRECONDITION`. You can
// configure and extend the `VERSION_RETENTION_PERIOD` of a database up to a
// period as long as one week, which allows Cloud Spanner to perform reads up
// to one week in the past. Querying change Streams: A Change Stream is a
// schema object that can be configured to watch data changes on the entire
// database, a set of tables, or a set of columns in a database. When a change
// stream is created, Spanner automatically defines a corresponding SQL
// Table-Valued Function (TVF) that can be used to query the change records in
// the associated change stream using the ExecuteStreamingSql API. The name of
// the TVF for a change stream is generated from the name of the change stream:
// READ_<change_stream_name>. All queries on change stream TVFs must be
// executed using the ExecuteStreamingSql API with a single-use read-only
// transaction with a strong read-only timestamp_bound. The change stream TVF
// allows users to specify the start_timestamp and end_timestamp for the time
// range of interest. All change records within the retention period is
// accessible using the strong read-only timestamp_bound. All other
// TransactionOptions are invalid for change stream queries. In addition, if
// TransactionOptions.read_only.return_read_timestamp is set to true, a special
// value of 2^63 - 2 will be returned in the
// [Transaction][google.spanner.v1.Transaction] message that describes the
// transaction, instead of a valid read timestamp. This special value should be
// discarded and not used for any subsequent queries. Please see
// https://cloud.google.com/spanner/docs/change-streams for more details on how
// to query the change stream TVFs. Partitioned DML transactions: Partitioned
// DML transactions are used to execute DML statements with a different
// execution strategy that provides different, and often better, scalability
// properties for large, table-wide operations than DML in a ReadWrite
// transaction. Smaller scoped statements, such as an OLTP workload, should
// prefer using ReadWrite transactions. Partitioned DML partitions the keyspace
// and runs the DML statement on each partition in separate, internal
// transactions. These transactions commit automatically when complete, and run
// independently from one another. To reduce lock contention, this execution
// strategy only acquires read locks on rows that match the WHERE clause of the
// statement. Additionally, the smaller per-partition transactions hold locks
// for less time. That said, Partitioned DML is not a drop-in replacement for
// standard DML used in ReadWrite transactions. - The DML statement must be
// fully-partitionable. Specifically, the statement must be expressible as the
// union of many statements which each access only a single row of the table. -
// The statement is not applied atomically to all rows of the table. Rather,
// the statement is applied atomically to partitions of the table, in
// independent transactions. Secondary index rows are updated atomically with
// the base table rows. - Partitioned DML does not guarantee exactly-once
// execution semantics against a partition. The statement will be applied at
// least once to each partition. It is strongly recommended that the DML
// statement should be idempotent to avoid unexpected results. For instance, it
// is potentially dangerous to run a statement such as `UPDATE table SET column
// = column + 1` as it could be run multiple times against some rows. - The
// partitions are committed automatically - there is no support for Commit or
// Rollback. If the call returns an error, or if the client issuing the
// ExecuteSql call dies, it is possible that some rows had the statement
// executed on them successfully. It is also possible that statement was never
// executed against other rows. - Partitioned DML transactions may only contain
// the execution of a single DML statement via ExecuteSql or
// ExecuteStreamingSql. - If any error is encountered during the execution of
// the partitioned DML operation (for instance, a UNIQUE INDEX violation,
// division by zero, or a value that cannot be stored due to schema
// constraints), then the operation is stopped at that point and an error is
// returned. It is possible that at this point, some partitions have been
// committed (or even committed multiple times), and other partitions have not
// been run at all. Given the above, Partitioned DML is good fit for large,
// database-wide, operations that are idempotent, such as deleting old rows
// from a very large table.
//
// Deprecated: Please use types in: cloud.google.com/go/spanner/apiv1/spannerpb
type TransactionOptions = src.TransactionOptions

// Message type to initiate a Partitioned DML transaction.
//
// Deprecated: Please use types in: cloud.google.com/go/spanner/apiv1/spannerpb
type TransactionOptions_PartitionedDml = src.TransactionOptions_PartitionedDml
type TransactionOptions_PartitionedDml_ = src.TransactionOptions_PartitionedDml_

// Message type to initiate a read-only transaction.
//
// Deprecated: Please use types in: cloud.google.com/go/spanner/apiv1/spannerpb
type TransactionOptions_ReadOnly = src.TransactionOptions_ReadOnly
type TransactionOptions_ReadOnly_ = src.TransactionOptions_ReadOnly_
type TransactionOptions_ReadOnly_ExactStaleness = src.TransactionOptions_ReadOnly_ExactStaleness
type TransactionOptions_ReadOnly_MaxStaleness = src.TransactionOptions_ReadOnly_MaxStaleness
type TransactionOptions_ReadOnly_MinReadTimestamp = src.TransactionOptions_ReadOnly_MinReadTimestamp
type TransactionOptions_ReadOnly_ReadTimestamp = src.TransactionOptions_ReadOnly_ReadTimestamp
type TransactionOptions_ReadOnly_Strong = src.TransactionOptions_ReadOnly_Strong

// Message type to initiate a read-write transaction. Currently this
// transaction type has no options.
//
// Deprecated: Please use types in: cloud.google.com/go/spanner/apiv1/spannerpb
type TransactionOptions_ReadWrite = src.TransactionOptions_ReadWrite
type TransactionOptions_ReadWrite_ = src.TransactionOptions_ReadWrite_

// `ReadLockMode` is used to set the read lock mode for read-write
// transactions.
//
// Deprecated: Please use types in: cloud.google.com/go/spanner/apiv1/spannerpb
type TransactionOptions_ReadWrite_ReadLockMode = src.TransactionOptions_ReadWrite_ReadLockMode

// This message is used to select the transaction in which a
// [Read][google.spanner.v1.Spanner.Read] or
// [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql] call runs. See
// [TransactionOptions][google.spanner.v1.TransactionOptions] for more
// information about transactions.
//
// Deprecated: Please use types in: cloud.google.com/go/spanner/apiv1/spannerpb
type TransactionSelector = src.TransactionSelector
type TransactionSelector_Begin = src.TransactionSelector_Begin
type TransactionSelector_Id = src.TransactionSelector_Id
type TransactionSelector_SingleUse = src.TransactionSelector_SingleUse

// `Type` indicates the type of a Cloud Spanner value, as might be stored in a
// table cell or returned from an SQL query.
//
// Deprecated: Please use types in: cloud.google.com/go/spanner/apiv1/spannerpb
type Type = src.Type

// `TypeAnnotationCode` is used as a part of [Type][google.spanner.v1.Type] to
// disambiguate SQL types that should be used for a given Cloud Spanner value.
// Disambiguation is needed because the same Cloud Spanner type can be mapped
// to different SQL types depending on SQL dialect. TypeAnnotationCode doesn't
// affect the way value is serialized.
//
// Deprecated: Please use types in: cloud.google.com/go/spanner/apiv1/spannerpb
type TypeAnnotationCode = src.TypeAnnotationCode

// `TypeCode` is used as part of [Type][google.spanner.v1.Type] to indicate
// the type of a Cloud Spanner value. Each legal value of a type can be encoded
// to or decoded from a JSON value, using the encodings described below. All
// Cloud Spanner values can be `null`, regardless of type; `null`s are always
// encoded as a JSON `null`.
//
// Deprecated: Please use types in: cloud.google.com/go/spanner/apiv1/spannerpb
type TypeCode = src.TypeCode

// UnimplementedSpannerServer can be embedded to have forward compatible
// implementations.
//
// Deprecated: Please use types in: cloud.google.com/go/spanner/apiv1/spannerpb
type UnimplementedSpannerServer = src.UnimplementedSpannerServer

// Deprecated: Please use funcs in: cloud.google.com/go/spanner/apiv1/spannerpb
func NewSpannerClient(cc grpc.ClientConnInterface) SpannerClient { return src.NewSpannerClient(cc) }

// Deprecated: Please use funcs in: cloud.google.com/go/spanner/apiv1/spannerpb
func RegisterSpannerServer(s *grpc.Server, srv SpannerServer) { src.RegisterSpannerServer(s, srv) }
