// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/dialogflow/v2beta1/generator_evaluation.proto

package dialogflowpb

import (
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Enumeration of input data source type.
type GeneratorEvaluationConfig_InputDataSourceType int32

const (
	// Unspecified InputDataSourceType. Should not be used.
	GeneratorEvaluationConfig_INPUT_DATA_SOURCE_TYPE_UNSPECIFIED GeneratorEvaluationConfig_InputDataSourceType = 0
	// Fetch data from Agent Assist storage. If this source type is chosen,
	// input_data_config.start_time and input_data_config.end_timestamp must be
	// provided.
	GeneratorEvaluationConfig_AGENT_ASSIST_CONVERSATIONS GeneratorEvaluationConfig_InputDataSourceType = 1
	// Fetch data from Insights storage. If this source type is chosen,
	// input_data_config.start_time and input_data_config.end_timestamp must be
	// provided.
	GeneratorEvaluationConfig_INSIGHTS_CONVERSATIONS GeneratorEvaluationConfig_InputDataSourceType = 2
)

// Enum value maps for GeneratorEvaluationConfig_InputDataSourceType.
var (
	GeneratorEvaluationConfig_InputDataSourceType_name = map[int32]string{
		0: "INPUT_DATA_SOURCE_TYPE_UNSPECIFIED",
		1: "AGENT_ASSIST_CONVERSATIONS",
		2: "INSIGHTS_CONVERSATIONS",
	}
	GeneratorEvaluationConfig_InputDataSourceType_value = map[string]int32{
		"INPUT_DATA_SOURCE_TYPE_UNSPECIFIED": 0,
		"AGENT_ASSIST_CONVERSATIONS":         1,
		"INSIGHTS_CONVERSATIONS":             2,
	}
)

func (x GeneratorEvaluationConfig_InputDataSourceType) Enum() *GeneratorEvaluationConfig_InputDataSourceType {
	p := new(GeneratorEvaluationConfig_InputDataSourceType)
	*p = x
	return p
}

func (x GeneratorEvaluationConfig_InputDataSourceType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GeneratorEvaluationConfig_InputDataSourceType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_enumTypes[0].Descriptor()
}

func (GeneratorEvaluationConfig_InputDataSourceType) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_enumTypes[0]
}

func (x GeneratorEvaluationConfig_InputDataSourceType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GeneratorEvaluationConfig_InputDataSourceType.Descriptor instead.
func (GeneratorEvaluationConfig_InputDataSourceType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_rawDescGZIP(), []int{7, 0}
}

// Summary generation options.
type GeneratorEvaluationConfig_InputDataConfig_SummaryGenerationOption int32

const (
	// Default option will not be used
	GeneratorEvaluationConfig_InputDataConfig_SUMMARY_GENERATION_OPTION_UNSPECIFIED GeneratorEvaluationConfig_InputDataConfig_SummaryGenerationOption = 0
	// Always Generate summary for all conversations.
	GeneratorEvaluationConfig_InputDataConfig_ALWAYS_GENERATE GeneratorEvaluationConfig_InputDataConfig_SummaryGenerationOption = 1
	// Gnerate only missing summaries.
	GeneratorEvaluationConfig_InputDataConfig_GENERATE_IF_MISSING GeneratorEvaluationConfig_InputDataConfig_SummaryGenerationOption = 2
	// Do not generate new summaries. Only use existing summaries found.
	GeneratorEvaluationConfig_InputDataConfig_DO_NOT_GENERATE GeneratorEvaluationConfig_InputDataConfig_SummaryGenerationOption = 3
)

// Enum value maps for GeneratorEvaluationConfig_InputDataConfig_SummaryGenerationOption.
var (
	GeneratorEvaluationConfig_InputDataConfig_SummaryGenerationOption_name = map[int32]string{
		0: "SUMMARY_GENERATION_OPTION_UNSPECIFIED",
		1: "ALWAYS_GENERATE",
		2: "GENERATE_IF_MISSING",
		3: "DO_NOT_GENERATE",
	}
	GeneratorEvaluationConfig_InputDataConfig_SummaryGenerationOption_value = map[string]int32{
		"SUMMARY_GENERATION_OPTION_UNSPECIFIED": 0,
		"ALWAYS_GENERATE":                       1,
		"GENERATE_IF_MISSING":                   2,
		"DO_NOT_GENERATE":                       3,
	}
)

func (x GeneratorEvaluationConfig_InputDataConfig_SummaryGenerationOption) Enum() *GeneratorEvaluationConfig_InputDataConfig_SummaryGenerationOption {
	p := new(GeneratorEvaluationConfig_InputDataConfig_SummaryGenerationOption)
	*p = x
	return p
}

func (x GeneratorEvaluationConfig_InputDataConfig_SummaryGenerationOption) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GeneratorEvaluationConfig_InputDataConfig_SummaryGenerationOption) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_enumTypes[1].Descriptor()
}

func (GeneratorEvaluationConfig_InputDataConfig_SummaryGenerationOption) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_enumTypes[1]
}

func (x GeneratorEvaluationConfig_InputDataConfig_SummaryGenerationOption) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GeneratorEvaluationConfig_InputDataConfig_SummaryGenerationOption.Descriptor instead.
func (GeneratorEvaluationConfig_InputDataConfig_SummaryGenerationOption) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_rawDescGZIP(), []int{7, 2, 0}
}

// Request of CreateGeneratorEvaluation.
type CreateGeneratorEvaluationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The generator resource name. Format:
	// `projects/<Project ID>/locations/<Location ID>/generators/<Generator ID>`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The generator evaluation to be created.
	GeneratorEvaluation *GeneratorEvaluation `protobuf:"bytes,2,opt,name=generator_evaluation,json=generatorEvaluation,proto3" json:"generator_evaluation,omitempty"`
}

func (x *CreateGeneratorEvaluationRequest) Reset() {
	*x = CreateGeneratorEvaluationRequest{}
	mi := &file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateGeneratorEvaluationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateGeneratorEvaluationRequest) ProtoMessage() {}

func (x *CreateGeneratorEvaluationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateGeneratorEvaluationRequest.ProtoReflect.Descriptor instead.
func (*CreateGeneratorEvaluationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_rawDescGZIP(), []int{0}
}

func (x *CreateGeneratorEvaluationRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateGeneratorEvaluationRequest) GetGeneratorEvaluation() *GeneratorEvaluation {
	if x != nil {
		return x.GeneratorEvaluation
	}
	return nil
}

// Request of GetGeneratorEvaluation.
type GetGeneratorEvaluationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The generator evaluation resource name. Format:
	// `projects/<Project ID>/locations/<Location ID>/generators/<Generator
	// ID>/evaluations/<Evaluation ID>`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetGeneratorEvaluationRequest) Reset() {
	*x = GetGeneratorEvaluationRequest{}
	mi := &file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetGeneratorEvaluationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetGeneratorEvaluationRequest) ProtoMessage() {}

func (x *GetGeneratorEvaluationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetGeneratorEvaluationRequest.ProtoReflect.Descriptor instead.
func (*GetGeneratorEvaluationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_rawDescGZIP(), []int{1}
}

func (x *GetGeneratorEvaluationRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request of ListGeneratorEvaluations.
type ListGeneratorEvaluationsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The generator resource name. Format:
	// `projects/<Project ID>/locations/<Location ID>/generators/<Generator ID>`
	// Wildcard value `-` is supported on generator_id to list evaluations across
	// all generators under same project.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Maximum number of evaluations to return in a
	// single page. By default 100 and at most 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The next_page_token value returned from a previous list request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListGeneratorEvaluationsRequest) Reset() {
	*x = ListGeneratorEvaluationsRequest{}
	mi := &file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListGeneratorEvaluationsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListGeneratorEvaluationsRequest) ProtoMessage() {}

func (x *ListGeneratorEvaluationsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListGeneratorEvaluationsRequest.ProtoReflect.Descriptor instead.
func (*ListGeneratorEvaluationsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_rawDescGZIP(), []int{2}
}

func (x *ListGeneratorEvaluationsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListGeneratorEvaluationsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListGeneratorEvaluationsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response of ListGeneratorEvaluations.
type ListGeneratorEvaluationsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of evaluations to return.
	GeneratorEvaluations []*GeneratorEvaluation `protobuf:"bytes,1,rep,name=generator_evaluations,json=generatorEvaluations,proto3" json:"generator_evaluations,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListGeneratorEvaluationsResponse) Reset() {
	*x = ListGeneratorEvaluationsResponse{}
	mi := &file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListGeneratorEvaluationsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListGeneratorEvaluationsResponse) ProtoMessage() {}

func (x *ListGeneratorEvaluationsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListGeneratorEvaluationsResponse.ProtoReflect.Descriptor instead.
func (*ListGeneratorEvaluationsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_rawDescGZIP(), []int{3}
}

func (x *ListGeneratorEvaluationsResponse) GetGeneratorEvaluations() []*GeneratorEvaluation {
	if x != nil {
		return x.GeneratorEvaluations
	}
	return nil
}

func (x *ListGeneratorEvaluationsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request of DeleteGeneratorEvaluation.
type DeleteGeneratorEvaluationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The generator evaluation resource name. Format:
	// `projects/<Project ID>/locations/<Location ID>/generators/<Generator ID>/
	// evaluations/<Evaluation ID>`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteGeneratorEvaluationRequest) Reset() {
	*x = DeleteGeneratorEvaluationRequest{}
	mi := &file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteGeneratorEvaluationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteGeneratorEvaluationRequest) ProtoMessage() {}

func (x *DeleteGeneratorEvaluationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteGeneratorEvaluationRequest.ProtoReflect.Descriptor instead.
func (*DeleteGeneratorEvaluationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_rawDescGZIP(), []int{4}
}

func (x *DeleteGeneratorEvaluationRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Represents evaluation result of a generator.
type GeneratorEvaluation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Identifier. The resource name of the evaluation. Format:
	// `projects/<Project ID>/locations/<Location ID>/generators/<Generator ID>/
	// evaluations/<Evaluation ID>`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The display name of the generator evaluation. At most 64 bytes
	// long.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Required. The configuration of the evaluation task.
	GeneratorEvaluationConfig *GeneratorEvaluationConfig `protobuf:"bytes,3,opt,name=generator_evaluation_config,json=generatorEvaluationConfig,proto3" json:"generator_evaluation_config,omitempty"`
	// Output only. Creation time of this generator evaluation.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Completion time of this generator evaluation.
	CompleteTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=complete_time,json=completeTime,proto3" json:"complete_time,omitempty"`
	// Required. The initial generator that was used when creating this
	// evaluation. This is a copy of the generator read from storage when creating
	// the evaluation.
	InitialGenerator *Generator `protobuf:"bytes,5,opt,name=initial_generator,json=initialGenerator,proto3" json:"initial_generator,omitempty"`
	// Metrics details.
	//
	// Types that are assignable to Metrics:
	//
	//	*GeneratorEvaluation_SummarizationMetrics
	Metrics isGeneratorEvaluation_Metrics `protobuf_oneof:"metrics"`
	// Output only. The result status of the evaluation pipeline. Provides the
	// status information including if the evaluation is still in progress,
	// completed or failed with certain error and user actionable message.
	EvaluationStatus *EvaluationStatus `protobuf:"bytes,10,opt,name=evaluation_status,json=evaluationStatus,proto3" json:"evaluation_status,omitempty"`
	// Output only. A read only boolean field reflecting Zone Separation
	// status of the model. The field is an aggregated
	// value of ZS status of its underlying dependencies. See more details in
	// go/zicy-resource-placement#resource-status
	SatisfiesPzs *bool `protobuf:"varint,11,opt,name=satisfies_pzs,json=satisfiesPzs,proto3,oneof" json:"satisfies_pzs,omitempty"`
	// Output only. A read only boolean field reflecting Zone Isolation status
	// of the model. The field is an aggregated value of
	// ZI status of its underlying dependencies. See more details in
	// go/zicy-resource-placement#resource-status
	SatisfiesPzi *bool `protobuf:"varint,12,opt,name=satisfies_pzi,json=satisfiesPzi,proto3,oneof" json:"satisfies_pzi,omitempty"`
}

func (x *GeneratorEvaluation) Reset() {
	*x = GeneratorEvaluation{}
	mi := &file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GeneratorEvaluation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GeneratorEvaluation) ProtoMessage() {}

func (x *GeneratorEvaluation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GeneratorEvaluation.ProtoReflect.Descriptor instead.
func (*GeneratorEvaluation) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_rawDescGZIP(), []int{5}
}

func (x *GeneratorEvaluation) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GeneratorEvaluation) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *GeneratorEvaluation) GetGeneratorEvaluationConfig() *GeneratorEvaluationConfig {
	if x != nil {
		return x.GeneratorEvaluationConfig
	}
	return nil
}

func (x *GeneratorEvaluation) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *GeneratorEvaluation) GetCompleteTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CompleteTime
	}
	return nil
}

func (x *GeneratorEvaluation) GetInitialGenerator() *Generator {
	if x != nil {
		return x.InitialGenerator
	}
	return nil
}

func (m *GeneratorEvaluation) GetMetrics() isGeneratorEvaluation_Metrics {
	if m != nil {
		return m.Metrics
	}
	return nil
}

func (x *GeneratorEvaluation) GetSummarizationMetrics() *SummarizationEvaluationMetrics {
	if x, ok := x.GetMetrics().(*GeneratorEvaluation_SummarizationMetrics); ok {
		return x.SummarizationMetrics
	}
	return nil
}

func (x *GeneratorEvaluation) GetEvaluationStatus() *EvaluationStatus {
	if x != nil {
		return x.EvaluationStatus
	}
	return nil
}

func (x *GeneratorEvaluation) GetSatisfiesPzs() bool {
	if x != nil && x.SatisfiesPzs != nil {
		return *x.SatisfiesPzs
	}
	return false
}

func (x *GeneratorEvaluation) GetSatisfiesPzi() bool {
	if x != nil && x.SatisfiesPzi != nil {
		return *x.SatisfiesPzi
	}
	return false
}

type isGeneratorEvaluation_Metrics interface {
	isGeneratorEvaluation_Metrics()
}

type GeneratorEvaluation_SummarizationMetrics struct {
	// Output only. Only available when the summarization generator is provided.
	SummarizationMetrics *SummarizationEvaluationMetrics `protobuf:"bytes,6,opt,name=summarization_metrics,json=summarizationMetrics,proto3,oneof"`
}

func (*GeneratorEvaluation_SummarizationMetrics) isGeneratorEvaluation_Metrics() {}

// Evaluation metrics for summarization generator.
type SummarizationEvaluationMetrics struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. A list of evaluation results per conversation(&summary),
	// metric and section.
	SummarizationEvaluationResults []*SummarizationEvaluationMetrics_SummarizationEvaluationResult `protobuf:"bytes,4,rep,name=summarization_evaluation_results,json=summarizationEvaluationResults,proto3" json:"summarization_evaluation_results,omitempty"`
	// Output only. User bucket uri for merged evaluation score and aggregation
	// score csv.
	SummarizationEvaluationMergedResultsUri string `protobuf:"bytes,5,opt,name=summarization_evaluation_merged_results_uri,json=summarizationEvaluationMergedResultsUri,proto3" json:"summarization_evaluation_merged_results_uri,omitempty"`
	// Output only. A list of aggregated(average) scores per metric section.
	OverallMetrics []*SummarizationEvaluationMetrics_OverallScoresByMetric `protobuf:"bytes,6,rep,name=overall_metrics,json=overallMetrics,proto3" json:"overall_metrics,omitempty"`
	// Output only. Overall token per section. This is an aggregated(sum) result
	// of input token of summary acorss all conversations that are selected for
	// summarization evaluation.
	OverallSectionTokens []*SummarizationEvaluationMetrics_SectionToken `protobuf:"bytes,7,rep,name=overall_section_tokens,json=overallSectionTokens,proto3" json:"overall_section_tokens,omitempty"`
	// Output only. List of conversation details.
	ConversationDetails []*SummarizationEvaluationMetrics_ConversationDetail `protobuf:"bytes,8,rep,name=conversation_details,json=conversationDetails,proto3" json:"conversation_details,omitempty"`
}

func (x *SummarizationEvaluationMetrics) Reset() {
	*x = SummarizationEvaluationMetrics{}
	mi := &file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SummarizationEvaluationMetrics) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SummarizationEvaluationMetrics) ProtoMessage() {}

func (x *SummarizationEvaluationMetrics) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SummarizationEvaluationMetrics.ProtoReflect.Descriptor instead.
func (*SummarizationEvaluationMetrics) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_rawDescGZIP(), []int{6}
}

func (x *SummarizationEvaluationMetrics) GetSummarizationEvaluationResults() []*SummarizationEvaluationMetrics_SummarizationEvaluationResult {
	if x != nil {
		return x.SummarizationEvaluationResults
	}
	return nil
}

func (x *SummarizationEvaluationMetrics) GetSummarizationEvaluationMergedResultsUri() string {
	if x != nil {
		return x.SummarizationEvaluationMergedResultsUri
	}
	return ""
}

func (x *SummarizationEvaluationMetrics) GetOverallMetrics() []*SummarizationEvaluationMetrics_OverallScoresByMetric {
	if x != nil {
		return x.OverallMetrics
	}
	return nil
}

func (x *SummarizationEvaluationMetrics) GetOverallSectionTokens() []*SummarizationEvaluationMetrics_SectionToken {
	if x != nil {
		return x.OverallSectionTokens
	}
	return nil
}

func (x *SummarizationEvaluationMetrics) GetConversationDetails() []*SummarizationEvaluationMetrics_ConversationDetail {
	if x != nil {
		return x.ConversationDetails
	}
	return nil
}

// Generator evaluation input config.
type GeneratorEvaluationConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The config/source of input data.
	InputDataConfig *GeneratorEvaluationConfig_InputDataConfig `protobuf:"bytes,1,opt,name=input_data_config,json=inputDataConfig,proto3" json:"input_data_config,omitempty"`
	// Required. The output Cloud Storage bucket path to store eval files, e.g.
	// per_summary_accuracy_score report. This path is provided by customer and
	// files stored in it are visible to customer, no internal data should be
	// stored in this path.
	OutputGcsBucketPath string `protobuf:"bytes,2,opt,name=output_gcs_bucket_path,json=outputGcsBucketPath,proto3" json:"output_gcs_bucket_path,omitempty"`
	// Feature used for evaluation.
	//
	// Types that are assignable to EvaluationFeatureConfig:
	//
	//	*GeneratorEvaluationConfig_SummarizationConfig_
	EvaluationFeatureConfig isGeneratorEvaluationConfig_EvaluationFeatureConfig `protobuf_oneof:"evaluation_feature_config"`
}

func (x *GeneratorEvaluationConfig) Reset() {
	*x = GeneratorEvaluationConfig{}
	mi := &file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GeneratorEvaluationConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GeneratorEvaluationConfig) ProtoMessage() {}

func (x *GeneratorEvaluationConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GeneratorEvaluationConfig.ProtoReflect.Descriptor instead.
func (*GeneratorEvaluationConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_rawDescGZIP(), []int{7}
}

func (x *GeneratorEvaluationConfig) GetInputDataConfig() *GeneratorEvaluationConfig_InputDataConfig {
	if x != nil {
		return x.InputDataConfig
	}
	return nil
}

func (x *GeneratorEvaluationConfig) GetOutputGcsBucketPath() string {
	if x != nil {
		return x.OutputGcsBucketPath
	}
	return ""
}

func (m *GeneratorEvaluationConfig) GetEvaluationFeatureConfig() isGeneratorEvaluationConfig_EvaluationFeatureConfig {
	if m != nil {
		return m.EvaluationFeatureConfig
	}
	return nil
}

func (x *GeneratorEvaluationConfig) GetSummarizationConfig() *GeneratorEvaluationConfig_SummarizationConfig {
	if x, ok := x.GetEvaluationFeatureConfig().(*GeneratorEvaluationConfig_SummarizationConfig_); ok {
		return x.SummarizationConfig
	}
	return nil
}

type isGeneratorEvaluationConfig_EvaluationFeatureConfig interface {
	isGeneratorEvaluationConfig_EvaluationFeatureConfig()
}

type GeneratorEvaluationConfig_SummarizationConfig_ struct {
	// Evaluation configs for summarization generator.
	SummarizationConfig *GeneratorEvaluationConfig_SummarizationConfig `protobuf:"bytes,3,opt,name=summarization_config,json=summarizationConfig,proto3,oneof"`
}

func (*GeneratorEvaluationConfig_SummarizationConfig_) isGeneratorEvaluationConfig_EvaluationFeatureConfig() {
}

// A common evalaution pipeline status.
type EvaluationStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. If the value is `false`, it means the evaluation is still in
	// progress. If `true`, the operation is completed, and either `error` or
	// `response` is available.
	Done *bool `protobuf:"varint,1,opt,name=done,proto3,oneof" json:"done,omitempty"`
	// Output only. The error result of the evaluation in case of failure in
	// evaluation pipeline.
	PipelineStatus *status.Status `protobuf:"bytes,2,opt,name=pipeline_status,json=pipelineStatus,proto3" json:"pipeline_status,omitempty"`
}

func (x *EvaluationStatus) Reset() {
	*x = EvaluationStatus{}
	mi := &file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EvaluationStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EvaluationStatus) ProtoMessage() {}

func (x *EvaluationStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EvaluationStatus.ProtoReflect.Descriptor instead.
func (*EvaluationStatus) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_rawDescGZIP(), []int{8}
}

func (x *EvaluationStatus) GetDone() bool {
	if x != nil && x.Done != nil {
		return *x.Done
	}
	return false
}

func (x *EvaluationStatus) GetPipelineStatus() *status.Status {
	if x != nil {
		return x.PipelineStatus
	}
	return nil
}

// Decomposition details for accuracy.
type SummarizationEvaluationMetrics_AccuracyDecomposition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The breakdown point of the summary.
	Point string `protobuf:"bytes,1,opt,name=point,proto3" json:"point,omitempty"`
	// Output only. The accuracy reasoning of the breakdown point.
	AccuracyReasoning string `protobuf:"bytes,2,opt,name=accuracy_reasoning,json=accuracyReasoning,proto3" json:"accuracy_reasoning,omitempty"`
	// Output only. Whether the breakdown point is accurate or not.
	IsAccurate *bool `protobuf:"varint,3,opt,name=is_accurate,json=isAccurate,proto3,oneof" json:"is_accurate,omitempty"`
}

func (x *SummarizationEvaluationMetrics_AccuracyDecomposition) Reset() {
	*x = SummarizationEvaluationMetrics_AccuracyDecomposition{}
	mi := &file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SummarizationEvaluationMetrics_AccuracyDecomposition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SummarizationEvaluationMetrics_AccuracyDecomposition) ProtoMessage() {}

func (x *SummarizationEvaluationMetrics_AccuracyDecomposition) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SummarizationEvaluationMetrics_AccuracyDecomposition.ProtoReflect.Descriptor instead.
func (*SummarizationEvaluationMetrics_AccuracyDecomposition) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_rawDescGZIP(), []int{6, 0}
}

func (x *SummarizationEvaluationMetrics_AccuracyDecomposition) GetPoint() string {
	if x != nil {
		return x.Point
	}
	return ""
}

func (x *SummarizationEvaluationMetrics_AccuracyDecomposition) GetAccuracyReasoning() string {
	if x != nil {
		return x.AccuracyReasoning
	}
	return ""
}

func (x *SummarizationEvaluationMetrics_AccuracyDecomposition) GetIsAccurate() bool {
	if x != nil && x.IsAccurate != nil {
		return *x.IsAccurate
	}
	return false
}

// Decomposition details for adherence.
//
// Deprecated: Marked as deprecated in google/cloud/dialogflow/v2beta1/generator_evaluation.proto.
type SummarizationEvaluationMetrics_AdherenceDecomposition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The breakdown point of the given instructions.
	Point string `protobuf:"bytes,1,opt,name=point,proto3" json:"point,omitempty"`
	// Output only. The adherence reasoning of the breakdown point.
	AdherenceReasoning string `protobuf:"bytes,2,opt,name=adherence_reasoning,json=adherenceReasoning,proto3" json:"adherence_reasoning,omitempty"`
	// Output only. Whether the breakdown point is adherent or not.
	IsAdherent bool `protobuf:"varint,3,opt,name=is_adherent,json=isAdherent,proto3" json:"is_adherent,omitempty"`
}

func (x *SummarizationEvaluationMetrics_AdherenceDecomposition) Reset() {
	*x = SummarizationEvaluationMetrics_AdherenceDecomposition{}
	mi := &file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SummarizationEvaluationMetrics_AdherenceDecomposition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SummarizationEvaluationMetrics_AdherenceDecomposition) ProtoMessage() {}

func (x *SummarizationEvaluationMetrics_AdherenceDecomposition) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SummarizationEvaluationMetrics_AdherenceDecomposition.ProtoReflect.Descriptor instead.
func (*SummarizationEvaluationMetrics_AdherenceDecomposition) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_rawDescGZIP(), []int{6, 1}
}

func (x *SummarizationEvaluationMetrics_AdherenceDecomposition) GetPoint() string {
	if x != nil {
		return x.Point
	}
	return ""
}

func (x *SummarizationEvaluationMetrics_AdherenceDecomposition) GetAdherenceReasoning() string {
	if x != nil {
		return x.AdherenceReasoning
	}
	return ""
}

func (x *SummarizationEvaluationMetrics_AdherenceDecomposition) GetIsAdherent() bool {
	if x != nil {
		return x.IsAdherent
	}
	return false
}

// Rubric result of the adherence evaluation. A rubric is ued to determine
// if the summary adheres to all aspects of the given instructions.
type SummarizationEvaluationMetrics_AdherenceRubric struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The question generated from instruction that used to
	// evaluate summary.
	Question string `protobuf:"bytes,1,opt,name=question,proto3" json:"question,omitempty"`
	// Output only. The reasoning of the rubric question is addressed or not.
	Reasoning string `protobuf:"bytes,2,opt,name=reasoning,proto3" json:"reasoning,omitempty"`
	// Output only. A boolean that indicates whether the rubric question is
	// addressed or not.
	IsAddressed *bool `protobuf:"varint,3,opt,name=is_addressed,json=isAddressed,proto3,oneof" json:"is_addressed,omitempty"`
}

func (x *SummarizationEvaluationMetrics_AdherenceRubric) Reset() {
	*x = SummarizationEvaluationMetrics_AdherenceRubric{}
	mi := &file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SummarizationEvaluationMetrics_AdherenceRubric) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SummarizationEvaluationMetrics_AdherenceRubric) ProtoMessage() {}

func (x *SummarizationEvaluationMetrics_AdherenceRubric) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SummarizationEvaluationMetrics_AdherenceRubric.ProtoReflect.Descriptor instead.
func (*SummarizationEvaluationMetrics_AdherenceRubric) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_rawDescGZIP(), []int{6, 2}
}

func (x *SummarizationEvaluationMetrics_AdherenceRubric) GetQuestion() string {
	if x != nil {
		return x.Question
	}
	return ""
}

func (x *SummarizationEvaluationMetrics_AdherenceRubric) GetReasoning() string {
	if x != nil {
		return x.Reasoning
	}
	return ""
}

func (x *SummarizationEvaluationMetrics_AdherenceRubric) GetIsAddressed() bool {
	if x != nil && x.IsAddressed != nil {
		return *x.IsAddressed
	}
	return false
}

// Rubric details of the completeness evaluation result.
type SummarizationEvaluationMetrics_CompletenessRubric struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The question generated from instruction that used to
	// evaluate summary.
	Question string `protobuf:"bytes,1,opt,name=question,proto3" json:"question,omitempty"`
	// Output only. A boolean that indicates whether the rubric question is
	// addressed or not.
	IsAddressed *bool `protobuf:"varint,2,opt,name=is_addressed,json=isAddressed,proto3,oneof" json:"is_addressed,omitempty"`
}

func (x *SummarizationEvaluationMetrics_CompletenessRubric) Reset() {
	*x = SummarizationEvaluationMetrics_CompletenessRubric{}
	mi := &file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SummarizationEvaluationMetrics_CompletenessRubric) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SummarizationEvaluationMetrics_CompletenessRubric) ProtoMessage() {}

func (x *SummarizationEvaluationMetrics_CompletenessRubric) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SummarizationEvaluationMetrics_CompletenessRubric.ProtoReflect.Descriptor instead.
func (*SummarizationEvaluationMetrics_CompletenessRubric) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_rawDescGZIP(), []int{6, 3}
}

func (x *SummarizationEvaluationMetrics_CompletenessRubric) GetQuestion() string {
	if x != nil {
		return x.Question
	}
	return ""
}

func (x *SummarizationEvaluationMetrics_CompletenessRubric) GetIsAddressed() bool {
	if x != nil && x.IsAddressed != nil {
		return *x.IsAddressed
	}
	return false
}

// Decomposition details
//
// Deprecated: Marked as deprecated in google/cloud/dialogflow/v2beta1/generator_evaluation.proto.
type SummarizationEvaluationMetrics_Decomposition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// One of decomposition details.
	//
	// Types that are assignable to Decomposition:
	//
	//	*SummarizationEvaluationMetrics_Decomposition_AccuracyDecomposition
	//	*SummarizationEvaluationMetrics_Decomposition_AdherenceDecomposition
	Decomposition isSummarizationEvaluationMetrics_Decomposition_Decomposition `protobuf_oneof:"decomposition"`
}

func (x *SummarizationEvaluationMetrics_Decomposition) Reset() {
	*x = SummarizationEvaluationMetrics_Decomposition{}
	mi := &file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SummarizationEvaluationMetrics_Decomposition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SummarizationEvaluationMetrics_Decomposition) ProtoMessage() {}

func (x *SummarizationEvaluationMetrics_Decomposition) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SummarizationEvaluationMetrics_Decomposition.ProtoReflect.Descriptor instead.
func (*SummarizationEvaluationMetrics_Decomposition) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_rawDescGZIP(), []int{6, 4}
}

func (m *SummarizationEvaluationMetrics_Decomposition) GetDecomposition() isSummarizationEvaluationMetrics_Decomposition_Decomposition {
	if m != nil {
		return m.Decomposition
	}
	return nil
}

func (x *SummarizationEvaluationMetrics_Decomposition) GetAccuracyDecomposition() *SummarizationEvaluationMetrics_AccuracyDecomposition {
	if x, ok := x.GetDecomposition().(*SummarizationEvaluationMetrics_Decomposition_AccuracyDecomposition); ok {
		return x.AccuracyDecomposition
	}
	return nil
}

func (x *SummarizationEvaluationMetrics_Decomposition) GetAdherenceDecomposition() *SummarizationEvaluationMetrics_AdherenceDecomposition {
	if x, ok := x.GetDecomposition().(*SummarizationEvaluationMetrics_Decomposition_AdherenceDecomposition); ok {
		return x.AdherenceDecomposition
	}
	return nil
}

type isSummarizationEvaluationMetrics_Decomposition_Decomposition interface {
	isSummarizationEvaluationMetrics_Decomposition_Decomposition()
}

type SummarizationEvaluationMetrics_Decomposition_AccuracyDecomposition struct {
	// only available for accuracy metric.
	AccuracyDecomposition *SummarizationEvaluationMetrics_AccuracyDecomposition `protobuf:"bytes,1,opt,name=accuracy_decomposition,json=accuracyDecomposition,proto3,oneof"`
}

type SummarizationEvaluationMetrics_Decomposition_AdherenceDecomposition struct {
	// only available for adherence metric.
	AdherenceDecomposition *SummarizationEvaluationMetrics_AdherenceDecomposition `protobuf:"bytes,2,opt,name=adherence_decomposition,json=adherenceDecomposition,proto3,oneof"`
}

func (*SummarizationEvaluationMetrics_Decomposition_AccuracyDecomposition) isSummarizationEvaluationMetrics_Decomposition_Decomposition() {
}

func (*SummarizationEvaluationMetrics_Decomposition_AdherenceDecomposition) isSummarizationEvaluationMetrics_Decomposition_Decomposition() {
}

// Evaluation result that contains one of accuracy, adherence or completeness
// evaluation result.
type SummarizationEvaluationMetrics_EvaluationResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// One of evaluation result details.
	//
	// Types that are assignable to Result:
	//
	//	*SummarizationEvaluationMetrics_EvaluationResult_AccuracyDecomposition
	//	*SummarizationEvaluationMetrics_EvaluationResult_AdherenceRubric
	//	*SummarizationEvaluationMetrics_EvaluationResult_CompletenessRubric
	Result isSummarizationEvaluationMetrics_EvaluationResult_Result `protobuf_oneof:"result"`
}

func (x *SummarizationEvaluationMetrics_EvaluationResult) Reset() {
	*x = SummarizationEvaluationMetrics_EvaluationResult{}
	mi := &file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SummarizationEvaluationMetrics_EvaluationResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SummarizationEvaluationMetrics_EvaluationResult) ProtoMessage() {}

func (x *SummarizationEvaluationMetrics_EvaluationResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SummarizationEvaluationMetrics_EvaluationResult.ProtoReflect.Descriptor instead.
func (*SummarizationEvaluationMetrics_EvaluationResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_rawDescGZIP(), []int{6, 5}
}

func (m *SummarizationEvaluationMetrics_EvaluationResult) GetResult() isSummarizationEvaluationMetrics_EvaluationResult_Result {
	if m != nil {
		return m.Result
	}
	return nil
}

func (x *SummarizationEvaluationMetrics_EvaluationResult) GetAccuracyDecomposition() *SummarizationEvaluationMetrics_AccuracyDecomposition {
	if x, ok := x.GetResult().(*SummarizationEvaluationMetrics_EvaluationResult_AccuracyDecomposition); ok {
		return x.AccuracyDecomposition
	}
	return nil
}

func (x *SummarizationEvaluationMetrics_EvaluationResult) GetAdherenceRubric() *SummarizationEvaluationMetrics_AdherenceRubric {
	if x, ok := x.GetResult().(*SummarizationEvaluationMetrics_EvaluationResult_AdherenceRubric); ok {
		return x.AdherenceRubric
	}
	return nil
}

func (x *SummarizationEvaluationMetrics_EvaluationResult) GetCompletenessRubric() *SummarizationEvaluationMetrics_CompletenessRubric {
	if x, ok := x.GetResult().(*SummarizationEvaluationMetrics_EvaluationResult_CompletenessRubric); ok {
		return x.CompletenessRubric
	}
	return nil
}

type isSummarizationEvaluationMetrics_EvaluationResult_Result interface {
	isSummarizationEvaluationMetrics_EvaluationResult_Result()
}

type SummarizationEvaluationMetrics_EvaluationResult_AccuracyDecomposition struct {
	// Only available for accuracy metric.
	AccuracyDecomposition *SummarizationEvaluationMetrics_AccuracyDecomposition `protobuf:"bytes,1,opt,name=accuracy_decomposition,json=accuracyDecomposition,proto3,oneof"`
}

type SummarizationEvaluationMetrics_EvaluationResult_AdherenceRubric struct {
	// Only available for adherence metric.
	AdherenceRubric *SummarizationEvaluationMetrics_AdherenceRubric `protobuf:"bytes,2,opt,name=adherence_rubric,json=adherenceRubric,proto3,oneof"`
}

type SummarizationEvaluationMetrics_EvaluationResult_CompletenessRubric struct {
	// Only available for completeness metric.
	CompletenessRubric *SummarizationEvaluationMetrics_CompletenessRubric `protobuf:"bytes,3,opt,name=completeness_rubric,json=completenessRubric,proto3,oneof"`
}

func (*SummarizationEvaluationMetrics_EvaluationResult_AccuracyDecomposition) isSummarizationEvaluationMetrics_EvaluationResult_Result() {
}

func (*SummarizationEvaluationMetrics_EvaluationResult_AdherenceRubric) isSummarizationEvaluationMetrics_EvaluationResult_Result() {
}

func (*SummarizationEvaluationMetrics_EvaluationResult_CompletenessRubric) isSummarizationEvaluationMetrics_EvaluationResult_Result() {
}

// Evaluation result per conversation(&summary), metric and section.
type SummarizationEvaluationMetrics_SummarizationEvaluationResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. conversation session id
	//
	// Deprecated: Marked as deprecated in google/cloud/dialogflow/v2beta1/generator_evaluation.proto.
	SessionId string `protobuf:"bytes,1,opt,name=session_id,json=sessionId,proto3" json:"session_id,omitempty"`
	// Output only. metric name, e.g. accuracy, completeness, adherence, etc.
	Metric string `protobuf:"bytes,2,opt,name=metric,proto3" json:"metric,omitempty"`
	// Output only. section/task name, e.g. action, situation, etc
	Section string `protobuf:"bytes,3,opt,name=section,proto3" json:"section,omitempty"`
	// Output only. score calculated from decompositions
	Score float32 `protobuf:"fixed32,4,opt,name=score,proto3" json:"score,omitempty"`
	// Output only. Summary of this section
	SectionSummary string `protobuf:"bytes,6,opt,name=section_summary,json=sectionSummary,proto3" json:"section_summary,omitempty"`
	// Output only. List of decompostion details
	//
	// Deprecated: Marked as deprecated in google/cloud/dialogflow/v2beta1/generator_evaluation.proto.
	Decompositions []*SummarizationEvaluationMetrics_Decomposition `protobuf:"bytes,7,rep,name=decompositions,proto3" json:"decompositions,omitempty"`
	// Output only. List of evaluation results.
	EvaluationResults []*SummarizationEvaluationMetrics_EvaluationResult `protobuf:"bytes,8,rep,name=evaluation_results,json=evaluationResults,proto3" json:"evaluation_results,omitempty"`
}

func (x *SummarizationEvaluationMetrics_SummarizationEvaluationResult) Reset() {
	*x = SummarizationEvaluationMetrics_SummarizationEvaluationResult{}
	mi := &file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SummarizationEvaluationMetrics_SummarizationEvaluationResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SummarizationEvaluationMetrics_SummarizationEvaluationResult) ProtoMessage() {}

func (x *SummarizationEvaluationMetrics_SummarizationEvaluationResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SummarizationEvaluationMetrics_SummarizationEvaluationResult.ProtoReflect.Descriptor instead.
func (*SummarizationEvaluationMetrics_SummarizationEvaluationResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_rawDescGZIP(), []int{6, 6}
}

// Deprecated: Marked as deprecated in google/cloud/dialogflow/v2beta1/generator_evaluation.proto.
func (x *SummarizationEvaluationMetrics_SummarizationEvaluationResult) GetSessionId() string {
	if x != nil {
		return x.SessionId
	}
	return ""
}

func (x *SummarizationEvaluationMetrics_SummarizationEvaluationResult) GetMetric() string {
	if x != nil {
		return x.Metric
	}
	return ""
}

func (x *SummarizationEvaluationMetrics_SummarizationEvaluationResult) GetSection() string {
	if x != nil {
		return x.Section
	}
	return ""
}

func (x *SummarizationEvaluationMetrics_SummarizationEvaluationResult) GetScore() float32 {
	if x != nil {
		return x.Score
	}
	return 0
}

func (x *SummarizationEvaluationMetrics_SummarizationEvaluationResult) GetSectionSummary() string {
	if x != nil {
		return x.SectionSummary
	}
	return ""
}

// Deprecated: Marked as deprecated in google/cloud/dialogflow/v2beta1/generator_evaluation.proto.
func (x *SummarizationEvaluationMetrics_SummarizationEvaluationResult) GetDecompositions() []*SummarizationEvaluationMetrics_Decomposition {
	if x != nil {
		return x.Decompositions
	}
	return nil
}

func (x *SummarizationEvaluationMetrics_SummarizationEvaluationResult) GetEvaluationResults() []*SummarizationEvaluationMetrics_EvaluationResult {
	if x != nil {
		return x.EvaluationResults
	}
	return nil
}

// Overall performance per metric. This is the aggregated score for each
// metric across all conversations that are selected for summarization
// evaluation.
type SummarizationEvaluationMetrics_OverallScoresByMetric struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Metric name. e.g. accuracy, adherence, completeness.
	Metric string `protobuf:"bytes,1,opt,name=metric,proto3" json:"metric,omitempty"`
}

func (x *SummarizationEvaluationMetrics_OverallScoresByMetric) Reset() {
	*x = SummarizationEvaluationMetrics_OverallScoresByMetric{}
	mi := &file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SummarizationEvaluationMetrics_OverallScoresByMetric) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SummarizationEvaluationMetrics_OverallScoresByMetric) ProtoMessage() {}

func (x *SummarizationEvaluationMetrics_OverallScoresByMetric) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SummarizationEvaluationMetrics_OverallScoresByMetric.ProtoReflect.Descriptor instead.
func (*SummarizationEvaluationMetrics_OverallScoresByMetric) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_rawDescGZIP(), []int{6, 7}
}

func (x *SummarizationEvaluationMetrics_OverallScoresByMetric) GetMetric() string {
	if x != nil {
		return x.Metric
	}
	return ""
}

// A pair of section name and input token count of the input summary section.
type SummarizationEvaluationMetrics_SectionToken struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The name of the summary instruction.
	Section string `protobuf:"bytes,1,opt,name=section,proto3" json:"section,omitempty"`
	// Output only. Token count.
	TokenCount *int64 `protobuf:"varint,2,opt,name=token_count,json=tokenCount,proto3,oneof" json:"token_count,omitempty"`
}

func (x *SummarizationEvaluationMetrics_SectionToken) Reset() {
	*x = SummarizationEvaluationMetrics_SectionToken{}
	mi := &file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SummarizationEvaluationMetrics_SectionToken) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SummarizationEvaluationMetrics_SectionToken) ProtoMessage() {}

func (x *SummarizationEvaluationMetrics_SectionToken) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SummarizationEvaluationMetrics_SectionToken.ProtoReflect.Descriptor instead.
func (*SummarizationEvaluationMetrics_SectionToken) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_rawDescGZIP(), []int{6, 8}
}

func (x *SummarizationEvaluationMetrics_SectionToken) GetSection() string {
	if x != nil {
		return x.Section
	}
	return ""
}

func (x *SummarizationEvaluationMetrics_SectionToken) GetTokenCount() int64 {
	if x != nil && x.TokenCount != nil {
		return *x.TokenCount
	}
	return 0
}

// Aggregated evaluation result on conversation level. This contains
// evaluation results of all the metrics and sections.
type SummarizationEvaluationMetrics_ConversationDetail struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Conversation transcript that used for summarization
	// evaluation as a reference.
	MessageEntries []*MessageEntry `protobuf:"bytes,1,rep,name=message_entries,json=messageEntries,proto3" json:"message_entries,omitempty"`
	// Output only. Summary sections that used for summarization evaluation as a
	// reference.
	SummarySections []*SummarySuggestion_SummarySection `protobuf:"bytes,4,rep,name=summary_sections,json=summarySections,proto3" json:"summary_sections,omitempty"`
	// Output only. List of metric details.
	MetricDetails []*SummarizationEvaluationMetrics_ConversationDetail_MetricDetail `protobuf:"bytes,2,rep,name=metric_details,json=metricDetails,proto3" json:"metric_details,omitempty"`
	// Output only. Conversation level token count per section. This is an
	// aggregated(sum) result of input token of summary acorss all metrics for a
	// single conversation.
	SectionTokens []*SummarizationEvaluationMetrics_SectionToken `protobuf:"bytes,3,rep,name=section_tokens,json=sectionTokens,proto3" json:"section_tokens,omitempty"`
}

func (x *SummarizationEvaluationMetrics_ConversationDetail) Reset() {
	*x = SummarizationEvaluationMetrics_ConversationDetail{}
	mi := &file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SummarizationEvaluationMetrics_ConversationDetail) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SummarizationEvaluationMetrics_ConversationDetail) ProtoMessage() {}

func (x *SummarizationEvaluationMetrics_ConversationDetail) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SummarizationEvaluationMetrics_ConversationDetail.ProtoReflect.Descriptor instead.
func (*SummarizationEvaluationMetrics_ConversationDetail) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_rawDescGZIP(), []int{6, 9}
}

func (x *SummarizationEvaluationMetrics_ConversationDetail) GetMessageEntries() []*MessageEntry {
	if x != nil {
		return x.MessageEntries
	}
	return nil
}

func (x *SummarizationEvaluationMetrics_ConversationDetail) GetSummarySections() []*SummarySuggestion_SummarySection {
	if x != nil {
		return x.SummarySections
	}
	return nil
}

func (x *SummarizationEvaluationMetrics_ConversationDetail) GetMetricDetails() []*SummarizationEvaluationMetrics_ConversationDetail_MetricDetail {
	if x != nil {
		return x.MetricDetails
	}
	return nil
}

func (x *SummarizationEvaluationMetrics_ConversationDetail) GetSectionTokens() []*SummarizationEvaluationMetrics_SectionToken {
	if x != nil {
		return x.SectionTokens
	}
	return nil
}

// Aggregated result on metric level. This contains the evaluation results
// of all the sections.
type SummarizationEvaluationMetrics_ConversationDetail_MetricDetail struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Metrics name. e.g. accuracy, adherence, completeness.
	Metric string `protobuf:"bytes,1,opt,name=metric,proto3" json:"metric,omitempty"`
	// Output only. Aggregated(average) score on this metric across all
	// sections.
	Score *float32 `protobuf:"fixed32,2,opt,name=score,proto3,oneof" json:"score,omitempty"`
	// Output only. List of section details.
	SectionDetails []*SummarizationEvaluationMetrics_ConversationDetail_MetricDetail_SectionDetail `protobuf:"bytes,4,rep,name=section_details,json=sectionDetails,proto3" json:"section_details,omitempty"`
}

func (x *SummarizationEvaluationMetrics_ConversationDetail_MetricDetail) Reset() {
	*x = SummarizationEvaluationMetrics_ConversationDetail_MetricDetail{}
	mi := &file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SummarizationEvaluationMetrics_ConversationDetail_MetricDetail) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SummarizationEvaluationMetrics_ConversationDetail_MetricDetail) ProtoMessage() {}

func (x *SummarizationEvaluationMetrics_ConversationDetail_MetricDetail) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SummarizationEvaluationMetrics_ConversationDetail_MetricDetail.ProtoReflect.Descriptor instead.
func (*SummarizationEvaluationMetrics_ConversationDetail_MetricDetail) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_rawDescGZIP(), []int{6, 9, 0}
}

func (x *SummarizationEvaluationMetrics_ConversationDetail_MetricDetail) GetMetric() string {
	if x != nil {
		return x.Metric
	}
	return ""
}

func (x *SummarizationEvaluationMetrics_ConversationDetail_MetricDetail) GetScore() float32 {
	if x != nil && x.Score != nil {
		return *x.Score
	}
	return 0
}

func (x *SummarizationEvaluationMetrics_ConversationDetail_MetricDetail) GetSectionDetails() []*SummarizationEvaluationMetrics_ConversationDetail_MetricDetail_SectionDetail {
	if x != nil {
		return x.SectionDetails
	}
	return nil
}

// Section level result.
type SummarizationEvaluationMetrics_ConversationDetail_MetricDetail_SectionDetail struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The name of the summary instruction.
	Section string `protobuf:"bytes,1,opt,name=section,proto3" json:"section,omitempty"`
	// Output only. Aggregated(average) score on this section across all
	// evaluation results. Either decompositions or rubrics.
	Score *float32 `protobuf:"fixed32,2,opt,name=score,proto3,oneof" json:"score,omitempty"`
	// Output only. Summary for this section
	SectionSummary string `protobuf:"bytes,4,opt,name=section_summary,json=sectionSummary,proto3" json:"section_summary,omitempty"`
	// Output only. List of evaluation result. The list only contains one
	// kind of the evaluation result.
	EvaluationResults []*SummarizationEvaluationMetrics_EvaluationResult `protobuf:"bytes,5,rep,name=evaluation_results,json=evaluationResults,proto3" json:"evaluation_results,omitempty"`
}

func (x *SummarizationEvaluationMetrics_ConversationDetail_MetricDetail_SectionDetail) Reset() {
	*x = SummarizationEvaluationMetrics_ConversationDetail_MetricDetail_SectionDetail{}
	mi := &file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SummarizationEvaluationMetrics_ConversationDetail_MetricDetail_SectionDetail) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SummarizationEvaluationMetrics_ConversationDetail_MetricDetail_SectionDetail) ProtoMessage() {}

func (x *SummarizationEvaluationMetrics_ConversationDetail_MetricDetail_SectionDetail) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SummarizationEvaluationMetrics_ConversationDetail_MetricDetail_SectionDetail.ProtoReflect.Descriptor instead.
func (*SummarizationEvaluationMetrics_ConversationDetail_MetricDetail_SectionDetail) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_rawDescGZIP(), []int{6, 9, 0, 0}
}

func (x *SummarizationEvaluationMetrics_ConversationDetail_MetricDetail_SectionDetail) GetSection() string {
	if x != nil {
		return x.Section
	}
	return ""
}

func (x *SummarizationEvaluationMetrics_ConversationDetail_MetricDetail_SectionDetail) GetScore() float32 {
	if x != nil && x.Score != nil {
		return *x.Score
	}
	return 0
}

func (x *SummarizationEvaluationMetrics_ConversationDetail_MetricDetail_SectionDetail) GetSectionSummary() string {
	if x != nil {
		return x.SectionSummary
	}
	return ""
}

func (x *SummarizationEvaluationMetrics_ConversationDetail_MetricDetail_SectionDetail) GetEvaluationResults() []*SummarizationEvaluationMetrics_EvaluationResult {
	if x != nil {
		return x.EvaluationResults
	}
	return nil
}

// The distinctive configs for Agent Assist conversations as the conversation
// source.
type GeneratorEvaluationConfig_AgentAssistInputDataConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The start of the time range for conversations to be evaluated.
	// Only conversations created at or after this timestamp will be sampled.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Required. The end of the time range for conversations to be evaluated.
	// Only conversations ended at or before this timestamp will be sampled.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
}

func (x *GeneratorEvaluationConfig_AgentAssistInputDataConfig) Reset() {
	*x = GeneratorEvaluationConfig_AgentAssistInputDataConfig{}
	mi := &file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GeneratorEvaluationConfig_AgentAssistInputDataConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GeneratorEvaluationConfig_AgentAssistInputDataConfig) ProtoMessage() {}

func (x *GeneratorEvaluationConfig_AgentAssistInputDataConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GeneratorEvaluationConfig_AgentAssistInputDataConfig.ProtoReflect.Descriptor instead.
func (*GeneratorEvaluationConfig_AgentAssistInputDataConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_rawDescGZIP(), []int{7, 0}
}

func (x *GeneratorEvaluationConfig_AgentAssistInputDataConfig) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *GeneratorEvaluationConfig_AgentAssistInputDataConfig) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

// The distinctive configs for dataset as the conversation source.
type GeneratorEvaluationConfig_DatasetInputDataConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The identifier of the dataset to be evaluated.
	// Format:
	// `projects/<ProjectId>/locations/<LocationID>/datasets/<DatasetID>`.
	Dataset string `protobuf:"bytes,1,opt,name=dataset,proto3" json:"dataset,omitempty"`
}

func (x *GeneratorEvaluationConfig_DatasetInputDataConfig) Reset() {
	*x = GeneratorEvaluationConfig_DatasetInputDataConfig{}
	mi := &file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GeneratorEvaluationConfig_DatasetInputDataConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GeneratorEvaluationConfig_DatasetInputDataConfig) ProtoMessage() {}

func (x *GeneratorEvaluationConfig_DatasetInputDataConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GeneratorEvaluationConfig_DatasetInputDataConfig.ProtoReflect.Descriptor instead.
func (*GeneratorEvaluationConfig_DatasetInputDataConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_rawDescGZIP(), []int{7, 1}
}

func (x *GeneratorEvaluationConfig_DatasetInputDataConfig) GetDataset() string {
	if x != nil {
		return x.Dataset
	}
	return ""
}

// Input data config details
type GeneratorEvaluationConfig_InputDataConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The source type of input data.
	//
	// Deprecated: Marked as deprecated in google/cloud/dialogflow/v2beta1/generator_evaluation.proto.
	InputDataSourceType GeneratorEvaluationConfig_InputDataSourceType `protobuf:"varint,1,opt,name=input_data_source_type,json=inputDataSourceType,proto3,enum=google.cloud.dialogflow.v2beta1.GeneratorEvaluationConfig_InputDataSourceType" json:"input_data_source_type,omitempty"`
	// Optional. The start timestamp to fetch conversation data.
	//
	// Deprecated: Marked as deprecated in google/cloud/dialogflow/v2beta1/generator_evaluation.proto.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Optional. The end timestamp to fetch conversation data.
	//
	// Deprecated: Marked as deprecated in google/cloud/dialogflow/v2beta1/generator_evaluation.proto.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Optional. Desired number of conversation-summary pairs to be evaluated.
	SampleSize int32 `protobuf:"varint,4,opt,name=sample_size,json=sampleSize,proto3" json:"sample_size,omitempty"`
	// Optional. Whether the summary generation is allowed when the pre-existing
	// qualified summaries are insufficient to cover the sample size.
	//
	// Deprecated: Marked as deprecated in google/cloud/dialogflow/v2beta1/generator_evaluation.proto.
	IsSummaryGenerationAllowed bool `protobuf:"varint,5,opt,name=is_summary_generation_allowed,json=isSummaryGenerationAllowed,proto3" json:"is_summary_generation_allowed,omitempty"`
	// Optional. Option to control whether summaries are generated during
	// evaluation.
	SummaryGenerationOption GeneratorEvaluationConfig_InputDataConfig_SummaryGenerationOption `protobuf:"varint,8,opt,name=summary_generation_option,json=summaryGenerationOption,proto3,enum=google.cloud.dialogflow.v2beta1.GeneratorEvaluationConfig_InputDataConfig_SummaryGenerationOption" json:"summary_generation_option,omitempty"`
	// The source specific config for the input data.
	//
	// Types that are assignable to SourceSpecificConfig:
	//
	//	*GeneratorEvaluationConfig_InputDataConfig_AgentAssistInputDataConfig
	//	*GeneratorEvaluationConfig_InputDataConfig_DatasetInputDataConfig
	SourceSpecificConfig isGeneratorEvaluationConfig_InputDataConfig_SourceSpecificConfig `protobuf_oneof:"source_specific_config"`
}

func (x *GeneratorEvaluationConfig_InputDataConfig) Reset() {
	*x = GeneratorEvaluationConfig_InputDataConfig{}
	mi := &file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GeneratorEvaluationConfig_InputDataConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GeneratorEvaluationConfig_InputDataConfig) ProtoMessage() {}

func (x *GeneratorEvaluationConfig_InputDataConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GeneratorEvaluationConfig_InputDataConfig.ProtoReflect.Descriptor instead.
func (*GeneratorEvaluationConfig_InputDataConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_rawDescGZIP(), []int{7, 2}
}

// Deprecated: Marked as deprecated in google/cloud/dialogflow/v2beta1/generator_evaluation.proto.
func (x *GeneratorEvaluationConfig_InputDataConfig) GetInputDataSourceType() GeneratorEvaluationConfig_InputDataSourceType {
	if x != nil {
		return x.InputDataSourceType
	}
	return GeneratorEvaluationConfig_INPUT_DATA_SOURCE_TYPE_UNSPECIFIED
}

// Deprecated: Marked as deprecated in google/cloud/dialogflow/v2beta1/generator_evaluation.proto.
func (x *GeneratorEvaluationConfig_InputDataConfig) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

// Deprecated: Marked as deprecated in google/cloud/dialogflow/v2beta1/generator_evaluation.proto.
func (x *GeneratorEvaluationConfig_InputDataConfig) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *GeneratorEvaluationConfig_InputDataConfig) GetSampleSize() int32 {
	if x != nil {
		return x.SampleSize
	}
	return 0
}

// Deprecated: Marked as deprecated in google/cloud/dialogflow/v2beta1/generator_evaluation.proto.
func (x *GeneratorEvaluationConfig_InputDataConfig) GetIsSummaryGenerationAllowed() bool {
	if x != nil {
		return x.IsSummaryGenerationAllowed
	}
	return false
}

func (x *GeneratorEvaluationConfig_InputDataConfig) GetSummaryGenerationOption() GeneratorEvaluationConfig_InputDataConfig_SummaryGenerationOption {
	if x != nil {
		return x.SummaryGenerationOption
	}
	return GeneratorEvaluationConfig_InputDataConfig_SUMMARY_GENERATION_OPTION_UNSPECIFIED
}

func (m *GeneratorEvaluationConfig_InputDataConfig) GetSourceSpecificConfig() isGeneratorEvaluationConfig_InputDataConfig_SourceSpecificConfig {
	if m != nil {
		return m.SourceSpecificConfig
	}
	return nil
}

func (x *GeneratorEvaluationConfig_InputDataConfig) GetAgentAssistInputDataConfig() *GeneratorEvaluationConfig_AgentAssistInputDataConfig {
	if x, ok := x.GetSourceSpecificConfig().(*GeneratorEvaluationConfig_InputDataConfig_AgentAssistInputDataConfig); ok {
		return x.AgentAssistInputDataConfig
	}
	return nil
}

func (x *GeneratorEvaluationConfig_InputDataConfig) GetDatasetInputDataConfig() *GeneratorEvaluationConfig_DatasetInputDataConfig {
	if x, ok := x.GetSourceSpecificConfig().(*GeneratorEvaluationConfig_InputDataConfig_DatasetInputDataConfig); ok {
		return x.DatasetInputDataConfig
	}
	return nil
}

type isGeneratorEvaluationConfig_InputDataConfig_SourceSpecificConfig interface {
	isGeneratorEvaluationConfig_InputDataConfig_SourceSpecificConfig()
}

type GeneratorEvaluationConfig_InputDataConfig_AgentAssistInputDataConfig struct {
	// The distinctive configs for Agent Assist conversations as the
	// conversation source.
	AgentAssistInputDataConfig *GeneratorEvaluationConfig_AgentAssistInputDataConfig `protobuf:"bytes,6,opt,name=agent_assist_input_data_config,json=agentAssistInputDataConfig,proto3,oneof"`
}

type GeneratorEvaluationConfig_InputDataConfig_DatasetInputDataConfig struct {
	// The distinctive configs for dataset as the conversation source.
	DatasetInputDataConfig *GeneratorEvaluationConfig_DatasetInputDataConfig `protobuf:"bytes,7,opt,name=dataset_input_data_config,json=datasetInputDataConfig,proto3,oneof"`
}

func (*GeneratorEvaluationConfig_InputDataConfig_AgentAssistInputDataConfig) isGeneratorEvaluationConfig_InputDataConfig_SourceSpecificConfig() {
}

func (*GeneratorEvaluationConfig_InputDataConfig_DatasetInputDataConfig) isGeneratorEvaluationConfig_InputDataConfig_SourceSpecificConfig() {
}

// Evaluation configs for summarization generator.
type GeneratorEvaluationConfig_SummarizationConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Enable accuracy evaluation.
	//
	// Deprecated: Marked as deprecated in google/cloud/dialogflow/v2beta1/generator_evaluation.proto.
	EnableAccuracyEvaluation bool `protobuf:"varint,1,opt,name=enable_accuracy_evaluation,json=enableAccuracyEvaluation,proto3" json:"enable_accuracy_evaluation,omitempty"`
	// Optional. Version for summarization accuracy. This will determine the
	// prompt and model used at backend.
	//
	// Deprecated: Marked as deprecated in google/cloud/dialogflow/v2beta1/generator_evaluation.proto.
	AccuracyEvaluationVersion string `protobuf:"bytes,2,opt,name=accuracy_evaluation_version,json=accuracyEvaluationVersion,proto3" json:"accuracy_evaluation_version,omitempty"`
	// Optional. Enable completeness evaluation.
	//
	// Deprecated: Marked as deprecated in google/cloud/dialogflow/v2beta1/generator_evaluation.proto.
	EnableCompletenessEvaluation bool `protobuf:"varint,3,opt,name=enable_completeness_evaluation,json=enableCompletenessEvaluation,proto3" json:"enable_completeness_evaluation,omitempty"`
	// Optional. Version for summarization completeness. This will determine the
	// prompt and model used at backend.
	//
	// Deprecated: Marked as deprecated in google/cloud/dialogflow/v2beta1/generator_evaluation.proto.
	CompletenessEvaluationVersion string `protobuf:"bytes,4,opt,name=completeness_evaluation_version,json=completenessEvaluationVersion,proto3" json:"completeness_evaluation_version,omitempty"`
	// Optional. Version for summarization evaluation.
	EvaluatorVersion *string `protobuf:"bytes,5,opt,name=evaluator_version,json=evaluatorVersion,proto3,oneof" json:"evaluator_version,omitempty"`
}

func (x *GeneratorEvaluationConfig_SummarizationConfig) Reset() {
	*x = GeneratorEvaluationConfig_SummarizationConfig{}
	mi := &file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GeneratorEvaluationConfig_SummarizationConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GeneratorEvaluationConfig_SummarizationConfig) ProtoMessage() {}

func (x *GeneratorEvaluationConfig_SummarizationConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GeneratorEvaluationConfig_SummarizationConfig.ProtoReflect.Descriptor instead.
func (*GeneratorEvaluationConfig_SummarizationConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_rawDescGZIP(), []int{7, 3}
}

// Deprecated: Marked as deprecated in google/cloud/dialogflow/v2beta1/generator_evaluation.proto.
func (x *GeneratorEvaluationConfig_SummarizationConfig) GetEnableAccuracyEvaluation() bool {
	if x != nil {
		return x.EnableAccuracyEvaluation
	}
	return false
}

// Deprecated: Marked as deprecated in google/cloud/dialogflow/v2beta1/generator_evaluation.proto.
func (x *GeneratorEvaluationConfig_SummarizationConfig) GetAccuracyEvaluationVersion() string {
	if x != nil {
		return x.AccuracyEvaluationVersion
	}
	return ""
}

// Deprecated: Marked as deprecated in google/cloud/dialogflow/v2beta1/generator_evaluation.proto.
func (x *GeneratorEvaluationConfig_SummarizationConfig) GetEnableCompletenessEvaluation() bool {
	if x != nil {
		return x.EnableCompletenessEvaluation
	}
	return false
}

// Deprecated: Marked as deprecated in google/cloud/dialogflow/v2beta1/generator_evaluation.proto.
func (x *GeneratorEvaluationConfig_SummarizationConfig) GetCompletenessEvaluationVersion() string {
	if x != nil {
		return x.CompletenessEvaluationVersion
	}
	return ""
}

func (x *GeneratorEvaluationConfig_SummarizationConfig) GetEvaluatorVersion() string {
	if x != nil && x.EvaluatorVersion != nil {
		return *x.EvaluatorVersion
	}
	return ""
}

var File_google_cloud_dialogflow_v2beta1_generator_evaluation_proto protoreflect.FileDescriptor

var file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_rawDesc = []byte{
	0x0a, 0x3a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x5f, 0x65, 0x76, 0x61, 0x6c,
	0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x1c, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67,
	0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72,
	0x70, 0x63, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22,
	0xdf, 0x01, 0x0a, 0x20, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x6f, 0x72, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x4d, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f, 0x12, 0x2d, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f,
	0x72, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x6c, 0x0a, 0x14, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72,
	0x5f, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x45, 0x76, 0x61,
	0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x13, 0x67, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x6a, 0x0a, 0x1d, 0x47, 0x65, 0x74, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f,
	0x72, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x49, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f, 0x0a, 0x2d, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x45, 0x76, 0x61,
	0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xb6, 0x01,
	0x0a, 0x1f, 0x4c, 0x69, 0x73, 0x74, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x45,
	0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x4d, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f, 0x12, 0x2d, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x45, 0x76,
	0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69,
	0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xb5, 0x01, 0x0a, 0x20, 0x4c, 0x69, 0x73, 0x74, 0x47,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x69, 0x0a, 0x15, 0x67,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x5f, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x6e,
	0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x14, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x45, 0x76, 0x61, 0x6c, 0x75,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x6d,
	0x0a, 0x20, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f,
	0x72, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x49, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f, 0x0a, 0x2d, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x45, 0x76, 0x61,
	0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xe9, 0x07,
	0x0a, 0x13, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x45, 0x76, 0x61, 0x6c, 0x75,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1a, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x08, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x69,
	0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x7f, 0x0a, 0x1b, 0x67, 0x65, 0x6e,
	0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x5f, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x19, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x44, 0x0a, 0x0d,
	0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x5c, 0x0a, 0x11, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x5f, 0x67, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10,
	0x69, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72,
	0x12, 0x7b, 0x0a, 0x15, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45,
	0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x14, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x63, 0x0a,
	0x11, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x76, 0x61, 0x6c, 0x75,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x10, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x12, 0x2d, 0x0a, 0x0d, 0x73, 0x61, 0x74, 0x69, 0x73, 0x66, 0x69, 0x65, 0x73, 0x5f,
	0x70, 0x7a, 0x73, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x01,
	0x52, 0x0c, 0x73, 0x61, 0x74, 0x69, 0x73, 0x66, 0x69, 0x65, 0x73, 0x50, 0x7a, 0x73, 0x88, 0x01,
	0x01, 0x12, 0x2d, 0x0a, 0x0d, 0x73, 0x61, 0x74, 0x69, 0x73, 0x66, 0x69, 0x65, 0x73, 0x5f, 0x70,
	0x7a, 0x69, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x02, 0x52,
	0x0c, 0x73, 0x61, 0x74, 0x69, 0x73, 0x66, 0x69, 0x65, 0x73, 0x50, 0x7a, 0x69, 0x88, 0x01, 0x01,
	0x3a, 0xb7, 0x01, 0xea, 0x41, 0xb3, 0x01, 0x0a, 0x2d, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x45, 0x76, 0x61, 0x6c,
	0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x57, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f,
	0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x73, 0x2f, 0x7b, 0x67, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x6f, 0x72, 0x7d, 0x2f, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x7b, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2a,
	0x14, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x32, 0x13, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72,
	0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x09, 0x0a, 0x07, 0x6d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x73, 0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x73, 0x61, 0x74, 0x69, 0x73, 0x66,
	0x69, 0x65, 0x73, 0x5f, 0x70, 0x7a, 0x73, 0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x73, 0x61, 0x74, 0x69,
	0x73, 0x66, 0x69, 0x65, 0x73, 0x5f, 0x70, 0x7a, 0x69, 0x22, 0xfd, 0x1c, 0x0a, 0x1e, 0x53, 0x75,
	0x6d, 0x6d, 0x61, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x61, 0x6c, 0x75,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0xac, 0x01, 0x0a,
	0x20, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x65,
	0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x5d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x1e, 0x73, 0x75, 0x6d,
	0x6d, 0x61, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x61, 0x0a, 0x2b, 0x73,
	0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x76, 0x61,
	0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x72, 0x67, 0x65, 0x64, 0x5f, 0x72,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x27, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x72, 0x67, 0x65, 0x64, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x55, 0x72, 0x69, 0x12, 0x83,
	0x01, 0x0a, 0x0f, 0x6f, 0x76, 0x65, 0x72, 0x61, 0x6c, 0x6c, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x55, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x75, 0x6d, 0x6d, 0x61,
	0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x4f, 0x76, 0x65, 0x72, 0x61, 0x6c,
	0x6c, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x73, 0x42, 0x79, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x6f, 0x76, 0x65, 0x72, 0x61, 0x6c, 0x6c, 0x4d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x73, 0x12, 0x87, 0x01, 0x0a, 0x16, 0x6f, 0x76, 0x65, 0x72, 0x61, 0x6c, 0x6c,
	0x5f, 0x73, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x18,
	0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x53, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x14, 0x6f, 0x76, 0x65, 0x72, 0x61, 0x6c,
	0x6c, 0x53, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x12, 0x8a,
	0x01, 0x0a, 0x14, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x52, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x61,
	0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x43,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x13, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x1a, 0xa1, 0x01, 0x0a, 0x15,
	0x41, 0x63, 0x63, 0x75, 0x72, 0x61, 0x63, 0x79, 0x44, 0x65, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x19, 0x0a, 0x05, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x70, 0x6f, 0x69, 0x6e, 0x74,
	0x12, 0x32, 0x0a, 0x12, 0x61, 0x63, 0x63, 0x75, 0x72, 0x61, 0x63, 0x79, 0x5f, 0x72, 0x65, 0x61,
	0x73, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x11, 0x61, 0x63, 0x63, 0x75, 0x72, 0x61, 0x63, 0x79, 0x52, 0x65, 0x61, 0x73, 0x6f,
	0x6e, 0x69, 0x6e, 0x67, 0x12, 0x29, 0x0a, 0x0b, 0x69, 0x73, 0x5f, 0x61, 0x63, 0x63, 0x75, 0x72,
	0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00,
	0x52, 0x0a, 0x69, 0x73, 0x41, 0x63, 0x63, 0x75, 0x72, 0x61, 0x74, 0x65, 0x88, 0x01, 0x01, 0x42,
	0x0e, 0x0a, 0x0c, 0x5f, 0x69, 0x73, 0x5f, 0x61, 0x63, 0x63, 0x75, 0x72, 0x61, 0x74, 0x65, 0x1a,
	0x93, 0x01, 0x0a, 0x16, 0x41, 0x64, 0x68, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x44, 0x65, 0x63,
	0x6f, 0x6d, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x19, 0x0a, 0x05, 0x70, 0x6f,
	0x69, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05,
	0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x34, 0x0a, 0x13, 0x61, 0x64, 0x68, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x5f, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x12, 0x61, 0x64, 0x68, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x12, 0x24, 0x0a, 0x0b, 0x69,
	0x73, 0x5f, 0x61, 0x64, 0x68, 0x65, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x69, 0x73, 0x41, 0x64, 0x68, 0x65, 0x72, 0x65, 0x6e,
	0x74, 0x3a, 0x02, 0x18, 0x01, 0x1a, 0x93, 0x01, 0x0a, 0x0f, 0x41, 0x64, 0x68, 0x65, 0x72, 0x65,
	0x6e, 0x63, 0x65, 0x52, 0x75, 0x62, 0x72, 0x69, 0x63, 0x12, 0x1f, 0x0a, 0x08, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x08, 0x71, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x21, 0x0a, 0x09, 0x72, 0x65,
	0x61, 0x73, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x09, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x12, 0x2b, 0x0a,
	0x0c, 0x69, 0x73, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x64, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x0b, 0x69, 0x73, 0x41, 0x64,
	0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x64, 0x88, 0x01, 0x01, 0x42, 0x0f, 0x0a, 0x0d, 0x5f, 0x69,
	0x73, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x64, 0x1a, 0x73, 0x0a, 0x12, 0x43,
	0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x6e, 0x65, 0x73, 0x73, 0x52, 0x75, 0x62, 0x72, 0x69,
	0x63, 0x12, 0x1f, 0x0a, 0x08, 0x71, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x71, 0x75, 0x65, 0x73, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x2b, 0x0a, 0x0c, 0x69, 0x73, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73,
	0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52,
	0x0b, 0x69, 0x73, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x64, 0x88, 0x01, 0x01, 0x42,
	0x0f, 0x0a, 0x0d, 0x5f, 0x69, 0x73, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x64,
	0x1a, 0xc9, 0x02, 0x0a, 0x0d, 0x44, 0x65, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x8e, 0x01, 0x0a, 0x16, 0x61, 0x63, 0x63, 0x75, 0x72, 0x61, 0x63, 0x79, 0x5f,
	0x64, 0x65, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x55, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x73, 0x2e, 0x41, 0x63, 0x63, 0x75, 0x72, 0x61, 0x63, 0x79, 0x44, 0x65, 0x63,
	0x6f, 0x6d, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x15, 0x61, 0x63,
	0x63, 0x75, 0x72, 0x61, 0x63, 0x79, 0x44, 0x65, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x91, 0x01, 0x0a, 0x17, 0x61, 0x64, 0x68, 0x65, 0x72, 0x65, 0x6e, 0x63,
	0x65, 0x5f, 0x64, 0x65, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x56, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x41, 0x64, 0x68, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x44, 0x65, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52,
	0x16, 0x61, 0x64, 0x68, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x44, 0x65, 0x63, 0x6f, 0x6d, 0x70,
	0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x02, 0x18, 0x01, 0x42, 0x0f, 0x0a, 0x0d, 0x64,
	0x65, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0xb3, 0x03, 0x0a,
	0x10, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x12, 0x8e, 0x01, 0x0a, 0x16, 0x61, 0x63, 0x63, 0x75, 0x72, 0x61, 0x63, 0x79, 0x5f, 0x64,
	0x65, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x55, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x73, 0x2e, 0x41, 0x63, 0x63, 0x75, 0x72, 0x61, 0x63, 0x79, 0x44, 0x65, 0x63, 0x6f,
	0x6d, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x15, 0x61, 0x63, 0x63,
	0x75, 0x72, 0x61, 0x63, 0x79, 0x44, 0x65, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x7c, 0x0a, 0x10, 0x61, 0x64, 0x68, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x5f,
	0x72, 0x75, 0x62, 0x72, 0x69, 0x63, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53,
	0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x61, 0x6c,
	0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x41, 0x64,
	0x68, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x75, 0x62, 0x72, 0x69, 0x63, 0x48, 0x00, 0x52,
	0x0f, 0x61, 0x64, 0x68, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x75, 0x62, 0x72, 0x69, 0x63,
	0x12, 0x85, 0x01, 0x0a, 0x13, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x6e, 0x65, 0x73,
	0x73, 0x5f, 0x72, 0x75, 0x62, 0x72, 0x69, 0x63, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x52,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x76,
	0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e,
	0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x6e, 0x65, 0x73, 0x73, 0x52, 0x75, 0x62, 0x72,
	0x69, 0x63, 0x48, 0x00, 0x52, 0x12, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x6e, 0x65,
	0x73, 0x73, 0x52, 0x75, 0x62, 0x72, 0x69, 0x63, 0x42, 0x08, 0x0a, 0x06, 0x72, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x1a, 0xcf, 0x03, 0x0a, 0x1d, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x12, 0x24, 0x0a, 0x0a, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x05, 0xe0, 0x41, 0x03, 0x18, 0x01, 0x52,
	0x09, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x1b, 0x0a, 0x06, 0x6d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x06, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x12, 0x1d, 0x0a, 0x07, 0x73, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x73,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x19, 0x0a, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x02, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x63, 0x6f, 0x72,
	0x65, 0x12, 0x2c, 0x0a, 0x0f, 0x73, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x75, 0x6d,
	0x6d, 0x61, 0x72, 0x79, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0e, 0x73, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x12,
	0x7c, 0x0a, 0x0e, 0x64, 0x65, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x44, 0x65, 0x63, 0x6f, 0x6d, 0x70, 0x6f,
	0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x05, 0xe0, 0x41, 0x03, 0x18, 0x01, 0x52, 0x0e, 0x64,
	0x65, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x84, 0x01,
	0x0a, 0x12, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x50, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x75, 0x6d,
	0x6d, 0x61, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x45, 0x76, 0x61, 0x6c,
	0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x11, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x73, 0x1a, 0x34, 0x0a, 0x15, 0x4f, 0x76, 0x65, 0x72, 0x61, 0x6c, 0x6c, 0x53,
	0x63, 0x6f, 0x72, 0x65, 0x73, 0x42, 0x79, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x12, 0x1b, 0x0a,
	0x06, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x06, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x1a, 0x68, 0x0a, 0x0c, 0x53, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1d, 0x0a, 0x07, 0x73, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x07, 0x73, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x29, 0x0a, 0x0b, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x0a, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x43, 0x6f, 0x75, 0x6e,
	0x74, 0x88, 0x01, 0x01, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x1a, 0xf2, 0x07, 0x0a, 0x12, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x12, 0x5b, 0x0a, 0x0f, 0x6d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76,
	0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x45, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x12, 0x71, 0x0a, 0x10, 0x73, 0x75, 0x6d, 0x6d,
	0x61, 0x72, 0x79, 0x5f, 0x73, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x53, 0x75, 0x67, 0x67,
	0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x53, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x73, 0x75, 0x6d, 0x6d,
	0x61, 0x72, 0x79, 0x53, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x8b, 0x01, 0x0a, 0x0e,
	0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x5f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76,
	0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x44,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x6d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x78, 0x0a, 0x0e, 0x73, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x73, 0x2e, 0x53, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x73, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x73, 0x1a, 0x83, 0x04, 0x0a, 0x0c, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x44, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x12, 0x1b, 0x0a, 0x06, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x6d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x12, 0x1e, 0x0a, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x88, 0x01,
	0x01, 0x12, 0x9b, 0x01, 0x0a, 0x0f, 0x73, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x6d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x75,
	0x6d, 0x6d, 0x61, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x61, 0x6c, 0x75,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x43, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e,
	0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x53, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0e, 0x73, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x1a,
	0x8d, 0x02, 0x0a, 0x0d, 0x53, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x12, 0x1d, 0x0a, 0x07, 0x73, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x73, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x1e, 0x0a, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x88, 0x01, 0x01,
	0x12, 0x2c, 0x0a, 0x0f, 0x73, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x75, 0x6d, 0x6d,
	0x61, 0x72, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e,
	0x73, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x12, 0x84,
	0x01, 0x0a, 0x12, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x50, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x75,
	0x6d, 0x6d, 0x61, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x61, 0x6c, 0x75,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x45, 0x76, 0x61,
	0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x11, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x73, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x42,
	0x08, 0x0a, 0x06, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x22, 0xdb, 0x10, 0x0a, 0x19, 0x47, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x7b, 0x0a, 0x11, 0x69, 0x6e, 0x70, 0x75, 0x74,
	0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x45, 0x76,
	0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x49,
	0x6e, 0x70, 0x75, 0x74, 0x44, 0x61, 0x74, 0x61, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x44, 0x61, 0x74, 0x61, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x38, 0x0a, 0x16, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x67,
	0x63, 0x73, 0x5f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x13, 0x6f, 0x75, 0x74, 0x70, 0x75,
	0x74, 0x47, 0x63, 0x73, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x50, 0x61, 0x74, 0x68, 0x12, 0x83,
	0x01, 0x0a, 0x14, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52,
	0x13, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x1a, 0x98, 0x01, 0x0a, 0x1a, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x41, 0x73,
	0x73, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x44, 0x61, 0x74, 0x61, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x3e, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x1a,
	0x37, 0x0a, 0x16, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x44,
	0x61, 0x74, 0x61, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1d, 0x0a, 0x07, 0x64, 0x61, 0x74,
	0x61, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x07, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x1a, 0x87, 0x08, 0x0a, 0x0f, 0x49, 0x6e, 0x70,
	0x75, 0x74, 0x44, 0x61, 0x74, 0x61, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x8a, 0x01, 0x0a,
	0x16, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x44,
	0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x42, 0x05, 0xe0,
	0x41, 0x02, 0x18, 0x01, 0x52, 0x13, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x44, 0x61, 0x74, 0x61, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x40, 0x0a, 0x0a, 0x73, 0x74, 0x61,
	0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x05, 0xe0, 0x41, 0x01, 0x18, 0x01,
	0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3c, 0x0a, 0x08, 0x65,
	0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x05, 0xe0, 0x41, 0x01, 0x18, 0x01,
	0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x24, 0x0a, 0x0b, 0x73, 0x61, 0x6d,
	0x70, 0x6c, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0a, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12,
	0x48, 0x0a, 0x1d, 0x69, 0x73, 0x5f, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x5f, 0x67, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x42, 0x05, 0xe0, 0x41, 0x01, 0x18, 0x01, 0x52, 0x1a, 0x69,
	0x73, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x41, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x12, 0xa3, 0x01, 0x0a, 0x19, 0x73, 0x75,
	0x6d, 0x6d, 0x61, 0x72, 0x79, 0x5f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x62, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x44,
	0x61, 0x74, 0x61, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72,
	0x79, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x17, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x47,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x9b, 0x01, 0x0a, 0x1e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x61, 0x73, 0x73, 0x69, 0x73, 0x74,
	0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x55, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x6f, 0x72, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x41, 0x73, 0x73, 0x69, 0x73, 0x74,
	0x49, 0x6e, 0x70, 0x75, 0x74, 0x44, 0x61, 0x74, 0x61, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48,
	0x00, 0x52, 0x1a, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x41, 0x73, 0x73, 0x69, 0x73, 0x74, 0x49, 0x6e,
	0x70, 0x75, 0x74, 0x44, 0x61, 0x74, 0x61, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x8e, 0x01,
	0x0a, 0x19, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f,
	0x64, 0x61, 0x74, 0x61, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x51, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x45, 0x76, 0x61,
	0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x44, 0x61,
	0x74, 0x61, 0x73, 0x65, 0x74, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x44, 0x61, 0x74, 0x61, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x16, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x49,
	0x6e, 0x70, 0x75, 0x74, 0x44, 0x61, 0x74, 0x61, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x87,
	0x01, 0x0a, 0x17, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x29, 0x0a, 0x25, 0x53, 0x55,
	0x4d, 0x4d, 0x41, 0x52, 0x59, 0x5f, 0x47, 0x45, 0x4e, 0x45, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e,
	0x5f, 0x4f, 0x50, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x13, 0x0a, 0x0f, 0x41, 0x4c, 0x57, 0x41, 0x59, 0x53, 0x5f,
	0x47, 0x45, 0x4e, 0x45, 0x52, 0x41, 0x54, 0x45, 0x10, 0x01, 0x12, 0x17, 0x0a, 0x13, 0x47, 0x45,
	0x4e, 0x45, 0x52, 0x41, 0x54, 0x45, 0x5f, 0x49, 0x46, 0x5f, 0x4d, 0x49, 0x53, 0x53, 0x49, 0x4e,
	0x47, 0x10, 0x02, 0x12, 0x13, 0x0a, 0x0f, 0x44, 0x4f, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x47, 0x45,
	0x4e, 0x45, 0x52, 0x41, 0x54, 0x45, 0x10, 0x03, 0x42, 0x18, 0x0a, 0x16, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x63, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x1a, 0x8a, 0x03, 0x0a, 0x13, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x43, 0x0a, 0x1a, 0x65, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x75, 0x72, 0x61, 0x63, 0x79, 0x5f, 0x65, 0x76,
	0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x42, 0x05,
	0xe0, 0x41, 0x01, 0x18, 0x01, 0x52, 0x18, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x41, 0x63, 0x63,
	0x75, 0x72, 0x61, 0x63, 0x79, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x45, 0x0a, 0x1b, 0x61, 0x63, 0x63, 0x75, 0x72, 0x61, 0x63, 0x79, 0x5f, 0x65, 0x76, 0x61, 0x6c,
	0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x05, 0xe0, 0x41, 0x01, 0x18, 0x01, 0x52, 0x19, 0x61, 0x63, 0x63,
	0x75, 0x72, 0x61, 0x63, 0x79, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x4b, 0x0a, 0x1e, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x6e, 0x65, 0x73, 0x73, 0x5f, 0x65, 0x76,
	0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x42, 0x05,
	0xe0, 0x41, 0x01, 0x18, 0x01, 0x52, 0x1c, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x6f, 0x6d,
	0x70, 0x6c, 0x65, 0x74, 0x65, 0x6e, 0x65, 0x73, 0x73, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x4d, 0x0a, 0x1f, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x6e,
	0x65, 0x73, 0x73, 0x5f, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x05, 0xe0, 0x41,
	0x01, 0x18, 0x01, 0x52, 0x1d, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x6e, 0x65, 0x73,
	0x73, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x12, 0x35, 0x0a, 0x11, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x6f, 0x72, 0x5f,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x48, 0x00, 0x52, 0x10, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x6f, 0x72, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x42, 0x14, 0x0a, 0x12, 0x5f, 0x65, 0x76,
	0x61, 0x6c, 0x75, 0x61, 0x74, 0x6f, 0x72, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22,
	0x79, 0x0a, 0x13, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x26, 0x0a, 0x22, 0x49, 0x4e, 0x50, 0x55, 0x54, 0x5f,
	0x44, 0x41, 0x54, 0x41, 0x5f, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1e,
	0x0a, 0x1a, 0x41, 0x47, 0x45, 0x4e, 0x54, 0x5f, 0x41, 0x53, 0x53, 0x49, 0x53, 0x54, 0x5f, 0x43,
	0x4f, 0x4e, 0x56, 0x45, 0x52, 0x53, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x53, 0x10, 0x01, 0x12, 0x1a,
	0x0a, 0x16, 0x49, 0x4e, 0x53, 0x49, 0x47, 0x48, 0x54, 0x53, 0x5f, 0x43, 0x4f, 0x4e, 0x56, 0x45,
	0x52, 0x53, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x53, 0x10, 0x02, 0x42, 0x1b, 0x0a, 0x19, 0x65, 0x76,
	0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x7b, 0x0a, 0x10, 0x45, 0x76, 0x61, 0x6c, 0x75,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x1c, 0x0a, 0x04, 0x64,
	0x6f, 0x6e, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00,
	0x52, 0x04, 0x64, 0x6f, 0x6e, 0x65, 0x88, 0x01, 0x01, 0x12, 0x40, 0x0a, 0x0f, 0x70, 0x69, 0x70,
	0x65, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x70, 0x69, 0x70,
	0x65, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x07, 0x0a, 0x05, 0x5f,
	0x64, 0x6f, 0x6e, 0x65, 0x32, 0x92, 0x09, 0x0a, 0x14, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74,
	0x6f, 0x72, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0xdb, 0x02,
	0x0a, 0x19, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f,
	0x72, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x41, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x45, 0x76, 0x61,
	0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xdb, 0x01,
	0xca, 0x41, 0x5b, 0x0a, 0x13, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x45, 0x76,
	0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x44, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x6f, 0x72, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41,
	0x1b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f,
	0x72, 0x5f, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x59, 0x3a, 0x14, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x5f, 0x65, 0x76,
	0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x41, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0xe0, 0x01, 0x0a, 0x16,
	0x47, 0x65, 0x74, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x45, 0x76, 0x61, 0x6c,
	0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x47, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x6f, 0x72, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74,
	0x6f, 0x72, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x50, 0xda, 0x41,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x43, 0x12, 0x41, 0x2f, 0x76, 0x32,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x73, 0x2f, 0x2a, 0x2f,
	0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xf3,
	0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72,
	0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x40, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x45, 0x76, 0x61, 0x6c, 0x75,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x41, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x45, 0x76, 0x61,
	0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x52, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x43, 0x12, 0x41, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x67, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x6f, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0xc8, 0x01, 0x0a, 0x19, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x47,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x47, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x6f, 0x72, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x50, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x43, 0x2a, 0x41, 0x2f, 0x76,
	0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x73, 0x2f, 0x2a,
	0x2f, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x1a,
	0x78, 0xca, 0x41, 0x19, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x59,
	0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2c, 0x68,
	0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x42, 0xad, 0x01, 0x0a, 0x23, 0x63, 0x6f,
	0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x42, 0x18, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x45, 0x76, 0x61, 0x6c,
	0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x43, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x67, 0x6f, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x61, 0x70,
	0x69, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x70, 0x62, 0x3b, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x70, 0x62, 0xa2, 0x02, 0x02, 0x44, 0x46, 0xaa, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x56, 0x32, 0x42, 0x65, 0x74, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x33,
}

var (
	file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_rawDescOnce sync.Once
	file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_rawDescData = file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_rawDesc
)

func file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_rawDescGZIP() []byte {
	file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_rawDescOnce.Do(func() {
		file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_rawDescData)
	})
	return file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_rawDescData
}

var file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_msgTypes = make([]protoimpl.MessageInfo, 25)
var file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_goTypes = []any{
	(GeneratorEvaluationConfig_InputDataSourceType)(0),                                   // 0: google.cloud.dialogflow.v2beta1.GeneratorEvaluationConfig.InputDataSourceType
	(GeneratorEvaluationConfig_InputDataConfig_SummaryGenerationOption)(0),               // 1: google.cloud.dialogflow.v2beta1.GeneratorEvaluationConfig.InputDataConfig.SummaryGenerationOption
	(*CreateGeneratorEvaluationRequest)(nil),                                             // 2: google.cloud.dialogflow.v2beta1.CreateGeneratorEvaluationRequest
	(*GetGeneratorEvaluationRequest)(nil),                                                // 3: google.cloud.dialogflow.v2beta1.GetGeneratorEvaluationRequest
	(*ListGeneratorEvaluationsRequest)(nil),                                              // 4: google.cloud.dialogflow.v2beta1.ListGeneratorEvaluationsRequest
	(*ListGeneratorEvaluationsResponse)(nil),                                             // 5: google.cloud.dialogflow.v2beta1.ListGeneratorEvaluationsResponse
	(*DeleteGeneratorEvaluationRequest)(nil),                                             // 6: google.cloud.dialogflow.v2beta1.DeleteGeneratorEvaluationRequest
	(*GeneratorEvaluation)(nil),                                                          // 7: google.cloud.dialogflow.v2beta1.GeneratorEvaluation
	(*SummarizationEvaluationMetrics)(nil),                                               // 8: google.cloud.dialogflow.v2beta1.SummarizationEvaluationMetrics
	(*GeneratorEvaluationConfig)(nil),                                                    // 9: google.cloud.dialogflow.v2beta1.GeneratorEvaluationConfig
	(*EvaluationStatus)(nil),                                                             // 10: google.cloud.dialogflow.v2beta1.EvaluationStatus
	(*SummarizationEvaluationMetrics_AccuracyDecomposition)(nil),                         // 11: google.cloud.dialogflow.v2beta1.SummarizationEvaluationMetrics.AccuracyDecomposition
	(*SummarizationEvaluationMetrics_AdherenceDecomposition)(nil),                        // 12: google.cloud.dialogflow.v2beta1.SummarizationEvaluationMetrics.AdherenceDecomposition
	(*SummarizationEvaluationMetrics_AdherenceRubric)(nil),                               // 13: google.cloud.dialogflow.v2beta1.SummarizationEvaluationMetrics.AdherenceRubric
	(*SummarizationEvaluationMetrics_CompletenessRubric)(nil),                            // 14: google.cloud.dialogflow.v2beta1.SummarizationEvaluationMetrics.CompletenessRubric
	(*SummarizationEvaluationMetrics_Decomposition)(nil),                                 // 15: google.cloud.dialogflow.v2beta1.SummarizationEvaluationMetrics.Decomposition
	(*SummarizationEvaluationMetrics_EvaluationResult)(nil),                              // 16: google.cloud.dialogflow.v2beta1.SummarizationEvaluationMetrics.EvaluationResult
	(*SummarizationEvaluationMetrics_SummarizationEvaluationResult)(nil),                 // 17: google.cloud.dialogflow.v2beta1.SummarizationEvaluationMetrics.SummarizationEvaluationResult
	(*SummarizationEvaluationMetrics_OverallScoresByMetric)(nil),                         // 18: google.cloud.dialogflow.v2beta1.SummarizationEvaluationMetrics.OverallScoresByMetric
	(*SummarizationEvaluationMetrics_SectionToken)(nil),                                  // 19: google.cloud.dialogflow.v2beta1.SummarizationEvaluationMetrics.SectionToken
	(*SummarizationEvaluationMetrics_ConversationDetail)(nil),                            // 20: google.cloud.dialogflow.v2beta1.SummarizationEvaluationMetrics.ConversationDetail
	(*SummarizationEvaluationMetrics_ConversationDetail_MetricDetail)(nil),               // 21: google.cloud.dialogflow.v2beta1.SummarizationEvaluationMetrics.ConversationDetail.MetricDetail
	(*SummarizationEvaluationMetrics_ConversationDetail_MetricDetail_SectionDetail)(nil), // 22: google.cloud.dialogflow.v2beta1.SummarizationEvaluationMetrics.ConversationDetail.MetricDetail.SectionDetail
	(*GeneratorEvaluationConfig_AgentAssistInputDataConfig)(nil),                         // 23: google.cloud.dialogflow.v2beta1.GeneratorEvaluationConfig.AgentAssistInputDataConfig
	(*GeneratorEvaluationConfig_DatasetInputDataConfig)(nil),                             // 24: google.cloud.dialogflow.v2beta1.GeneratorEvaluationConfig.DatasetInputDataConfig
	(*GeneratorEvaluationConfig_InputDataConfig)(nil),                                    // 25: google.cloud.dialogflow.v2beta1.GeneratorEvaluationConfig.InputDataConfig
	(*GeneratorEvaluationConfig_SummarizationConfig)(nil),                                // 26: google.cloud.dialogflow.v2beta1.GeneratorEvaluationConfig.SummarizationConfig
	(*timestamppb.Timestamp)(nil),                                                        // 27: google.protobuf.Timestamp
	(*Generator)(nil),                                                                    // 28: google.cloud.dialogflow.v2beta1.Generator
	(*status.Status)(nil),                                                                // 29: google.rpc.Status
	(*MessageEntry)(nil),                                                                 // 30: google.cloud.dialogflow.v2beta1.MessageEntry
	(*SummarySuggestion_SummarySection)(nil),                                             // 31: google.cloud.dialogflow.v2beta1.SummarySuggestion.SummarySection
	(*longrunningpb.Operation)(nil),                                                      // 32: google.longrunning.Operation
	(*emptypb.Empty)(nil),                                                                // 33: google.protobuf.Empty
}
var file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_depIdxs = []int32{
	7,  // 0: google.cloud.dialogflow.v2beta1.CreateGeneratorEvaluationRequest.generator_evaluation:type_name -> google.cloud.dialogflow.v2beta1.GeneratorEvaluation
	7,  // 1: google.cloud.dialogflow.v2beta1.ListGeneratorEvaluationsResponse.generator_evaluations:type_name -> google.cloud.dialogflow.v2beta1.GeneratorEvaluation
	9,  // 2: google.cloud.dialogflow.v2beta1.GeneratorEvaluation.generator_evaluation_config:type_name -> google.cloud.dialogflow.v2beta1.GeneratorEvaluationConfig
	27, // 3: google.cloud.dialogflow.v2beta1.GeneratorEvaluation.create_time:type_name -> google.protobuf.Timestamp
	27, // 4: google.cloud.dialogflow.v2beta1.GeneratorEvaluation.complete_time:type_name -> google.protobuf.Timestamp
	28, // 5: google.cloud.dialogflow.v2beta1.GeneratorEvaluation.initial_generator:type_name -> google.cloud.dialogflow.v2beta1.Generator
	8,  // 6: google.cloud.dialogflow.v2beta1.GeneratorEvaluation.summarization_metrics:type_name -> google.cloud.dialogflow.v2beta1.SummarizationEvaluationMetrics
	10, // 7: google.cloud.dialogflow.v2beta1.GeneratorEvaluation.evaluation_status:type_name -> google.cloud.dialogflow.v2beta1.EvaluationStatus
	17, // 8: google.cloud.dialogflow.v2beta1.SummarizationEvaluationMetrics.summarization_evaluation_results:type_name -> google.cloud.dialogflow.v2beta1.SummarizationEvaluationMetrics.SummarizationEvaluationResult
	18, // 9: google.cloud.dialogflow.v2beta1.SummarizationEvaluationMetrics.overall_metrics:type_name -> google.cloud.dialogflow.v2beta1.SummarizationEvaluationMetrics.OverallScoresByMetric
	19, // 10: google.cloud.dialogflow.v2beta1.SummarizationEvaluationMetrics.overall_section_tokens:type_name -> google.cloud.dialogflow.v2beta1.SummarizationEvaluationMetrics.SectionToken
	20, // 11: google.cloud.dialogflow.v2beta1.SummarizationEvaluationMetrics.conversation_details:type_name -> google.cloud.dialogflow.v2beta1.SummarizationEvaluationMetrics.ConversationDetail
	25, // 12: google.cloud.dialogflow.v2beta1.GeneratorEvaluationConfig.input_data_config:type_name -> google.cloud.dialogflow.v2beta1.GeneratorEvaluationConfig.InputDataConfig
	26, // 13: google.cloud.dialogflow.v2beta1.GeneratorEvaluationConfig.summarization_config:type_name -> google.cloud.dialogflow.v2beta1.GeneratorEvaluationConfig.SummarizationConfig
	29, // 14: google.cloud.dialogflow.v2beta1.EvaluationStatus.pipeline_status:type_name -> google.rpc.Status
	11, // 15: google.cloud.dialogflow.v2beta1.SummarizationEvaluationMetrics.Decomposition.accuracy_decomposition:type_name -> google.cloud.dialogflow.v2beta1.SummarizationEvaluationMetrics.AccuracyDecomposition
	12, // 16: google.cloud.dialogflow.v2beta1.SummarizationEvaluationMetrics.Decomposition.adherence_decomposition:type_name -> google.cloud.dialogflow.v2beta1.SummarizationEvaluationMetrics.AdherenceDecomposition
	11, // 17: google.cloud.dialogflow.v2beta1.SummarizationEvaluationMetrics.EvaluationResult.accuracy_decomposition:type_name -> google.cloud.dialogflow.v2beta1.SummarizationEvaluationMetrics.AccuracyDecomposition
	13, // 18: google.cloud.dialogflow.v2beta1.SummarizationEvaluationMetrics.EvaluationResult.adherence_rubric:type_name -> google.cloud.dialogflow.v2beta1.SummarizationEvaluationMetrics.AdherenceRubric
	14, // 19: google.cloud.dialogflow.v2beta1.SummarizationEvaluationMetrics.EvaluationResult.completeness_rubric:type_name -> google.cloud.dialogflow.v2beta1.SummarizationEvaluationMetrics.CompletenessRubric
	15, // 20: google.cloud.dialogflow.v2beta1.SummarizationEvaluationMetrics.SummarizationEvaluationResult.decompositions:type_name -> google.cloud.dialogflow.v2beta1.SummarizationEvaluationMetrics.Decomposition
	16, // 21: google.cloud.dialogflow.v2beta1.SummarizationEvaluationMetrics.SummarizationEvaluationResult.evaluation_results:type_name -> google.cloud.dialogflow.v2beta1.SummarizationEvaluationMetrics.EvaluationResult
	30, // 22: google.cloud.dialogflow.v2beta1.SummarizationEvaluationMetrics.ConversationDetail.message_entries:type_name -> google.cloud.dialogflow.v2beta1.MessageEntry
	31, // 23: google.cloud.dialogflow.v2beta1.SummarizationEvaluationMetrics.ConversationDetail.summary_sections:type_name -> google.cloud.dialogflow.v2beta1.SummarySuggestion.SummarySection
	21, // 24: google.cloud.dialogflow.v2beta1.SummarizationEvaluationMetrics.ConversationDetail.metric_details:type_name -> google.cloud.dialogflow.v2beta1.SummarizationEvaluationMetrics.ConversationDetail.MetricDetail
	19, // 25: google.cloud.dialogflow.v2beta1.SummarizationEvaluationMetrics.ConversationDetail.section_tokens:type_name -> google.cloud.dialogflow.v2beta1.SummarizationEvaluationMetrics.SectionToken
	22, // 26: google.cloud.dialogflow.v2beta1.SummarizationEvaluationMetrics.ConversationDetail.MetricDetail.section_details:type_name -> google.cloud.dialogflow.v2beta1.SummarizationEvaluationMetrics.ConversationDetail.MetricDetail.SectionDetail
	16, // 27: google.cloud.dialogflow.v2beta1.SummarizationEvaluationMetrics.ConversationDetail.MetricDetail.SectionDetail.evaluation_results:type_name -> google.cloud.dialogflow.v2beta1.SummarizationEvaluationMetrics.EvaluationResult
	27, // 28: google.cloud.dialogflow.v2beta1.GeneratorEvaluationConfig.AgentAssistInputDataConfig.start_time:type_name -> google.protobuf.Timestamp
	27, // 29: google.cloud.dialogflow.v2beta1.GeneratorEvaluationConfig.AgentAssistInputDataConfig.end_time:type_name -> google.protobuf.Timestamp
	0,  // 30: google.cloud.dialogflow.v2beta1.GeneratorEvaluationConfig.InputDataConfig.input_data_source_type:type_name -> google.cloud.dialogflow.v2beta1.GeneratorEvaluationConfig.InputDataSourceType
	27, // 31: google.cloud.dialogflow.v2beta1.GeneratorEvaluationConfig.InputDataConfig.start_time:type_name -> google.protobuf.Timestamp
	27, // 32: google.cloud.dialogflow.v2beta1.GeneratorEvaluationConfig.InputDataConfig.end_time:type_name -> google.protobuf.Timestamp
	1,  // 33: google.cloud.dialogflow.v2beta1.GeneratorEvaluationConfig.InputDataConfig.summary_generation_option:type_name -> google.cloud.dialogflow.v2beta1.GeneratorEvaluationConfig.InputDataConfig.SummaryGenerationOption
	23, // 34: google.cloud.dialogflow.v2beta1.GeneratorEvaluationConfig.InputDataConfig.agent_assist_input_data_config:type_name -> google.cloud.dialogflow.v2beta1.GeneratorEvaluationConfig.AgentAssistInputDataConfig
	24, // 35: google.cloud.dialogflow.v2beta1.GeneratorEvaluationConfig.InputDataConfig.dataset_input_data_config:type_name -> google.cloud.dialogflow.v2beta1.GeneratorEvaluationConfig.DatasetInputDataConfig
	2,  // 36: google.cloud.dialogflow.v2beta1.GeneratorEvaluations.CreateGeneratorEvaluation:input_type -> google.cloud.dialogflow.v2beta1.CreateGeneratorEvaluationRequest
	3,  // 37: google.cloud.dialogflow.v2beta1.GeneratorEvaluations.GetGeneratorEvaluation:input_type -> google.cloud.dialogflow.v2beta1.GetGeneratorEvaluationRequest
	4,  // 38: google.cloud.dialogflow.v2beta1.GeneratorEvaluations.ListGeneratorEvaluations:input_type -> google.cloud.dialogflow.v2beta1.ListGeneratorEvaluationsRequest
	6,  // 39: google.cloud.dialogflow.v2beta1.GeneratorEvaluations.DeleteGeneratorEvaluation:input_type -> google.cloud.dialogflow.v2beta1.DeleteGeneratorEvaluationRequest
	32, // 40: google.cloud.dialogflow.v2beta1.GeneratorEvaluations.CreateGeneratorEvaluation:output_type -> google.longrunning.Operation
	7,  // 41: google.cloud.dialogflow.v2beta1.GeneratorEvaluations.GetGeneratorEvaluation:output_type -> google.cloud.dialogflow.v2beta1.GeneratorEvaluation
	5,  // 42: google.cloud.dialogflow.v2beta1.GeneratorEvaluations.ListGeneratorEvaluations:output_type -> google.cloud.dialogflow.v2beta1.ListGeneratorEvaluationsResponse
	33, // 43: google.cloud.dialogflow.v2beta1.GeneratorEvaluations.DeleteGeneratorEvaluation:output_type -> google.protobuf.Empty
	40, // [40:44] is the sub-list for method output_type
	36, // [36:40] is the sub-list for method input_type
	36, // [36:36] is the sub-list for extension type_name
	36, // [36:36] is the sub-list for extension extendee
	0,  // [0:36] is the sub-list for field type_name
}

func init() { file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_init() }
func file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_init() {
	if File_google_cloud_dialogflow_v2beta1_generator_evaluation_proto != nil {
		return
	}
	file_google_cloud_dialogflow_v2beta1_generator_proto_init()
	file_google_cloud_dialogflow_v2beta1_operations_proto_init()
	file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_msgTypes[5].OneofWrappers = []any{
		(*GeneratorEvaluation_SummarizationMetrics)(nil),
	}
	file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_msgTypes[7].OneofWrappers = []any{
		(*GeneratorEvaluationConfig_SummarizationConfig_)(nil),
	}
	file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_msgTypes[8].OneofWrappers = []any{}
	file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_msgTypes[9].OneofWrappers = []any{}
	file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_msgTypes[11].OneofWrappers = []any{}
	file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_msgTypes[12].OneofWrappers = []any{}
	file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_msgTypes[13].OneofWrappers = []any{
		(*SummarizationEvaluationMetrics_Decomposition_AccuracyDecomposition)(nil),
		(*SummarizationEvaluationMetrics_Decomposition_AdherenceDecomposition)(nil),
	}
	file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_msgTypes[14].OneofWrappers = []any{
		(*SummarizationEvaluationMetrics_EvaluationResult_AccuracyDecomposition)(nil),
		(*SummarizationEvaluationMetrics_EvaluationResult_AdherenceRubric)(nil),
		(*SummarizationEvaluationMetrics_EvaluationResult_CompletenessRubric)(nil),
	}
	file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_msgTypes[17].OneofWrappers = []any{}
	file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_msgTypes[19].OneofWrappers = []any{}
	file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_msgTypes[20].OneofWrappers = []any{}
	file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_msgTypes[23].OneofWrappers = []any{
		(*GeneratorEvaluationConfig_InputDataConfig_AgentAssistInputDataConfig)(nil),
		(*GeneratorEvaluationConfig_InputDataConfig_DatasetInputDataConfig)(nil),
	}
	file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_msgTypes[24].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   25,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_goTypes,
		DependencyIndexes: file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_depIdxs,
		EnumInfos:         file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_enumTypes,
		MessageInfos:      file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_msgTypes,
	}.Build()
	File_google_cloud_dialogflow_v2beta1_generator_evaluation_proto = out.File
	file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_rawDesc = nil
	file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_goTypes = nil
	file_google_cloud_dialogflow_v2beta1_generator_evaluation_proto_depIdxs = nil
}
