.\" auto generated by yuck -*- nroff -*-
.TH DATECONV "1" "January 2024" "dateutils 0.4.11" "User Commands"
.SH NAME
dateconv - Convert DATE/TIMEs between calendrical systems.
.SH SYNOPSIS
.B dateconv
[\fIOPTION\fR]... 
\fR[\fIDATE/TIME\fR]\fR...
.SH DESCRIPTION
Convert DATE/TIMEs between calendrical systems.
If DATE/TIME is omitted date/times are read from stdin.

DATE/TIME can also be one of the following specials
  - `now'           interpreted as the current (UTC) time stamp
  - `time'          the time part of the current (UTC) time stamp
  - `today'         the current date (according to UTC)
  - `tomo[rrow]'    tomorrow's date (according to UTC)
  - `y[ester]day'   yesterday's date (according to UTC)

.PP

Recognized \fIOPTION\fRs:
.TP
.B   \fB-h\fR, \fB--help
Print help and exit
.TP
.B   \fB-V\fR, \fB--version
Print version and exit
.TP
.B   \fB-q\fR, \fB--quiet
Suppress message about date/time and duration
parser errors and fix-ups.
The default is to print a warning or the
fixed up value and return error code 2.
.TP
.B   \fB-f\fR, \fB--format\fR=\fISTRING
Output format.  This can either be a specifier
string (similar to strftime()'s FMT) or the name
of a calendar.
.TP
.B   \fB-i\fR, \fB--input-format\fR=\fISTRING\fR...
Input format, can be used multiple times.
Each date/time will be passed to the input
format parsers in the order they are given, if a
date/time can be read successfully with a given
input format specifier string, that value will
be used.
.TP
.B   \fB-b\fR, \fB--base\fR=\fIDT
For underspecified input use DT as a fallback to
fill in missing fields.  Also used for ambiguous
format specifiers to position their range on the
absolute time line.
Must be a date/time in ISO8601 format.
If omitted defaults to the current date/time.
.TP
.B   \fB-e\fR, \fB--backslash-escapes
Enable interpretation of backslash escapes in the
output and input format specifier strings.
.TP
.B   \fB-S\fR, \fB--sed-mode
Copy parts from the input before and after a
matching date/time.
Note that all occurrences of date/times within a
line will be processed.
.TP
.B   \fB-E\fR, \fB--empty-mode
Empty lines that cannot be parsed.
.TP
.B       \fB--locale\fR=\fILOCALE
Format results according to LOCALE, this would only
affect month and weekday names.
.TP
.B       \fB--from-locale\fR=\fILOCALE
Interpret dates on stdin or the command line as
coming from the locale LOCALE, this would only
affect month and weekday names as input formats
have to be specified explicitly.
.TP
.B       \fB--from-zone\fR=\fIZONE
Interpret dates on stdin or the command line as
coming from the time zone ZONE.
.TP
.B   \fB-z\fR, \fB--zone\fR=\fIZONE
Convert dates printed on stdout to time zone ZONE,
default: UTC.
.SH FORMAT SPECS
.PP
Format specs in dateutils are similar to posix' strftime().
.PP
However, due to a broader range of supported calendars dateutils must
employ different rules.
.PP
Date specs:
.nf
  %a  The abbreviated weekday name
  %A  The full weekday name
  %_a The weekday name shortened to a single character (MTWRFAS)
  %b  The abbreviated month name
  %B  The full month name
  %_b The month name shortened to a single character (FGHJKMNQUVXZ)
  %c  The count of the weekday within the month (range 00 to 05)
  %C  The count of the weekday within the year (range 00 to 53)
  %d  The day of the month, 2 digits (range 00 to 31)
  %D  The day of the year, 3 digits (range 000 to 366)
  %F  Equivalent to %Y-%m-%d (ymd's canonical format)
  %g  ISO week date year without the century (range 00 to 99)
  %G  ISO week date year including the century
  %j  Equivalent to %D
  %m  The month in the current calendar (range 00 to 12)
  %Q  The quarter of the year (range Q1 to Q4)
  %q  The number of the quarter (range 01 to 04)
  %s  The number of seconds since the Epoch.
  %u  The weekday as number (range 01 to 07, Sunday being 07)
  %U  The week count,  day of week is Sun (range 00 to 53)
  %V  The ISO week count,  day of week is Mon (range 01 to 53)
  %w  The weekday as number (range 00 to 06, Sunday being 00)
  %W  The week count,  day of week is Mon (range 00 to 53)
  %y  The year without a century (range 00 to 99)
  %Y  The year including the century
  %_y The year shortened to a single digit
  %Z  The zone offset in hours and minutes (HH:MM) with
      a preceding sign (+ for offsets east of UTC, - for offsets
      west of UTC)
.fi
.PP
.nf
  %Od The day as roman numerals
  %Om The month as roman numerals
  %Oy The two digit year as roman numerals
  %OY The year including the century as roman numerals
.fi
.PP
.nf
  %rs In time systems whose Epoch is different from the unix Epoch, this
      selects the number of seconds since then.
  %rY In calendars with years that don't coincide with the Gregorian
      years, this selects the calendar's year.
.fi
.PP
.nf
  %dth  The day of the month as an ordinal number, 1st, 2nd, 3rd, etc.
  %mth  The month of the year as an ordinal number, 1st, 2nd, 3rd, etc.
.fi
.PP
.nf
  %db The business day of the month (since last month's ultimo)
  %dB Number of business days until this month's ultimo
.fi
.PP
Time specs:
.nf
  %H  The hour of the day using a 24h clock, 2 digits (range 00 to 23)
  %I  The hour of the day using a 12h clock, 2 digits (range 01 to 12)
  %M  The minute (range 00 to 59)
  %N  The nanoseconds (range 000000000 to 999999999)
  %p  The string AM or PM, noon is PM and midnight is AM.
  %P  Like %p but in lowercase
  %S  The  (range 00 to 60, 60 is for leap seconds)
  %T  Equivalent to %H:%M:%S
.fi
.PP
General specs:
.nf
  %n  A newline character
  %t  A tab character
  %%  A literal % character
.fi
.PP
Modifiers:
.nf
  %O  Modifier to turn decimal numbers into Roman numerals
  %r  Modifier to turn units into real units
  %0  Modifier to turn on zero prefixes
  %SPC  Modifier to turn on space prefixes
  %-  Modifier to turn off prefixes altogether
  th  Suffix, read and print ordinal numbers
  b   Suffix, treat days as business days
.fi
.PP
By design dates before 1601-01-01 are not supported.
.PP
For conformity here is a list of calendar designators and their
corresponding format string:
.nf
  ymd     %Y-%m-%d
  ymcw    %Y-%m-%c-%w
  ywd     %rY-W%V-%u
  bizda   %Y-%m-%db
  lilian     n/a
  ldn        n/a
  julian     n/a
  jdn        n/a
  matlab     n/a
  mdn        n/a
.fi
.PP
These designators can be used as output format string, moreover,
@code{lilian}/@code{ldn} and @code{julian}/@code{jdn} can also be used
as input format string.

.SH EXAMPLES
.PP
.nf
  $ dateconv 2012-03-01
  2012-03-01
  $
.fi
.PP
.nf
  $ dateconv -i "%d/%b/%y" 01/Mar/12
  2012-03-01
  $
.fi
.PP
.nf
  $ dateconv -f "%d/%b/%y" 2012-03-01
  01/Mar/12
  $
.fi
.PP
.nf
  $ dateconv -f "%d/%b/%y" -i "%OY %Om %Od" "MCMXCVIII IX XVII"
  17/Sep/98
  $
.fi
.PP
.nf
  $ dateconv 12:03:01
  12:03:01
  $
.fi
.PP
.nf
  $ dateconv -i "%I:%M:%S %p" "11:22:33 PM"
  23:22:33
  $
.fi
.PP
.nf
  $ dateconv '2012-03-01 00:00:00'
  2012-03-01T00:00:00
  $
.fi
.PP
.nf
  $ dateconv 2012-03-01T12:34:56
  2012-03-01T12:34:56
  $
.fi
.PP
.nf
  $ dateconv --zone America/Chicago <<EOF
  2012-03-01T07:05:06
  2012-03-01T08:12:34
  2012-03-11T01:05:06
  2012-03-11T02:05:06
  2012-03-11T07:05:06
  2012-03-11T08:05:06
  2012-03-11T17:05:06
  EOF
  2012-03-01T01:05:06
  2012-03-01T02:12:34
  2012-03-10T19:05:06
  2012-03-10T20:05:06
  2012-03-11T01:05:06
  2012-03-11T03:05:06
  2012-03-11T12:05:06
  $
.fi
.PP
.nf
  $ dateconv --from-zone America/Chicago <<EOF
  2012-03-01T01:05:06
  2012-03-01T02:12:34
  2012-03-10T19:05:06
  2012-03-10T20:05:06
  2012-03-11T01:05:06
  2012-03-11T03:05:06
  2012-03-11T12:05:06
  EOF
  2012-03-01T07:05:06
  2012-03-01T08:12:34
  2012-03-11T01:05:06
  2012-03-11T02:05:06
  2012-03-11T07:05:06
  2012-03-11T08:05:06
  2012-03-11T17:05:06
  $
.fi
.PP
.nf
  $ dateconv --from-zone America/Chicago -z Europe/Berlin '2012-03-01 12:00' -i '%F %H:%M' -f '%F %T'
  2012-03-01 19:00:00
  $
.fi
.PP

.SH AUTHOR
Written by Sebastian Freundt <freundt@fresse.org>
.PP
.SH REPORTING BUGS
Report bugs to: https://github.com/hroptatyr/dateutils/issues
.PP



.SH "SEE ALSO"
The full documentation for
.B dateconv
is maintained as a Texinfo manual.  If the
.B info
and
.B dateconv
programs are properly installed at your site, the command
.IP
.B info (dateutils)dateconv
.PP
should give you access to the complete manual.
.\" yuck.m4man ends here
