package costmanagement

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// ViewsClient is the client for the Views methods of the Costmanagement service.
type ViewsClient struct {
	BaseClient
}

// NewViewsClient creates an instance of the ViewsClient client.
func NewViewsClient(subscriptionID string) ViewsClient {
	return NewViewsClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewViewsClientWithBaseURI creates an instance of the ViewsClient client using a custom endpoint.  Use this when
// interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewViewsClientWithBaseURI(baseURI string, subscriptionID string) ViewsClient {
	return ViewsClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// CreateOrUpdate the operation to create or update a view. Update operation requires latest eTag to be set in the
// request. You may obtain the latest eTag by performing a get operation. Create operation does not require eTag.
// Parameters:
// viewName - view name
// parameters - parameters supplied to the CreateOrUpdate View operation.
func (client ViewsClient) CreateOrUpdate(ctx context.Context, viewName string, parameters View) (result View, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ViewsClient.CreateOrUpdate")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: parameters,
			Constraints: []validation.Constraint{{Target: "parameters.ViewProperties", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "parameters.ViewProperties.ReportConfigDefinition", Name: validation.Null, Rule: false,
					Chain: []validation.Constraint{{Target: "parameters.ViewProperties.ReportConfigDefinition.Type", Name: validation.Null, Rule: true, Chain: nil},
						{Target: "parameters.ViewProperties.ReportConfigDefinition.TimePeriod", Name: validation.Null, Rule: false,
							Chain: []validation.Constraint{{Target: "parameters.ViewProperties.ReportConfigDefinition.TimePeriod.From", Name: validation.Null, Rule: true, Chain: nil},
								{Target: "parameters.ViewProperties.ReportConfigDefinition.TimePeriod.To", Name: validation.Null, Rule: true, Chain: nil},
							}},
						{Target: "parameters.ViewProperties.ReportConfigDefinition.DataSet", Name: validation.Null, Rule: false,
							Chain: []validation.Constraint{{Target: "parameters.ViewProperties.ReportConfigDefinition.DataSet.Grouping", Name: validation.Null, Rule: false,
								Chain: []validation.Constraint{{Target: "parameters.ViewProperties.ReportConfigDefinition.DataSet.Grouping", Name: validation.MaxItems, Rule: 2, Chain: nil}}},
								{Target: "parameters.ViewProperties.ReportConfigDefinition.DataSet.Filter", Name: validation.Null, Rule: false,
									Chain: []validation.Constraint{{Target: "parameters.ViewProperties.ReportConfigDefinition.DataSet.Filter.And", Name: validation.Null, Rule: false,
										Chain: []validation.Constraint{{Target: "parameters.ViewProperties.ReportConfigDefinition.DataSet.Filter.And", Name: validation.MinItems, Rule: 2, Chain: nil}}},
										{Target: "parameters.ViewProperties.ReportConfigDefinition.DataSet.Filter.Or", Name: validation.Null, Rule: false,
											Chain: []validation.Constraint{{Target: "parameters.ViewProperties.ReportConfigDefinition.DataSet.Filter.Or", Name: validation.MinItems, Rule: 2, Chain: nil}}},
										{Target: "parameters.ViewProperties.ReportConfigDefinition.DataSet.Filter.Dimensions", Name: validation.Null, Rule: false,
											Chain: []validation.Constraint{{Target: "parameters.ViewProperties.ReportConfigDefinition.DataSet.Filter.Dimensions.Name", Name: validation.Null, Rule: true, Chain: nil},
												{Target: "parameters.ViewProperties.ReportConfigDefinition.DataSet.Filter.Dimensions.Values", Name: validation.Null, Rule: true,
													Chain: []validation.Constraint{{Target: "parameters.ViewProperties.ReportConfigDefinition.DataSet.Filter.Dimensions.Values", Name: validation.MinItems, Rule: 1, Chain: nil}}},
											}},
										{Target: "parameters.ViewProperties.ReportConfigDefinition.DataSet.Filter.Tags", Name: validation.Null, Rule: false,
											Chain: []validation.Constraint{{Target: "parameters.ViewProperties.ReportConfigDefinition.DataSet.Filter.Tags.Name", Name: validation.Null, Rule: true, Chain: nil},
												{Target: "parameters.ViewProperties.ReportConfigDefinition.DataSet.Filter.Tags.Values", Name: validation.Null, Rule: true,
													Chain: []validation.Constraint{{Target: "parameters.ViewProperties.ReportConfigDefinition.DataSet.Filter.Tags.Values", Name: validation.MinItems, Rule: 1, Chain: nil}}},
											}},
										{Target: "parameters.ViewProperties.ReportConfigDefinition.DataSet.Filter.TagKey", Name: validation.Null, Rule: false,
											Chain: []validation.Constraint{{Target: "parameters.ViewProperties.ReportConfigDefinition.DataSet.Filter.TagKey.Name", Name: validation.Null, Rule: true, Chain: nil},
												{Target: "parameters.ViewProperties.ReportConfigDefinition.DataSet.Filter.TagKey.Values", Name: validation.Null, Rule: true,
													Chain: []validation.Constraint{{Target: "parameters.ViewProperties.ReportConfigDefinition.DataSet.Filter.TagKey.Values", Name: validation.MinItems, Rule: 1, Chain: nil}}},
											}},
										{Target: "parameters.ViewProperties.ReportConfigDefinition.DataSet.Filter.TagValue", Name: validation.Null, Rule: false,
											Chain: []validation.Constraint{{Target: "parameters.ViewProperties.ReportConfigDefinition.DataSet.Filter.TagValue.Name", Name: validation.Null, Rule: true, Chain: nil},
												{Target: "parameters.ViewProperties.ReportConfigDefinition.DataSet.Filter.TagValue.Values", Name: validation.Null, Rule: true,
													Chain: []validation.Constraint{{Target: "parameters.ViewProperties.ReportConfigDefinition.DataSet.Filter.TagValue.Values", Name: validation.MinItems, Rule: 1, Chain: nil}}},
											}},
									}},
							}},
					}},
				}}}}}); err != nil {
		return result, validation.NewError("costmanagement.ViewsClient", "CreateOrUpdate", err.Error())
	}

	req, err := client.CreateOrUpdatePreparer(ctx, viewName, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.ViewsClient", "CreateOrUpdate", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "costmanagement.ViewsClient", "CreateOrUpdate", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.ViewsClient", "CreateOrUpdate", resp, "Failure responding to request")
		return
	}

	return
}

// CreateOrUpdatePreparer prepares the CreateOrUpdate request.
func (client ViewsClient) CreateOrUpdatePreparer(ctx context.Context, viewName string, parameters View) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"viewName": autorest.Encode("path", viewName),
	}

	const APIVersion = "2019-11-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.CostManagement/views/{viewName}", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateSender sends the CreateOrUpdate request. The method will close the
// http.Response Body if it receives an error.
func (client ViewsClient) CreateOrUpdateSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// CreateOrUpdateResponder handles the response to the CreateOrUpdate request. The method always
// closes the http.Response Body.
func (client ViewsClient) CreateOrUpdateResponder(resp *http.Response) (result View, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateByScope the operation to create or update a view. Update operation requires latest eTag to be set in
// the request. You may obtain the latest eTag by performing a get operation. Create operation does not require eTag.
// Parameters:
// scope - the scope associated with view operations. This includes 'subscriptions/{subscriptionId}' for
// subscription scope, 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for resourceGroup
// scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope,
// 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for Department
// scope,
// 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}'
// for EnrollmentAccount scope,
// 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}' for
// BillingProfile scope,
// 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/invoiceSections/{invoiceSectionId}' for
// InvoiceSection scope, 'providers/Microsoft.Management/managementGroups/{managementGroupId}' for Management
// Group scope, 'providers/Microsoft.CostManagement/externalBillingAccounts/{externalBillingAccountName}' for
// External Billing Account scope and
// 'providers/Microsoft.CostManagement/externalSubscriptions/{externalSubscriptionName}' for External
// Subscription scope.
// viewName - view name
// parameters - parameters supplied to the CreateOrUpdate View operation.
func (client ViewsClient) CreateOrUpdateByScope(ctx context.Context, scope string, viewName string, parameters View) (result View, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ViewsClient.CreateOrUpdateByScope")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: parameters,
			Constraints: []validation.Constraint{{Target: "parameters.ViewProperties", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "parameters.ViewProperties.ReportConfigDefinition", Name: validation.Null, Rule: false,
					Chain: []validation.Constraint{{Target: "parameters.ViewProperties.ReportConfigDefinition.Type", Name: validation.Null, Rule: true, Chain: nil},
						{Target: "parameters.ViewProperties.ReportConfigDefinition.TimePeriod", Name: validation.Null, Rule: false,
							Chain: []validation.Constraint{{Target: "parameters.ViewProperties.ReportConfigDefinition.TimePeriod.From", Name: validation.Null, Rule: true, Chain: nil},
								{Target: "parameters.ViewProperties.ReportConfigDefinition.TimePeriod.To", Name: validation.Null, Rule: true, Chain: nil},
							}},
						{Target: "parameters.ViewProperties.ReportConfigDefinition.DataSet", Name: validation.Null, Rule: false,
							Chain: []validation.Constraint{{Target: "parameters.ViewProperties.ReportConfigDefinition.DataSet.Grouping", Name: validation.Null, Rule: false,
								Chain: []validation.Constraint{{Target: "parameters.ViewProperties.ReportConfigDefinition.DataSet.Grouping", Name: validation.MaxItems, Rule: 2, Chain: nil}}},
								{Target: "parameters.ViewProperties.ReportConfigDefinition.DataSet.Filter", Name: validation.Null, Rule: false,
									Chain: []validation.Constraint{{Target: "parameters.ViewProperties.ReportConfigDefinition.DataSet.Filter.And", Name: validation.Null, Rule: false,
										Chain: []validation.Constraint{{Target: "parameters.ViewProperties.ReportConfigDefinition.DataSet.Filter.And", Name: validation.MinItems, Rule: 2, Chain: nil}}},
										{Target: "parameters.ViewProperties.ReportConfigDefinition.DataSet.Filter.Or", Name: validation.Null, Rule: false,
											Chain: []validation.Constraint{{Target: "parameters.ViewProperties.ReportConfigDefinition.DataSet.Filter.Or", Name: validation.MinItems, Rule: 2, Chain: nil}}},
										{Target: "parameters.ViewProperties.ReportConfigDefinition.DataSet.Filter.Dimensions", Name: validation.Null, Rule: false,
											Chain: []validation.Constraint{{Target: "parameters.ViewProperties.ReportConfigDefinition.DataSet.Filter.Dimensions.Name", Name: validation.Null, Rule: true, Chain: nil},
												{Target: "parameters.ViewProperties.ReportConfigDefinition.DataSet.Filter.Dimensions.Values", Name: validation.Null, Rule: true,
													Chain: []validation.Constraint{{Target: "parameters.ViewProperties.ReportConfigDefinition.DataSet.Filter.Dimensions.Values", Name: validation.MinItems, Rule: 1, Chain: nil}}},
											}},
										{Target: "parameters.ViewProperties.ReportConfigDefinition.DataSet.Filter.Tags", Name: validation.Null, Rule: false,
											Chain: []validation.Constraint{{Target: "parameters.ViewProperties.ReportConfigDefinition.DataSet.Filter.Tags.Name", Name: validation.Null, Rule: true, Chain: nil},
												{Target: "parameters.ViewProperties.ReportConfigDefinition.DataSet.Filter.Tags.Values", Name: validation.Null, Rule: true,
													Chain: []validation.Constraint{{Target: "parameters.ViewProperties.ReportConfigDefinition.DataSet.Filter.Tags.Values", Name: validation.MinItems, Rule: 1, Chain: nil}}},
											}},
										{Target: "parameters.ViewProperties.ReportConfigDefinition.DataSet.Filter.TagKey", Name: validation.Null, Rule: false,
											Chain: []validation.Constraint{{Target: "parameters.ViewProperties.ReportConfigDefinition.DataSet.Filter.TagKey.Name", Name: validation.Null, Rule: true, Chain: nil},
												{Target: "parameters.ViewProperties.ReportConfigDefinition.DataSet.Filter.TagKey.Values", Name: validation.Null, Rule: true,
													Chain: []validation.Constraint{{Target: "parameters.ViewProperties.ReportConfigDefinition.DataSet.Filter.TagKey.Values", Name: validation.MinItems, Rule: 1, Chain: nil}}},
											}},
										{Target: "parameters.ViewProperties.ReportConfigDefinition.DataSet.Filter.TagValue", Name: validation.Null, Rule: false,
											Chain: []validation.Constraint{{Target: "parameters.ViewProperties.ReportConfigDefinition.DataSet.Filter.TagValue.Name", Name: validation.Null, Rule: true, Chain: nil},
												{Target: "parameters.ViewProperties.ReportConfigDefinition.DataSet.Filter.TagValue.Values", Name: validation.Null, Rule: true,
													Chain: []validation.Constraint{{Target: "parameters.ViewProperties.ReportConfigDefinition.DataSet.Filter.TagValue.Values", Name: validation.MinItems, Rule: 1, Chain: nil}}},
											}},
									}},
							}},
					}},
				}}}}}); err != nil {
		return result, validation.NewError("costmanagement.ViewsClient", "CreateOrUpdateByScope", err.Error())
	}

	req, err := client.CreateOrUpdateByScopePreparer(ctx, scope, viewName, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.ViewsClient", "CreateOrUpdateByScope", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateByScopeSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "costmanagement.ViewsClient", "CreateOrUpdateByScope", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateByScopeResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.ViewsClient", "CreateOrUpdateByScope", resp, "Failure responding to request")
		return
	}

	return
}

// CreateOrUpdateByScopePreparer prepares the CreateOrUpdateByScope request.
func (client ViewsClient) CreateOrUpdateByScopePreparer(ctx context.Context, scope string, viewName string, parameters View) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"scope":    autorest.Encode("path", scope),
		"viewName": autorest.Encode("path", viewName),
	}

	const APIVersion = "2019-11-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/{scope}/providers/Microsoft.CostManagement/views/{viewName}", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateByScopeSender sends the CreateOrUpdateByScope request. The method will close the
// http.Response Body if it receives an error.
func (client ViewsClient) CreateOrUpdateByScopeSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// CreateOrUpdateByScopeResponder handles the response to the CreateOrUpdateByScope request. The method always
// closes the http.Response Body.
func (client ViewsClient) CreateOrUpdateByScopeResponder(resp *http.Response) (result View, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Delete the operation to delete a view.
// Parameters:
// viewName - view name
func (client ViewsClient) Delete(ctx context.Context, viewName string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ViewsClient.Delete")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeletePreparer(ctx, viewName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.ViewsClient", "Delete", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "costmanagement.ViewsClient", "Delete", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.ViewsClient", "Delete", resp, "Failure responding to request")
		return
	}

	return
}

// DeletePreparer prepares the Delete request.
func (client ViewsClient) DeletePreparer(ctx context.Context, viewName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"viewName": autorest.Encode("path", viewName),
	}

	const APIVersion = "2019-11-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.CostManagement/views/{viewName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSender sends the Delete request. The method will close the
// http.Response Body if it receives an error.
func (client ViewsClient) DeleteSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// DeleteResponder handles the response to the Delete request. The method always
// closes the http.Response Body.
func (client ViewsClient) DeleteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteByScope the operation to delete a view.
// Parameters:
// scope - the scope associated with view operations. This includes 'subscriptions/{subscriptionId}' for
// subscription scope, 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for resourceGroup
// scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope,
// 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for Department
// scope,
// 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}'
// for EnrollmentAccount scope,
// 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}' for
// BillingProfile scope,
// 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/invoiceSections/{invoiceSectionId}' for
// InvoiceSection scope, 'providers/Microsoft.Management/managementGroups/{managementGroupId}' for Management
// Group scope, 'providers/Microsoft.CostManagement/externalBillingAccounts/{externalBillingAccountName}' for
// External Billing Account scope and
// 'providers/Microsoft.CostManagement/externalSubscriptions/{externalSubscriptionName}' for External
// Subscription scope.
// viewName - view name
func (client ViewsClient) DeleteByScope(ctx context.Context, scope string, viewName string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ViewsClient.DeleteByScope")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeleteByScopePreparer(ctx, scope, viewName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.ViewsClient", "DeleteByScope", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteByScopeSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "costmanagement.ViewsClient", "DeleteByScope", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteByScopeResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.ViewsClient", "DeleteByScope", resp, "Failure responding to request")
		return
	}

	return
}

// DeleteByScopePreparer prepares the DeleteByScope request.
func (client ViewsClient) DeleteByScopePreparer(ctx context.Context, scope string, viewName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"scope":    autorest.Encode("path", scope),
		"viewName": autorest.Encode("path", viewName),
	}

	const APIVersion = "2019-11-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/{scope}/providers/Microsoft.CostManagement/views/{viewName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteByScopeSender sends the DeleteByScope request. The method will close the
// http.Response Body if it receives an error.
func (client ViewsClient) DeleteByScopeSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// DeleteByScopeResponder handles the response to the DeleteByScope request. The method always
// closes the http.Response Body.
func (client ViewsClient) DeleteByScopeResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Get gets the view by view name.
// Parameters:
// viewName - view name
func (client ViewsClient) Get(ctx context.Context, viewName string) (result View, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ViewsClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetPreparer(ctx, viewName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.ViewsClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "costmanagement.ViewsClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.ViewsClient", "Get", resp, "Failure responding to request")
		return
	}

	return
}

// GetPreparer prepares the Get request.
func (client ViewsClient) GetPreparer(ctx context.Context, viewName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"viewName": autorest.Encode("path", viewName),
	}

	const APIVersion = "2019-11-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.CostManagement/views/{viewName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client ViewsClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client ViewsClient) GetResponder(resp *http.Response) (result View, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetByScope gets the view for the defined scope by view name.
// Parameters:
// scope - the scope associated with view operations. This includes 'subscriptions/{subscriptionId}' for
// subscription scope, 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for resourceGroup
// scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope,
// 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for Department
// scope,
// 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}'
// for EnrollmentAccount scope,
// 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}' for
// BillingProfile scope,
// 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/invoiceSections/{invoiceSectionId}' for
// InvoiceSection scope, 'providers/Microsoft.Management/managementGroups/{managementGroupId}' for Management
// Group scope, 'providers/Microsoft.CostManagement/externalBillingAccounts/{externalBillingAccountName}' for
// External Billing Account scope and
// 'providers/Microsoft.CostManagement/externalSubscriptions/{externalSubscriptionName}' for External
// Subscription scope.
// viewName - view name
func (client ViewsClient) GetByScope(ctx context.Context, scope string, viewName string) (result View, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ViewsClient.GetByScope")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetByScopePreparer(ctx, scope, viewName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.ViewsClient", "GetByScope", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetByScopeSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "costmanagement.ViewsClient", "GetByScope", resp, "Failure sending request")
		return
	}

	result, err = client.GetByScopeResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.ViewsClient", "GetByScope", resp, "Failure responding to request")
		return
	}

	return
}

// GetByScopePreparer prepares the GetByScope request.
func (client ViewsClient) GetByScopePreparer(ctx context.Context, scope string, viewName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"scope":    autorest.Encode("path", scope),
		"viewName": autorest.Encode("path", viewName),
	}

	const APIVersion = "2019-11-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/{scope}/providers/Microsoft.CostManagement/views/{viewName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetByScopeSender sends the GetByScope request. The method will close the
// http.Response Body if it receives an error.
func (client ViewsClient) GetByScopeSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetByScopeResponder handles the response to the GetByScope request. The method always
// closes the http.Response Body.
func (client ViewsClient) GetByScopeResponder(resp *http.Response) (result View, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// List lists all views by tenant and object.
func (client ViewsClient) List(ctx context.Context) (result ViewListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ViewsClient.List")
		defer func() {
			sc := -1
			if result.vlr.Response.Response != nil {
				sc = result.vlr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listNextResults
	req, err := client.ListPreparer(ctx)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.ViewsClient", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.vlr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "costmanagement.ViewsClient", "List", resp, "Failure sending request")
		return
	}

	result.vlr, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.ViewsClient", "List", resp, "Failure responding to request")
		return
	}
	if result.vlr.hasNextLink() && result.vlr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListPreparer prepares the List request.
func (client ViewsClient) ListPreparer(ctx context.Context) (*http.Request, error) {
	const APIVersion = "2019-11-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPath("/providers/Microsoft.CostManagement/views"),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client ViewsClient) ListSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client ViewsClient) ListResponder(resp *http.Response) (result ViewListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listNextResults retrieves the next set of results, if any.
func (client ViewsClient) listNextResults(ctx context.Context, lastResults ViewListResult) (result ViewListResult, err error) {
	req, err := lastResults.viewListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "costmanagement.ViewsClient", "listNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "costmanagement.ViewsClient", "listNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.ViewsClient", "listNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListComplete enumerates all values, automatically crossing page boundaries as required.
func (client ViewsClient) ListComplete(ctx context.Context) (result ViewListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ViewsClient.List")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.List(ctx)
	return
}

// ListByScope lists all views at the given scope.
// Parameters:
// scope - the scope associated with view operations. This includes 'subscriptions/{subscriptionId}' for
// subscription scope, 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for resourceGroup
// scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope,
// 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for Department
// scope,
// 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}'
// for EnrollmentAccount scope,
// 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}' for
// BillingProfile scope,
// 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/invoiceSections/{invoiceSectionId}' for
// InvoiceSection scope, 'providers/Microsoft.Management/managementGroups/{managementGroupId}' for Management
// Group scope, 'providers/Microsoft.CostManagement/externalBillingAccounts/{externalBillingAccountName}' for
// External Billing Account scope and
// 'providers/Microsoft.CostManagement/externalSubscriptions/{externalSubscriptionName}' for External
// Subscription scope.
func (client ViewsClient) ListByScope(ctx context.Context, scope string) (result ViewListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ViewsClient.ListByScope")
		defer func() {
			sc := -1
			if result.vlr.Response.Response != nil {
				sc = result.vlr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listByScopeNextResults
	req, err := client.ListByScopePreparer(ctx, scope)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.ViewsClient", "ListByScope", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByScopeSender(req)
	if err != nil {
		result.vlr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "costmanagement.ViewsClient", "ListByScope", resp, "Failure sending request")
		return
	}

	result.vlr, err = client.ListByScopeResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.ViewsClient", "ListByScope", resp, "Failure responding to request")
		return
	}
	if result.vlr.hasNextLink() && result.vlr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListByScopePreparer prepares the ListByScope request.
func (client ViewsClient) ListByScopePreparer(ctx context.Context, scope string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"scope": autorest.Encode("path", scope),
	}

	const APIVersion = "2019-11-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/{scope}/providers/Microsoft.CostManagement/views", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListByScopeSender sends the ListByScope request. The method will close the
// http.Response Body if it receives an error.
func (client ViewsClient) ListByScopeSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListByScopeResponder handles the response to the ListByScope request. The method always
// closes the http.Response Body.
func (client ViewsClient) ListByScopeResponder(resp *http.Response) (result ViewListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listByScopeNextResults retrieves the next set of results, if any.
func (client ViewsClient) listByScopeNextResults(ctx context.Context, lastResults ViewListResult) (result ViewListResult, err error) {
	req, err := lastResults.viewListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "costmanagement.ViewsClient", "listByScopeNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListByScopeSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "costmanagement.ViewsClient", "listByScopeNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListByScopeResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.ViewsClient", "listByScopeNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListByScopeComplete enumerates all values, automatically crossing page boundaries as required.
func (client ViewsClient) ListByScopeComplete(ctx context.Context, scope string) (result ViewListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ViewsClient.ListByScope")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListByScope(ctx, scope)
	return
}
