package cognitiveservicesapi

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/preview/cognitiveservices/mgmt/2016-02-01-preview/cognitiveservices"
	"github.com/Azure/go-autorest/autorest"
)

// AccountsClientAPI contains the set of methods on the AccountsClient type.
type AccountsClientAPI interface {
	Create(ctx context.Context, resourceGroupName string, accountName string, parameters cognitiveservices.AccountCreateParameters) (result cognitiveservices.Account, err error)
	Delete(ctx context.Context, resourceGroupName string, accountName string) (result autorest.Response, err error)
	GetProperties(ctx context.Context, resourceGroupName string, accountName string) (result cognitiveservices.Account, err error)
	List(ctx context.Context) (result cognitiveservices.AccountListResult, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result cognitiveservices.AccountListResult, err error)
	ListKeys(ctx context.Context, resourceGroupName string, accountName string) (result cognitiveservices.AccountKeys, err error)
	ListSkus(ctx context.Context, resourceGroupName string, accountName string) (result cognitiveservices.AccountEnumerateSkusResult, err error)
	RegenerateKey(ctx context.Context, resourceGroupName string, accountName string, body cognitiveservices.RegenerateKeyParameters) (result cognitiveservices.AccountKeys, err error)
	Update(ctx context.Context, resourceGroupName string, accountName string, body cognitiveservices.AccountUpdateParameters) (result cognitiveservices.Account, err error)
}

var _ AccountsClientAPI = (*cognitiveservices.AccountsClient)(nil)
