package devops

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// CodeRepositoryType enumerates the values for code repository type.
type CodeRepositoryType string

const (
	// GitHub ...
	GitHub CodeRepositoryType = "gitHub"
	// VstsGit ...
	VstsGit CodeRepositoryType = "vstsGit"
)

// PossibleCodeRepositoryTypeValues returns an array of possible values for the CodeRepositoryType const type.
func PossibleCodeRepositoryTypeValues() []CodeRepositoryType {
	return []CodeRepositoryType{GitHub, VstsGit}
}

// InputDataType enumerates the values for input data type.
type InputDataType string

const (
	// InputDataTypeAuthorization ...
	InputDataTypeAuthorization InputDataType = "Authorization"
	// InputDataTypeBool ...
	InputDataTypeBool InputDataType = "Bool"
	// InputDataTypeInt ...
	InputDataTypeInt InputDataType = "Int"
	// InputDataTypeSecureString ...
	InputDataTypeSecureString InputDataType = "SecureString"
	// InputDataTypeString ...
	InputDataTypeString InputDataType = "String"
)

// PossibleInputDataTypeValues returns an array of possible values for the InputDataType const type.
func PossibleInputDataTypeValues() []InputDataType {
	return []InputDataType{InputDataTypeAuthorization, InputDataTypeBool, InputDataTypeInt, InputDataTypeSecureString, InputDataTypeString}
}
