package commitmentplansapi

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/preview/machinelearning/mgmt/2016-05-01-preview/commitmentplans"
	"github.com/Azure/go-autorest/autorest"
)

// OperationsClientAPI contains the set of methods on the OperationsClient type.
type OperationsClientAPI interface {
	List(ctx context.Context) (result commitmentplans.OperationEntityListResult, err error)
}

var _ OperationsClientAPI = (*commitmentplans.OperationsClient)(nil)

// SkusClientAPI contains the set of methods on the SkusClient type.
type SkusClientAPI interface {
	List(ctx context.Context) (result commitmentplans.SkuListResult, err error)
}

var _ SkusClientAPI = (*commitmentplans.SkusClient)(nil)

// CommitmentAssociationsClientAPI contains the set of methods on the CommitmentAssociationsClient type.
type CommitmentAssociationsClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, commitmentPlanName string, commitmentAssociationName string) (result commitmentplans.CommitmentAssociation, err error)
	List(ctx context.Context, resourceGroupName string, commitmentPlanName string, skipToken string) (result commitmentplans.CommitmentAssociationListResultPage, err error)
	ListComplete(ctx context.Context, resourceGroupName string, commitmentPlanName string, skipToken string) (result commitmentplans.CommitmentAssociationListResultIterator, err error)
	Move(ctx context.Context, resourceGroupName string, commitmentPlanName string, commitmentAssociationName string, movePayload commitmentplans.MoveCommitmentAssociationRequest) (result commitmentplans.CommitmentAssociation, err error)
}

var _ CommitmentAssociationsClientAPI = (*commitmentplans.CommitmentAssociationsClient)(nil)

// ClientAPI contains the set of methods on the Client type.
type ClientAPI interface {
	CreateOrUpdate(ctx context.Context, createOrUpdatePayload commitmentplans.CommitmentPlan, resourceGroupName string, commitmentPlanName string) (result commitmentplans.CommitmentPlan, err error)
	Get(ctx context.Context, resourceGroupName string, commitmentPlanName string) (result commitmentplans.CommitmentPlan, err error)
	List(ctx context.Context, skipToken string) (result commitmentplans.ListResultPage, err error)
	ListComplete(ctx context.Context, skipToken string) (result commitmentplans.ListResultIterator, err error)
	ListInResourceGroup(ctx context.Context, resourceGroupName string, skipToken string) (result commitmentplans.ListResultPage, err error)
	ListInResourceGroupComplete(ctx context.Context, resourceGroupName string, skipToken string) (result commitmentplans.ListResultIterator, err error)
	Patch(ctx context.Context, patchPayload commitmentplans.PatchPayload, resourceGroupName string, commitmentPlanName string) (result commitmentplans.CommitmentPlan, err error)
	Remove(ctx context.Context, resourceGroupName string, commitmentPlanName string) (result autorest.Response, err error)
}

var _ ClientAPI = (*commitmentplans.Client)(nil)

// UsageHistoryClientAPI contains the set of methods on the UsageHistoryClient type.
type UsageHistoryClientAPI interface {
	List(ctx context.Context, resourceGroupName string, commitmentPlanName string, skipToken string) (result commitmentplans.PlanUsageHistoryListResultPage, err error)
	ListComplete(ctx context.Context, resourceGroupName string, commitmentPlanName string, skipToken string) (result commitmentplans.PlanUsageHistoryListResultIterator, err error)
}

var _ UsageHistoryClientAPI = (*commitmentplans.UsageHistoryClient)(nil)
