package videoanalyzer

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"github.com/gofrs/uuid"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/videoanalyzer/mgmt/2021-11-01-preview/videoanalyzer"

// AccessPolicyEntity access policies help define the authentication rules, and control access to specific
// video resources.
type AccessPolicyEntity struct {
	autorest.Response `json:"-"`
	// AccessPolicyProperties - The resource properties.
	*AccessPolicyProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
	// SystemData - READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for AccessPolicyEntity.
func (ape AccessPolicyEntity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ape.AccessPolicyProperties != nil {
		objectMap["properties"] = ape.AccessPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AccessPolicyEntity struct.
func (ape *AccessPolicyEntity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var accessPolicyProperties AccessPolicyProperties
				err = json.Unmarshal(*v, &accessPolicyProperties)
				if err != nil {
					return err
				}
				ape.AccessPolicyProperties = &accessPolicyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ape.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ape.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ape.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				ape.SystemData = &systemData
			}
		}
	}

	return nil
}

// AccessPolicyEntityCollection a collection of AccessPolicyEntity items.
type AccessPolicyEntityCollection struct {
	autorest.Response `json:"-"`
	// Value - A collection of AccessPolicyEntity items.
	Value *[]AccessPolicyEntity `json:"value,omitempty"`
	// NextLink - A link to the next page of the collection (when the collection contains too many results to return in one response).
	NextLink *string `json:"@nextLink,omitempty"`
}

// AccessPolicyEntityCollectionIterator provides access to a complete listing of AccessPolicyEntity values.
type AccessPolicyEntityCollectionIterator struct {
	i    int
	page AccessPolicyEntityCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AccessPolicyEntityCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AccessPolicyEntityCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AccessPolicyEntityCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AccessPolicyEntityCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AccessPolicyEntityCollectionIterator) Response() AccessPolicyEntityCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AccessPolicyEntityCollectionIterator) Value() AccessPolicyEntity {
	if !iter.page.NotDone() {
		return AccessPolicyEntity{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AccessPolicyEntityCollectionIterator type.
func NewAccessPolicyEntityCollectionIterator(page AccessPolicyEntityCollectionPage) AccessPolicyEntityCollectionIterator {
	return AccessPolicyEntityCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (apec AccessPolicyEntityCollection) IsEmpty() bool {
	return apec.Value == nil || len(*apec.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (apec AccessPolicyEntityCollection) hasNextLink() bool {
	return apec.NextLink != nil && len(*apec.NextLink) != 0
}

// accessPolicyEntityCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (apec AccessPolicyEntityCollection) accessPolicyEntityCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !apec.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(apec.NextLink)))
}

// AccessPolicyEntityCollectionPage contains a page of AccessPolicyEntity values.
type AccessPolicyEntityCollectionPage struct {
	fn   func(context.Context, AccessPolicyEntityCollection) (AccessPolicyEntityCollection, error)
	apec AccessPolicyEntityCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AccessPolicyEntityCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AccessPolicyEntityCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.apec)
		if err != nil {
			return err
		}
		page.apec = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AccessPolicyEntityCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AccessPolicyEntityCollectionPage) NotDone() bool {
	return !page.apec.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AccessPolicyEntityCollectionPage) Response() AccessPolicyEntityCollection {
	return page.apec
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AccessPolicyEntityCollectionPage) Values() []AccessPolicyEntity {
	if page.apec.IsEmpty() {
		return nil
	}
	return *page.apec.Value
}

// Creates a new instance of the AccessPolicyEntityCollectionPage type.
func NewAccessPolicyEntityCollectionPage(cur AccessPolicyEntityCollection, getNextPage func(context.Context, AccessPolicyEntityCollection) (AccessPolicyEntityCollection, error)) AccessPolicyEntityCollectionPage {
	return AccessPolicyEntityCollectionPage{
		fn:   getNextPage,
		apec: cur,
	}
}

// AccessPolicyProperties application level properties for the access policy resource.
type AccessPolicyProperties struct {
	// Role - Defines the access level granted by this policy. Possible values include: 'AccessPolicyRoleReader'
	Role AccessPolicyRole `json:"role,omitempty"`
	// Authentication - Authentication method to be used when validating client API access.
	Authentication BasicAuthenticationBase `json:"authentication,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AccessPolicyProperties struct.
func (app *AccessPolicyProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "role":
			if v != nil {
				var role AccessPolicyRole
				err = json.Unmarshal(*v, &role)
				if err != nil {
					return err
				}
				app.Role = role
			}
		case "authentication":
			if v != nil {
				authentication, err := unmarshalBasicAuthenticationBase(*v)
				if err != nil {
					return err
				}
				app.Authentication = authentication
			}
		}
	}

	return nil
}

// AccountEncryption defines how the Video Analyzer account is (optionally) encrypted.
type AccountEncryption struct {
	// Type - The type of key used to encrypt the Account Key. Possible values include: 'AccountEncryptionKeyTypeSystemKey', 'AccountEncryptionKeyTypeCustomerKey'
	Type AccountEncryptionKeyType `json:"type,omitempty"`
	// KeyVaultProperties - The properties of the key used to encrypt the account.
	KeyVaultProperties *KeyVaultProperties `json:"keyVaultProperties,omitempty"`
	// Identity - The Key Vault identity.
	Identity *ResourceIdentity `json:"identity,omitempty"`
	// Status - READ-ONLY; The current status of the Key Vault mapping.
	Status *string `json:"status,omitempty"`
}

// MarshalJSON is the custom marshaler for AccountEncryption.
func (ae AccountEncryption) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ae.Type != "" {
		objectMap["type"] = ae.Type
	}
	if ae.KeyVaultProperties != nil {
		objectMap["keyVaultProperties"] = ae.KeyVaultProperties
	}
	if ae.Identity != nil {
		objectMap["identity"] = ae.Identity
	}
	return json.Marshal(objectMap)
}

// AudioEncoderAac a custom preset for encoding audio with the AAC codec.
type AudioEncoderAac struct {
	// BitrateKbps - Bitrate, in kilobits per second or Kbps, at which audio should be encoded (2-channel stereo audio at a sampling rate of 48 kHz). Allowed values are 96, 112, 128, 160, 192, 224, and 256. If omitted, the bitrate of the input audio is used.
	BitrateKbps *string `json:"bitrateKbps,omitempty"`
	// Type - Possible values include: 'TypeBasicAudioEncoderBaseTypeAudioEncoderBase', 'TypeBasicAudioEncoderBaseTypeMicrosoftVideoAnalyzerAudioEncoderAac'
	Type TypeBasicAudioEncoderBase `json:"@type,omitempty"`
}

// MarshalJSON is the custom marshaler for AudioEncoderAac.
func (aea AudioEncoderAac) MarshalJSON() ([]byte, error) {
	aea.Type = TypeBasicAudioEncoderBaseTypeMicrosoftVideoAnalyzerAudioEncoderAac
	objectMap := make(map[string]interface{})
	if aea.BitrateKbps != nil {
		objectMap["bitrateKbps"] = aea.BitrateKbps
	}
	if aea.Type != "" {
		objectMap["@type"] = aea.Type
	}
	return json.Marshal(objectMap)
}

// AsAudioEncoderAac is the BasicAudioEncoderBase implementation for AudioEncoderAac.
func (aea AudioEncoderAac) AsAudioEncoderAac() (*AudioEncoderAac, bool) {
	return &aea, true
}

// AsAudioEncoderBase is the BasicAudioEncoderBase implementation for AudioEncoderAac.
func (aea AudioEncoderAac) AsAudioEncoderBase() (*AudioEncoderBase, bool) {
	return nil, false
}

// AsBasicAudioEncoderBase is the BasicAudioEncoderBase implementation for AudioEncoderAac.
func (aea AudioEncoderAac) AsBasicAudioEncoderBase() (BasicAudioEncoderBase, bool) {
	return &aea, true
}

// BasicAudioEncoderBase base type for all audio encoder presets, which define the recipe or instructions on how audio
// should be processed.
type BasicAudioEncoderBase interface {
	AsAudioEncoderAac() (*AudioEncoderAac, bool)
	AsAudioEncoderBase() (*AudioEncoderBase, bool)
}

// AudioEncoderBase base type for all audio encoder presets, which define the recipe or instructions on how
// audio should be processed.
type AudioEncoderBase struct {
	// BitrateKbps - Bitrate, in kilobits per second or Kbps, at which audio should be encoded (2-channel stereo audio at a sampling rate of 48 kHz). Allowed values are 96, 112, 128, 160, 192, 224, and 256. If omitted, the bitrate of the input audio is used.
	BitrateKbps *string `json:"bitrateKbps,omitempty"`
	// Type - Possible values include: 'TypeBasicAudioEncoderBaseTypeAudioEncoderBase', 'TypeBasicAudioEncoderBaseTypeMicrosoftVideoAnalyzerAudioEncoderAac'
	Type TypeBasicAudioEncoderBase `json:"@type,omitempty"`
}

func unmarshalBasicAudioEncoderBase(body []byte) (BasicAudioEncoderBase, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["@type"] {
	case string(TypeBasicAudioEncoderBaseTypeMicrosoftVideoAnalyzerAudioEncoderAac):
		var aea AudioEncoderAac
		err := json.Unmarshal(body, &aea)
		return aea, err
	default:
		var aeb AudioEncoderBase
		err := json.Unmarshal(body, &aeb)
		return aeb, err
	}
}
func unmarshalBasicAudioEncoderBaseArray(body []byte) ([]BasicAudioEncoderBase, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	aebArray := make([]BasicAudioEncoderBase, len(rawMessages))

	for index, rawMessage := range rawMessages {
		aeb, err := unmarshalBasicAudioEncoderBase(*rawMessage)
		if err != nil {
			return nil, err
		}
		aebArray[index] = aeb
	}
	return aebArray, nil
}

// MarshalJSON is the custom marshaler for AudioEncoderBase.
func (aeb AudioEncoderBase) MarshalJSON() ([]byte, error) {
	aeb.Type = TypeBasicAudioEncoderBaseTypeAudioEncoderBase
	objectMap := make(map[string]interface{})
	if aeb.BitrateKbps != nil {
		objectMap["bitrateKbps"] = aeb.BitrateKbps
	}
	if aeb.Type != "" {
		objectMap["@type"] = aeb.Type
	}
	return json.Marshal(objectMap)
}

// AsAudioEncoderAac is the BasicAudioEncoderBase implementation for AudioEncoderBase.
func (aeb AudioEncoderBase) AsAudioEncoderAac() (*AudioEncoderAac, bool) {
	return nil, false
}

// AsAudioEncoderBase is the BasicAudioEncoderBase implementation for AudioEncoderBase.
func (aeb AudioEncoderBase) AsAudioEncoderBase() (*AudioEncoderBase, bool) {
	return &aeb, true
}

// AsBasicAudioEncoderBase is the BasicAudioEncoderBase implementation for AudioEncoderBase.
func (aeb AudioEncoderBase) AsBasicAudioEncoderBase() (BasicAudioEncoderBase, bool) {
	return &aeb, true
}

// BasicAuthenticationBase base class for access policies authentication methods.
type BasicAuthenticationBase interface {
	AsJwtAuthentication() (*JwtAuthentication, bool)
	AsAuthenticationBase() (*AuthenticationBase, bool)
}

// AuthenticationBase base class for access policies authentication methods.
type AuthenticationBase struct {
	// Type - Possible values include: 'TypeBasicAuthenticationBaseTypeAuthenticationBase', 'TypeBasicAuthenticationBaseTypeMicrosoftVideoAnalyzerJwtAuthentication'
	Type TypeBasicAuthenticationBase `json:"@type,omitempty"`
}

func unmarshalBasicAuthenticationBase(body []byte) (BasicAuthenticationBase, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["@type"] {
	case string(TypeBasicAuthenticationBaseTypeMicrosoftVideoAnalyzerJwtAuthentication):
		var ja JwtAuthentication
		err := json.Unmarshal(body, &ja)
		return ja, err
	default:
		var ab AuthenticationBase
		err := json.Unmarshal(body, &ab)
		return ab, err
	}
}
func unmarshalBasicAuthenticationBaseArray(body []byte) ([]BasicAuthenticationBase, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	abArray := make([]BasicAuthenticationBase, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ab, err := unmarshalBasicAuthenticationBase(*rawMessage)
		if err != nil {
			return nil, err
		}
		abArray[index] = ab
	}
	return abArray, nil
}

// MarshalJSON is the custom marshaler for AuthenticationBase.
func (ab AuthenticationBase) MarshalJSON() ([]byte, error) {
	ab.Type = TypeBasicAuthenticationBaseTypeAuthenticationBase
	objectMap := make(map[string]interface{})
	if ab.Type != "" {
		objectMap["@type"] = ab.Type
	}
	return json.Marshal(objectMap)
}

// AsJwtAuthentication is the BasicAuthenticationBase implementation for AuthenticationBase.
func (ab AuthenticationBase) AsJwtAuthentication() (*JwtAuthentication, bool) {
	return nil, false
}

// AsAuthenticationBase is the BasicAuthenticationBase implementation for AuthenticationBase.
func (ab AuthenticationBase) AsAuthenticationBase() (*AuthenticationBase, bool) {
	return &ab, true
}

// AsBasicAuthenticationBase is the BasicAuthenticationBase implementation for AuthenticationBase.
func (ab AuthenticationBase) AsBasicAuthenticationBase() (BasicAuthenticationBase, bool) {
	return &ab, true
}

// AzureEntityResource the resource model definition for an Azure Resource Manager resource with an etag.
type AzureEntityResource struct {
	// Etag - READ-ONLY; Resource Etag.
	Etag *string `json:"etag,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
	// SystemData - READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureEntityResource.
func (aer AzureEntityResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// BasicCertificateSource base class for certificate sources.
type BasicCertificateSource interface {
	AsPemCertificateList() (*PemCertificateList, bool)
	AsCertificateSource() (*CertificateSource, bool)
}

// CertificateSource base class for certificate sources.
type CertificateSource struct {
	// Type - Possible values include: 'TypeBasicCertificateSourceTypeCertificateSource', 'TypeBasicCertificateSourceTypeMicrosoftVideoAnalyzerPemCertificateList'
	Type TypeBasicCertificateSource `json:"@type,omitempty"`
}

func unmarshalBasicCertificateSource(body []byte) (BasicCertificateSource, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["@type"] {
	case string(TypeBasicCertificateSourceTypeMicrosoftVideoAnalyzerPemCertificateList):
		var pcl PemCertificateList
		err := json.Unmarshal(body, &pcl)
		return pcl, err
	default:
		var cs CertificateSource
		err := json.Unmarshal(body, &cs)
		return cs, err
	}
}
func unmarshalBasicCertificateSourceArray(body []byte) ([]BasicCertificateSource, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	csArray := make([]BasicCertificateSource, len(rawMessages))

	for index, rawMessage := range rawMessages {
		cs, err := unmarshalBasicCertificateSource(*rawMessage)
		if err != nil {
			return nil, err
		}
		csArray[index] = cs
	}
	return csArray, nil
}

// MarshalJSON is the custom marshaler for CertificateSource.
func (cs CertificateSource) MarshalJSON() ([]byte, error) {
	cs.Type = TypeBasicCertificateSourceTypeCertificateSource
	objectMap := make(map[string]interface{})
	if cs.Type != "" {
		objectMap["@type"] = cs.Type
	}
	return json.Marshal(objectMap)
}

// AsPemCertificateList is the BasicCertificateSource implementation for CertificateSource.
func (cs CertificateSource) AsPemCertificateList() (*PemCertificateList, bool) {
	return nil, false
}

// AsCertificateSource is the BasicCertificateSource implementation for CertificateSource.
func (cs CertificateSource) AsCertificateSource() (*CertificateSource, bool) {
	return &cs, true
}

// AsBasicCertificateSource is the BasicCertificateSource implementation for CertificateSource.
func (cs CertificateSource) AsBasicCertificateSource() (BasicCertificateSource, bool) {
	return &cs, true
}

// CheckNameAvailabilityRequest the check availability request body.
type CheckNameAvailabilityRequest struct {
	// Name - The name of the resource for which availability needs to be checked.
	Name *string `json:"name,omitempty"`
	// Type - The resource type.
	Type *string `json:"type,omitempty"`
}

// CheckNameAvailabilityResponse the check availability result.
type CheckNameAvailabilityResponse struct {
	autorest.Response `json:"-"`
	// NameAvailable - Indicates if the resource name is available.
	NameAvailable *bool `json:"nameAvailable,omitempty"`
	// Reason - The reason why the given name is not available. Possible values include: 'CheckNameAvailabilityReasonInvalid', 'CheckNameAvailabilityReasonAlreadyExists'
	Reason CheckNameAvailabilityReason `json:"reason,omitempty"`
	// Message - Detailed reason why the given name is available.
	Message *string `json:"message,omitempty"`
}

// Collection a collection of VideoAnalyzer items.
type Collection struct {
	autorest.Response `json:"-"`
	// Value - A collection of VideoAnalyzer items.
	Value *[]Model `json:"value,omitempty"`
}

// BasicCredentialsBase base class for credential objects.
type BasicCredentialsBase interface {
	AsUsernamePasswordCredentials() (*UsernamePasswordCredentials, bool)
	AsCredentialsBase() (*CredentialsBase, bool)
}

// CredentialsBase base class for credential objects.
type CredentialsBase struct {
	// Type - Possible values include: 'TypeBasicCredentialsBaseTypeCredentialsBase', 'TypeBasicCredentialsBaseTypeMicrosoftVideoAnalyzerUsernamePasswordCredentials'
	Type TypeBasicCredentialsBase `json:"@type,omitempty"`
}

func unmarshalBasicCredentialsBase(body []byte) (BasicCredentialsBase, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["@type"] {
	case string(TypeBasicCredentialsBaseTypeMicrosoftVideoAnalyzerUsernamePasswordCredentials):
		var upc UsernamePasswordCredentials
		err := json.Unmarshal(body, &upc)
		return upc, err
	default:
		var cb CredentialsBase
		err := json.Unmarshal(body, &cb)
		return cb, err
	}
}
func unmarshalBasicCredentialsBaseArray(body []byte) ([]BasicCredentialsBase, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	cbArray := make([]BasicCredentialsBase, len(rawMessages))

	for index, rawMessage := range rawMessages {
		cb, err := unmarshalBasicCredentialsBase(*rawMessage)
		if err != nil {
			return nil, err
		}
		cbArray[index] = cb
	}
	return cbArray, nil
}

// MarshalJSON is the custom marshaler for CredentialsBase.
func (cb CredentialsBase) MarshalJSON() ([]byte, error) {
	cb.Type = TypeBasicCredentialsBaseTypeCredentialsBase
	objectMap := make(map[string]interface{})
	if cb.Type != "" {
		objectMap["@type"] = cb.Type
	}
	return json.Marshal(objectMap)
}

// AsUsernamePasswordCredentials is the BasicCredentialsBase implementation for CredentialsBase.
func (cb CredentialsBase) AsUsernamePasswordCredentials() (*UsernamePasswordCredentials, bool) {
	return nil, false
}

// AsCredentialsBase is the BasicCredentialsBase implementation for CredentialsBase.
func (cb CredentialsBase) AsCredentialsBase() (*CredentialsBase, bool) {
	return &cb, true
}

// AsBasicCredentialsBase is the BasicCredentialsBase implementation for CredentialsBase.
func (cb CredentialsBase) AsBasicCredentialsBase() (BasicCredentialsBase, bool) {
	return &cb, true
}

// EccTokenKey required validation properties for tokens generated with Elliptical Curve algorithm.
type EccTokenKey struct {
	// Alg - Elliptical curve algorithm to be used: ES256, ES384 or ES512. Possible values include: 'AccessPolicyEccAlgoES256', 'AccessPolicyEccAlgoES384', 'AccessPolicyEccAlgoES512'
	Alg AccessPolicyEccAlgo `json:"alg,omitempty"`
	// X - X coordinate.
	X *string `json:"x,omitempty"`
	// Y - Y coordinate.
	Y *string `json:"y,omitempty"`
	// Kid - JWT token key id. Validation keys are looked up based on the key id present on the JWT token header.
	Kid *string `json:"kid,omitempty"`
	// Type - Possible values include: 'TypeBasicTokenKeyTypeTokenKey', 'TypeBasicTokenKeyTypeMicrosoftVideoAnalyzerRsaTokenKey', 'TypeBasicTokenKeyTypeMicrosoftVideoAnalyzerEccTokenKey'
	Type TypeBasicTokenKey `json:"@type,omitempty"`
}

// MarshalJSON is the custom marshaler for EccTokenKey.
func (etk EccTokenKey) MarshalJSON() ([]byte, error) {
	etk.Type = TypeBasicTokenKeyTypeMicrosoftVideoAnalyzerEccTokenKey
	objectMap := make(map[string]interface{})
	if etk.Alg != "" {
		objectMap["alg"] = etk.Alg
	}
	if etk.X != nil {
		objectMap["x"] = etk.X
	}
	if etk.Y != nil {
		objectMap["y"] = etk.Y
	}
	if etk.Kid != nil {
		objectMap["kid"] = etk.Kid
	}
	if etk.Type != "" {
		objectMap["@type"] = etk.Type
	}
	return json.Marshal(objectMap)
}

// AsRsaTokenKey is the BasicTokenKey implementation for EccTokenKey.
func (etk EccTokenKey) AsRsaTokenKey() (*RsaTokenKey, bool) {
	return nil, false
}

// AsEccTokenKey is the BasicTokenKey implementation for EccTokenKey.
func (etk EccTokenKey) AsEccTokenKey() (*EccTokenKey, bool) {
	return &etk, true
}

// AsTokenKey is the BasicTokenKey implementation for EccTokenKey.
func (etk EccTokenKey) AsTokenKey() (*TokenKey, bool) {
	return nil, false
}

// AsBasicTokenKey is the BasicTokenKey implementation for EccTokenKey.
func (etk EccTokenKey) AsBasicTokenKey() (BasicTokenKey, bool) {
	return &etk, true
}

// EdgeModuleEntity the representation of an edge module.
type EdgeModuleEntity struct {
	autorest.Response `json:"-"`
	// EdgeModuleProperties - The resource properties.
	*EdgeModuleProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
	// SystemData - READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for EdgeModuleEntity.
func (eme EdgeModuleEntity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if eme.EdgeModuleProperties != nil {
		objectMap["properties"] = eme.EdgeModuleProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for EdgeModuleEntity struct.
func (eme *EdgeModuleEntity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var edgeModuleProperties EdgeModuleProperties
				err = json.Unmarshal(*v, &edgeModuleProperties)
				if err != nil {
					return err
				}
				eme.EdgeModuleProperties = &edgeModuleProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				eme.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				eme.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				eme.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				eme.SystemData = &systemData
			}
		}
	}

	return nil
}

// EdgeModuleEntityCollection a collection of EdgeModuleEntity items.
type EdgeModuleEntityCollection struct {
	autorest.Response `json:"-"`
	// Value - A collection of EdgeModuleEntity items.
	Value *[]EdgeModuleEntity `json:"value,omitempty"`
	// NextLink - A link to the next page of the collection (when the collection contains too many results to return in one response).
	NextLink *string `json:"@nextLink,omitempty"`
}

// EdgeModuleEntityCollectionIterator provides access to a complete listing of EdgeModuleEntity values.
type EdgeModuleEntityCollectionIterator struct {
	i    int
	page EdgeModuleEntityCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *EdgeModuleEntityCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EdgeModuleEntityCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *EdgeModuleEntityCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter EdgeModuleEntityCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter EdgeModuleEntityCollectionIterator) Response() EdgeModuleEntityCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter EdgeModuleEntityCollectionIterator) Value() EdgeModuleEntity {
	if !iter.page.NotDone() {
		return EdgeModuleEntity{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the EdgeModuleEntityCollectionIterator type.
func NewEdgeModuleEntityCollectionIterator(page EdgeModuleEntityCollectionPage) EdgeModuleEntityCollectionIterator {
	return EdgeModuleEntityCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (emec EdgeModuleEntityCollection) IsEmpty() bool {
	return emec.Value == nil || len(*emec.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (emec EdgeModuleEntityCollection) hasNextLink() bool {
	return emec.NextLink != nil && len(*emec.NextLink) != 0
}

// edgeModuleEntityCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (emec EdgeModuleEntityCollection) edgeModuleEntityCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !emec.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(emec.NextLink)))
}

// EdgeModuleEntityCollectionPage contains a page of EdgeModuleEntity values.
type EdgeModuleEntityCollectionPage struct {
	fn   func(context.Context, EdgeModuleEntityCollection) (EdgeModuleEntityCollection, error)
	emec EdgeModuleEntityCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *EdgeModuleEntityCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EdgeModuleEntityCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.emec)
		if err != nil {
			return err
		}
		page.emec = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *EdgeModuleEntityCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page EdgeModuleEntityCollectionPage) NotDone() bool {
	return !page.emec.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page EdgeModuleEntityCollectionPage) Response() EdgeModuleEntityCollection {
	return page.emec
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page EdgeModuleEntityCollectionPage) Values() []EdgeModuleEntity {
	if page.emec.IsEmpty() {
		return nil
	}
	return *page.emec.Value
}

// Creates a new instance of the EdgeModuleEntityCollectionPage type.
func NewEdgeModuleEntityCollectionPage(cur EdgeModuleEntityCollection, getNextPage func(context.Context, EdgeModuleEntityCollection) (EdgeModuleEntityCollection, error)) EdgeModuleEntityCollectionPage {
	return EdgeModuleEntityCollectionPage{
		fn:   getNextPage,
		emec: cur,
	}
}

// EdgeModuleProperties application level properties for the edge module resource.
type EdgeModuleProperties struct {
	// EdgeModuleID - READ-ONLY; Internal ID generated for the instance of the Video Analyzer edge module.
	EdgeModuleID *uuid.UUID `json:"edgeModuleId,omitempty"`
}

// MarshalJSON is the custom marshaler for EdgeModuleProperties.
func (emp EdgeModuleProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// EdgeModuleProvisioningToken provisioning token properties. A provisioning token allows for a single
// instance of Azure Video analyzer IoT edge module to be initialized and authorized to the cloud account.
// The provisioning token itself is short lived and it is only used for the initial handshake between IoT
// edge module and the cloud. After the initial handshake, the IoT edge module will agree on a set of
// authentication keys which will be auto-rotated as long as the module is able to periodically connect to
// the cloud. A new provisioning token can be generated for the same IoT edge module in case the module
// state lost or reset.
type EdgeModuleProvisioningToken struct {
	autorest.Response `json:"-"`
	// ExpirationDate - READ-ONLY; The expiration date of the registration token. The Azure Video Analyzer IoT edge module must be initialized and connected to the Internet prior to the token expiration date.
	ExpirationDate *date.Time `json:"expirationDate,omitempty"`
	// Token - READ-ONLY; The token blob to be provided to the Azure Video Analyzer IoT edge module through the Azure IoT Edge module twin properties.
	Token *string `json:"token,omitempty"`
}

// MarshalJSON is the custom marshaler for EdgeModuleProvisioningToken.
func (empt EdgeModuleProvisioningToken) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// EncoderCustomPreset describes a custom preset for encoding the input content using the encoder
// processor.
type EncoderCustomPreset struct {
	// AudioEncoder - Describes a custom preset for encoding audio.
	AudioEncoder BasicAudioEncoderBase `json:"audioEncoder,omitempty"`
	// VideoEncoder - Describes a custom preset for encoding video.
	VideoEncoder BasicVideoEncoderBase `json:"videoEncoder,omitempty"`
	// Type - Possible values include: 'TypeBasicEncoderPresetBaseTypeEncoderPresetBase', 'TypeBasicEncoderPresetBaseTypeMicrosoftVideoAnalyzerEncoderSystemPreset', 'TypeBasicEncoderPresetBaseTypeMicrosoftVideoAnalyzerEncoderCustomPreset'
	Type TypeBasicEncoderPresetBase `json:"@type,omitempty"`
}

// MarshalJSON is the custom marshaler for EncoderCustomPreset.
func (ecp EncoderCustomPreset) MarshalJSON() ([]byte, error) {
	ecp.Type = TypeBasicEncoderPresetBaseTypeMicrosoftVideoAnalyzerEncoderCustomPreset
	objectMap := make(map[string]interface{})
	objectMap["audioEncoder"] = ecp.AudioEncoder
	objectMap["videoEncoder"] = ecp.VideoEncoder
	if ecp.Type != "" {
		objectMap["@type"] = ecp.Type
	}
	return json.Marshal(objectMap)
}

// AsEncoderSystemPreset is the BasicEncoderPresetBase implementation for EncoderCustomPreset.
func (ecp EncoderCustomPreset) AsEncoderSystemPreset() (*EncoderSystemPreset, bool) {
	return nil, false
}

// AsEncoderCustomPreset is the BasicEncoderPresetBase implementation for EncoderCustomPreset.
func (ecp EncoderCustomPreset) AsEncoderCustomPreset() (*EncoderCustomPreset, bool) {
	return &ecp, true
}

// AsEncoderPresetBase is the BasicEncoderPresetBase implementation for EncoderCustomPreset.
func (ecp EncoderCustomPreset) AsEncoderPresetBase() (*EncoderPresetBase, bool) {
	return nil, false
}

// AsBasicEncoderPresetBase is the BasicEncoderPresetBase implementation for EncoderCustomPreset.
func (ecp EncoderCustomPreset) AsBasicEncoderPresetBase() (BasicEncoderPresetBase, bool) {
	return &ecp, true
}

// UnmarshalJSON is the custom unmarshaler for EncoderCustomPreset struct.
func (ecp *EncoderCustomPreset) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "audioEncoder":
			if v != nil {
				audioEncoder, err := unmarshalBasicAudioEncoderBase(*v)
				if err != nil {
					return err
				}
				ecp.AudioEncoder = audioEncoder
			}
		case "videoEncoder":
			if v != nil {
				videoEncoder, err := unmarshalBasicVideoEncoderBase(*v)
				if err != nil {
					return err
				}
				ecp.VideoEncoder = videoEncoder
			}
		case "@type":
			if v != nil {
				var typeVar TypeBasicEncoderPresetBase
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ecp.Type = typeVar
			}
		}
	}

	return nil
}

// BasicEncoderPresetBase base type for all encoder presets, which define the recipe or instructions on how the input
// content should be processed.
type BasicEncoderPresetBase interface {
	AsEncoderSystemPreset() (*EncoderSystemPreset, bool)
	AsEncoderCustomPreset() (*EncoderCustomPreset, bool)
	AsEncoderPresetBase() (*EncoderPresetBase, bool)
}

// EncoderPresetBase base type for all encoder presets, which define the recipe or instructions on how the
// input content should be processed.
type EncoderPresetBase struct {
	// Type - Possible values include: 'TypeBasicEncoderPresetBaseTypeEncoderPresetBase', 'TypeBasicEncoderPresetBaseTypeMicrosoftVideoAnalyzerEncoderSystemPreset', 'TypeBasicEncoderPresetBaseTypeMicrosoftVideoAnalyzerEncoderCustomPreset'
	Type TypeBasicEncoderPresetBase `json:"@type,omitempty"`
}

func unmarshalBasicEncoderPresetBase(body []byte) (BasicEncoderPresetBase, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["@type"] {
	case string(TypeBasicEncoderPresetBaseTypeMicrosoftVideoAnalyzerEncoderSystemPreset):
		var esp EncoderSystemPreset
		err := json.Unmarshal(body, &esp)
		return esp, err
	case string(TypeBasicEncoderPresetBaseTypeMicrosoftVideoAnalyzerEncoderCustomPreset):
		var ecp EncoderCustomPreset
		err := json.Unmarshal(body, &ecp)
		return ecp, err
	default:
		var epb EncoderPresetBase
		err := json.Unmarshal(body, &epb)
		return epb, err
	}
}
func unmarshalBasicEncoderPresetBaseArray(body []byte) ([]BasicEncoderPresetBase, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	epbArray := make([]BasicEncoderPresetBase, len(rawMessages))

	for index, rawMessage := range rawMessages {
		epb, err := unmarshalBasicEncoderPresetBase(*rawMessage)
		if err != nil {
			return nil, err
		}
		epbArray[index] = epb
	}
	return epbArray, nil
}

// MarshalJSON is the custom marshaler for EncoderPresetBase.
func (epb EncoderPresetBase) MarshalJSON() ([]byte, error) {
	epb.Type = TypeBasicEncoderPresetBaseTypeEncoderPresetBase
	objectMap := make(map[string]interface{})
	if epb.Type != "" {
		objectMap["@type"] = epb.Type
	}
	return json.Marshal(objectMap)
}

// AsEncoderSystemPreset is the BasicEncoderPresetBase implementation for EncoderPresetBase.
func (epb EncoderPresetBase) AsEncoderSystemPreset() (*EncoderSystemPreset, bool) {
	return nil, false
}

// AsEncoderCustomPreset is the BasicEncoderPresetBase implementation for EncoderPresetBase.
func (epb EncoderPresetBase) AsEncoderCustomPreset() (*EncoderCustomPreset, bool) {
	return nil, false
}

// AsEncoderPresetBase is the BasicEncoderPresetBase implementation for EncoderPresetBase.
func (epb EncoderPresetBase) AsEncoderPresetBase() (*EncoderPresetBase, bool) {
	return &epb, true
}

// AsBasicEncoderPresetBase is the BasicEncoderPresetBase implementation for EncoderPresetBase.
func (epb EncoderPresetBase) AsBasicEncoderPresetBase() (BasicEncoderPresetBase, bool) {
	return &epb, true
}

// EncoderProcessor encoder processor allows for encoding of the input content. For example, it can used to
// change the resolution from 4K to 1280x720.
type EncoderProcessor struct {
	// Preset - The encoder preset, which defines the recipe or instructions on how the input content should be processed.
	Preset BasicEncoderPresetBase `json:"preset,omitempty"`
	// Inputs - An array of upstream node references within the topology to be used as inputs for this node.
	Inputs *[]NodeInput `json:"inputs,omitempty"`
	// Name - Node name. Must be unique within the topology.
	Name *string `json:"name,omitempty"`
	// Type - Possible values include: 'TypeNodeBase', 'TypeMicrosoftVideoAnalyzerSourceNodeBase', 'TypeMicrosoftVideoAnalyzerProcessorNodeBase', 'TypeMicrosoftVideoAnalyzerSinkNodeBase', 'TypeMicrosoftVideoAnalyzerRtspSource', 'TypeMicrosoftVideoAnalyzerVideoSource', 'TypeMicrosoftVideoAnalyzerEncoderProcessor', 'TypeMicrosoftVideoAnalyzerVideoSink'
	Type Type `json:"@type,omitempty"`
}

// MarshalJSON is the custom marshaler for EncoderProcessor.
func (ep EncoderProcessor) MarshalJSON() ([]byte, error) {
	ep.Type = TypeMicrosoftVideoAnalyzerEncoderProcessor
	objectMap := make(map[string]interface{})
	objectMap["preset"] = ep.Preset
	if ep.Inputs != nil {
		objectMap["inputs"] = ep.Inputs
	}
	if ep.Name != nil {
		objectMap["name"] = ep.Name
	}
	if ep.Type != "" {
		objectMap["@type"] = ep.Type
	}
	return json.Marshal(objectMap)
}

// AsSourceNodeBase is the BasicNodeBase implementation for EncoderProcessor.
func (ep EncoderProcessor) AsSourceNodeBase() (*SourceNodeBase, bool) {
	return nil, false
}

// AsBasicSourceNodeBase is the BasicNodeBase implementation for EncoderProcessor.
func (ep EncoderProcessor) AsBasicSourceNodeBase() (BasicSourceNodeBase, bool) {
	return nil, false
}

// AsProcessorNodeBase is the BasicNodeBase implementation for EncoderProcessor.
func (ep EncoderProcessor) AsProcessorNodeBase() (*ProcessorNodeBase, bool) {
	return nil, false
}

// AsBasicProcessorNodeBase is the BasicNodeBase implementation for EncoderProcessor.
func (ep EncoderProcessor) AsBasicProcessorNodeBase() (BasicProcessorNodeBase, bool) {
	return &ep, true
}

// AsSinkNodeBase is the BasicNodeBase implementation for EncoderProcessor.
func (ep EncoderProcessor) AsSinkNodeBase() (*SinkNodeBase, bool) {
	return nil, false
}

// AsBasicSinkNodeBase is the BasicNodeBase implementation for EncoderProcessor.
func (ep EncoderProcessor) AsBasicSinkNodeBase() (BasicSinkNodeBase, bool) {
	return nil, false
}

// AsRtspSource is the BasicNodeBase implementation for EncoderProcessor.
func (ep EncoderProcessor) AsRtspSource() (*RtspSource, bool) {
	return nil, false
}

// AsVideoSource is the BasicNodeBase implementation for EncoderProcessor.
func (ep EncoderProcessor) AsVideoSource() (*VideoSource, bool) {
	return nil, false
}

// AsEncoderProcessor is the BasicNodeBase implementation for EncoderProcessor.
func (ep EncoderProcessor) AsEncoderProcessor() (*EncoderProcessor, bool) {
	return &ep, true
}

// AsVideoSink is the BasicNodeBase implementation for EncoderProcessor.
func (ep EncoderProcessor) AsVideoSink() (*VideoSink, bool) {
	return nil, false
}

// AsNodeBase is the BasicNodeBase implementation for EncoderProcessor.
func (ep EncoderProcessor) AsNodeBase() (*NodeBase, bool) {
	return nil, false
}

// AsBasicNodeBase is the BasicNodeBase implementation for EncoderProcessor.
func (ep EncoderProcessor) AsBasicNodeBase() (BasicNodeBase, bool) {
	return &ep, true
}

// UnmarshalJSON is the custom unmarshaler for EncoderProcessor struct.
func (ep *EncoderProcessor) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "preset":
			if v != nil {
				preset, err := unmarshalBasicEncoderPresetBase(*v)
				if err != nil {
					return err
				}
				ep.Preset = preset
			}
		case "inputs":
			if v != nil {
				var inputs []NodeInput
				err = json.Unmarshal(*v, &inputs)
				if err != nil {
					return err
				}
				ep.Inputs = &inputs
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ep.Name = &name
			}
		case "@type":
			if v != nil {
				var typeVar Type
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ep.Type = typeVar
			}
		}
	}

	return nil
}

// EncoderSystemPreset describes a built-in preset for encoding the input content using the encoder
// processor.
type EncoderSystemPreset struct {
	// Name - Name of the built-in encoding preset. Possible values include: 'EncoderSystemPresetTypeSingleLayer540pH264AAC', 'EncoderSystemPresetTypeSingleLayer720pH264AAC', 'EncoderSystemPresetTypeSingleLayer1080pH264AAC', 'EncoderSystemPresetTypeSingleLayer2160pH264AAC'
	Name EncoderSystemPresetType `json:"name,omitempty"`
	// Type - Possible values include: 'TypeBasicEncoderPresetBaseTypeEncoderPresetBase', 'TypeBasicEncoderPresetBaseTypeMicrosoftVideoAnalyzerEncoderSystemPreset', 'TypeBasicEncoderPresetBaseTypeMicrosoftVideoAnalyzerEncoderCustomPreset'
	Type TypeBasicEncoderPresetBase `json:"@type,omitempty"`
}

// MarshalJSON is the custom marshaler for EncoderSystemPreset.
func (esp EncoderSystemPreset) MarshalJSON() ([]byte, error) {
	esp.Type = TypeBasicEncoderPresetBaseTypeMicrosoftVideoAnalyzerEncoderSystemPreset
	objectMap := make(map[string]interface{})
	if esp.Name != "" {
		objectMap["name"] = esp.Name
	}
	if esp.Type != "" {
		objectMap["@type"] = esp.Type
	}
	return json.Marshal(objectMap)
}

// AsEncoderSystemPreset is the BasicEncoderPresetBase implementation for EncoderSystemPreset.
func (esp EncoderSystemPreset) AsEncoderSystemPreset() (*EncoderSystemPreset, bool) {
	return &esp, true
}

// AsEncoderCustomPreset is the BasicEncoderPresetBase implementation for EncoderSystemPreset.
func (esp EncoderSystemPreset) AsEncoderCustomPreset() (*EncoderCustomPreset, bool) {
	return nil, false
}

// AsEncoderPresetBase is the BasicEncoderPresetBase implementation for EncoderSystemPreset.
func (esp EncoderSystemPreset) AsEncoderPresetBase() (*EncoderPresetBase, bool) {
	return nil, false
}

// AsBasicEncoderPresetBase is the BasicEncoderPresetBase implementation for EncoderSystemPreset.
func (esp EncoderSystemPreset) AsBasicEncoderPresetBase() (BasicEncoderPresetBase, bool) {
	return &esp, true
}

// Endpoint the endpoint details.
type Endpoint struct {
	// EndpointURL - The URL of the endpoint.
	EndpointURL *string `json:"endpointUrl,omitempty"`
	// Type - The type of the endpoint.
	Type *string `json:"type,omitempty"`
}

// BasicEndpointBase base class for endpoints.
type BasicEndpointBase interface {
	AsUnsecuredEndpoint() (*UnsecuredEndpoint, bool)
	AsTLSEndpoint() (*TLSEndpoint, bool)
	AsEndpointBase() (*EndpointBase, bool)
}

// EndpointBase base class for endpoints.
type EndpointBase struct {
	// Credentials - Credentials to be presented to the endpoint.
	Credentials BasicCredentialsBase `json:"credentials,omitempty"`
	// URL - The endpoint URL for Video Analyzer to connect to.
	URL *string `json:"url,omitempty"`
	// Tunnel - Describes the tunnel through which Video Analyzer can connect to the endpoint URL. This is an optional property, typically used when the endpoint is behind a firewall.
	Tunnel BasicTunnelBase `json:"tunnel,omitempty"`
	// Type - Possible values include: 'TypeBasicEndpointBaseTypeEndpointBase', 'TypeBasicEndpointBaseTypeMicrosoftVideoAnalyzerUnsecuredEndpoint', 'TypeBasicEndpointBaseTypeMicrosoftVideoAnalyzerTLSEndpoint'
	Type TypeBasicEndpointBase `json:"@type,omitempty"`
}

func unmarshalBasicEndpointBase(body []byte) (BasicEndpointBase, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["@type"] {
	case string(TypeBasicEndpointBaseTypeMicrosoftVideoAnalyzerUnsecuredEndpoint):
		var ue UnsecuredEndpoint
		err := json.Unmarshal(body, &ue)
		return ue, err
	case string(TypeBasicEndpointBaseTypeMicrosoftVideoAnalyzerTLSEndpoint):
		var te TLSEndpoint
		err := json.Unmarshal(body, &te)
		return te, err
	default:
		var eb EndpointBase
		err := json.Unmarshal(body, &eb)
		return eb, err
	}
}
func unmarshalBasicEndpointBaseArray(body []byte) ([]BasicEndpointBase, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	ebArray := make([]BasicEndpointBase, len(rawMessages))

	for index, rawMessage := range rawMessages {
		eb, err := unmarshalBasicEndpointBase(*rawMessage)
		if err != nil {
			return nil, err
		}
		ebArray[index] = eb
	}
	return ebArray, nil
}

// MarshalJSON is the custom marshaler for EndpointBase.
func (eb EndpointBase) MarshalJSON() ([]byte, error) {
	eb.Type = TypeBasicEndpointBaseTypeEndpointBase
	objectMap := make(map[string]interface{})
	objectMap["credentials"] = eb.Credentials
	if eb.URL != nil {
		objectMap["url"] = eb.URL
	}
	objectMap["tunnel"] = eb.Tunnel
	if eb.Type != "" {
		objectMap["@type"] = eb.Type
	}
	return json.Marshal(objectMap)
}

// AsUnsecuredEndpoint is the BasicEndpointBase implementation for EndpointBase.
func (eb EndpointBase) AsUnsecuredEndpoint() (*UnsecuredEndpoint, bool) {
	return nil, false
}

// AsTLSEndpoint is the BasicEndpointBase implementation for EndpointBase.
func (eb EndpointBase) AsTLSEndpoint() (*TLSEndpoint, bool) {
	return nil, false
}

// AsEndpointBase is the BasicEndpointBase implementation for EndpointBase.
func (eb EndpointBase) AsEndpointBase() (*EndpointBase, bool) {
	return &eb, true
}

// AsBasicEndpointBase is the BasicEndpointBase implementation for EndpointBase.
func (eb EndpointBase) AsBasicEndpointBase() (BasicEndpointBase, bool) {
	return &eb, true
}

// UnmarshalJSON is the custom unmarshaler for EndpointBase struct.
func (eb *EndpointBase) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "credentials":
			if v != nil {
				credentials, err := unmarshalBasicCredentialsBase(*v)
				if err != nil {
					return err
				}
				eb.Credentials = credentials
			}
		case "url":
			if v != nil {
				var URL string
				err = json.Unmarshal(*v, &URL)
				if err != nil {
					return err
				}
				eb.URL = &URL
			}
		case "tunnel":
			if v != nil {
				tunnel, err := unmarshalBasicTunnelBase(*v)
				if err != nil {
					return err
				}
				eb.Tunnel = tunnel
			}
		case "@type":
			if v != nil {
				var typeVar TypeBasicEndpointBase
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				eb.Type = typeVar
			}
		}
	}

	return nil
}

// ErrorAdditionalInfo the resource management error additional info.
type ErrorAdditionalInfo struct {
	// Type - READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty"`
	// Info - READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorAdditionalInfo.
func (eai ErrorAdditionalInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ErrorDetail the error detail.
type ErrorDetail struct {
	// Code - READ-ONLY; The error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; The error message.
	Message *string `json:"message,omitempty"`
	// Target - READ-ONLY; The error target.
	Target *string `json:"target,omitempty"`
	// Details - READ-ONLY; The error details.
	Details *[]ErrorDetail `json:"details,omitempty"`
	// AdditionalInfo - READ-ONLY; The error additional info.
	AdditionalInfo *[]ErrorAdditionalInfo `json:"additionalInfo,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorDetail.
func (ed ErrorDetail) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ErrorResponse common error response for all Azure Resource Manager APIs to return error details for
// failed operations. (This also follows the OData error response format.).
type ErrorResponse struct {
	// Error - The error object.
	Error *ErrorDetail `json:"error,omitempty"`
}

// GroupLevelAccessControl group level network access control.
type GroupLevelAccessControl struct {
	// PublicNetworkAccess - Whether or not public network access is allowed for specified resources under the Video Analyzer account. Possible values include: 'PublicNetworkAccessEnabled', 'PublicNetworkAccessDisabled'
	PublicNetworkAccess PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`
}

// Identity the managed identity for the Video Analyzer resource.
type Identity struct {
	// Type - The identity type.
	Type *string `json:"type,omitempty"`
	// UserAssignedIdentities - The User Assigned Managed Identities.
	UserAssignedIdentities map[string]*UserAssignedManagedIdentity `json:"userAssignedIdentities"`
}

// MarshalJSON is the custom marshaler for Identity.
func (i Identity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if i.Type != nil {
		objectMap["type"] = i.Type
	}
	if i.UserAssignedIdentities != nil {
		objectMap["userAssignedIdentities"] = i.UserAssignedIdentities
	}
	return json.Marshal(objectMap)
}

// IotHub the IoT Hub details.
type IotHub struct {
	// ID - The IoT Hub resource identifier.
	ID *string `json:"id,omitempty"`
	// Identity - The IoT Hub identity.
	Identity *ResourceIdentity `json:"identity,omitempty"`
	// Status - READ-ONLY; The current status of the Iot Hub mapping.
	Status *string `json:"status,omitempty"`
}

// MarshalJSON is the custom marshaler for IotHub.
func (ih IotHub) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ih.ID != nil {
		objectMap["id"] = ih.ID
	}
	if ih.Identity != nil {
		objectMap["identity"] = ih.Identity
	}
	return json.Marshal(objectMap)
}

// JwtAuthentication properties for access validation based on JSON Web Tokens (JWT).
type JwtAuthentication struct {
	// Issuers - List of expected token issuers. Token issuer is valid if it matches at least one of the given values.
	Issuers *[]string `json:"issuers,omitempty"`
	// Audiences - List of expected token audiences. Token audience is valid if it matches at least one of the given values.
	Audiences *[]string `json:"audiences,omitempty"`
	// Claims - List of additional token claims to be validated. Token must contains all claims and respective values for it to be valid.
	Claims *[]TokenClaim `json:"claims,omitempty"`
	// Keys - List of keys which can be used to validate access tokens. Having multiple keys allow for seamless key rotation of the token signing key. Token signature must match exactly one key.
	Keys *[]BasicTokenKey `json:"keys,omitempty"`
	// Type - Possible values include: 'TypeBasicAuthenticationBaseTypeAuthenticationBase', 'TypeBasicAuthenticationBaseTypeMicrosoftVideoAnalyzerJwtAuthentication'
	Type TypeBasicAuthenticationBase `json:"@type,omitempty"`
}

// MarshalJSON is the custom marshaler for JwtAuthentication.
func (ja JwtAuthentication) MarshalJSON() ([]byte, error) {
	ja.Type = TypeBasicAuthenticationBaseTypeMicrosoftVideoAnalyzerJwtAuthentication
	objectMap := make(map[string]interface{})
	if ja.Issuers != nil {
		objectMap["issuers"] = ja.Issuers
	}
	if ja.Audiences != nil {
		objectMap["audiences"] = ja.Audiences
	}
	if ja.Claims != nil {
		objectMap["claims"] = ja.Claims
	}
	if ja.Keys != nil {
		objectMap["keys"] = ja.Keys
	}
	if ja.Type != "" {
		objectMap["@type"] = ja.Type
	}
	return json.Marshal(objectMap)
}

// AsJwtAuthentication is the BasicAuthenticationBase implementation for JwtAuthentication.
func (ja JwtAuthentication) AsJwtAuthentication() (*JwtAuthentication, bool) {
	return &ja, true
}

// AsAuthenticationBase is the BasicAuthenticationBase implementation for JwtAuthentication.
func (ja JwtAuthentication) AsAuthenticationBase() (*AuthenticationBase, bool) {
	return nil, false
}

// AsBasicAuthenticationBase is the BasicAuthenticationBase implementation for JwtAuthentication.
func (ja JwtAuthentication) AsBasicAuthenticationBase() (BasicAuthenticationBase, bool) {
	return &ja, true
}

// UnmarshalJSON is the custom unmarshaler for JwtAuthentication struct.
func (ja *JwtAuthentication) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "issuers":
			if v != nil {
				var issuers []string
				err = json.Unmarshal(*v, &issuers)
				if err != nil {
					return err
				}
				ja.Issuers = &issuers
			}
		case "audiences":
			if v != nil {
				var audiences []string
				err = json.Unmarshal(*v, &audiences)
				if err != nil {
					return err
				}
				ja.Audiences = &audiences
			}
		case "claims":
			if v != nil {
				var claims []TokenClaim
				err = json.Unmarshal(*v, &claims)
				if err != nil {
					return err
				}
				ja.Claims = &claims
			}
		case "keys":
			if v != nil {
				keys, err := unmarshalBasicTokenKeyArray(*v)
				if err != nil {
					return err
				}
				ja.Keys = &keys
			}
		case "@type":
			if v != nil {
				var typeVar TypeBasicAuthenticationBase
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ja.Type = typeVar
			}
		}
	}

	return nil
}

// KeyVaultProperties the details for accessing the encryption keys in Key Vault.
type KeyVaultProperties struct {
	// KeyIdentifier - The URL of the Key Vault key used to encrypt the account. The key may either be versioned (for example https://vault/keys/mykey/version1) or reference a key without a version (for example https://vault/keys/mykey).
	KeyIdentifier *string `json:"keyIdentifier,omitempty"`
	// CurrentKeyIdentifier - READ-ONLY; The current key used to encrypt Video Analyzer account, including the key version.
	CurrentKeyIdentifier *string `json:"currentKeyIdentifier,omitempty"`
}

// MarshalJSON is the custom marshaler for KeyVaultProperties.
func (kvp KeyVaultProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if kvp.KeyIdentifier != nil {
		objectMap["keyIdentifier"] = kvp.KeyIdentifier
	}
	return json.Marshal(objectMap)
}

// ListProvisioningTokenInput the input parameters to generate registration token for the Azure Video
// Analyzer IoT edge module.
type ListProvisioningTokenInput struct {
	// ExpirationDate - The desired expiration date of the registration token. The Azure Video Analyzer IoT edge module must be initialized and connected to the Internet prior to the token expiration date.
	ExpirationDate *date.Time `json:"expirationDate,omitempty"`
}

// LivePipeline live pipeline represents a unique instance of a live topology, used for real-time
// ingestion, archiving and publishing of content for a unique RTSP camera.
type LivePipeline struct {
	autorest.Response `json:"-"`
	// LivePipelineProperties - The resource properties.
	*LivePipelineProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
	// SystemData - READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for LivePipeline.
func (lp LivePipeline) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lp.LivePipelineProperties != nil {
		objectMap["properties"] = lp.LivePipelineProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for LivePipeline struct.
func (lp *LivePipeline) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var livePipelineProperties LivePipelineProperties
				err = json.Unmarshal(*v, &livePipelineProperties)
				if err != nil {
					return err
				}
				lp.LivePipelineProperties = &livePipelineProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				lp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				lp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				lp.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				lp.SystemData = &systemData
			}
		}
	}

	return nil
}

// LivePipelineCollection a collection of LivePipeline items.
type LivePipelineCollection struct {
	autorest.Response `json:"-"`
	// Value - A collection of LivePipeline items.
	Value *[]LivePipeline `json:"value,omitempty"`
	// NextLink - A link to the next page of the collection (when the collection contains too many results to return in one response).
	NextLink *string `json:"@nextLink,omitempty"`
}

// LivePipelineCollectionIterator provides access to a complete listing of LivePipeline values.
type LivePipelineCollectionIterator struct {
	i    int
	page LivePipelineCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *LivePipelineCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LivePipelineCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *LivePipelineCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter LivePipelineCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter LivePipelineCollectionIterator) Response() LivePipelineCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter LivePipelineCollectionIterator) Value() LivePipeline {
	if !iter.page.NotDone() {
		return LivePipeline{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the LivePipelineCollectionIterator type.
func NewLivePipelineCollectionIterator(page LivePipelineCollectionPage) LivePipelineCollectionIterator {
	return LivePipelineCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (lpc LivePipelineCollection) IsEmpty() bool {
	return lpc.Value == nil || len(*lpc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (lpc LivePipelineCollection) hasNextLink() bool {
	return lpc.NextLink != nil && len(*lpc.NextLink) != 0
}

// livePipelineCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lpc LivePipelineCollection) livePipelineCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !lpc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lpc.NextLink)))
}

// LivePipelineCollectionPage contains a page of LivePipeline values.
type LivePipelineCollectionPage struct {
	fn  func(context.Context, LivePipelineCollection) (LivePipelineCollection, error)
	lpc LivePipelineCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *LivePipelineCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LivePipelineCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.lpc)
		if err != nil {
			return err
		}
		page.lpc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *LivePipelineCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page LivePipelineCollectionPage) NotDone() bool {
	return !page.lpc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page LivePipelineCollectionPage) Response() LivePipelineCollection {
	return page.lpc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page LivePipelineCollectionPage) Values() []LivePipeline {
	if page.lpc.IsEmpty() {
		return nil
	}
	return *page.lpc.Value
}

// Creates a new instance of the LivePipelineCollectionPage type.
func NewLivePipelineCollectionPage(cur LivePipelineCollection, getNextPage func(context.Context, LivePipelineCollection) (LivePipelineCollection, error)) LivePipelineCollectionPage {
	return LivePipelineCollectionPage{
		fn:  getNextPage,
		lpc: cur,
	}
}

// LivePipelineOperationStatus used for tracking the status of an operation on the live pipeline.
type LivePipelineOperationStatus struct {
	autorest.Response `json:"-"`
	// Name - READ-ONLY; The name of the live pipeline operation.
	Name *string `json:"name,omitempty"`
	// Status - READ-ONLY; The status of the live pipeline operation.
	Status *string `json:"status,omitempty"`
	// Error - READ-ONLY; The error details for the live pipeline operation.
	Error *ErrorDetail `json:"error,omitempty"`
}

// MarshalJSON is the custom marshaler for LivePipelineOperationStatus.
func (lpos LivePipelineOperationStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// LivePipelineProperties live pipeline properties.
type LivePipelineProperties struct {
	// TopologyName - The reference to an existing pipeline topology defined for real-time content processing. When activated, this live pipeline will process content according to the pipeline topology definition.
	TopologyName *string `json:"topologyName,omitempty"`
	// Description - An optional description for the pipeline.
	Description *string `json:"description,omitempty"`
	// BitrateKbps - Maximum bitrate capacity in Kbps reserved for the live pipeline. The allowed range is from 500 to 3000 Kbps in increments of 100 Kbps. If the RTSP camera exceeds this capacity, then the service will disconnect temporarily from the camera. It will retry to re-establish connection (with exponential backoff), checking to see if the camera bitrate is now below the reserved capacity. Doing so will ensure that one 'noisy neighbor' does not affect other live pipelines in your account.
	BitrateKbps *int32 `json:"bitrateKbps,omitempty"`
	// State - READ-ONLY; Current state of the pipeline (read-only). Possible values include: 'LivePipelineStateInactive', 'LivePipelineStateActivating', 'LivePipelineStateActive', 'LivePipelineStateDeactivating'
	State LivePipelineState `json:"state,omitempty"`
	// Parameters - List of the instance level parameter values for the user-defined topology parameters. A pipeline can only define or override parameters values for parameters which have been declared in the referenced topology. Topology parameters without a default value must be defined. Topology parameters with a default value can be optionally be overridden.
	Parameters *[]ParameterDefinition `json:"parameters,omitempty"`
}

// MarshalJSON is the custom marshaler for LivePipelineProperties.
func (lpp LivePipelineProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lpp.TopologyName != nil {
		objectMap["topologyName"] = lpp.TopologyName
	}
	if lpp.Description != nil {
		objectMap["description"] = lpp.Description
	}
	if lpp.BitrateKbps != nil {
		objectMap["bitrateKbps"] = lpp.BitrateKbps
	}
	if lpp.Parameters != nil {
		objectMap["parameters"] = lpp.Parameters
	}
	return json.Marshal(objectMap)
}

// LivePipelinePropertiesUpdate live pipeline properties.
type LivePipelinePropertiesUpdate struct {
	// TopologyName - The reference to an existing pipeline topology defined for real-time content processing. When activated, this live pipeline will process content according to the pipeline topology definition.
	TopologyName *string `json:"topologyName,omitempty"`
	// Description - An optional description for the pipeline.
	Description *string `json:"description,omitempty"`
	// BitrateKbps - Maximum bitrate capacity in Kbps reserved for the live pipeline. The allowed range is from 500 to 3000 Kbps in increments of 100 Kbps. If the RTSP camera exceeds this capacity, then the service will disconnect temporarily from the camera. It will retry to re-establish connection (with exponential backoff), checking to see if the camera bitrate is now below the reserved capacity. Doing so will ensure that one 'noisy neighbor' does not affect other live pipelines in your account.
	BitrateKbps *int32 `json:"bitrateKbps,omitempty"`
	// State - READ-ONLY; Current state of the pipeline (read-only). Possible values include: 'LivePipelineStateInactive', 'LivePipelineStateActivating', 'LivePipelineStateActive', 'LivePipelineStateDeactivating'
	State LivePipelineState `json:"state,omitempty"`
	// Parameters - List of the instance level parameter values for the user-defined topology parameters. A pipeline can only define or override parameters values for parameters which have been declared in the referenced topology. Topology parameters without a default value must be defined. Topology parameters with a default value can be optionally be overridden.
	Parameters *[]ParameterDefinition `json:"parameters,omitempty"`
}

// MarshalJSON is the custom marshaler for LivePipelinePropertiesUpdate.
func (lppu LivePipelinePropertiesUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lppu.TopologyName != nil {
		objectMap["topologyName"] = lppu.TopologyName
	}
	if lppu.Description != nil {
		objectMap["description"] = lppu.Description
	}
	if lppu.BitrateKbps != nil {
		objectMap["bitrateKbps"] = lppu.BitrateKbps
	}
	if lppu.Parameters != nil {
		objectMap["parameters"] = lppu.Parameters
	}
	return json.Marshal(objectMap)
}

// LivePipelinesActivateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type LivePipelinesActivateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(LivePipelinesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *LivePipelinesActivateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for LivePipelinesActivateFuture.Result.
func (future *LivePipelinesActivateFuture) result(client LivePipelinesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "videoanalyzer.LivePipelinesActivateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("videoanalyzer.LivePipelinesActivateFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// LivePipelinesDeactivateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type LivePipelinesDeactivateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(LivePipelinesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *LivePipelinesDeactivateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for LivePipelinesDeactivateFuture.Result.
func (future *LivePipelinesDeactivateFuture) result(client LivePipelinesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "videoanalyzer.LivePipelinesDeactivateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("videoanalyzer.LivePipelinesDeactivateFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// LivePipelineUpdate live pipeline represents a unique instance of a live topology, used for real-time
// ingestion, archiving and publishing of content for a unique RTSP camera.
type LivePipelineUpdate struct {
	// LivePipelinePropertiesUpdate - The resource properties.
	*LivePipelinePropertiesUpdate `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
	// SystemData - READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for LivePipelineUpdate.
func (lpu LivePipelineUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lpu.LivePipelinePropertiesUpdate != nil {
		objectMap["properties"] = lpu.LivePipelinePropertiesUpdate
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for LivePipelineUpdate struct.
func (lpu *LivePipelineUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var livePipelinePropertiesUpdate LivePipelinePropertiesUpdate
				err = json.Unmarshal(*v, &livePipelinePropertiesUpdate)
				if err != nil {
					return err
				}
				lpu.LivePipelinePropertiesUpdate = &livePipelinePropertiesUpdate
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				lpu.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				lpu.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				lpu.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				lpu.SystemData = &systemData
			}
		}
	}

	return nil
}

// LogSpecification a diagnostic log emitted by service.
type LogSpecification struct {
	// Name - READ-ONLY; The diagnostic log category name.
	Name *string `json:"name,omitempty"`
	// DisplayName - READ-ONLY; The diagnostic log category display name.
	DisplayName *string `json:"displayName,omitempty"`
	// BlobDuration - READ-ONLY; The time range for requests in each blob.
	BlobDuration *string `json:"blobDuration,omitempty"`
}

// MarshalJSON is the custom marshaler for LogSpecification.
func (ls LogSpecification) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// MetricDimension a metric dimension.
type MetricDimension struct {
	// Name - READ-ONLY; The metric dimension name.
	Name *string `json:"name,omitempty"`
	// DisplayName - READ-ONLY; The display name for the dimension.
	DisplayName *string `json:"displayName,omitempty"`
	// ToBeExportedForShoebox - READ-ONLY; Whether to export metric to shoebox.
	ToBeExportedForShoebox *bool `json:"toBeExportedForShoebox,omitempty"`
}

// MarshalJSON is the custom marshaler for MetricDimension.
func (md MetricDimension) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// MetricSpecification a metric emitted by service.
type MetricSpecification struct {
	// Name - READ-ONLY; The metric name.
	Name *string `json:"name,omitempty"`
	// DisplayName - READ-ONLY; The metric display name.
	DisplayName *string `json:"displayName,omitempty"`
	// DisplayDescription - READ-ONLY; The metric display description.
	DisplayDescription *string `json:"displayDescription,omitempty"`
	// Unit - READ-ONLY; The metric unit. Possible values include: 'MetricUnitBytes', 'MetricUnitCount', 'MetricUnitMilliseconds'
	Unit MetricUnit `json:"unit,omitempty"`
	// AggregationType - READ-ONLY; The metric aggregation type. Possible values include: 'MetricAggregationTypeAverage', 'MetricAggregationTypeCount', 'MetricAggregationTypeTotal'
	AggregationType MetricAggregationType `json:"aggregationType,omitempty"`
	// LockAggregationType - READ-ONLY; The metric lock aggregation type. Possible values include: 'MetricAggregationTypeAverage', 'MetricAggregationTypeCount', 'MetricAggregationTypeTotal'
	LockAggregationType MetricAggregationType `json:"lockAggregationType,omitempty"`
	// SupportedAggregationTypes - Supported aggregation types.
	SupportedAggregationTypes *[]string `json:"supportedAggregationTypes,omitempty"`
	// Dimensions - READ-ONLY; The metric dimensions.
	Dimensions *[]MetricDimension `json:"dimensions,omitempty"`
	// EnableRegionalMdmAccount - READ-ONLY; Indicates whether regional MDM account is enabled.
	EnableRegionalMdmAccount *bool `json:"enableRegionalMdmAccount,omitempty"`
	// SourceMdmAccount - READ-ONLY; The source MDM account.
	SourceMdmAccount *string `json:"sourceMdmAccount,omitempty"`
	// SourceMdmNamespace - READ-ONLY; The source MDM namespace.
	SourceMdmNamespace *string `json:"sourceMdmNamespace,omitempty"`
	// SupportedTimeGrainTypes - READ-ONLY; The supported time grain types.
	SupportedTimeGrainTypes *[]string `json:"supportedTimeGrainTypes,omitempty"`
}

// MarshalJSON is the custom marshaler for MetricSpecification.
func (ms MetricSpecification) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ms.SupportedAggregationTypes != nil {
		objectMap["supportedAggregationTypes"] = ms.SupportedAggregationTypes
	}
	return json.Marshal(objectMap)
}

// Model the Video Analyzer account.
type Model struct {
	autorest.Response `json:"-"`
	// PropertiesType - The resource properties.
	*PropertiesType `json:"properties,omitempty"`
	// Identity - The identities associated to the Video Analyzer resource.
	Identity *Identity `json:"identity,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
	// SystemData - READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for Model.
func (mVar Model) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mVar.PropertiesType != nil {
		objectMap["properties"] = mVar.PropertiesType
	}
	if mVar.Identity != nil {
		objectMap["identity"] = mVar.Identity
	}
	if mVar.Tags != nil {
		objectMap["tags"] = mVar.Tags
	}
	if mVar.Location != nil {
		objectMap["location"] = mVar.Location
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Model struct.
func (mVar *Model) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var propertiesType PropertiesType
				err = json.Unmarshal(*v, &propertiesType)
				if err != nil {
					return err
				}
				mVar.PropertiesType = &propertiesType
			}
		case "identity":
			if v != nil {
				var identity Identity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				mVar.Identity = &identity
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				mVar.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				mVar.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mVar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mVar.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mVar.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				mVar.SystemData = &systemData
			}
		}
	}

	return nil
}

// NetworkAccessControl network access control for video analyzer account.
type NetworkAccessControl struct {
	// Integration - Public network access for integration group.
	Integration *GroupLevelAccessControl `json:"integration,omitempty"`
	// Ingestion - Public network access for ingestion group.
	Ingestion *GroupLevelAccessControl `json:"ingestion,omitempty"`
	// Consumption - Public network access for consumption group.
	Consumption *GroupLevelAccessControl `json:"consumption,omitempty"`
}

// BasicNodeBase base class for nodes.
type BasicNodeBase interface {
	AsSourceNodeBase() (*SourceNodeBase, bool)
	AsBasicSourceNodeBase() (BasicSourceNodeBase, bool)
	AsProcessorNodeBase() (*ProcessorNodeBase, bool)
	AsBasicProcessorNodeBase() (BasicProcessorNodeBase, bool)
	AsSinkNodeBase() (*SinkNodeBase, bool)
	AsBasicSinkNodeBase() (BasicSinkNodeBase, bool)
	AsRtspSource() (*RtspSource, bool)
	AsVideoSource() (*VideoSource, bool)
	AsEncoderProcessor() (*EncoderProcessor, bool)
	AsVideoSink() (*VideoSink, bool)
	AsNodeBase() (*NodeBase, bool)
}

// NodeBase base class for nodes.
type NodeBase struct {
	// Name - Node name. Must be unique within the topology.
	Name *string `json:"name,omitempty"`
	// Type - Possible values include: 'TypeNodeBase', 'TypeMicrosoftVideoAnalyzerSourceNodeBase', 'TypeMicrosoftVideoAnalyzerProcessorNodeBase', 'TypeMicrosoftVideoAnalyzerSinkNodeBase', 'TypeMicrosoftVideoAnalyzerRtspSource', 'TypeMicrosoftVideoAnalyzerVideoSource', 'TypeMicrosoftVideoAnalyzerEncoderProcessor', 'TypeMicrosoftVideoAnalyzerVideoSink'
	Type Type `json:"@type,omitempty"`
}

func unmarshalBasicNodeBase(body []byte) (BasicNodeBase, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["@type"] {
	case string(TypeMicrosoftVideoAnalyzerSourceNodeBase):
		var snb SourceNodeBase
		err := json.Unmarshal(body, &snb)
		return snb, err
	case string(TypeMicrosoftVideoAnalyzerProcessorNodeBase):
		var pnb ProcessorNodeBase
		err := json.Unmarshal(body, &pnb)
		return pnb, err
	case string(TypeMicrosoftVideoAnalyzerSinkNodeBase):
		var snb SinkNodeBase
		err := json.Unmarshal(body, &snb)
		return snb, err
	case string(TypeMicrosoftVideoAnalyzerRtspSource):
		var rs RtspSource
		err := json.Unmarshal(body, &rs)
		return rs, err
	case string(TypeMicrosoftVideoAnalyzerVideoSource):
		var vs VideoSource
		err := json.Unmarshal(body, &vs)
		return vs, err
	case string(TypeMicrosoftVideoAnalyzerEncoderProcessor):
		var ep EncoderProcessor
		err := json.Unmarshal(body, &ep)
		return ep, err
	case string(TypeMicrosoftVideoAnalyzerVideoSink):
		var vs VideoSink
		err := json.Unmarshal(body, &vs)
		return vs, err
	default:
		var nb NodeBase
		err := json.Unmarshal(body, &nb)
		return nb, err
	}
}
func unmarshalBasicNodeBaseArray(body []byte) ([]BasicNodeBase, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	nbArray := make([]BasicNodeBase, len(rawMessages))

	for index, rawMessage := range rawMessages {
		nb, err := unmarshalBasicNodeBase(*rawMessage)
		if err != nil {
			return nil, err
		}
		nbArray[index] = nb
	}
	return nbArray, nil
}

// MarshalJSON is the custom marshaler for NodeBase.
func (nb NodeBase) MarshalJSON() ([]byte, error) {
	nb.Type = TypeNodeBase
	objectMap := make(map[string]interface{})
	if nb.Name != nil {
		objectMap["name"] = nb.Name
	}
	if nb.Type != "" {
		objectMap["@type"] = nb.Type
	}
	return json.Marshal(objectMap)
}

// AsSourceNodeBase is the BasicNodeBase implementation for NodeBase.
func (nb NodeBase) AsSourceNodeBase() (*SourceNodeBase, bool) {
	return nil, false
}

// AsBasicSourceNodeBase is the BasicNodeBase implementation for NodeBase.
func (nb NodeBase) AsBasicSourceNodeBase() (BasicSourceNodeBase, bool) {
	return nil, false
}

// AsProcessorNodeBase is the BasicNodeBase implementation for NodeBase.
func (nb NodeBase) AsProcessorNodeBase() (*ProcessorNodeBase, bool) {
	return nil, false
}

// AsBasicProcessorNodeBase is the BasicNodeBase implementation for NodeBase.
func (nb NodeBase) AsBasicProcessorNodeBase() (BasicProcessorNodeBase, bool) {
	return nil, false
}

// AsSinkNodeBase is the BasicNodeBase implementation for NodeBase.
func (nb NodeBase) AsSinkNodeBase() (*SinkNodeBase, bool) {
	return nil, false
}

// AsBasicSinkNodeBase is the BasicNodeBase implementation for NodeBase.
func (nb NodeBase) AsBasicSinkNodeBase() (BasicSinkNodeBase, bool) {
	return nil, false
}

// AsRtspSource is the BasicNodeBase implementation for NodeBase.
func (nb NodeBase) AsRtspSource() (*RtspSource, bool) {
	return nil, false
}

// AsVideoSource is the BasicNodeBase implementation for NodeBase.
func (nb NodeBase) AsVideoSource() (*VideoSource, bool) {
	return nil, false
}

// AsEncoderProcessor is the BasicNodeBase implementation for NodeBase.
func (nb NodeBase) AsEncoderProcessor() (*EncoderProcessor, bool) {
	return nil, false
}

// AsVideoSink is the BasicNodeBase implementation for NodeBase.
func (nb NodeBase) AsVideoSink() (*VideoSink, bool) {
	return nil, false
}

// AsNodeBase is the BasicNodeBase implementation for NodeBase.
func (nb NodeBase) AsNodeBase() (*NodeBase, bool) {
	return &nb, true
}

// AsBasicNodeBase is the BasicNodeBase implementation for NodeBase.
func (nb NodeBase) AsBasicNodeBase() (BasicNodeBase, bool) {
	return &nb, true
}

// NodeInput describes an input signal to be used on a pipeline node.
type NodeInput struct {
	// NodeName - The name of the upstream node in the pipeline which output is used as input of the current node.
	NodeName *string `json:"nodeName,omitempty"`
}

// Operation an operation.
type Operation struct {
	// Name - The operation name.
	Name *string `json:"name,omitempty"`
	// Display - The operation display name.
	Display *OperationDisplay `json:"display,omitempty"`
	// Origin - Origin of the operation.
	Origin *string `json:"origin,omitempty"`
	// Properties - Operation properties format.
	Properties *Properties `json:"properties,omitempty"`
	// IsDataAction - Whether the operation applies to data-plane.
	IsDataAction *bool `json:"isDataAction,omitempty"`
	// ActionType - Indicates the action type. Possible values include: 'ActionTypeInternal'
	ActionType ActionType `json:"actionType,omitempty"`
}

// OperationCollection a collection of Operation items.
type OperationCollection struct {
	autorest.Response `json:"-"`
	// Value - A collection of Operation items.
	Value *[]Operation `json:"value,omitempty"`
}

// OperationDisplay operation details.
type OperationDisplay struct {
	// Provider - The service provider.
	Provider *string `json:"provider,omitempty"`
	// Resource - Resource on which the operation is performed.
	Resource *string `json:"resource,omitempty"`
	// Operation - The operation type.
	Operation *string `json:"operation,omitempty"`
	// Description - The operation description.
	Description *string `json:"description,omitempty"`
}

// OperationStatus status of video analyzer operation.
type OperationStatus struct {
	autorest.Response `json:"-"`
	// Name - Operation identifier.
	Name *string `json:"name,omitempty"`
	// ID - Operation resource ID.
	ID *string `json:"id,omitempty"`
	// StartTime - Operation start time.
	StartTime *string `json:"startTime,omitempty"`
	// EndTime - Operation end time.
	EndTime *string `json:"endTime,omitempty"`
	// Status - Operation status.
	Status *string      `json:"status,omitempty"`
	Error  *ErrorDetail `json:"error,omitempty"`
}

// ParameterDeclaration single topology parameter declaration. Declared parameters can and must be
// referenced throughout the topology and can optionally have default values to be used when they are not
// defined in the pipelines.
type ParameterDeclaration struct {
	// Name - Name of the parameter.
	Name *string `json:"name,omitempty"`
	// Type - Type of the parameter. Possible values include: 'ParameterTypeString', 'ParameterTypeSecretString', 'ParameterTypeInt', 'ParameterTypeDouble', 'ParameterTypeBool'
	Type ParameterType `json:"type,omitempty"`
	// Description - Description of the parameter.
	Description *string `json:"description,omitempty"`
	// Default - The default value for the parameter to be used if the pipeline does not specify a value.
	Default *string `json:"default,omitempty"`
}

// ParameterDefinition defines the parameter value of an specific pipeline topology parameter. See pipeline
// topology parameters for more information.
type ParameterDefinition struct {
	// Name - Name of the parameter declared in the pipeline topology.
	Name *string `json:"name,omitempty"`
	// Value - Parameter value to be applied on this specific pipeline.
	Value *string `json:"value,omitempty"`
}

// PemCertificateList a list of PEM formatted certificates.
type PemCertificateList struct {
	// Certificates - PEM formatted public certificates. One certificate per entry.
	Certificates *[]string `json:"certificates,omitempty"`
	// Type - Possible values include: 'TypeBasicCertificateSourceTypeCertificateSource', 'TypeBasicCertificateSourceTypeMicrosoftVideoAnalyzerPemCertificateList'
	Type TypeBasicCertificateSource `json:"@type,omitempty"`
}

// MarshalJSON is the custom marshaler for PemCertificateList.
func (pcl PemCertificateList) MarshalJSON() ([]byte, error) {
	pcl.Type = TypeBasicCertificateSourceTypeMicrosoftVideoAnalyzerPemCertificateList
	objectMap := make(map[string]interface{})
	if pcl.Certificates != nil {
		objectMap["certificates"] = pcl.Certificates
	}
	if pcl.Type != "" {
		objectMap["@type"] = pcl.Type
	}
	return json.Marshal(objectMap)
}

// AsPemCertificateList is the BasicCertificateSource implementation for PemCertificateList.
func (pcl PemCertificateList) AsPemCertificateList() (*PemCertificateList, bool) {
	return &pcl, true
}

// AsCertificateSource is the BasicCertificateSource implementation for PemCertificateList.
func (pcl PemCertificateList) AsCertificateSource() (*CertificateSource, bool) {
	return nil, false
}

// AsBasicCertificateSource is the BasicCertificateSource implementation for PemCertificateList.
func (pcl PemCertificateList) AsBasicCertificateSource() (BasicCertificateSource, bool) {
	return &pcl, true
}

// PipelineJob pipeline job represents a unique instance of a batch topology, used for offline processing
// of selected portions of archived content.
type PipelineJob struct {
	autorest.Response `json:"-"`
	// PipelineJobProperties - The resource properties.
	*PipelineJobProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
	// SystemData - READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for PipelineJob.
func (pj PipelineJob) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pj.PipelineJobProperties != nil {
		objectMap["properties"] = pj.PipelineJobProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PipelineJob struct.
func (pj *PipelineJob) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var pipelineJobProperties PipelineJobProperties
				err = json.Unmarshal(*v, &pipelineJobProperties)
				if err != nil {
					return err
				}
				pj.PipelineJobProperties = &pipelineJobProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pj.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pj.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pj.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				pj.SystemData = &systemData
			}
		}
	}

	return nil
}

// PipelineJobCollection a collection of PipelineJob items.
type PipelineJobCollection struct {
	autorest.Response `json:"-"`
	// Value - A collection of PipelineJob items.
	Value *[]PipelineJob `json:"value,omitempty"`
	// NextLink - A link to the next page of the collection (when the collection contains too many results to return in one response).
	NextLink *string `json:"@nextLink,omitempty"`
}

// PipelineJobCollectionIterator provides access to a complete listing of PipelineJob values.
type PipelineJobCollectionIterator struct {
	i    int
	page PipelineJobCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PipelineJobCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PipelineJobCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PipelineJobCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PipelineJobCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PipelineJobCollectionIterator) Response() PipelineJobCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PipelineJobCollectionIterator) Value() PipelineJob {
	if !iter.page.NotDone() {
		return PipelineJob{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PipelineJobCollectionIterator type.
func NewPipelineJobCollectionIterator(page PipelineJobCollectionPage) PipelineJobCollectionIterator {
	return PipelineJobCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (pjc PipelineJobCollection) IsEmpty() bool {
	return pjc.Value == nil || len(*pjc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (pjc PipelineJobCollection) hasNextLink() bool {
	return pjc.NextLink != nil && len(*pjc.NextLink) != 0
}

// pipelineJobCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pjc PipelineJobCollection) pipelineJobCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !pjc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pjc.NextLink)))
}

// PipelineJobCollectionPage contains a page of PipelineJob values.
type PipelineJobCollectionPage struct {
	fn  func(context.Context, PipelineJobCollection) (PipelineJobCollection, error)
	pjc PipelineJobCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PipelineJobCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PipelineJobCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.pjc)
		if err != nil {
			return err
		}
		page.pjc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PipelineJobCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PipelineJobCollectionPage) NotDone() bool {
	return !page.pjc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PipelineJobCollectionPage) Response() PipelineJobCollection {
	return page.pjc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PipelineJobCollectionPage) Values() []PipelineJob {
	if page.pjc.IsEmpty() {
		return nil
	}
	return *page.pjc.Value
}

// Creates a new instance of the PipelineJobCollectionPage type.
func NewPipelineJobCollectionPage(cur PipelineJobCollection, getNextPage func(context.Context, PipelineJobCollection) (PipelineJobCollection, error)) PipelineJobCollectionPage {
	return PipelineJobCollectionPage{
		fn:  getNextPage,
		pjc: cur,
	}
}

// PipelineJobError details about the error for a failed pipeline job.
type PipelineJobError struct {
	// Code - The error code.
	Code *string `json:"code,omitempty"`
	// Message - The error message.
	Message *string `json:"message,omitempty"`
}

// PipelineJobOperationStatus used for tracking the status of an operation on the pipeline job.
type PipelineJobOperationStatus struct {
	autorest.Response `json:"-"`
	// Name - READ-ONLY; The name of the pipeline job operation.
	Name *string `json:"name,omitempty"`
	// Status - READ-ONLY; The status of the pipeline job operation.
	Status *string `json:"status,omitempty"`
	// Error - READ-ONLY; The error details for the pipeline job operation.
	Error *ErrorDetail `json:"error,omitempty"`
}

// MarshalJSON is the custom marshaler for PipelineJobOperationStatus.
func (pjos PipelineJobOperationStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// PipelineJobProperties pipeline job properties.
type PipelineJobProperties struct {
	// TopologyName - Reference to an existing pipeline topology. When activated, this pipeline job will process content according to the pipeline topology definition.
	TopologyName *string `json:"topologyName,omitempty"`
	// Description - An optional description for the pipeline.
	Description *string `json:"description,omitempty"`
	// State - READ-ONLY; Current state of the pipeline (read-only). Possible values include: 'PipelineJobStateProcessing', 'PipelineJobStateCanceled', 'PipelineJobStateCompleted', 'PipelineJobStateFailed'
	State PipelineJobState `json:"state,omitempty"`
	// Expiration - READ-ONLY; The date-time by when this pipeline job will be automatically deleted from your account.
	Expiration *date.Time `json:"expiration,omitempty"`
	// Error - READ-ONLY; Details about the error, in case the pipeline job fails.
	Error *PipelineJobError `json:"error,omitempty"`
	// Parameters - List of the instance level parameter values for the user-defined topology parameters. A pipeline can only define or override parameters values for parameters which have been declared in the referenced topology. Topology parameters without a default value must be defined. Topology parameters with a default value can be optionally be overridden.
	Parameters *[]ParameterDefinition `json:"parameters,omitempty"`
}

// MarshalJSON is the custom marshaler for PipelineJobProperties.
func (pjp PipelineJobProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pjp.TopologyName != nil {
		objectMap["topologyName"] = pjp.TopologyName
	}
	if pjp.Description != nil {
		objectMap["description"] = pjp.Description
	}
	if pjp.Parameters != nil {
		objectMap["parameters"] = pjp.Parameters
	}
	return json.Marshal(objectMap)
}

// PipelineJobPropertiesUpdate pipeline job properties.
type PipelineJobPropertiesUpdate struct {
	// TopologyName - Reference to an existing pipeline topology. When activated, this pipeline job will process content according to the pipeline topology definition.
	TopologyName *string `json:"topologyName,omitempty"`
	// Description - An optional description for the pipeline.
	Description *string `json:"description,omitempty"`
	// State - READ-ONLY; Current state of the pipeline (read-only). Possible values include: 'PipelineJobStateProcessing', 'PipelineJobStateCanceled', 'PipelineJobStateCompleted', 'PipelineJobStateFailed'
	State PipelineJobState `json:"state,omitempty"`
	// Expiration - READ-ONLY; The date-time by when this pipeline job will be automatically deleted from your account.
	Expiration *date.Time `json:"expiration,omitempty"`
	// Error - READ-ONLY; Details about the error, in case the pipeline job fails.
	Error *PipelineJobError `json:"error,omitempty"`
	// Parameters - List of the instance level parameter values for the user-defined topology parameters. A pipeline can only define or override parameters values for parameters which have been declared in the referenced topology. Topology parameters without a default value must be defined. Topology parameters with a default value can be optionally be overridden.
	Parameters *[]ParameterDefinition `json:"parameters,omitempty"`
}

// MarshalJSON is the custom marshaler for PipelineJobPropertiesUpdate.
func (pjpu PipelineJobPropertiesUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pjpu.TopologyName != nil {
		objectMap["topologyName"] = pjpu.TopologyName
	}
	if pjpu.Description != nil {
		objectMap["description"] = pjpu.Description
	}
	if pjpu.Parameters != nil {
		objectMap["parameters"] = pjpu.Parameters
	}
	return json.Marshal(objectMap)
}

// PipelineJobsCancelFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type PipelineJobsCancelFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PipelineJobsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *PipelineJobsCancelFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for PipelineJobsCancelFuture.Result.
func (future *PipelineJobsCancelFuture) result(client PipelineJobsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "videoanalyzer.PipelineJobsCancelFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("videoanalyzer.PipelineJobsCancelFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// PipelineJobUpdate pipeline job represents a unique instance of a batch topology, used for offline
// processing of selected portions of archived content.
type PipelineJobUpdate struct {
	// PipelineJobPropertiesUpdate - The resource properties.
	*PipelineJobPropertiesUpdate `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
	// SystemData - READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for PipelineJobUpdate.
func (pju PipelineJobUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pju.PipelineJobPropertiesUpdate != nil {
		objectMap["properties"] = pju.PipelineJobPropertiesUpdate
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PipelineJobUpdate struct.
func (pju *PipelineJobUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var pipelineJobPropertiesUpdate PipelineJobPropertiesUpdate
				err = json.Unmarshal(*v, &pipelineJobPropertiesUpdate)
				if err != nil {
					return err
				}
				pju.PipelineJobPropertiesUpdate = &pipelineJobPropertiesUpdate
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pju.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pju.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pju.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				pju.SystemData = &systemData
			}
		}
	}

	return nil
}

// PipelineTopology pipeline topology describes the processing steps to be applied when processing content
// for a particular outcome. The topology should be defined according to the scenario to be achieved and
// can be reused across many pipeline instances which share the same processing characteristics. For
// instance, a pipeline topology which captures content from a RTSP camera and archives the content can be
// reused across many different cameras, as long as the same processing is to be applied across all the
// cameras. Individual instance properties can be defined through the use of user-defined parameters, which
// allow for a topology to be parameterized. This allows  individual pipelines refer to different values,
// such as individual cameras' RTSP endpoints and credentials. Overall a topology is composed of the
// following:
//
// - Parameters: list of user defined parameters that can be references across the topology nodes.
// - Sources: list of one or more data sources nodes such as an RTSP source which allows for content to be
// ingested from cameras.
// - Processors: list of nodes which perform data analysis or transformations.
// - Sinks: list of one or more data sinks which allow for data to be stored or exported to other
// destinations.
type PipelineTopology struct {
	autorest.Response `json:"-"`
	// PipelineTopologyProperties - The resource properties.
	*PipelineTopologyProperties `json:"properties,omitempty"`
	// Kind - Topology kind. Possible values include: 'KindLive', 'KindBatch'
	Kind Kind `json:"kind,omitempty"`
	// Sku - Describes the properties of a SKU.
	Sku *Sku `json:"sku,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
	// SystemData - READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for PipelineTopology.
func (pt PipelineTopology) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pt.PipelineTopologyProperties != nil {
		objectMap["properties"] = pt.PipelineTopologyProperties
	}
	if pt.Kind != "" {
		objectMap["kind"] = pt.Kind
	}
	if pt.Sku != nil {
		objectMap["sku"] = pt.Sku
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PipelineTopology struct.
func (pt *PipelineTopology) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var pipelineTopologyProperties PipelineTopologyProperties
				err = json.Unmarshal(*v, &pipelineTopologyProperties)
				if err != nil {
					return err
				}
				pt.PipelineTopologyProperties = &pipelineTopologyProperties
			}
		case "kind":
			if v != nil {
				var kind Kind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				pt.Kind = kind
			}
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				pt.Sku = &sku
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pt.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pt.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pt.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				pt.SystemData = &systemData
			}
		}
	}

	return nil
}

// PipelineTopologyCollection a collection of PipelineTopology items.
type PipelineTopologyCollection struct {
	autorest.Response `json:"-"`
	// Value - A collection of PipelineTopology items.
	Value *[]PipelineTopology `json:"value,omitempty"`
	// NextLink - A link to the next page of the collection (when the collection contains too many results to return in one response).
	NextLink *string `json:"@nextLink,omitempty"`
}

// PipelineTopologyCollectionIterator provides access to a complete listing of PipelineTopology values.
type PipelineTopologyCollectionIterator struct {
	i    int
	page PipelineTopologyCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PipelineTopologyCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PipelineTopologyCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PipelineTopologyCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PipelineTopologyCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PipelineTopologyCollectionIterator) Response() PipelineTopologyCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PipelineTopologyCollectionIterator) Value() PipelineTopology {
	if !iter.page.NotDone() {
		return PipelineTopology{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PipelineTopologyCollectionIterator type.
func NewPipelineTopologyCollectionIterator(page PipelineTopologyCollectionPage) PipelineTopologyCollectionIterator {
	return PipelineTopologyCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ptc PipelineTopologyCollection) IsEmpty() bool {
	return ptc.Value == nil || len(*ptc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ptc PipelineTopologyCollection) hasNextLink() bool {
	return ptc.NextLink != nil && len(*ptc.NextLink) != 0
}

// pipelineTopologyCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ptc PipelineTopologyCollection) pipelineTopologyCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !ptc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ptc.NextLink)))
}

// PipelineTopologyCollectionPage contains a page of PipelineTopology values.
type PipelineTopologyCollectionPage struct {
	fn  func(context.Context, PipelineTopologyCollection) (PipelineTopologyCollection, error)
	ptc PipelineTopologyCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PipelineTopologyCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PipelineTopologyCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ptc)
		if err != nil {
			return err
		}
		page.ptc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PipelineTopologyCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PipelineTopologyCollectionPage) NotDone() bool {
	return !page.ptc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PipelineTopologyCollectionPage) Response() PipelineTopologyCollection {
	return page.ptc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PipelineTopologyCollectionPage) Values() []PipelineTopology {
	if page.ptc.IsEmpty() {
		return nil
	}
	return *page.ptc.Value
}

// Creates a new instance of the PipelineTopologyCollectionPage type.
func NewPipelineTopologyCollectionPage(cur PipelineTopologyCollection, getNextPage func(context.Context, PipelineTopologyCollection) (PipelineTopologyCollection, error)) PipelineTopologyCollectionPage {
	return PipelineTopologyCollectionPage{
		fn:  getNextPage,
		ptc: cur,
	}
}

// PipelineTopologyProperties describes the properties of a pipeline topology.
type PipelineTopologyProperties struct {
	// Description - An optional description of the pipeline topology. It is recommended that the expected use of the topology to be described here.
	Description *string `json:"description,omitempty"`
	// Parameters - List of the topology parameter declarations. Parameters declared here can be referenced throughout the topology nodes through the use of "${PARAMETER_NAME}" string pattern. Parameters can have optional default values and can later be defined in individual instances of the pipeline.
	Parameters *[]ParameterDeclaration `json:"parameters,omitempty"`
	// Sources - List of the topology source nodes. Source nodes enable external data to be ingested by the pipeline.
	Sources *[]BasicSourceNodeBase `json:"sources,omitempty"`
	// Processors - List of the topology processor nodes. Processor nodes enable pipeline data to be analyzed, processed or transformed.
	Processors *[]BasicProcessorNodeBase `json:"processors,omitempty"`
	// Sinks - List of the topology sink nodes. Sink nodes allow pipeline data to be stored or exported.
	Sinks *[]BasicSinkNodeBase `json:"sinks,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for PipelineTopologyProperties struct.
func (ptp *PipelineTopologyProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				ptp.Description = &description
			}
		case "parameters":
			if v != nil {
				var parameters []ParameterDeclaration
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				ptp.Parameters = &parameters
			}
		case "sources":
			if v != nil {
				sources, err := unmarshalBasicSourceNodeBaseArray(*v)
				if err != nil {
					return err
				}
				ptp.Sources = &sources
			}
		case "processors":
			if v != nil {
				processors, err := unmarshalBasicProcessorNodeBaseArray(*v)
				if err != nil {
					return err
				}
				ptp.Processors = &processors
			}
		case "sinks":
			if v != nil {
				sinks, err := unmarshalBasicSinkNodeBaseArray(*v)
				if err != nil {
					return err
				}
				ptp.Sinks = &sinks
			}
		}
	}

	return nil
}

// PipelineTopologyPropertiesUpdate describes the properties of a pipeline topology.
type PipelineTopologyPropertiesUpdate struct {
	// Description - An optional description of the pipeline topology. It is recommended that the expected use of the topology to be described here.
	Description *string `json:"description,omitempty"`
	// Parameters - List of the topology parameter declarations. Parameters declared here can be referenced throughout the topology nodes through the use of "${PARAMETER_NAME}" string pattern. Parameters can have optional default values and can later be defined in individual instances of the pipeline.
	Parameters *[]ParameterDeclaration `json:"parameters,omitempty"`
	// Sources - List of the topology source nodes. Source nodes enable external data to be ingested by the pipeline.
	Sources *[]BasicSourceNodeBase `json:"sources,omitempty"`
	// Processors - List of the topology processor nodes. Processor nodes enable pipeline data to be analyzed, processed or transformed.
	Processors *[]BasicProcessorNodeBase `json:"processors,omitempty"`
	// Sinks - List of the topology sink nodes. Sink nodes allow pipeline data to be stored or exported.
	Sinks *[]BasicSinkNodeBase `json:"sinks,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for PipelineTopologyPropertiesUpdate struct.
func (ptpu *PipelineTopologyPropertiesUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				ptpu.Description = &description
			}
		case "parameters":
			if v != nil {
				var parameters []ParameterDeclaration
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				ptpu.Parameters = &parameters
			}
		case "sources":
			if v != nil {
				sources, err := unmarshalBasicSourceNodeBaseArray(*v)
				if err != nil {
					return err
				}
				ptpu.Sources = &sources
			}
		case "processors":
			if v != nil {
				processors, err := unmarshalBasicProcessorNodeBaseArray(*v)
				if err != nil {
					return err
				}
				ptpu.Processors = &processors
			}
		case "sinks":
			if v != nil {
				sinks, err := unmarshalBasicSinkNodeBaseArray(*v)
				if err != nil {
					return err
				}
				ptpu.Sinks = &sinks
			}
		}
	}

	return nil
}

// PipelineTopologyUpdate pipeline topology describes the processing steps to be applied when processing
// content for a particular outcome. The topology should be defined according to the scenario to be
// achieved and can be reused across many pipeline instances which share the same processing
// characteristics. For instance, a pipeline topology which captures content from a RTSP camera and
// archives the content can be reused across many different cameras, as long as the same processing is to
// be applied across all the cameras. Individual instance properties can be defined through the use of
// user-defined parameters, which allow for a topology to be parameterized. This allows  individual
// pipelines refer to different values, such as individual cameras' RTSP endpoints and credentials. Overall
// a topology is composed of the following:
//
// - Parameters: list of user defined parameters that can be references across the topology nodes.
// - Sources: list of one or more data sources nodes such as an RTSP source which allows for content to be
// ingested from cameras.
// - Processors: list of nodes which perform data analysis or transformations.
// - Sinks: list of one or more data sinks which allow for data to be stored or exported to other
// destinations.
type PipelineTopologyUpdate struct {
	// PipelineTopologyPropertiesUpdate - The resource properties.
	*PipelineTopologyPropertiesUpdate `json:"properties,omitempty"`
	// Kind - Topology kind. Possible values include: 'KindLive', 'KindBatch'
	Kind Kind `json:"kind,omitempty"`
	// Sku - Describes the properties of a SKU.
	Sku *Sku `json:"sku,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
	// SystemData - READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for PipelineTopologyUpdate.
func (ptu PipelineTopologyUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ptu.PipelineTopologyPropertiesUpdate != nil {
		objectMap["properties"] = ptu.PipelineTopologyPropertiesUpdate
	}
	if ptu.Kind != "" {
		objectMap["kind"] = ptu.Kind
	}
	if ptu.Sku != nil {
		objectMap["sku"] = ptu.Sku
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PipelineTopologyUpdate struct.
func (ptu *PipelineTopologyUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var pipelineTopologyPropertiesUpdate PipelineTopologyPropertiesUpdate
				err = json.Unmarshal(*v, &pipelineTopologyPropertiesUpdate)
				if err != nil {
					return err
				}
				ptu.PipelineTopologyPropertiesUpdate = &pipelineTopologyPropertiesUpdate
			}
		case "kind":
			if v != nil {
				var kind Kind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ptu.Kind = kind
			}
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				ptu.Sku = &sku
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ptu.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ptu.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ptu.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				ptu.SystemData = &systemData
			}
		}
	}

	return nil
}

// PrivateEndpoint the Private Endpoint resource.
type PrivateEndpoint struct {
	// ID - READ-ONLY; The ARM identifier for Private Endpoint
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateEndpoint.
func (peVar PrivateEndpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// PrivateEndpointConnection the Private Endpoint Connection resource.
type PrivateEndpointConnection struct {
	autorest.Response `json:"-"`
	// PrivateEndpointConnectionProperties - Resource properties.
	*PrivateEndpointConnectionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
	// SystemData - READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateEndpointConnection.
func (pec PrivateEndpointConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pec.PrivateEndpointConnectionProperties != nil {
		objectMap["properties"] = pec.PrivateEndpointConnectionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PrivateEndpointConnection struct.
func (pec *PrivateEndpointConnection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var privateEndpointConnectionProperties PrivateEndpointConnectionProperties
				err = json.Unmarshal(*v, &privateEndpointConnectionProperties)
				if err != nil {
					return err
				}
				pec.PrivateEndpointConnectionProperties = &privateEndpointConnectionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pec.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pec.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pec.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				pec.SystemData = &systemData
			}
		}
	}

	return nil
}

// PrivateEndpointConnectionListResult list of private endpoint connection associated with the specified
// storage account
type PrivateEndpointConnectionListResult struct {
	autorest.Response `json:"-"`
	// Value - Array of private endpoint connections
	Value *[]PrivateEndpointConnection `json:"value,omitempty"`
}

// PrivateEndpointConnectionOperationStatus status of private endpoint connection operation.
type PrivateEndpointConnectionOperationStatus struct {
	autorest.Response `json:"-"`
	// Name - Operation identifier.
	Name *string `json:"name,omitempty"`
	// ID - Operation resource ID.
	ID *string `json:"id,omitempty"`
	// StartTime - Operation start time.
	StartTime *string `json:"startTime,omitempty"`
	// EndTime - Operation end time.
	EndTime *string `json:"endTime,omitempty"`
	// Status - Operation status.
	Status *string      `json:"status,omitempty"`
	Error  *ErrorDetail `json:"error,omitempty"`
}

// PrivateEndpointConnectionProperties properties of the PrivateEndpointConnectProperties.
type PrivateEndpointConnectionProperties struct {
	// PrivateEndpoint - The resource of private end point.
	PrivateEndpoint *PrivateEndpoint `json:"privateEndpoint,omitempty"`
	// PrivateLinkServiceConnectionState - A collection of information about the state of the connection between service consumer and provider.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState `json:"privateLinkServiceConnectionState,omitempty"`
	// ProvisioningState - The provisioning state of the private endpoint connection resource. Possible values include: 'PrivateEndpointConnectionProvisioningStateSucceeded', 'PrivateEndpointConnectionProvisioningStateCreating', 'PrivateEndpointConnectionProvisioningStateDeleting', 'PrivateEndpointConnectionProvisioningStateFailed'
	ProvisioningState PrivateEndpointConnectionProvisioningState `json:"provisioningState,omitempty"`
}

// PrivateLinkResource a private link resource
type PrivateLinkResource struct {
	autorest.Response `json:"-"`
	// PrivateLinkResourceProperties - Resource properties.
	*PrivateLinkResourceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
	// SystemData - READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateLinkResource.
func (plr PrivateLinkResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if plr.PrivateLinkResourceProperties != nil {
		objectMap["properties"] = plr.PrivateLinkResourceProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PrivateLinkResource struct.
func (plr *PrivateLinkResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var privateLinkResourceProperties PrivateLinkResourceProperties
				err = json.Unmarshal(*v, &privateLinkResourceProperties)
				if err != nil {
					return err
				}
				plr.PrivateLinkResourceProperties = &privateLinkResourceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				plr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				plr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				plr.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				plr.SystemData = &systemData
			}
		}
	}

	return nil
}

// PrivateLinkResourceListResult a list of private link resources
type PrivateLinkResourceListResult struct {
	autorest.Response `json:"-"`
	// Value - Array of private link resources
	Value *[]PrivateLinkResource `json:"value,omitempty"`
}

// PrivateLinkResourceProperties properties of a private link resource.
type PrivateLinkResourceProperties struct {
	// GroupID - READ-ONLY; The private link resource group id.
	GroupID *string `json:"groupId,omitempty"`
	// RequiredMembers - READ-ONLY; The private link resource required member names.
	RequiredMembers *[]string `json:"requiredMembers,omitempty"`
	// RequiredZoneNames - The private link resource Private link DNS zone name.
	RequiredZoneNames *[]string `json:"requiredZoneNames,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateLinkResourceProperties.
func (plrp PrivateLinkResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if plrp.RequiredZoneNames != nil {
		objectMap["requiredZoneNames"] = plrp.RequiredZoneNames
	}
	return json.Marshal(objectMap)
}

// PrivateLinkServiceConnectionState a collection of information about the state of the connection between
// service consumer and provider.
type PrivateLinkServiceConnectionState struct {
	// Status - Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service. Possible values include: 'PrivateEndpointServiceConnectionStatusPending', 'PrivateEndpointServiceConnectionStatusApproved', 'PrivateEndpointServiceConnectionStatusRejected'
	Status PrivateEndpointServiceConnectionStatus `json:"status,omitempty"`
	// Description - The reason for approval/rejection of the connection.
	Description *string `json:"description,omitempty"`
	// ActionsRequired - A message indicating if changes on the service provider require any updates on the consumer.
	ActionsRequired *string `json:"actionsRequired,omitempty"`
}

// BasicProcessorNodeBase base class for topology processor nodes.
type BasicProcessorNodeBase interface {
	AsEncoderProcessor() (*EncoderProcessor, bool)
	AsProcessorNodeBase() (*ProcessorNodeBase, bool)
}

// ProcessorNodeBase base class for topology processor nodes.
type ProcessorNodeBase struct {
	// Inputs - An array of upstream node references within the topology to be used as inputs for this node.
	Inputs *[]NodeInput `json:"inputs,omitempty"`
	// Name - Node name. Must be unique within the topology.
	Name *string `json:"name,omitempty"`
	// Type - Possible values include: 'TypeNodeBase', 'TypeMicrosoftVideoAnalyzerSourceNodeBase', 'TypeMicrosoftVideoAnalyzerProcessorNodeBase', 'TypeMicrosoftVideoAnalyzerSinkNodeBase', 'TypeMicrosoftVideoAnalyzerRtspSource', 'TypeMicrosoftVideoAnalyzerVideoSource', 'TypeMicrosoftVideoAnalyzerEncoderProcessor', 'TypeMicrosoftVideoAnalyzerVideoSink'
	Type Type `json:"@type,omitempty"`
}

func unmarshalBasicProcessorNodeBase(body []byte) (BasicProcessorNodeBase, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["@type"] {
	case string(TypeMicrosoftVideoAnalyzerEncoderProcessor):
		var ep EncoderProcessor
		err := json.Unmarshal(body, &ep)
		return ep, err
	default:
		var pnb ProcessorNodeBase
		err := json.Unmarshal(body, &pnb)
		return pnb, err
	}
}
func unmarshalBasicProcessorNodeBaseArray(body []byte) ([]BasicProcessorNodeBase, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	pnbArray := make([]BasicProcessorNodeBase, len(rawMessages))

	for index, rawMessage := range rawMessages {
		pnb, err := unmarshalBasicProcessorNodeBase(*rawMessage)
		if err != nil {
			return nil, err
		}
		pnbArray[index] = pnb
	}
	return pnbArray, nil
}

// MarshalJSON is the custom marshaler for ProcessorNodeBase.
func (pnb ProcessorNodeBase) MarshalJSON() ([]byte, error) {
	pnb.Type = TypeMicrosoftVideoAnalyzerProcessorNodeBase
	objectMap := make(map[string]interface{})
	if pnb.Inputs != nil {
		objectMap["inputs"] = pnb.Inputs
	}
	if pnb.Name != nil {
		objectMap["name"] = pnb.Name
	}
	if pnb.Type != "" {
		objectMap["@type"] = pnb.Type
	}
	return json.Marshal(objectMap)
}

// AsSourceNodeBase is the BasicNodeBase implementation for ProcessorNodeBase.
func (pnb ProcessorNodeBase) AsSourceNodeBase() (*SourceNodeBase, bool) {
	return nil, false
}

// AsBasicSourceNodeBase is the BasicNodeBase implementation for ProcessorNodeBase.
func (pnb ProcessorNodeBase) AsBasicSourceNodeBase() (BasicSourceNodeBase, bool) {
	return nil, false
}

// AsProcessorNodeBase is the BasicNodeBase implementation for ProcessorNodeBase.
func (pnb ProcessorNodeBase) AsProcessorNodeBase() (*ProcessorNodeBase, bool) {
	return &pnb, true
}

// AsBasicProcessorNodeBase is the BasicNodeBase implementation for ProcessorNodeBase.
func (pnb ProcessorNodeBase) AsBasicProcessorNodeBase() (BasicProcessorNodeBase, bool) {
	return &pnb, true
}

// AsSinkNodeBase is the BasicNodeBase implementation for ProcessorNodeBase.
func (pnb ProcessorNodeBase) AsSinkNodeBase() (*SinkNodeBase, bool) {
	return nil, false
}

// AsBasicSinkNodeBase is the BasicNodeBase implementation for ProcessorNodeBase.
func (pnb ProcessorNodeBase) AsBasicSinkNodeBase() (BasicSinkNodeBase, bool) {
	return nil, false
}

// AsRtspSource is the BasicNodeBase implementation for ProcessorNodeBase.
func (pnb ProcessorNodeBase) AsRtspSource() (*RtspSource, bool) {
	return nil, false
}

// AsVideoSource is the BasicNodeBase implementation for ProcessorNodeBase.
func (pnb ProcessorNodeBase) AsVideoSource() (*VideoSource, bool) {
	return nil, false
}

// AsEncoderProcessor is the BasicNodeBase implementation for ProcessorNodeBase.
func (pnb ProcessorNodeBase) AsEncoderProcessor() (*EncoderProcessor, bool) {
	return nil, false
}

// AsVideoSink is the BasicNodeBase implementation for ProcessorNodeBase.
func (pnb ProcessorNodeBase) AsVideoSink() (*VideoSink, bool) {
	return nil, false
}

// AsNodeBase is the BasicNodeBase implementation for ProcessorNodeBase.
func (pnb ProcessorNodeBase) AsNodeBase() (*NodeBase, bool) {
	return nil, false
}

// AsBasicNodeBase is the BasicNodeBase implementation for ProcessorNodeBase.
func (pnb ProcessorNodeBase) AsBasicNodeBase() (BasicNodeBase, bool) {
	return &pnb, true
}

// Properties metric properties.
type Properties struct {
	// ServiceSpecification - READ-ONLY; The service specifications.
	ServiceSpecification *ServiceSpecification `json:"serviceSpecification,omitempty"`
}

// MarshalJSON is the custom marshaler for Properties.
func (p Properties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// PropertiesType the properties of the Video Analyzer account.
type PropertiesType struct {
	// StorageAccounts - The storage accounts for this resource.
	StorageAccounts *[]StorageAccount `json:"storageAccounts,omitempty"`
	// Endpoints - READ-ONLY; The endpoints associated with this resource.
	Endpoints *[]Endpoint `json:"endpoints,omitempty"`
	// Encryption - The account encryption properties.
	Encryption *AccountEncryption `json:"encryption,omitempty"`
	// IotHubs - The IoT Hubs for this resource.
	IotHubs *[]IotHub `json:"iotHubs,omitempty"`
	// PublicNetworkAccess - Whether or not public network access is allowed for resources under the Video Analyzer account. Possible values include: 'PublicNetworkAccessEnabled', 'PublicNetworkAccessDisabled'
	PublicNetworkAccess PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`
	// NetworkAccessControl - Network access control for Video Analyzer.
	NetworkAccessControl *NetworkAccessControl `json:"networkAccessControl,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning state of the Video Analyzer account. Possible values include: 'ProvisioningStateFailed', 'ProvisioningStateInProgress', 'ProvisioningStateSucceeded'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// PrivateEndpointConnections - READ-ONLY; Private Endpoint Connections created under Video Analyzer account.
	PrivateEndpointConnections *[]PrivateEndpointConnection `json:"privateEndpointConnections,omitempty"`
}

// MarshalJSON is the custom marshaler for PropertiesType.
func (pt PropertiesType) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pt.StorageAccounts != nil {
		objectMap["storageAccounts"] = pt.StorageAccounts
	}
	if pt.Encryption != nil {
		objectMap["encryption"] = pt.Encryption
	}
	if pt.IotHubs != nil {
		objectMap["iotHubs"] = pt.IotHubs
	}
	if pt.PublicNetworkAccess != "" {
		objectMap["publicNetworkAccess"] = pt.PublicNetworkAccess
	}
	if pt.NetworkAccessControl != nil {
		objectMap["networkAccessControl"] = pt.NetworkAccessControl
	}
	return json.Marshal(objectMap)
}

// PropertiesUpdate the properties of the Video Analyzer account.
type PropertiesUpdate struct {
	// StorageAccounts - The storage accounts for this resource.
	StorageAccounts *[]StorageAccount `json:"storageAccounts,omitempty"`
	// Endpoints - READ-ONLY; The endpoints associated with this resource.
	Endpoints *[]Endpoint `json:"endpoints,omitempty"`
	// Encryption - The account encryption properties.
	Encryption *AccountEncryption `json:"encryption,omitempty"`
	// IotHubs - The IoT Hubs for this resource.
	IotHubs *[]IotHub `json:"iotHubs,omitempty"`
	// PublicNetworkAccess - Whether or not public network access is allowed for resources under the Video Analyzer account. Possible values include: 'PublicNetworkAccessEnabled', 'PublicNetworkAccessDisabled'
	PublicNetworkAccess PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`
	// NetworkAccessControl - Network access control for Video Analyzer.
	NetworkAccessControl *NetworkAccessControl `json:"networkAccessControl,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning state of the Video Analyzer account. Possible values include: 'ProvisioningStateFailed', 'ProvisioningStateInProgress', 'ProvisioningStateSucceeded'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// PrivateEndpointConnections - READ-ONLY; Private Endpoint Connections created under Video Analyzer account.
	PrivateEndpointConnections *[]PrivateEndpointConnection `json:"privateEndpointConnections,omitempty"`
}

// MarshalJSON is the custom marshaler for PropertiesUpdate.
func (pu PropertiesUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pu.StorageAccounts != nil {
		objectMap["storageAccounts"] = pu.StorageAccounts
	}
	if pu.Encryption != nil {
		objectMap["encryption"] = pu.Encryption
	}
	if pu.IotHubs != nil {
		objectMap["iotHubs"] = pu.IotHubs
	}
	if pu.PublicNetworkAccess != "" {
		objectMap["publicNetworkAccess"] = pu.PublicNetworkAccess
	}
	if pu.NetworkAccessControl != nil {
		objectMap["networkAccessControl"] = pu.NetworkAccessControl
	}
	return json.Marshal(objectMap)
}

// ProxyResource the resource model definition for a Azure Resource Manager proxy resource. It will not
// have tags and a location
type ProxyResource struct {
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
	// SystemData - READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for ProxyResource.
func (pr ProxyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// Resource common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
	// SystemData - READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ResourceIdentity the user assigned managed identity to use when accessing a resource.
type ResourceIdentity struct {
	// UserAssignedIdentity - The user assigned managed identity's resource identifier to use when accessing a resource.
	UserAssignedIdentity *string `json:"userAssignedIdentity,omitempty"`
}

// RsaTokenKey required validation properties for tokens generated with RSA algorithm.
type RsaTokenKey struct {
	// Alg - RSA algorithm to be used: RS256, RS384 or RS512. Possible values include: 'AccessPolicyRsaAlgoRS256', 'AccessPolicyRsaAlgoRS384', 'AccessPolicyRsaAlgoRS512'
	Alg AccessPolicyRsaAlgo `json:"alg,omitempty"`
	// N - RSA public key modulus.
	N *string `json:"n,omitempty"`
	// E - RSA public key exponent.
	E *string `json:"e,omitempty"`
	// Kid - JWT token key id. Validation keys are looked up based on the key id present on the JWT token header.
	Kid *string `json:"kid,omitempty"`
	// Type - Possible values include: 'TypeBasicTokenKeyTypeTokenKey', 'TypeBasicTokenKeyTypeMicrosoftVideoAnalyzerRsaTokenKey', 'TypeBasicTokenKeyTypeMicrosoftVideoAnalyzerEccTokenKey'
	Type TypeBasicTokenKey `json:"@type,omitempty"`
}

// MarshalJSON is the custom marshaler for RsaTokenKey.
func (rtk RsaTokenKey) MarshalJSON() ([]byte, error) {
	rtk.Type = TypeBasicTokenKeyTypeMicrosoftVideoAnalyzerRsaTokenKey
	objectMap := make(map[string]interface{})
	if rtk.Alg != "" {
		objectMap["alg"] = rtk.Alg
	}
	if rtk.N != nil {
		objectMap["n"] = rtk.N
	}
	if rtk.E != nil {
		objectMap["e"] = rtk.E
	}
	if rtk.Kid != nil {
		objectMap["kid"] = rtk.Kid
	}
	if rtk.Type != "" {
		objectMap["@type"] = rtk.Type
	}
	return json.Marshal(objectMap)
}

// AsRsaTokenKey is the BasicTokenKey implementation for RsaTokenKey.
func (rtk RsaTokenKey) AsRsaTokenKey() (*RsaTokenKey, bool) {
	return &rtk, true
}

// AsEccTokenKey is the BasicTokenKey implementation for RsaTokenKey.
func (rtk RsaTokenKey) AsEccTokenKey() (*EccTokenKey, bool) {
	return nil, false
}

// AsTokenKey is the BasicTokenKey implementation for RsaTokenKey.
func (rtk RsaTokenKey) AsTokenKey() (*TokenKey, bool) {
	return nil, false
}

// AsBasicTokenKey is the BasicTokenKey implementation for RsaTokenKey.
func (rtk RsaTokenKey) AsBasicTokenKey() (BasicTokenKey, bool) {
	return &rtk, true
}

// RtspSource RTSP source allows for media from an RTSP camera or generic RTSP server to be ingested into a
// pipeline.
type RtspSource struct {
	// Transport - Network transport utilized by the RTSP and RTP exchange: TCP or HTTP. When using TCP, the RTP packets are interleaved on the TCP RTSP connection. When using HTTP, the RTSP messages are exchanged through long lived HTTP connections, and the RTP packages are interleaved in the HTTP connections alongside the RTSP messages. Possible values include: 'RtspTransportHTTP', 'RtspTransportTCP'
	Transport RtspTransport `json:"transport,omitempty"`
	// Endpoint - RTSP endpoint information for Video Analyzer to connect to. This contains the required information for Video Analyzer to connect to RTSP cameras and/or generic RTSP servers.
	Endpoint BasicEndpointBase `json:"endpoint,omitempty"`
	// Name - Node name. Must be unique within the topology.
	Name *string `json:"name,omitempty"`
	// Type - Possible values include: 'TypeNodeBase', 'TypeMicrosoftVideoAnalyzerSourceNodeBase', 'TypeMicrosoftVideoAnalyzerProcessorNodeBase', 'TypeMicrosoftVideoAnalyzerSinkNodeBase', 'TypeMicrosoftVideoAnalyzerRtspSource', 'TypeMicrosoftVideoAnalyzerVideoSource', 'TypeMicrosoftVideoAnalyzerEncoderProcessor', 'TypeMicrosoftVideoAnalyzerVideoSink'
	Type Type `json:"@type,omitempty"`
}

// MarshalJSON is the custom marshaler for RtspSource.
func (rs RtspSource) MarshalJSON() ([]byte, error) {
	rs.Type = TypeMicrosoftVideoAnalyzerRtspSource
	objectMap := make(map[string]interface{})
	if rs.Transport != "" {
		objectMap["transport"] = rs.Transport
	}
	objectMap["endpoint"] = rs.Endpoint
	if rs.Name != nil {
		objectMap["name"] = rs.Name
	}
	if rs.Type != "" {
		objectMap["@type"] = rs.Type
	}
	return json.Marshal(objectMap)
}

// AsSourceNodeBase is the BasicNodeBase implementation for RtspSource.
func (rs RtspSource) AsSourceNodeBase() (*SourceNodeBase, bool) {
	return nil, false
}

// AsBasicSourceNodeBase is the BasicNodeBase implementation for RtspSource.
func (rs RtspSource) AsBasicSourceNodeBase() (BasicSourceNodeBase, bool) {
	return &rs, true
}

// AsProcessorNodeBase is the BasicNodeBase implementation for RtspSource.
func (rs RtspSource) AsProcessorNodeBase() (*ProcessorNodeBase, bool) {
	return nil, false
}

// AsBasicProcessorNodeBase is the BasicNodeBase implementation for RtspSource.
func (rs RtspSource) AsBasicProcessorNodeBase() (BasicProcessorNodeBase, bool) {
	return nil, false
}

// AsSinkNodeBase is the BasicNodeBase implementation for RtspSource.
func (rs RtspSource) AsSinkNodeBase() (*SinkNodeBase, bool) {
	return nil, false
}

// AsBasicSinkNodeBase is the BasicNodeBase implementation for RtspSource.
func (rs RtspSource) AsBasicSinkNodeBase() (BasicSinkNodeBase, bool) {
	return nil, false
}

// AsRtspSource is the BasicNodeBase implementation for RtspSource.
func (rs RtspSource) AsRtspSource() (*RtspSource, bool) {
	return &rs, true
}

// AsVideoSource is the BasicNodeBase implementation for RtspSource.
func (rs RtspSource) AsVideoSource() (*VideoSource, bool) {
	return nil, false
}

// AsEncoderProcessor is the BasicNodeBase implementation for RtspSource.
func (rs RtspSource) AsEncoderProcessor() (*EncoderProcessor, bool) {
	return nil, false
}

// AsVideoSink is the BasicNodeBase implementation for RtspSource.
func (rs RtspSource) AsVideoSink() (*VideoSink, bool) {
	return nil, false
}

// AsNodeBase is the BasicNodeBase implementation for RtspSource.
func (rs RtspSource) AsNodeBase() (*NodeBase, bool) {
	return nil, false
}

// AsBasicNodeBase is the BasicNodeBase implementation for RtspSource.
func (rs RtspSource) AsBasicNodeBase() (BasicNodeBase, bool) {
	return &rs, true
}

// UnmarshalJSON is the custom unmarshaler for RtspSource struct.
func (rs *RtspSource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "transport":
			if v != nil {
				var transport RtspTransport
				err = json.Unmarshal(*v, &transport)
				if err != nil {
					return err
				}
				rs.Transport = transport
			}
		case "endpoint":
			if v != nil {
				endpoint, err := unmarshalBasicEndpointBase(*v)
				if err != nil {
					return err
				}
				rs.Endpoint = endpoint
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rs.Name = &name
			}
		case "@type":
			if v != nil {
				var typeVar Type
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rs.Type = typeVar
			}
		}
	}

	return nil
}

// SecureIotDeviceRemoteTunnel a remote tunnel securely established using IoT Hub device information.
type SecureIotDeviceRemoteTunnel struct {
	// IotHubName - Name of the IoT Hub.
	IotHubName *string `json:"iotHubName,omitempty"`
	// DeviceID - The IoT device id to use when establishing the remote tunnel. This string is case-sensitive.
	DeviceID *string `json:"deviceId,omitempty"`
	// Type - Possible values include: 'TypeBasicTunnelBaseTypeTunnelBase', 'TypeBasicTunnelBaseTypeMicrosoftVideoAnalyzerSecureIotDeviceRemoteTunnel'
	Type TypeBasicTunnelBase `json:"@type,omitempty"`
}

// MarshalJSON is the custom marshaler for SecureIotDeviceRemoteTunnel.
func (sidrt SecureIotDeviceRemoteTunnel) MarshalJSON() ([]byte, error) {
	sidrt.Type = TypeBasicTunnelBaseTypeMicrosoftVideoAnalyzerSecureIotDeviceRemoteTunnel
	objectMap := make(map[string]interface{})
	if sidrt.IotHubName != nil {
		objectMap["iotHubName"] = sidrt.IotHubName
	}
	if sidrt.DeviceID != nil {
		objectMap["deviceId"] = sidrt.DeviceID
	}
	if sidrt.Type != "" {
		objectMap["@type"] = sidrt.Type
	}
	return json.Marshal(objectMap)
}

// AsSecureIotDeviceRemoteTunnel is the BasicTunnelBase implementation for SecureIotDeviceRemoteTunnel.
func (sidrt SecureIotDeviceRemoteTunnel) AsSecureIotDeviceRemoteTunnel() (*SecureIotDeviceRemoteTunnel, bool) {
	return &sidrt, true
}

// AsTunnelBase is the BasicTunnelBase implementation for SecureIotDeviceRemoteTunnel.
func (sidrt SecureIotDeviceRemoteTunnel) AsTunnelBase() (*TunnelBase, bool) {
	return nil, false
}

// AsBasicTunnelBase is the BasicTunnelBase implementation for SecureIotDeviceRemoteTunnel.
func (sidrt SecureIotDeviceRemoteTunnel) AsBasicTunnelBase() (BasicTunnelBase, bool) {
	return &sidrt, true
}

// ServiceSpecification the service metric specifications.
type ServiceSpecification struct {
	// LogSpecifications - READ-ONLY; List of log specifications.
	LogSpecifications *[]LogSpecification `json:"logSpecifications,omitempty"`
	// MetricSpecifications - READ-ONLY; List of metric specifications.
	MetricSpecifications *[]MetricSpecification `json:"metricSpecifications,omitempty"`
}

// MarshalJSON is the custom marshaler for ServiceSpecification.
func (ss ServiceSpecification) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// BasicSinkNodeBase base class for topology sink nodes.
type BasicSinkNodeBase interface {
	AsVideoSink() (*VideoSink, bool)
	AsSinkNodeBase() (*SinkNodeBase, bool)
}

// SinkNodeBase base class for topology sink nodes.
type SinkNodeBase struct {
	// Inputs - An array of upstream node references within the topology to be used as inputs for this node.
	Inputs *[]NodeInput `json:"inputs,omitempty"`
	// Name - Node name. Must be unique within the topology.
	Name *string `json:"name,omitempty"`
	// Type - Possible values include: 'TypeNodeBase', 'TypeMicrosoftVideoAnalyzerSourceNodeBase', 'TypeMicrosoftVideoAnalyzerProcessorNodeBase', 'TypeMicrosoftVideoAnalyzerSinkNodeBase', 'TypeMicrosoftVideoAnalyzerRtspSource', 'TypeMicrosoftVideoAnalyzerVideoSource', 'TypeMicrosoftVideoAnalyzerEncoderProcessor', 'TypeMicrosoftVideoAnalyzerVideoSink'
	Type Type `json:"@type,omitempty"`
}

func unmarshalBasicSinkNodeBase(body []byte) (BasicSinkNodeBase, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["@type"] {
	case string(TypeMicrosoftVideoAnalyzerVideoSink):
		var vs VideoSink
		err := json.Unmarshal(body, &vs)
		return vs, err
	default:
		var snb SinkNodeBase
		err := json.Unmarshal(body, &snb)
		return snb, err
	}
}
func unmarshalBasicSinkNodeBaseArray(body []byte) ([]BasicSinkNodeBase, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	snbArray := make([]BasicSinkNodeBase, len(rawMessages))

	for index, rawMessage := range rawMessages {
		snb, err := unmarshalBasicSinkNodeBase(*rawMessage)
		if err != nil {
			return nil, err
		}
		snbArray[index] = snb
	}
	return snbArray, nil
}

// MarshalJSON is the custom marshaler for SinkNodeBase.
func (snb SinkNodeBase) MarshalJSON() ([]byte, error) {
	snb.Type = TypeMicrosoftVideoAnalyzerSinkNodeBase
	objectMap := make(map[string]interface{})
	if snb.Inputs != nil {
		objectMap["inputs"] = snb.Inputs
	}
	if snb.Name != nil {
		objectMap["name"] = snb.Name
	}
	if snb.Type != "" {
		objectMap["@type"] = snb.Type
	}
	return json.Marshal(objectMap)
}

// AsSourceNodeBase is the BasicNodeBase implementation for SinkNodeBase.
func (snb SinkNodeBase) AsSourceNodeBase() (*SourceNodeBase, bool) {
	return nil, false
}

// AsBasicSourceNodeBase is the BasicNodeBase implementation for SinkNodeBase.
func (snb SinkNodeBase) AsBasicSourceNodeBase() (BasicSourceNodeBase, bool) {
	return nil, false
}

// AsProcessorNodeBase is the BasicNodeBase implementation for SinkNodeBase.
func (snb SinkNodeBase) AsProcessorNodeBase() (*ProcessorNodeBase, bool) {
	return nil, false
}

// AsBasicProcessorNodeBase is the BasicNodeBase implementation for SinkNodeBase.
func (snb SinkNodeBase) AsBasicProcessorNodeBase() (BasicProcessorNodeBase, bool) {
	return nil, false
}

// AsSinkNodeBase is the BasicNodeBase implementation for SinkNodeBase.
func (snb SinkNodeBase) AsSinkNodeBase() (*SinkNodeBase, bool) {
	return &snb, true
}

// AsBasicSinkNodeBase is the BasicNodeBase implementation for SinkNodeBase.
func (snb SinkNodeBase) AsBasicSinkNodeBase() (BasicSinkNodeBase, bool) {
	return &snb, true
}

// AsRtspSource is the BasicNodeBase implementation for SinkNodeBase.
func (snb SinkNodeBase) AsRtspSource() (*RtspSource, bool) {
	return nil, false
}

// AsVideoSource is the BasicNodeBase implementation for SinkNodeBase.
func (snb SinkNodeBase) AsVideoSource() (*VideoSource, bool) {
	return nil, false
}

// AsEncoderProcessor is the BasicNodeBase implementation for SinkNodeBase.
func (snb SinkNodeBase) AsEncoderProcessor() (*EncoderProcessor, bool) {
	return nil, false
}

// AsVideoSink is the BasicNodeBase implementation for SinkNodeBase.
func (snb SinkNodeBase) AsVideoSink() (*VideoSink, bool) {
	return nil, false
}

// AsNodeBase is the BasicNodeBase implementation for SinkNodeBase.
func (snb SinkNodeBase) AsNodeBase() (*NodeBase, bool) {
	return nil, false
}

// AsBasicNodeBase is the BasicNodeBase implementation for SinkNodeBase.
func (snb SinkNodeBase) AsBasicNodeBase() (BasicNodeBase, bool) {
	return &snb, true
}

// Sku the SKU details.
type Sku struct {
	// Name - The SKU name. Possible values include: 'SkuNameLiveS1', 'SkuNameBatchS1'
	Name SkuName `json:"name,omitempty"`
	// Tier - READ-ONLY; The SKU tier. Possible values include: 'SkuTierStandard'
	Tier SkuTier `json:"tier,omitempty"`
}

// MarshalJSON is the custom marshaler for Sku.
func (s Sku) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if s.Name != "" {
		objectMap["name"] = s.Name
	}
	return json.Marshal(objectMap)
}

// BasicSourceNodeBase base class for topology source nodes.
type BasicSourceNodeBase interface {
	AsRtspSource() (*RtspSource, bool)
	AsVideoSource() (*VideoSource, bool)
	AsSourceNodeBase() (*SourceNodeBase, bool)
}

// SourceNodeBase base class for topology source nodes.
type SourceNodeBase struct {
	// Name - Node name. Must be unique within the topology.
	Name *string `json:"name,omitempty"`
	// Type - Possible values include: 'TypeNodeBase', 'TypeMicrosoftVideoAnalyzerSourceNodeBase', 'TypeMicrosoftVideoAnalyzerProcessorNodeBase', 'TypeMicrosoftVideoAnalyzerSinkNodeBase', 'TypeMicrosoftVideoAnalyzerRtspSource', 'TypeMicrosoftVideoAnalyzerVideoSource', 'TypeMicrosoftVideoAnalyzerEncoderProcessor', 'TypeMicrosoftVideoAnalyzerVideoSink'
	Type Type `json:"@type,omitempty"`
}

func unmarshalBasicSourceNodeBase(body []byte) (BasicSourceNodeBase, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["@type"] {
	case string(TypeMicrosoftVideoAnalyzerRtspSource):
		var rs RtspSource
		err := json.Unmarshal(body, &rs)
		return rs, err
	case string(TypeMicrosoftVideoAnalyzerVideoSource):
		var vs VideoSource
		err := json.Unmarshal(body, &vs)
		return vs, err
	default:
		var snb SourceNodeBase
		err := json.Unmarshal(body, &snb)
		return snb, err
	}
}
func unmarshalBasicSourceNodeBaseArray(body []byte) ([]BasicSourceNodeBase, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	snbArray := make([]BasicSourceNodeBase, len(rawMessages))

	for index, rawMessage := range rawMessages {
		snb, err := unmarshalBasicSourceNodeBase(*rawMessage)
		if err != nil {
			return nil, err
		}
		snbArray[index] = snb
	}
	return snbArray, nil
}

// MarshalJSON is the custom marshaler for SourceNodeBase.
func (snb SourceNodeBase) MarshalJSON() ([]byte, error) {
	snb.Type = TypeMicrosoftVideoAnalyzerSourceNodeBase
	objectMap := make(map[string]interface{})
	if snb.Name != nil {
		objectMap["name"] = snb.Name
	}
	if snb.Type != "" {
		objectMap["@type"] = snb.Type
	}
	return json.Marshal(objectMap)
}

// AsSourceNodeBase is the BasicNodeBase implementation for SourceNodeBase.
func (snb SourceNodeBase) AsSourceNodeBase() (*SourceNodeBase, bool) {
	return &snb, true
}

// AsBasicSourceNodeBase is the BasicNodeBase implementation for SourceNodeBase.
func (snb SourceNodeBase) AsBasicSourceNodeBase() (BasicSourceNodeBase, bool) {
	return &snb, true
}

// AsProcessorNodeBase is the BasicNodeBase implementation for SourceNodeBase.
func (snb SourceNodeBase) AsProcessorNodeBase() (*ProcessorNodeBase, bool) {
	return nil, false
}

// AsBasicProcessorNodeBase is the BasicNodeBase implementation for SourceNodeBase.
func (snb SourceNodeBase) AsBasicProcessorNodeBase() (BasicProcessorNodeBase, bool) {
	return nil, false
}

// AsSinkNodeBase is the BasicNodeBase implementation for SourceNodeBase.
func (snb SourceNodeBase) AsSinkNodeBase() (*SinkNodeBase, bool) {
	return nil, false
}

// AsBasicSinkNodeBase is the BasicNodeBase implementation for SourceNodeBase.
func (snb SourceNodeBase) AsBasicSinkNodeBase() (BasicSinkNodeBase, bool) {
	return nil, false
}

// AsRtspSource is the BasicNodeBase implementation for SourceNodeBase.
func (snb SourceNodeBase) AsRtspSource() (*RtspSource, bool) {
	return nil, false
}

// AsVideoSource is the BasicNodeBase implementation for SourceNodeBase.
func (snb SourceNodeBase) AsVideoSource() (*VideoSource, bool) {
	return nil, false
}

// AsEncoderProcessor is the BasicNodeBase implementation for SourceNodeBase.
func (snb SourceNodeBase) AsEncoderProcessor() (*EncoderProcessor, bool) {
	return nil, false
}

// AsVideoSink is the BasicNodeBase implementation for SourceNodeBase.
func (snb SourceNodeBase) AsVideoSink() (*VideoSink, bool) {
	return nil, false
}

// AsNodeBase is the BasicNodeBase implementation for SourceNodeBase.
func (snb SourceNodeBase) AsNodeBase() (*NodeBase, bool) {
	return nil, false
}

// AsBasicNodeBase is the BasicNodeBase implementation for SourceNodeBase.
func (snb SourceNodeBase) AsBasicNodeBase() (BasicNodeBase, bool) {
	return &snb, true
}

// StorageAccount the details about the associated storage account.
type StorageAccount struct {
	// ID - The ID of the storage account resource. Video Analyzer relies on tables, queues, and blobs. The primary storage account must be a Standard Storage account (either Microsoft.ClassicStorage or Microsoft.Storage).
	ID *string `json:"id,omitempty"`
	// Identity - A managed identity that Video Analyzer will use to access the storage account.
	Identity *ResourceIdentity `json:"identity,omitempty"`
	// Status - READ-ONLY; The current status of the storage account mapping.
	Status *string `json:"status,omitempty"`
}

// MarshalJSON is the custom marshaler for StorageAccount.
func (sa StorageAccount) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sa.ID != nil {
		objectMap["id"] = sa.ID
	}
	if sa.Identity != nil {
		objectMap["identity"] = sa.Identity
	}
	return json.Marshal(objectMap)
}

// SystemData metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// CreatedBy - The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`
	// CreatedByType - The type of identity that created the resource. Possible values include: 'CreatedByTypeUser', 'CreatedByTypeApplication', 'CreatedByTypeManagedIdentity', 'CreatedByTypeKey'
	CreatedByType CreatedByType `json:"createdByType,omitempty"`
	// CreatedAt - The timestamp of resource creation (UTC).
	CreatedAt *date.Time `json:"createdAt,omitempty"`
	// LastModifiedBy - The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`
	// LastModifiedByType - The type of identity that last modified the resource. Possible values include: 'CreatedByTypeUser', 'CreatedByTypeApplication', 'CreatedByTypeManagedIdentity', 'CreatedByTypeKey'
	LastModifiedByType CreatedByType `json:"lastModifiedByType,omitempty"`
	// LastModifiedAt - The timestamp of resource last modification (UTC)
	LastModifiedAt *date.Time `json:"lastModifiedAt,omitempty"`
}

// BasicTimeSequenceBase a sequence of datetime ranges as a string.
type BasicTimeSequenceBase interface {
	AsVideoSequenceAbsoluteTimeMarkers() (*VideoSequenceAbsoluteTimeMarkers, bool)
	AsTimeSequenceBase() (*TimeSequenceBase, bool)
}

// TimeSequenceBase a sequence of datetime ranges as a string.
type TimeSequenceBase struct {
	// Type - Possible values include: 'TypeBasicTimeSequenceBaseTypeTimeSequenceBase', 'TypeBasicTimeSequenceBaseTypeMicrosoftVideoAnalyzerVideoSequenceAbsoluteTimeMarkers'
	Type TypeBasicTimeSequenceBase `json:"@type,omitempty"`
}

func unmarshalBasicTimeSequenceBase(body []byte) (BasicTimeSequenceBase, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["@type"] {
	case string(TypeBasicTimeSequenceBaseTypeMicrosoftVideoAnalyzerVideoSequenceAbsoluteTimeMarkers):
		var vsatm VideoSequenceAbsoluteTimeMarkers
		err := json.Unmarshal(body, &vsatm)
		return vsatm, err
	default:
		var tsb TimeSequenceBase
		err := json.Unmarshal(body, &tsb)
		return tsb, err
	}
}
func unmarshalBasicTimeSequenceBaseArray(body []byte) ([]BasicTimeSequenceBase, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	tsbArray := make([]BasicTimeSequenceBase, len(rawMessages))

	for index, rawMessage := range rawMessages {
		tsb, err := unmarshalBasicTimeSequenceBase(*rawMessage)
		if err != nil {
			return nil, err
		}
		tsbArray[index] = tsb
	}
	return tsbArray, nil
}

// MarshalJSON is the custom marshaler for TimeSequenceBase.
func (tsb TimeSequenceBase) MarshalJSON() ([]byte, error) {
	tsb.Type = TypeBasicTimeSequenceBaseTypeTimeSequenceBase
	objectMap := make(map[string]interface{})
	if tsb.Type != "" {
		objectMap["@type"] = tsb.Type
	}
	return json.Marshal(objectMap)
}

// AsVideoSequenceAbsoluteTimeMarkers is the BasicTimeSequenceBase implementation for TimeSequenceBase.
func (tsb TimeSequenceBase) AsVideoSequenceAbsoluteTimeMarkers() (*VideoSequenceAbsoluteTimeMarkers, bool) {
	return nil, false
}

// AsTimeSequenceBase is the BasicTimeSequenceBase implementation for TimeSequenceBase.
func (tsb TimeSequenceBase) AsTimeSequenceBase() (*TimeSequenceBase, bool) {
	return &tsb, true
}

// AsBasicTimeSequenceBase is the BasicTimeSequenceBase implementation for TimeSequenceBase.
func (tsb TimeSequenceBase) AsBasicTimeSequenceBase() (BasicTimeSequenceBase, bool) {
	return &tsb, true
}

// TLSEndpoint TLS endpoint describes an endpoint that the pipeline can connect to over TLS transport (data
// is encrypted in transit).
type TLSEndpoint struct {
	// TrustedCertificates - List of trusted certificate authorities when authenticating a TLS connection. A null list designates that Azure Video Analyzer's list of trusted authorities should be used.
	TrustedCertificates BasicCertificateSource `json:"trustedCertificates,omitempty"`
	// ValidationOptions - Validation options to use when authenticating a TLS connection. By default, strict validation is used.
	ValidationOptions *TLSValidationOptions `json:"validationOptions,omitempty"`
	// Credentials - Credentials to be presented to the endpoint.
	Credentials BasicCredentialsBase `json:"credentials,omitempty"`
	// URL - The endpoint URL for Video Analyzer to connect to.
	URL *string `json:"url,omitempty"`
	// Tunnel - Describes the tunnel through which Video Analyzer can connect to the endpoint URL. This is an optional property, typically used when the endpoint is behind a firewall.
	Tunnel BasicTunnelBase `json:"tunnel,omitempty"`
	// Type - Possible values include: 'TypeBasicEndpointBaseTypeEndpointBase', 'TypeBasicEndpointBaseTypeMicrosoftVideoAnalyzerUnsecuredEndpoint', 'TypeBasicEndpointBaseTypeMicrosoftVideoAnalyzerTLSEndpoint'
	Type TypeBasicEndpointBase `json:"@type,omitempty"`
}

// MarshalJSON is the custom marshaler for TLSEndpoint.
func (te TLSEndpoint) MarshalJSON() ([]byte, error) {
	te.Type = TypeBasicEndpointBaseTypeMicrosoftVideoAnalyzerTLSEndpoint
	objectMap := make(map[string]interface{})
	objectMap["trustedCertificates"] = te.TrustedCertificates
	if te.ValidationOptions != nil {
		objectMap["validationOptions"] = te.ValidationOptions
	}
	objectMap["credentials"] = te.Credentials
	if te.URL != nil {
		objectMap["url"] = te.URL
	}
	objectMap["tunnel"] = te.Tunnel
	if te.Type != "" {
		objectMap["@type"] = te.Type
	}
	return json.Marshal(objectMap)
}

// AsUnsecuredEndpoint is the BasicEndpointBase implementation for TLSEndpoint.
func (te TLSEndpoint) AsUnsecuredEndpoint() (*UnsecuredEndpoint, bool) {
	return nil, false
}

// AsTLSEndpoint is the BasicEndpointBase implementation for TLSEndpoint.
func (te TLSEndpoint) AsTLSEndpoint() (*TLSEndpoint, bool) {
	return &te, true
}

// AsEndpointBase is the BasicEndpointBase implementation for TLSEndpoint.
func (te TLSEndpoint) AsEndpointBase() (*EndpointBase, bool) {
	return nil, false
}

// AsBasicEndpointBase is the BasicEndpointBase implementation for TLSEndpoint.
func (te TLSEndpoint) AsBasicEndpointBase() (BasicEndpointBase, bool) {
	return &te, true
}

// UnmarshalJSON is the custom unmarshaler for TLSEndpoint struct.
func (te *TLSEndpoint) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "trustedCertificates":
			if v != nil {
				trustedCertificates, err := unmarshalBasicCertificateSource(*v)
				if err != nil {
					return err
				}
				te.TrustedCertificates = trustedCertificates
			}
		case "validationOptions":
			if v != nil {
				var validationOptions TLSValidationOptions
				err = json.Unmarshal(*v, &validationOptions)
				if err != nil {
					return err
				}
				te.ValidationOptions = &validationOptions
			}
		case "credentials":
			if v != nil {
				credentials, err := unmarshalBasicCredentialsBase(*v)
				if err != nil {
					return err
				}
				te.Credentials = credentials
			}
		case "url":
			if v != nil {
				var URL string
				err = json.Unmarshal(*v, &URL)
				if err != nil {
					return err
				}
				te.URL = &URL
			}
		case "tunnel":
			if v != nil {
				tunnel, err := unmarshalBasicTunnelBase(*v)
				if err != nil {
					return err
				}
				te.Tunnel = tunnel
			}
		case "@type":
			if v != nil {
				var typeVar TypeBasicEndpointBase
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				te.Type = typeVar
			}
		}
	}

	return nil
}

// TLSValidationOptions options for controlling the validation of TLS endpoints.
type TLSValidationOptions struct {
	// IgnoreHostname - When set to 'true' causes the certificate subject name validation to be skipped. Default is 'false'.
	IgnoreHostname *string `json:"ignoreHostname,omitempty"`
	// IgnoreSignature - When set to 'true' causes the certificate chain trust validation to be skipped. Default is 'false'.
	IgnoreSignature *string `json:"ignoreSignature,omitempty"`
}

// TokenClaim properties for expected token claims.
type TokenClaim struct {
	// Name - Name of the claim which must be present on the token.
	Name *string `json:"name,omitempty"`
	// Value - Expected value of the claim to be present on the token.
	Value *string `json:"value,omitempty"`
}

// BasicTokenKey key properties for JWT token validation.
type BasicTokenKey interface {
	AsRsaTokenKey() (*RsaTokenKey, bool)
	AsEccTokenKey() (*EccTokenKey, bool)
	AsTokenKey() (*TokenKey, bool)
}

// TokenKey key properties for JWT token validation.
type TokenKey struct {
	// Kid - JWT token key id. Validation keys are looked up based on the key id present on the JWT token header.
	Kid *string `json:"kid,omitempty"`
	// Type - Possible values include: 'TypeBasicTokenKeyTypeTokenKey', 'TypeBasicTokenKeyTypeMicrosoftVideoAnalyzerRsaTokenKey', 'TypeBasicTokenKeyTypeMicrosoftVideoAnalyzerEccTokenKey'
	Type TypeBasicTokenKey `json:"@type,omitempty"`
}

func unmarshalBasicTokenKey(body []byte) (BasicTokenKey, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["@type"] {
	case string(TypeBasicTokenKeyTypeMicrosoftVideoAnalyzerRsaTokenKey):
		var rtk RsaTokenKey
		err := json.Unmarshal(body, &rtk)
		return rtk, err
	case string(TypeBasicTokenKeyTypeMicrosoftVideoAnalyzerEccTokenKey):
		var etk EccTokenKey
		err := json.Unmarshal(body, &etk)
		return etk, err
	default:
		var tk TokenKey
		err := json.Unmarshal(body, &tk)
		return tk, err
	}
}
func unmarshalBasicTokenKeyArray(body []byte) ([]BasicTokenKey, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	tkArray := make([]BasicTokenKey, len(rawMessages))

	for index, rawMessage := range rawMessages {
		tk, err := unmarshalBasicTokenKey(*rawMessage)
		if err != nil {
			return nil, err
		}
		tkArray[index] = tk
	}
	return tkArray, nil
}

// MarshalJSON is the custom marshaler for TokenKey.
func (tk TokenKey) MarshalJSON() ([]byte, error) {
	tk.Type = TypeBasicTokenKeyTypeTokenKey
	objectMap := make(map[string]interface{})
	if tk.Kid != nil {
		objectMap["kid"] = tk.Kid
	}
	if tk.Type != "" {
		objectMap["@type"] = tk.Type
	}
	return json.Marshal(objectMap)
}

// AsRsaTokenKey is the BasicTokenKey implementation for TokenKey.
func (tk TokenKey) AsRsaTokenKey() (*RsaTokenKey, bool) {
	return nil, false
}

// AsEccTokenKey is the BasicTokenKey implementation for TokenKey.
func (tk TokenKey) AsEccTokenKey() (*EccTokenKey, bool) {
	return nil, false
}

// AsTokenKey is the BasicTokenKey implementation for TokenKey.
func (tk TokenKey) AsTokenKey() (*TokenKey, bool) {
	return &tk, true
}

// AsBasicTokenKey is the BasicTokenKey implementation for TokenKey.
func (tk TokenKey) AsBasicTokenKey() (BasicTokenKey, bool) {
	return &tk, true
}

// TrackedResource the resource model definition for an Azure Resource Manager tracked top level resource
// which has 'tags' and a 'location'
type TrackedResource struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
	// SystemData - READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	return json.Marshal(objectMap)
}

// BasicTunnelBase base class for tunnel objects.
type BasicTunnelBase interface {
	AsSecureIotDeviceRemoteTunnel() (*SecureIotDeviceRemoteTunnel, bool)
	AsTunnelBase() (*TunnelBase, bool)
}

// TunnelBase base class for tunnel objects.
type TunnelBase struct {
	// Type - Possible values include: 'TypeBasicTunnelBaseTypeTunnelBase', 'TypeBasicTunnelBaseTypeMicrosoftVideoAnalyzerSecureIotDeviceRemoteTunnel'
	Type TypeBasicTunnelBase `json:"@type,omitempty"`
}

func unmarshalBasicTunnelBase(body []byte) (BasicTunnelBase, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["@type"] {
	case string(TypeBasicTunnelBaseTypeMicrosoftVideoAnalyzerSecureIotDeviceRemoteTunnel):
		var sidrt SecureIotDeviceRemoteTunnel
		err := json.Unmarshal(body, &sidrt)
		return sidrt, err
	default:
		var tb TunnelBase
		err := json.Unmarshal(body, &tb)
		return tb, err
	}
}
func unmarshalBasicTunnelBaseArray(body []byte) ([]BasicTunnelBase, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	tbArray := make([]BasicTunnelBase, len(rawMessages))

	for index, rawMessage := range rawMessages {
		tb, err := unmarshalBasicTunnelBase(*rawMessage)
		if err != nil {
			return nil, err
		}
		tbArray[index] = tb
	}
	return tbArray, nil
}

// MarshalJSON is the custom marshaler for TunnelBase.
func (tb TunnelBase) MarshalJSON() ([]byte, error) {
	tb.Type = TypeBasicTunnelBaseTypeTunnelBase
	objectMap := make(map[string]interface{})
	if tb.Type != "" {
		objectMap["@type"] = tb.Type
	}
	return json.Marshal(objectMap)
}

// AsSecureIotDeviceRemoteTunnel is the BasicTunnelBase implementation for TunnelBase.
func (tb TunnelBase) AsSecureIotDeviceRemoteTunnel() (*SecureIotDeviceRemoteTunnel, bool) {
	return nil, false
}

// AsTunnelBase is the BasicTunnelBase implementation for TunnelBase.
func (tb TunnelBase) AsTunnelBase() (*TunnelBase, bool) {
	return &tb, true
}

// AsBasicTunnelBase is the BasicTunnelBase implementation for TunnelBase.
func (tb TunnelBase) AsBasicTunnelBase() (BasicTunnelBase, bool) {
	return &tb, true
}

// UnsecuredEndpoint unsecured endpoint describes an endpoint that the pipeline can connect to over clear
// transport (no encryption in transit).
type UnsecuredEndpoint struct {
	// Credentials - Credentials to be presented to the endpoint.
	Credentials BasicCredentialsBase `json:"credentials,omitempty"`
	// URL - The endpoint URL for Video Analyzer to connect to.
	URL *string `json:"url,omitempty"`
	// Tunnel - Describes the tunnel through which Video Analyzer can connect to the endpoint URL. This is an optional property, typically used when the endpoint is behind a firewall.
	Tunnel BasicTunnelBase `json:"tunnel,omitempty"`
	// Type - Possible values include: 'TypeBasicEndpointBaseTypeEndpointBase', 'TypeBasicEndpointBaseTypeMicrosoftVideoAnalyzerUnsecuredEndpoint', 'TypeBasicEndpointBaseTypeMicrosoftVideoAnalyzerTLSEndpoint'
	Type TypeBasicEndpointBase `json:"@type,omitempty"`
}

// MarshalJSON is the custom marshaler for UnsecuredEndpoint.
func (ue UnsecuredEndpoint) MarshalJSON() ([]byte, error) {
	ue.Type = TypeBasicEndpointBaseTypeMicrosoftVideoAnalyzerUnsecuredEndpoint
	objectMap := make(map[string]interface{})
	objectMap["credentials"] = ue.Credentials
	if ue.URL != nil {
		objectMap["url"] = ue.URL
	}
	objectMap["tunnel"] = ue.Tunnel
	if ue.Type != "" {
		objectMap["@type"] = ue.Type
	}
	return json.Marshal(objectMap)
}

// AsUnsecuredEndpoint is the BasicEndpointBase implementation for UnsecuredEndpoint.
func (ue UnsecuredEndpoint) AsUnsecuredEndpoint() (*UnsecuredEndpoint, bool) {
	return &ue, true
}

// AsTLSEndpoint is the BasicEndpointBase implementation for UnsecuredEndpoint.
func (ue UnsecuredEndpoint) AsTLSEndpoint() (*TLSEndpoint, bool) {
	return nil, false
}

// AsEndpointBase is the BasicEndpointBase implementation for UnsecuredEndpoint.
func (ue UnsecuredEndpoint) AsEndpointBase() (*EndpointBase, bool) {
	return nil, false
}

// AsBasicEndpointBase is the BasicEndpointBase implementation for UnsecuredEndpoint.
func (ue UnsecuredEndpoint) AsBasicEndpointBase() (BasicEndpointBase, bool) {
	return &ue, true
}

// UnmarshalJSON is the custom unmarshaler for UnsecuredEndpoint struct.
func (ue *UnsecuredEndpoint) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "credentials":
			if v != nil {
				credentials, err := unmarshalBasicCredentialsBase(*v)
				if err != nil {
					return err
				}
				ue.Credentials = credentials
			}
		case "url":
			if v != nil {
				var URL string
				err = json.Unmarshal(*v, &URL)
				if err != nil {
					return err
				}
				ue.URL = &URL
			}
		case "tunnel":
			if v != nil {
				tunnel, err := unmarshalBasicTunnelBase(*v)
				if err != nil {
					return err
				}
				ue.Tunnel = tunnel
			}
		case "@type":
			if v != nil {
				var typeVar TypeBasicEndpointBase
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ue.Type = typeVar
			}
		}
	}

	return nil
}

// Update the update operation for a Video Analyzer account.
type Update struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// PropertiesUpdate - The resource properties.
	*PropertiesUpdate `json:"properties,omitempty"`
	// Identity - The identities associated to the Video Analyzer resource.
	Identity *Identity `json:"identity,omitempty"`
}

// MarshalJSON is the custom marshaler for Update.
func (u Update) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if u.Tags != nil {
		objectMap["tags"] = u.Tags
	}
	if u.PropertiesUpdate != nil {
		objectMap["properties"] = u.PropertiesUpdate
	}
	if u.Identity != nil {
		objectMap["identity"] = u.Identity
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Update struct.
func (u *Update) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				u.Tags = tags
			}
		case "properties":
			if v != nil {
				var propertiesUpdate PropertiesUpdate
				err = json.Unmarshal(*v, &propertiesUpdate)
				if err != nil {
					return err
				}
				u.PropertiesUpdate = &propertiesUpdate
			}
		case "identity":
			if v != nil {
				var identity Identity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				u.Identity = &identity
			}
		}
	}

	return nil
}

// UserAssignedManagedIdentity the details of the user assigned managed identity used by the Video Analyzer
// resource.
type UserAssignedManagedIdentity struct {
	// ClientID - READ-ONLY; The client ID.
	ClientID *uuid.UUID `json:"clientId,omitempty"`
	// PrincipalID - READ-ONLY; The principal ID.
	PrincipalID *uuid.UUID `json:"principalId,omitempty"`
}

// MarshalJSON is the custom marshaler for UserAssignedManagedIdentity.
func (uami UserAssignedManagedIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// UsernamePasswordCredentials username and password credentials.
type UsernamePasswordCredentials struct {
	// Username - Username to be presented as part of the credentials.
	Username *string `json:"username,omitempty"`
	// Password - Password to be presented as part of the credentials. It is recommended that this value is parameterized as a secret string in order to prevent this value to be returned as part of the resource on API requests.
	Password *string `json:"password,omitempty"`
	// Type - Possible values include: 'TypeBasicCredentialsBaseTypeCredentialsBase', 'TypeBasicCredentialsBaseTypeMicrosoftVideoAnalyzerUsernamePasswordCredentials'
	Type TypeBasicCredentialsBase `json:"@type,omitempty"`
}

// MarshalJSON is the custom marshaler for UsernamePasswordCredentials.
func (upc UsernamePasswordCredentials) MarshalJSON() ([]byte, error) {
	upc.Type = TypeBasicCredentialsBaseTypeMicrosoftVideoAnalyzerUsernamePasswordCredentials
	objectMap := make(map[string]interface{})
	if upc.Username != nil {
		objectMap["username"] = upc.Username
	}
	if upc.Password != nil {
		objectMap["password"] = upc.Password
	}
	if upc.Type != "" {
		objectMap["@type"] = upc.Type
	}
	return json.Marshal(objectMap)
}

// AsUsernamePasswordCredentials is the BasicCredentialsBase implementation for UsernamePasswordCredentials.
func (upc UsernamePasswordCredentials) AsUsernamePasswordCredentials() (*UsernamePasswordCredentials, bool) {
	return &upc, true
}

// AsCredentialsBase is the BasicCredentialsBase implementation for UsernamePasswordCredentials.
func (upc UsernamePasswordCredentials) AsCredentialsBase() (*CredentialsBase, bool) {
	return nil, false
}

// AsBasicCredentialsBase is the BasicCredentialsBase implementation for UsernamePasswordCredentials.
func (upc UsernamePasswordCredentials) AsBasicCredentialsBase() (BasicCredentialsBase, bool) {
	return &upc, true
}

// VideoAnalyzersCreateOrUpdateFutureType an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VideoAnalyzersCreateOrUpdateFutureType struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VideoAnalyzersClient) (Model, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VideoAnalyzersCreateOrUpdateFutureType) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VideoAnalyzersCreateOrUpdateFutureType.Result.
func (future *VideoAnalyzersCreateOrUpdateFutureType) result(client VideoAnalyzersClient) (mVar Model, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "videoanalyzer.VideoAnalyzersCreateOrUpdateFutureType", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		mVar.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("videoanalyzer.VideoAnalyzersCreateOrUpdateFutureType")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if mVar.Response.Response, err = future.GetResult(sender); err == nil && mVar.Response.Response.StatusCode != http.StatusNoContent {
		mVar, err = client.CreateOrUpdateResponder(mVar.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "videoanalyzer.VideoAnalyzersCreateOrUpdateFutureType", "Result", mVar.Response.Response, "Failure responding to request")
		}
	}
	return
}

// VideoAnalyzersUpdateFutureType an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VideoAnalyzersUpdateFutureType struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VideoAnalyzersClient) (Model, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VideoAnalyzersUpdateFutureType) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VideoAnalyzersUpdateFutureType.Result.
func (future *VideoAnalyzersUpdateFutureType) result(client VideoAnalyzersClient) (mVar Model, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "videoanalyzer.VideoAnalyzersUpdateFutureType", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		mVar.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("videoanalyzer.VideoAnalyzersUpdateFutureType")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if mVar.Response.Response, err = future.GetResult(sender); err == nil && mVar.Response.Response.StatusCode != http.StatusNoContent {
		mVar, err = client.UpdateResponder(mVar.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "videoanalyzer.VideoAnalyzersUpdateFutureType", "Result", mVar.Response.Response, "Failure responding to request")
		}
	}
	return
}

// VideoArchival video archival properties.
type VideoArchival struct {
	// RetentionPeriod - Video retention period indicates the maximum age of the video archive segments which are intended to be kept in storage. It must be provided in the ISO8601 duration format in the granularity of days, up to a maximum of 10 years. For example, if this is set to P30D (30 days), content older than 30 days will be periodically deleted. This value can be updated at any time and the new desired retention period will be effective within 24 hours.
	RetentionPeriod *string `json:"retentionPeriod,omitempty"`
}

// VideoContentToken "Video content token grants access to the video content URLs."
type VideoContentToken struct {
	autorest.Response `json:"-"`
	// ExpirationDate - READ-ONLY; The content token expiration date in ISO8601 format (eg. 2021-01-01T00:00:00Z).
	ExpirationDate *date.Time `json:"expirationDate,omitempty"`
	// Token - READ-ONLY; The content token value to be added to the video content URL as the value for the "token" query string parameter. The token is specific to a single video.
	Token *string `json:"token,omitempty"`
}

// MarshalJSON is the custom marshaler for VideoContentToken.
func (vct VideoContentToken) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// VideoContentUrls set of URLs to the video content.
type VideoContentUrls struct {
	// DownloadURL - Video file download URL. This URL can be used in conjunction with the video content authorization token to download the video MP4 file. The resulting MP4 file can be played on any standard media player. It is available when the video type is 'file' and video file is available for consumption.
	DownloadURL *string `json:"downloadUrl,omitempty"`
	// ArchiveBaseURL - Video archive streaming base URL. The archived content can be automatically played by the Azure Video Analyzer player widget. Alternatively, this URL can be used in conjunction with the video content authorization token on any compatible DASH or HLS players by appending the following to the base URL:
	//
	//     - HLSv4:     /manifest(format=m3u8-aapl).m3u8
	//     - HLS CMAF:  /manifest(format=m3u8-cmaf)
	//     - DASH CMAF: /manifest(format=mpd-time-cmaf)
	//
	//     Moreover, an ongoing video recording can be played in "live mode" with latencies which are approximately double of the chosen video segment length. It is available when the video type is 'archive' and video archiving is enabled.
	ArchiveBaseURL *string `json:"archiveBaseUrl,omitempty"`
	// RtspTunnelURL - Video low-latency streaming URL. The live content can be automatically played by the Azure Video Analyzer player widget. Alternatively, this URL can be used in conjunction with the video content authorization token to expose a WebSocket tunneled RTSP stream. It is available when the video type is 'archive' and a live, low-latency feed is available from the source.
	RtspTunnelURL *string `json:"rtspTunnelUrl,omitempty"`
	// PreviewImageUrls - Video preview image URLs. These URLs can be used in conjunction with the video content authorization token to download the most recent still image from the video archive in different resolutions. They are available when the video type is 'archive' and preview images are enabled.
	PreviewImageUrls *VideoPreviewImageUrls `json:"previewImageUrls,omitempty"`
}

// VideoCreationProperties optional properties to be used in case a new video resource needs to be created
// on the service. These will not take effect if the video already exists.
type VideoCreationProperties struct {
	// Title - Optional title provided by the user. Value can be up to 256 characters long.
	Title *string `json:"title,omitempty"`
	// Description - Optional description provided by the user. Value can be up to 2048 characters long.
	Description *string `json:"description,omitempty"`
	// SegmentLength - Segment length indicates the length of individual content files (segments) which are persisted to storage. Smaller segments provide lower archive playback latency but generate larger volume of storage transactions. Larger segments reduce the amount of storage transactions while increasing the archive playback latency. Value must be specified in ISO8601 duration format (i.e. "PT30S" equals 30 seconds) and can vary between 30 seconds to 5 minutes, in 30 seconds increments. Changing this value after the initial call to create the video resource can lead to errors when uploading content to the archive. Default value is 30 seconds. This property is only allowed for topologies where "kind" is set to "live".
	SegmentLength *string `json:"segmentLength,omitempty"`
	// RetentionPeriod - Video retention period indicates how long the video is kept in storage. Value must be specified in ISO8601 duration format (i.e. "PT1D" equals 1 day) and can vary between 1 day to 10 years, in 1 day increments. When absent (null), all video content is retained indefinitely. This property is only allowed for topologies where "kind" is set to "live".
	RetentionPeriod *string `json:"retentionPeriod,omitempty"`
}

// BasicVideoEncoderBase base type for all video encoding presets, which define the recipe or instructions on how the
// input video should be processed.
type BasicVideoEncoderBase interface {
	AsVideoEncoderH264() (*VideoEncoderH264, bool)
	AsVideoEncoderBase() (*VideoEncoderBase, bool)
}

// VideoEncoderBase base type for all video encoding presets, which define the recipe or instructions on how
// the input video should be processed.
type VideoEncoderBase struct {
	// BitrateKbps - The maximum bitrate, in kilobits per second or Kbps, at which video should be encoded. If omitted, encoder sets it automatically to try and match the quality of the input video.
	BitrateKbps *string `json:"bitrateKbps,omitempty"`
	// FrameRate - The frame rate (in frames per second) of the encoded video. The value must be greater than zero, and less than or equal to 300. If omitted, the encoder uses the average frame rate of the input video.
	FrameRate *string `json:"frameRate,omitempty"`
	// Scale - Describes the resolution of the encoded video. If omitted, the encoder uses the resolution of the input video.
	Scale *VideoScale `json:"scale,omitempty"`
	// Type - Possible values include: 'TypeBasicVideoEncoderBaseTypeVideoEncoderBase', 'TypeBasicVideoEncoderBaseTypeMicrosoftVideoAnalyzerVideoEncoderH264'
	Type TypeBasicVideoEncoderBase `json:"@type,omitempty"`
}

func unmarshalBasicVideoEncoderBase(body []byte) (BasicVideoEncoderBase, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["@type"] {
	case string(TypeBasicVideoEncoderBaseTypeMicrosoftVideoAnalyzerVideoEncoderH264):
		var veh VideoEncoderH264
		err := json.Unmarshal(body, &veh)
		return veh, err
	default:
		var veb VideoEncoderBase
		err := json.Unmarshal(body, &veb)
		return veb, err
	}
}
func unmarshalBasicVideoEncoderBaseArray(body []byte) ([]BasicVideoEncoderBase, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	vebArray := make([]BasicVideoEncoderBase, len(rawMessages))

	for index, rawMessage := range rawMessages {
		veb, err := unmarshalBasicVideoEncoderBase(*rawMessage)
		if err != nil {
			return nil, err
		}
		vebArray[index] = veb
	}
	return vebArray, nil
}

// MarshalJSON is the custom marshaler for VideoEncoderBase.
func (veb VideoEncoderBase) MarshalJSON() ([]byte, error) {
	veb.Type = TypeBasicVideoEncoderBaseTypeVideoEncoderBase
	objectMap := make(map[string]interface{})
	if veb.BitrateKbps != nil {
		objectMap["bitrateKbps"] = veb.BitrateKbps
	}
	if veb.FrameRate != nil {
		objectMap["frameRate"] = veb.FrameRate
	}
	if veb.Scale != nil {
		objectMap["scale"] = veb.Scale
	}
	if veb.Type != "" {
		objectMap["@type"] = veb.Type
	}
	return json.Marshal(objectMap)
}

// AsVideoEncoderH264 is the BasicVideoEncoderBase implementation for VideoEncoderBase.
func (veb VideoEncoderBase) AsVideoEncoderH264() (*VideoEncoderH264, bool) {
	return nil, false
}

// AsVideoEncoderBase is the BasicVideoEncoderBase implementation for VideoEncoderBase.
func (veb VideoEncoderBase) AsVideoEncoderBase() (*VideoEncoderBase, bool) {
	return &veb, true
}

// AsBasicVideoEncoderBase is the BasicVideoEncoderBase implementation for VideoEncoderBase.
func (veb VideoEncoderBase) AsBasicVideoEncoderBase() (BasicVideoEncoderBase, bool) {
	return &veb, true
}

// VideoEncoderH264 a custom preset for encoding video with the H.264 (AVC) codec.
type VideoEncoderH264 struct {
	// BitrateKbps - The maximum bitrate, in kilobits per second or Kbps, at which video should be encoded. If omitted, encoder sets it automatically to try and match the quality of the input video.
	BitrateKbps *string `json:"bitrateKbps,omitempty"`
	// FrameRate - The frame rate (in frames per second) of the encoded video. The value must be greater than zero, and less than or equal to 300. If omitted, the encoder uses the average frame rate of the input video.
	FrameRate *string `json:"frameRate,omitempty"`
	// Scale - Describes the resolution of the encoded video. If omitted, the encoder uses the resolution of the input video.
	Scale *VideoScale `json:"scale,omitempty"`
	// Type - Possible values include: 'TypeBasicVideoEncoderBaseTypeVideoEncoderBase', 'TypeBasicVideoEncoderBaseTypeMicrosoftVideoAnalyzerVideoEncoderH264'
	Type TypeBasicVideoEncoderBase `json:"@type,omitempty"`
}

// MarshalJSON is the custom marshaler for VideoEncoderH264.
func (veh VideoEncoderH264) MarshalJSON() ([]byte, error) {
	veh.Type = TypeBasicVideoEncoderBaseTypeMicrosoftVideoAnalyzerVideoEncoderH264
	objectMap := make(map[string]interface{})
	if veh.BitrateKbps != nil {
		objectMap["bitrateKbps"] = veh.BitrateKbps
	}
	if veh.FrameRate != nil {
		objectMap["frameRate"] = veh.FrameRate
	}
	if veh.Scale != nil {
		objectMap["scale"] = veh.Scale
	}
	if veh.Type != "" {
		objectMap["@type"] = veh.Type
	}
	return json.Marshal(objectMap)
}

// AsVideoEncoderH264 is the BasicVideoEncoderBase implementation for VideoEncoderH264.
func (veh VideoEncoderH264) AsVideoEncoderH264() (*VideoEncoderH264, bool) {
	return &veh, true
}

// AsVideoEncoderBase is the BasicVideoEncoderBase implementation for VideoEncoderH264.
func (veh VideoEncoderH264) AsVideoEncoderBase() (*VideoEncoderBase, bool) {
	return nil, false
}

// AsBasicVideoEncoderBase is the BasicVideoEncoderBase implementation for VideoEncoderH264.
func (veh VideoEncoderH264) AsBasicVideoEncoderBase() (BasicVideoEncoderBase, bool) {
	return &veh, true
}

// VideoEntity represents a video resource within Azure Video Analyzer. Videos can be ingested from RTSP
// cameras through live pipelines or can be created by exporting sequences from existing captured video
// through a pipeline job. Videos ingested through live pipelines can be streamed through Azure Video
// Analyzer Player Widget or compatible players. Exported videos can be downloaded as MP4 files.
type VideoEntity struct {
	autorest.Response `json:"-"`
	// VideoProperties - The resource properties.
	*VideoProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
	// SystemData - READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for VideoEntity.
func (ve VideoEntity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ve.VideoProperties != nil {
		objectMap["properties"] = ve.VideoProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VideoEntity struct.
func (ve *VideoEntity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var videoProperties VideoProperties
				err = json.Unmarshal(*v, &videoProperties)
				if err != nil {
					return err
				}
				ve.VideoProperties = &videoProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ve.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ve.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ve.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				ve.SystemData = &systemData
			}
		}
	}

	return nil
}

// VideoEntityCollection a collection of VideoEntity items.
type VideoEntityCollection struct {
	autorest.Response `json:"-"`
	// Value - A collection of VideoEntity items.
	Value *[]VideoEntity `json:"value,omitempty"`
	// NextLink - A link to the next page of the collection (when the collection contains too many results to return in one response).
	NextLink *string `json:"@nextLink,omitempty"`
}

// VideoEntityCollectionIterator provides access to a complete listing of VideoEntity values.
type VideoEntityCollectionIterator struct {
	i    int
	page VideoEntityCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *VideoEntityCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VideoEntityCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *VideoEntityCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter VideoEntityCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter VideoEntityCollectionIterator) Response() VideoEntityCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter VideoEntityCollectionIterator) Value() VideoEntity {
	if !iter.page.NotDone() {
		return VideoEntity{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the VideoEntityCollectionIterator type.
func NewVideoEntityCollectionIterator(page VideoEntityCollectionPage) VideoEntityCollectionIterator {
	return VideoEntityCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (vec VideoEntityCollection) IsEmpty() bool {
	return vec.Value == nil || len(*vec.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (vec VideoEntityCollection) hasNextLink() bool {
	return vec.NextLink != nil && len(*vec.NextLink) != 0
}

// videoEntityCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (vec VideoEntityCollection) videoEntityCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !vec.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(vec.NextLink)))
}

// VideoEntityCollectionPage contains a page of VideoEntity values.
type VideoEntityCollectionPage struct {
	fn  func(context.Context, VideoEntityCollection) (VideoEntityCollection, error)
	vec VideoEntityCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *VideoEntityCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VideoEntityCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.vec)
		if err != nil {
			return err
		}
		page.vec = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *VideoEntityCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page VideoEntityCollectionPage) NotDone() bool {
	return !page.vec.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page VideoEntityCollectionPage) Response() VideoEntityCollection {
	return page.vec
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page VideoEntityCollectionPage) Values() []VideoEntity {
	if page.vec.IsEmpty() {
		return nil
	}
	return *page.vec.Value
}

// Creates a new instance of the VideoEntityCollectionPage type.
func NewVideoEntityCollectionPage(cur VideoEntityCollection, getNextPage func(context.Context, VideoEntityCollection) (VideoEntityCollection, error)) VideoEntityCollectionPage {
	return VideoEntityCollectionPage{
		fn:  getNextPage,
		vec: cur,
	}
}

// VideoFlags video flags contain information about the available video actions and its dynamic properties
// based on the current video state.
type VideoFlags struct {
	// CanStream - Value indicating whether or not the video can be streamed. Only "archive" type videos can be streamed.
	CanStream *bool `json:"canStream,omitempty"`
	// HasData - Value indicating whether or not there has ever been data recorded or uploaded into the video. Newly created videos have this value set to false.
	HasData *bool `json:"hasData,omitempty"`
	// IsInUse - Value indicating whether or not the video is currently being referenced be an active pipeline. The fact that is being referenced, doesn't necessarily indicate that data is being received. For example, video recording may be gated on events or camera may not be accessible at the time.
	IsInUse *bool `json:"isInUse,omitempty"`
}

// VideoMediaInfo contains information about the video and audio content.
type VideoMediaInfo struct {
	// SegmentLength - READ-ONLY; Video segment length indicates the length of individual video files (segments) which are persisted to storage. Smaller segments provide lower archive playback latency but generate larger volume of storage transactions. Larger segments reduce the amount of storage transactions while increasing the archive playback latency. Value must be specified in ISO8601 duration format (i.e. "PT30S" equals 30 seconds) and can vary between 30 seconds to 5 minutes, in 30 seconds increments.
	SegmentLength *string `json:"segmentLength,omitempty"`
}

// MarshalJSON is the custom marshaler for VideoMediaInfo.
func (vmi VideoMediaInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// VideoPreviewImageUrls video preview image URLs. These URLs can be used in conjunction with the video
// content authorization token to download the most recent still image from the video archive in different
// resolutions. They are available when the video type is 'archive' and preview images are enabled.
type VideoPreviewImageUrls struct {
	// Small - Low resolution preview image URL.
	Small *string `json:"small,omitempty"`
	// Medium - Medium resolution preview image URL.
	Medium *string `json:"medium,omitempty"`
	// Large - High resolution preview image URL.
	Large *string `json:"large,omitempty"`
}

// VideoProperties application level properties for the video resource.
type VideoProperties struct {
	// Title - Optional video title provided by the user. Value can be up to 256 characters long.
	Title *string `json:"title,omitempty"`
	// Description - Optional video description provided by the user. Value can be up to 2048 characters long.
	Description *string `json:"description,omitempty"`
	// Type - READ-ONLY; Video content type. Different content types are suitable for different applications and scenarios. Possible values include: 'VideoTypeArchive', 'VideoTypeFile'
	Type VideoType `json:"type,omitempty"`
	// Flags - READ-ONLY; Video flags contain information about the available video actions and its dynamic properties based on the current video state.
	Flags *VideoFlags `json:"flags,omitempty"`
	// ContentUrls - READ-ONLY; Set of URLs to the video content.
	ContentUrls *VideoContentUrls `json:"contentUrls,omitempty"`
	// MediaInfo - READ-ONLY; Contains information about the video and audio content.
	MediaInfo *VideoMediaInfo `json:"mediaInfo,omitempty"`
	// Archival - Video archival properties.
	Archival *VideoArchival `json:"archival,omitempty"`
}

// MarshalJSON is the custom marshaler for VideoProperties.
func (vp VideoProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vp.Title != nil {
		objectMap["title"] = vp.Title
	}
	if vp.Description != nil {
		objectMap["description"] = vp.Description
	}
	if vp.Archival != nil {
		objectMap["archival"] = vp.Archival
	}
	return json.Marshal(objectMap)
}

// VideoPublishingOptions optional flags used to change how video is published. These are only allowed for
// topologies where "kind" is set to "live".
type VideoPublishingOptions struct {
	// DisableArchive - When set to 'true' content will not be archived or recorded. This is used, for example, when the topology is used only for low latency video streaming. Default is 'false'.  If set to 'true', then "disableRtspPublishing" must be set to 'false'.
	DisableArchive *string `json:"disableArchive,omitempty"`
	// DisableRtspPublishing - When set to 'true' the RTSP playback URL will not be published, disabling low latency streaming. This is used, for example, when the topology is used only for archiving content. Default is 'false'.  If set to 'true', then "disableArchive" must be set to 'false'.
	DisableRtspPublishing *string `json:"disableRtspPublishing,omitempty"`
}

// VideoScale the video scaling information.
type VideoScale struct {
	// Height - The desired output video height.
	Height *string `json:"height,omitempty"`
	// Width - The desired output video width.
	Width *string `json:"width,omitempty"`
	// Mode - Describes the video scaling mode to be applied. Default mode is 'Pad'. If the mode is 'Pad' or 'Stretch' then both width and height must be specified. Else if the mode is 'PreserveAspectRatio' then only one of width or height need be provided. Possible values include: 'VideoScaleModePad', 'VideoScaleModePreserveAspectRatio', 'VideoScaleModeStretch'
	Mode VideoScaleMode `json:"mode,omitempty"`
}

// VideoSequenceAbsoluteTimeMarkers a sequence of absolute datetime ranges as a string. The datetime values
// should follow IS08601, and the sum of the ranges should add up to 24 hours or less. Currently, there can
// be only one range specified in the sequence.
type VideoSequenceAbsoluteTimeMarkers struct {
	// Ranges - The sequence of datetime ranges. Example: '[["2021-10-05T03:30:00Z", "2021-10-05T03:40:00Z"]]'.
	Ranges *string `json:"ranges,omitempty"`
	// Type - Possible values include: 'TypeBasicTimeSequenceBaseTypeTimeSequenceBase', 'TypeBasicTimeSequenceBaseTypeMicrosoftVideoAnalyzerVideoSequenceAbsoluteTimeMarkers'
	Type TypeBasicTimeSequenceBase `json:"@type,omitempty"`
}

// MarshalJSON is the custom marshaler for VideoSequenceAbsoluteTimeMarkers.
func (vsatm VideoSequenceAbsoluteTimeMarkers) MarshalJSON() ([]byte, error) {
	vsatm.Type = TypeBasicTimeSequenceBaseTypeMicrosoftVideoAnalyzerVideoSequenceAbsoluteTimeMarkers
	objectMap := make(map[string]interface{})
	if vsatm.Ranges != nil {
		objectMap["ranges"] = vsatm.Ranges
	}
	if vsatm.Type != "" {
		objectMap["@type"] = vsatm.Type
	}
	return json.Marshal(objectMap)
}

// AsVideoSequenceAbsoluteTimeMarkers is the BasicTimeSequenceBase implementation for VideoSequenceAbsoluteTimeMarkers.
func (vsatm VideoSequenceAbsoluteTimeMarkers) AsVideoSequenceAbsoluteTimeMarkers() (*VideoSequenceAbsoluteTimeMarkers, bool) {
	return &vsatm, true
}

// AsTimeSequenceBase is the BasicTimeSequenceBase implementation for VideoSequenceAbsoluteTimeMarkers.
func (vsatm VideoSequenceAbsoluteTimeMarkers) AsTimeSequenceBase() (*TimeSequenceBase, bool) {
	return nil, false
}

// AsBasicTimeSequenceBase is the BasicTimeSequenceBase implementation for VideoSequenceAbsoluteTimeMarkers.
func (vsatm VideoSequenceAbsoluteTimeMarkers) AsBasicTimeSequenceBase() (BasicTimeSequenceBase, bool) {
	return &vsatm, true
}

// VideoSink video sink in a live topology allows for video and audio to be captured, optionally archived,
// and published via a video resource. If archiving is enabled, this results in a video of type 'archive'.
// If used in a batch topology, this allows for video and audio to be stored as a file, and published via a
// video resource of type 'file'
type VideoSink struct {
	// VideoName - Name of a new or existing video resource used to capture and publish content. Note: if downstream of RTSP source, and if disableArchive is set to true, then no content is archived.
	VideoName *string `json:"videoName,omitempty"`
	// VideoCreationProperties - Optional video properties to be used in case a new video resource needs to be created on the service.
	VideoCreationProperties *VideoCreationProperties `json:"videoCreationProperties,omitempty"`
	// VideoPublishingOptions - Options to change how the video sink publishes content via the video resource. This property is only allowed for topologies where "kind" is set to "live".
	VideoPublishingOptions *VideoPublishingOptions `json:"videoPublishingOptions,omitempty"`
	// Inputs - An array of upstream node references within the topology to be used as inputs for this node.
	Inputs *[]NodeInput `json:"inputs,omitempty"`
	// Name - Node name. Must be unique within the topology.
	Name *string `json:"name,omitempty"`
	// Type - Possible values include: 'TypeNodeBase', 'TypeMicrosoftVideoAnalyzerSourceNodeBase', 'TypeMicrosoftVideoAnalyzerProcessorNodeBase', 'TypeMicrosoftVideoAnalyzerSinkNodeBase', 'TypeMicrosoftVideoAnalyzerRtspSource', 'TypeMicrosoftVideoAnalyzerVideoSource', 'TypeMicrosoftVideoAnalyzerEncoderProcessor', 'TypeMicrosoftVideoAnalyzerVideoSink'
	Type Type `json:"@type,omitempty"`
}

// MarshalJSON is the custom marshaler for VideoSink.
func (vs VideoSink) MarshalJSON() ([]byte, error) {
	vs.Type = TypeMicrosoftVideoAnalyzerVideoSink
	objectMap := make(map[string]interface{})
	if vs.VideoName != nil {
		objectMap["videoName"] = vs.VideoName
	}
	if vs.VideoCreationProperties != nil {
		objectMap["videoCreationProperties"] = vs.VideoCreationProperties
	}
	if vs.VideoPublishingOptions != nil {
		objectMap["videoPublishingOptions"] = vs.VideoPublishingOptions
	}
	if vs.Inputs != nil {
		objectMap["inputs"] = vs.Inputs
	}
	if vs.Name != nil {
		objectMap["name"] = vs.Name
	}
	if vs.Type != "" {
		objectMap["@type"] = vs.Type
	}
	return json.Marshal(objectMap)
}

// AsSourceNodeBase is the BasicNodeBase implementation for VideoSink.
func (vs VideoSink) AsSourceNodeBase() (*SourceNodeBase, bool) {
	return nil, false
}

// AsBasicSourceNodeBase is the BasicNodeBase implementation for VideoSink.
func (vs VideoSink) AsBasicSourceNodeBase() (BasicSourceNodeBase, bool) {
	return nil, false
}

// AsProcessorNodeBase is the BasicNodeBase implementation for VideoSink.
func (vs VideoSink) AsProcessorNodeBase() (*ProcessorNodeBase, bool) {
	return nil, false
}

// AsBasicProcessorNodeBase is the BasicNodeBase implementation for VideoSink.
func (vs VideoSink) AsBasicProcessorNodeBase() (BasicProcessorNodeBase, bool) {
	return nil, false
}

// AsSinkNodeBase is the BasicNodeBase implementation for VideoSink.
func (vs VideoSink) AsSinkNodeBase() (*SinkNodeBase, bool) {
	return nil, false
}

// AsBasicSinkNodeBase is the BasicNodeBase implementation for VideoSink.
func (vs VideoSink) AsBasicSinkNodeBase() (BasicSinkNodeBase, bool) {
	return &vs, true
}

// AsRtspSource is the BasicNodeBase implementation for VideoSink.
func (vs VideoSink) AsRtspSource() (*RtspSource, bool) {
	return nil, false
}

// AsVideoSource is the BasicNodeBase implementation for VideoSink.
func (vs VideoSink) AsVideoSource() (*VideoSource, bool) {
	return nil, false
}

// AsEncoderProcessor is the BasicNodeBase implementation for VideoSink.
func (vs VideoSink) AsEncoderProcessor() (*EncoderProcessor, bool) {
	return nil, false
}

// AsVideoSink is the BasicNodeBase implementation for VideoSink.
func (vs VideoSink) AsVideoSink() (*VideoSink, bool) {
	return &vs, true
}

// AsNodeBase is the BasicNodeBase implementation for VideoSink.
func (vs VideoSink) AsNodeBase() (*NodeBase, bool) {
	return nil, false
}

// AsBasicNodeBase is the BasicNodeBase implementation for VideoSink.
func (vs VideoSink) AsBasicNodeBase() (BasicNodeBase, bool) {
	return &vs, true
}

// VideoSource video source allows for content from a Video Analyzer video resource to be ingested into a
// pipeline. Currently supported only with batch pipelines.
type VideoSource struct {
	// VideoName - Name of the Video Analyzer video resource to be used as the source.
	VideoName *string `json:"videoName,omitempty"`
	// TimeSequences - Describes a sequence of datetime ranges. The video source only picks up recorded media within these ranges.
	TimeSequences BasicTimeSequenceBase `json:"timeSequences,omitempty"`
	// Name - Node name. Must be unique within the topology.
	Name *string `json:"name,omitempty"`
	// Type - Possible values include: 'TypeNodeBase', 'TypeMicrosoftVideoAnalyzerSourceNodeBase', 'TypeMicrosoftVideoAnalyzerProcessorNodeBase', 'TypeMicrosoftVideoAnalyzerSinkNodeBase', 'TypeMicrosoftVideoAnalyzerRtspSource', 'TypeMicrosoftVideoAnalyzerVideoSource', 'TypeMicrosoftVideoAnalyzerEncoderProcessor', 'TypeMicrosoftVideoAnalyzerVideoSink'
	Type Type `json:"@type,omitempty"`
}

// MarshalJSON is the custom marshaler for VideoSource.
func (vs VideoSource) MarshalJSON() ([]byte, error) {
	vs.Type = TypeMicrosoftVideoAnalyzerVideoSource
	objectMap := make(map[string]interface{})
	if vs.VideoName != nil {
		objectMap["videoName"] = vs.VideoName
	}
	objectMap["timeSequences"] = vs.TimeSequences
	if vs.Name != nil {
		objectMap["name"] = vs.Name
	}
	if vs.Type != "" {
		objectMap["@type"] = vs.Type
	}
	return json.Marshal(objectMap)
}

// AsSourceNodeBase is the BasicNodeBase implementation for VideoSource.
func (vs VideoSource) AsSourceNodeBase() (*SourceNodeBase, bool) {
	return nil, false
}

// AsBasicSourceNodeBase is the BasicNodeBase implementation for VideoSource.
func (vs VideoSource) AsBasicSourceNodeBase() (BasicSourceNodeBase, bool) {
	return &vs, true
}

// AsProcessorNodeBase is the BasicNodeBase implementation for VideoSource.
func (vs VideoSource) AsProcessorNodeBase() (*ProcessorNodeBase, bool) {
	return nil, false
}

// AsBasicProcessorNodeBase is the BasicNodeBase implementation for VideoSource.
func (vs VideoSource) AsBasicProcessorNodeBase() (BasicProcessorNodeBase, bool) {
	return nil, false
}

// AsSinkNodeBase is the BasicNodeBase implementation for VideoSource.
func (vs VideoSource) AsSinkNodeBase() (*SinkNodeBase, bool) {
	return nil, false
}

// AsBasicSinkNodeBase is the BasicNodeBase implementation for VideoSource.
func (vs VideoSource) AsBasicSinkNodeBase() (BasicSinkNodeBase, bool) {
	return nil, false
}

// AsRtspSource is the BasicNodeBase implementation for VideoSource.
func (vs VideoSource) AsRtspSource() (*RtspSource, bool) {
	return nil, false
}

// AsVideoSource is the BasicNodeBase implementation for VideoSource.
func (vs VideoSource) AsVideoSource() (*VideoSource, bool) {
	return &vs, true
}

// AsEncoderProcessor is the BasicNodeBase implementation for VideoSource.
func (vs VideoSource) AsEncoderProcessor() (*EncoderProcessor, bool) {
	return nil, false
}

// AsVideoSink is the BasicNodeBase implementation for VideoSource.
func (vs VideoSource) AsVideoSink() (*VideoSink, bool) {
	return nil, false
}

// AsNodeBase is the BasicNodeBase implementation for VideoSource.
func (vs VideoSource) AsNodeBase() (*NodeBase, bool) {
	return nil, false
}

// AsBasicNodeBase is the BasicNodeBase implementation for VideoSource.
func (vs VideoSource) AsBasicNodeBase() (BasicNodeBase, bool) {
	return &vs, true
}

// UnmarshalJSON is the custom unmarshaler for VideoSource struct.
func (vs *VideoSource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "videoName":
			if v != nil {
				var videoName string
				err = json.Unmarshal(*v, &videoName)
				if err != nil {
					return err
				}
				vs.VideoName = &videoName
			}
		case "timeSequences":
			if v != nil {
				timeSequences, err := unmarshalBasicTimeSequenceBase(*v)
				if err != nil {
					return err
				}
				vs.TimeSequences = timeSequences
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vs.Name = &name
			}
		case "@type":
			if v != nil {
				var typeVar Type
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vs.Type = typeVar
			}
		}
	}

	return nil
}
