// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/networkmanagement/v1/vpc_flow_logs_config.proto

package networkmanagementpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Determines whether this configuration will be generating logs.
type VpcFlowLogsConfig_State int32

const (
	// If not specified, will default to ENABLED.
	VpcFlowLogsConfig_STATE_UNSPECIFIED VpcFlowLogsConfig_State = 0
	// When ENABLED, this configuration will generate logs.
	VpcFlowLogsConfig_ENABLED VpcFlowLogsConfig_State = 1
	// When DISABLED, this configuration will not generate logs.
	VpcFlowLogsConfig_DISABLED VpcFlowLogsConfig_State = 2
)

// Enum value maps for VpcFlowLogsConfig_State.
var (
	VpcFlowLogsConfig_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "ENABLED",
		2: "DISABLED",
	}
	VpcFlowLogsConfig_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"ENABLED":           1,
		"DISABLED":          2,
	}
)

func (x VpcFlowLogsConfig_State) Enum() *VpcFlowLogsConfig_State {
	p := new(VpcFlowLogsConfig_State)
	*p = x
	return p
}

func (x VpcFlowLogsConfig_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (VpcFlowLogsConfig_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_networkmanagement_v1_vpc_flow_logs_config_proto_enumTypes[0].Descriptor()
}

func (VpcFlowLogsConfig_State) Type() protoreflect.EnumType {
	return &file_google_cloud_networkmanagement_v1_vpc_flow_logs_config_proto_enumTypes[0]
}

func (x VpcFlowLogsConfig_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use VpcFlowLogsConfig_State.Descriptor instead.
func (VpcFlowLogsConfig_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_vpc_flow_logs_config_proto_rawDescGZIP(), []int{0, 0}
}

// Toggles the aggregation interval for collecting flow logs by 5-tuple.
type VpcFlowLogsConfig_AggregationInterval int32

const (
	// If not specified, will default to INTERVAL_5_SEC.
	VpcFlowLogsConfig_AGGREGATION_INTERVAL_UNSPECIFIED VpcFlowLogsConfig_AggregationInterval = 0
	// Aggregate logs in 5s intervals.
	VpcFlowLogsConfig_INTERVAL_5_SEC VpcFlowLogsConfig_AggregationInterval = 1
	// Aggregate logs in 30s intervals.
	VpcFlowLogsConfig_INTERVAL_30_SEC VpcFlowLogsConfig_AggregationInterval = 2
	// Aggregate logs in 1m intervals.
	VpcFlowLogsConfig_INTERVAL_1_MIN VpcFlowLogsConfig_AggregationInterval = 3
	// Aggregate logs in 5m intervals.
	VpcFlowLogsConfig_INTERVAL_5_MIN VpcFlowLogsConfig_AggregationInterval = 4
	// Aggregate logs in 10m intervals.
	VpcFlowLogsConfig_INTERVAL_10_MIN VpcFlowLogsConfig_AggregationInterval = 5
	// Aggregate logs in 15m intervals.
	VpcFlowLogsConfig_INTERVAL_15_MIN VpcFlowLogsConfig_AggregationInterval = 6
)

// Enum value maps for VpcFlowLogsConfig_AggregationInterval.
var (
	VpcFlowLogsConfig_AggregationInterval_name = map[int32]string{
		0: "AGGREGATION_INTERVAL_UNSPECIFIED",
		1: "INTERVAL_5_SEC",
		2: "INTERVAL_30_SEC",
		3: "INTERVAL_1_MIN",
		4: "INTERVAL_5_MIN",
		5: "INTERVAL_10_MIN",
		6: "INTERVAL_15_MIN",
	}
	VpcFlowLogsConfig_AggregationInterval_value = map[string]int32{
		"AGGREGATION_INTERVAL_UNSPECIFIED": 0,
		"INTERVAL_5_SEC":                   1,
		"INTERVAL_30_SEC":                  2,
		"INTERVAL_1_MIN":                   3,
		"INTERVAL_5_MIN":                   4,
		"INTERVAL_10_MIN":                  5,
		"INTERVAL_15_MIN":                  6,
	}
)

func (x VpcFlowLogsConfig_AggregationInterval) Enum() *VpcFlowLogsConfig_AggregationInterval {
	p := new(VpcFlowLogsConfig_AggregationInterval)
	*p = x
	return p
}

func (x VpcFlowLogsConfig_AggregationInterval) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (VpcFlowLogsConfig_AggregationInterval) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_networkmanagement_v1_vpc_flow_logs_config_proto_enumTypes[1].Descriptor()
}

func (VpcFlowLogsConfig_AggregationInterval) Type() protoreflect.EnumType {
	return &file_google_cloud_networkmanagement_v1_vpc_flow_logs_config_proto_enumTypes[1]
}

func (x VpcFlowLogsConfig_AggregationInterval) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use VpcFlowLogsConfig_AggregationInterval.Descriptor instead.
func (VpcFlowLogsConfig_AggregationInterval) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_vpc_flow_logs_config_proto_rawDescGZIP(), []int{0, 1}
}

// Configures which log fields would be included.
type VpcFlowLogsConfig_Metadata int32

const (
	// If not specified, will default to INCLUDE_ALL_METADATA.
	VpcFlowLogsConfig_METADATA_UNSPECIFIED VpcFlowLogsConfig_Metadata = 0
	// Include all metadata fields.
	VpcFlowLogsConfig_INCLUDE_ALL_METADATA VpcFlowLogsConfig_Metadata = 1
	// Exclude all metadata fields.
	VpcFlowLogsConfig_EXCLUDE_ALL_METADATA VpcFlowLogsConfig_Metadata = 2
	// Include only custom fields (specified in metadata_fields).
	VpcFlowLogsConfig_CUSTOM_METADATA VpcFlowLogsConfig_Metadata = 3
)

// Enum value maps for VpcFlowLogsConfig_Metadata.
var (
	VpcFlowLogsConfig_Metadata_name = map[int32]string{
		0: "METADATA_UNSPECIFIED",
		1: "INCLUDE_ALL_METADATA",
		2: "EXCLUDE_ALL_METADATA",
		3: "CUSTOM_METADATA",
	}
	VpcFlowLogsConfig_Metadata_value = map[string]int32{
		"METADATA_UNSPECIFIED": 0,
		"INCLUDE_ALL_METADATA": 1,
		"EXCLUDE_ALL_METADATA": 2,
		"CUSTOM_METADATA":      3,
	}
)

func (x VpcFlowLogsConfig_Metadata) Enum() *VpcFlowLogsConfig_Metadata {
	p := new(VpcFlowLogsConfig_Metadata)
	*p = x
	return p
}

func (x VpcFlowLogsConfig_Metadata) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (VpcFlowLogsConfig_Metadata) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_networkmanagement_v1_vpc_flow_logs_config_proto_enumTypes[2].Descriptor()
}

func (VpcFlowLogsConfig_Metadata) Type() protoreflect.EnumType {
	return &file_google_cloud_networkmanagement_v1_vpc_flow_logs_config_proto_enumTypes[2]
}

func (x VpcFlowLogsConfig_Metadata) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use VpcFlowLogsConfig_Metadata.Descriptor instead.
func (VpcFlowLogsConfig_Metadata) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_vpc_flow_logs_config_proto_rawDescGZIP(), []int{0, 2}
}

// Determines whether to include cross project annotations in the logs.
// Project configurations will always have CROSS_PROJECT_METADATA_DISABLED.
type VpcFlowLogsConfig_CrossProjectMetadata int32

const (
	// If not specified, the default is CROSS_PROJECT_METADATA_ENABLED.
	VpcFlowLogsConfig_CROSS_PROJECT_METADATA_UNSPECIFIED VpcFlowLogsConfig_CrossProjectMetadata = 0
	// When CROSS_PROJECT_METADATA_ENABLED, metadata from other projects will be
	// included in the logs.
	VpcFlowLogsConfig_CROSS_PROJECT_METADATA_ENABLED VpcFlowLogsConfig_CrossProjectMetadata = 1
	// When CROSS_PROJECT_METADATA_DISABLED, metadata from other projects will
	// not be included in the logs.
	VpcFlowLogsConfig_CROSS_PROJECT_METADATA_DISABLED VpcFlowLogsConfig_CrossProjectMetadata = 2
)

// Enum value maps for VpcFlowLogsConfig_CrossProjectMetadata.
var (
	VpcFlowLogsConfig_CrossProjectMetadata_name = map[int32]string{
		0: "CROSS_PROJECT_METADATA_UNSPECIFIED",
		1: "CROSS_PROJECT_METADATA_ENABLED",
		2: "CROSS_PROJECT_METADATA_DISABLED",
	}
	VpcFlowLogsConfig_CrossProjectMetadata_value = map[string]int32{
		"CROSS_PROJECT_METADATA_UNSPECIFIED": 0,
		"CROSS_PROJECT_METADATA_ENABLED":     1,
		"CROSS_PROJECT_METADATA_DISABLED":    2,
	}
)

func (x VpcFlowLogsConfig_CrossProjectMetadata) Enum() *VpcFlowLogsConfig_CrossProjectMetadata {
	p := new(VpcFlowLogsConfig_CrossProjectMetadata)
	*p = x
	return p
}

func (x VpcFlowLogsConfig_CrossProjectMetadata) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (VpcFlowLogsConfig_CrossProjectMetadata) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_networkmanagement_v1_vpc_flow_logs_config_proto_enumTypes[3].Descriptor()
}

func (VpcFlowLogsConfig_CrossProjectMetadata) Type() protoreflect.EnumType {
	return &file_google_cloud_networkmanagement_v1_vpc_flow_logs_config_proto_enumTypes[3]
}

func (x VpcFlowLogsConfig_CrossProjectMetadata) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use VpcFlowLogsConfig_CrossProjectMetadata.Descriptor instead.
func (VpcFlowLogsConfig_CrossProjectMetadata) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_vpc_flow_logs_config_proto_rawDescGZIP(), []int{0, 3}
}

// Output only. Indicates whether the target resource exists, for diagnostic
// purposes.
type VpcFlowLogsConfig_TargetResourceState int32

const (
	// Unspecified target resource state.
	VpcFlowLogsConfig_TARGET_RESOURCE_STATE_UNSPECIFIED VpcFlowLogsConfig_TargetResourceState = 0
	// Indicates that the target resource exists.
	VpcFlowLogsConfig_TARGET_RESOURCE_EXISTS VpcFlowLogsConfig_TargetResourceState = 1
	// Indicates that the target resource does not exist.
	VpcFlowLogsConfig_TARGET_RESOURCE_DOES_NOT_EXIST VpcFlowLogsConfig_TargetResourceState = 2
)

// Enum value maps for VpcFlowLogsConfig_TargetResourceState.
var (
	VpcFlowLogsConfig_TargetResourceState_name = map[int32]string{
		0: "TARGET_RESOURCE_STATE_UNSPECIFIED",
		1: "TARGET_RESOURCE_EXISTS",
		2: "TARGET_RESOURCE_DOES_NOT_EXIST",
	}
	VpcFlowLogsConfig_TargetResourceState_value = map[string]int32{
		"TARGET_RESOURCE_STATE_UNSPECIFIED": 0,
		"TARGET_RESOURCE_EXISTS":            1,
		"TARGET_RESOURCE_DOES_NOT_EXIST":    2,
	}
)

func (x VpcFlowLogsConfig_TargetResourceState) Enum() *VpcFlowLogsConfig_TargetResourceState {
	p := new(VpcFlowLogsConfig_TargetResourceState)
	*p = x
	return p
}

func (x VpcFlowLogsConfig_TargetResourceState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (VpcFlowLogsConfig_TargetResourceState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_networkmanagement_v1_vpc_flow_logs_config_proto_enumTypes[4].Descriptor()
}

func (VpcFlowLogsConfig_TargetResourceState) Type() protoreflect.EnumType {
	return &file_google_cloud_networkmanagement_v1_vpc_flow_logs_config_proto_enumTypes[4]
}

func (x VpcFlowLogsConfig_TargetResourceState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use VpcFlowLogsConfig_TargetResourceState.Descriptor instead.
func (VpcFlowLogsConfig_TargetResourceState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_vpc_flow_logs_config_proto_rawDescGZIP(), []int{0, 4}
}

// The scope for this flow log configuration.
type EffectiveVpcFlowLogsConfig_Scope int32

const (
	// Scope is unspecified.
	EffectiveVpcFlowLogsConfig_SCOPE_UNSPECIFIED EffectiveVpcFlowLogsConfig_Scope = 0
	// Target resource is a subnet (Network Management API).
	EffectiveVpcFlowLogsConfig_SUBNET EffectiveVpcFlowLogsConfig_Scope = 1
	// Target resource is a subnet, and the config originates from the Compute
	// API.
	EffectiveVpcFlowLogsConfig_COMPUTE_API_SUBNET EffectiveVpcFlowLogsConfig_Scope = 2
	// Target resource is a network.
	EffectiveVpcFlowLogsConfig_NETWORK EffectiveVpcFlowLogsConfig_Scope = 3
	// Target resource is a VPN tunnel.
	EffectiveVpcFlowLogsConfig_VPN_TUNNEL EffectiveVpcFlowLogsConfig_Scope = 4
	// Target resource is an interconnect attachment.
	EffectiveVpcFlowLogsConfig_INTERCONNECT_ATTACHMENT EffectiveVpcFlowLogsConfig_Scope = 5
	// Configuration applies to an entire organization.
	EffectiveVpcFlowLogsConfig_ORGANIZATION EffectiveVpcFlowLogsConfig_Scope = 6
)

// Enum value maps for EffectiveVpcFlowLogsConfig_Scope.
var (
	EffectiveVpcFlowLogsConfig_Scope_name = map[int32]string{
		0: "SCOPE_UNSPECIFIED",
		1: "SUBNET",
		2: "COMPUTE_API_SUBNET",
		3: "NETWORK",
		4: "VPN_TUNNEL",
		5: "INTERCONNECT_ATTACHMENT",
		6: "ORGANIZATION",
	}
	EffectiveVpcFlowLogsConfig_Scope_value = map[string]int32{
		"SCOPE_UNSPECIFIED":       0,
		"SUBNET":                  1,
		"COMPUTE_API_SUBNET":      2,
		"NETWORK":                 3,
		"VPN_TUNNEL":              4,
		"INTERCONNECT_ATTACHMENT": 5,
		"ORGANIZATION":            6,
	}
)

func (x EffectiveVpcFlowLogsConfig_Scope) Enum() *EffectiveVpcFlowLogsConfig_Scope {
	p := new(EffectiveVpcFlowLogsConfig_Scope)
	*p = x
	return p
}

func (x EffectiveVpcFlowLogsConfig_Scope) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (EffectiveVpcFlowLogsConfig_Scope) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_networkmanagement_v1_vpc_flow_logs_config_proto_enumTypes[5].Descriptor()
}

func (EffectiveVpcFlowLogsConfig_Scope) Type() protoreflect.EnumType {
	return &file_google_cloud_networkmanagement_v1_vpc_flow_logs_config_proto_enumTypes[5]
}

func (x EffectiveVpcFlowLogsConfig_Scope) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use EffectiveVpcFlowLogsConfig_Scope.Descriptor instead.
func (EffectiveVpcFlowLogsConfig_Scope) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_vpc_flow_logs_config_proto_rawDescGZIP(), []int{1, 0}
}

// A configuration to generate VPC Flow Logs.
type VpcFlowLogsConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. Unique name of the configuration. The name can have one of the
	// following forms:
	//
	// - For project-level configurations:
	// `projects/{project_id}/locations/global/vpcFlowLogsConfigs/{vpc_flow_logs_config_id}`
	//
	// - For organization-level configurations:
	// `organizations/{organization_id}/locations/global/vpcFlowLogsConfigs/{vpc_flow_logs_config_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The user-supplied description of the VPC Flow Logs configuration.
	// Maximum of 512 characters.
	Description *string `protobuf:"bytes,2,opt,name=description,proto3,oneof" json:"description,omitempty"`
	// Optional. The state of the VPC Flow Log configuration. Default value is
	// ENABLED. When creating a new configuration, it must be enabled. Setting
	// state=DISABLED will pause the log generation for this config.
	State *VpcFlowLogsConfig_State `protobuf:"varint,3,opt,name=state,proto3,enum=google.cloud.networkmanagement.v1.VpcFlowLogsConfig_State,oneof" json:"state,omitempty"`
	// Optional. The aggregation interval for the logs. Default value is
	// INTERVAL_5_SEC.
	AggregationInterval *VpcFlowLogsConfig_AggregationInterval `protobuf:"varint,4,opt,name=aggregation_interval,json=aggregationInterval,proto3,enum=google.cloud.networkmanagement.v1.VpcFlowLogsConfig_AggregationInterval,oneof" json:"aggregation_interval,omitempty"`
	// Optional. The value of the field must be in (0, 1]. The sampling rate of
	// VPC Flow Logs where 1.0 means all collected logs are reported. Setting the
	// sampling rate to 0.0 is not allowed. If you want to disable VPC Flow Logs,
	// use the state field instead. Default value is 1.0.
	FlowSampling *float32 `protobuf:"fixed32,5,opt,name=flow_sampling,json=flowSampling,proto3,oneof" json:"flow_sampling,omitempty"`
	// Optional. Configures whether all, none or a subset of metadata fields
	// should be added to the reported VPC flow logs. Default value is
	// INCLUDE_ALL_METADATA.
	Metadata *VpcFlowLogsConfig_Metadata `protobuf:"varint,6,opt,name=metadata,proto3,enum=google.cloud.networkmanagement.v1.VpcFlowLogsConfig_Metadata,oneof" json:"metadata,omitempty"`
	// Optional. Custom metadata fields to include in the reported VPC flow logs.
	// Can only be specified if "metadata" was set to CUSTOM_METADATA.
	MetadataFields []string `protobuf:"bytes,7,rep,name=metadata_fields,json=metadataFields,proto3" json:"metadata_fields,omitempty"`
	// Optional. Export filter used to define which VPC Flow Logs should be
	// logged.
	FilterExpr *string `protobuf:"bytes,8,opt,name=filter_expr,json=filterExpr,proto3,oneof" json:"filter_expr,omitempty"`
	// Optional. Determines whether to include cross project annotations in the
	// logs. This field is available only for organization configurations. If not
	// specified in org configs will be set to CROSS_PROJECT_METADATA_ENABLED.
	CrossProjectMetadata *VpcFlowLogsConfig_CrossProjectMetadata `protobuf:"varint,13,opt,name=cross_project_metadata,json=crossProjectMetadata,proto3,enum=google.cloud.networkmanagement.v1.VpcFlowLogsConfig_CrossProjectMetadata,oneof" json:"cross_project_metadata,omitempty"`
	// Output only. Describes the state of the configured target resource for
	// diagnostic purposes.
	TargetResourceState *VpcFlowLogsConfig_TargetResourceState `protobuf:"varint,12,opt,name=target_resource_state,json=targetResourceState,proto3,enum=google.cloud.networkmanagement.v1.VpcFlowLogsConfig_TargetResourceState,oneof" json:"target_resource_state,omitempty"`
	// Reference to the resource of the config scope. That is, the scope from
	// which traffic is logged. The target resource must belong to the same
	// project as the configuration.
	// This field is not supported for organization level configurations.
	//
	// Types that are assignable to TargetResource:
	//
	//	*VpcFlowLogsConfig_Network
	//	*VpcFlowLogsConfig_Subnet
	//	*VpcFlowLogsConfig_InterconnectAttachment
	//	*VpcFlowLogsConfig_VpnTunnel
	TargetResource isVpcFlowLogsConfig_TargetResource `protobuf_oneof:"target_resource"`
	// Optional. Resource labels to represent user-provided metadata.
	Labels map[string]string `protobuf:"bytes,11,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. The time the config was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time the config was updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,10,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *VpcFlowLogsConfig) Reset() {
	*x = VpcFlowLogsConfig{}
	mi := &file_google_cloud_networkmanagement_v1_vpc_flow_logs_config_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *VpcFlowLogsConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VpcFlowLogsConfig) ProtoMessage() {}

func (x *VpcFlowLogsConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkmanagement_v1_vpc_flow_logs_config_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VpcFlowLogsConfig.ProtoReflect.Descriptor instead.
func (*VpcFlowLogsConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_vpc_flow_logs_config_proto_rawDescGZIP(), []int{0}
}

func (x *VpcFlowLogsConfig) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *VpcFlowLogsConfig) GetDescription() string {
	if x != nil && x.Description != nil {
		return *x.Description
	}
	return ""
}

func (x *VpcFlowLogsConfig) GetState() VpcFlowLogsConfig_State {
	if x != nil && x.State != nil {
		return *x.State
	}
	return VpcFlowLogsConfig_STATE_UNSPECIFIED
}

func (x *VpcFlowLogsConfig) GetAggregationInterval() VpcFlowLogsConfig_AggregationInterval {
	if x != nil && x.AggregationInterval != nil {
		return *x.AggregationInterval
	}
	return VpcFlowLogsConfig_AGGREGATION_INTERVAL_UNSPECIFIED
}

func (x *VpcFlowLogsConfig) GetFlowSampling() float32 {
	if x != nil && x.FlowSampling != nil {
		return *x.FlowSampling
	}
	return 0
}

func (x *VpcFlowLogsConfig) GetMetadata() VpcFlowLogsConfig_Metadata {
	if x != nil && x.Metadata != nil {
		return *x.Metadata
	}
	return VpcFlowLogsConfig_METADATA_UNSPECIFIED
}

func (x *VpcFlowLogsConfig) GetMetadataFields() []string {
	if x != nil {
		return x.MetadataFields
	}
	return nil
}

func (x *VpcFlowLogsConfig) GetFilterExpr() string {
	if x != nil && x.FilterExpr != nil {
		return *x.FilterExpr
	}
	return ""
}

func (x *VpcFlowLogsConfig) GetCrossProjectMetadata() VpcFlowLogsConfig_CrossProjectMetadata {
	if x != nil && x.CrossProjectMetadata != nil {
		return *x.CrossProjectMetadata
	}
	return VpcFlowLogsConfig_CROSS_PROJECT_METADATA_UNSPECIFIED
}

func (x *VpcFlowLogsConfig) GetTargetResourceState() VpcFlowLogsConfig_TargetResourceState {
	if x != nil && x.TargetResourceState != nil {
		return *x.TargetResourceState
	}
	return VpcFlowLogsConfig_TARGET_RESOURCE_STATE_UNSPECIFIED
}

func (m *VpcFlowLogsConfig) GetTargetResource() isVpcFlowLogsConfig_TargetResource {
	if m != nil {
		return m.TargetResource
	}
	return nil
}

func (x *VpcFlowLogsConfig) GetNetwork() string {
	if x, ok := x.GetTargetResource().(*VpcFlowLogsConfig_Network); ok {
		return x.Network
	}
	return ""
}

func (x *VpcFlowLogsConfig) GetSubnet() string {
	if x, ok := x.GetTargetResource().(*VpcFlowLogsConfig_Subnet); ok {
		return x.Subnet
	}
	return ""
}

func (x *VpcFlowLogsConfig) GetInterconnectAttachment() string {
	if x, ok := x.GetTargetResource().(*VpcFlowLogsConfig_InterconnectAttachment); ok {
		return x.InterconnectAttachment
	}
	return ""
}

func (x *VpcFlowLogsConfig) GetVpnTunnel() string {
	if x, ok := x.GetTargetResource().(*VpcFlowLogsConfig_VpnTunnel); ok {
		return x.VpnTunnel
	}
	return ""
}

func (x *VpcFlowLogsConfig) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *VpcFlowLogsConfig) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *VpcFlowLogsConfig) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

type isVpcFlowLogsConfig_TargetResource interface {
	isVpcFlowLogsConfig_TargetResource()
}

type VpcFlowLogsConfig_Network struct {
	// Traffic will be logged from VMs, VPN tunnels and Interconnect Attachments
	// within the network.
	// Format: projects/{project_id}/global/networks/{name}
	Network string `protobuf:"bytes,100,opt,name=network,proto3,oneof"`
}

type VpcFlowLogsConfig_Subnet struct {
	// Traffic will be logged from VMs within the subnetwork.
	// Format: projects/{project_id}/regions/{region}/subnetworks/{name}
	Subnet string `protobuf:"bytes,101,opt,name=subnet,proto3,oneof"`
}

type VpcFlowLogsConfig_InterconnectAttachment struct {
	// Traffic will be logged from the Interconnect Attachment.
	// Format:
	// projects/{project_id}/regions/{region}/interconnectAttachments/{name}
	InterconnectAttachment string `protobuf:"bytes,102,opt,name=interconnect_attachment,json=interconnectAttachment,proto3,oneof"`
}

type VpcFlowLogsConfig_VpnTunnel struct {
	// Traffic will be logged from the VPN Tunnel.
	// Format: projects/{project_id}/regions/{region}/vpnTunnels/{name}
	VpnTunnel string `protobuf:"bytes,103,opt,name=vpn_tunnel,json=vpnTunnel,proto3,oneof"`
}

func (*VpcFlowLogsConfig_Network) isVpcFlowLogsConfig_TargetResource() {}

func (*VpcFlowLogsConfig_Subnet) isVpcFlowLogsConfig_TargetResource() {}

func (*VpcFlowLogsConfig_InterconnectAttachment) isVpcFlowLogsConfig_TargetResource() {}

func (*VpcFlowLogsConfig_VpnTunnel) isVpcFlowLogsConfig_TargetResource() {}

// A configuration to generate a response for GetEffectiveVpcFlowLogsConfig
// request.
type EffectiveVpcFlowLogsConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Unique name of the configuration. The name can have one of the following
	// forms:
	//
	// - For project-level configurations:
	// `projects/{project_id}/locations/global/vpcFlowLogsConfigs/{vpc_flow_logs_config_id}`
	//
	// - For organization-level configurations:
	// `organizations/{organization_id}/locations/global/vpcFlowLogsConfigs/{vpc_flow_logs_config_id}`
	//
	// - For a Compute config, the name will be the path of the subnet:
	// `projects/{project_id}/regions/{region}/subnetworks/{subnet_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The state of the VPC Flow Log configuration. Default value is ENABLED.
	// When creating a new configuration, it must be enabled.
	// Setting state=DISABLED will pause the log generation for this config.
	State *VpcFlowLogsConfig_State `protobuf:"varint,3,opt,name=state,proto3,enum=google.cloud.networkmanagement.v1.VpcFlowLogsConfig_State,oneof" json:"state,omitempty"`
	// The aggregation interval for the logs. Default value is INTERVAL_5_SEC.
	AggregationInterval *VpcFlowLogsConfig_AggregationInterval `protobuf:"varint,4,opt,name=aggregation_interval,json=aggregationInterval,proto3,enum=google.cloud.networkmanagement.v1.VpcFlowLogsConfig_AggregationInterval,oneof" json:"aggregation_interval,omitempty"`
	// The value of the field must be in (0, 1]. The sampling rate of VPC Flow
	// Logs where 1.0 means all collected logs are reported.
	// Setting the sampling rate to 0.0 is not allowed. If you want to disable VPC
	// Flow Logs, use the state field instead.
	// Default value is 1.0.
	FlowSampling *float32 `protobuf:"fixed32,5,opt,name=flow_sampling,json=flowSampling,proto3,oneof" json:"flow_sampling,omitempty"`
	// Configures whether all, none or a subset of metadata fields should be
	// added to the reported VPC flow logs.
	// Default value is INCLUDE_ALL_METADATA.
	Metadata *VpcFlowLogsConfig_Metadata `protobuf:"varint,6,opt,name=metadata,proto3,enum=google.cloud.networkmanagement.v1.VpcFlowLogsConfig_Metadata,oneof" json:"metadata,omitempty"`
	// Custom metadata fields to include in the reported VPC flow logs.
	// Can only be specified if "metadata" was set to CUSTOM_METADATA.
	MetadataFields []string `protobuf:"bytes,7,rep,name=metadata_fields,json=metadataFields,proto3" json:"metadata_fields,omitempty"`
	// Export filter used to define which VPC Flow Logs should be logged.
	FilterExpr *string `protobuf:"bytes,8,opt,name=filter_expr,json=filterExpr,proto3,oneof" json:"filter_expr,omitempty"`
	// Determines whether to include cross project annotations in the logs.
	// This field is available only for organization configurations. If not
	// specified in org configs will be set to CROSS_PROJECT_METADATA_ENABLED.
	CrossProjectMetadata *VpcFlowLogsConfig_CrossProjectMetadata `protobuf:"varint,13,opt,name=cross_project_metadata,json=crossProjectMetadata,proto3,enum=google.cloud.networkmanagement.v1.VpcFlowLogsConfig_CrossProjectMetadata,oneof" json:"cross_project_metadata,omitempty"`
	// Reference to the resource of the config scope. That is, the scope from
	// which traffic is logged. The target resource must belong to the same
	// project as the configuration.
	// This field is not supported for organization level configurations.
	//
	// Types that are assignable to TargetResource:
	//
	//	*EffectiveVpcFlowLogsConfig_Network
	//	*EffectiveVpcFlowLogsConfig_Subnet
	//	*EffectiveVpcFlowLogsConfig_InterconnectAttachment
	//	*EffectiveVpcFlowLogsConfig_VpnTunnel
	TargetResource isEffectiveVpcFlowLogsConfig_TargetResource `protobuf_oneof:"target_resource"`
	// Specifies the scope of the config (e.g., SUBNET, NETWORK, ORGANIZATION..).
	Scope *EffectiveVpcFlowLogsConfig_Scope `protobuf:"varint,12,opt,name=scope,proto3,enum=google.cloud.networkmanagement.v1.EffectiveVpcFlowLogsConfig_Scope,oneof" json:"scope,omitempty"`
}

func (x *EffectiveVpcFlowLogsConfig) Reset() {
	*x = EffectiveVpcFlowLogsConfig{}
	mi := &file_google_cloud_networkmanagement_v1_vpc_flow_logs_config_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EffectiveVpcFlowLogsConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EffectiveVpcFlowLogsConfig) ProtoMessage() {}

func (x *EffectiveVpcFlowLogsConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkmanagement_v1_vpc_flow_logs_config_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EffectiveVpcFlowLogsConfig.ProtoReflect.Descriptor instead.
func (*EffectiveVpcFlowLogsConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_vpc_flow_logs_config_proto_rawDescGZIP(), []int{1}
}

func (x *EffectiveVpcFlowLogsConfig) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *EffectiveVpcFlowLogsConfig) GetState() VpcFlowLogsConfig_State {
	if x != nil && x.State != nil {
		return *x.State
	}
	return VpcFlowLogsConfig_STATE_UNSPECIFIED
}

func (x *EffectiveVpcFlowLogsConfig) GetAggregationInterval() VpcFlowLogsConfig_AggregationInterval {
	if x != nil && x.AggregationInterval != nil {
		return *x.AggregationInterval
	}
	return VpcFlowLogsConfig_AGGREGATION_INTERVAL_UNSPECIFIED
}

func (x *EffectiveVpcFlowLogsConfig) GetFlowSampling() float32 {
	if x != nil && x.FlowSampling != nil {
		return *x.FlowSampling
	}
	return 0
}

func (x *EffectiveVpcFlowLogsConfig) GetMetadata() VpcFlowLogsConfig_Metadata {
	if x != nil && x.Metadata != nil {
		return *x.Metadata
	}
	return VpcFlowLogsConfig_METADATA_UNSPECIFIED
}

func (x *EffectiveVpcFlowLogsConfig) GetMetadataFields() []string {
	if x != nil {
		return x.MetadataFields
	}
	return nil
}

func (x *EffectiveVpcFlowLogsConfig) GetFilterExpr() string {
	if x != nil && x.FilterExpr != nil {
		return *x.FilterExpr
	}
	return ""
}

func (x *EffectiveVpcFlowLogsConfig) GetCrossProjectMetadata() VpcFlowLogsConfig_CrossProjectMetadata {
	if x != nil && x.CrossProjectMetadata != nil {
		return *x.CrossProjectMetadata
	}
	return VpcFlowLogsConfig_CROSS_PROJECT_METADATA_UNSPECIFIED
}

func (m *EffectiveVpcFlowLogsConfig) GetTargetResource() isEffectiveVpcFlowLogsConfig_TargetResource {
	if m != nil {
		return m.TargetResource
	}
	return nil
}

func (x *EffectiveVpcFlowLogsConfig) GetNetwork() string {
	if x, ok := x.GetTargetResource().(*EffectiveVpcFlowLogsConfig_Network); ok {
		return x.Network
	}
	return ""
}

func (x *EffectiveVpcFlowLogsConfig) GetSubnet() string {
	if x, ok := x.GetTargetResource().(*EffectiveVpcFlowLogsConfig_Subnet); ok {
		return x.Subnet
	}
	return ""
}

func (x *EffectiveVpcFlowLogsConfig) GetInterconnectAttachment() string {
	if x, ok := x.GetTargetResource().(*EffectiveVpcFlowLogsConfig_InterconnectAttachment); ok {
		return x.InterconnectAttachment
	}
	return ""
}

func (x *EffectiveVpcFlowLogsConfig) GetVpnTunnel() string {
	if x, ok := x.GetTargetResource().(*EffectiveVpcFlowLogsConfig_VpnTunnel); ok {
		return x.VpnTunnel
	}
	return ""
}

func (x *EffectiveVpcFlowLogsConfig) GetScope() EffectiveVpcFlowLogsConfig_Scope {
	if x != nil && x.Scope != nil {
		return *x.Scope
	}
	return EffectiveVpcFlowLogsConfig_SCOPE_UNSPECIFIED
}

type isEffectiveVpcFlowLogsConfig_TargetResource interface {
	isEffectiveVpcFlowLogsConfig_TargetResource()
}

type EffectiveVpcFlowLogsConfig_Network struct {
	// Traffic will be logged from VMs, VPN tunnels and Interconnect Attachments
	// within the network.
	// Format: projects/{project_id}/global/networks/{name}
	Network string `protobuf:"bytes,100,opt,name=network,proto3,oneof"`
}

type EffectiveVpcFlowLogsConfig_Subnet struct {
	// Traffic will be logged from VMs within the subnetwork.
	// Format: projects/{project_id}/regions/{region}/subnetworks/{name}
	Subnet string `protobuf:"bytes,101,opt,name=subnet,proto3,oneof"`
}

type EffectiveVpcFlowLogsConfig_InterconnectAttachment struct {
	// Traffic will be logged from the Interconnect Attachment.
	// Format:
	// projects/{project_id}/regions/{region}/interconnectAttachments/{name}
	InterconnectAttachment string `protobuf:"bytes,102,opt,name=interconnect_attachment,json=interconnectAttachment,proto3,oneof"`
}

type EffectiveVpcFlowLogsConfig_VpnTunnel struct {
	// Traffic will be logged from the VPN Tunnel.
	// Format: projects/{project_id}/regions/{region}/vpnTunnels/{name}
	VpnTunnel string `protobuf:"bytes,103,opt,name=vpn_tunnel,json=vpnTunnel,proto3,oneof"`
}

func (*EffectiveVpcFlowLogsConfig_Network) isEffectiveVpcFlowLogsConfig_TargetResource() {}

func (*EffectiveVpcFlowLogsConfig_Subnet) isEffectiveVpcFlowLogsConfig_TargetResource() {}

func (*EffectiveVpcFlowLogsConfig_InterconnectAttachment) isEffectiveVpcFlowLogsConfig_TargetResource() {
}

func (*EffectiveVpcFlowLogsConfig_VpnTunnel) isEffectiveVpcFlowLogsConfig_TargetResource() {}

var File_google_cloud_networkmanagement_v1_vpc_flow_logs_config_proto protoreflect.FileDescriptor

var file_google_cloud_networkmanagement_v1_vpc_flow_logs_config_proto_rawDesc = []byte{
	0x0a, 0x3c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x2f, 0x76, 0x31, 0x2f, 0x76, 0x70, 0x63, 0x5f, 0x66, 0x6c, 0x6f, 0x77, 0x5f, 0x6c, 0x6f, 0x67,
	0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x21,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76,
	0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x95,
	0x12, 0x0a, 0x11, 0x56, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2a, 0x0a,
	0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x01, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x5a, 0x0a, 0x05, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x70, 0x63,
	0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x02, 0x52, 0x05, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x88, 0x01, 0x01, 0x12, 0x85, 0x01, 0x0a, 0x14, 0x61, 0x67, 0x67, 0x72, 0x65, 0x67,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77,
	0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x41, 0x67, 0x67, 0x72, 0x65,
	0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x48, 0x03, 0x52, 0x13, 0x61, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x88, 0x01, 0x01, 0x12, 0x2d, 0x0a,
	0x0d, 0x66, 0x6c, 0x6f, 0x77, 0x5f, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x69, 0x6e, 0x67, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x02, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x04, 0x52, 0x0c, 0x66, 0x6c, 0x6f,
	0x77, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x69, 0x6e, 0x67, 0x88, 0x01, 0x01, 0x12, 0x63, 0x0a, 0x08,
	0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e,
	0x76, 0x31, 0x2e, 0x56, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x48, 0x05, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x88, 0x01,
	0x01, 0x12, 0x2c, 0x0a, 0x0f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0e, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x12,
	0x29, 0x0a, 0x0b, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x5f, 0x65, 0x78, 0x70, 0x72, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x06, 0x52, 0x0a, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x45, 0x78, 0x70, 0x72, 0x88, 0x01, 0x01, 0x12, 0x89, 0x01, 0x0a, 0x16, 0x63,
	0x72, 0x6f, 0x73, 0x73, 0x5f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x6d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x49, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e,
	0x56, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x43, 0x72, 0x6f, 0x73, 0x73, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x07, 0x52, 0x14, 0x63,
	0x72, 0x6f, 0x73, 0x73, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x88, 0x01, 0x01, 0x12, 0x86, 0x01, 0x0a, 0x15, 0x74, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x18, 0x0c, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x70, 0x63, 0x46, 0x6c,
	0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x54, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x08, 0x52, 0x13, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x88, 0x01, 0x01, 0x12,
	0x1a, 0x0a, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x64, 0x20, 0x01, 0x28, 0x09,
	0x48, 0x00, 0x52, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x18, 0x0a, 0x06, 0x73,
	0x75, 0x62, 0x6e, 0x65, 0x74, 0x18, 0x65, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x06, 0x73,
	0x75, 0x62, 0x6e, 0x65, 0x74, 0x12, 0x39, 0x0a, 0x17, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x5f, 0x61, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74,
	0x18, 0x66, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x16, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74,
	0x12, 0x1f, 0x0a, 0x0a, 0x76, 0x70, 0x6e, 0x5f, 0x74, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x18, 0x67,
	0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x09, 0x76, 0x70, 0x6e, 0x54, 0x75, 0x6e, 0x6e, 0x65,
	0x6c, 0x12, 0x5d, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x0b, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67,
	0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22,
	0x39, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x0b, 0x0a, 0x07, 0x45, 0x4e, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08,
	0x44, 0x49, 0x53, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x22, 0xb6, 0x01, 0x0a, 0x13, 0x41,
	0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76,
	0x61, 0x6c, 0x12, 0x24, 0x0a, 0x20, 0x41, 0x47, 0x47, 0x52, 0x45, 0x47, 0x41, 0x54, 0x49, 0x4f,
	0x4e, 0x5f, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x56, 0x41, 0x4c, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x12, 0x0a, 0x0e, 0x49, 0x4e, 0x54, 0x45,
	0x52, 0x56, 0x41, 0x4c, 0x5f, 0x35, 0x5f, 0x53, 0x45, 0x43, 0x10, 0x01, 0x12, 0x13, 0x0a, 0x0f,
	0x49, 0x4e, 0x54, 0x45, 0x52, 0x56, 0x41, 0x4c, 0x5f, 0x33, 0x30, 0x5f, 0x53, 0x45, 0x43, 0x10,
	0x02, 0x12, 0x12, 0x0a, 0x0e, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x56, 0x41, 0x4c, 0x5f, 0x31, 0x5f,
	0x4d, 0x49, 0x4e, 0x10, 0x03, 0x12, 0x12, 0x0a, 0x0e, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x56, 0x41,
	0x4c, 0x5f, 0x35, 0x5f, 0x4d, 0x49, 0x4e, 0x10, 0x04, 0x12, 0x13, 0x0a, 0x0f, 0x49, 0x4e, 0x54,
	0x45, 0x52, 0x56, 0x41, 0x4c, 0x5f, 0x31, 0x30, 0x5f, 0x4d, 0x49, 0x4e, 0x10, 0x05, 0x12, 0x13,
	0x0a, 0x0f, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x56, 0x41, 0x4c, 0x5f, 0x31, 0x35, 0x5f, 0x4d, 0x49,
	0x4e, 0x10, 0x06, 0x22, 0x6d, 0x0a, 0x08, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12,
	0x18, 0x0a, 0x14, 0x4d, 0x45, 0x54, 0x41, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x18, 0x0a, 0x14, 0x49, 0x4e, 0x43,
	0x4c, 0x55, 0x44, 0x45, 0x5f, 0x41, 0x4c, 0x4c, 0x5f, 0x4d, 0x45, 0x54, 0x41, 0x44, 0x41, 0x54,
	0x41, 0x10, 0x01, 0x12, 0x18, 0x0a, 0x14, 0x45, 0x58, 0x43, 0x4c, 0x55, 0x44, 0x45, 0x5f, 0x41,
	0x4c, 0x4c, 0x5f, 0x4d, 0x45, 0x54, 0x41, 0x44, 0x41, 0x54, 0x41, 0x10, 0x02, 0x12, 0x13, 0x0a,
	0x0f, 0x43, 0x55, 0x53, 0x54, 0x4f, 0x4d, 0x5f, 0x4d, 0x45, 0x54, 0x41, 0x44, 0x41, 0x54, 0x41,
	0x10, 0x03, 0x22, 0x87, 0x01, 0x0a, 0x14, 0x43, 0x72, 0x6f, 0x73, 0x73, 0x50, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x26, 0x0a, 0x22, 0x43,
	0x52, 0x4f, 0x53, 0x53, 0x5f, 0x50, 0x52, 0x4f, 0x4a, 0x45, 0x43, 0x54, 0x5f, 0x4d, 0x45, 0x54,
	0x41, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x22, 0x0a, 0x1e, 0x43, 0x52, 0x4f, 0x53, 0x53, 0x5f, 0x50, 0x52, 0x4f,
	0x4a, 0x45, 0x43, 0x54, 0x5f, 0x4d, 0x45, 0x54, 0x41, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x45, 0x4e,
	0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x01, 0x12, 0x23, 0x0a, 0x1f, 0x43, 0x52, 0x4f, 0x53, 0x53,
	0x5f, 0x50, 0x52, 0x4f, 0x4a, 0x45, 0x43, 0x54, 0x5f, 0x4d, 0x45, 0x54, 0x41, 0x44, 0x41, 0x54,
	0x41, 0x5f, 0x44, 0x49, 0x53, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x22, 0x7c, 0x0a, 0x13,
	0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x12, 0x25, 0x0a, 0x21, 0x54, 0x41, 0x52, 0x47, 0x45, 0x54, 0x5f, 0x52, 0x45,
	0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1a, 0x0a, 0x16, 0x54, 0x41,
	0x52, 0x47, 0x45, 0x54, 0x5f, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x45, 0x58,
	0x49, 0x53, 0x54, 0x53, 0x10, 0x01, 0x12, 0x22, 0x0a, 0x1e, 0x54, 0x41, 0x52, 0x47, 0x45, 0x54,
	0x5f, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x44, 0x4f, 0x45, 0x53, 0x5f, 0x4e,
	0x4f, 0x54, 0x5f, 0x45, 0x58, 0x49, 0x53, 0x54, 0x10, 0x02, 0x3a, 0x8f, 0x02, 0xea, 0x41, 0x8b,
	0x02, 0x0a, 0x32, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x56, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x51, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x76,
	0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x73, 0x2f, 0x7b, 0x76, 0x70, 0x63, 0x5f, 0x66, 0x6c, 0x6f, 0x77, 0x5f, 0x6c, 0x6f, 0x67, 0x73,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x7d, 0x12, 0x5b, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x76, 0x70, 0x63, 0x46,
	0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x7b,
	0x76, 0x70, 0x63, 0x5f, 0x66, 0x6c, 0x6f, 0x77, 0x5f, 0x6c, 0x6f, 0x67, 0x73, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x7d, 0x2a, 0x12, 0x76, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f,
	0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x32, 0x11, 0x76, 0x70, 0x63, 0x46, 0x6c,
	0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x11, 0x0a, 0x0f,
	0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42,
	0x0e, 0x0a, 0x0c, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x42,
	0x08, 0x0a, 0x06, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x42, 0x17, 0x0a, 0x15, 0x5f, 0x61, 0x67,
	0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76,
	0x61, 0x6c, 0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x66, 0x6c, 0x6f, 0x77, 0x5f, 0x73, 0x61, 0x6d, 0x70,
	0x6c, 0x69, 0x6e, 0x67, 0x42, 0x0b, 0x0a, 0x09, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x5f, 0x65, 0x78, 0x70,
	0x72, 0x42, 0x19, 0x0a, 0x17, 0x5f, 0x63, 0x72, 0x6f, 0x73, 0x73, 0x5f, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x18, 0x0a, 0x16,
	0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x22, 0xf7, 0x08, 0x0a, 0x1a, 0x45, 0x66, 0x66, 0x65, 0x63,
	0x74, 0x69, 0x76, 0x65, 0x56, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x55, 0x0a, 0x05, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x70, 0x63,
	0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x48, 0x01, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x88, 0x01, 0x01,
	0x12, 0x80, 0x01, 0x0a, 0x14, 0x61, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x2e, 0x76, 0x31, 0x2e, 0x56, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x48, 0x02, 0x52, 0x13, 0x61, 0x67, 0x67,
	0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c,
	0x88, 0x01, 0x01, 0x12, 0x28, 0x0a, 0x0d, 0x66, 0x6c, 0x6f, 0x77, 0x5f, 0x73, 0x61, 0x6d, 0x70,
	0x6c, 0x69, 0x6e, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x02, 0x48, 0x03, 0x52, 0x0c, 0x66, 0x6c,
	0x6f, 0x77, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x69, 0x6e, 0x67, 0x88, 0x01, 0x01, 0x12, 0x5e, 0x0a,
	0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x2e, 0x76, 0x31, 0x2e, 0x56, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x48, 0x04,
	0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x88, 0x01, 0x01, 0x12, 0x27, 0x0a,
	0x0f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73,
	0x18, 0x07, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0e, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x46, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x12, 0x24, 0x0a, 0x0b, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x5f, 0x65, 0x78, 0x70, 0x72, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x48, 0x05, 0x52, 0x0a, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x45, 0x78, 0x70, 0x72, 0x88, 0x01, 0x01, 0x12, 0x84, 0x01, 0x0a,
	0x16, 0x63, 0x72, 0x6f, 0x73, 0x73, 0x5f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x6d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x49, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76,
	0x31, 0x2e, 0x56, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x43, 0x72, 0x6f, 0x73, 0x73, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x48, 0x06, 0x52, 0x14, 0x63, 0x72, 0x6f, 0x73,
	0x73, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x88, 0x01, 0x01, 0x12, 0x1a, 0x0a, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x64,
	0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12,
	0x18, 0x0a, 0x06, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x18, 0x65, 0x20, 0x01, 0x28, 0x09, 0x48,
	0x00, 0x52, 0x06, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x12, 0x39, 0x0a, 0x17, 0x69, 0x6e, 0x74,
	0x65, 0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x5f, 0x61, 0x74, 0x74, 0x61, 0x63, 0x68,
	0x6d, 0x65, 0x6e, 0x74, 0x18, 0x66, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x16, 0x69, 0x6e,
	0x74, 0x65, 0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68,
	0x6d, 0x65, 0x6e, 0x74, 0x12, 0x1f, 0x0a, 0x0a, 0x76, 0x70, 0x6e, 0x5f, 0x74, 0x75, 0x6e, 0x6e,
	0x65, 0x6c, 0x18, 0x67, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x09, 0x76, 0x70, 0x6e, 0x54,
	0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x12, 0x5e, 0x0a, 0x05, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x18, 0x0c,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69,
	0x76, 0x65, 0x56, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x53, 0x63, 0x6f, 0x70, 0x65, 0x48, 0x07, 0x52, 0x05, 0x73, 0x63, 0x6f,
	0x70, 0x65, 0x88, 0x01, 0x01, 0x22, 0x8e, 0x01, 0x0a, 0x05, 0x53, 0x63, 0x6f, 0x70, 0x65, 0x12,
	0x15, 0x0a, 0x11, 0x53, 0x43, 0x4f, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x55, 0x42, 0x4e, 0x45, 0x54,
	0x10, 0x01, 0x12, 0x16, 0x0a, 0x12, 0x43, 0x4f, 0x4d, 0x50, 0x55, 0x54, 0x45, 0x5f, 0x41, 0x50,
	0x49, 0x5f, 0x53, 0x55, 0x42, 0x4e, 0x45, 0x54, 0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07, 0x4e, 0x45,
	0x54, 0x57, 0x4f, 0x52, 0x4b, 0x10, 0x03, 0x12, 0x0e, 0x0a, 0x0a, 0x56, 0x50, 0x4e, 0x5f, 0x54,
	0x55, 0x4e, 0x4e, 0x45, 0x4c, 0x10, 0x04, 0x12, 0x1b, 0x0a, 0x17, 0x49, 0x4e, 0x54, 0x45, 0x52,
	0x43, 0x4f, 0x4e, 0x4e, 0x45, 0x43, 0x54, 0x5f, 0x41, 0x54, 0x54, 0x41, 0x43, 0x48, 0x4d, 0x45,
	0x4e, 0x54, 0x10, 0x05, 0x12, 0x10, 0x0a, 0x0c, 0x4f, 0x52, 0x47, 0x41, 0x4e, 0x49, 0x5a, 0x41,
	0x54, 0x49, 0x4f, 0x4e, 0x10, 0x06, 0x42, 0x11, 0x0a, 0x0f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x42, 0x17, 0x0a, 0x15, 0x5f, 0x61, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x42, 0x10, 0x0a, 0x0e,
	0x5f, 0x66, 0x6c, 0x6f, 0x77, 0x5f, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x69, 0x6e, 0x67, 0x42, 0x0b,
	0x0a, 0x09, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x0e, 0x0a, 0x0c, 0x5f,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x5f, 0x65, 0x78, 0x70, 0x72, 0x42, 0x19, 0x0a, 0x17, 0x5f,
	0x63, 0x72, 0x6f, 0x73, 0x73, 0x5f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x6d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x73, 0x63, 0x6f, 0x70, 0x65,
	0x42, 0xf2, 0x02, 0xea, 0x41, 0x6a, 0x0a, 0x35, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x31, 0x6f,
	0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6f, 0x72,
	0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d,
	0x0a, 0x25, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x42, 0x16, 0x56, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77,
	0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50,
	0x01, 0x5a, 0x53, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x70, 0x62, 0x3b, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x70, 0x62, 0xaa, 0x02, 0x21, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x4d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x21, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5c, 0x56, 0x31, 0xea, 0x02,
	0x24, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a,
	0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_networkmanagement_v1_vpc_flow_logs_config_proto_rawDescOnce sync.Once
	file_google_cloud_networkmanagement_v1_vpc_flow_logs_config_proto_rawDescData = file_google_cloud_networkmanagement_v1_vpc_flow_logs_config_proto_rawDesc
)

func file_google_cloud_networkmanagement_v1_vpc_flow_logs_config_proto_rawDescGZIP() []byte {
	file_google_cloud_networkmanagement_v1_vpc_flow_logs_config_proto_rawDescOnce.Do(func() {
		file_google_cloud_networkmanagement_v1_vpc_flow_logs_config_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_networkmanagement_v1_vpc_flow_logs_config_proto_rawDescData)
	})
	return file_google_cloud_networkmanagement_v1_vpc_flow_logs_config_proto_rawDescData
}

var file_google_cloud_networkmanagement_v1_vpc_flow_logs_config_proto_enumTypes = make([]protoimpl.EnumInfo, 6)
var file_google_cloud_networkmanagement_v1_vpc_flow_logs_config_proto_msgTypes = make([]protoimpl.MessageInfo, 3)
var file_google_cloud_networkmanagement_v1_vpc_flow_logs_config_proto_goTypes = []any{
	(VpcFlowLogsConfig_State)(0),                // 0: google.cloud.networkmanagement.v1.VpcFlowLogsConfig.State
	(VpcFlowLogsConfig_AggregationInterval)(0),  // 1: google.cloud.networkmanagement.v1.VpcFlowLogsConfig.AggregationInterval
	(VpcFlowLogsConfig_Metadata)(0),             // 2: google.cloud.networkmanagement.v1.VpcFlowLogsConfig.Metadata
	(VpcFlowLogsConfig_CrossProjectMetadata)(0), // 3: google.cloud.networkmanagement.v1.VpcFlowLogsConfig.CrossProjectMetadata
	(VpcFlowLogsConfig_TargetResourceState)(0),  // 4: google.cloud.networkmanagement.v1.VpcFlowLogsConfig.TargetResourceState
	(EffectiveVpcFlowLogsConfig_Scope)(0),       // 5: google.cloud.networkmanagement.v1.EffectiveVpcFlowLogsConfig.Scope
	(*VpcFlowLogsConfig)(nil),                   // 6: google.cloud.networkmanagement.v1.VpcFlowLogsConfig
	(*EffectiveVpcFlowLogsConfig)(nil),          // 7: google.cloud.networkmanagement.v1.EffectiveVpcFlowLogsConfig
	nil,                                         // 8: google.cloud.networkmanagement.v1.VpcFlowLogsConfig.LabelsEntry
	(*timestamppb.Timestamp)(nil),               // 9: google.protobuf.Timestamp
}
var file_google_cloud_networkmanagement_v1_vpc_flow_logs_config_proto_depIdxs = []int32{
	0,  // 0: google.cloud.networkmanagement.v1.VpcFlowLogsConfig.state:type_name -> google.cloud.networkmanagement.v1.VpcFlowLogsConfig.State
	1,  // 1: google.cloud.networkmanagement.v1.VpcFlowLogsConfig.aggregation_interval:type_name -> google.cloud.networkmanagement.v1.VpcFlowLogsConfig.AggregationInterval
	2,  // 2: google.cloud.networkmanagement.v1.VpcFlowLogsConfig.metadata:type_name -> google.cloud.networkmanagement.v1.VpcFlowLogsConfig.Metadata
	3,  // 3: google.cloud.networkmanagement.v1.VpcFlowLogsConfig.cross_project_metadata:type_name -> google.cloud.networkmanagement.v1.VpcFlowLogsConfig.CrossProjectMetadata
	4,  // 4: google.cloud.networkmanagement.v1.VpcFlowLogsConfig.target_resource_state:type_name -> google.cloud.networkmanagement.v1.VpcFlowLogsConfig.TargetResourceState
	8,  // 5: google.cloud.networkmanagement.v1.VpcFlowLogsConfig.labels:type_name -> google.cloud.networkmanagement.v1.VpcFlowLogsConfig.LabelsEntry
	9,  // 6: google.cloud.networkmanagement.v1.VpcFlowLogsConfig.create_time:type_name -> google.protobuf.Timestamp
	9,  // 7: google.cloud.networkmanagement.v1.VpcFlowLogsConfig.update_time:type_name -> google.protobuf.Timestamp
	0,  // 8: google.cloud.networkmanagement.v1.EffectiveVpcFlowLogsConfig.state:type_name -> google.cloud.networkmanagement.v1.VpcFlowLogsConfig.State
	1,  // 9: google.cloud.networkmanagement.v1.EffectiveVpcFlowLogsConfig.aggregation_interval:type_name -> google.cloud.networkmanagement.v1.VpcFlowLogsConfig.AggregationInterval
	2,  // 10: google.cloud.networkmanagement.v1.EffectiveVpcFlowLogsConfig.metadata:type_name -> google.cloud.networkmanagement.v1.VpcFlowLogsConfig.Metadata
	3,  // 11: google.cloud.networkmanagement.v1.EffectiveVpcFlowLogsConfig.cross_project_metadata:type_name -> google.cloud.networkmanagement.v1.VpcFlowLogsConfig.CrossProjectMetadata
	5,  // 12: google.cloud.networkmanagement.v1.EffectiveVpcFlowLogsConfig.scope:type_name -> google.cloud.networkmanagement.v1.EffectiveVpcFlowLogsConfig.Scope
	13, // [13:13] is the sub-list for method output_type
	13, // [13:13] is the sub-list for method input_type
	13, // [13:13] is the sub-list for extension type_name
	13, // [13:13] is the sub-list for extension extendee
	0,  // [0:13] is the sub-list for field type_name
}

func init() { file_google_cloud_networkmanagement_v1_vpc_flow_logs_config_proto_init() }
func file_google_cloud_networkmanagement_v1_vpc_flow_logs_config_proto_init() {
	if File_google_cloud_networkmanagement_v1_vpc_flow_logs_config_proto != nil {
		return
	}
	file_google_cloud_networkmanagement_v1_vpc_flow_logs_config_proto_msgTypes[0].OneofWrappers = []any{
		(*VpcFlowLogsConfig_Network)(nil),
		(*VpcFlowLogsConfig_Subnet)(nil),
		(*VpcFlowLogsConfig_InterconnectAttachment)(nil),
		(*VpcFlowLogsConfig_VpnTunnel)(nil),
	}
	file_google_cloud_networkmanagement_v1_vpc_flow_logs_config_proto_msgTypes[1].OneofWrappers = []any{
		(*EffectiveVpcFlowLogsConfig_Network)(nil),
		(*EffectiveVpcFlowLogsConfig_Subnet)(nil),
		(*EffectiveVpcFlowLogsConfig_InterconnectAttachment)(nil),
		(*EffectiveVpcFlowLogsConfig_VpnTunnel)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_networkmanagement_v1_vpc_flow_logs_config_proto_rawDesc,
			NumEnums:      6,
			NumMessages:   3,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_networkmanagement_v1_vpc_flow_logs_config_proto_goTypes,
		DependencyIndexes: file_google_cloud_networkmanagement_v1_vpc_flow_logs_config_proto_depIdxs,
		EnumInfos:         file_google_cloud_networkmanagement_v1_vpc_flow_logs_config_proto_enumTypes,
		MessageInfos:      file_google_cloud_networkmanagement_v1_vpc_flow_logs_config_proto_msgTypes,
	}.Build()
	File_google_cloud_networkmanagement_v1_vpc_flow_logs_config_proto = out.File
	file_google_cloud_networkmanagement_v1_vpc_flow_logs_config_proto_rawDesc = nil
	file_google_cloud_networkmanagement_v1_vpc_flow_logs_config_proto_goTypes = nil
	file_google_cloud_networkmanagement_v1_vpc_flow_logs_config_proto_depIdxs = nil
}
