// Licensed to Elasticsearch B.V. under one or more contributor
// license agreements. See the NOTICE file distributed with
// this work for additional information regarding copyright
// ownership. Elasticsearch B.V. licenses this file to you under
// the Apache License, Version 2.0 (the "License"); you may
// not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// Code generated by mk_audit_arches.pl  - DO NOT EDIT.

// +build ignore

package auparse

/*
#include <audit.h>
*/
import "C"

import "fmt"

// AuditArch represents a machine architecture (i.e. arm, ppc, x86_64).
type AuditArch uint32

// List of architectures constants used by then kernel.
const (
	AUDIT_ARCH_AARCH64     AuditArch = C.AUDIT_ARCH_AARCH64
	AUDIT_ARCH_ARM         AuditArch = C.AUDIT_ARCH_ARM
	AUDIT_ARCH_ARMEB       AuditArch = C.AUDIT_ARCH_ARMEB
	AUDIT_ARCH_CRIS        AuditArch = C.AUDIT_ARCH_CRIS
	AUDIT_ARCH_FRV         AuditArch = C.AUDIT_ARCH_FRV
	AUDIT_ARCH_I386        AuditArch = C.AUDIT_ARCH_I386
	AUDIT_ARCH_IA64        AuditArch = C.AUDIT_ARCH_IA64
	AUDIT_ARCH_M32R        AuditArch = C.AUDIT_ARCH_M32R
	AUDIT_ARCH_M68K        AuditArch = C.AUDIT_ARCH_M68K
	AUDIT_ARCH_MIPS        AuditArch = C.AUDIT_ARCH_MIPS
	AUDIT_ARCH_MIPS64      AuditArch = C.AUDIT_ARCH_MIPS64
	AUDIT_ARCH_MIPS64N32   AuditArch = C.AUDIT_ARCH_MIPS64N32
	AUDIT_ARCH_MIPSEL      AuditArch = C.AUDIT_ARCH_MIPSEL
	AUDIT_ARCH_MIPSEL64    AuditArch = C.AUDIT_ARCH_MIPSEL64
	AUDIT_ARCH_MIPSEL64N32 AuditArch = C.AUDIT_ARCH_MIPSEL64N32
	AUDIT_ARCH_PARISC      AuditArch = C.AUDIT_ARCH_PARISC
	AUDIT_ARCH_PARISC64    AuditArch = C.AUDIT_ARCH_PARISC64
	AUDIT_ARCH_PPC         AuditArch = C.AUDIT_ARCH_PPC
	AUDIT_ARCH_PPC64       AuditArch = C.AUDIT_ARCH_PPC64
	AUDIT_ARCH_PPC64LE     AuditArch = C.AUDIT_ARCH_PPC64LE
	AUDIT_ARCH_S390        AuditArch = C.AUDIT_ARCH_S390
	AUDIT_ARCH_S390X       AuditArch = C.AUDIT_ARCH_S390X
	AUDIT_ARCH_SH          AuditArch = C.AUDIT_ARCH_SH
	AUDIT_ARCH_SH64        AuditArch = C.AUDIT_ARCH_SH64
	AUDIT_ARCH_SHEL        AuditArch = C.AUDIT_ARCH_SHEL
	AUDIT_ARCH_SHEL64      AuditArch = C.AUDIT_ARCH_SHEL64
	AUDIT_ARCH_SPARC       AuditArch = C.AUDIT_ARCH_SPARC
	AUDIT_ARCH_SPARC64     AuditArch = C.AUDIT_ARCH_SPARC64
	AUDIT_ARCH_X86_64      AuditArch = C.AUDIT_ARCH_X86_64
)

var AuditArchNames = map[AuditArch]string{
	AUDIT_ARCH_AARCH64:     "aarch64",
	AUDIT_ARCH_ARM:         "arm",
	AUDIT_ARCH_ARMEB:       "armeb",
	AUDIT_ARCH_CRIS:        "cris",
	AUDIT_ARCH_FRV:         "frv",
	AUDIT_ARCH_I386:        "i386",
	AUDIT_ARCH_IA64:        "ia64",
	AUDIT_ARCH_M32R:        "m32r",
	AUDIT_ARCH_M68K:        "m68k",
	AUDIT_ARCH_MIPS:        "mips",
	AUDIT_ARCH_MIPS64:      "mips64",
	AUDIT_ARCH_MIPS64N32:   "mips64n32",
	AUDIT_ARCH_MIPSEL:      "mipsel",
	AUDIT_ARCH_MIPSEL64:    "mipsel64",
	AUDIT_ARCH_MIPSEL64N32: "mipsel64n32",
	AUDIT_ARCH_PARISC:      "parisc",
	AUDIT_ARCH_PARISC64:    "parisc64",
	AUDIT_ARCH_PPC:         "ppc",
	AUDIT_ARCH_PPC64:       "ppc64",
	AUDIT_ARCH_PPC64LE:     "ppc64le",
	AUDIT_ARCH_S390:        "s390",
	AUDIT_ARCH_S390X:       "s390x",
	AUDIT_ARCH_SH:          "sh",
	AUDIT_ARCH_SH64:        "sh64",
	AUDIT_ARCH_SHEL:        "shel",
	AUDIT_ARCH_SHEL64:      "shel64",
	AUDIT_ARCH_SPARC:       "sparc",
	AUDIT_ARCH_SPARC64:     "sparc64",
	AUDIT_ARCH_X86_64:      "x86_64",
}

func (a AuditArch) String() string {
	name, found := AuditArchNames[a]
	if found {
		return name
	}

	return fmt.Sprintf("unknown[%x]", uint32(a))
}
