package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SaveApConfig invokes the cloudwf.SaveApConfig API synchronously
// api document: https://help.aliyun.com/api/cloudwf/saveapconfig.html
func (client *Client) SaveApConfig(request *SaveApConfigRequest) (response *SaveApConfigResponse, err error) {
	response = CreateSaveApConfigResponse()
	err = client.DoAction(request, response)
	return
}

// SaveApConfigWithChan invokes the cloudwf.SaveApConfig API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/saveapconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SaveApConfigWithChan(request *SaveApConfigRequest) (<-chan *SaveApConfigResponse, <-chan error) {
	responseChan := make(chan *SaveApConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SaveApConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SaveApConfigWithCallback invokes the cloudwf.SaveApConfig API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/saveapconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SaveApConfigWithCallback(request *SaveApConfigRequest, callback func(response *SaveApConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SaveApConfigResponse
		var err error
		defer close(result)
		response, err = client.SaveApConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SaveApConfigRequest is the request struct for api SaveApConfig
type SaveApConfigRequest struct {
	*requests.RpcRequest
	Country     string           `position:"Query" name:"Country"`
	ApAssetId   requests.Integer `position:"Query" name:"ApAssetId"`
	LogLevel    requests.Integer `position:"Query" name:"LogLevel"`
	Name        string           `position:"Query" name:"Name"`
	EchoInt     requests.Integer `position:"Query" name:"EchoInt"`
	Scan        requests.Integer `position:"Query" name:"Scan"`
	Description string           `position:"Query" name:"Description"`
	Id          requests.Integer `position:"Query" name:"Id"`
	Dai         string           `position:"Query" name:"Dai"`
	LogIp       string           `position:"Query" name:"LogIp"`
	Mac         string           `position:"Query" name:"Mac"`
}

// SaveApConfigResponse is the response struct for api SaveApConfig
type SaveApConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateSaveApConfigRequest creates a request to invoke SaveApConfig API
func CreateSaveApConfigRequest() (request *SaveApConfigRequest) {
	request = &SaveApConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "SaveApConfig", "cloudwf", "openAPI")
	return
}

// CreateSaveApConfigResponse creates a response to parse from SaveApConfig response
func CreateSaveApConfigResponse() (response *SaveApConfigResponse) {
	response = &SaveApConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
