package ddosbgp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeResourcePackUsage invokes the ddosbgp.DescribeResourcePackUsage API synchronously
// api document: https://help.aliyun.com/api/ddosbgp/describeresourcepackusage.html
func (client *Client) DescribeResourcePackUsage(request *DescribeResourcePackUsageRequest) (response *DescribeResourcePackUsageResponse, err error) {
	response = CreateDescribeResourcePackUsageResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeResourcePackUsageWithChan invokes the ddosbgp.DescribeResourcePackUsage API asynchronously
// api document: https://help.aliyun.com/api/ddosbgp/describeresourcepackusage.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeResourcePackUsageWithChan(request *DescribeResourcePackUsageRequest) (<-chan *DescribeResourcePackUsageResponse, <-chan error) {
	responseChan := make(chan *DescribeResourcePackUsageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeResourcePackUsage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeResourcePackUsageWithCallback invokes the ddosbgp.DescribeResourcePackUsage API asynchronously
// api document: https://help.aliyun.com/api/ddosbgp/describeresourcepackusage.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeResourcePackUsageWithCallback(request *DescribeResourcePackUsageRequest, callback func(response *DescribeResourcePackUsageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeResourcePackUsageResponse
		var err error
		defer close(result)
		response, err = client.DescribeResourcePackUsage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeResourcePackUsageRequest is the request struct for api DescribeResourcePackUsage
type DescribeResourcePackUsageRequest struct {
	*requests.RpcRequest
	EndTime         requests.Integer `position:"Query" name:"EndTime"`
	StartTime       requests.Integer `position:"Query" name:"StartTime"`
	ResourceGroupId string           `position:"Query" name:"ResourceGroupId"`
	InstanceId      string           `position:"Query" name:"InstanceId"`
	SourceIp        string           `position:"Query" name:"SourceIp"`
}

// DescribeResourcePackUsageResponse is the response struct for api DescribeResourcePackUsage
type DescribeResourcePackUsageResponse struct {
	*responses.BaseResponse
	RequestId  string      `json:"RequestId" xml:"RequestId"`
	Interval   int64       `json:"Interval" xml:"Interval"`
	StartTime  int64       `json:"StartTime" xml:"StartTime"`
	EndTime    int64       `json:"EndTime" xml:"EndTime"`
	PackUsages []PackUsage `json:"PackUsages" xml:"PackUsages"`
}

// CreateDescribeResourcePackUsageRequest creates a request to invoke DescribeResourcePackUsage API
func CreateDescribeResourcePackUsageRequest() (request *DescribeResourcePackUsageRequest) {
	request = &DescribeResourcePackUsageRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddosbgp", "2018-07-20", "DescribeResourcePackUsage", "ddosbgp", "openAPI")
	return
}

// CreateDescribeResourcePackUsageResponse creates a response to parse from DescribeResourcePackUsage response
func CreateDescribeResourcePackUsageResponse() (response *DescribeResourcePackUsageResponse) {
	response = &DescribeResourcePackUsageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
