package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateDataCorrectOrder invokes the dms_enterprise.CreateDataCorrectOrder API synchronously
func (client *Client) CreateDataCorrectOrder(request *CreateDataCorrectOrderRequest) (response *CreateDataCorrectOrderResponse, err error) {
	response = CreateCreateDataCorrectOrderResponse()
	err = client.DoAction(request, response)
	return
}

// CreateDataCorrectOrderWithChan invokes the dms_enterprise.CreateDataCorrectOrder API asynchronously
func (client *Client) CreateDataCorrectOrderWithChan(request *CreateDataCorrectOrderRequest) (<-chan *CreateDataCorrectOrderResponse, <-chan error) {
	responseChan := make(chan *CreateDataCorrectOrderResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateDataCorrectOrder(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateDataCorrectOrderWithCallback invokes the dms_enterprise.CreateDataCorrectOrder API asynchronously
func (client *Client) CreateDataCorrectOrderWithCallback(request *CreateDataCorrectOrderRequest, callback func(response *CreateDataCorrectOrderResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateDataCorrectOrderResponse
		var err error
		defer close(result)
		response, err = client.CreateDataCorrectOrder(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateDataCorrectOrderRequest is the request struct for api CreateDataCorrectOrder
type CreateDataCorrectOrderRequest struct {
	*requests.RpcRequest
	Tid             requests.Integer            `position:"Query" name:"Tid"`
	AttachmentKey   string                      `position:"Query" name:"AttachmentKey"`
	Param           CreateDataCorrectOrderParam `position:"Query" name:"Param"  type:"Struct"`
	Comment         string                      `position:"Query" name:"Comment"`
	RelatedUserList *[]string                   `position:"Query" name:"RelatedUserList"  type:"Json"`
}

// CreateDataCorrectOrderParam is a repeated param struct in CreateDataCorrectOrderRequest
type CreateDataCorrectOrderParam struct {
	SqlType                string                                       `name:"SqlType"`
	Classify               string                                       `name:"Classify"`
	RollbackSQL            string                                       `name:"RollbackSQL"`
	RollbackSqlType        string                                       `name:"RollbackSqlType"`
	DbItemList             *[]CreateDataCorrectOrderParamDbItemListItem `name:"DbItemList" type:"Repeated"`
	ExecSQL                string                                       `name:"ExecSQL"`
	EstimateAffectRows     string                                       `name:"EstimateAffectRows"`
	RollbackAttachmentName string                                       `name:"RollbackAttachmentName"`
	AttachmentName         string                                       `name:"AttachmentName"`
}

// CreateDataCorrectOrderParamDbItemListItem is a repeated param struct in CreateDataCorrectOrderRequest
type CreateDataCorrectOrderParamDbItemListItem struct {
	DbId  string `name:"DbId"`
	Logic string `name:"Logic"`
}

// CreateDataCorrectOrderResponse is the response struct for api CreateDataCorrectOrder
type CreateDataCorrectOrderResponse struct {
	*responses.BaseResponse
	RequestId         string  `json:"RequestId" xml:"RequestId"`
	Success           bool    `json:"Success" xml:"Success"`
	ErrorMessage      string  `json:"ErrorMessage" xml:"ErrorMessage"`
	ErrorCode         string  `json:"ErrorCode" xml:"ErrorCode"`
	CreateOrderResult []int64 `json:"CreateOrderResult" xml:"CreateOrderResult"`
}

// CreateCreateDataCorrectOrderRequest creates a request to invoke CreateDataCorrectOrder API
func CreateCreateDataCorrectOrderRequest() (request *CreateDataCorrectOrderRequest) {
	request = &CreateDataCorrectOrderRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "CreateDataCorrectOrder", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateDataCorrectOrderResponse creates a response to parse from CreateDataCorrectOrder response
func CreateCreateDataCorrectOrderResponse() (response *CreateDataCorrectOrderResponse) {
	response = &CreateDataCorrectOrderResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
