package teslastream

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetJobTopology invokes the teslastream.GetJobTopology API synchronously
// api document: https://help.aliyun.com/api/teslastream/getjobtopology.html
func (client *Client) GetJobTopology(request *GetJobTopologyRequest) (response *GetJobTopologyResponse, err error) {
	response = CreateGetJobTopologyResponse()
	err = client.DoAction(request, response)
	return
}

// GetJobTopologyWithChan invokes the teslastream.GetJobTopology API asynchronously
// api document: https://help.aliyun.com/api/teslastream/getjobtopology.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetJobTopologyWithChan(request *GetJobTopologyRequest) (<-chan *GetJobTopologyResponse, <-chan error) {
	responseChan := make(chan *GetJobTopologyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetJobTopology(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetJobTopologyWithCallback invokes the teslastream.GetJobTopology API asynchronously
// api document: https://help.aliyun.com/api/teslastream/getjobtopology.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetJobTopologyWithCallback(request *GetJobTopologyRequest, callback func(response *GetJobTopologyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetJobTopologyResponse
		var err error
		defer close(result)
		response, err = client.GetJobTopology(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetJobTopologyRequest is the request struct for api GetJobTopology
type GetJobTopologyRequest struct {
	*requests.RpcRequest
	JobName string `position:"Query" name:"JobName"`
}

// GetJobTopologyResponse is the response struct for api GetJobTopology
type GetJobTopologyResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      []Job  `json:"Data" xml:"Data"`
}

// CreateGetJobTopologyRequest creates a request to invoke GetJobTopology API
func CreateGetJobTopologyRequest() (request *GetJobTopologyRequest) {
	request = &GetJobTopologyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("TeslaStream", "2018-01-15", "GetJobTopology", "teslastream", "openAPI")
	return
}

// CreateGetJobTopologyResponse creates a response to parse from GetJobTopology response
func CreateGetJobTopologyResponse() (response *GetJobTopologyResponse) {
	response = &GetJobTopologyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
