package uis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeHighPriorityIp invokes the uis.DescribeHighPriorityIp API synchronously
// api document: https://help.aliyun.com/api/uis/describehighpriorityip.html
func (client *Client) DescribeHighPriorityIp(request *DescribeHighPriorityIpRequest) (response *DescribeHighPriorityIpResponse, err error) {
	response = CreateDescribeHighPriorityIpResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeHighPriorityIpWithChan invokes the uis.DescribeHighPriorityIp API asynchronously
// api document: https://help.aliyun.com/api/uis/describehighpriorityip.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeHighPriorityIpWithChan(request *DescribeHighPriorityIpRequest) (<-chan *DescribeHighPriorityIpResponse, <-chan error) {
	responseChan := make(chan *DescribeHighPriorityIpResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeHighPriorityIp(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeHighPriorityIpWithCallback invokes the uis.DescribeHighPriorityIp API asynchronously
// api document: https://help.aliyun.com/api/uis/describehighpriorityip.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeHighPriorityIpWithCallback(request *DescribeHighPriorityIpRequest, callback func(response *DescribeHighPriorityIpResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeHighPriorityIpResponse
		var err error
		defer close(result)
		response, err = client.DescribeHighPriorityIp(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeHighPriorityIpRequest is the request struct for api DescribeHighPriorityIp
type DescribeHighPriorityIpRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	HighPriorityIp       string           `position:"Query" name:"HighPriorityIp"`
	UisId                string           `position:"Query" name:"UisId"`
	PageSize             requests.Integer `position:"Query" name:"PageSize"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	PageNumber           requests.Integer `position:"Query" name:"PageNumber"`
}

// DescribeHighPriorityIpResponse is the response struct for api DescribeHighPriorityIp
type DescribeHighPriorityIpResponse struct {
	*responses.BaseResponse
	RequestId       string          `json:"RequestId" xml:"RequestId"`
	TotalCount      int             `json:"TotalCount" xml:"TotalCount"`
	PageNumber      int             `json:"PageNumber" xml:"PageNumber"`
	PageSize        int             `json:"PageSize" xml:"PageSize"`
	HighPriorityIps HighPriorityIps `json:"HighPriorityIps" xml:"HighPriorityIps"`
}

// CreateDescribeHighPriorityIpRequest creates a request to invoke DescribeHighPriorityIp API
func CreateDescribeHighPriorityIpRequest() (request *DescribeHighPriorityIpRequest) {
	request = &DescribeHighPriorityIpRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Uis", "2018-08-21", "DescribeHighPriorityIp", "uis", "openAPI")
	return
}

// CreateDescribeHighPriorityIpResponse creates a response to parse from DescribeHighPriorityIp response
func CreateDescribeHighPriorityIpResponse() (response *DescribeHighPriorityIpResponse) {
	response = &DescribeHighPriorityIpResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
