package vod

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateStreamInfo invokes the vod.UpdateStreamInfo API synchronously
func (client *Client) UpdateStreamInfo(request *UpdateStreamInfoRequest) (response *UpdateStreamInfoResponse, err error) {
	response = CreateUpdateStreamInfoResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateStreamInfoWithChan invokes the vod.UpdateStreamInfo API asynchronously
func (client *Client) UpdateStreamInfoWithChan(request *UpdateStreamInfoRequest) (<-chan *UpdateStreamInfoResponse, <-chan error) {
	responseChan := make(chan *UpdateStreamInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateStreamInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateStreamInfoWithCallback invokes the vod.UpdateStreamInfo API asynchronously
func (client *Client) UpdateStreamInfoWithCallback(request *UpdateStreamInfoRequest, callback func(response *UpdateStreamInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateStreamInfoResponse
		var err error
		defer close(result)
		response, err = client.UpdateStreamInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateStreamInfoRequest is the request struct for api UpdateStreamInfo
type UpdateStreamInfoRequest struct {
	*requests.RpcRequest
	JobId      string `position:"Query" name:"JobId"`
	HDRType    string `position:"Query" name:"HDRType"`
	Definition string `position:"Query" name:"Definition"`
	MediaId    string `position:"Query" name:"MediaId"`
}

// UpdateStreamInfoResponse is the response struct for api UpdateStreamInfo
type UpdateStreamInfoResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateStreamInfoRequest creates a request to invoke UpdateStreamInfo API
func CreateUpdateStreamInfoRequest() (request *UpdateStreamInfoRequest) {
	request = &UpdateStreamInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vod", "2017-03-21", "UpdateStreamInfo", "vod", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateStreamInfoResponse creates a response to parse from UpdateStreamInfo response
func CreateUpdateStreamInfoResponse() (response *UpdateStreamInfoResponse) {
	response = &UpdateStreamInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
