package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DissociateVpnGatewayWithCertificate invokes the vpc.DissociateVpnGatewayWithCertificate API synchronously
func (client *Client) DissociateVpnGatewayWithCertificate(request *DissociateVpnGatewayWithCertificateRequest) (response *DissociateVpnGatewayWithCertificateResponse, err error) {
	response = CreateDissociateVpnGatewayWithCertificateResponse()
	err = client.DoAction(request, response)
	return
}

// DissociateVpnGatewayWithCertificateWithChan invokes the vpc.DissociateVpnGatewayWithCertificate API asynchronously
func (client *Client) DissociateVpnGatewayWithCertificateWithChan(request *DissociateVpnGatewayWithCertificateRequest) (<-chan *DissociateVpnGatewayWithCertificateResponse, <-chan error) {
	responseChan := make(chan *DissociateVpnGatewayWithCertificateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DissociateVpnGatewayWithCertificate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DissociateVpnGatewayWithCertificateWithCallback invokes the vpc.DissociateVpnGatewayWithCertificate API asynchronously
func (client *Client) DissociateVpnGatewayWithCertificateWithCallback(request *DissociateVpnGatewayWithCertificateRequest, callback func(response *DissociateVpnGatewayWithCertificateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DissociateVpnGatewayWithCertificateResponse
		var err error
		defer close(result)
		response, err = client.DissociateVpnGatewayWithCertificate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DissociateVpnGatewayWithCertificateRequest is the request struct for api DissociateVpnGatewayWithCertificate
type DissociateVpnGatewayWithCertificateRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	DryRun          requests.Boolean `position:"Query" name:"DryRun"`
	ClientToken     string           `position:"Query" name:"ClientToken"`
	CertificateId   string           `position:"Query" name:"CertificateId"`
	VpnGatewayId    string           `position:"Query" name:"VpnGatewayId"`
	CallerBid       string           `position:"Query" name:"callerBid"`
	CertificateType string           `position:"Query" name:"CertificateType"`
}

// DissociateVpnGatewayWithCertificateResponse is the response struct for api DissociateVpnGatewayWithCertificate
type DissociateVpnGatewayWithCertificateResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDissociateVpnGatewayWithCertificateRequest creates a request to invoke DissociateVpnGatewayWithCertificate API
func CreateDissociateVpnGatewayWithCertificateRequest() (request *DissociateVpnGatewayWithCertificateRequest) {
	request = &DissociateVpnGatewayWithCertificateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "DissociateVpnGatewayWithCertificate", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDissociateVpnGatewayWithCertificateResponse creates a response to parse from DissociateVpnGatewayWithCertificate response
func CreateDissociateVpnGatewayWithCertificateResponse() (response *DissociateVpnGatewayWithCertificateResponse) {
	response = &DissociateVpnGatewayWithCertificateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
