/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import com.google.common.collect.ImmutableSortedMap;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Duration;
import java.util.Map;
import java.util.function.Supplier;
import org.gradle.internal.execution.ExecutionEngine;
import org.gradle.internal.execution.OutputChangeListener;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.WorkInputListeners;
import org.gradle.internal.execution.history.ExecutionInputState;
import org.gradle.internal.execution.history.ExecutionOutputState;
import org.gradle.internal.execution.history.OutputsCleaner;
import org.gradle.internal.execution.steps.AbstractSkipEmptyWorkStep;
import org.gradle.internal.execution.steps.CachingResult;
import org.gradle.internal.execution.steps.PreviousExecutionContext;
import org.gradle.internal.execution.steps.Step;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileCollectionFingerprint;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.SnapshotUtil;
import org.gradle.internal.snapshot.ValueSnapshot;
import org.gradle.internal.time.Time;
import org.gradle.internal.time.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkipEmptyIncrementalWorkStep
extends AbstractSkipEmptyWorkStep<PreviousExecutionContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SkipEmptyIncrementalWorkStep.class);
    private final OutputChangeListener outputChangeListener;
    private final Supplier<OutputsCleaner> outputsCleanerSupplier;

    public SkipEmptyIncrementalWorkStep(OutputChangeListener outputChangeListener, WorkInputListeners workInputListeners, Supplier<OutputsCleaner> outputsCleanerSupplier, Step<? super PreviousExecutionContext, ? extends CachingResult> delegate) {
        super(workInputListeners, delegate);
        this.outputChangeListener = outputChangeListener;
        this.outputsCleanerSupplier = outputsCleanerSupplier;
    }

    @Override
    protected PreviousExecutionContext recreateContextWithNewInputFiles(PreviousExecutionContext context, final ImmutableSortedMap<String, CurrentFileCollectionFingerprint> inputFiles) {
        return new PreviousExecutionContext(context){

            @Override
            public ImmutableSortedMap<String, CurrentFileCollectionFingerprint> getInputFileProperties() {
                return inputFiles;
            }
        };
    }

    @Override
    protected ImmutableSortedMap<String, ValueSnapshot> getKnownInputProperties(PreviousExecutionContext context) {
        return context.getPreviousExecutionState().map(ExecutionInputState::getInputProperties).orElse(ImmutableSortedMap.of());
    }

    @Override
    protected ImmutableSortedMap<String, ? extends FileCollectionFingerprint> getKnownInputFileProperties(PreviousExecutionContext context) {
        return context.getPreviousExecutionState().map(ExecutionInputState::getInputFileProperties).orElse(ImmutableSortedMap.of());
    }

    @Override
    protected CachingResult performSkip(UnitOfWork work, PreviousExecutionContext context) {
        ExecutionEngine.ExecutionOutcome skipOutcome;
        ImmutableSortedMap outputFilesAfterPreviousExecution = context.getPreviousExecutionState().map(ExecutionOutputState::getOutputFilesProducedByWork).orElse(ImmutableSortedMap.of());
        Timer timer = Time.startTimer();
        String executionReason = null;
        if (outputFilesAfterPreviousExecution.isEmpty()) {
            LOGGER.info("Skipping {} as it has no source files and no previous output files.", (Object)work.getDisplayName());
            skipOutcome = ExecutionEngine.ExecutionOutcome.SHORT_CIRCUITED;
        } else {
            boolean didWork = this.cleanPreviousOutputs((Map<String, FileSystemSnapshot>)outputFilesAfterPreviousExecution);
            if (didWork) {
                LOGGER.info("Cleaned previous output of {} as it has no source files.", (Object)work.getDisplayName());
                skipOutcome = ExecutionEngine.ExecutionOutcome.EXECUTED_NON_INCREMENTALLY;
                executionReason = "Cleaned previous output";
            } else {
                skipOutcome = ExecutionEngine.ExecutionOutcome.SHORT_CIRCUITED;
            }
        }
        Duration duration = skipOutcome == ExecutionEngine.ExecutionOutcome.SHORT_CIRCUITED ? Duration.ZERO : Duration.ofMillis(timer.getElapsedMillis());
        return CachingResult.shortcutResult(duration, ExecutionEngine.Execution.skipped(skipOutcome, work), null, executionReason, null);
    }

    private boolean cleanPreviousOutputs(Map<String, FileSystemSnapshot> outputFileSnapshots) {
        OutputsCleaner outputsCleaner = this.outputsCleanerSupplier.get();
        for (FileSystemSnapshot outputFileSnapshot : outputFileSnapshots.values()) {
            try {
                this.outputChangeListener.invalidateCachesFor(SnapshotUtil.rootIndex((FileSystemSnapshot)outputFileSnapshot).keySet());
                outputsCleaner.cleanupOutputs(outputFileSnapshot);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return outputsCleaner.getDidWork();
    }
}

