# RFC Title

Issue: https://github.com/OpenTofu/{ Repository }/issues/{ issue number } <!-- Ideally, this issue will have the "needs-rfc" label added by the Core Team during triage -->

A short description of the problem that is trying to be solved. Include links to existing documentation, code examples, and links to existing code. Written such that a non-technical user or someone unfamiliar with the OpenTofu code will be able to understand and discuss it.

Background on the issue with links to similar problems which have been resolved in the past.

## Proposed Solution

Overview of the Proposed Solution to introduce the User Documentation and Technical Approach.

### User Documentation

Describe what the user would encounter when attempting to interact with what is being proposed. Provide clear and detailed descriptions, code examples, diagrams, etc... Starting point for the documentation that will be added during implementation.

This documentation will help the community have a better understanding how they will be interacting with this proposal and have an easier time discussing it in depth.

### Technical Approach

Technical summary, easy to understand by someone unfamiliar with the codebase.

Link to existing documentation and code, include diagrams if helpful.

Include pseudocode or link to a Proof of Concept if applicable.

Describe potential limitations or impacts on other areas of the codebase.

### Open Questions

List questions that should be discussed and answered during the RFC process.

### Future Considerations

What are some potential future paths this solution could take?  What other features may interact with this solution, what should be kept in mind during implementation?

## Potential Alternatives

List different approaches and briefly compare with the proposal in this RFC. It's important to explore and understand possible alternatives before agreeing on a solution.
