// Copyright (c) 2016, 2018, 2024, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

package opensearch

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"net/http"
	"strings"
)

// ListOpensearchClusterBackupsRequest wrapper for the ListOpensearchClusterBackups operation
//
// # See also
//
// Click https://docs.cloud.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/opensearch/ListOpensearchClusterBackups.go.html to see an example of how to use ListOpensearchClusterBackupsRequest.
type ListOpensearchClusterBackupsRequest struct {

	// The ID of the compartment in which to list resources.
	CompartmentId *string `mandatory:"true" contributesTo:"query" name:"compartmentId"`

	// A filter to return only resources their lifecycleState matches the given lifecycleState.
	LifecycleState OpensearchClusterBackupLifecycleStateEnum `mandatory:"false" contributesTo:"query" name:"lifecycleState" omitEmpty:"true"`

	// A filter to return only resources that match the entire display name given.
	DisplayName *string `mandatory:"false" contributesTo:"query" name:"displayName"`

	// A filter to return only resources that match the entire source cluster id given.
	SourceOpensearchClusterId *string `mandatory:"false" contributesTo:"query" name:"sourceOpensearchClusterId"`

	// unique OpensearchClusterBackup identifier
	Id *string `mandatory:"false" contributesTo:"query" name:"id"`

	// The maximum number of items to return.
	Limit *int `mandatory:"false" contributesTo:"query" name:"limit"`

	// The page token representing the page at which to start retrieving results. This is usually retrieved from a previous list call.
	Page *string `mandatory:"false" contributesTo:"query" name:"page"`

	// The sort order to use, either 'asc' or 'desc'.
	SortOrder ListOpensearchClusterBackupsSortOrderEnum `mandatory:"false" contributesTo:"query" name:"sortOrder" omitEmpty:"true"`

	// The field to sort by. Only one sort order may be provided. Default order for timeCreated is descending. Default order for displayName is ascending. If no value is specified timeCreated is default.
	SortBy ListOpensearchClusterBackupsSortByEnum `mandatory:"false" contributesTo:"query" name:"sortBy" omitEmpty:"true"`

	// The client request ID for tracing.
	OpcRequestId *string `mandatory:"false" contributesTo:"header" name:"opc-request-id"`

	// Metadata about the request. This information will not be transmitted to the service, but
	// represents information that the SDK will consume to drive retry behavior.
	RequestMetadata common.RequestMetadata
}

func (request ListOpensearchClusterBackupsRequest) String() string {
	return common.PointerString(request)
}

// HTTPRequest implements the OCIRequest interface
func (request ListOpensearchClusterBackupsRequest) HTTPRequest(method, path string, binaryRequestBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (http.Request, error) {

	_, err := request.ValidateEnumValue()
	if err != nil {
		return http.Request{}, err
	}
	return common.MakeDefaultHTTPRequestWithTaggedStructAndExtraHeaders(method, path, request, extraHeaders)
}

// BinaryRequestBody implements the OCIRequest interface
func (request ListOpensearchClusterBackupsRequest) BinaryRequestBody() (*common.OCIReadSeekCloser, bool) {

	return nil, false

}

// RetryPolicy implements the OCIRetryableRequest interface. This retrieves the specified retry policy.
func (request ListOpensearchClusterBackupsRequest) RetryPolicy() *common.RetryPolicy {
	return request.RequestMetadata.RetryPolicy
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (request ListOpensearchClusterBackupsRequest) ValidateEnumValue() (bool, error) {
	errMessage := []string{}
	if _, ok := GetMappingOpensearchClusterBackupLifecycleStateEnum(string(request.LifecycleState)); !ok && request.LifecycleState != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for LifecycleState: %s. Supported values are: %s.", request.LifecycleState, strings.Join(GetOpensearchClusterBackupLifecycleStateEnumStringValues(), ",")))
	}
	if _, ok := GetMappingListOpensearchClusterBackupsSortOrderEnum(string(request.SortOrder)); !ok && request.SortOrder != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for SortOrder: %s. Supported values are: %s.", request.SortOrder, strings.Join(GetListOpensearchClusterBackupsSortOrderEnumStringValues(), ",")))
	}
	if _, ok := GetMappingListOpensearchClusterBackupsSortByEnum(string(request.SortBy)); !ok && request.SortBy != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for SortBy: %s. Supported values are: %s.", request.SortBy, strings.Join(GetListOpensearchClusterBackupsSortByEnumStringValues(), ",")))
	}
	if len(errMessage) > 0 {
		return true, fmt.Errorf(strings.Join(errMessage, "\n"))
	}
	return false, nil
}

// ListOpensearchClusterBackupsResponse wrapper for the ListOpensearchClusterBackups operation
type ListOpensearchClusterBackupsResponse struct {

	// The underlying http response
	RawResponse *http.Response

	// A list of OpensearchClusterBackupCollection instances
	OpensearchClusterBackupCollection `presentIn:"body"`

	// Unique Oracle-assigned identifier for the request. If you need to contact
	// Oracle about a particular request, please provide the request ID.
	OpcRequestId *string `presentIn:"header" name:"opc-request-id"`

	// For pagination of a list of items. When paging through a list, if this header appears in the response,
	// then a partial list might have been returned. Include this value as the `page` parameter for the
	// subsequent GET request to get the next batch of items.
	OpcNextPage *string `presentIn:"header" name:"opc-next-page"`
}

func (response ListOpensearchClusterBackupsResponse) String() string {
	return common.PointerString(response)
}

// HTTPResponse implements the OCIResponse interface
func (response ListOpensearchClusterBackupsResponse) HTTPResponse() *http.Response {
	return response.RawResponse
}

// ListOpensearchClusterBackupsSortOrderEnum Enum with underlying type: string
type ListOpensearchClusterBackupsSortOrderEnum string

// Set of constants representing the allowable values for ListOpensearchClusterBackupsSortOrderEnum
const (
	ListOpensearchClusterBackupsSortOrderAsc  ListOpensearchClusterBackupsSortOrderEnum = "ASC"
	ListOpensearchClusterBackupsSortOrderDesc ListOpensearchClusterBackupsSortOrderEnum = "DESC"
)

var mappingListOpensearchClusterBackupsSortOrderEnum = map[string]ListOpensearchClusterBackupsSortOrderEnum{
	"ASC":  ListOpensearchClusterBackupsSortOrderAsc,
	"DESC": ListOpensearchClusterBackupsSortOrderDesc,
}

var mappingListOpensearchClusterBackupsSortOrderEnumLowerCase = map[string]ListOpensearchClusterBackupsSortOrderEnum{
	"asc":  ListOpensearchClusterBackupsSortOrderAsc,
	"desc": ListOpensearchClusterBackupsSortOrderDesc,
}

// GetListOpensearchClusterBackupsSortOrderEnumValues Enumerates the set of values for ListOpensearchClusterBackupsSortOrderEnum
func GetListOpensearchClusterBackupsSortOrderEnumValues() []ListOpensearchClusterBackupsSortOrderEnum {
	values := make([]ListOpensearchClusterBackupsSortOrderEnum, 0)
	for _, v := range mappingListOpensearchClusterBackupsSortOrderEnum {
		values = append(values, v)
	}
	return values
}

// GetListOpensearchClusterBackupsSortOrderEnumStringValues Enumerates the set of values in String for ListOpensearchClusterBackupsSortOrderEnum
func GetListOpensearchClusterBackupsSortOrderEnumStringValues() []string {
	return []string{
		"ASC",
		"DESC",
	}
}

// GetMappingListOpensearchClusterBackupsSortOrderEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingListOpensearchClusterBackupsSortOrderEnum(val string) (ListOpensearchClusterBackupsSortOrderEnum, bool) {
	enum, ok := mappingListOpensearchClusterBackupsSortOrderEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}

// ListOpensearchClusterBackupsSortByEnum Enum with underlying type: string
type ListOpensearchClusterBackupsSortByEnum string

// Set of constants representing the allowable values for ListOpensearchClusterBackupsSortByEnum
const (
	ListOpensearchClusterBackupsSortByTimecreated ListOpensearchClusterBackupsSortByEnum = "timeCreated"
	ListOpensearchClusterBackupsSortByDisplayname ListOpensearchClusterBackupsSortByEnum = "displayName"
)

var mappingListOpensearchClusterBackupsSortByEnum = map[string]ListOpensearchClusterBackupsSortByEnum{
	"timeCreated": ListOpensearchClusterBackupsSortByTimecreated,
	"displayName": ListOpensearchClusterBackupsSortByDisplayname,
}

var mappingListOpensearchClusterBackupsSortByEnumLowerCase = map[string]ListOpensearchClusterBackupsSortByEnum{
	"timecreated": ListOpensearchClusterBackupsSortByTimecreated,
	"displayname": ListOpensearchClusterBackupsSortByDisplayname,
}

// GetListOpensearchClusterBackupsSortByEnumValues Enumerates the set of values for ListOpensearchClusterBackupsSortByEnum
func GetListOpensearchClusterBackupsSortByEnumValues() []ListOpensearchClusterBackupsSortByEnum {
	values := make([]ListOpensearchClusterBackupsSortByEnum, 0)
	for _, v := range mappingListOpensearchClusterBackupsSortByEnum {
		values = append(values, v)
	}
	return values
}

// GetListOpensearchClusterBackupsSortByEnumStringValues Enumerates the set of values in String for ListOpensearchClusterBackupsSortByEnum
func GetListOpensearchClusterBackupsSortByEnumStringValues() []string {
	return []string{
		"timeCreated",
		"displayName",
	}
}

// GetMappingListOpensearchClusterBackupsSortByEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingListOpensearchClusterBackupsSortByEnum(val string) (ListOpensearchClusterBackupsSortByEnum, bool) {
	enum, ok := mappingListOpensearchClusterBackupsSortByEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}
