// Copyright (c) 2016, 2018, 2024, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Ops Insights API
//
// Use the Ops Insights API to perform data extraction operations to obtain database
// resource utilization, performance statistics, and reference information. For more information,
// see About Oracle Cloud Infrastructure Ops Insights (https://docs.cloud.oracle.com/en-us/iaas/operations-insights/doc/operations-insights.html).
//

package opsi

import (
	"encoding/json"
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// HostNetworkConfiguration Network Configuration metric for the host
type HostNetworkConfiguration struct {

	// Collection timestamp
	// Example: `"2020-05-06T00:00:00.000Z"`
	TimeCollected *common.SDKTime `mandatory:"true" json:"timeCollected"`

	// Name of the network interface
	InterfaceName *string `mandatory:"true" json:"interfaceName"`

	// IP address (IPv4 or IPv6) of the network interface
	IpAddress *string `mandatory:"true" json:"ipAddress"`

	// MAC address of the network interface. MAC address is a 12-digit hexadecimal number separated by colons or dashes or dots. Following formats are accepted: MM:MM:MM:SS:SS:SS, MM-MM-MM-SS-SS-SS, MM.MM.MM.SS.SS.SS, MMM:MMM:SSS:SSS, MMM-MMM-SSS-SSS, MMM.MMM.SSS.SSS, MMMM:MMSS:SSSS, MMMM-MMSS-SSSS, MMMM.MMSS.SSSS
	MacAddress *string `mandatory:"false" json:"macAddress"`
}

// GetTimeCollected returns TimeCollected
func (m HostNetworkConfiguration) GetTimeCollected() *common.SDKTime {
	return m.TimeCollected
}

func (m HostNetworkConfiguration) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m HostNetworkConfiguration) ValidateEnumValue() (bool, error) {
	errMessage := []string{}

	if len(errMessage) > 0 {
		return true, fmt.Errorf(strings.Join(errMessage, "\n"))
	}
	return false, nil
}

// MarshalJSON marshals to json representation
func (m HostNetworkConfiguration) MarshalJSON() (buff []byte, e error) {
	type MarshalTypeHostNetworkConfiguration HostNetworkConfiguration
	s := struct {
		DiscriminatorParam string `json:"metricName"`
		MarshalTypeHostNetworkConfiguration
	}{
		"HOST_NETWORK_CONFIGURATION",
		(MarshalTypeHostNetworkConfiguration)(m),
	}

	return json.Marshal(&s)
}
