// Copyright (c) 2016, 2018, 2024, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// OS Management Hub API
//
// Use the OS Management Hub API to manage and monitor updates and patches for instances in OCI, your private data center, or 3rd-party clouds.
// For more information, see Overview of OS Management Hub (https://docs.cloud.oracle.com/iaas/osmh/doc/overview.htm).
//

package osmanagementhub

import (
	"strings"
)

// VulnerabilityTypesEnum Enum with underlying type: string
type VulnerabilityTypesEnum string

// Set of constants representing the allowable values for VulnerabilityTypesEnum
const (
	VulnerabilityTypesSecurity    VulnerabilityTypesEnum = "SECURITY"
	VulnerabilityTypesBugfix      VulnerabilityTypesEnum = "BUGFIX"
	VulnerabilityTypesEnhancement VulnerabilityTypesEnum = "ENHANCEMENT"
	VulnerabilityTypesOther       VulnerabilityTypesEnum = "OTHER"
	VulnerabilityTypesAll         VulnerabilityTypesEnum = "ALL"
)

var mappingVulnerabilityTypesEnum = map[string]VulnerabilityTypesEnum{
	"SECURITY":    VulnerabilityTypesSecurity,
	"BUGFIX":      VulnerabilityTypesBugfix,
	"ENHANCEMENT": VulnerabilityTypesEnhancement,
	"OTHER":       VulnerabilityTypesOther,
	"ALL":         VulnerabilityTypesAll,
}

var mappingVulnerabilityTypesEnumLowerCase = map[string]VulnerabilityTypesEnum{
	"security":    VulnerabilityTypesSecurity,
	"bugfix":      VulnerabilityTypesBugfix,
	"enhancement": VulnerabilityTypesEnhancement,
	"other":       VulnerabilityTypesOther,
	"all":         VulnerabilityTypesAll,
}

// GetVulnerabilityTypesEnumValues Enumerates the set of values for VulnerabilityTypesEnum
func GetVulnerabilityTypesEnumValues() []VulnerabilityTypesEnum {
	values := make([]VulnerabilityTypesEnum, 0)
	for _, v := range mappingVulnerabilityTypesEnum {
		values = append(values, v)
	}
	return values
}

// GetVulnerabilityTypesEnumStringValues Enumerates the set of values in String for VulnerabilityTypesEnum
func GetVulnerabilityTypesEnumStringValues() []string {
	return []string{
		"SECURITY",
		"BUGFIX",
		"ENHANCEMENT",
		"OTHER",
		"ALL",
	}
}

// GetMappingVulnerabilityTypesEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingVulnerabilityTypesEnum(val string) (VulnerabilityTypesEnum, bool) {
	enum, ok := mappingVulnerabilityTypesEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}
