// Copyright (c) 2016, 2018, 2024, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Scanning API
//
// Use the Vulnerability Scanning Service (VSS) API to manage scan recipes, targets, and reports. For more information, see the Vulnerability Scanning documentation (https://docs.cloud.oracle.com/iaas/scanning/home.htm).
//

package vulnerabilityscanning

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// VulnerabilityImpactedContainerSummary Information on a container image impacted by a vulnerability
type VulnerabilityImpactedContainerSummary struct {

	// The scan target id of the repository scan result
	ContainerScanTargetId *string `mandatory:"true" json:"containerScanTargetId"`

	// The repository id of the container image.
	Repository *string `mandatory:"true" json:"repository"`

	// The registry key of the container image.
	Registry *string `mandatory:"true" json:"registry"`

	// The name of the container image.
	Image *string `mandatory:"true" json:"image"`

	// The ID of the last container image scan result Id
	LastContainerScanId *string `mandatory:"true" json:"lastContainerScanId"`

	// Date and time the scan was completed, as described in RFC 3339 (https://tools.ietf.org/rfc/rfc3339)
	TimeScanCompleted *common.SDKTime `mandatory:"true" json:"timeScanCompleted"`
}

func (m VulnerabilityImpactedContainerSummary) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m VulnerabilityImpactedContainerSummary) ValidateEnumValue() (bool, error) {
	errMessage := []string{}

	if len(errMessage) > 0 {
		return true, fmt.Errorf(strings.Join(errMessage, "\n"))
	}
	return false, nil
}
