# Security Policy

The go-tuf community is committed to maintaining a reliable and consistent TUF client implementation. If you believe you have identified a security issue in go-tuf's client protocol, please follow these guidelines for responsible disclosure.

## Supported Versions

You may report issues for the most recent version of go-tuf. We will not retroactively make changes to older versions.

## Reporting a Vulnerability

If you discover a potential security issue in this project we ask that you notify the go-tuf maintainers via [Github's private reporting feature](https://github.com/DataDog/go-tuf/security/advisories/new) (requires being signed in to GitHub). At the minimum, the report must contain the following:

* A description of the issue.
* A specific version or commit SHA of `go-tuf` where the issue reproduces.
* Instructions to reproduce the issue.

Please do **not** create a public GitHub issue or pull request to submit vulnerability reports. These public trackers are intended for non-time-sensitive and non-security-related bug reports and feature requests. Major feature requests, such as design changes to the specification, should be proposed via a [TUF Augmentation Protocol](https://theupdateframework.github.io/specification/latest/#tuf-augmentation-proposal-tap-support) (TAP).

## Disclosure

This project follows a 90 day disclosure timeline.
