#pragma once
//-------------------------------------------------------------------------------------------------
// <copyright file="memutil.h" company="Outercurve Foundation">
//   Copyright (c) 2004, Outercurve Foundation.
//   This software is released under Microsoft Reciprocal License (MS-RL).
//   The license and further copyright text can be found in the file
//   LICENSE.TXT at the root directory of the distribution.
// </copyright>
// 
// <summary>
//    Header for memory helper functions.
// </summary>
//-------------------------------------------------------------------------------------------------

#ifdef __cplusplus
extern "C" {
#endif

#define ReleaseMem(p) if (p) { MemFree(p); }
#define ReleaseNullMem(p) if (p) { MemFree(p); p = NULL; }

HRESULT DAPI MemInitialize();
void DAPI MemUninitialize();

LPVOID DAPI MemAlloc(
    __in SIZE_T cbSize,
    __in BOOL fZero
    );
LPVOID DAPI MemReAlloc(
    __in LPVOID pv,
    __in SIZE_T cbSize,
    __in BOOL fZero
    );
HRESULT DAPI MemReAllocSecure(
    __in LPVOID pv,
    __in SIZE_T cbSize,
    __in BOOL fZero,
    __deref_out LPVOID* ppvNew
    );
HRESULT DAPI MemAllocArray(
    __inout LPVOID* ppvArray,
    __in SIZE_T cbArrayType,
    __in DWORD dwItemCount
    );
HRESULT DAPI MemReAllocArray(
    __inout LPVOID* ppvArray,
    __in DWORD cArray,
    __in SIZE_T cbArrayType,
    __in DWORD dwNewItemCount
    );
HRESULT DAPI MemEnsureArraySize(
    __deref_out_bcount(cArray * cbArrayType) LPVOID* ppvArray,
    __in DWORD cArray,
    __in SIZE_T cbArrayType,
    __in DWORD dwGrowthCount
    );
HRESULT DAPI MemInsertIntoArray(
    __deref_out_bcount((cExistingArray + cInsertItems) * cbArrayType) LPVOID* ppvArray,
    __in DWORD dwInsertIndex,
    __in DWORD cInsertItems,
    __in DWORD cExistingArray,
    __in SIZE_T cbArrayType,
    __in DWORD dwGrowthCount
    );
void DAPI MemRemoveFromArray(
    __inout_bcount((cExistingArray) * cbArrayType) LPVOID pvArray,
    __in DWORD dwRemoveIndex,
    __in DWORD cRemoveItems,
    __in DWORD cExistingArray,
    __in SIZE_T cbArrayType,
    __in BOOL fPreserveOrder
    );
void DAPI MemArraySwapItems(
    __inout_bcount((cExistingArray) * cbArrayType) LPVOID pvArray,
    __in DWORD dwIndex1,
    __in DWORD dwIndex2,
    __in SIZE_T cbArrayType
    );

HRESULT DAPI MemFree(
    __in LPVOID pv
    );
SIZE_T DAPI MemSize(
    __in LPCVOID pv
    );

#ifdef __cplusplus
}
#endif

