package training

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// Classifier enumerates the values for classifier.
type Classifier string

const (
	// Multiclass ...
	Multiclass Classifier = "Multiclass"
	// Multilabel ...
	Multilabel Classifier = "Multilabel"
)

// PossibleClassifierValues returns an array of possible values for the Classifier const type.
func PossibleClassifierValues() []Classifier {
	return []Classifier{Multiclass, Multilabel}
}

// CustomVisionErrorCodes enumerates the values for custom vision error codes.
type CustomVisionErrorCodes string

const (
	// BadRequest ...
	BadRequest CustomVisionErrorCodes = "BadRequest"
	// BadRequestCannotMigrateProjectWithName ...
	BadRequestCannotMigrateProjectWithName CustomVisionErrorCodes = "BadRequestCannotMigrateProjectWithName"
	// BadRequestClassificationTrainingValidationFailed ...
	BadRequestClassificationTrainingValidationFailed CustomVisionErrorCodes = "BadRequestClassificationTrainingValidationFailed"
	// BadRequestDetectionTrainingNotAllowNegativeTag ...
	BadRequestDetectionTrainingNotAllowNegativeTag CustomVisionErrorCodes = "BadRequestDetectionTrainingNotAllowNegativeTag"
	// BadRequestDetectionTrainingValidationFailed ...
	BadRequestDetectionTrainingValidationFailed CustomVisionErrorCodes = "BadRequestDetectionTrainingValidationFailed"
	// BadRequestDomainNotSupportedForAdvancedTraining ...
	BadRequestDomainNotSupportedForAdvancedTraining CustomVisionErrorCodes = "BadRequestDomainNotSupportedForAdvancedTraining"
	// BadRequestExceededBatchSize ...
	BadRequestExceededBatchSize CustomVisionErrorCodes = "BadRequestExceededBatchSize"
	// BadRequestExceededQuota ...
	BadRequestExceededQuota CustomVisionErrorCodes = "BadRequestExceededQuota"
	// BadRequestExceedIterationPerProjectLimit ...
	BadRequestExceedIterationPerProjectLimit CustomVisionErrorCodes = "BadRequestExceedIterationPerProjectLimit"
	// BadRequestExceedProjectLimit ...
	BadRequestExceedProjectLimit CustomVisionErrorCodes = "BadRequestExceedProjectLimit"
	// BadRequestExceedTagPerImageLimit ...
	BadRequestExceedTagPerImageLimit CustomVisionErrorCodes = "BadRequestExceedTagPerImageLimit"
	// BadRequestExceedTagPerProjectLimit ...
	BadRequestExceedTagPerProjectLimit CustomVisionErrorCodes = "BadRequestExceedTagPerProjectLimit"
	// BadRequestExportAlreadyInProgress ...
	BadRequestExportAlreadyInProgress CustomVisionErrorCodes = "BadRequestExportAlreadyInProgress"
	// BadRequestExportPlatformNotSupportedForAdvancedTraining ...
	BadRequestExportPlatformNotSupportedForAdvancedTraining CustomVisionErrorCodes = "BadRequestExportPlatformNotSupportedForAdvancedTraining"
	// BadRequestExportValidationFailed ...
	BadRequestExportValidationFailed CustomVisionErrorCodes = "BadRequestExportValidationFailed"
	// BadRequestImageBatch ...
	BadRequestImageBatch CustomVisionErrorCodes = "BadRequestImageBatch"
	// BadRequestImageExceededCount ...
	BadRequestImageExceededCount CustomVisionErrorCodes = "BadRequestImageExceededCount"
	// BadRequestImageFormat ...
	BadRequestImageFormat CustomVisionErrorCodes = "BadRequestImageFormat"
	// BadRequestImageRegions ...
	BadRequestImageRegions CustomVisionErrorCodes = "BadRequestImageRegions"
	// BadRequestImageSizeBytes ...
	BadRequestImageSizeBytes CustomVisionErrorCodes = "BadRequestImageSizeBytes"
	// BadRequestImageStream ...
	BadRequestImageStream CustomVisionErrorCodes = "BadRequestImageStream"
	// BadRequestImageTags ...
	BadRequestImageTags CustomVisionErrorCodes = "BadRequestImageTags"
	// BadRequestImageURL ...
	BadRequestImageURL CustomVisionErrorCodes = "BadRequestImageUrl"
	// BadRequestInvalid ...
	BadRequestInvalid CustomVisionErrorCodes = "BadRequestInvalid"
	// BadRequestInvalidEmailAddress ...
	BadRequestInvalidEmailAddress CustomVisionErrorCodes = "BadRequestInvalidEmailAddress"
	// BadRequestInvalidIds ...
	BadRequestInvalidIds CustomVisionErrorCodes = "BadRequestInvalidIds"
	// BadRequestInvalidPublishName ...
	BadRequestInvalidPublishName CustomVisionErrorCodes = "BadRequestInvalidPublishName"
	// BadRequestInvalidPublishTarget ...
	BadRequestInvalidPublishTarget CustomVisionErrorCodes = "BadRequestInvalidPublishTarget"
	// BadRequestIterationDescription ...
	BadRequestIterationDescription CustomVisionErrorCodes = "BadRequestIterationDescription"
	// BadRequestIterationIsNotTrained ...
	BadRequestIterationIsNotTrained CustomVisionErrorCodes = "BadRequestIterationIsNotTrained"
	// BadRequestIterationIsPublished ...
	BadRequestIterationIsPublished CustomVisionErrorCodes = "BadRequestIterationIsPublished"
	// BadRequestIterationName ...
	BadRequestIterationName CustomVisionErrorCodes = "BadRequestIterationName"
	// BadRequestIterationNameNotUnique ...
	BadRequestIterationNameNotUnique CustomVisionErrorCodes = "BadRequestIterationNameNotUnique"
	// BadRequestIterationNotPublished ...
	BadRequestIterationNotPublished CustomVisionErrorCodes = "BadRequestIterationNotPublished"
	// BadRequestMultiClassClassificationTrainingValidationFailed ...
	BadRequestMultiClassClassificationTrainingValidationFailed CustomVisionErrorCodes = "BadRequestMultiClassClassificationTrainingValidationFailed"
	// BadRequestMultiLabelClassificationTrainingValidationFailed ...
	BadRequestMultiLabelClassificationTrainingValidationFailed CustomVisionErrorCodes = "BadRequestMultiLabelClassificationTrainingValidationFailed"
	// BadRequestMultipleNegativeTag ...
	BadRequestMultipleNegativeTag CustomVisionErrorCodes = "BadRequestMultipleNegativeTag"
	// BadRequestNegativeAndRegularTagOnSameImage ...
	BadRequestNegativeAndRegularTagOnSameImage CustomVisionErrorCodes = "BadRequestNegativeAndRegularTagOnSameImage"
	// BadRequestNotLimitedTrial ...
	BadRequestNotLimitedTrial CustomVisionErrorCodes = "BadRequestNotLimitedTrial"
	// BadRequestNotSupported ...
	BadRequestNotSupported CustomVisionErrorCodes = "BadRequestNotSupported"
	// BadRequestPredictionIdsExceededCount ...
	BadRequestPredictionIdsExceededCount CustomVisionErrorCodes = "BadRequestPredictionIdsExceededCount"
	// BadRequestPredictionIdsMissing ...
	BadRequestPredictionIdsMissing CustomVisionErrorCodes = "BadRequestPredictionIdsMissing"
	// BadRequestPredictionInvalidApplicationName ...
	BadRequestPredictionInvalidApplicationName CustomVisionErrorCodes = "BadRequestPredictionInvalidApplicationName"
	// BadRequestPredictionInvalidQueryParameters ...
	BadRequestPredictionInvalidQueryParameters CustomVisionErrorCodes = "BadRequestPredictionInvalidQueryParameters"
	// BadRequestPredictionResultsExceededCount ...
	BadRequestPredictionResultsExceededCount CustomVisionErrorCodes = "BadRequestPredictionResultsExceededCount"
	// BadRequestPredictionTagsExceededCount ...
	BadRequestPredictionTagsExceededCount CustomVisionErrorCodes = "BadRequestPredictionTagsExceededCount"
	// BadRequestProjectDescription ...
	BadRequestProjectDescription CustomVisionErrorCodes = "BadRequestProjectDescription"
	// BadRequestProjectImagePreprocessingSettings ...
	BadRequestProjectImagePreprocessingSettings CustomVisionErrorCodes = "BadRequestProjectImagePreprocessingSettings"
	// BadRequestProjectName ...
	BadRequestProjectName CustomVisionErrorCodes = "BadRequestProjectName"
	// BadRequestProjectNameNotUnique ...
	BadRequestProjectNameNotUnique CustomVisionErrorCodes = "BadRequestProjectNameNotUnique"
	// BadRequestProjectUnknownClassification ...
	BadRequestProjectUnknownClassification CustomVisionErrorCodes = "BadRequestProjectUnknownClassification"
	// BadRequestProjectUnknownDomain ...
	BadRequestProjectUnknownDomain CustomVisionErrorCodes = "BadRequestProjectUnknownDomain"
	// BadRequestProjectUnsupportedDomainTypeChange ...
	BadRequestProjectUnsupportedDomainTypeChange CustomVisionErrorCodes = "BadRequestProjectUnsupportedDomainTypeChange"
	// BadRequestProjectUnsupportedExportPlatform ...
	BadRequestProjectUnsupportedExportPlatform CustomVisionErrorCodes = "BadRequestProjectUnsupportedExportPlatform"
	// BadRequestRequiredParamIsNull ...
	BadRequestRequiredParamIsNull CustomVisionErrorCodes = "BadRequestRequiredParamIsNull"
	// BadRequestReservedBudgetInHoursNotEnoughForAdvancedTraining ...
	BadRequestReservedBudgetInHoursNotEnoughForAdvancedTraining CustomVisionErrorCodes = "BadRequestReservedBudgetInHoursNotEnoughForAdvancedTraining"
	// BadRequestSubscriptionAPI ...
	BadRequestSubscriptionAPI CustomVisionErrorCodes = "BadRequestSubscriptionApi"
	// BadRequestTagDescription ...
	BadRequestTagDescription CustomVisionErrorCodes = "BadRequestTagDescription"
	// BadRequestTagName ...
	BadRequestTagName CustomVisionErrorCodes = "BadRequestTagName"
	// BadRequestTagNameNotUnique ...
	BadRequestTagNameNotUnique CustomVisionErrorCodes = "BadRequestTagNameNotUnique"
	// BadRequestTagType ...
	BadRequestTagType CustomVisionErrorCodes = "BadRequestTagType"
	// BadRequestTrainingAlreadyInProgress ...
	BadRequestTrainingAlreadyInProgress CustomVisionErrorCodes = "BadRequestTrainingAlreadyInProgress"
	// BadRequestTrainingNotNeeded ...
	BadRequestTrainingNotNeeded CustomVisionErrorCodes = "BadRequestTrainingNotNeeded"
	// BadRequestTrainingNotNeededButTrainingPipelineUpdated ...
	BadRequestTrainingNotNeededButTrainingPipelineUpdated CustomVisionErrorCodes = "BadRequestTrainingNotNeededButTrainingPipelineUpdated"
	// BadRequestTrainingValidationFailed ...
	BadRequestTrainingValidationFailed CustomVisionErrorCodes = "BadRequestTrainingValidationFailed"
	// BadRequestUnpublishFailed ...
	BadRequestUnpublishFailed CustomVisionErrorCodes = "BadRequestUnpublishFailed"
	// BadRequestWorkspaceCannotBeModified ...
	BadRequestWorkspaceCannotBeModified CustomVisionErrorCodes = "BadRequestWorkspaceCannotBeModified"
	// BadRequestWorkspaceNotDeletable ...
	BadRequestWorkspaceNotDeletable CustomVisionErrorCodes = "BadRequestWorkspaceNotDeletable"
	// Conflict ...
	Conflict CustomVisionErrorCodes = "Conflict"
	// ConflictInvalid ...
	ConflictInvalid CustomVisionErrorCodes = "ConflictInvalid"
	// ErrorExporterInvalidClassifier ...
	ErrorExporterInvalidClassifier CustomVisionErrorCodes = "ErrorExporterInvalidClassifier"
	// ErrorExporterInvalidFeaturizer ...
	ErrorExporterInvalidFeaturizer CustomVisionErrorCodes = "ErrorExporterInvalidFeaturizer"
	// ErrorExporterInvalidPlatform ...
	ErrorExporterInvalidPlatform CustomVisionErrorCodes = "ErrorExporterInvalidPlatform"
	// ErrorFeaturizationAugmentationError ...
	ErrorFeaturizationAugmentationError CustomVisionErrorCodes = "ErrorFeaturizationAugmentationError"
	// ErrorFeaturizationAugmentationUnavailable ...
	ErrorFeaturizationAugmentationUnavailable CustomVisionErrorCodes = "ErrorFeaturizationAugmentationUnavailable"
	// ErrorFeaturizationInvalidFeaturizer ...
	ErrorFeaturizationInvalidFeaturizer CustomVisionErrorCodes = "ErrorFeaturizationInvalidFeaturizer"
	// ErrorFeaturizationQueueTimeout ...
	ErrorFeaturizationQueueTimeout CustomVisionErrorCodes = "ErrorFeaturizationQueueTimeout"
	// ErrorFeaturizationServiceUnavailable ...
	ErrorFeaturizationServiceUnavailable CustomVisionErrorCodes = "ErrorFeaturizationServiceUnavailable"
	// ErrorFeaturizationUnrecognizedJob ...
	ErrorFeaturizationUnrecognizedJob CustomVisionErrorCodes = "ErrorFeaturizationUnrecognizedJob"
	// ErrorInvalid ...
	ErrorInvalid CustomVisionErrorCodes = "ErrorInvalid"
	// ErrorPrediction ...
	ErrorPrediction CustomVisionErrorCodes = "ErrorPrediction"
	// ErrorPredictionModelNotCached ...
	ErrorPredictionModelNotCached CustomVisionErrorCodes = "ErrorPredictionModelNotCached"
	// ErrorPredictionModelNotFound ...
	ErrorPredictionModelNotFound CustomVisionErrorCodes = "ErrorPredictionModelNotFound"
	// ErrorPredictionServiceUnavailable ...
	ErrorPredictionServiceUnavailable CustomVisionErrorCodes = "ErrorPredictionServiceUnavailable"
	// ErrorPredictionStorage ...
	ErrorPredictionStorage CustomVisionErrorCodes = "ErrorPredictionStorage"
	// ErrorProjectExportRequestFailed ...
	ErrorProjectExportRequestFailed CustomVisionErrorCodes = "ErrorProjectExportRequestFailed"
	// ErrorProjectInvalidDomain ...
	ErrorProjectInvalidDomain CustomVisionErrorCodes = "ErrorProjectInvalidDomain"
	// ErrorProjectInvalidPipelineConfiguration ...
	ErrorProjectInvalidPipelineConfiguration CustomVisionErrorCodes = "ErrorProjectInvalidPipelineConfiguration"
	// ErrorProjectInvalidWorkspace ...
	ErrorProjectInvalidWorkspace CustomVisionErrorCodes = "ErrorProjectInvalidWorkspace"
	// ErrorProjectTrainingRequestFailed ...
	ErrorProjectTrainingRequestFailed CustomVisionErrorCodes = "ErrorProjectTrainingRequestFailed"
	// ErrorRegionProposal ...
	ErrorRegionProposal CustomVisionErrorCodes = "ErrorRegionProposal"
	// ErrorUnknown ...
	ErrorUnknown CustomVisionErrorCodes = "ErrorUnknown"
	// Forbidden ...
	Forbidden CustomVisionErrorCodes = "Forbidden"
	// ForbiddenDRModeEnabled ...
	ForbiddenDRModeEnabled CustomVisionErrorCodes = "ForbiddenDRModeEnabled"
	// ForbiddenInvalid ...
	ForbiddenInvalid CustomVisionErrorCodes = "ForbiddenInvalid"
	// ForbiddenUser ...
	ForbiddenUser CustomVisionErrorCodes = "ForbiddenUser"
	// ForbiddenUserDisabled ...
	ForbiddenUserDisabled CustomVisionErrorCodes = "ForbiddenUserDisabled"
	// ForbiddenUserDoesNotExist ...
	ForbiddenUserDoesNotExist CustomVisionErrorCodes = "ForbiddenUserDoesNotExist"
	// ForbiddenUserInsufficientCapability ...
	ForbiddenUserInsufficientCapability CustomVisionErrorCodes = "ForbiddenUserInsufficientCapability"
	// ForbiddenUserResource ...
	ForbiddenUserResource CustomVisionErrorCodes = "ForbiddenUserResource"
	// ForbiddenUserSignupAllowanceExceeded ...
	ForbiddenUserSignupAllowanceExceeded CustomVisionErrorCodes = "ForbiddenUserSignupAllowanceExceeded"
	// ForbiddenUserSignupDisabled ...
	ForbiddenUserSignupDisabled CustomVisionErrorCodes = "ForbiddenUserSignupDisabled"
	// NoError ...
	NoError CustomVisionErrorCodes = "NoError"
	// NotFound ...
	NotFound CustomVisionErrorCodes = "NotFound"
	// NotFoundApimSubscription ...
	NotFoundApimSubscription CustomVisionErrorCodes = "NotFoundApimSubscription"
	// NotFoundDomain ...
	NotFoundDomain CustomVisionErrorCodes = "NotFoundDomain"
	// NotFoundImage ...
	NotFoundImage CustomVisionErrorCodes = "NotFoundImage"
	// NotFoundInvalid ...
	NotFoundInvalid CustomVisionErrorCodes = "NotFoundInvalid"
	// NotFoundIteration ...
	NotFoundIteration CustomVisionErrorCodes = "NotFoundIteration"
	// NotFoundIterationPerformance ...
	NotFoundIterationPerformance CustomVisionErrorCodes = "NotFoundIterationPerformance"
	// NotFoundProject ...
	NotFoundProject CustomVisionErrorCodes = "NotFoundProject"
	// NotFoundProjectDefaultIteration ...
	NotFoundProjectDefaultIteration CustomVisionErrorCodes = "NotFoundProjectDefaultIteration"
	// NotFoundTag ...
	NotFoundTag CustomVisionErrorCodes = "NotFoundTag"
	// UnsupportedMediaType ...
	UnsupportedMediaType CustomVisionErrorCodes = "UnsupportedMediaType"
)

// PossibleCustomVisionErrorCodesValues returns an array of possible values for the CustomVisionErrorCodes const type.
func PossibleCustomVisionErrorCodesValues() []CustomVisionErrorCodes {
	return []CustomVisionErrorCodes{BadRequest, BadRequestCannotMigrateProjectWithName, BadRequestClassificationTrainingValidationFailed, BadRequestDetectionTrainingNotAllowNegativeTag, BadRequestDetectionTrainingValidationFailed, BadRequestDomainNotSupportedForAdvancedTraining, BadRequestExceededBatchSize, BadRequestExceededQuota, BadRequestExceedIterationPerProjectLimit, BadRequestExceedProjectLimit, BadRequestExceedTagPerImageLimit, BadRequestExceedTagPerProjectLimit, BadRequestExportAlreadyInProgress, BadRequestExportPlatformNotSupportedForAdvancedTraining, BadRequestExportValidationFailed, BadRequestImageBatch, BadRequestImageExceededCount, BadRequestImageFormat, BadRequestImageRegions, BadRequestImageSizeBytes, BadRequestImageStream, BadRequestImageTags, BadRequestImageURL, BadRequestInvalid, BadRequestInvalidEmailAddress, BadRequestInvalidIds, BadRequestInvalidPublishName, BadRequestInvalidPublishTarget, BadRequestIterationDescription, BadRequestIterationIsNotTrained, BadRequestIterationIsPublished, BadRequestIterationName, BadRequestIterationNameNotUnique, BadRequestIterationNotPublished, BadRequestMultiClassClassificationTrainingValidationFailed, BadRequestMultiLabelClassificationTrainingValidationFailed, BadRequestMultipleNegativeTag, BadRequestNegativeAndRegularTagOnSameImage, BadRequestNotLimitedTrial, BadRequestNotSupported, BadRequestPredictionIdsExceededCount, BadRequestPredictionIdsMissing, BadRequestPredictionInvalidApplicationName, BadRequestPredictionInvalidQueryParameters, BadRequestPredictionResultsExceededCount, BadRequestPredictionTagsExceededCount, BadRequestProjectDescription, BadRequestProjectImagePreprocessingSettings, BadRequestProjectName, BadRequestProjectNameNotUnique, BadRequestProjectUnknownClassification, BadRequestProjectUnknownDomain, BadRequestProjectUnsupportedDomainTypeChange, BadRequestProjectUnsupportedExportPlatform, BadRequestRequiredParamIsNull, BadRequestReservedBudgetInHoursNotEnoughForAdvancedTraining, BadRequestSubscriptionAPI, BadRequestTagDescription, BadRequestTagName, BadRequestTagNameNotUnique, BadRequestTagType, BadRequestTrainingAlreadyInProgress, BadRequestTrainingNotNeeded, BadRequestTrainingNotNeededButTrainingPipelineUpdated, BadRequestTrainingValidationFailed, BadRequestUnpublishFailed, BadRequestWorkspaceCannotBeModified, BadRequestWorkspaceNotDeletable, Conflict, ConflictInvalid, ErrorExporterInvalidClassifier, ErrorExporterInvalidFeaturizer, ErrorExporterInvalidPlatform, ErrorFeaturizationAugmentationError, ErrorFeaturizationAugmentationUnavailable, ErrorFeaturizationInvalidFeaturizer, ErrorFeaturizationQueueTimeout, ErrorFeaturizationServiceUnavailable, ErrorFeaturizationUnrecognizedJob, ErrorInvalid, ErrorPrediction, ErrorPredictionModelNotCached, ErrorPredictionModelNotFound, ErrorPredictionServiceUnavailable, ErrorPredictionStorage, ErrorProjectExportRequestFailed, ErrorProjectInvalidDomain, ErrorProjectInvalidPipelineConfiguration, ErrorProjectInvalidWorkspace, ErrorProjectTrainingRequestFailed, ErrorRegionProposal, ErrorUnknown, Forbidden, ForbiddenDRModeEnabled, ForbiddenInvalid, ForbiddenUser, ForbiddenUserDisabled, ForbiddenUserDoesNotExist, ForbiddenUserInsufficientCapability, ForbiddenUserResource, ForbiddenUserSignupAllowanceExceeded, ForbiddenUserSignupDisabled, NoError, NotFound, NotFoundApimSubscription, NotFoundDomain, NotFoundImage, NotFoundInvalid, NotFoundIteration, NotFoundIterationPerformance, NotFoundProject, NotFoundProjectDefaultIteration, NotFoundTag, UnsupportedMediaType}
}

// DomainType enumerates the values for domain type.
type DomainType string

const (
	// Classification ...
	Classification DomainType = "Classification"
	// ObjectDetection ...
	ObjectDetection DomainType = "ObjectDetection"
)

// PossibleDomainTypeValues returns an array of possible values for the DomainType const type.
func PossibleDomainTypeValues() []DomainType {
	return []DomainType{Classification, ObjectDetection}
}

// ExportFlavor enumerates the values for export flavor.
type ExportFlavor string

const (
	// ARM ...
	ARM ExportFlavor = "ARM"
	// Linux ...
	Linux ExportFlavor = "Linux"
	// ONNX10 ...
	ONNX10 ExportFlavor = "ONNX10"
	// ONNX12 ...
	ONNX12 ExportFlavor = "ONNX12"
	// TensorFlowLite ...
	TensorFlowLite ExportFlavor = "TensorFlowLite"
	// TensorFlowNormal ...
	TensorFlowNormal ExportFlavor = "TensorFlowNormal"
	// Windows ...
	Windows ExportFlavor = "Windows"
)

// PossibleExportFlavorValues returns an array of possible values for the ExportFlavor const type.
func PossibleExportFlavorValues() []ExportFlavor {
	return []ExportFlavor{ARM, Linux, ONNX10, ONNX12, TensorFlowLite, TensorFlowNormal, Windows}
}

// ExportPlatform enumerates the values for export platform.
type ExportPlatform string

const (
	// CoreML ...
	CoreML ExportPlatform = "CoreML"
	// DockerFile ...
	DockerFile ExportPlatform = "DockerFile"
	// ONNX ...
	ONNX ExportPlatform = "ONNX"
	// TensorFlow ...
	TensorFlow ExportPlatform = "TensorFlow"
	// VAIDK ...
	VAIDK ExportPlatform = "VAIDK"
)

// PossibleExportPlatformValues returns an array of possible values for the ExportPlatform const type.
func PossibleExportPlatformValues() []ExportPlatform {
	return []ExportPlatform{CoreML, DockerFile, ONNX, TensorFlow, VAIDK}
}

// ExportStatus enumerates the values for export status.
type ExportStatus string

const (
	// Done ...
	Done ExportStatus = "Done"
	// Exporting ...
	Exporting ExportStatus = "Exporting"
	// Failed ...
	Failed ExportStatus = "Failed"
)

// PossibleExportStatusValues returns an array of possible values for the ExportStatus const type.
func PossibleExportStatusValues() []ExportStatus {
	return []ExportStatus{Done, Exporting, Failed}
}

// ImageCreateStatus enumerates the values for image create status.
type ImageCreateStatus string

const (
	// ImageCreateStatusErrorImageFormat ...
	ImageCreateStatusErrorImageFormat ImageCreateStatus = "ErrorImageFormat"
	// ImageCreateStatusErrorImageSize ...
	ImageCreateStatusErrorImageSize ImageCreateStatus = "ErrorImageSize"
	// ImageCreateStatusErrorLimitExceed ...
	ImageCreateStatusErrorLimitExceed ImageCreateStatus = "ErrorLimitExceed"
	// ImageCreateStatusErrorNegativeAndRegularTagOnSameImage ...
	ImageCreateStatusErrorNegativeAndRegularTagOnSameImage ImageCreateStatus = "ErrorNegativeAndRegularTagOnSameImage"
	// ImageCreateStatusErrorRegionLimitExceed ...
	ImageCreateStatusErrorRegionLimitExceed ImageCreateStatus = "ErrorRegionLimitExceed"
	// ImageCreateStatusErrorSource ...
	ImageCreateStatusErrorSource ImageCreateStatus = "ErrorSource"
	// ImageCreateStatusErrorStorage ...
	ImageCreateStatusErrorStorage ImageCreateStatus = "ErrorStorage"
	// ImageCreateStatusErrorTagLimitExceed ...
	ImageCreateStatusErrorTagLimitExceed ImageCreateStatus = "ErrorTagLimitExceed"
	// ImageCreateStatusErrorUnknown ...
	ImageCreateStatusErrorUnknown ImageCreateStatus = "ErrorUnknown"
	// ImageCreateStatusOK ...
	ImageCreateStatusOK ImageCreateStatus = "OK"
	// ImageCreateStatusOKDuplicate ...
	ImageCreateStatusOKDuplicate ImageCreateStatus = "OKDuplicate"
)

// PossibleImageCreateStatusValues returns an array of possible values for the ImageCreateStatus const type.
func PossibleImageCreateStatusValues() []ImageCreateStatus {
	return []ImageCreateStatus{ImageCreateStatusErrorImageFormat, ImageCreateStatusErrorImageSize, ImageCreateStatusErrorLimitExceed, ImageCreateStatusErrorNegativeAndRegularTagOnSameImage, ImageCreateStatusErrorRegionLimitExceed, ImageCreateStatusErrorSource, ImageCreateStatusErrorStorage, ImageCreateStatusErrorTagLimitExceed, ImageCreateStatusErrorUnknown, ImageCreateStatusOK, ImageCreateStatusOKDuplicate}
}

// OrderBy enumerates the values for order by.
type OrderBy string

const (
	// Newest ...
	Newest OrderBy = "Newest"
	// Oldest ...
	Oldest OrderBy = "Oldest"
	// Suggested ...
	Suggested OrderBy = "Suggested"
)

// PossibleOrderByValues returns an array of possible values for the OrderBy const type.
func PossibleOrderByValues() []OrderBy {
	return []OrderBy{Newest, Oldest, Suggested}
}

// SortBy enumerates the values for sort by.
type SortBy string

const (
	// UncertaintyAscending ...
	UncertaintyAscending SortBy = "UncertaintyAscending"
	// UncertaintyDescending ...
	UncertaintyDescending SortBy = "UncertaintyDescending"
)

// PossibleSortByValues returns an array of possible values for the SortBy const type.
func PossibleSortByValues() []SortBy {
	return []SortBy{UncertaintyAscending, UncertaintyDescending}
}

// TagType enumerates the values for tag type.
type TagType string

const (
	// Negative ...
	Negative TagType = "Negative"
	// Regular ...
	Regular TagType = "Regular"
)

// PossibleTagTypeValues returns an array of possible values for the TagType const type.
func PossibleTagTypeValues() []TagType {
	return []TagType{Negative, Regular}
}

// Type enumerates the values for type.
type Type string

const (
	// TypeAdvanced ...
	TypeAdvanced Type = "Advanced"
	// TypeRegular ...
	TypeRegular Type = "Regular"
)

// PossibleTypeValues returns an array of possible values for the Type const type.
func PossibleTypeValues() []Type {
	return []Type{TypeAdvanced, TypeRegular}
}
