package delegatednetwork

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// ControllerState enumerates the values for controller state.
type ControllerState string

const (
	// Deleting ...
	Deleting ControllerState = "Deleting"
	// Failed ...
	Failed ControllerState = "Failed"
	// Provisioning ...
	Provisioning ControllerState = "Provisioning"
	// Succeeded ...
	Succeeded ControllerState = "Succeeded"
)

// PossibleControllerStateValues returns an array of possible values for the ControllerState const type.
func PossibleControllerStateValues() []ControllerState {
	return []ControllerState{Deleting, Failed, Provisioning, Succeeded}
}

// DelegatedSubnetState enumerates the values for delegated subnet state.
type DelegatedSubnetState string

const (
	// DelegatedSubnetStateDeleting ...
	DelegatedSubnetStateDeleting DelegatedSubnetState = "Deleting"
	// DelegatedSubnetStateFailed ...
	DelegatedSubnetStateFailed DelegatedSubnetState = "Failed"
	// DelegatedSubnetStateProvisioning ...
	DelegatedSubnetStateProvisioning DelegatedSubnetState = "Provisioning"
	// DelegatedSubnetStateSucceeded ...
	DelegatedSubnetStateSucceeded DelegatedSubnetState = "Succeeded"
)

// PossibleDelegatedSubnetStateValues returns an array of possible values for the DelegatedSubnetState const type.
func PossibleDelegatedSubnetStateValues() []DelegatedSubnetState {
	return []DelegatedSubnetState{DelegatedSubnetStateDeleting, DelegatedSubnetStateFailed, DelegatedSubnetStateProvisioning, DelegatedSubnetStateSucceeded}
}

// OrchestratorInstanceState enumerates the values for orchestrator instance state.
type OrchestratorInstanceState string

const (
	// OrchestratorInstanceStateDeleting ...
	OrchestratorInstanceStateDeleting OrchestratorInstanceState = "Deleting"
	// OrchestratorInstanceStateFailed ...
	OrchestratorInstanceStateFailed OrchestratorInstanceState = "Failed"
	// OrchestratorInstanceStateProvisioning ...
	OrchestratorInstanceStateProvisioning OrchestratorInstanceState = "Provisioning"
	// OrchestratorInstanceStateSucceeded ...
	OrchestratorInstanceStateSucceeded OrchestratorInstanceState = "Succeeded"
)

// PossibleOrchestratorInstanceStateValues returns an array of possible values for the OrchestratorInstanceState const type.
func PossibleOrchestratorInstanceStateValues() []OrchestratorInstanceState {
	return []OrchestratorInstanceState{OrchestratorInstanceStateDeleting, OrchestratorInstanceStateFailed, OrchestratorInstanceStateProvisioning, OrchestratorInstanceStateSucceeded}
}

// ResourceIdentityType enumerates the values for resource identity type.
type ResourceIdentityType string

const (
	// None ...
	None ResourceIdentityType = "None"
	// SystemAssigned ...
	SystemAssigned ResourceIdentityType = "SystemAssigned"
)

// PossibleResourceIdentityTypeValues returns an array of possible values for the ResourceIdentityType const type.
func PossibleResourceIdentityTypeValues() []ResourceIdentityType {
	return []ResourceIdentityType{None, SystemAssigned}
}
