package digitaltwins

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// EndpointProvisioningState enumerates the values for endpoint provisioning state.
type EndpointProvisioningState string

const (
	// Canceled ...
	Canceled EndpointProvisioningState = "Canceled"
	// Deleting ...
	Deleting EndpointProvisioningState = "Deleting"
	// Failed ...
	Failed EndpointProvisioningState = "Failed"
	// Provisioning ...
	Provisioning EndpointProvisioningState = "Provisioning"
	// Succeeded ...
	Succeeded EndpointProvisioningState = "Succeeded"
)

// PossibleEndpointProvisioningStateValues returns an array of possible values for the EndpointProvisioningState const type.
func PossibleEndpointProvisioningStateValues() []EndpointProvisioningState {
	return []EndpointProvisioningState{Canceled, Deleting, Failed, Provisioning, Succeeded}
}

// EndpointType enumerates the values for endpoint type.
type EndpointType string

const (
	// EndpointTypeDigitalTwinsEndpointResourceProperties ...
	EndpointTypeDigitalTwinsEndpointResourceProperties EndpointType = "DigitalTwinsEndpointResourceProperties"
	// EndpointTypeEventGrid ...
	EndpointTypeEventGrid EndpointType = "EventGrid"
	// EndpointTypeEventHub ...
	EndpointTypeEventHub EndpointType = "EventHub"
	// EndpointTypeServiceBus ...
	EndpointTypeServiceBus EndpointType = "ServiceBus"
)

// PossibleEndpointTypeValues returns an array of possible values for the EndpointType const type.
func PossibleEndpointTypeValues() []EndpointType {
	return []EndpointType{EndpointTypeDigitalTwinsEndpointResourceProperties, EndpointTypeEventGrid, EndpointTypeEventHub, EndpointTypeServiceBus}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// ProvisioningStateCanceled ...
	ProvisioningStateCanceled ProvisioningState = "Canceled"
	// ProvisioningStateDeleting ...
	ProvisioningStateDeleting ProvisioningState = "Deleting"
	// ProvisioningStateFailed ...
	ProvisioningStateFailed ProvisioningState = "Failed"
	// ProvisioningStateProvisioning ...
	ProvisioningStateProvisioning ProvisioningState = "Provisioning"
	// ProvisioningStateSucceeded ...
	ProvisioningStateSucceeded ProvisioningState = "Succeeded"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{ProvisioningStateCanceled, ProvisioningStateDeleting, ProvisioningStateFailed, ProvisioningStateProvisioning, ProvisioningStateSucceeded}
}

// Reason enumerates the values for reason.
type Reason string

const (
	// AlreadyExists ...
	AlreadyExists Reason = "AlreadyExists"
	// Invalid ...
	Invalid Reason = "Invalid"
)

// PossibleReasonValues returns an array of possible values for the Reason const type.
func PossibleReasonValues() []Reason {
	return []Reason{AlreadyExists, Invalid}
}
