package healthcareapis

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// FhirDestinationsClient is the azure Healthcare APIs Client
type FhirDestinationsClient struct {
	BaseClient
}

// NewFhirDestinationsClient creates an instance of the FhirDestinationsClient client.
func NewFhirDestinationsClient(subscriptionID string) FhirDestinationsClient {
	return NewFhirDestinationsClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewFhirDestinationsClientWithBaseURI creates an instance of the FhirDestinationsClient client using a custom
// endpoint.  Use this when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure
// stack).
func NewFhirDestinationsClientWithBaseURI(baseURI string, subscriptionID string) FhirDestinationsClient {
	return FhirDestinationsClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// ListByIotConnector lists all FHIR destinations for the given IoT Connector
// Parameters:
// resourceGroupName - the name of the resource group that contains the service instance.
// workspaceName - the name of workspace resource.
// iotConnectorName - the name of IoT Connector resource.
func (client FhirDestinationsClient) ListByIotConnector(ctx context.Context, resourceGroupName string, workspaceName string, iotConnectorName string) (result IotFhirDestinationCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/FhirDestinationsClient.ListByIotConnector")
		defer func() {
			sc := -1
			if result.ifdc.Response.Response != nil {
				sc = result.ifdc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}},
		{TargetValue: workspaceName,
			Constraints: []validation.Constraint{{Target: "workspaceName", Name: validation.MaxLength, Rule: 24, Chain: nil},
				{Target: "workspaceName", Name: validation.MinLength, Rule: 3, Chain: nil}}},
		{TargetValue: iotConnectorName,
			Constraints: []validation.Constraint{{Target: "iotConnectorName", Name: validation.MaxLength, Rule: 24, Chain: nil},
				{Target: "iotConnectorName", Name: validation.MinLength, Rule: 3, Chain: nil}}}}); err != nil {
		return result, validation.NewError("healthcareapis.FhirDestinationsClient", "ListByIotConnector", err.Error())
	}

	result.fn = client.listByIotConnectorNextResults
	req, err := client.ListByIotConnectorPreparer(ctx, resourceGroupName, workspaceName, iotConnectorName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "healthcareapis.FhirDestinationsClient", "ListByIotConnector", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByIotConnectorSender(req)
	if err != nil {
		result.ifdc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "healthcareapis.FhirDestinationsClient", "ListByIotConnector", resp, "Failure sending request")
		return
	}

	result.ifdc, err = client.ListByIotConnectorResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "healthcareapis.FhirDestinationsClient", "ListByIotConnector", resp, "Failure responding to request")
		return
	}
	if result.ifdc.hasNextLink() && result.ifdc.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListByIotConnectorPreparer prepares the ListByIotConnector request.
func (client FhirDestinationsClient) ListByIotConnectorPreparer(ctx context.Context, resourceGroupName string, workspaceName string, iotConnectorName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"iotConnectorName":  autorest.Encode("path", iotConnectorName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"workspaceName":     autorest.Encode("path", workspaceName),
	}

	const APIVersion = "2021-06-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HealthcareApis/workspaces/{workspaceName}/iotconnectors/{iotConnectorName}/fhirdestinations", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListByIotConnectorSender sends the ListByIotConnector request. The method will close the
// http.Response Body if it receives an error.
func (client FhirDestinationsClient) ListByIotConnectorSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListByIotConnectorResponder handles the response to the ListByIotConnector request. The method always
// closes the http.Response Body.
func (client FhirDestinationsClient) ListByIotConnectorResponder(resp *http.Response) (result IotFhirDestinationCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listByIotConnectorNextResults retrieves the next set of results, if any.
func (client FhirDestinationsClient) listByIotConnectorNextResults(ctx context.Context, lastResults IotFhirDestinationCollection) (result IotFhirDestinationCollection, err error) {
	req, err := lastResults.iotFhirDestinationCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "healthcareapis.FhirDestinationsClient", "listByIotConnectorNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListByIotConnectorSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "healthcareapis.FhirDestinationsClient", "listByIotConnectorNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListByIotConnectorResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "healthcareapis.FhirDestinationsClient", "listByIotConnectorNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListByIotConnectorComplete enumerates all values, automatically crossing page boundaries as required.
func (client FhirDestinationsClient) ListByIotConnectorComplete(ctx context.Context, resourceGroupName string, workspaceName string, iotConnectorName string) (result IotFhirDestinationCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/FhirDestinationsClient.ListByIotConnector")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListByIotConnector(ctx, resourceGroupName, workspaceName, iotConnectorName)
	return
}
