package keyvault

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"github.com/gofrs/uuid"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/keyvault/mgmt/2020-04-01-preview/keyvault"

// AccessPolicyEntry an identity that have access to the key vault. All identities in the array must use
// the same tenant ID as the key vault's tenant ID.
type AccessPolicyEntry struct {
	// TenantID - The Azure Active Directory tenant ID that should be used for authenticating requests to the key vault.
	TenantID *uuid.UUID `json:"tenantId,omitempty"`
	// ObjectID - The object ID of a user, service principal or security group in the Azure Active Directory tenant for the vault. The object ID must be unique for the list of access policies.
	ObjectID *string `json:"objectId,omitempty"`
	// ApplicationID -  Application ID of the client making request on behalf of a principal
	ApplicationID *uuid.UUID `json:"applicationId,omitempty"`
	// Permissions - Permissions the identity has for keys, secrets and certificates.
	Permissions *Permissions `json:"permissions,omitempty"`
}

// CheckNameAvailabilityResult the CheckNameAvailability operation response.
type CheckNameAvailabilityResult struct {
	autorest.Response `json:"-"`
	// NameAvailable - READ-ONLY; A boolean value that indicates whether the name is available for you to use. If true, the name is available. If false, the name has already been taken or is invalid and cannot be used.
	NameAvailable *bool `json:"nameAvailable,omitempty"`
	// Reason - READ-ONLY; The reason that a vault name could not be used. The Reason element is only returned if NameAvailable is false. Possible values include: 'AccountNameInvalid', 'AlreadyExists'
	Reason Reason `json:"reason,omitempty"`
	// Message - READ-ONLY; An error message explaining the Reason value in more detail.
	Message *string `json:"message,omitempty"`
}

// MarshalJSON is the custom marshaler for CheckNameAvailabilityResult.
func (cnar CheckNameAvailabilityResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// CloudError an error response from Key Vault resource provider
type CloudError struct {
	Error *CloudErrorBody `json:"error,omitempty"`
}

// CloudErrorBody an error response from Key Vault resource provider
type CloudErrorBody struct {
	// Code - Error code. This is a mnemonic that can be consumed programmatically.
	Code *string `json:"code,omitempty"`
	// Message - User friendly error message. The message is typically localized and may vary with service version.
	Message *string `json:"message,omitempty"`
}

// DeletedVault deleted vault information with extended details.
type DeletedVault struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; The resource ID for the deleted key vault.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the key vault.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The resource type of the key vault.
	Type *string `json:"type,omitempty"`
	// Properties - Properties of the vault
	Properties *DeletedVaultProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for DeletedVault.
func (dv DeletedVault) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dv.Properties != nil {
		objectMap["properties"] = dv.Properties
	}
	return json.Marshal(objectMap)
}

// DeletedVaultListResult list of vaults
type DeletedVaultListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of deleted vaults.
	Value *[]DeletedVault `json:"value,omitempty"`
	// NextLink - The URL to get the next set of deleted vaults.
	NextLink *string `json:"nextLink,omitempty"`
}

// DeletedVaultListResultIterator provides access to a complete listing of DeletedVault values.
type DeletedVaultListResultIterator struct {
	i    int
	page DeletedVaultListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DeletedVaultListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DeletedVaultListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DeletedVaultListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DeletedVaultListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DeletedVaultListResultIterator) Response() DeletedVaultListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DeletedVaultListResultIterator) Value() DeletedVault {
	if !iter.page.NotDone() {
		return DeletedVault{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DeletedVaultListResultIterator type.
func NewDeletedVaultListResultIterator(page DeletedVaultListResultPage) DeletedVaultListResultIterator {
	return DeletedVaultListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dvlr DeletedVaultListResult) IsEmpty() bool {
	return dvlr.Value == nil || len(*dvlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dvlr DeletedVaultListResult) hasNextLink() bool {
	return dvlr.NextLink != nil && len(*dvlr.NextLink) != 0
}

// deletedVaultListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dvlr DeletedVaultListResult) deletedVaultListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !dvlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dvlr.NextLink)))
}

// DeletedVaultListResultPage contains a page of DeletedVault values.
type DeletedVaultListResultPage struct {
	fn   func(context.Context, DeletedVaultListResult) (DeletedVaultListResult, error)
	dvlr DeletedVaultListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DeletedVaultListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DeletedVaultListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dvlr)
		if err != nil {
			return err
		}
		page.dvlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DeletedVaultListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DeletedVaultListResultPage) NotDone() bool {
	return !page.dvlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DeletedVaultListResultPage) Response() DeletedVaultListResult {
	return page.dvlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DeletedVaultListResultPage) Values() []DeletedVault {
	if page.dvlr.IsEmpty() {
		return nil
	}
	return *page.dvlr.Value
}

// Creates a new instance of the DeletedVaultListResultPage type.
func NewDeletedVaultListResultPage(cur DeletedVaultListResult, getNextPage func(context.Context, DeletedVaultListResult) (DeletedVaultListResult, error)) DeletedVaultListResultPage {
	return DeletedVaultListResultPage{
		fn:   getNextPage,
		dvlr: cur,
	}
}

// DeletedVaultProperties properties of the deleted vault.
type DeletedVaultProperties struct {
	// VaultID - READ-ONLY; The resource id of the original vault.
	VaultID *string `json:"vaultId,omitempty"`
	// Location - READ-ONLY; The location of the original vault.
	Location *string `json:"location,omitempty"`
	// DeletionDate - READ-ONLY; The deleted date.
	DeletionDate *date.Time `json:"deletionDate,omitempty"`
	// ScheduledPurgeDate - READ-ONLY; The scheduled purged date.
	ScheduledPurgeDate *date.Time `json:"scheduledPurgeDate,omitempty"`
	// Tags - READ-ONLY; Tags of the original vault.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for DeletedVaultProperties.
func (dvp DeletedVaultProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// Error the server error.
type Error struct {
	// Code - READ-ONLY; The error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; The error message.
	Message *string `json:"message,omitempty"`
	// InnerError - READ-ONLY; The inner error, contains a more specific error code.
	InnerError *Error `json:"innererror,omitempty"`
}

// MarshalJSON is the custom marshaler for Error.
func (e Error) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// IPRule a rule governing the accessibility of a vault from a specific ip address or ip range.
type IPRule struct {
	// Value - An IPv4 address range in CIDR notation, such as '124.56.78.91' (simple IP address) or '124.56.78.0/24' (all addresses that start with 124.56.78).
	Value *string `json:"value,omitempty"`
}

// LogSpecification log specification of operation.
type LogSpecification struct {
	// Name - Name of log specification.
	Name *string `json:"name,omitempty"`
	// DisplayName - Display name of log specification.
	DisplayName *string `json:"displayName,omitempty"`
	// BlobDuration - Blob duration of specification.
	BlobDuration *string `json:"blobDuration,omitempty"`
}

// ManagedHsm resource information with extended details.
type ManagedHsm struct {
	autorest.Response `json:"-"`
	// Properties - Properties of the managed HSM
	Properties *ManagedHsmProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The Azure Resource Manager resource ID for the managed HSM Pool.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the managed HSM Pool.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The resource type of the managed HSM Pool.
	Type *string `json:"type,omitempty"`
	// Location - The supported Azure location where the managed HSM Pool should be created.
	Location *string `json:"location,omitempty"`
	// Sku - SKU details
	Sku *ManagedHsmSku `json:"sku,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ManagedHsm.
func (mh ManagedHsm) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mh.Properties != nil {
		objectMap["properties"] = mh.Properties
	}
	if mh.Location != nil {
		objectMap["location"] = mh.Location
	}
	if mh.Sku != nil {
		objectMap["sku"] = mh.Sku
	}
	if mh.Tags != nil {
		objectMap["tags"] = mh.Tags
	}
	return json.Marshal(objectMap)
}

// ManagedHsmError the error exception.
type ManagedHsmError struct {
	// Error - READ-ONLY; The server error.
	Error *Error `json:"error,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedHsmError.
func (mhe ManagedHsmError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ManagedHsmListResult list of managed HSM Pools
type ManagedHsmListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of managed HSM Pools.
	Value *[]ManagedHsm `json:"value,omitempty"`
	// NextLink - The URL to get the next set of managed HSM Pools.
	NextLink *string `json:"nextLink,omitempty"`
}

// ManagedHsmListResultIterator provides access to a complete listing of ManagedHsm values.
type ManagedHsmListResultIterator struct {
	i    int
	page ManagedHsmListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ManagedHsmListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedHsmListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ManagedHsmListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ManagedHsmListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ManagedHsmListResultIterator) Response() ManagedHsmListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ManagedHsmListResultIterator) Value() ManagedHsm {
	if !iter.page.NotDone() {
		return ManagedHsm{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ManagedHsmListResultIterator type.
func NewManagedHsmListResultIterator(page ManagedHsmListResultPage) ManagedHsmListResultIterator {
	return ManagedHsmListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (mhlr ManagedHsmListResult) IsEmpty() bool {
	return mhlr.Value == nil || len(*mhlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (mhlr ManagedHsmListResult) hasNextLink() bool {
	return mhlr.NextLink != nil && len(*mhlr.NextLink) != 0
}

// managedHsmListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (mhlr ManagedHsmListResult) managedHsmListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !mhlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(mhlr.NextLink)))
}

// ManagedHsmListResultPage contains a page of ManagedHsm values.
type ManagedHsmListResultPage struct {
	fn   func(context.Context, ManagedHsmListResult) (ManagedHsmListResult, error)
	mhlr ManagedHsmListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ManagedHsmListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedHsmListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.mhlr)
		if err != nil {
			return err
		}
		page.mhlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ManagedHsmListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ManagedHsmListResultPage) NotDone() bool {
	return !page.mhlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ManagedHsmListResultPage) Response() ManagedHsmListResult {
	return page.mhlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ManagedHsmListResultPage) Values() []ManagedHsm {
	if page.mhlr.IsEmpty() {
		return nil
	}
	return *page.mhlr.Value
}

// Creates a new instance of the ManagedHsmListResultPage type.
func NewManagedHsmListResultPage(cur ManagedHsmListResult, getNextPage func(context.Context, ManagedHsmListResult) (ManagedHsmListResult, error)) ManagedHsmListResultPage {
	return ManagedHsmListResultPage{
		fn:   getNextPage,
		mhlr: cur,
	}
}

// ManagedHsmProperties properties of the managed HSM Pool
type ManagedHsmProperties struct {
	// TenantID - The Azure Active Directory tenant ID that should be used for authenticating requests to the managed HSM pool.
	TenantID *uuid.UUID `json:"tenantId,omitempty"`
	// InitialAdminObjectIds - Array of initial administrators object ids for this managed hsm pool.
	InitialAdminObjectIds *[]string `json:"initialAdminObjectIds,omitempty"`
	// HsmURI - The URI of the managed hsm pool for performing operations on keys.
	HsmURI *string `json:"hsmUri,omitempty"`
	// EnableSoftDelete - Property to specify whether the 'soft delete' functionality is enabled for this managed HSM pool. If it's not set to any value(true or false) when creating new managed HSM pool, it will be set to true by default. Once set to true, it cannot be reverted to false.
	EnableSoftDelete *bool `json:"enableSoftDelete,omitempty"`
	// SoftDeleteRetentionInDays - softDelete data retention days. It accepts >=7 and <=90.
	SoftDeleteRetentionInDays *int32 `json:"softDeleteRetentionInDays,omitempty"`
	// EnablePurgeProtection - Property specifying whether protection against purge is enabled for this managed HSM pool. Setting this property to true activates protection against purge for this managed HSM pool and its content - only the Managed HSM service may initiate a hard, irrecoverable deletion. The setting is effective only if soft delete is also enabled. Enabling this functionality is irreversible.
	EnablePurgeProtection *bool `json:"enablePurgeProtection,omitempty"`
	// CreateMode - The create mode to indicate whether the resource is being created or is being recovered from a deleted resource. Possible values include: 'CreateModeRecover', 'CreateModeDefault'
	CreateMode CreateMode `json:"createMode,omitempty"`
	// StatusMessage - READ-ONLY; Resource Status Message.
	StatusMessage *string `json:"statusMessage,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning state. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateProvisioning', 'ProvisioningStateFailed', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateActivated', 'ProvisioningStateSecurityDomainRestore', 'ProvisioningStateRestoring'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedHsmProperties.
func (mhp ManagedHsmProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mhp.TenantID != nil {
		objectMap["tenantId"] = mhp.TenantID
	}
	if mhp.InitialAdminObjectIds != nil {
		objectMap["initialAdminObjectIds"] = mhp.InitialAdminObjectIds
	}
	if mhp.HsmURI != nil {
		objectMap["hsmUri"] = mhp.HsmURI
	}
	if mhp.EnableSoftDelete != nil {
		objectMap["enableSoftDelete"] = mhp.EnableSoftDelete
	}
	if mhp.SoftDeleteRetentionInDays != nil {
		objectMap["softDeleteRetentionInDays"] = mhp.SoftDeleteRetentionInDays
	}
	if mhp.EnablePurgeProtection != nil {
		objectMap["enablePurgeProtection"] = mhp.EnablePurgeProtection
	}
	if mhp.CreateMode != "" {
		objectMap["createMode"] = mhp.CreateMode
	}
	return json.Marshal(objectMap)
}

// ManagedHsmResource managed HSM resource
type ManagedHsmResource struct {
	// ID - READ-ONLY; The Azure Resource Manager resource ID for the managed HSM Pool.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the managed HSM Pool.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The resource type of the managed HSM Pool.
	Type *string `json:"type,omitempty"`
	// Location - The supported Azure location where the managed HSM Pool should be created.
	Location *string `json:"location,omitempty"`
	// Sku - SKU details
	Sku *ManagedHsmSku `json:"sku,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ManagedHsmResource.
func (mhr ManagedHsmResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mhr.Location != nil {
		objectMap["location"] = mhr.Location
	}
	if mhr.Sku != nil {
		objectMap["sku"] = mhr.Sku
	}
	if mhr.Tags != nil {
		objectMap["tags"] = mhr.Tags
	}
	return json.Marshal(objectMap)
}

// ManagedHsmsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ManagedHsmsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ManagedHsmsClient) (ManagedHsm, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ManagedHsmsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ManagedHsmsCreateOrUpdateFuture.Result.
func (future *ManagedHsmsCreateOrUpdateFuture) result(client ManagedHsmsClient) (mh ManagedHsm, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "keyvault.ManagedHsmsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		mh.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("keyvault.ManagedHsmsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if mh.Response.Response, err = future.GetResult(sender); err == nil && mh.Response.Response.StatusCode != http.StatusNoContent {
		mh, err = client.CreateOrUpdateResponder(mh.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "keyvault.ManagedHsmsCreateOrUpdateFuture", "Result", mh.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ManagedHsmsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ManagedHsmsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ManagedHsmsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ManagedHsmsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ManagedHsmsDeleteFuture.Result.
func (future *ManagedHsmsDeleteFuture) result(client ManagedHsmsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "keyvault.ManagedHsmsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("keyvault.ManagedHsmsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ManagedHsmSku SKU details
type ManagedHsmSku struct {
	// Family - SKU Family of the managed HSM Pool
	Family *string `json:"family,omitempty"`
	// Name - SKU of the managed HSM Pool. Possible values include: 'StandardB1', 'CustomB32'
	Name ManagedHsmSkuName `json:"name,omitempty"`
}

// ManagedHsmsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ManagedHsmsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ManagedHsmsClient) (ManagedHsm, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ManagedHsmsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ManagedHsmsUpdateFuture.Result.
func (future *ManagedHsmsUpdateFuture) result(client ManagedHsmsClient) (mh ManagedHsm, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "keyvault.ManagedHsmsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		mh.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("keyvault.ManagedHsmsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if mh.Response.Response, err = future.GetResult(sender); err == nil && mh.Response.Response.StatusCode != http.StatusNoContent {
		mh, err = client.UpdateResponder(mh.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "keyvault.ManagedHsmsUpdateFuture", "Result", mh.Response.Response, "Failure responding to request")
		}
	}
	return
}

// NetworkRuleSet a set of rules governing the network accessibility of a vault.
type NetworkRuleSet struct {
	// Bypass - Tells what traffic can bypass network rules. This can be 'AzureServices' or 'None'.  If not specified the default is 'AzureServices'. Possible values include: 'AzureServices', 'None'
	Bypass NetworkRuleBypassOptions `json:"bypass,omitempty"`
	// DefaultAction - The default action when no rule from ipRules and from virtualNetworkRules match. This is only used after the bypass property has been evaluated. Possible values include: 'Allow', 'Deny'
	DefaultAction NetworkRuleAction `json:"defaultAction,omitempty"`
	// IPRules - The list of IP address rules.
	IPRules *[]IPRule `json:"ipRules,omitempty"`
	// VirtualNetworkRules - The list of virtual network rules.
	VirtualNetworkRules *[]VirtualNetworkRule `json:"virtualNetworkRules,omitempty"`
}

// Operation key Vault REST API operation definition.
type Operation struct {
	// Name - Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
	// Display - Display metadata associated with the operation.
	Display *OperationDisplay `json:"display,omitempty"`
	// Origin - The origin of operations.
	Origin *string `json:"origin,omitempty"`
	// OperationProperties - Properties of operation, include metric specifications.
	*OperationProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if o.Name != nil {
		objectMap["name"] = o.Name
	}
	if o.Display != nil {
		objectMap["display"] = o.Display
	}
	if o.Origin != nil {
		objectMap["origin"] = o.Origin
	}
	if o.OperationProperties != nil {
		objectMap["properties"] = o.OperationProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Operation struct.
func (o *Operation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				o.Name = &name
			}
		case "display":
			if v != nil {
				var display OperationDisplay
				err = json.Unmarshal(*v, &display)
				if err != nil {
					return err
				}
				o.Display = &display
			}
		case "origin":
			if v != nil {
				var origin string
				err = json.Unmarshal(*v, &origin)
				if err != nil {
					return err
				}
				o.Origin = &origin
			}
		case "properties":
			if v != nil {
				var operationProperties OperationProperties
				err = json.Unmarshal(*v, &operationProperties)
				if err != nil {
					return err
				}
				o.OperationProperties = &operationProperties
			}
		}
	}

	return nil
}

// OperationDisplay display metadata associated with the operation.
type OperationDisplay struct {
	// Provider - Service provider: Microsoft Key Vault.
	Provider *string `json:"provider,omitempty"`
	// Resource - Resource on which the operation is performed etc.
	Resource *string `json:"resource,omitempty"`
	// Operation - Type of operation: get, read, delete, etc.
	Operation *string `json:"operation,omitempty"`
	// Description - Description of operation.
	Description *string `json:"description,omitempty"`
}

// OperationListResult result of the request to list Storage operations. It contains a list of operations
// and a URL link to get the next set of results.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - List of Storage operations supported by the Storage resource provider.
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - The URL to get the next set of operations.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationListResultIterator provides access to a complete listing of Operation values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListResultIterator type.
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return OperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (olr OperationListResult) hasNextLink() bool {
	return olr.NextLink != nil && len(*olr.NextLink) != 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !olr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of Operation values.
type OperationListResultPage struct {
	fn  func(context.Context, OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.olr)
		if err != nil {
			return err
		}
		page.olr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []Operation {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OperationListResultPage type.
func NewOperationListResultPage(cur OperationListResult, getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return OperationListResultPage{
		fn:  getNextPage,
		olr: cur,
	}
}

// OperationProperties properties of operation, include metric specifications.
type OperationProperties struct {
	// ServiceSpecification - One property of operation, include metric specifications.
	ServiceSpecification *ServiceSpecification `json:"serviceSpecification,omitempty"`
}

// Permissions permissions the identity has for keys, secrets, certificates and storage.
type Permissions struct {
	// Keys - Permissions to keys
	Keys *[]KeyPermissions `json:"keys,omitempty"`
	// Secrets - Permissions to secrets
	Secrets *[]SecretPermissions `json:"secrets,omitempty"`
	// Certificates - Permissions to certificates
	Certificates *[]CertificatePermissions `json:"certificates,omitempty"`
	// Storage - Permissions to storage accounts
	Storage *[]StoragePermissions `json:"storage,omitempty"`
}

// PrivateEndpoint private endpoint object properties.
type PrivateEndpoint struct {
	// ID - READ-ONLY; Full identifier of the private endpoint resource.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateEndpoint.
func (peVar PrivateEndpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// PrivateEndpointConnection private endpoint connection resource.
type PrivateEndpointConnection struct {
	autorest.Response `json:"-"`
	// PrivateEndpointConnectionProperties - Resource properties.
	*PrivateEndpointConnectionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified identifier of the key vault resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Name of the key vault resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type of the key vault resource.
	Type *string `json:"type,omitempty"`
	// Location - READ-ONLY; Azure location of the key vault resource.
	Location *string `json:"location,omitempty"`
	// Tags - READ-ONLY; Tags assigned to the key vault resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for PrivateEndpointConnection.
func (pec PrivateEndpointConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pec.PrivateEndpointConnectionProperties != nil {
		objectMap["properties"] = pec.PrivateEndpointConnectionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PrivateEndpointConnection struct.
func (pec *PrivateEndpointConnection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var privateEndpointConnectionProperties PrivateEndpointConnectionProperties
				err = json.Unmarshal(*v, &privateEndpointConnectionProperties)
				if err != nil {
					return err
				}
				pec.PrivateEndpointConnectionProperties = &privateEndpointConnectionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pec.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pec.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pec.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				pec.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				pec.Tags = tags
			}
		}
	}

	return nil
}

// PrivateEndpointConnectionItem private endpoint connection item.
type PrivateEndpointConnectionItem struct {
	// PrivateEndpointConnectionProperties - Private endpoint connection properties.
	*PrivateEndpointConnectionProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateEndpointConnectionItem.
func (peci PrivateEndpointConnectionItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if peci.PrivateEndpointConnectionProperties != nil {
		objectMap["properties"] = peci.PrivateEndpointConnectionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PrivateEndpointConnectionItem struct.
func (peci *PrivateEndpointConnectionItem) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var privateEndpointConnectionProperties PrivateEndpointConnectionProperties
				err = json.Unmarshal(*v, &privateEndpointConnectionProperties)
				if err != nil {
					return err
				}
				peci.PrivateEndpointConnectionProperties = &privateEndpointConnectionProperties
			}
		}
	}

	return nil
}

// PrivateEndpointConnectionProperties properties of the private endpoint connection resource.
type PrivateEndpointConnectionProperties struct {
	// PrivateEndpoint - Properties of the private endpoint object.
	PrivateEndpoint *PrivateEndpoint `json:"privateEndpoint,omitempty"`
	// PrivateLinkServiceConnectionState - Approval state of the private link connection.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState `json:"privateLinkServiceConnectionState,omitempty"`
	// ProvisioningState - Provisioning state of the private endpoint connection. Possible values include: 'Succeeded', 'Creating', 'Updating', 'Deleting', 'Failed', 'Disconnected'
	ProvisioningState PrivateEndpointConnectionProvisioningState `json:"provisioningState,omitempty"`
}

// PrivateEndpointConnectionsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type PrivateEndpointConnectionsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PrivateEndpointConnectionsClient) (PrivateEndpointConnection, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *PrivateEndpointConnectionsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for PrivateEndpointConnectionsDeleteFuture.Result.
func (future *PrivateEndpointConnectionsDeleteFuture) result(client PrivateEndpointConnectionsClient) (pec PrivateEndpointConnection, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "keyvault.PrivateEndpointConnectionsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		pec.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("keyvault.PrivateEndpointConnectionsDeleteFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if pec.Response.Response, err = future.GetResult(sender); err == nil && pec.Response.Response.StatusCode != http.StatusNoContent {
		pec, err = client.DeleteResponder(pec.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "keyvault.PrivateEndpointConnectionsDeleteFuture", "Result", pec.Response.Response, "Failure responding to request")
		}
	}
	return
}

// PrivateLinkResource a private link resource
type PrivateLinkResource struct {
	// PrivateLinkResourceProperties - Resource properties.
	*PrivateLinkResourceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified identifier of the key vault resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Name of the key vault resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type of the key vault resource.
	Type *string `json:"type,omitempty"`
	// Location - READ-ONLY; Azure location of the key vault resource.
	Location *string `json:"location,omitempty"`
	// Tags - READ-ONLY; Tags assigned to the key vault resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for PrivateLinkResource.
func (plr PrivateLinkResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if plr.PrivateLinkResourceProperties != nil {
		objectMap["properties"] = plr.PrivateLinkResourceProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PrivateLinkResource struct.
func (plr *PrivateLinkResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var privateLinkResourceProperties PrivateLinkResourceProperties
				err = json.Unmarshal(*v, &privateLinkResourceProperties)
				if err != nil {
					return err
				}
				plr.PrivateLinkResourceProperties = &privateLinkResourceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				plr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				plr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				plr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				plr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				plr.Tags = tags
			}
		}
	}

	return nil
}

// PrivateLinkResourceListResult a list of private link resources
type PrivateLinkResourceListResult struct {
	autorest.Response `json:"-"`
	// Value - Array of private link resources
	Value *[]PrivateLinkResource `json:"value,omitempty"`
}

// PrivateLinkResourceProperties properties of a private link resource.
type PrivateLinkResourceProperties struct {
	// GroupID - READ-ONLY; Group identifier of private link resource.
	GroupID *string `json:"groupId,omitempty"`
	// RequiredMembers - READ-ONLY; Required member names of private link resource.
	RequiredMembers *[]string `json:"requiredMembers,omitempty"`
	// RequiredZoneNames - Required DNS zone names of the the private link resource.
	RequiredZoneNames *[]string `json:"requiredZoneNames,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateLinkResourceProperties.
func (plrp PrivateLinkResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if plrp.RequiredZoneNames != nil {
		objectMap["requiredZoneNames"] = plrp.RequiredZoneNames
	}
	return json.Marshal(objectMap)
}

// PrivateLinkServiceConnectionState an object that represents the approval state of the private link
// connection.
type PrivateLinkServiceConnectionState struct {
	// Status - Indicates whether the connection has been approved, rejected or removed by the key vault owner. Possible values include: 'PrivateEndpointServiceConnectionStatusPending', 'PrivateEndpointServiceConnectionStatusApproved', 'PrivateEndpointServiceConnectionStatusRejected', 'PrivateEndpointServiceConnectionStatusDisconnected'
	Status PrivateEndpointServiceConnectionStatus `json:"status,omitempty"`
	// Description - The reason for approval or rejection.
	Description *string `json:"description,omitempty"`
	// ActionRequired - A message indicating if changes on the service provider require any updates on the consumer.
	ActionRequired *string `json:"actionRequired,omitempty"`
}

// Resource key Vault resource
type Resource struct {
	// ID - READ-ONLY; Fully qualified identifier of the key vault resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Name of the key vault resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type of the key vault resource.
	Type *string `json:"type,omitempty"`
	// Location - READ-ONLY; Azure location of the key vault resource.
	Location *string `json:"location,omitempty"`
	// Tags - READ-ONLY; Tags assigned to the key vault resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ResourceListResult list of vault resources.
type ResourceListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of vault resources.
	Value *[]Resource `json:"value,omitempty"`
	// NextLink - The URL to get the next set of vault resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// ResourceListResultIterator provides access to a complete listing of Resource values.
type ResourceListResultIterator struct {
	i    int
	page ResourceListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ResourceListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ResourceListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ResourceListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ResourceListResultIterator) Response() ResourceListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ResourceListResultIterator) Value() Resource {
	if !iter.page.NotDone() {
		return Resource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ResourceListResultIterator type.
func NewResourceListResultIterator(page ResourceListResultPage) ResourceListResultIterator {
	return ResourceListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rlr ResourceListResult) IsEmpty() bool {
	return rlr.Value == nil || len(*rlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rlr ResourceListResult) hasNextLink() bool {
	return rlr.NextLink != nil && len(*rlr.NextLink) != 0
}

// resourceListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rlr ResourceListResult) resourceListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !rlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rlr.NextLink)))
}

// ResourceListResultPage contains a page of Resource values.
type ResourceListResultPage struct {
	fn  func(context.Context, ResourceListResult) (ResourceListResult, error)
	rlr ResourceListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ResourceListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rlr)
		if err != nil {
			return err
		}
		page.rlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ResourceListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ResourceListResultPage) NotDone() bool {
	return !page.rlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ResourceListResultPage) Response() ResourceListResult {
	return page.rlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ResourceListResultPage) Values() []Resource {
	if page.rlr.IsEmpty() {
		return nil
	}
	return *page.rlr.Value
}

// Creates a new instance of the ResourceListResultPage type.
func NewResourceListResultPage(cur ResourceListResult, getNextPage func(context.Context, ResourceListResult) (ResourceListResult, error)) ResourceListResultPage {
	return ResourceListResultPage{
		fn:  getNextPage,
		rlr: cur,
	}
}

// ServiceSpecification one property of operation, include log specifications.
type ServiceSpecification struct {
	// LogSpecifications - Log specifications of operation.
	LogSpecifications *[]LogSpecification `json:"logSpecifications,omitempty"`
}

// Sku SKU details
type Sku struct {
	// Family - SKU family name
	Family *string `json:"family,omitempty"`
	// Name - SKU name to specify whether the key vault is a standard vault or a premium vault. Possible values include: 'Standard', 'Premium'
	Name SkuName `json:"name,omitempty"`
}

// Vault resource information with extended details.
type Vault struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Fully qualified identifier of the key vault resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Name of the key vault resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type of the key vault resource.
	Type *string `json:"type,omitempty"`
	// Location - Azure location of the key vault resource.
	Location *string `json:"location,omitempty"`
	// Tags - Tags assigned to the key vault resource.
	Tags map[string]*string `json:"tags"`
	// Properties - Properties of the vault
	Properties *VaultProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for Vault.
func (vVar Vault) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vVar.Location != nil {
		objectMap["location"] = vVar.Location
	}
	if vVar.Tags != nil {
		objectMap["tags"] = vVar.Tags
	}
	if vVar.Properties != nil {
		objectMap["properties"] = vVar.Properties
	}
	return json.Marshal(objectMap)
}

// VaultAccessPolicyParameters parameters for updating the access policy in a vault
type VaultAccessPolicyParameters struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; The resource id of the access policy.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The resource name of the access policy.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The resource name of the access policy.
	Type *string `json:"type,omitempty"`
	// Location - READ-ONLY; The resource type of the access policy.
	Location *string `json:"location,omitempty"`
	// Properties - Properties of the access policy
	Properties *VaultAccessPolicyProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for VaultAccessPolicyParameters.
func (vapp VaultAccessPolicyParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vapp.Properties != nil {
		objectMap["properties"] = vapp.Properties
	}
	return json.Marshal(objectMap)
}

// VaultAccessPolicyProperties properties of the vault access policy
type VaultAccessPolicyProperties struct {
	// AccessPolicies - An array of 0 to 16 identities that have access to the key vault. All identities in the array must use the same tenant ID as the key vault's tenant ID.
	AccessPolicies *[]AccessPolicyEntry `json:"accessPolicies,omitempty"`
}

// VaultCheckNameAvailabilityParameters the parameters used to check the availability of the vault name.
type VaultCheckNameAvailabilityParameters struct {
	// Name - The vault name.
	Name *string `json:"name,omitempty"`
	// Type - The type of resource, Microsoft.KeyVault/vaults
	Type *string `json:"type,omitempty"`
}

// VaultCreateOrUpdateParameters parameters for creating or updating a vault
type VaultCreateOrUpdateParameters struct {
	// Location - The supported Azure location where the key vault should be created.
	Location *string `json:"location,omitempty"`
	// Tags - The tags that will be assigned to the key vault.
	Tags map[string]*string `json:"tags"`
	// Properties - Properties of the vault
	Properties *VaultProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for VaultCreateOrUpdateParameters.
func (vcoup VaultCreateOrUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vcoup.Location != nil {
		objectMap["location"] = vcoup.Location
	}
	if vcoup.Tags != nil {
		objectMap["tags"] = vcoup.Tags
	}
	if vcoup.Properties != nil {
		objectMap["properties"] = vcoup.Properties
	}
	return json.Marshal(objectMap)
}

// VaultListResult list of vaults
type VaultListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of vaults.
	Value *[]Vault `json:"value,omitempty"`
	// NextLink - The URL to get the next set of vaults.
	NextLink *string `json:"nextLink,omitempty"`
}

// VaultListResultIterator provides access to a complete listing of Vault values.
type VaultListResultIterator struct {
	i    int
	page VaultListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *VaultListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VaultListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *VaultListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter VaultListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter VaultListResultIterator) Response() VaultListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter VaultListResultIterator) Value() Vault {
	if !iter.page.NotDone() {
		return Vault{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the VaultListResultIterator type.
func NewVaultListResultIterator(page VaultListResultPage) VaultListResultIterator {
	return VaultListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (vlr VaultListResult) IsEmpty() bool {
	return vlr.Value == nil || len(*vlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (vlr VaultListResult) hasNextLink() bool {
	return vlr.NextLink != nil && len(*vlr.NextLink) != 0
}

// vaultListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (vlr VaultListResult) vaultListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !vlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(vlr.NextLink)))
}

// VaultListResultPage contains a page of Vault values.
type VaultListResultPage struct {
	fn  func(context.Context, VaultListResult) (VaultListResult, error)
	vlr VaultListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *VaultListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VaultListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.vlr)
		if err != nil {
			return err
		}
		page.vlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *VaultListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page VaultListResultPage) NotDone() bool {
	return !page.vlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page VaultListResultPage) Response() VaultListResult {
	return page.vlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page VaultListResultPage) Values() []Vault {
	if page.vlr.IsEmpty() {
		return nil
	}
	return *page.vlr.Value
}

// Creates a new instance of the VaultListResultPage type.
func NewVaultListResultPage(cur VaultListResult, getNextPage func(context.Context, VaultListResult) (VaultListResult, error)) VaultListResultPage {
	return VaultListResultPage{
		fn:  getNextPage,
		vlr: cur,
	}
}

// VaultPatchParameters parameters for creating or updating a vault
type VaultPatchParameters struct {
	// Tags - The tags that will be assigned to the key vault.
	Tags map[string]*string `json:"tags"`
	// Properties - Properties of the vault
	Properties *VaultPatchProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for VaultPatchParameters.
func (vpp VaultPatchParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vpp.Tags != nil {
		objectMap["tags"] = vpp.Tags
	}
	if vpp.Properties != nil {
		objectMap["properties"] = vpp.Properties
	}
	return json.Marshal(objectMap)
}

// VaultPatchProperties properties of the vault
type VaultPatchProperties struct {
	// TenantID - The Azure Active Directory tenant ID that should be used for authenticating requests to the key vault.
	TenantID *uuid.UUID `json:"tenantId,omitempty"`
	// Sku - SKU details
	Sku *Sku `json:"sku,omitempty"`
	// AccessPolicies - An array of 0 to 16 identities that have access to the key vault. All identities in the array must use the same tenant ID as the key vault's tenant ID.
	AccessPolicies *[]AccessPolicyEntry `json:"accessPolicies,omitempty"`
	// EnabledForDeployment - Property to specify whether Azure Virtual Machines are permitted to retrieve certificates stored as secrets from the key vault.
	EnabledForDeployment *bool `json:"enabledForDeployment,omitempty"`
	// EnabledForDiskEncryption - Property to specify whether Azure Disk Encryption is permitted to retrieve secrets from the vault and unwrap keys.
	EnabledForDiskEncryption *bool `json:"enabledForDiskEncryption,omitempty"`
	// EnabledForTemplateDeployment - Property to specify whether Azure Resource Manager is permitted to retrieve secrets from the key vault.
	EnabledForTemplateDeployment *bool `json:"enabledForTemplateDeployment,omitempty"`
	// EnableSoftDelete - Property to specify whether the 'soft delete' functionality is enabled for this key vault. Once set to true, it cannot be reverted to false.
	EnableSoftDelete *bool `json:"enableSoftDelete,omitempty"`
	// EnableRbacAuthorization - Property that controls how data actions are authorized. When true, the key vault will use Role Based Access Control (RBAC) for authorization of data actions, and the access policies specified in vault properties will be  ignored (warning: this is a preview feature). When false, the key vault will use the access policies specified in vault properties, and any policy stored on Azure Resource Manager will be ignored. If null or not specified, the value of this property will not change.
	EnableRbacAuthorization *bool `json:"enableRbacAuthorization,omitempty"`
	// SoftDeleteRetentionInDays - softDelete data retention days. It accepts >=7 and <=90.
	SoftDeleteRetentionInDays *int32 `json:"softDeleteRetentionInDays,omitempty"`
	// CreateMode - The vault's create mode to indicate whether the vault need to be recovered or not. Possible values include: 'CreateModeRecover', 'CreateModeDefault'
	CreateMode CreateMode `json:"createMode,omitempty"`
	// EnablePurgeProtection - Property specifying whether protection against purge is enabled for this vault. Setting this property to true activates protection against purge for this vault and its content - only the Key Vault service may initiate a hard, irrecoverable deletion. The setting is effective only if soft delete is also enabled. Enabling this functionality is irreversible - that is, the property does not accept false as its value.
	EnablePurgeProtection *bool `json:"enablePurgeProtection,omitempty"`
	// NetworkAcls - A collection of rules governing the accessibility of the vault from specific network locations.
	NetworkAcls *NetworkRuleSet `json:"networkAcls,omitempty"`
}

// VaultProperties properties of the vault
type VaultProperties struct {
	// TenantID - The Azure Active Directory tenant ID that should be used for authenticating requests to the key vault.
	TenantID *uuid.UUID `json:"tenantId,omitempty"`
	// Sku - SKU details
	Sku *Sku `json:"sku,omitempty"`
	// AccessPolicies - An array of 0 to 1024 identities that have access to the key vault. All identities in the array must use the same tenant ID as the key vault's tenant ID. When `createMode` is set to `recover`, access policies are not required. Otherwise, access policies are required.
	AccessPolicies *[]AccessPolicyEntry `json:"accessPolicies,omitempty"`
	// VaultURI - The URI of the vault for performing operations on keys and secrets.
	VaultURI *string `json:"vaultUri,omitempty"`
	// EnabledForDeployment - Property to specify whether Azure Virtual Machines are permitted to retrieve certificates stored as secrets from the key vault.
	EnabledForDeployment *bool `json:"enabledForDeployment,omitempty"`
	// EnabledForDiskEncryption - Property to specify whether Azure Disk Encryption is permitted to retrieve secrets from the vault and unwrap keys.
	EnabledForDiskEncryption *bool `json:"enabledForDiskEncryption,omitempty"`
	// EnabledForTemplateDeployment - Property to specify whether Azure Resource Manager is permitted to retrieve secrets from the key vault.
	EnabledForTemplateDeployment *bool `json:"enabledForTemplateDeployment,omitempty"`
	// EnableSoftDelete - Property to specify whether the 'soft delete' functionality is enabled for this key vault. If it's not set to any value(true or false) when creating new key vault, it will be set to true by default. Once set to true, it cannot be reverted to false.
	EnableSoftDelete *bool `json:"enableSoftDelete,omitempty"`
	// SoftDeleteRetentionInDays - softDelete data retention days. It accepts >=7 and <=90.
	SoftDeleteRetentionInDays *int32 `json:"softDeleteRetentionInDays,omitempty"`
	// EnableRbacAuthorization - Property that controls how data actions are authorized. When true, the key vault will use Role Based Access Control (RBAC) for authorization of data actions, and the access policies specified in vault properties will be  ignored (warning: this is a preview feature). When false, the key vault will use the access policies specified in vault properties, and any policy stored on Azure Resource Manager will be ignored. If null or not specified, the vault is created with the default value of false. Note that management actions are always authorized with RBAC.
	EnableRbacAuthorization *bool `json:"enableRbacAuthorization,omitempty"`
	// CreateMode - The vault's create mode to indicate whether the vault need to be recovered or not. Possible values include: 'CreateModeRecover', 'CreateModeDefault'
	CreateMode CreateMode `json:"createMode,omitempty"`
	// EnablePurgeProtection - Property specifying whether protection against purge is enabled for this vault. Setting this property to true activates protection against purge for this vault and its content - only the Key Vault service may initiate a hard, irrecoverable deletion. The setting is effective only if soft delete is also enabled. Enabling this functionality is irreversible - that is, the property does not accept false as its value.
	EnablePurgeProtection *bool `json:"enablePurgeProtection,omitempty"`
	// NetworkAcls - Rules governing the accessibility of the key vault from specific network locations.
	NetworkAcls *NetworkRuleSet `json:"networkAcls,omitempty"`
	// PrivateEndpointConnections - READ-ONLY; List of private endpoint connections associated with the key vault.
	PrivateEndpointConnections *[]PrivateEndpointConnectionItem `json:"privateEndpointConnections,omitempty"`
}

// MarshalJSON is the custom marshaler for VaultProperties.
func (vp VaultProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vp.TenantID != nil {
		objectMap["tenantId"] = vp.TenantID
	}
	if vp.Sku != nil {
		objectMap["sku"] = vp.Sku
	}
	if vp.AccessPolicies != nil {
		objectMap["accessPolicies"] = vp.AccessPolicies
	}
	if vp.VaultURI != nil {
		objectMap["vaultUri"] = vp.VaultURI
	}
	if vp.EnabledForDeployment != nil {
		objectMap["enabledForDeployment"] = vp.EnabledForDeployment
	}
	if vp.EnabledForDiskEncryption != nil {
		objectMap["enabledForDiskEncryption"] = vp.EnabledForDiskEncryption
	}
	if vp.EnabledForTemplateDeployment != nil {
		objectMap["enabledForTemplateDeployment"] = vp.EnabledForTemplateDeployment
	}
	if vp.EnableSoftDelete != nil {
		objectMap["enableSoftDelete"] = vp.EnableSoftDelete
	}
	if vp.SoftDeleteRetentionInDays != nil {
		objectMap["softDeleteRetentionInDays"] = vp.SoftDeleteRetentionInDays
	}
	if vp.EnableRbacAuthorization != nil {
		objectMap["enableRbacAuthorization"] = vp.EnableRbacAuthorization
	}
	if vp.CreateMode != "" {
		objectMap["createMode"] = vp.CreateMode
	}
	if vp.EnablePurgeProtection != nil {
		objectMap["enablePurgeProtection"] = vp.EnablePurgeProtection
	}
	if vp.NetworkAcls != nil {
		objectMap["networkAcls"] = vp.NetworkAcls
	}
	return json.Marshal(objectMap)
}

// VaultsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type VaultsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VaultsClient) (Vault, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VaultsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VaultsCreateOrUpdateFuture.Result.
func (future *VaultsCreateOrUpdateFuture) result(client VaultsClient) (vVar Vault, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "keyvault.VaultsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		vVar.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("keyvault.VaultsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if vVar.Response.Response, err = future.GetResult(sender); err == nil && vVar.Response.Response.StatusCode != http.StatusNoContent {
		vVar, err = client.CreateOrUpdateResponder(vVar.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "keyvault.VaultsCreateOrUpdateFuture", "Result", vVar.Response.Response, "Failure responding to request")
		}
	}
	return
}

// VaultsPurgeDeletedFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type VaultsPurgeDeletedFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VaultsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VaultsPurgeDeletedFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VaultsPurgeDeletedFuture.Result.
func (future *VaultsPurgeDeletedFuture) result(client VaultsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "keyvault.VaultsPurgeDeletedFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("keyvault.VaultsPurgeDeletedFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VirtualNetworkRule a rule governing the accessibility of a vault from a specific virtual network.
type VirtualNetworkRule struct {
	// ID - Full resource id of a vnet subnet, such as '/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/subnet1'.
	ID *string `json:"id,omitempty"`
}
