package iothub

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/provisioningservices/mgmt/2022-02-05/iothub"

// AsyncOperationResult result of a long running operation.
type AsyncOperationResult struct {
	autorest.Response `json:"-"`
	// Status - current status of a long running operation.
	Status *string `json:"status,omitempty"`
	// Error - Error message containing code, description and details
	Error *ErrorMessage `json:"error,omitempty"`
}

// CertificateBodyDescription the JSON-serialized X509 Certificate.
type CertificateBodyDescription struct {
	// Certificate - Base-64 representation of the X509 leaf certificate .cer file or just .pem file content.
	Certificate *string `json:"certificate,omitempty"`
	// IsVerified - True indicates that the certificate will be created in verified state and proof of possession will not be required.
	IsVerified *bool `json:"isVerified,omitempty"`
}

// CertificateListDescription the JSON-serialized array of Certificate objects.
type CertificateListDescription struct {
	autorest.Response `json:"-"`
	// Value - The array of Certificate objects.
	Value *[]CertificateResponse `json:"value,omitempty"`
}

// CertificateProperties the description of an X509 CA Certificate.
type CertificateProperties struct {
	// Subject - READ-ONLY; The certificate's subject name.
	Subject *string `json:"subject,omitempty"`
	// Expiry - READ-ONLY; The certificate's expiration date and time.
	Expiry *date.TimeRFC1123 `json:"expiry,omitempty"`
	// Thumbprint - READ-ONLY; The certificate's thumbprint.
	Thumbprint *string `json:"thumbprint,omitempty"`
	// IsVerified - Determines whether certificate has been verified.
	IsVerified *bool `json:"isVerified,omitempty"`
	// Certificate - base-64 representation of X509 certificate .cer file or just .pem file content.
	Certificate *[]byte `json:"certificate,omitempty"`
	// Created - READ-ONLY; The certificate's creation date and time.
	Created *date.TimeRFC1123 `json:"created,omitempty"`
	// Updated - READ-ONLY; The certificate's last update date and time.
	Updated *date.TimeRFC1123 `json:"updated,omitempty"`
}

// MarshalJSON is the custom marshaler for CertificateProperties.
func (cp CertificateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cp.IsVerified != nil {
		objectMap["isVerified"] = cp.IsVerified
	}
	if cp.Certificate != nil {
		objectMap["certificate"] = cp.Certificate
	}
	return json.Marshal(objectMap)
}

// CertificateResponse the X509 Certificate.
type CertificateResponse struct {
	autorest.Response `json:"-"`
	// Properties - properties of a certificate
	Properties *CertificateProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the certificate.
	Name *string `json:"name,omitempty"`
	// Etag - READ-ONLY; The entity tag.
	Etag *string `json:"etag,omitempty"`
	// Type - READ-ONLY; The resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - READ-ONLY
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for CertificateResponse.
func (cr CertificateResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cr.Properties != nil {
		objectMap["properties"] = cr.Properties
	}
	return json.Marshal(objectMap)
}

// DefinitionDescription description of the IoT hub.
type DefinitionDescription struct {
	// ApplyAllocationPolicy - flag for applying allocationPolicy or not for a given iot hub.
	ApplyAllocationPolicy *bool `json:"applyAllocationPolicy,omitempty"`
	// AllocationWeight - weight to apply for a given iot h.
	AllocationWeight *int32 `json:"allocationWeight,omitempty"`
	// Name - READ-ONLY; Host name of the IoT hub.
	Name *string `json:"name,omitempty"`
	// ConnectionString - Connection string of the IoT hub.
	ConnectionString *string `json:"connectionString,omitempty"`
	// Location - ARM region of the IoT hub.
	Location *string `json:"location,omitempty"`
}

// MarshalJSON is the custom marshaler for DefinitionDescription.
func (dd DefinitionDescription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dd.ApplyAllocationPolicy != nil {
		objectMap["applyAllocationPolicy"] = dd.ApplyAllocationPolicy
	}
	if dd.AllocationWeight != nil {
		objectMap["allocationWeight"] = dd.AllocationWeight
	}
	if dd.ConnectionString != nil {
		objectMap["connectionString"] = dd.ConnectionString
	}
	if dd.Location != nil {
		objectMap["location"] = dd.Location
	}
	return json.Marshal(objectMap)
}

// ErrorDetails error details.
type ErrorDetails struct {
	// Code - READ-ONLY; The error code.
	Code *string `json:"code,omitempty"`
	// HTTPStatusCode - READ-ONLY; The HTTP status code.
	HTTPStatusCode *string `json:"httpStatusCode,omitempty"`
	// Message - READ-ONLY; The error message.
	Message *string `json:"message,omitempty"`
	// Details - READ-ONLY; The error details.
	Details *string `json:"details,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorDetails.
func (ed ErrorDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ErrorMessage error response containing message and code.
type ErrorMessage struct {
	// Code - standard error code
	Code *string `json:"code,omitempty"`
	// Message - standard error description
	Message *string `json:"message,omitempty"`
	// Details - detailed summary of error
	Details *string `json:"details,omitempty"`
}

// GroupIDInformation the group information for creating a private endpoint on a provisioning service
type GroupIDInformation struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The resource type.
	Type *string `json:"type,omitempty"`
	// Properties - The properties for a group information object
	Properties *GroupIDInformationProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for GroupIDInformation.
func (gii GroupIDInformation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gii.Properties != nil {
		objectMap["properties"] = gii.Properties
	}
	return json.Marshal(objectMap)
}

// GroupIDInformationProperties the properties for a group information object
type GroupIDInformationProperties struct {
	// GroupID - The group id
	GroupID *string `json:"groupId,omitempty"`
	// RequiredMembers - The required members for a specific group id
	RequiredMembers *[]string `json:"requiredMembers,omitempty"`
	// RequiredZoneNames - The required DNS zones for a specific group id
	RequiredZoneNames *[]string `json:"requiredZoneNames,omitempty"`
}

// IotDpsPropertiesDescription the service specific properties of a provisioning service, including keys,
// linked iot hubs, current state, and system generated properties such as hostname and idScope
type IotDpsPropertiesDescription struct {
	// State - Current state of the provisioning service. Possible values include: 'StateActivating', 'StateActive', 'StateDeleting', 'StateDeleted', 'StateActivationFailed', 'StateDeletionFailed', 'StateTransitioning', 'StateSuspending', 'StateSuspended', 'StateResuming', 'StateFailingOver', 'StateFailoverFailed'
	State State `json:"state,omitempty"`
	// PublicNetworkAccess - Whether requests from Public Network are allowed. Possible values include: 'PublicNetworkAccessEnabled', 'PublicNetworkAccessDisabled'
	PublicNetworkAccess PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`
	// IPFilterRules - The IP filter rules.
	IPFilterRules *[]IPFilterRule `json:"ipFilterRules,omitempty"`
	// PrivateEndpointConnections - Private endpoint connections created on this IotHub
	PrivateEndpointConnections *[]PrivateEndpointConnection `json:"privateEndpointConnections,omitempty"`
	// ProvisioningState - The ARM provisioning state of the provisioning service.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// IotHubs - List of IoT hubs associated with this provisioning service.
	IotHubs *[]DefinitionDescription `json:"iotHubs,omitempty"`
	// AllocationPolicy - Allocation policy to be used by this provisioning service. Possible values include: 'AllocationPolicyHashed', 'AllocationPolicyGeoLatency', 'AllocationPolicyStatic'
	AllocationPolicy AllocationPolicy `json:"allocationPolicy,omitempty"`
	// ServiceOperationsHostName - READ-ONLY; Service endpoint for provisioning service.
	ServiceOperationsHostName *string `json:"serviceOperationsHostName,omitempty"`
	// DeviceProvisioningHostName - READ-ONLY; Device endpoint for this provisioning service.
	DeviceProvisioningHostName *string `json:"deviceProvisioningHostName,omitempty"`
	// IDScope - READ-ONLY; Unique identifier of this provisioning service.
	IDScope *string `json:"idScope,omitempty"`
	// AuthorizationPolicies - List of authorization keys for a provisioning service.
	AuthorizationPolicies *[]SharedAccessSignatureAuthorizationRuleAccessRightsDescription `json:"authorizationPolicies,omitempty"`
	// EnableDataResidency - Optional.
	// Indicates if the DPS instance has Data Residency enabled, removing the cross geo-pair disaster recovery.
	EnableDataResidency *bool `json:"enableDataResidency,omitempty"`
}

// MarshalJSON is the custom marshaler for IotDpsPropertiesDescription.
func (idpd IotDpsPropertiesDescription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if idpd.State != "" {
		objectMap["state"] = idpd.State
	}
	if idpd.PublicNetworkAccess != "" {
		objectMap["publicNetworkAccess"] = idpd.PublicNetworkAccess
	}
	if idpd.IPFilterRules != nil {
		objectMap["ipFilterRules"] = idpd.IPFilterRules
	}
	if idpd.PrivateEndpointConnections != nil {
		objectMap["privateEndpointConnections"] = idpd.PrivateEndpointConnections
	}
	if idpd.ProvisioningState != nil {
		objectMap["provisioningState"] = idpd.ProvisioningState
	}
	if idpd.IotHubs != nil {
		objectMap["iotHubs"] = idpd.IotHubs
	}
	if idpd.AllocationPolicy != "" {
		objectMap["allocationPolicy"] = idpd.AllocationPolicy
	}
	if idpd.AuthorizationPolicies != nil {
		objectMap["authorizationPolicies"] = idpd.AuthorizationPolicies
	}
	if idpd.EnableDataResidency != nil {
		objectMap["enableDataResidency"] = idpd.EnableDataResidency
	}
	return json.Marshal(objectMap)
}

// IotDpsResourceCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type IotDpsResourceCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(IotDpsResourceClient) (ProvisioningServiceDescription, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *IotDpsResourceCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for IotDpsResourceCreateOrUpdateFuture.Result.
func (future *IotDpsResourceCreateOrUpdateFuture) result(client IotDpsResourceClient) (psd ProvisioningServiceDescription, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.IotDpsResourceCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		psd.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("iothub.IotDpsResourceCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if psd.Response.Response, err = future.GetResult(sender); err == nil && psd.Response.Response.StatusCode != http.StatusNoContent {
		psd, err = client.CreateOrUpdateResponder(psd.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "iothub.IotDpsResourceCreateOrUpdateFuture", "Result", psd.Response.Response, "Failure responding to request")
		}
	}
	return
}

// IotDpsResourceCreateOrUpdatePrivateEndpointConnectionFuture an abstraction for monitoring and retrieving
// the results of a long-running operation.
type IotDpsResourceCreateOrUpdatePrivateEndpointConnectionFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(IotDpsResourceClient) (PrivateEndpointConnection, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *IotDpsResourceCreateOrUpdatePrivateEndpointConnectionFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for IotDpsResourceCreateOrUpdatePrivateEndpointConnectionFuture.Result.
func (future *IotDpsResourceCreateOrUpdatePrivateEndpointConnectionFuture) result(client IotDpsResourceClient) (pec PrivateEndpointConnection, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.IotDpsResourceCreateOrUpdatePrivateEndpointConnectionFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		pec.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("iothub.IotDpsResourceCreateOrUpdatePrivateEndpointConnectionFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if pec.Response.Response, err = future.GetResult(sender); err == nil && pec.Response.Response.StatusCode != http.StatusNoContent {
		pec, err = client.CreateOrUpdatePrivateEndpointConnectionResponder(pec.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "iothub.IotDpsResourceCreateOrUpdatePrivateEndpointConnectionFuture", "Result", pec.Response.Response, "Failure responding to request")
		}
	}
	return
}

// IotDpsResourceDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type IotDpsResourceDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(IotDpsResourceClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *IotDpsResourceDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for IotDpsResourceDeleteFuture.Result.
func (future *IotDpsResourceDeleteFuture) result(client IotDpsResourceClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.IotDpsResourceDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("iothub.IotDpsResourceDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// IotDpsResourceDeletePrivateEndpointConnectionFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type IotDpsResourceDeletePrivateEndpointConnectionFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(IotDpsResourceClient) (PrivateEndpointConnection, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *IotDpsResourceDeletePrivateEndpointConnectionFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for IotDpsResourceDeletePrivateEndpointConnectionFuture.Result.
func (future *IotDpsResourceDeletePrivateEndpointConnectionFuture) result(client IotDpsResourceClient) (pec PrivateEndpointConnection, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.IotDpsResourceDeletePrivateEndpointConnectionFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		pec.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("iothub.IotDpsResourceDeletePrivateEndpointConnectionFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if pec.Response.Response, err = future.GetResult(sender); err == nil && pec.Response.Response.StatusCode != http.StatusNoContent {
		pec, err = client.DeletePrivateEndpointConnectionResponder(pec.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "iothub.IotDpsResourceDeletePrivateEndpointConnectionFuture", "Result", pec.Response.Response, "Failure responding to request")
		}
	}
	return
}

// IotDpsResourceUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type IotDpsResourceUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(IotDpsResourceClient) (ProvisioningServiceDescription, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *IotDpsResourceUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for IotDpsResourceUpdateFuture.Result.
func (future *IotDpsResourceUpdateFuture) result(client IotDpsResourceClient) (psd ProvisioningServiceDescription, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.IotDpsResourceUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		psd.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("iothub.IotDpsResourceUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if psd.Response.Response, err = future.GetResult(sender); err == nil && psd.Response.Response.StatusCode != http.StatusNoContent {
		psd, err = client.UpdateResponder(psd.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "iothub.IotDpsResourceUpdateFuture", "Result", psd.Response.Response, "Failure responding to request")
		}
	}
	return
}

// IotDpsSkuDefinition available SKUs of tier and units.
type IotDpsSkuDefinition struct {
	// Name - Sku name. Possible values include: 'IotDpsSkuS1'
	Name IotDpsSku `json:"name,omitempty"`
}

// IotDpsSkuDefinitionListResult list of available SKUs.
type IotDpsSkuDefinitionListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of SKUs
	Value *[]IotDpsSkuDefinition `json:"value,omitempty"`
	// NextLink - READ-ONLY; The next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for IotDpsSkuDefinitionListResult.
func (idsdlr IotDpsSkuDefinitionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if idsdlr.Value != nil {
		objectMap["value"] = idsdlr.Value
	}
	return json.Marshal(objectMap)
}

// IotDpsSkuDefinitionListResultIterator provides access to a complete listing of IotDpsSkuDefinition
// values.
type IotDpsSkuDefinitionListResultIterator struct {
	i    int
	page IotDpsSkuDefinitionListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *IotDpsSkuDefinitionListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IotDpsSkuDefinitionListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *IotDpsSkuDefinitionListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter IotDpsSkuDefinitionListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter IotDpsSkuDefinitionListResultIterator) Response() IotDpsSkuDefinitionListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter IotDpsSkuDefinitionListResultIterator) Value() IotDpsSkuDefinition {
	if !iter.page.NotDone() {
		return IotDpsSkuDefinition{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the IotDpsSkuDefinitionListResultIterator type.
func NewIotDpsSkuDefinitionListResultIterator(page IotDpsSkuDefinitionListResultPage) IotDpsSkuDefinitionListResultIterator {
	return IotDpsSkuDefinitionListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (idsdlr IotDpsSkuDefinitionListResult) IsEmpty() bool {
	return idsdlr.Value == nil || len(*idsdlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (idsdlr IotDpsSkuDefinitionListResult) hasNextLink() bool {
	return idsdlr.NextLink != nil && len(*idsdlr.NextLink) != 0
}

// iotDpsSkuDefinitionListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (idsdlr IotDpsSkuDefinitionListResult) iotDpsSkuDefinitionListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !idsdlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(idsdlr.NextLink)))
}

// IotDpsSkuDefinitionListResultPage contains a page of IotDpsSkuDefinition values.
type IotDpsSkuDefinitionListResultPage struct {
	fn     func(context.Context, IotDpsSkuDefinitionListResult) (IotDpsSkuDefinitionListResult, error)
	idsdlr IotDpsSkuDefinitionListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *IotDpsSkuDefinitionListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IotDpsSkuDefinitionListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.idsdlr)
		if err != nil {
			return err
		}
		page.idsdlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *IotDpsSkuDefinitionListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page IotDpsSkuDefinitionListResultPage) NotDone() bool {
	return !page.idsdlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page IotDpsSkuDefinitionListResultPage) Response() IotDpsSkuDefinitionListResult {
	return page.idsdlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page IotDpsSkuDefinitionListResultPage) Values() []IotDpsSkuDefinition {
	if page.idsdlr.IsEmpty() {
		return nil
	}
	return *page.idsdlr.Value
}

// Creates a new instance of the IotDpsSkuDefinitionListResultPage type.
func NewIotDpsSkuDefinitionListResultPage(cur IotDpsSkuDefinitionListResult, getNextPage func(context.Context, IotDpsSkuDefinitionListResult) (IotDpsSkuDefinitionListResult, error)) IotDpsSkuDefinitionListResultPage {
	return IotDpsSkuDefinitionListResultPage{
		fn:     getNextPage,
		idsdlr: cur,
	}
}

// IotDpsSkuInfo list of possible provisioning service SKUs.
type IotDpsSkuInfo struct {
	// Name - Sku name. Possible values include: 'IotDpsSkuS1'
	Name IotDpsSku `json:"name,omitempty"`
	// Tier - READ-ONLY; Pricing tier name of the provisioning service.
	Tier *string `json:"tier,omitempty"`
	// Capacity - The number of units to provision
	Capacity *int64 `json:"capacity,omitempty"`
}

// MarshalJSON is the custom marshaler for IotDpsSkuInfo.
func (idsi IotDpsSkuInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if idsi.Name != "" {
		objectMap["name"] = idsi.Name
	}
	if idsi.Capacity != nil {
		objectMap["capacity"] = idsi.Capacity
	}
	return json.Marshal(objectMap)
}

// IPFilterRule the IP filter rules for a provisioning Service.
type IPFilterRule struct {
	// FilterName - The name of the IP filter rule.
	FilterName *string `json:"filterName,omitempty"`
	// Action - The desired action for requests captured by this rule. Possible values include: 'IPFilterActionTypeAccept', 'IPFilterActionTypeReject'
	Action IPFilterActionType `json:"action,omitempty"`
	// IPMask - A string that contains the IP address range in CIDR notation for the rule.
	IPMask *string `json:"ipMask,omitempty"`
	// Target - Target for requests captured by this rule. Possible values include: 'IPFilterTargetTypeAll', 'IPFilterTargetTypeServiceAPI', 'IPFilterTargetTypeDeviceAPI'
	Target IPFilterTargetType `json:"target,omitempty"`
}

// ListPrivateEndpointConnection ...
type ListPrivateEndpointConnection struct {
	autorest.Response `json:"-"`
	Value             *[]PrivateEndpointConnection `json:"value,omitempty"`
}

// NameAvailabilityInfo description of name availability.
type NameAvailabilityInfo struct {
	autorest.Response `json:"-"`
	// NameAvailable - specifies if a name is available or not
	NameAvailable *bool `json:"nameAvailable,omitempty"`
	// Reason - specifies the reason a name is unavailable. Possible values include: 'NameUnavailabilityReasonInvalid', 'NameUnavailabilityReasonAlreadyExists'
	Reason NameUnavailabilityReason `json:"reason,omitempty"`
	// Message - message containing a detailed reason name is unavailable
	Message *string `json:"message,omitempty"`
}

// Operation provisioning Service REST API operation.
type Operation struct {
	// Name - READ-ONLY; Operation name: {provider}/{resource}/{read | write | action | delete}
	Name *string `json:"name,omitempty"`
	// Display - The object that represents the operation.
	Display *OperationDisplay `json:"display,omitempty"`
}

// MarshalJSON is the custom marshaler for Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if o.Display != nil {
		objectMap["display"] = o.Display
	}
	return json.Marshal(objectMap)
}

// OperationDisplay the object that represents the operation.
type OperationDisplay struct {
	// Provider - READ-ONLY; Service provider: Microsoft Devices.
	Provider *string `json:"provider,omitempty"`
	// Resource - READ-ONLY; Resource Type: ProvisioningServices.
	Resource *string `json:"resource,omitempty"`
	// Operation - READ-ONLY; Name of the operation.
	Operation *string `json:"operation,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationDisplay.
func (o OperationDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// OperationInputs input values for operation results call.
type OperationInputs struct {
	// Name - The name of the Provisioning Service to check.
	Name *string `json:"name,omitempty"`
}

// OperationListResult result of the request to list provisioning service operations. It contains a list of
// operations and a URL link to get the next set of results.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Provisioning service operations supported by the Microsoft.Devices resource provider.
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationListResult.
func (olr OperationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// OperationListResultIterator provides access to a complete listing of Operation values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListResultIterator type.
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return OperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (olr OperationListResult) hasNextLink() bool {
	return olr.NextLink != nil && len(*olr.NextLink) != 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !olr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of Operation values.
type OperationListResultPage struct {
	fn  func(context.Context, OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.olr)
		if err != nil {
			return err
		}
		page.olr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []Operation {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OperationListResultPage type.
func NewOperationListResultPage(cur OperationListResult, getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return OperationListResultPage{
		fn:  getNextPage,
		olr: cur,
	}
}

// PrivateEndpoint the private endpoint property of a private endpoint connection
type PrivateEndpoint struct {
	// ID - READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateEndpoint.
func (peVar PrivateEndpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// PrivateEndpointConnection the private endpoint connection of a provisioning service
type PrivateEndpointConnection struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The resource type.
	Type *string `json:"type,omitempty"`
	// Properties - The properties of a private endpoint connection
	Properties *PrivateEndpointConnectionProperties `json:"properties,omitempty"`
	// SystemData - READ-ONLY
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateEndpointConnection.
func (pec PrivateEndpointConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pec.Properties != nil {
		objectMap["properties"] = pec.Properties
	}
	return json.Marshal(objectMap)
}

// PrivateEndpointConnectionProperties the properties of a private endpoint connection
type PrivateEndpointConnectionProperties struct {
	// PrivateEndpoint - The private endpoint property of a private endpoint connection
	PrivateEndpoint *PrivateEndpoint `json:"privateEndpoint,omitempty"`
	// PrivateLinkServiceConnectionState - The current state of a private endpoint connection
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState `json:"privateLinkServiceConnectionState,omitempty"`
}

// PrivateLinkResources the available private link resources for a provisioning service
type PrivateLinkResources struct {
	autorest.Response `json:"-"`
	// Value - The list of available private link resources for a provisioning service
	Value *[]GroupIDInformation `json:"value,omitempty"`
}

// PrivateLinkServiceConnectionState the current state of a private endpoint connection
type PrivateLinkServiceConnectionState struct {
	// Status - The status of a private endpoint connection. Possible values include: 'PrivateLinkServiceConnectionStatusPending', 'PrivateLinkServiceConnectionStatusApproved', 'PrivateLinkServiceConnectionStatusRejected', 'PrivateLinkServiceConnectionStatusDisconnected'
	Status PrivateLinkServiceConnectionStatus `json:"status,omitempty"`
	// Description - The description for the current state of a private endpoint connection
	Description *string `json:"description,omitempty"`
	// ActionsRequired - Actions required for a private endpoint connection
	ActionsRequired *string `json:"actionsRequired,omitempty"`
}

// ProvisioningServiceDescription the description of the provisioning service.
type ProvisioningServiceDescription struct {
	autorest.Response `json:"-"`
	// Etag - The Etag field is *not* required. If it is provided in the response body, it must also be provided as a header per the normal ETag convention.
	Etag *string `json:"etag,omitempty"`
	// Properties - Service specific properties for a provisioning service
	Properties *IotDpsPropertiesDescription `json:"properties,omitempty"`
	// Sku - Sku info for a provisioning Service.
	Sku *IotDpsSkuInfo `json:"sku,omitempty"`
	// SystemData - READ-ONLY
	SystemData *SystemData `json:"systemData,omitempty"`
	// ID - READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The resource type.
	Type *string `json:"type,omitempty"`
	// Location - The resource location.
	Location *string `json:"location,omitempty"`
	// Tags - The resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ProvisioningServiceDescription.
func (psd ProvisioningServiceDescription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if psd.Etag != nil {
		objectMap["etag"] = psd.Etag
	}
	if psd.Properties != nil {
		objectMap["properties"] = psd.Properties
	}
	if psd.Sku != nil {
		objectMap["sku"] = psd.Sku
	}
	if psd.Location != nil {
		objectMap["location"] = psd.Location
	}
	if psd.Tags != nil {
		objectMap["tags"] = psd.Tags
	}
	return json.Marshal(objectMap)
}

// ProvisioningServiceDescriptionListResult list of provisioning service descriptions.
type ProvisioningServiceDescriptionListResult struct {
	autorest.Response `json:"-"`
	// Value - List of provisioning service descriptions.
	Value *[]ProvisioningServiceDescription `json:"value,omitempty"`
	// NextLink - READ-ONLY; the next link
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ProvisioningServiceDescriptionListResult.
func (psdlr ProvisioningServiceDescriptionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if psdlr.Value != nil {
		objectMap["value"] = psdlr.Value
	}
	return json.Marshal(objectMap)
}

// ProvisioningServiceDescriptionListResultIterator provides access to a complete listing of
// ProvisioningServiceDescription values.
type ProvisioningServiceDescriptionListResultIterator struct {
	i    int
	page ProvisioningServiceDescriptionListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ProvisioningServiceDescriptionListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProvisioningServiceDescriptionListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ProvisioningServiceDescriptionListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ProvisioningServiceDescriptionListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ProvisioningServiceDescriptionListResultIterator) Response() ProvisioningServiceDescriptionListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ProvisioningServiceDescriptionListResultIterator) Value() ProvisioningServiceDescription {
	if !iter.page.NotDone() {
		return ProvisioningServiceDescription{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ProvisioningServiceDescriptionListResultIterator type.
func NewProvisioningServiceDescriptionListResultIterator(page ProvisioningServiceDescriptionListResultPage) ProvisioningServiceDescriptionListResultIterator {
	return ProvisioningServiceDescriptionListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (psdlr ProvisioningServiceDescriptionListResult) IsEmpty() bool {
	return psdlr.Value == nil || len(*psdlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (psdlr ProvisioningServiceDescriptionListResult) hasNextLink() bool {
	return psdlr.NextLink != nil && len(*psdlr.NextLink) != 0
}

// provisioningServiceDescriptionListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (psdlr ProvisioningServiceDescriptionListResult) provisioningServiceDescriptionListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !psdlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(psdlr.NextLink)))
}

// ProvisioningServiceDescriptionListResultPage contains a page of ProvisioningServiceDescription values.
type ProvisioningServiceDescriptionListResultPage struct {
	fn    func(context.Context, ProvisioningServiceDescriptionListResult) (ProvisioningServiceDescriptionListResult, error)
	psdlr ProvisioningServiceDescriptionListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ProvisioningServiceDescriptionListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProvisioningServiceDescriptionListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.psdlr)
		if err != nil {
			return err
		}
		page.psdlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ProvisioningServiceDescriptionListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ProvisioningServiceDescriptionListResultPage) NotDone() bool {
	return !page.psdlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ProvisioningServiceDescriptionListResultPage) Response() ProvisioningServiceDescriptionListResult {
	return page.psdlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ProvisioningServiceDescriptionListResultPage) Values() []ProvisioningServiceDescription {
	if page.psdlr.IsEmpty() {
		return nil
	}
	return *page.psdlr.Value
}

// Creates a new instance of the ProvisioningServiceDescriptionListResultPage type.
func NewProvisioningServiceDescriptionListResultPage(cur ProvisioningServiceDescriptionListResult, getNextPage func(context.Context, ProvisioningServiceDescriptionListResult) (ProvisioningServiceDescriptionListResult, error)) ProvisioningServiceDescriptionListResultPage {
	return ProvisioningServiceDescriptionListResultPage{
		fn:    getNextPage,
		psdlr: cur,
	}
}

// Resource the common properties of an Azure resource.
type Resource struct {
	// ID - READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The resource type.
	Type *string `json:"type,omitempty"`
	// Location - The resource location.
	Location *string `json:"location,omitempty"`
	// Tags - The resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	return json.Marshal(objectMap)
}

// SharedAccessSignatureAuthorizationRuleAccessRightsDescription description of the shared access key.
type SharedAccessSignatureAuthorizationRuleAccessRightsDescription struct {
	autorest.Response `json:"-"`
	// KeyName - Name of the key.
	KeyName *string `json:"keyName,omitempty"`
	// PrimaryKey - Primary SAS key value.
	PrimaryKey *string `json:"primaryKey,omitempty"`
	// SecondaryKey - Secondary SAS key value.
	SecondaryKey *string `json:"secondaryKey,omitempty"`
	// Rights - Rights that this key has. Possible values include: 'AccessRightsDescriptionServiceConfig', 'AccessRightsDescriptionEnrollmentRead', 'AccessRightsDescriptionEnrollmentWrite', 'AccessRightsDescriptionDeviceConnect', 'AccessRightsDescriptionRegistrationStatusRead', 'AccessRightsDescriptionRegistrationStatusWrite'
	Rights AccessRightsDescription `json:"rights,omitempty"`
}

// SharedAccessSignatureAuthorizationRuleListResult list of shared access keys.
type SharedAccessSignatureAuthorizationRuleListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of shared access policies.
	Value *[]SharedAccessSignatureAuthorizationRuleAccessRightsDescription `json:"value,omitempty"`
	// NextLink - READ-ONLY; The next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for SharedAccessSignatureAuthorizationRuleListResult.
func (sasarlr SharedAccessSignatureAuthorizationRuleListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sasarlr.Value != nil {
		objectMap["value"] = sasarlr.Value
	}
	return json.Marshal(objectMap)
}

// SharedAccessSignatureAuthorizationRuleListResultIterator provides access to a complete listing of
// SharedAccessSignatureAuthorizationRuleAccessRightsDescription values.
type SharedAccessSignatureAuthorizationRuleListResultIterator struct {
	i    int
	page SharedAccessSignatureAuthorizationRuleListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SharedAccessSignatureAuthorizationRuleListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SharedAccessSignatureAuthorizationRuleListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SharedAccessSignatureAuthorizationRuleListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SharedAccessSignatureAuthorizationRuleListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SharedAccessSignatureAuthorizationRuleListResultIterator) Response() SharedAccessSignatureAuthorizationRuleListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SharedAccessSignatureAuthorizationRuleListResultIterator) Value() SharedAccessSignatureAuthorizationRuleAccessRightsDescription {
	if !iter.page.NotDone() {
		return SharedAccessSignatureAuthorizationRuleAccessRightsDescription{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SharedAccessSignatureAuthorizationRuleListResultIterator type.
func NewSharedAccessSignatureAuthorizationRuleListResultIterator(page SharedAccessSignatureAuthorizationRuleListResultPage) SharedAccessSignatureAuthorizationRuleListResultIterator {
	return SharedAccessSignatureAuthorizationRuleListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sasarlr SharedAccessSignatureAuthorizationRuleListResult) IsEmpty() bool {
	return sasarlr.Value == nil || len(*sasarlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (sasarlr SharedAccessSignatureAuthorizationRuleListResult) hasNextLink() bool {
	return sasarlr.NextLink != nil && len(*sasarlr.NextLink) != 0
}

// sharedAccessSignatureAuthorizationRuleListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sasarlr SharedAccessSignatureAuthorizationRuleListResult) sharedAccessSignatureAuthorizationRuleListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !sasarlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sasarlr.NextLink)))
}

// SharedAccessSignatureAuthorizationRuleListResultPage contains a page of
// SharedAccessSignatureAuthorizationRuleAccessRightsDescription values.
type SharedAccessSignatureAuthorizationRuleListResultPage struct {
	fn      func(context.Context, SharedAccessSignatureAuthorizationRuleListResult) (SharedAccessSignatureAuthorizationRuleListResult, error)
	sasarlr SharedAccessSignatureAuthorizationRuleListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SharedAccessSignatureAuthorizationRuleListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SharedAccessSignatureAuthorizationRuleListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.sasarlr)
		if err != nil {
			return err
		}
		page.sasarlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SharedAccessSignatureAuthorizationRuleListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SharedAccessSignatureAuthorizationRuleListResultPage) NotDone() bool {
	return !page.sasarlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SharedAccessSignatureAuthorizationRuleListResultPage) Response() SharedAccessSignatureAuthorizationRuleListResult {
	return page.sasarlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SharedAccessSignatureAuthorizationRuleListResultPage) Values() []SharedAccessSignatureAuthorizationRuleAccessRightsDescription {
	if page.sasarlr.IsEmpty() {
		return nil
	}
	return *page.sasarlr.Value
}

// Creates a new instance of the SharedAccessSignatureAuthorizationRuleListResultPage type.
func NewSharedAccessSignatureAuthorizationRuleListResultPage(cur SharedAccessSignatureAuthorizationRuleListResult, getNextPage func(context.Context, SharedAccessSignatureAuthorizationRuleListResult) (SharedAccessSignatureAuthorizationRuleListResult, error)) SharedAccessSignatureAuthorizationRuleListResultPage {
	return SharedAccessSignatureAuthorizationRuleListResultPage{
		fn:      getNextPage,
		sasarlr: cur,
	}
}

// SystemData metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// CreatedBy - The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`
	// CreatedByType - The type of identity that created the resource. Possible values include: 'CreatedByTypeUser', 'CreatedByTypeApplication', 'CreatedByTypeManagedIdentity', 'CreatedByTypeKey'
	CreatedByType CreatedByType `json:"createdByType,omitempty"`
	// CreatedAt - The timestamp of resource creation (UTC).
	CreatedAt *date.Time `json:"createdAt,omitempty"`
	// LastModifiedBy - The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`
	// LastModifiedByType - The type of identity that last modified the resource. Possible values include: 'CreatedByTypeUser', 'CreatedByTypeApplication', 'CreatedByTypeManagedIdentity', 'CreatedByTypeKey'
	LastModifiedByType CreatedByType `json:"lastModifiedByType,omitempty"`
	// LastModifiedAt - The timestamp of resource last modification (UTC)
	LastModifiedAt *date.Time `json:"lastModifiedAt,omitempty"`
}

// TagsResource a container holding only the Tags for a resource, allowing the user to update the tags on a
// Provisioning Service instance.
type TagsResource struct {
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for TagsResource.
func (tr TagsResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	return json.Marshal(objectMap)
}

// VerificationCodeRequest the JSON-serialized leaf certificate
type VerificationCodeRequest struct {
	// Certificate - base-64 representation of X509 certificate .cer file or just .pem file content.
	Certificate *string `json:"certificate,omitempty"`
}

// VerificationCodeResponse description of the response of the verification code.
type VerificationCodeResponse struct {
	autorest.Response `json:"-"`
	// Name - READ-ONLY; Name of certificate.
	Name *string `json:"name,omitempty"`
	// Etag - READ-ONLY; Request etag.
	Etag *string `json:"etag,omitempty"`
	// ID - READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; The resource type.
	Type       *string                             `json:"type,omitempty"`
	Properties *VerificationCodeResponseProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for VerificationCodeResponse.
func (vcr VerificationCodeResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vcr.Properties != nil {
		objectMap["properties"] = vcr.Properties
	}
	return json.Marshal(objectMap)
}

// VerificationCodeResponseProperties ...
type VerificationCodeResponseProperties struct {
	// VerificationCode - Verification code.
	VerificationCode *string `json:"verificationCode,omitempty"`
	// Subject - Certificate subject.
	Subject *string `json:"subject,omitempty"`
	// Expiry - Code expiry.
	Expiry *string `json:"expiry,omitempty"`
	// Thumbprint - Certificate thumbprint.
	Thumbprint *string `json:"thumbprint,omitempty"`
	// IsVerified - Indicate if the certificate is verified by owner of private key.
	IsVerified *bool `json:"isVerified,omitempty"`
	// Certificate - base-64 representation of X509 certificate .cer file or just .pem file content.
	Certificate *[]byte `json:"certificate,omitempty"`
	// Created - Certificate created time.
	Created *string `json:"created,omitempty"`
	// Updated - Certificate updated time.
	Updated *string `json:"updated,omitempty"`
}
