// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.5.1
// - protoc             v3.21.12
// source: yandex/cloud/cdn/v1/shielding_service.proto

package cdn

import (
	context "context"
	operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.64.0 or later.
const _ = grpc.SupportPackageIsVersion9

const (
	ShieldingService_Activate_FullMethodName               = "/yandex.cloud.cdn.v1.ShieldingService/Activate"
	ShieldingService_Deactivate_FullMethodName             = "/yandex.cloud.cdn.v1.ShieldingService/Deactivate"
	ShieldingService_Get_FullMethodName                    = "/yandex.cloud.cdn.v1.ShieldingService/Get"
	ShieldingService_Update_FullMethodName                 = "/yandex.cloud.cdn.v1.ShieldingService/Update"
	ShieldingService_ListAvailableLocations_FullMethodName = "/yandex.cloud.cdn.v1.ShieldingService/ListAvailableLocations"
)

// ShieldingServiceClient is the client API for ShieldingService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
//
// Shielding management service.
type ShieldingServiceClient interface {
	// Activate shielding for a resource.
	Activate(ctx context.Context, in *ActivateShieldingRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Deactivate shielding for a resource.
	Deactivate(ctx context.Context, in *DeactivateShieldingRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Get shielding details by resource ID.
	Get(ctx context.Context, in *GetShieldingDetailsRequest, opts ...grpc.CallOption) (*ShieldingDetails, error)
	// Updates shielding parameters for a resource, such as changing the geographical location of the shielding server.
	// Changes may take up to 15 minutes to propagate across CDN servers.
	// After updating, it is recommended to purge the resource's cache.
	Update(ctx context.Context, in *UpdateShieldingRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Lists available geographical locations.
	ListAvailableLocations(ctx context.Context, in *ListShieldingLocationsRequest, opts ...grpc.CallOption) (*ListShieldingLocationsResponse, error)
}

type shieldingServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewShieldingServiceClient(cc grpc.ClientConnInterface) ShieldingServiceClient {
	return &shieldingServiceClient{cc}
}

func (c *shieldingServiceClient) Activate(ctx context.Context, in *ActivateShieldingRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, ShieldingService_Activate_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *shieldingServiceClient) Deactivate(ctx context.Context, in *DeactivateShieldingRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, ShieldingService_Deactivate_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *shieldingServiceClient) Get(ctx context.Context, in *GetShieldingDetailsRequest, opts ...grpc.CallOption) (*ShieldingDetails, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ShieldingDetails)
	err := c.cc.Invoke(ctx, ShieldingService_Get_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *shieldingServiceClient) Update(ctx context.Context, in *UpdateShieldingRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, ShieldingService_Update_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *shieldingServiceClient) ListAvailableLocations(ctx context.Context, in *ListShieldingLocationsRequest, opts ...grpc.CallOption) (*ListShieldingLocationsResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ListShieldingLocationsResponse)
	err := c.cc.Invoke(ctx, ShieldingService_ListAvailableLocations_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ShieldingServiceServer is the server API for ShieldingService service.
// All implementations should embed UnimplementedShieldingServiceServer
// for forward compatibility.
//
// Shielding management service.
type ShieldingServiceServer interface {
	// Activate shielding for a resource.
	Activate(context.Context, *ActivateShieldingRequest) (*operation.Operation, error)
	// Deactivate shielding for a resource.
	Deactivate(context.Context, *DeactivateShieldingRequest) (*operation.Operation, error)
	// Get shielding details by resource ID.
	Get(context.Context, *GetShieldingDetailsRequest) (*ShieldingDetails, error)
	// Updates shielding parameters for a resource, such as changing the geographical location of the shielding server.
	// Changes may take up to 15 minutes to propagate across CDN servers.
	// After updating, it is recommended to purge the resource's cache.
	Update(context.Context, *UpdateShieldingRequest) (*operation.Operation, error)
	// Lists available geographical locations.
	ListAvailableLocations(context.Context, *ListShieldingLocationsRequest) (*ListShieldingLocationsResponse, error)
}

// UnimplementedShieldingServiceServer should be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedShieldingServiceServer struct{}

func (UnimplementedShieldingServiceServer) Activate(context.Context, *ActivateShieldingRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Activate not implemented")
}
func (UnimplementedShieldingServiceServer) Deactivate(context.Context, *DeactivateShieldingRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Deactivate not implemented")
}
func (UnimplementedShieldingServiceServer) Get(context.Context, *GetShieldingDetailsRequest) (*ShieldingDetails, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedShieldingServiceServer) Update(context.Context, *UpdateShieldingRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Update not implemented")
}
func (UnimplementedShieldingServiceServer) ListAvailableLocations(context.Context, *ListShieldingLocationsRequest) (*ListShieldingLocationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAvailableLocations not implemented")
}
func (UnimplementedShieldingServiceServer) testEmbeddedByValue() {}

// UnsafeShieldingServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ShieldingServiceServer will
// result in compilation errors.
type UnsafeShieldingServiceServer interface {
	mustEmbedUnimplementedShieldingServiceServer()
}

func RegisterShieldingServiceServer(s grpc.ServiceRegistrar, srv ShieldingServiceServer) {
	// If the following call pancis, it indicates UnimplementedShieldingServiceServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&ShieldingService_ServiceDesc, srv)
}

func _ShieldingService_Activate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ActivateShieldingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ShieldingServiceServer).Activate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ShieldingService_Activate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ShieldingServiceServer).Activate(ctx, req.(*ActivateShieldingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ShieldingService_Deactivate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeactivateShieldingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ShieldingServiceServer).Deactivate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ShieldingService_Deactivate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ShieldingServiceServer).Deactivate(ctx, req.(*DeactivateShieldingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ShieldingService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetShieldingDetailsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ShieldingServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ShieldingService_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ShieldingServiceServer).Get(ctx, req.(*GetShieldingDetailsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ShieldingService_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateShieldingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ShieldingServiceServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ShieldingService_Update_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ShieldingServiceServer).Update(ctx, req.(*UpdateShieldingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ShieldingService_ListAvailableLocations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListShieldingLocationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ShieldingServiceServer).ListAvailableLocations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ShieldingService_ListAvailableLocations_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ShieldingServiceServer).ListAvailableLocations(ctx, req.(*ListShieldingLocationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// ShieldingService_ServiceDesc is the grpc.ServiceDesc for ShieldingService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var ShieldingService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "yandex.cloud.cdn.v1.ShieldingService",
	HandlerType: (*ShieldingServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Activate",
			Handler:    _ShieldingService_Activate_Handler,
		},
		{
			MethodName: "Deactivate",
			Handler:    _ShieldingService_Deactivate_Handler,
		},
		{
			MethodName: "Get",
			Handler:    _ShieldingService_Get_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _ShieldingService_Update_Handler,
		},
		{
			MethodName: "ListAvailableLocations",
			Handler:    _ShieldingService_ListAvailableLocations_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "yandex/cloud/cdn/v1/shielding_service.proto",
}
