// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.6
// 	protoc        v3.21.12
// source: yandex/cloud/compute/v1/filesystem_service.proto

package compute

import (
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud"
	access "github.com/yandex-cloud/go-genproto/yandex/cloud/access"
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud/api"
	operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type GetFilesystemRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the filesystem to return.
	//
	// To get the filesystem ID, make a [FilesystemService.List] request.
	FilesystemId  string `protobuf:"bytes,1,opt,name=filesystem_id,json=filesystemId,proto3" json:"filesystem_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetFilesystemRequest) Reset() {
	*x = GetFilesystemRequest{}
	mi := &file_yandex_cloud_compute_v1_filesystem_service_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetFilesystemRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetFilesystemRequest) ProtoMessage() {}

func (x *GetFilesystemRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_compute_v1_filesystem_service_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetFilesystemRequest.ProtoReflect.Descriptor instead.
func (*GetFilesystemRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_compute_v1_filesystem_service_proto_rawDescGZIP(), []int{0}
}

func (x *GetFilesystemRequest) GetFilesystemId() string {
	if x != nil {
		return x.FilesystemId
	}
	return ""
}

type ListFilesystemsRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the folder to list filesystems in.
	//
	// To get the folder ID, make a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
	FolderId string `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than `page_size`,
	// the service returns a [ListFilesystemsResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results, set `page_token` to the
	// [ListFilesystemsResponse.next_page_token] returned by a previous list request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A filter expression that filters resources listed in the response.
	// The expression consists of one or more conditions united by `AND` operator: `<condition1> [AND <condition2> [<...> AND <conditionN>]]`.
	//
	// Each condition has the form `<field> <operator> <value>`, where:
	// 1. `<field>` is the field name. Currently you can use filtering only on the limited number of fields.
	// 2. `<operator>` is a logical operator, one of `=`, `!=`, `IN`, `NOT IN`.
	// 3. `<value>` represents a value.
	// String values should be written in double (`"`) or single (`'`) quotes. C-style escape sequences are supported (`\"` turns to `"`, `\'` to `'`, `\\` to backslash).
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// By which column the listing should be ordered and in which direction,
	// format is "createdAt desc". "id asc" if omitted.
	// The default sorting order is ascending
	OrderBy       string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListFilesystemsRequest) Reset() {
	*x = ListFilesystemsRequest{}
	mi := &file_yandex_cloud_compute_v1_filesystem_service_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListFilesystemsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListFilesystemsRequest) ProtoMessage() {}

func (x *ListFilesystemsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_compute_v1_filesystem_service_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListFilesystemsRequest.ProtoReflect.Descriptor instead.
func (*ListFilesystemsRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_compute_v1_filesystem_service_proto_rawDescGZIP(), []int{1}
}

func (x *ListFilesystemsRequest) GetFolderId() string {
	if x != nil {
		return x.FolderId
	}
	return ""
}

func (x *ListFilesystemsRequest) GetPageSize() int64 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListFilesystemsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListFilesystemsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListFilesystemsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

type ListFilesystemsResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// List of filesystems in the specified folder.
	Filesystems []*Filesystem `protobuf:"bytes,1,rep,name=filesystems,proto3" json:"filesystems,omitempty"`
	// Token for getting the next page of the list. If the number of results is greater than
	// the specified [ListFilesystemsRequest.page_size], use `next_page_token` as the value
	// for the [ListFilesystemsRequest.page_token] parameter in the next list request.
	//
	// Each subsequent page will have its own `next_page_token` to continue paging through the results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListFilesystemsResponse) Reset() {
	*x = ListFilesystemsResponse{}
	mi := &file_yandex_cloud_compute_v1_filesystem_service_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListFilesystemsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListFilesystemsResponse) ProtoMessage() {}

func (x *ListFilesystemsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_compute_v1_filesystem_service_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListFilesystemsResponse.ProtoReflect.Descriptor instead.
func (*ListFilesystemsResponse) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_compute_v1_filesystem_service_proto_rawDescGZIP(), []int{2}
}

func (x *ListFilesystemsResponse) GetFilesystems() []*Filesystem {
	if x != nil {
		return x.Filesystems
	}
	return nil
}

func (x *ListFilesystemsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

type CreateFilesystemRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the folder to create a filesystem in.
	//
	// To get the folder ID, make a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
	FolderId string `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// Name of the filesystem. The name must be unique within the folder.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the filesystem.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Filesystem labels as `key:value` pairs.
	// For details about the concept, see [documentation](/docs/overview/concepts/services#labels).
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// ID of the filesystem type.
	//
	// To get a list of available filesystem types, make a [yandex.cloud.compute.v1.DiskTypeService.List] request.
	//
	// The filesystem type cannot be updated after the filesystem creation.
	TypeId string `protobuf:"bytes,5,opt,name=type_id,json=typeId,proto3" json:"type_id,omitempty"`
	// ID of the availability zone where the filesystem resides.
	//
	// To get a list of available zones, make a [yandex.cloud.compute.v1.ZoneService.List] request.
	//
	// A filesystem can be attached only to virtual machines residing in the same availability zone.
	// The filesystem availability zone cannot be updated after the filesystem creation.
	ZoneId string `protobuf:"bytes,6,opt,name=zone_id,json=zoneId,proto3" json:"zone_id,omitempty"`
	// Size of the filesystem, specified in bytes.
	//
	// The size of the filesystem cannot be updated after the filesystem creation.
	Size int64 `protobuf:"varint,7,opt,name=size,proto3" json:"size,omitempty"`
	// Block size used for the filesystem, specified in bytes.
	//
	// The block size cannot be updated after the filesystem creation.
	//
	// Default value: 4096.
	BlockSize     int64 `protobuf:"varint,8,opt,name=block_size,json=blockSize,proto3" json:"block_size,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CreateFilesystemRequest) Reset() {
	*x = CreateFilesystemRequest{}
	mi := &file_yandex_cloud_compute_v1_filesystem_service_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateFilesystemRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateFilesystemRequest) ProtoMessage() {}

func (x *CreateFilesystemRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_compute_v1_filesystem_service_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateFilesystemRequest.ProtoReflect.Descriptor instead.
func (*CreateFilesystemRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_compute_v1_filesystem_service_proto_rawDescGZIP(), []int{3}
}

func (x *CreateFilesystemRequest) GetFolderId() string {
	if x != nil {
		return x.FolderId
	}
	return ""
}

func (x *CreateFilesystemRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CreateFilesystemRequest) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *CreateFilesystemRequest) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *CreateFilesystemRequest) GetTypeId() string {
	if x != nil {
		return x.TypeId
	}
	return ""
}

func (x *CreateFilesystemRequest) GetZoneId() string {
	if x != nil {
		return x.ZoneId
	}
	return ""
}

func (x *CreateFilesystemRequest) GetSize() int64 {
	if x != nil {
		return x.Size
	}
	return 0
}

func (x *CreateFilesystemRequest) GetBlockSize() int64 {
	if x != nil {
		return x.BlockSize
	}
	return 0
}

type CreateFilesystemMetadata struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the filesystem that is being created.
	FilesystemId  string `protobuf:"bytes,1,opt,name=filesystem_id,json=filesystemId,proto3" json:"filesystem_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CreateFilesystemMetadata) Reset() {
	*x = CreateFilesystemMetadata{}
	mi := &file_yandex_cloud_compute_v1_filesystem_service_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateFilesystemMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateFilesystemMetadata) ProtoMessage() {}

func (x *CreateFilesystemMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_compute_v1_filesystem_service_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateFilesystemMetadata.ProtoReflect.Descriptor instead.
func (*CreateFilesystemMetadata) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_compute_v1_filesystem_service_proto_rawDescGZIP(), []int{4}
}

func (x *CreateFilesystemMetadata) GetFilesystemId() string {
	if x != nil {
		return x.FilesystemId
	}
	return ""
}

type UpdateFilesystemRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the filesystem to update.
	//
	// To get the filesystem ID, make a [FilesystemService.List] request.
	FilesystemId string `protobuf:"bytes,1,opt,name=filesystem_id,json=filesystemId,proto3" json:"filesystem_id,omitempty"`
	// Field mask that specifies which attributes of the filesystem should be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// New name of the filesystem. The name must be unique within the folder.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// New description of the filesystem.
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// New filesystem labels as `key:value` pairs.
	// For details about the concept, see [documentation](/docs/overview/concepts/services#labels).
	//
	// Existing set of labels is completely replaced by the provided set, so if you just want
	// to add or remove a label:
	// 1. Get the current set of labels with a [FilesystemService.Get] request.
	// 2. Add or remove a label in this set.
	// 3. Send the new set in this field.
	Labels map[string]string `protobuf:"bytes,5,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Size of the filesystem, specified in bytes.
	Size          int64 `protobuf:"varint,6,opt,name=size,proto3" json:"size,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UpdateFilesystemRequest) Reset() {
	*x = UpdateFilesystemRequest{}
	mi := &file_yandex_cloud_compute_v1_filesystem_service_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateFilesystemRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateFilesystemRequest) ProtoMessage() {}

func (x *UpdateFilesystemRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_compute_v1_filesystem_service_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateFilesystemRequest.ProtoReflect.Descriptor instead.
func (*UpdateFilesystemRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_compute_v1_filesystem_service_proto_rawDescGZIP(), []int{5}
}

func (x *UpdateFilesystemRequest) GetFilesystemId() string {
	if x != nil {
		return x.FilesystemId
	}
	return ""
}

func (x *UpdateFilesystemRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateFilesystemRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *UpdateFilesystemRequest) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *UpdateFilesystemRequest) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *UpdateFilesystemRequest) GetSize() int64 {
	if x != nil {
		return x.Size
	}
	return 0
}

type UpdateFilesystemMetadata struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the filesystem that is being updated.
	FilesystemId  string `protobuf:"bytes,1,opt,name=filesystem_id,json=filesystemId,proto3" json:"filesystem_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UpdateFilesystemMetadata) Reset() {
	*x = UpdateFilesystemMetadata{}
	mi := &file_yandex_cloud_compute_v1_filesystem_service_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateFilesystemMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateFilesystemMetadata) ProtoMessage() {}

func (x *UpdateFilesystemMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_compute_v1_filesystem_service_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateFilesystemMetadata.ProtoReflect.Descriptor instead.
func (*UpdateFilesystemMetadata) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_compute_v1_filesystem_service_proto_rawDescGZIP(), []int{6}
}

func (x *UpdateFilesystemMetadata) GetFilesystemId() string {
	if x != nil {
		return x.FilesystemId
	}
	return ""
}

type DeleteFilesystemRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the filesystem to delete.
	//
	// To get the filesystem ID, make a [FilesystemService.List] request.
	FilesystemId  string `protobuf:"bytes,1,opt,name=filesystem_id,json=filesystemId,proto3" json:"filesystem_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DeleteFilesystemRequest) Reset() {
	*x = DeleteFilesystemRequest{}
	mi := &file_yandex_cloud_compute_v1_filesystem_service_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteFilesystemRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteFilesystemRequest) ProtoMessage() {}

func (x *DeleteFilesystemRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_compute_v1_filesystem_service_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteFilesystemRequest.ProtoReflect.Descriptor instead.
func (*DeleteFilesystemRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_compute_v1_filesystem_service_proto_rawDescGZIP(), []int{7}
}

func (x *DeleteFilesystemRequest) GetFilesystemId() string {
	if x != nil {
		return x.FilesystemId
	}
	return ""
}

type DeleteFilesystemMetadata struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the filesystem that is being deleted.
	FilesystemId  string `protobuf:"bytes,1,opt,name=filesystem_id,json=filesystemId,proto3" json:"filesystem_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DeleteFilesystemMetadata) Reset() {
	*x = DeleteFilesystemMetadata{}
	mi := &file_yandex_cloud_compute_v1_filesystem_service_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteFilesystemMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteFilesystemMetadata) ProtoMessage() {}

func (x *DeleteFilesystemMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_compute_v1_filesystem_service_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteFilesystemMetadata.ProtoReflect.Descriptor instead.
func (*DeleteFilesystemMetadata) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_compute_v1_filesystem_service_proto_rawDescGZIP(), []int{8}
}

func (x *DeleteFilesystemMetadata) GetFilesystemId() string {
	if x != nil {
		return x.FilesystemId
	}
	return ""
}

type ListFilesystemOperationsRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the filesystem to list operations for.
	//
	// To get the filesystem ID, make a [FilesystemService.List] request.
	FilesystemId string `protobuf:"bytes,1,opt,name=filesystem_id,json=filesystemId,proto3" json:"filesystem_id,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than `page_size`, the service returns a [ListFilesystemOperationsResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results, set `page_token` to the
	// [ListFilesystemOperationsResponse.next_page_token] returned by a previous list request.
	PageToken     string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListFilesystemOperationsRequest) Reset() {
	*x = ListFilesystemOperationsRequest{}
	mi := &file_yandex_cloud_compute_v1_filesystem_service_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListFilesystemOperationsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListFilesystemOperationsRequest) ProtoMessage() {}

func (x *ListFilesystemOperationsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_compute_v1_filesystem_service_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListFilesystemOperationsRequest.ProtoReflect.Descriptor instead.
func (*ListFilesystemOperationsRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_compute_v1_filesystem_service_proto_rawDescGZIP(), []int{9}
}

func (x *ListFilesystemOperationsRequest) GetFilesystemId() string {
	if x != nil {
		return x.FilesystemId
	}
	return ""
}

func (x *ListFilesystemOperationsRequest) GetPageSize() int64 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListFilesystemOperationsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

type ListFilesystemOperationsResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// List of operations for the specified filesystem.
	Operations []*operation.Operation `protobuf:"bytes,1,rep,name=operations,proto3" json:"operations,omitempty"`
	// Token for getting the next page of the list. If the number of results is greater than
	// the specified [ListFilesystemOperationsRequest.page_size], use `next_page_token` as the value
	// for the [ListFilesystemOperationsRequest.page_token] parameter in the next list request.
	//
	// Each subsequent page will have its own `next_page_token` to continue paging through the results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListFilesystemOperationsResponse) Reset() {
	*x = ListFilesystemOperationsResponse{}
	mi := &file_yandex_cloud_compute_v1_filesystem_service_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListFilesystemOperationsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListFilesystemOperationsResponse) ProtoMessage() {}

func (x *ListFilesystemOperationsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_compute_v1_filesystem_service_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListFilesystemOperationsResponse.ProtoReflect.Descriptor instead.
func (*ListFilesystemOperationsResponse) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_compute_v1_filesystem_service_proto_rawDescGZIP(), []int{10}
}

func (x *ListFilesystemOperationsResponse) GetOperations() []*operation.Operation {
	if x != nil {
		return x.Operations
	}
	return nil
}

func (x *ListFilesystemOperationsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

var File_yandex_cloud_compute_v1_filesystem_service_proto protoreflect.FileDescriptor

const file_yandex_cloud_compute_v1_filesystem_service_proto_rawDesc = "" +
	"\n" +
	"0yandex/cloud/compute/v1/filesystem_service.proto\x12\x17yandex.cloud.compute.v1\x1a\x1cgoogle/api/annotations.proto\x1a google/protobuf/field_mask.proto\x1a yandex/cloud/access/access.proto\x1a yandex/cloud/api/operation.proto\x1a(yandex/cloud/compute/v1/filesystem.proto\x1a&yandex/cloud/operation/operation.proto\x1a\x1dyandex/cloud/validation.proto\"I\n" +
	"\x14GetFilesystemRequest\x121\n" +
	"\rfilesystem_id\x18\x01 \x01(\tB\f\xe8\xc71\x01\x8a\xc81\x04<=50R\ffilesystemId\"\xe0\x01\n" +
	"\x16ListFilesystemsRequest\x12)\n" +
	"\tfolder_id\x18\x01 \x01(\tB\f\xe8\xc71\x01\x8a\xc81\x04<=50R\bfolderId\x12'\n" +
	"\tpage_size\x18\x02 \x01(\x03B\n" +
	"\xfa\xc71\x06<=1000R\bpageSize\x12(\n" +
	"\n" +
	"page_token\x18\x03 \x01(\tB\t\x8a\xc81\x05<=100R\tpageToken\x12\"\n" +
	"\x06filter\x18\x04 \x01(\tB\n" +
	"\x8a\xc81\x06<=1000R\x06filter\x12$\n" +
	"\border_by\x18\x05 \x01(\tB\t\x8a\xc81\x05<=100R\aorderBy\"\x88\x01\n" +
	"\x17ListFilesystemsResponse\x12E\n" +
	"\vfilesystems\x18\x01 \x03(\v2#.yandex.cloud.compute.v1.FilesystemR\vfilesystems\x12&\n" +
	"\x0fnext_page_token\x18\x02 \x01(\tR\rnextPageToken\"\x86\x04\n" +
	"\x17CreateFilesystemRequest\x12)\n" +
	"\tfolder_id\x18\x01 \x01(\tB\f\xe8\xc71\x01\x8a\xc81\x04<=50R\bfolderId\x129\n" +
	"\x04name\x18\x02 \x01(\tB%\xf2\xc71!|[a-z]([-_a-z0-9]{0,61}[a-z0-9])?R\x04name\x12+\n" +
	"\vdescription\x18\x03 \x01(\tB\t\x8a\xc81\x05<=256R\vdescription\x12\x99\x01\n" +
	"\x06labels\x18\x04 \x03(\v2<.yandex.cloud.compute.v1.CreateFilesystemRequest.LabelsEntryBC\xf2\xc71\x0f[-_./\\@0-9a-z]*\x82\xc81\x04<=64\x8a\xc81\x04<=63\xb2\xc81\x1c\x12\x14[a-z][-_./\\@0-9a-z]*\x1a\x041-63R\x06labels\x12!\n" +
	"\atype_id\x18\x05 \x01(\tB\b\x8a\xc81\x04<=50R\x06typeId\x12%\n" +
	"\azone_id\x18\x06 \x01(\tB\f\xe8\xc71\x01\x8a\xc81\x04<=50R\x06zoneId\x12\x18\n" +
	"\x04size\x18\a \x01(\x03B\x04\xe8\xc71\x01R\x04size\x12\x1d\n" +
	"\n" +
	"block_size\x18\b \x01(\x03R\tblockSize\x1a9\n" +
	"\vLabelsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01\"?\n" +
	"\x18CreateFilesystemMetadata\x12#\n" +
	"\rfilesystem_id\x18\x01 \x01(\tR\ffilesystemId\"\xdc\x03\n" +
	"\x17UpdateFilesystemRequest\x121\n" +
	"\rfilesystem_id\x18\x01 \x01(\tB\f\xe8\xc71\x01\x8a\xc81\x04<=50R\ffilesystemId\x12;\n" +
	"\vupdate_mask\x18\x02 \x01(\v2\x1a.google.protobuf.FieldMaskR\n" +
	"updateMask\x129\n" +
	"\x04name\x18\x03 \x01(\tB%\xf2\xc71!|[a-z]([-_a-z0-9]{0,61}[a-z0-9])?R\x04name\x12+\n" +
	"\vdescription\x18\x04 \x01(\tB\t\x8a\xc81\x05<=256R\vdescription\x12\x99\x01\n" +
	"\x06labels\x18\x05 \x03(\v2<.yandex.cloud.compute.v1.UpdateFilesystemRequest.LabelsEntryBC\xf2\xc71\x0f[-_./\\@0-9a-z]*\x82\xc81\x04<=64\x8a\xc81\x04<=63\xb2\xc81\x1c\x12\x14[a-z][-_./\\@0-9a-z]*\x1a\x041-63R\x06labels\x12\x12\n" +
	"\x04size\x18\x06 \x01(\x03R\x04size\x1a9\n" +
	"\vLabelsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01\"?\n" +
	"\x18UpdateFilesystemMetadata\x12#\n" +
	"\rfilesystem_id\x18\x01 \x01(\tR\ffilesystemId\"L\n" +
	"\x17DeleteFilesystemRequest\x121\n" +
	"\rfilesystem_id\x18\x01 \x01(\tB\f\xe8\xc71\x01\x8a\xc81\x04<=50R\ffilesystemId\"?\n" +
	"\x18DeleteFilesystemMetadata\x12#\n" +
	"\rfilesystem_id\x18\x01 \x01(\tR\ffilesystemId\"\xa7\x01\n" +
	"\x1fListFilesystemOperationsRequest\x121\n" +
	"\rfilesystem_id\x18\x01 \x01(\tB\f\xe8\xc71\x01\x8a\xc81\x04<=50R\ffilesystemId\x12'\n" +
	"\tpage_size\x18\x02 \x01(\x03B\n" +
	"\xfa\xc71\x06<=1000R\bpageSize\x12(\n" +
	"\n" +
	"page_token\x18\x03 \x01(\tB\t\x8a\xc81\x05<=100R\tpageToken\"\x8d\x01\n" +
	" ListFilesystemOperationsResponse\x12A\n" +
	"\n" +
	"operations\x18\x01 \x03(\v2!.yandex.cloud.operation.OperationR\n" +
	"operations\x12&\n" +
	"\x0fnext_page_token\x18\x02 \x01(\tR\rnextPageToken2\xdb\r\n" +
	"\x11FilesystemService\x12\x8a\x01\n" +
	"\x03Get\x12-.yandex.cloud.compute.v1.GetFilesystemRequest\x1a#.yandex.cloud.compute.v1.Filesystem\"/\x82\xd3\xe4\x93\x02)\x12'/compute/v1/filesystems/{filesystem_id}\x12\x8a\x01\n" +
	"\x04List\x12/.yandex.cloud.compute.v1.ListFilesystemsRequest\x1a0.yandex.cloud.compute.v1.ListFilesystemsResponse\"\x1f\x82\xd3\xe4\x93\x02\x19\x12\x17/compute/v1/filesystems\x12\xab\x01\n" +
	"\x06Create\x120.yandex.cloud.compute.v1.CreateFilesystemRequest\x1a!.yandex.cloud.operation.Operation\"L\xb2\xd2*&\n" +
	"\x18CreateFilesystemMetadata\x12\n" +
	"Filesystem\x82\xd3\xe4\x93\x02\x1c:\x01*\"\x17/compute/v1/filesystems\x12\xbb\x01\n" +
	"\x06Update\x120.yandex.cloud.compute.v1.UpdateFilesystemRequest\x1a!.yandex.cloud.operation.Operation\"\\\xb2\xd2*&\n" +
	"\x18UpdateFilesystemMetadata\x12\n" +
	"Filesystem\x82\xd3\xe4\x93\x02,:\x01*2'/compute/v1/filesystems/{filesystem_id}\x12\xc3\x01\n" +
	"\x06Delete\x120.yandex.cloud.compute.v1.DeleteFilesystemRequest\x1a!.yandex.cloud.operation.Operation\"d\xb2\xd2*1\n" +
	"\x18DeleteFilesystemMetadata\x12\x15google.protobuf.Empty\x82\xd3\xe4\x93\x02)*'/compute/v1/filesystems/{filesystem_id}\x12\xc1\x01\n" +
	"\x0eListOperations\x128.yandex.cloud.compute.v1.ListFilesystemOperationsRequest\x1a9.yandex.cloud.compute.v1.ListFilesystemOperationsResponse\":\x82\xd3\xe4\x93\x024\x122/compute/v1/filesystems/{filesystem_id}/operations\x12\xb7\x01\n" +
	"\x12ListAccessBindings\x12..yandex.cloud.access.ListAccessBindingsRequest\x1a/.yandex.cloud.access.ListAccessBindingsResponse\"@\x82\xd3\xe4\x93\x02:\x128/compute/v1/filesystems/{resource_id}:listAccessBindings\x12\xf6\x01\n" +
	"\x11SetAccessBindings\x12-.yandex.cloud.access.SetAccessBindingsRequest\x1a!.yandex.cloud.operation.Operation\"\x8e\x01\xb2\xd2*H\n" +
	" access.SetAccessBindingsMetadata\x12$access.AccessBindingsOperationResult\x82\xd3\xe4\x93\x02<:\x01*\"7/compute/v1/filesystems/{resource_id}:setAccessBindings\x12\x82\x02\n" +
	"\x14UpdateAccessBindings\x120.yandex.cloud.access.UpdateAccessBindingsRequest\x1a!.yandex.cloud.operation.Operation\"\x94\x01\xb2\xd2*K\n" +
	"#access.UpdateAccessBindingsMetadata\x12$access.AccessBindingsOperationResult\x82\xd3\xe4\x93\x02?:\x01*\":/compute/v1/filesystems/{resource_id}:updateAccessBindingsBb\n" +
	"\x1byandex.cloud.api.compute.v1ZCgithub.com/yandex-cloud/go-genproto/yandex/cloud/compute/v1;computeb\x06proto3"

var (
	file_yandex_cloud_compute_v1_filesystem_service_proto_rawDescOnce sync.Once
	file_yandex_cloud_compute_v1_filesystem_service_proto_rawDescData []byte
)

func file_yandex_cloud_compute_v1_filesystem_service_proto_rawDescGZIP() []byte {
	file_yandex_cloud_compute_v1_filesystem_service_proto_rawDescOnce.Do(func() {
		file_yandex_cloud_compute_v1_filesystem_service_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_yandex_cloud_compute_v1_filesystem_service_proto_rawDesc), len(file_yandex_cloud_compute_v1_filesystem_service_proto_rawDesc)))
	})
	return file_yandex_cloud_compute_v1_filesystem_service_proto_rawDescData
}

var file_yandex_cloud_compute_v1_filesystem_service_proto_msgTypes = make([]protoimpl.MessageInfo, 13)
var file_yandex_cloud_compute_v1_filesystem_service_proto_goTypes = []any{
	(*GetFilesystemRequest)(nil),               // 0: yandex.cloud.compute.v1.GetFilesystemRequest
	(*ListFilesystemsRequest)(nil),             // 1: yandex.cloud.compute.v1.ListFilesystemsRequest
	(*ListFilesystemsResponse)(nil),            // 2: yandex.cloud.compute.v1.ListFilesystemsResponse
	(*CreateFilesystemRequest)(nil),            // 3: yandex.cloud.compute.v1.CreateFilesystemRequest
	(*CreateFilesystemMetadata)(nil),           // 4: yandex.cloud.compute.v1.CreateFilesystemMetadata
	(*UpdateFilesystemRequest)(nil),            // 5: yandex.cloud.compute.v1.UpdateFilesystemRequest
	(*UpdateFilesystemMetadata)(nil),           // 6: yandex.cloud.compute.v1.UpdateFilesystemMetadata
	(*DeleteFilesystemRequest)(nil),            // 7: yandex.cloud.compute.v1.DeleteFilesystemRequest
	(*DeleteFilesystemMetadata)(nil),           // 8: yandex.cloud.compute.v1.DeleteFilesystemMetadata
	(*ListFilesystemOperationsRequest)(nil),    // 9: yandex.cloud.compute.v1.ListFilesystemOperationsRequest
	(*ListFilesystemOperationsResponse)(nil),   // 10: yandex.cloud.compute.v1.ListFilesystemOperationsResponse
	nil,                                        // 11: yandex.cloud.compute.v1.CreateFilesystemRequest.LabelsEntry
	nil,                                        // 12: yandex.cloud.compute.v1.UpdateFilesystemRequest.LabelsEntry
	(*Filesystem)(nil),                         // 13: yandex.cloud.compute.v1.Filesystem
	(*fieldmaskpb.FieldMask)(nil),              // 14: google.protobuf.FieldMask
	(*operation.Operation)(nil),                // 15: yandex.cloud.operation.Operation
	(*access.ListAccessBindingsRequest)(nil),   // 16: yandex.cloud.access.ListAccessBindingsRequest
	(*access.SetAccessBindingsRequest)(nil),    // 17: yandex.cloud.access.SetAccessBindingsRequest
	(*access.UpdateAccessBindingsRequest)(nil), // 18: yandex.cloud.access.UpdateAccessBindingsRequest
	(*access.ListAccessBindingsResponse)(nil),  // 19: yandex.cloud.access.ListAccessBindingsResponse
}
var file_yandex_cloud_compute_v1_filesystem_service_proto_depIdxs = []int32{
	13, // 0: yandex.cloud.compute.v1.ListFilesystemsResponse.filesystems:type_name -> yandex.cloud.compute.v1.Filesystem
	11, // 1: yandex.cloud.compute.v1.CreateFilesystemRequest.labels:type_name -> yandex.cloud.compute.v1.CreateFilesystemRequest.LabelsEntry
	14, // 2: yandex.cloud.compute.v1.UpdateFilesystemRequest.update_mask:type_name -> google.protobuf.FieldMask
	12, // 3: yandex.cloud.compute.v1.UpdateFilesystemRequest.labels:type_name -> yandex.cloud.compute.v1.UpdateFilesystemRequest.LabelsEntry
	15, // 4: yandex.cloud.compute.v1.ListFilesystemOperationsResponse.operations:type_name -> yandex.cloud.operation.Operation
	0,  // 5: yandex.cloud.compute.v1.FilesystemService.Get:input_type -> yandex.cloud.compute.v1.GetFilesystemRequest
	1,  // 6: yandex.cloud.compute.v1.FilesystemService.List:input_type -> yandex.cloud.compute.v1.ListFilesystemsRequest
	3,  // 7: yandex.cloud.compute.v1.FilesystemService.Create:input_type -> yandex.cloud.compute.v1.CreateFilesystemRequest
	5,  // 8: yandex.cloud.compute.v1.FilesystemService.Update:input_type -> yandex.cloud.compute.v1.UpdateFilesystemRequest
	7,  // 9: yandex.cloud.compute.v1.FilesystemService.Delete:input_type -> yandex.cloud.compute.v1.DeleteFilesystemRequest
	9,  // 10: yandex.cloud.compute.v1.FilesystemService.ListOperations:input_type -> yandex.cloud.compute.v1.ListFilesystemOperationsRequest
	16, // 11: yandex.cloud.compute.v1.FilesystemService.ListAccessBindings:input_type -> yandex.cloud.access.ListAccessBindingsRequest
	17, // 12: yandex.cloud.compute.v1.FilesystemService.SetAccessBindings:input_type -> yandex.cloud.access.SetAccessBindingsRequest
	18, // 13: yandex.cloud.compute.v1.FilesystemService.UpdateAccessBindings:input_type -> yandex.cloud.access.UpdateAccessBindingsRequest
	13, // 14: yandex.cloud.compute.v1.FilesystemService.Get:output_type -> yandex.cloud.compute.v1.Filesystem
	2,  // 15: yandex.cloud.compute.v1.FilesystemService.List:output_type -> yandex.cloud.compute.v1.ListFilesystemsResponse
	15, // 16: yandex.cloud.compute.v1.FilesystemService.Create:output_type -> yandex.cloud.operation.Operation
	15, // 17: yandex.cloud.compute.v1.FilesystemService.Update:output_type -> yandex.cloud.operation.Operation
	15, // 18: yandex.cloud.compute.v1.FilesystemService.Delete:output_type -> yandex.cloud.operation.Operation
	10, // 19: yandex.cloud.compute.v1.FilesystemService.ListOperations:output_type -> yandex.cloud.compute.v1.ListFilesystemOperationsResponse
	19, // 20: yandex.cloud.compute.v1.FilesystemService.ListAccessBindings:output_type -> yandex.cloud.access.ListAccessBindingsResponse
	15, // 21: yandex.cloud.compute.v1.FilesystemService.SetAccessBindings:output_type -> yandex.cloud.operation.Operation
	15, // 22: yandex.cloud.compute.v1.FilesystemService.UpdateAccessBindings:output_type -> yandex.cloud.operation.Operation
	14, // [14:23] is the sub-list for method output_type
	5,  // [5:14] is the sub-list for method input_type
	5,  // [5:5] is the sub-list for extension type_name
	5,  // [5:5] is the sub-list for extension extendee
	0,  // [0:5] is the sub-list for field type_name
}

func init() { file_yandex_cloud_compute_v1_filesystem_service_proto_init() }
func file_yandex_cloud_compute_v1_filesystem_service_proto_init() {
	if File_yandex_cloud_compute_v1_filesystem_service_proto != nil {
		return
	}
	file_yandex_cloud_compute_v1_filesystem_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_yandex_cloud_compute_v1_filesystem_service_proto_rawDesc), len(file_yandex_cloud_compute_v1_filesystem_service_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   13,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_yandex_cloud_compute_v1_filesystem_service_proto_goTypes,
		DependencyIndexes: file_yandex_cloud_compute_v1_filesystem_service_proto_depIdxs,
		MessageInfos:      file_yandex_cloud_compute_v1_filesystem_service_proto_msgTypes,
	}.Build()
	File_yandex_cloud_compute_v1_filesystem_service_proto = out.File
	file_yandex_cloud_compute_v1_filesystem_service_proto_goTypes = nil
	file_yandex_cloud_compute_v1_filesystem_service_proto_depIdxs = nil
}
