// Code generated by ent, DO NOT EDIT.

package ent

import (
	"context"
	"errors"
	"fmt"
	"sync"
	"time"

	"entgo.io/ent"
	"entgo.io/ent/dialect/sql"
	"github.com/crowdsecurity/crowdsec/pkg/database/ent/alert"
	"github.com/crowdsecurity/crowdsec/pkg/database/ent/allowlist"
	"github.com/crowdsecurity/crowdsec/pkg/database/ent/allowlistitem"
	"github.com/crowdsecurity/crowdsec/pkg/database/ent/bouncer"
	"github.com/crowdsecurity/crowdsec/pkg/database/ent/configitem"
	"github.com/crowdsecurity/crowdsec/pkg/database/ent/decision"
	"github.com/crowdsecurity/crowdsec/pkg/database/ent/event"
	"github.com/crowdsecurity/crowdsec/pkg/database/ent/lock"
	"github.com/crowdsecurity/crowdsec/pkg/database/ent/machine"
	"github.com/crowdsecurity/crowdsec/pkg/database/ent/meta"
	"github.com/crowdsecurity/crowdsec/pkg/database/ent/metric"
	"github.com/crowdsecurity/crowdsec/pkg/database/ent/predicate"
	"github.com/crowdsecurity/crowdsec/pkg/database/ent/schema"
)

const (
	// Operation types.
	OpCreate    = ent.OpCreate
	OpDelete    = ent.OpDelete
	OpDeleteOne = ent.OpDeleteOne
	OpUpdate    = ent.OpUpdate
	OpUpdateOne = ent.OpUpdateOne

	// Node types.
	TypeAlert         = "Alert"
	TypeAllowList     = "AllowList"
	TypeAllowListItem = "AllowListItem"
	TypeBouncer       = "Bouncer"
	TypeConfigItem    = "ConfigItem"
	TypeDecision      = "Decision"
	TypeEvent         = "Event"
	TypeLock          = "Lock"
	TypeMachine       = "Machine"
	TypeMeta          = "Meta"
	TypeMetric        = "Metric"
)

// AlertMutation represents an operation that mutates the Alert nodes in the graph.
type AlertMutation struct {
	config
	op                 Op
	typ                string
	id                 *int
	created_at         *time.Time
	updated_at         *time.Time
	scenario           *string
	bucketId           *string
	message            *string
	eventsCount        *int32
	addeventsCount     *int32
	startedAt          *time.Time
	stoppedAt          *time.Time
	sourceIp           *string
	sourceRange        *string
	sourceAsNumber     *string
	sourceAsName       *string
	sourceCountry      *string
	sourceLatitude     *float32
	addsourceLatitude  *float32
	sourceLongitude    *float32
	addsourceLongitude *float32
	sourceScope        *string
	sourceValue        *string
	capacity           *int32
	addcapacity        *int32
	leakSpeed          *string
	scenarioVersion    *string
	scenarioHash       *string
	simulated          *bool
	uuid               *string
	remediation        *bool
	clearedFields      map[string]struct{}
	owner              *int
	clearedowner       bool
	decisions          map[int]struct{}
	removeddecisions   map[int]struct{}
	cleareddecisions   bool
	events             map[int]struct{}
	removedevents      map[int]struct{}
	clearedevents      bool
	metas              map[int]struct{}
	removedmetas       map[int]struct{}
	clearedmetas       bool
	done               bool
	oldValue           func(context.Context) (*Alert, error)
	predicates         []predicate.Alert
}

var _ ent.Mutation = (*AlertMutation)(nil)

// alertOption allows management of the mutation configuration using functional options.
type alertOption func(*AlertMutation)

// newAlertMutation creates new mutation for the Alert entity.
func newAlertMutation(c config, op Op, opts ...alertOption) *AlertMutation {
	m := &AlertMutation{
		config:        c,
		op:            op,
		typ:           TypeAlert,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withAlertID sets the ID field of the mutation.
func withAlertID(id int) alertOption {
	return func(m *AlertMutation) {
		var (
			err   error
			once  sync.Once
			value *Alert
		)
		m.oldValue = func(ctx context.Context) (*Alert, error) {
			once.Do(func() {
				if m.done {
					err = errors.New("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().Alert.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withAlert sets the old Alert of the mutation.
func withAlert(node *Alert) alertOption {
	return func(m *AlertMutation) {
		m.oldValue = func(context.Context) (*Alert, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m AlertMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m AlertMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, errors.New("ent: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *AlertMutation) ID() (id int, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// IDs queries the database and returns the entity ids that match the mutation's predicate.
// That means, if the mutation is applied within a transaction with an isolation level such
// as sql.LevelSerializable, the returned ids match the ids of the rows that will be updated
// or updated by the mutation.
func (m *AlertMutation) IDs(ctx context.Context) ([]int, error) {
	switch {
	case m.op.Is(OpUpdateOne | OpDeleteOne):
		id, exists := m.ID()
		if exists {
			return []int{id}, nil
		}
		fallthrough
	case m.op.Is(OpUpdate | OpDelete):
		return m.Client().Alert.Query().Where(m.predicates...).IDs(ctx)
	default:
		return nil, fmt.Errorf("IDs is not allowed on %s operations", m.op)
	}
}

// SetCreatedAt sets the "created_at" field.
func (m *AlertMutation) SetCreatedAt(t time.Time) {
	m.created_at = &t
}

// CreatedAt returns the value of the "created_at" field in the mutation.
func (m *AlertMutation) CreatedAt() (r time.Time, exists bool) {
	v := m.created_at
	if v == nil {
		return
	}
	return *v, true
}

// OldCreatedAt returns the old "created_at" field's value of the Alert entity.
// If the Alert object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AlertMutation) OldCreatedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldCreatedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldCreatedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldCreatedAt: %w", err)
	}
	return oldValue.CreatedAt, nil
}

// ResetCreatedAt resets all changes to the "created_at" field.
func (m *AlertMutation) ResetCreatedAt() {
	m.created_at = nil
}

// SetUpdatedAt sets the "updated_at" field.
func (m *AlertMutation) SetUpdatedAt(t time.Time) {
	m.updated_at = &t
}

// UpdatedAt returns the value of the "updated_at" field in the mutation.
func (m *AlertMutation) UpdatedAt() (r time.Time, exists bool) {
	v := m.updated_at
	if v == nil {
		return
	}
	return *v, true
}

// OldUpdatedAt returns the old "updated_at" field's value of the Alert entity.
// If the Alert object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AlertMutation) OldUpdatedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldUpdatedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldUpdatedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldUpdatedAt: %w", err)
	}
	return oldValue.UpdatedAt, nil
}

// ResetUpdatedAt resets all changes to the "updated_at" field.
func (m *AlertMutation) ResetUpdatedAt() {
	m.updated_at = nil
}

// SetScenario sets the "scenario" field.
func (m *AlertMutation) SetScenario(s string) {
	m.scenario = &s
}

// Scenario returns the value of the "scenario" field in the mutation.
func (m *AlertMutation) Scenario() (r string, exists bool) {
	v := m.scenario
	if v == nil {
		return
	}
	return *v, true
}

// OldScenario returns the old "scenario" field's value of the Alert entity.
// If the Alert object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AlertMutation) OldScenario(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldScenario is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldScenario requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldScenario: %w", err)
	}
	return oldValue.Scenario, nil
}

// ResetScenario resets all changes to the "scenario" field.
func (m *AlertMutation) ResetScenario() {
	m.scenario = nil
}

// SetBucketId sets the "bucketId" field.
func (m *AlertMutation) SetBucketId(s string) {
	m.bucketId = &s
}

// BucketId returns the value of the "bucketId" field in the mutation.
func (m *AlertMutation) BucketId() (r string, exists bool) {
	v := m.bucketId
	if v == nil {
		return
	}
	return *v, true
}

// OldBucketId returns the old "bucketId" field's value of the Alert entity.
// If the Alert object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AlertMutation) OldBucketId(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldBucketId is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldBucketId requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldBucketId: %w", err)
	}
	return oldValue.BucketId, nil
}

// ClearBucketId clears the value of the "bucketId" field.
func (m *AlertMutation) ClearBucketId() {
	m.bucketId = nil
	m.clearedFields[alert.FieldBucketId] = struct{}{}
}

// BucketIdCleared returns if the "bucketId" field was cleared in this mutation.
func (m *AlertMutation) BucketIdCleared() bool {
	_, ok := m.clearedFields[alert.FieldBucketId]
	return ok
}

// ResetBucketId resets all changes to the "bucketId" field.
func (m *AlertMutation) ResetBucketId() {
	m.bucketId = nil
	delete(m.clearedFields, alert.FieldBucketId)
}

// SetMessage sets the "message" field.
func (m *AlertMutation) SetMessage(s string) {
	m.message = &s
}

// Message returns the value of the "message" field in the mutation.
func (m *AlertMutation) Message() (r string, exists bool) {
	v := m.message
	if v == nil {
		return
	}
	return *v, true
}

// OldMessage returns the old "message" field's value of the Alert entity.
// If the Alert object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AlertMutation) OldMessage(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldMessage is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldMessage requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldMessage: %w", err)
	}
	return oldValue.Message, nil
}

// ClearMessage clears the value of the "message" field.
func (m *AlertMutation) ClearMessage() {
	m.message = nil
	m.clearedFields[alert.FieldMessage] = struct{}{}
}

// MessageCleared returns if the "message" field was cleared in this mutation.
func (m *AlertMutation) MessageCleared() bool {
	_, ok := m.clearedFields[alert.FieldMessage]
	return ok
}

// ResetMessage resets all changes to the "message" field.
func (m *AlertMutation) ResetMessage() {
	m.message = nil
	delete(m.clearedFields, alert.FieldMessage)
}

// SetEventsCount sets the "eventsCount" field.
func (m *AlertMutation) SetEventsCount(i int32) {
	m.eventsCount = &i
	m.addeventsCount = nil
}

// EventsCount returns the value of the "eventsCount" field in the mutation.
func (m *AlertMutation) EventsCount() (r int32, exists bool) {
	v := m.eventsCount
	if v == nil {
		return
	}
	return *v, true
}

// OldEventsCount returns the old "eventsCount" field's value of the Alert entity.
// If the Alert object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AlertMutation) OldEventsCount(ctx context.Context) (v int32, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldEventsCount is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldEventsCount requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldEventsCount: %w", err)
	}
	return oldValue.EventsCount, nil
}

// AddEventsCount adds i to the "eventsCount" field.
func (m *AlertMutation) AddEventsCount(i int32) {
	if m.addeventsCount != nil {
		*m.addeventsCount += i
	} else {
		m.addeventsCount = &i
	}
}

// AddedEventsCount returns the value that was added to the "eventsCount" field in this mutation.
func (m *AlertMutation) AddedEventsCount() (r int32, exists bool) {
	v := m.addeventsCount
	if v == nil {
		return
	}
	return *v, true
}

// ClearEventsCount clears the value of the "eventsCount" field.
func (m *AlertMutation) ClearEventsCount() {
	m.eventsCount = nil
	m.addeventsCount = nil
	m.clearedFields[alert.FieldEventsCount] = struct{}{}
}

// EventsCountCleared returns if the "eventsCount" field was cleared in this mutation.
func (m *AlertMutation) EventsCountCleared() bool {
	_, ok := m.clearedFields[alert.FieldEventsCount]
	return ok
}

// ResetEventsCount resets all changes to the "eventsCount" field.
func (m *AlertMutation) ResetEventsCount() {
	m.eventsCount = nil
	m.addeventsCount = nil
	delete(m.clearedFields, alert.FieldEventsCount)
}

// SetStartedAt sets the "startedAt" field.
func (m *AlertMutation) SetStartedAt(t time.Time) {
	m.startedAt = &t
}

// StartedAt returns the value of the "startedAt" field in the mutation.
func (m *AlertMutation) StartedAt() (r time.Time, exists bool) {
	v := m.startedAt
	if v == nil {
		return
	}
	return *v, true
}

// OldStartedAt returns the old "startedAt" field's value of the Alert entity.
// If the Alert object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AlertMutation) OldStartedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldStartedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldStartedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldStartedAt: %w", err)
	}
	return oldValue.StartedAt, nil
}

// ClearStartedAt clears the value of the "startedAt" field.
func (m *AlertMutation) ClearStartedAt() {
	m.startedAt = nil
	m.clearedFields[alert.FieldStartedAt] = struct{}{}
}

// StartedAtCleared returns if the "startedAt" field was cleared in this mutation.
func (m *AlertMutation) StartedAtCleared() bool {
	_, ok := m.clearedFields[alert.FieldStartedAt]
	return ok
}

// ResetStartedAt resets all changes to the "startedAt" field.
func (m *AlertMutation) ResetStartedAt() {
	m.startedAt = nil
	delete(m.clearedFields, alert.FieldStartedAt)
}

// SetStoppedAt sets the "stoppedAt" field.
func (m *AlertMutation) SetStoppedAt(t time.Time) {
	m.stoppedAt = &t
}

// StoppedAt returns the value of the "stoppedAt" field in the mutation.
func (m *AlertMutation) StoppedAt() (r time.Time, exists bool) {
	v := m.stoppedAt
	if v == nil {
		return
	}
	return *v, true
}

// OldStoppedAt returns the old "stoppedAt" field's value of the Alert entity.
// If the Alert object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AlertMutation) OldStoppedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldStoppedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldStoppedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldStoppedAt: %w", err)
	}
	return oldValue.StoppedAt, nil
}

// ClearStoppedAt clears the value of the "stoppedAt" field.
func (m *AlertMutation) ClearStoppedAt() {
	m.stoppedAt = nil
	m.clearedFields[alert.FieldStoppedAt] = struct{}{}
}

// StoppedAtCleared returns if the "stoppedAt" field was cleared in this mutation.
func (m *AlertMutation) StoppedAtCleared() bool {
	_, ok := m.clearedFields[alert.FieldStoppedAt]
	return ok
}

// ResetStoppedAt resets all changes to the "stoppedAt" field.
func (m *AlertMutation) ResetStoppedAt() {
	m.stoppedAt = nil
	delete(m.clearedFields, alert.FieldStoppedAt)
}

// SetSourceIp sets the "sourceIp" field.
func (m *AlertMutation) SetSourceIp(s string) {
	m.sourceIp = &s
}

// SourceIp returns the value of the "sourceIp" field in the mutation.
func (m *AlertMutation) SourceIp() (r string, exists bool) {
	v := m.sourceIp
	if v == nil {
		return
	}
	return *v, true
}

// OldSourceIp returns the old "sourceIp" field's value of the Alert entity.
// If the Alert object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AlertMutation) OldSourceIp(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldSourceIp is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldSourceIp requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldSourceIp: %w", err)
	}
	return oldValue.SourceIp, nil
}

// ClearSourceIp clears the value of the "sourceIp" field.
func (m *AlertMutation) ClearSourceIp() {
	m.sourceIp = nil
	m.clearedFields[alert.FieldSourceIp] = struct{}{}
}

// SourceIpCleared returns if the "sourceIp" field was cleared in this mutation.
func (m *AlertMutation) SourceIpCleared() bool {
	_, ok := m.clearedFields[alert.FieldSourceIp]
	return ok
}

// ResetSourceIp resets all changes to the "sourceIp" field.
func (m *AlertMutation) ResetSourceIp() {
	m.sourceIp = nil
	delete(m.clearedFields, alert.FieldSourceIp)
}

// SetSourceRange sets the "sourceRange" field.
func (m *AlertMutation) SetSourceRange(s string) {
	m.sourceRange = &s
}

// SourceRange returns the value of the "sourceRange" field in the mutation.
func (m *AlertMutation) SourceRange() (r string, exists bool) {
	v := m.sourceRange
	if v == nil {
		return
	}
	return *v, true
}

// OldSourceRange returns the old "sourceRange" field's value of the Alert entity.
// If the Alert object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AlertMutation) OldSourceRange(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldSourceRange is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldSourceRange requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldSourceRange: %w", err)
	}
	return oldValue.SourceRange, nil
}

// ClearSourceRange clears the value of the "sourceRange" field.
func (m *AlertMutation) ClearSourceRange() {
	m.sourceRange = nil
	m.clearedFields[alert.FieldSourceRange] = struct{}{}
}

// SourceRangeCleared returns if the "sourceRange" field was cleared in this mutation.
func (m *AlertMutation) SourceRangeCleared() bool {
	_, ok := m.clearedFields[alert.FieldSourceRange]
	return ok
}

// ResetSourceRange resets all changes to the "sourceRange" field.
func (m *AlertMutation) ResetSourceRange() {
	m.sourceRange = nil
	delete(m.clearedFields, alert.FieldSourceRange)
}

// SetSourceAsNumber sets the "sourceAsNumber" field.
func (m *AlertMutation) SetSourceAsNumber(s string) {
	m.sourceAsNumber = &s
}

// SourceAsNumber returns the value of the "sourceAsNumber" field in the mutation.
func (m *AlertMutation) SourceAsNumber() (r string, exists bool) {
	v := m.sourceAsNumber
	if v == nil {
		return
	}
	return *v, true
}

// OldSourceAsNumber returns the old "sourceAsNumber" field's value of the Alert entity.
// If the Alert object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AlertMutation) OldSourceAsNumber(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldSourceAsNumber is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldSourceAsNumber requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldSourceAsNumber: %w", err)
	}
	return oldValue.SourceAsNumber, nil
}

// ClearSourceAsNumber clears the value of the "sourceAsNumber" field.
func (m *AlertMutation) ClearSourceAsNumber() {
	m.sourceAsNumber = nil
	m.clearedFields[alert.FieldSourceAsNumber] = struct{}{}
}

// SourceAsNumberCleared returns if the "sourceAsNumber" field was cleared in this mutation.
func (m *AlertMutation) SourceAsNumberCleared() bool {
	_, ok := m.clearedFields[alert.FieldSourceAsNumber]
	return ok
}

// ResetSourceAsNumber resets all changes to the "sourceAsNumber" field.
func (m *AlertMutation) ResetSourceAsNumber() {
	m.sourceAsNumber = nil
	delete(m.clearedFields, alert.FieldSourceAsNumber)
}

// SetSourceAsName sets the "sourceAsName" field.
func (m *AlertMutation) SetSourceAsName(s string) {
	m.sourceAsName = &s
}

// SourceAsName returns the value of the "sourceAsName" field in the mutation.
func (m *AlertMutation) SourceAsName() (r string, exists bool) {
	v := m.sourceAsName
	if v == nil {
		return
	}
	return *v, true
}

// OldSourceAsName returns the old "sourceAsName" field's value of the Alert entity.
// If the Alert object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AlertMutation) OldSourceAsName(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldSourceAsName is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldSourceAsName requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldSourceAsName: %w", err)
	}
	return oldValue.SourceAsName, nil
}

// ClearSourceAsName clears the value of the "sourceAsName" field.
func (m *AlertMutation) ClearSourceAsName() {
	m.sourceAsName = nil
	m.clearedFields[alert.FieldSourceAsName] = struct{}{}
}

// SourceAsNameCleared returns if the "sourceAsName" field was cleared in this mutation.
func (m *AlertMutation) SourceAsNameCleared() bool {
	_, ok := m.clearedFields[alert.FieldSourceAsName]
	return ok
}

// ResetSourceAsName resets all changes to the "sourceAsName" field.
func (m *AlertMutation) ResetSourceAsName() {
	m.sourceAsName = nil
	delete(m.clearedFields, alert.FieldSourceAsName)
}

// SetSourceCountry sets the "sourceCountry" field.
func (m *AlertMutation) SetSourceCountry(s string) {
	m.sourceCountry = &s
}

// SourceCountry returns the value of the "sourceCountry" field in the mutation.
func (m *AlertMutation) SourceCountry() (r string, exists bool) {
	v := m.sourceCountry
	if v == nil {
		return
	}
	return *v, true
}

// OldSourceCountry returns the old "sourceCountry" field's value of the Alert entity.
// If the Alert object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AlertMutation) OldSourceCountry(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldSourceCountry is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldSourceCountry requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldSourceCountry: %w", err)
	}
	return oldValue.SourceCountry, nil
}

// ClearSourceCountry clears the value of the "sourceCountry" field.
func (m *AlertMutation) ClearSourceCountry() {
	m.sourceCountry = nil
	m.clearedFields[alert.FieldSourceCountry] = struct{}{}
}

// SourceCountryCleared returns if the "sourceCountry" field was cleared in this mutation.
func (m *AlertMutation) SourceCountryCleared() bool {
	_, ok := m.clearedFields[alert.FieldSourceCountry]
	return ok
}

// ResetSourceCountry resets all changes to the "sourceCountry" field.
func (m *AlertMutation) ResetSourceCountry() {
	m.sourceCountry = nil
	delete(m.clearedFields, alert.FieldSourceCountry)
}

// SetSourceLatitude sets the "sourceLatitude" field.
func (m *AlertMutation) SetSourceLatitude(f float32) {
	m.sourceLatitude = &f
	m.addsourceLatitude = nil
}

// SourceLatitude returns the value of the "sourceLatitude" field in the mutation.
func (m *AlertMutation) SourceLatitude() (r float32, exists bool) {
	v := m.sourceLatitude
	if v == nil {
		return
	}
	return *v, true
}

// OldSourceLatitude returns the old "sourceLatitude" field's value of the Alert entity.
// If the Alert object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AlertMutation) OldSourceLatitude(ctx context.Context) (v float32, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldSourceLatitude is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldSourceLatitude requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldSourceLatitude: %w", err)
	}
	return oldValue.SourceLatitude, nil
}

// AddSourceLatitude adds f to the "sourceLatitude" field.
func (m *AlertMutation) AddSourceLatitude(f float32) {
	if m.addsourceLatitude != nil {
		*m.addsourceLatitude += f
	} else {
		m.addsourceLatitude = &f
	}
}

// AddedSourceLatitude returns the value that was added to the "sourceLatitude" field in this mutation.
func (m *AlertMutation) AddedSourceLatitude() (r float32, exists bool) {
	v := m.addsourceLatitude
	if v == nil {
		return
	}
	return *v, true
}

// ClearSourceLatitude clears the value of the "sourceLatitude" field.
func (m *AlertMutation) ClearSourceLatitude() {
	m.sourceLatitude = nil
	m.addsourceLatitude = nil
	m.clearedFields[alert.FieldSourceLatitude] = struct{}{}
}

// SourceLatitudeCleared returns if the "sourceLatitude" field was cleared in this mutation.
func (m *AlertMutation) SourceLatitudeCleared() bool {
	_, ok := m.clearedFields[alert.FieldSourceLatitude]
	return ok
}

// ResetSourceLatitude resets all changes to the "sourceLatitude" field.
func (m *AlertMutation) ResetSourceLatitude() {
	m.sourceLatitude = nil
	m.addsourceLatitude = nil
	delete(m.clearedFields, alert.FieldSourceLatitude)
}

// SetSourceLongitude sets the "sourceLongitude" field.
func (m *AlertMutation) SetSourceLongitude(f float32) {
	m.sourceLongitude = &f
	m.addsourceLongitude = nil
}

// SourceLongitude returns the value of the "sourceLongitude" field in the mutation.
func (m *AlertMutation) SourceLongitude() (r float32, exists bool) {
	v := m.sourceLongitude
	if v == nil {
		return
	}
	return *v, true
}

// OldSourceLongitude returns the old "sourceLongitude" field's value of the Alert entity.
// If the Alert object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AlertMutation) OldSourceLongitude(ctx context.Context) (v float32, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldSourceLongitude is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldSourceLongitude requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldSourceLongitude: %w", err)
	}
	return oldValue.SourceLongitude, nil
}

// AddSourceLongitude adds f to the "sourceLongitude" field.
func (m *AlertMutation) AddSourceLongitude(f float32) {
	if m.addsourceLongitude != nil {
		*m.addsourceLongitude += f
	} else {
		m.addsourceLongitude = &f
	}
}

// AddedSourceLongitude returns the value that was added to the "sourceLongitude" field in this mutation.
func (m *AlertMutation) AddedSourceLongitude() (r float32, exists bool) {
	v := m.addsourceLongitude
	if v == nil {
		return
	}
	return *v, true
}

// ClearSourceLongitude clears the value of the "sourceLongitude" field.
func (m *AlertMutation) ClearSourceLongitude() {
	m.sourceLongitude = nil
	m.addsourceLongitude = nil
	m.clearedFields[alert.FieldSourceLongitude] = struct{}{}
}

// SourceLongitudeCleared returns if the "sourceLongitude" field was cleared in this mutation.
func (m *AlertMutation) SourceLongitudeCleared() bool {
	_, ok := m.clearedFields[alert.FieldSourceLongitude]
	return ok
}

// ResetSourceLongitude resets all changes to the "sourceLongitude" field.
func (m *AlertMutation) ResetSourceLongitude() {
	m.sourceLongitude = nil
	m.addsourceLongitude = nil
	delete(m.clearedFields, alert.FieldSourceLongitude)
}

// SetSourceScope sets the "sourceScope" field.
func (m *AlertMutation) SetSourceScope(s string) {
	m.sourceScope = &s
}

// SourceScope returns the value of the "sourceScope" field in the mutation.
func (m *AlertMutation) SourceScope() (r string, exists bool) {
	v := m.sourceScope
	if v == nil {
		return
	}
	return *v, true
}

// OldSourceScope returns the old "sourceScope" field's value of the Alert entity.
// If the Alert object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AlertMutation) OldSourceScope(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldSourceScope is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldSourceScope requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldSourceScope: %w", err)
	}
	return oldValue.SourceScope, nil
}

// ClearSourceScope clears the value of the "sourceScope" field.
func (m *AlertMutation) ClearSourceScope() {
	m.sourceScope = nil
	m.clearedFields[alert.FieldSourceScope] = struct{}{}
}

// SourceScopeCleared returns if the "sourceScope" field was cleared in this mutation.
func (m *AlertMutation) SourceScopeCleared() bool {
	_, ok := m.clearedFields[alert.FieldSourceScope]
	return ok
}

// ResetSourceScope resets all changes to the "sourceScope" field.
func (m *AlertMutation) ResetSourceScope() {
	m.sourceScope = nil
	delete(m.clearedFields, alert.FieldSourceScope)
}

// SetSourceValue sets the "sourceValue" field.
func (m *AlertMutation) SetSourceValue(s string) {
	m.sourceValue = &s
}

// SourceValue returns the value of the "sourceValue" field in the mutation.
func (m *AlertMutation) SourceValue() (r string, exists bool) {
	v := m.sourceValue
	if v == nil {
		return
	}
	return *v, true
}

// OldSourceValue returns the old "sourceValue" field's value of the Alert entity.
// If the Alert object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AlertMutation) OldSourceValue(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldSourceValue is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldSourceValue requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldSourceValue: %w", err)
	}
	return oldValue.SourceValue, nil
}

// ClearSourceValue clears the value of the "sourceValue" field.
func (m *AlertMutation) ClearSourceValue() {
	m.sourceValue = nil
	m.clearedFields[alert.FieldSourceValue] = struct{}{}
}

// SourceValueCleared returns if the "sourceValue" field was cleared in this mutation.
func (m *AlertMutation) SourceValueCleared() bool {
	_, ok := m.clearedFields[alert.FieldSourceValue]
	return ok
}

// ResetSourceValue resets all changes to the "sourceValue" field.
func (m *AlertMutation) ResetSourceValue() {
	m.sourceValue = nil
	delete(m.clearedFields, alert.FieldSourceValue)
}

// SetCapacity sets the "capacity" field.
func (m *AlertMutation) SetCapacity(i int32) {
	m.capacity = &i
	m.addcapacity = nil
}

// Capacity returns the value of the "capacity" field in the mutation.
func (m *AlertMutation) Capacity() (r int32, exists bool) {
	v := m.capacity
	if v == nil {
		return
	}
	return *v, true
}

// OldCapacity returns the old "capacity" field's value of the Alert entity.
// If the Alert object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AlertMutation) OldCapacity(ctx context.Context) (v int32, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldCapacity is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldCapacity requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldCapacity: %w", err)
	}
	return oldValue.Capacity, nil
}

// AddCapacity adds i to the "capacity" field.
func (m *AlertMutation) AddCapacity(i int32) {
	if m.addcapacity != nil {
		*m.addcapacity += i
	} else {
		m.addcapacity = &i
	}
}

// AddedCapacity returns the value that was added to the "capacity" field in this mutation.
func (m *AlertMutation) AddedCapacity() (r int32, exists bool) {
	v := m.addcapacity
	if v == nil {
		return
	}
	return *v, true
}

// ClearCapacity clears the value of the "capacity" field.
func (m *AlertMutation) ClearCapacity() {
	m.capacity = nil
	m.addcapacity = nil
	m.clearedFields[alert.FieldCapacity] = struct{}{}
}

// CapacityCleared returns if the "capacity" field was cleared in this mutation.
func (m *AlertMutation) CapacityCleared() bool {
	_, ok := m.clearedFields[alert.FieldCapacity]
	return ok
}

// ResetCapacity resets all changes to the "capacity" field.
func (m *AlertMutation) ResetCapacity() {
	m.capacity = nil
	m.addcapacity = nil
	delete(m.clearedFields, alert.FieldCapacity)
}

// SetLeakSpeed sets the "leakSpeed" field.
func (m *AlertMutation) SetLeakSpeed(s string) {
	m.leakSpeed = &s
}

// LeakSpeed returns the value of the "leakSpeed" field in the mutation.
func (m *AlertMutation) LeakSpeed() (r string, exists bool) {
	v := m.leakSpeed
	if v == nil {
		return
	}
	return *v, true
}

// OldLeakSpeed returns the old "leakSpeed" field's value of the Alert entity.
// If the Alert object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AlertMutation) OldLeakSpeed(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldLeakSpeed is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldLeakSpeed requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldLeakSpeed: %w", err)
	}
	return oldValue.LeakSpeed, nil
}

// ClearLeakSpeed clears the value of the "leakSpeed" field.
func (m *AlertMutation) ClearLeakSpeed() {
	m.leakSpeed = nil
	m.clearedFields[alert.FieldLeakSpeed] = struct{}{}
}

// LeakSpeedCleared returns if the "leakSpeed" field was cleared in this mutation.
func (m *AlertMutation) LeakSpeedCleared() bool {
	_, ok := m.clearedFields[alert.FieldLeakSpeed]
	return ok
}

// ResetLeakSpeed resets all changes to the "leakSpeed" field.
func (m *AlertMutation) ResetLeakSpeed() {
	m.leakSpeed = nil
	delete(m.clearedFields, alert.FieldLeakSpeed)
}

// SetScenarioVersion sets the "scenarioVersion" field.
func (m *AlertMutation) SetScenarioVersion(s string) {
	m.scenarioVersion = &s
}

// ScenarioVersion returns the value of the "scenarioVersion" field in the mutation.
func (m *AlertMutation) ScenarioVersion() (r string, exists bool) {
	v := m.scenarioVersion
	if v == nil {
		return
	}
	return *v, true
}

// OldScenarioVersion returns the old "scenarioVersion" field's value of the Alert entity.
// If the Alert object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AlertMutation) OldScenarioVersion(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldScenarioVersion is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldScenarioVersion requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldScenarioVersion: %w", err)
	}
	return oldValue.ScenarioVersion, nil
}

// ClearScenarioVersion clears the value of the "scenarioVersion" field.
func (m *AlertMutation) ClearScenarioVersion() {
	m.scenarioVersion = nil
	m.clearedFields[alert.FieldScenarioVersion] = struct{}{}
}

// ScenarioVersionCleared returns if the "scenarioVersion" field was cleared in this mutation.
func (m *AlertMutation) ScenarioVersionCleared() bool {
	_, ok := m.clearedFields[alert.FieldScenarioVersion]
	return ok
}

// ResetScenarioVersion resets all changes to the "scenarioVersion" field.
func (m *AlertMutation) ResetScenarioVersion() {
	m.scenarioVersion = nil
	delete(m.clearedFields, alert.FieldScenarioVersion)
}

// SetScenarioHash sets the "scenarioHash" field.
func (m *AlertMutation) SetScenarioHash(s string) {
	m.scenarioHash = &s
}

// ScenarioHash returns the value of the "scenarioHash" field in the mutation.
func (m *AlertMutation) ScenarioHash() (r string, exists bool) {
	v := m.scenarioHash
	if v == nil {
		return
	}
	return *v, true
}

// OldScenarioHash returns the old "scenarioHash" field's value of the Alert entity.
// If the Alert object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AlertMutation) OldScenarioHash(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldScenarioHash is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldScenarioHash requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldScenarioHash: %w", err)
	}
	return oldValue.ScenarioHash, nil
}

// ClearScenarioHash clears the value of the "scenarioHash" field.
func (m *AlertMutation) ClearScenarioHash() {
	m.scenarioHash = nil
	m.clearedFields[alert.FieldScenarioHash] = struct{}{}
}

// ScenarioHashCleared returns if the "scenarioHash" field was cleared in this mutation.
func (m *AlertMutation) ScenarioHashCleared() bool {
	_, ok := m.clearedFields[alert.FieldScenarioHash]
	return ok
}

// ResetScenarioHash resets all changes to the "scenarioHash" field.
func (m *AlertMutation) ResetScenarioHash() {
	m.scenarioHash = nil
	delete(m.clearedFields, alert.FieldScenarioHash)
}

// SetSimulated sets the "simulated" field.
func (m *AlertMutation) SetSimulated(b bool) {
	m.simulated = &b
}

// Simulated returns the value of the "simulated" field in the mutation.
func (m *AlertMutation) Simulated() (r bool, exists bool) {
	v := m.simulated
	if v == nil {
		return
	}
	return *v, true
}

// OldSimulated returns the old "simulated" field's value of the Alert entity.
// If the Alert object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AlertMutation) OldSimulated(ctx context.Context) (v bool, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldSimulated is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldSimulated requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldSimulated: %w", err)
	}
	return oldValue.Simulated, nil
}

// ResetSimulated resets all changes to the "simulated" field.
func (m *AlertMutation) ResetSimulated() {
	m.simulated = nil
}

// SetUUID sets the "uuid" field.
func (m *AlertMutation) SetUUID(s string) {
	m.uuid = &s
}

// UUID returns the value of the "uuid" field in the mutation.
func (m *AlertMutation) UUID() (r string, exists bool) {
	v := m.uuid
	if v == nil {
		return
	}
	return *v, true
}

// OldUUID returns the old "uuid" field's value of the Alert entity.
// If the Alert object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AlertMutation) OldUUID(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldUUID is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldUUID requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldUUID: %w", err)
	}
	return oldValue.UUID, nil
}

// ClearUUID clears the value of the "uuid" field.
func (m *AlertMutation) ClearUUID() {
	m.uuid = nil
	m.clearedFields[alert.FieldUUID] = struct{}{}
}

// UUIDCleared returns if the "uuid" field was cleared in this mutation.
func (m *AlertMutation) UUIDCleared() bool {
	_, ok := m.clearedFields[alert.FieldUUID]
	return ok
}

// ResetUUID resets all changes to the "uuid" field.
func (m *AlertMutation) ResetUUID() {
	m.uuid = nil
	delete(m.clearedFields, alert.FieldUUID)
}

// SetRemediation sets the "remediation" field.
func (m *AlertMutation) SetRemediation(b bool) {
	m.remediation = &b
}

// Remediation returns the value of the "remediation" field in the mutation.
func (m *AlertMutation) Remediation() (r bool, exists bool) {
	v := m.remediation
	if v == nil {
		return
	}
	return *v, true
}

// OldRemediation returns the old "remediation" field's value of the Alert entity.
// If the Alert object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AlertMutation) OldRemediation(ctx context.Context) (v bool, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldRemediation is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldRemediation requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldRemediation: %w", err)
	}
	return oldValue.Remediation, nil
}

// ClearRemediation clears the value of the "remediation" field.
func (m *AlertMutation) ClearRemediation() {
	m.remediation = nil
	m.clearedFields[alert.FieldRemediation] = struct{}{}
}

// RemediationCleared returns if the "remediation" field was cleared in this mutation.
func (m *AlertMutation) RemediationCleared() bool {
	_, ok := m.clearedFields[alert.FieldRemediation]
	return ok
}

// ResetRemediation resets all changes to the "remediation" field.
func (m *AlertMutation) ResetRemediation() {
	m.remediation = nil
	delete(m.clearedFields, alert.FieldRemediation)
}

// SetOwnerID sets the "owner" edge to the Machine entity by id.
func (m *AlertMutation) SetOwnerID(id int) {
	m.owner = &id
}

// ClearOwner clears the "owner" edge to the Machine entity.
func (m *AlertMutation) ClearOwner() {
	m.clearedowner = true
}

// OwnerCleared reports if the "owner" edge to the Machine entity was cleared.
func (m *AlertMutation) OwnerCleared() bool {
	return m.clearedowner
}

// OwnerID returns the "owner" edge ID in the mutation.
func (m *AlertMutation) OwnerID() (id int, exists bool) {
	if m.owner != nil {
		return *m.owner, true
	}
	return
}

// OwnerIDs returns the "owner" edge IDs in the mutation.
// Note that IDs always returns len(IDs) <= 1 for unique edges, and you should use
// OwnerID instead. It exists only for internal usage by the builders.
func (m *AlertMutation) OwnerIDs() (ids []int) {
	if id := m.owner; id != nil {
		ids = append(ids, *id)
	}
	return
}

// ResetOwner resets all changes to the "owner" edge.
func (m *AlertMutation) ResetOwner() {
	m.owner = nil
	m.clearedowner = false
}

// AddDecisionIDs adds the "decisions" edge to the Decision entity by ids.
func (m *AlertMutation) AddDecisionIDs(ids ...int) {
	if m.decisions == nil {
		m.decisions = make(map[int]struct{})
	}
	for i := range ids {
		m.decisions[ids[i]] = struct{}{}
	}
}

// ClearDecisions clears the "decisions" edge to the Decision entity.
func (m *AlertMutation) ClearDecisions() {
	m.cleareddecisions = true
}

// DecisionsCleared reports if the "decisions" edge to the Decision entity was cleared.
func (m *AlertMutation) DecisionsCleared() bool {
	return m.cleareddecisions
}

// RemoveDecisionIDs removes the "decisions" edge to the Decision entity by IDs.
func (m *AlertMutation) RemoveDecisionIDs(ids ...int) {
	if m.removeddecisions == nil {
		m.removeddecisions = make(map[int]struct{})
	}
	for i := range ids {
		delete(m.decisions, ids[i])
		m.removeddecisions[ids[i]] = struct{}{}
	}
}

// RemovedDecisions returns the removed IDs of the "decisions" edge to the Decision entity.
func (m *AlertMutation) RemovedDecisionsIDs() (ids []int) {
	for id := range m.removeddecisions {
		ids = append(ids, id)
	}
	return
}

// DecisionsIDs returns the "decisions" edge IDs in the mutation.
func (m *AlertMutation) DecisionsIDs() (ids []int) {
	for id := range m.decisions {
		ids = append(ids, id)
	}
	return
}

// ResetDecisions resets all changes to the "decisions" edge.
func (m *AlertMutation) ResetDecisions() {
	m.decisions = nil
	m.cleareddecisions = false
	m.removeddecisions = nil
}

// AddEventIDs adds the "events" edge to the Event entity by ids.
func (m *AlertMutation) AddEventIDs(ids ...int) {
	if m.events == nil {
		m.events = make(map[int]struct{})
	}
	for i := range ids {
		m.events[ids[i]] = struct{}{}
	}
}

// ClearEvents clears the "events" edge to the Event entity.
func (m *AlertMutation) ClearEvents() {
	m.clearedevents = true
}

// EventsCleared reports if the "events" edge to the Event entity was cleared.
func (m *AlertMutation) EventsCleared() bool {
	return m.clearedevents
}

// RemoveEventIDs removes the "events" edge to the Event entity by IDs.
func (m *AlertMutation) RemoveEventIDs(ids ...int) {
	if m.removedevents == nil {
		m.removedevents = make(map[int]struct{})
	}
	for i := range ids {
		delete(m.events, ids[i])
		m.removedevents[ids[i]] = struct{}{}
	}
}

// RemovedEvents returns the removed IDs of the "events" edge to the Event entity.
func (m *AlertMutation) RemovedEventsIDs() (ids []int) {
	for id := range m.removedevents {
		ids = append(ids, id)
	}
	return
}

// EventsIDs returns the "events" edge IDs in the mutation.
func (m *AlertMutation) EventsIDs() (ids []int) {
	for id := range m.events {
		ids = append(ids, id)
	}
	return
}

// ResetEvents resets all changes to the "events" edge.
func (m *AlertMutation) ResetEvents() {
	m.events = nil
	m.clearedevents = false
	m.removedevents = nil
}

// AddMetaIDs adds the "metas" edge to the Meta entity by ids.
func (m *AlertMutation) AddMetaIDs(ids ...int) {
	if m.metas == nil {
		m.metas = make(map[int]struct{})
	}
	for i := range ids {
		m.metas[ids[i]] = struct{}{}
	}
}

// ClearMetas clears the "metas" edge to the Meta entity.
func (m *AlertMutation) ClearMetas() {
	m.clearedmetas = true
}

// MetasCleared reports if the "metas" edge to the Meta entity was cleared.
func (m *AlertMutation) MetasCleared() bool {
	return m.clearedmetas
}

// RemoveMetaIDs removes the "metas" edge to the Meta entity by IDs.
func (m *AlertMutation) RemoveMetaIDs(ids ...int) {
	if m.removedmetas == nil {
		m.removedmetas = make(map[int]struct{})
	}
	for i := range ids {
		delete(m.metas, ids[i])
		m.removedmetas[ids[i]] = struct{}{}
	}
}

// RemovedMetas returns the removed IDs of the "metas" edge to the Meta entity.
func (m *AlertMutation) RemovedMetasIDs() (ids []int) {
	for id := range m.removedmetas {
		ids = append(ids, id)
	}
	return
}

// MetasIDs returns the "metas" edge IDs in the mutation.
func (m *AlertMutation) MetasIDs() (ids []int) {
	for id := range m.metas {
		ids = append(ids, id)
	}
	return
}

// ResetMetas resets all changes to the "metas" edge.
func (m *AlertMutation) ResetMetas() {
	m.metas = nil
	m.clearedmetas = false
	m.removedmetas = nil
}

// Where appends a list predicates to the AlertMutation builder.
func (m *AlertMutation) Where(ps ...predicate.Alert) {
	m.predicates = append(m.predicates, ps...)
}

// WhereP appends storage-level predicates to the AlertMutation builder. Using this method,
// users can use type-assertion to append predicates that do not depend on any generated package.
func (m *AlertMutation) WhereP(ps ...func(*sql.Selector)) {
	p := make([]predicate.Alert, len(ps))
	for i := range ps {
		p[i] = ps[i]
	}
	m.Where(p...)
}

// Op returns the operation name.
func (m *AlertMutation) Op() Op {
	return m.op
}

// SetOp allows setting the mutation operation.
func (m *AlertMutation) SetOp(op Op) {
	m.op = op
}

// Type returns the node type of this mutation (Alert).
func (m *AlertMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *AlertMutation) Fields() []string {
	fields := make([]string, 0, 24)
	if m.created_at != nil {
		fields = append(fields, alert.FieldCreatedAt)
	}
	if m.updated_at != nil {
		fields = append(fields, alert.FieldUpdatedAt)
	}
	if m.scenario != nil {
		fields = append(fields, alert.FieldScenario)
	}
	if m.bucketId != nil {
		fields = append(fields, alert.FieldBucketId)
	}
	if m.message != nil {
		fields = append(fields, alert.FieldMessage)
	}
	if m.eventsCount != nil {
		fields = append(fields, alert.FieldEventsCount)
	}
	if m.startedAt != nil {
		fields = append(fields, alert.FieldStartedAt)
	}
	if m.stoppedAt != nil {
		fields = append(fields, alert.FieldStoppedAt)
	}
	if m.sourceIp != nil {
		fields = append(fields, alert.FieldSourceIp)
	}
	if m.sourceRange != nil {
		fields = append(fields, alert.FieldSourceRange)
	}
	if m.sourceAsNumber != nil {
		fields = append(fields, alert.FieldSourceAsNumber)
	}
	if m.sourceAsName != nil {
		fields = append(fields, alert.FieldSourceAsName)
	}
	if m.sourceCountry != nil {
		fields = append(fields, alert.FieldSourceCountry)
	}
	if m.sourceLatitude != nil {
		fields = append(fields, alert.FieldSourceLatitude)
	}
	if m.sourceLongitude != nil {
		fields = append(fields, alert.FieldSourceLongitude)
	}
	if m.sourceScope != nil {
		fields = append(fields, alert.FieldSourceScope)
	}
	if m.sourceValue != nil {
		fields = append(fields, alert.FieldSourceValue)
	}
	if m.capacity != nil {
		fields = append(fields, alert.FieldCapacity)
	}
	if m.leakSpeed != nil {
		fields = append(fields, alert.FieldLeakSpeed)
	}
	if m.scenarioVersion != nil {
		fields = append(fields, alert.FieldScenarioVersion)
	}
	if m.scenarioHash != nil {
		fields = append(fields, alert.FieldScenarioHash)
	}
	if m.simulated != nil {
		fields = append(fields, alert.FieldSimulated)
	}
	if m.uuid != nil {
		fields = append(fields, alert.FieldUUID)
	}
	if m.remediation != nil {
		fields = append(fields, alert.FieldRemediation)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *AlertMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case alert.FieldCreatedAt:
		return m.CreatedAt()
	case alert.FieldUpdatedAt:
		return m.UpdatedAt()
	case alert.FieldScenario:
		return m.Scenario()
	case alert.FieldBucketId:
		return m.BucketId()
	case alert.FieldMessage:
		return m.Message()
	case alert.FieldEventsCount:
		return m.EventsCount()
	case alert.FieldStartedAt:
		return m.StartedAt()
	case alert.FieldStoppedAt:
		return m.StoppedAt()
	case alert.FieldSourceIp:
		return m.SourceIp()
	case alert.FieldSourceRange:
		return m.SourceRange()
	case alert.FieldSourceAsNumber:
		return m.SourceAsNumber()
	case alert.FieldSourceAsName:
		return m.SourceAsName()
	case alert.FieldSourceCountry:
		return m.SourceCountry()
	case alert.FieldSourceLatitude:
		return m.SourceLatitude()
	case alert.FieldSourceLongitude:
		return m.SourceLongitude()
	case alert.FieldSourceScope:
		return m.SourceScope()
	case alert.FieldSourceValue:
		return m.SourceValue()
	case alert.FieldCapacity:
		return m.Capacity()
	case alert.FieldLeakSpeed:
		return m.LeakSpeed()
	case alert.FieldScenarioVersion:
		return m.ScenarioVersion()
	case alert.FieldScenarioHash:
		return m.ScenarioHash()
	case alert.FieldSimulated:
		return m.Simulated()
	case alert.FieldUUID:
		return m.UUID()
	case alert.FieldRemediation:
		return m.Remediation()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *AlertMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case alert.FieldCreatedAt:
		return m.OldCreatedAt(ctx)
	case alert.FieldUpdatedAt:
		return m.OldUpdatedAt(ctx)
	case alert.FieldScenario:
		return m.OldScenario(ctx)
	case alert.FieldBucketId:
		return m.OldBucketId(ctx)
	case alert.FieldMessage:
		return m.OldMessage(ctx)
	case alert.FieldEventsCount:
		return m.OldEventsCount(ctx)
	case alert.FieldStartedAt:
		return m.OldStartedAt(ctx)
	case alert.FieldStoppedAt:
		return m.OldStoppedAt(ctx)
	case alert.FieldSourceIp:
		return m.OldSourceIp(ctx)
	case alert.FieldSourceRange:
		return m.OldSourceRange(ctx)
	case alert.FieldSourceAsNumber:
		return m.OldSourceAsNumber(ctx)
	case alert.FieldSourceAsName:
		return m.OldSourceAsName(ctx)
	case alert.FieldSourceCountry:
		return m.OldSourceCountry(ctx)
	case alert.FieldSourceLatitude:
		return m.OldSourceLatitude(ctx)
	case alert.FieldSourceLongitude:
		return m.OldSourceLongitude(ctx)
	case alert.FieldSourceScope:
		return m.OldSourceScope(ctx)
	case alert.FieldSourceValue:
		return m.OldSourceValue(ctx)
	case alert.FieldCapacity:
		return m.OldCapacity(ctx)
	case alert.FieldLeakSpeed:
		return m.OldLeakSpeed(ctx)
	case alert.FieldScenarioVersion:
		return m.OldScenarioVersion(ctx)
	case alert.FieldScenarioHash:
		return m.OldScenarioHash(ctx)
	case alert.FieldSimulated:
		return m.OldSimulated(ctx)
	case alert.FieldUUID:
		return m.OldUUID(ctx)
	case alert.FieldRemediation:
		return m.OldRemediation(ctx)
	}
	return nil, fmt.Errorf("unknown Alert field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *AlertMutation) SetField(name string, value ent.Value) error {
	switch name {
	case alert.FieldCreatedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetCreatedAt(v)
		return nil
	case alert.FieldUpdatedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetUpdatedAt(v)
		return nil
	case alert.FieldScenario:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetScenario(v)
		return nil
	case alert.FieldBucketId:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetBucketId(v)
		return nil
	case alert.FieldMessage:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetMessage(v)
		return nil
	case alert.FieldEventsCount:
		v, ok := value.(int32)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetEventsCount(v)
		return nil
	case alert.FieldStartedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetStartedAt(v)
		return nil
	case alert.FieldStoppedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetStoppedAt(v)
		return nil
	case alert.FieldSourceIp:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetSourceIp(v)
		return nil
	case alert.FieldSourceRange:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetSourceRange(v)
		return nil
	case alert.FieldSourceAsNumber:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetSourceAsNumber(v)
		return nil
	case alert.FieldSourceAsName:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetSourceAsName(v)
		return nil
	case alert.FieldSourceCountry:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetSourceCountry(v)
		return nil
	case alert.FieldSourceLatitude:
		v, ok := value.(float32)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetSourceLatitude(v)
		return nil
	case alert.FieldSourceLongitude:
		v, ok := value.(float32)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetSourceLongitude(v)
		return nil
	case alert.FieldSourceScope:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetSourceScope(v)
		return nil
	case alert.FieldSourceValue:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetSourceValue(v)
		return nil
	case alert.FieldCapacity:
		v, ok := value.(int32)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetCapacity(v)
		return nil
	case alert.FieldLeakSpeed:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetLeakSpeed(v)
		return nil
	case alert.FieldScenarioVersion:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetScenarioVersion(v)
		return nil
	case alert.FieldScenarioHash:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetScenarioHash(v)
		return nil
	case alert.FieldSimulated:
		v, ok := value.(bool)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetSimulated(v)
		return nil
	case alert.FieldUUID:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetUUID(v)
		return nil
	case alert.FieldRemediation:
		v, ok := value.(bool)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetRemediation(v)
		return nil
	}
	return fmt.Errorf("unknown Alert field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *AlertMutation) AddedFields() []string {
	var fields []string
	if m.addeventsCount != nil {
		fields = append(fields, alert.FieldEventsCount)
	}
	if m.addsourceLatitude != nil {
		fields = append(fields, alert.FieldSourceLatitude)
	}
	if m.addsourceLongitude != nil {
		fields = append(fields, alert.FieldSourceLongitude)
	}
	if m.addcapacity != nil {
		fields = append(fields, alert.FieldCapacity)
	}
	return fields
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *AlertMutation) AddedField(name string) (ent.Value, bool) {
	switch name {
	case alert.FieldEventsCount:
		return m.AddedEventsCount()
	case alert.FieldSourceLatitude:
		return m.AddedSourceLatitude()
	case alert.FieldSourceLongitude:
		return m.AddedSourceLongitude()
	case alert.FieldCapacity:
		return m.AddedCapacity()
	}
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *AlertMutation) AddField(name string, value ent.Value) error {
	switch name {
	case alert.FieldEventsCount:
		v, ok := value.(int32)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.AddEventsCount(v)
		return nil
	case alert.FieldSourceLatitude:
		v, ok := value.(float32)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.AddSourceLatitude(v)
		return nil
	case alert.FieldSourceLongitude:
		v, ok := value.(float32)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.AddSourceLongitude(v)
		return nil
	case alert.FieldCapacity:
		v, ok := value.(int32)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.AddCapacity(v)
		return nil
	}
	return fmt.Errorf("unknown Alert numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *AlertMutation) ClearedFields() []string {
	var fields []string
	if m.FieldCleared(alert.FieldBucketId) {
		fields = append(fields, alert.FieldBucketId)
	}
	if m.FieldCleared(alert.FieldMessage) {
		fields = append(fields, alert.FieldMessage)
	}
	if m.FieldCleared(alert.FieldEventsCount) {
		fields = append(fields, alert.FieldEventsCount)
	}
	if m.FieldCleared(alert.FieldStartedAt) {
		fields = append(fields, alert.FieldStartedAt)
	}
	if m.FieldCleared(alert.FieldStoppedAt) {
		fields = append(fields, alert.FieldStoppedAt)
	}
	if m.FieldCleared(alert.FieldSourceIp) {
		fields = append(fields, alert.FieldSourceIp)
	}
	if m.FieldCleared(alert.FieldSourceRange) {
		fields = append(fields, alert.FieldSourceRange)
	}
	if m.FieldCleared(alert.FieldSourceAsNumber) {
		fields = append(fields, alert.FieldSourceAsNumber)
	}
	if m.FieldCleared(alert.FieldSourceAsName) {
		fields = append(fields, alert.FieldSourceAsName)
	}
	if m.FieldCleared(alert.FieldSourceCountry) {
		fields = append(fields, alert.FieldSourceCountry)
	}
	if m.FieldCleared(alert.FieldSourceLatitude) {
		fields = append(fields, alert.FieldSourceLatitude)
	}
	if m.FieldCleared(alert.FieldSourceLongitude) {
		fields = append(fields, alert.FieldSourceLongitude)
	}
	if m.FieldCleared(alert.FieldSourceScope) {
		fields = append(fields, alert.FieldSourceScope)
	}
	if m.FieldCleared(alert.FieldSourceValue) {
		fields = append(fields, alert.FieldSourceValue)
	}
	if m.FieldCleared(alert.FieldCapacity) {
		fields = append(fields, alert.FieldCapacity)
	}
	if m.FieldCleared(alert.FieldLeakSpeed) {
		fields = append(fields, alert.FieldLeakSpeed)
	}
	if m.FieldCleared(alert.FieldScenarioVersion) {
		fields = append(fields, alert.FieldScenarioVersion)
	}
	if m.FieldCleared(alert.FieldScenarioHash) {
		fields = append(fields, alert.FieldScenarioHash)
	}
	if m.FieldCleared(alert.FieldUUID) {
		fields = append(fields, alert.FieldUUID)
	}
	if m.FieldCleared(alert.FieldRemediation) {
		fields = append(fields, alert.FieldRemediation)
	}
	return fields
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *AlertMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *AlertMutation) ClearField(name string) error {
	switch name {
	case alert.FieldBucketId:
		m.ClearBucketId()
		return nil
	case alert.FieldMessage:
		m.ClearMessage()
		return nil
	case alert.FieldEventsCount:
		m.ClearEventsCount()
		return nil
	case alert.FieldStartedAt:
		m.ClearStartedAt()
		return nil
	case alert.FieldStoppedAt:
		m.ClearStoppedAt()
		return nil
	case alert.FieldSourceIp:
		m.ClearSourceIp()
		return nil
	case alert.FieldSourceRange:
		m.ClearSourceRange()
		return nil
	case alert.FieldSourceAsNumber:
		m.ClearSourceAsNumber()
		return nil
	case alert.FieldSourceAsName:
		m.ClearSourceAsName()
		return nil
	case alert.FieldSourceCountry:
		m.ClearSourceCountry()
		return nil
	case alert.FieldSourceLatitude:
		m.ClearSourceLatitude()
		return nil
	case alert.FieldSourceLongitude:
		m.ClearSourceLongitude()
		return nil
	case alert.FieldSourceScope:
		m.ClearSourceScope()
		return nil
	case alert.FieldSourceValue:
		m.ClearSourceValue()
		return nil
	case alert.FieldCapacity:
		m.ClearCapacity()
		return nil
	case alert.FieldLeakSpeed:
		m.ClearLeakSpeed()
		return nil
	case alert.FieldScenarioVersion:
		m.ClearScenarioVersion()
		return nil
	case alert.FieldScenarioHash:
		m.ClearScenarioHash()
		return nil
	case alert.FieldUUID:
		m.ClearUUID()
		return nil
	case alert.FieldRemediation:
		m.ClearRemediation()
		return nil
	}
	return fmt.Errorf("unknown Alert nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *AlertMutation) ResetField(name string) error {
	switch name {
	case alert.FieldCreatedAt:
		m.ResetCreatedAt()
		return nil
	case alert.FieldUpdatedAt:
		m.ResetUpdatedAt()
		return nil
	case alert.FieldScenario:
		m.ResetScenario()
		return nil
	case alert.FieldBucketId:
		m.ResetBucketId()
		return nil
	case alert.FieldMessage:
		m.ResetMessage()
		return nil
	case alert.FieldEventsCount:
		m.ResetEventsCount()
		return nil
	case alert.FieldStartedAt:
		m.ResetStartedAt()
		return nil
	case alert.FieldStoppedAt:
		m.ResetStoppedAt()
		return nil
	case alert.FieldSourceIp:
		m.ResetSourceIp()
		return nil
	case alert.FieldSourceRange:
		m.ResetSourceRange()
		return nil
	case alert.FieldSourceAsNumber:
		m.ResetSourceAsNumber()
		return nil
	case alert.FieldSourceAsName:
		m.ResetSourceAsName()
		return nil
	case alert.FieldSourceCountry:
		m.ResetSourceCountry()
		return nil
	case alert.FieldSourceLatitude:
		m.ResetSourceLatitude()
		return nil
	case alert.FieldSourceLongitude:
		m.ResetSourceLongitude()
		return nil
	case alert.FieldSourceScope:
		m.ResetSourceScope()
		return nil
	case alert.FieldSourceValue:
		m.ResetSourceValue()
		return nil
	case alert.FieldCapacity:
		m.ResetCapacity()
		return nil
	case alert.FieldLeakSpeed:
		m.ResetLeakSpeed()
		return nil
	case alert.FieldScenarioVersion:
		m.ResetScenarioVersion()
		return nil
	case alert.FieldScenarioHash:
		m.ResetScenarioHash()
		return nil
	case alert.FieldSimulated:
		m.ResetSimulated()
		return nil
	case alert.FieldUUID:
		m.ResetUUID()
		return nil
	case alert.FieldRemediation:
		m.ResetRemediation()
		return nil
	}
	return fmt.Errorf("unknown Alert field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *AlertMutation) AddedEdges() []string {
	edges := make([]string, 0, 4)
	if m.owner != nil {
		edges = append(edges, alert.EdgeOwner)
	}
	if m.decisions != nil {
		edges = append(edges, alert.EdgeDecisions)
	}
	if m.events != nil {
		edges = append(edges, alert.EdgeEvents)
	}
	if m.metas != nil {
		edges = append(edges, alert.EdgeMetas)
	}
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *AlertMutation) AddedIDs(name string) []ent.Value {
	switch name {
	case alert.EdgeOwner:
		if id := m.owner; id != nil {
			return []ent.Value{*id}
		}
	case alert.EdgeDecisions:
		ids := make([]ent.Value, 0, len(m.decisions))
		for id := range m.decisions {
			ids = append(ids, id)
		}
		return ids
	case alert.EdgeEvents:
		ids := make([]ent.Value, 0, len(m.events))
		for id := range m.events {
			ids = append(ids, id)
		}
		return ids
	case alert.EdgeMetas:
		ids := make([]ent.Value, 0, len(m.metas))
		for id := range m.metas {
			ids = append(ids, id)
		}
		return ids
	}
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *AlertMutation) RemovedEdges() []string {
	edges := make([]string, 0, 4)
	if m.removeddecisions != nil {
		edges = append(edges, alert.EdgeDecisions)
	}
	if m.removedevents != nil {
		edges = append(edges, alert.EdgeEvents)
	}
	if m.removedmetas != nil {
		edges = append(edges, alert.EdgeMetas)
	}
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *AlertMutation) RemovedIDs(name string) []ent.Value {
	switch name {
	case alert.EdgeDecisions:
		ids := make([]ent.Value, 0, len(m.removeddecisions))
		for id := range m.removeddecisions {
			ids = append(ids, id)
		}
		return ids
	case alert.EdgeEvents:
		ids := make([]ent.Value, 0, len(m.removedevents))
		for id := range m.removedevents {
			ids = append(ids, id)
		}
		return ids
	case alert.EdgeMetas:
		ids := make([]ent.Value, 0, len(m.removedmetas))
		for id := range m.removedmetas {
			ids = append(ids, id)
		}
		return ids
	}
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *AlertMutation) ClearedEdges() []string {
	edges := make([]string, 0, 4)
	if m.clearedowner {
		edges = append(edges, alert.EdgeOwner)
	}
	if m.cleareddecisions {
		edges = append(edges, alert.EdgeDecisions)
	}
	if m.clearedevents {
		edges = append(edges, alert.EdgeEvents)
	}
	if m.clearedmetas {
		edges = append(edges, alert.EdgeMetas)
	}
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *AlertMutation) EdgeCleared(name string) bool {
	switch name {
	case alert.EdgeOwner:
		return m.clearedowner
	case alert.EdgeDecisions:
		return m.cleareddecisions
	case alert.EdgeEvents:
		return m.clearedevents
	case alert.EdgeMetas:
		return m.clearedmetas
	}
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *AlertMutation) ClearEdge(name string) error {
	switch name {
	case alert.EdgeOwner:
		m.ClearOwner()
		return nil
	}
	return fmt.Errorf("unknown Alert unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *AlertMutation) ResetEdge(name string) error {
	switch name {
	case alert.EdgeOwner:
		m.ResetOwner()
		return nil
	case alert.EdgeDecisions:
		m.ResetDecisions()
		return nil
	case alert.EdgeEvents:
		m.ResetEvents()
		return nil
	case alert.EdgeMetas:
		m.ResetMetas()
		return nil
	}
	return fmt.Errorf("unknown Alert edge %s", name)
}

// AllowListMutation represents an operation that mutates the AllowList nodes in the graph.
type AllowListMutation struct {
	config
	op                     Op
	typ                    string
	id                     *int
	created_at             *time.Time
	updated_at             *time.Time
	name                   *string
	from_console           *bool
	description            *string
	allowlist_id           *string
	clearedFields          map[string]struct{}
	allowlist_items        map[int]struct{}
	removedallowlist_items map[int]struct{}
	clearedallowlist_items bool
	done                   bool
	oldValue               func(context.Context) (*AllowList, error)
	predicates             []predicate.AllowList
}

var _ ent.Mutation = (*AllowListMutation)(nil)

// allowlistOption allows management of the mutation configuration using functional options.
type allowlistOption func(*AllowListMutation)

// newAllowListMutation creates new mutation for the AllowList entity.
func newAllowListMutation(c config, op Op, opts ...allowlistOption) *AllowListMutation {
	m := &AllowListMutation{
		config:        c,
		op:            op,
		typ:           TypeAllowList,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withAllowListID sets the ID field of the mutation.
func withAllowListID(id int) allowlistOption {
	return func(m *AllowListMutation) {
		var (
			err   error
			once  sync.Once
			value *AllowList
		)
		m.oldValue = func(ctx context.Context) (*AllowList, error) {
			once.Do(func() {
				if m.done {
					err = errors.New("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().AllowList.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withAllowList sets the old AllowList of the mutation.
func withAllowList(node *AllowList) allowlistOption {
	return func(m *AllowListMutation) {
		m.oldValue = func(context.Context) (*AllowList, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m AllowListMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m AllowListMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, errors.New("ent: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *AllowListMutation) ID() (id int, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// IDs queries the database and returns the entity ids that match the mutation's predicate.
// That means, if the mutation is applied within a transaction with an isolation level such
// as sql.LevelSerializable, the returned ids match the ids of the rows that will be updated
// or updated by the mutation.
func (m *AllowListMutation) IDs(ctx context.Context) ([]int, error) {
	switch {
	case m.op.Is(OpUpdateOne | OpDeleteOne):
		id, exists := m.ID()
		if exists {
			return []int{id}, nil
		}
		fallthrough
	case m.op.Is(OpUpdate | OpDelete):
		return m.Client().AllowList.Query().Where(m.predicates...).IDs(ctx)
	default:
		return nil, fmt.Errorf("IDs is not allowed on %s operations", m.op)
	}
}

// SetCreatedAt sets the "created_at" field.
func (m *AllowListMutation) SetCreatedAt(t time.Time) {
	m.created_at = &t
}

// CreatedAt returns the value of the "created_at" field in the mutation.
func (m *AllowListMutation) CreatedAt() (r time.Time, exists bool) {
	v := m.created_at
	if v == nil {
		return
	}
	return *v, true
}

// OldCreatedAt returns the old "created_at" field's value of the AllowList entity.
// If the AllowList object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AllowListMutation) OldCreatedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldCreatedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldCreatedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldCreatedAt: %w", err)
	}
	return oldValue.CreatedAt, nil
}

// ResetCreatedAt resets all changes to the "created_at" field.
func (m *AllowListMutation) ResetCreatedAt() {
	m.created_at = nil
}

// SetUpdatedAt sets the "updated_at" field.
func (m *AllowListMutation) SetUpdatedAt(t time.Time) {
	m.updated_at = &t
}

// UpdatedAt returns the value of the "updated_at" field in the mutation.
func (m *AllowListMutation) UpdatedAt() (r time.Time, exists bool) {
	v := m.updated_at
	if v == nil {
		return
	}
	return *v, true
}

// OldUpdatedAt returns the old "updated_at" field's value of the AllowList entity.
// If the AllowList object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AllowListMutation) OldUpdatedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldUpdatedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldUpdatedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldUpdatedAt: %w", err)
	}
	return oldValue.UpdatedAt, nil
}

// ResetUpdatedAt resets all changes to the "updated_at" field.
func (m *AllowListMutation) ResetUpdatedAt() {
	m.updated_at = nil
}

// SetName sets the "name" field.
func (m *AllowListMutation) SetName(s string) {
	m.name = &s
}

// Name returns the value of the "name" field in the mutation.
func (m *AllowListMutation) Name() (r string, exists bool) {
	v := m.name
	if v == nil {
		return
	}
	return *v, true
}

// OldName returns the old "name" field's value of the AllowList entity.
// If the AllowList object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AllowListMutation) OldName(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldName is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldName requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldName: %w", err)
	}
	return oldValue.Name, nil
}

// ResetName resets all changes to the "name" field.
func (m *AllowListMutation) ResetName() {
	m.name = nil
}

// SetFromConsole sets the "from_console" field.
func (m *AllowListMutation) SetFromConsole(b bool) {
	m.from_console = &b
}

// FromConsole returns the value of the "from_console" field in the mutation.
func (m *AllowListMutation) FromConsole() (r bool, exists bool) {
	v := m.from_console
	if v == nil {
		return
	}
	return *v, true
}

// OldFromConsole returns the old "from_console" field's value of the AllowList entity.
// If the AllowList object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AllowListMutation) OldFromConsole(ctx context.Context) (v bool, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldFromConsole is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldFromConsole requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldFromConsole: %w", err)
	}
	return oldValue.FromConsole, nil
}

// ResetFromConsole resets all changes to the "from_console" field.
func (m *AllowListMutation) ResetFromConsole() {
	m.from_console = nil
}

// SetDescription sets the "description" field.
func (m *AllowListMutation) SetDescription(s string) {
	m.description = &s
}

// Description returns the value of the "description" field in the mutation.
func (m *AllowListMutation) Description() (r string, exists bool) {
	v := m.description
	if v == nil {
		return
	}
	return *v, true
}

// OldDescription returns the old "description" field's value of the AllowList entity.
// If the AllowList object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AllowListMutation) OldDescription(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldDescription is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldDescription requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldDescription: %w", err)
	}
	return oldValue.Description, nil
}

// ClearDescription clears the value of the "description" field.
func (m *AllowListMutation) ClearDescription() {
	m.description = nil
	m.clearedFields[allowlist.FieldDescription] = struct{}{}
}

// DescriptionCleared returns if the "description" field was cleared in this mutation.
func (m *AllowListMutation) DescriptionCleared() bool {
	_, ok := m.clearedFields[allowlist.FieldDescription]
	return ok
}

// ResetDescription resets all changes to the "description" field.
func (m *AllowListMutation) ResetDescription() {
	m.description = nil
	delete(m.clearedFields, allowlist.FieldDescription)
}

// SetAllowlistID sets the "allowlist_id" field.
func (m *AllowListMutation) SetAllowlistID(s string) {
	m.allowlist_id = &s
}

// AllowlistID returns the value of the "allowlist_id" field in the mutation.
func (m *AllowListMutation) AllowlistID() (r string, exists bool) {
	v := m.allowlist_id
	if v == nil {
		return
	}
	return *v, true
}

// OldAllowlistID returns the old "allowlist_id" field's value of the AllowList entity.
// If the AllowList object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AllowListMutation) OldAllowlistID(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldAllowlistID is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldAllowlistID requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldAllowlistID: %w", err)
	}
	return oldValue.AllowlistID, nil
}

// ClearAllowlistID clears the value of the "allowlist_id" field.
func (m *AllowListMutation) ClearAllowlistID() {
	m.allowlist_id = nil
	m.clearedFields[allowlist.FieldAllowlistID] = struct{}{}
}

// AllowlistIDCleared returns if the "allowlist_id" field was cleared in this mutation.
func (m *AllowListMutation) AllowlistIDCleared() bool {
	_, ok := m.clearedFields[allowlist.FieldAllowlistID]
	return ok
}

// ResetAllowlistID resets all changes to the "allowlist_id" field.
func (m *AllowListMutation) ResetAllowlistID() {
	m.allowlist_id = nil
	delete(m.clearedFields, allowlist.FieldAllowlistID)
}

// AddAllowlistItemIDs adds the "allowlist_items" edge to the AllowListItem entity by ids.
func (m *AllowListMutation) AddAllowlistItemIDs(ids ...int) {
	if m.allowlist_items == nil {
		m.allowlist_items = make(map[int]struct{})
	}
	for i := range ids {
		m.allowlist_items[ids[i]] = struct{}{}
	}
}

// ClearAllowlistItems clears the "allowlist_items" edge to the AllowListItem entity.
func (m *AllowListMutation) ClearAllowlistItems() {
	m.clearedallowlist_items = true
}

// AllowlistItemsCleared reports if the "allowlist_items" edge to the AllowListItem entity was cleared.
func (m *AllowListMutation) AllowlistItemsCleared() bool {
	return m.clearedallowlist_items
}

// RemoveAllowlistItemIDs removes the "allowlist_items" edge to the AllowListItem entity by IDs.
func (m *AllowListMutation) RemoveAllowlistItemIDs(ids ...int) {
	if m.removedallowlist_items == nil {
		m.removedallowlist_items = make(map[int]struct{})
	}
	for i := range ids {
		delete(m.allowlist_items, ids[i])
		m.removedallowlist_items[ids[i]] = struct{}{}
	}
}

// RemovedAllowlistItems returns the removed IDs of the "allowlist_items" edge to the AllowListItem entity.
func (m *AllowListMutation) RemovedAllowlistItemsIDs() (ids []int) {
	for id := range m.removedallowlist_items {
		ids = append(ids, id)
	}
	return
}

// AllowlistItemsIDs returns the "allowlist_items" edge IDs in the mutation.
func (m *AllowListMutation) AllowlistItemsIDs() (ids []int) {
	for id := range m.allowlist_items {
		ids = append(ids, id)
	}
	return
}

// ResetAllowlistItems resets all changes to the "allowlist_items" edge.
func (m *AllowListMutation) ResetAllowlistItems() {
	m.allowlist_items = nil
	m.clearedallowlist_items = false
	m.removedallowlist_items = nil
}

// Where appends a list predicates to the AllowListMutation builder.
func (m *AllowListMutation) Where(ps ...predicate.AllowList) {
	m.predicates = append(m.predicates, ps...)
}

// WhereP appends storage-level predicates to the AllowListMutation builder. Using this method,
// users can use type-assertion to append predicates that do not depend on any generated package.
func (m *AllowListMutation) WhereP(ps ...func(*sql.Selector)) {
	p := make([]predicate.AllowList, len(ps))
	for i := range ps {
		p[i] = ps[i]
	}
	m.Where(p...)
}

// Op returns the operation name.
func (m *AllowListMutation) Op() Op {
	return m.op
}

// SetOp allows setting the mutation operation.
func (m *AllowListMutation) SetOp(op Op) {
	m.op = op
}

// Type returns the node type of this mutation (AllowList).
func (m *AllowListMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *AllowListMutation) Fields() []string {
	fields := make([]string, 0, 6)
	if m.created_at != nil {
		fields = append(fields, allowlist.FieldCreatedAt)
	}
	if m.updated_at != nil {
		fields = append(fields, allowlist.FieldUpdatedAt)
	}
	if m.name != nil {
		fields = append(fields, allowlist.FieldName)
	}
	if m.from_console != nil {
		fields = append(fields, allowlist.FieldFromConsole)
	}
	if m.description != nil {
		fields = append(fields, allowlist.FieldDescription)
	}
	if m.allowlist_id != nil {
		fields = append(fields, allowlist.FieldAllowlistID)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *AllowListMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case allowlist.FieldCreatedAt:
		return m.CreatedAt()
	case allowlist.FieldUpdatedAt:
		return m.UpdatedAt()
	case allowlist.FieldName:
		return m.Name()
	case allowlist.FieldFromConsole:
		return m.FromConsole()
	case allowlist.FieldDescription:
		return m.Description()
	case allowlist.FieldAllowlistID:
		return m.AllowlistID()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *AllowListMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case allowlist.FieldCreatedAt:
		return m.OldCreatedAt(ctx)
	case allowlist.FieldUpdatedAt:
		return m.OldUpdatedAt(ctx)
	case allowlist.FieldName:
		return m.OldName(ctx)
	case allowlist.FieldFromConsole:
		return m.OldFromConsole(ctx)
	case allowlist.FieldDescription:
		return m.OldDescription(ctx)
	case allowlist.FieldAllowlistID:
		return m.OldAllowlistID(ctx)
	}
	return nil, fmt.Errorf("unknown AllowList field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *AllowListMutation) SetField(name string, value ent.Value) error {
	switch name {
	case allowlist.FieldCreatedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetCreatedAt(v)
		return nil
	case allowlist.FieldUpdatedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetUpdatedAt(v)
		return nil
	case allowlist.FieldName:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetName(v)
		return nil
	case allowlist.FieldFromConsole:
		v, ok := value.(bool)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetFromConsole(v)
		return nil
	case allowlist.FieldDescription:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetDescription(v)
		return nil
	case allowlist.FieldAllowlistID:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetAllowlistID(v)
		return nil
	}
	return fmt.Errorf("unknown AllowList field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *AllowListMutation) AddedFields() []string {
	return nil
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *AllowListMutation) AddedField(name string) (ent.Value, bool) {
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *AllowListMutation) AddField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown AllowList numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *AllowListMutation) ClearedFields() []string {
	var fields []string
	if m.FieldCleared(allowlist.FieldDescription) {
		fields = append(fields, allowlist.FieldDescription)
	}
	if m.FieldCleared(allowlist.FieldAllowlistID) {
		fields = append(fields, allowlist.FieldAllowlistID)
	}
	return fields
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *AllowListMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *AllowListMutation) ClearField(name string) error {
	switch name {
	case allowlist.FieldDescription:
		m.ClearDescription()
		return nil
	case allowlist.FieldAllowlistID:
		m.ClearAllowlistID()
		return nil
	}
	return fmt.Errorf("unknown AllowList nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *AllowListMutation) ResetField(name string) error {
	switch name {
	case allowlist.FieldCreatedAt:
		m.ResetCreatedAt()
		return nil
	case allowlist.FieldUpdatedAt:
		m.ResetUpdatedAt()
		return nil
	case allowlist.FieldName:
		m.ResetName()
		return nil
	case allowlist.FieldFromConsole:
		m.ResetFromConsole()
		return nil
	case allowlist.FieldDescription:
		m.ResetDescription()
		return nil
	case allowlist.FieldAllowlistID:
		m.ResetAllowlistID()
		return nil
	}
	return fmt.Errorf("unknown AllowList field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *AllowListMutation) AddedEdges() []string {
	edges := make([]string, 0, 1)
	if m.allowlist_items != nil {
		edges = append(edges, allowlist.EdgeAllowlistItems)
	}
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *AllowListMutation) AddedIDs(name string) []ent.Value {
	switch name {
	case allowlist.EdgeAllowlistItems:
		ids := make([]ent.Value, 0, len(m.allowlist_items))
		for id := range m.allowlist_items {
			ids = append(ids, id)
		}
		return ids
	}
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *AllowListMutation) RemovedEdges() []string {
	edges := make([]string, 0, 1)
	if m.removedallowlist_items != nil {
		edges = append(edges, allowlist.EdgeAllowlistItems)
	}
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *AllowListMutation) RemovedIDs(name string) []ent.Value {
	switch name {
	case allowlist.EdgeAllowlistItems:
		ids := make([]ent.Value, 0, len(m.removedallowlist_items))
		for id := range m.removedallowlist_items {
			ids = append(ids, id)
		}
		return ids
	}
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *AllowListMutation) ClearedEdges() []string {
	edges := make([]string, 0, 1)
	if m.clearedallowlist_items {
		edges = append(edges, allowlist.EdgeAllowlistItems)
	}
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *AllowListMutation) EdgeCleared(name string) bool {
	switch name {
	case allowlist.EdgeAllowlistItems:
		return m.clearedallowlist_items
	}
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *AllowListMutation) ClearEdge(name string) error {
	switch name {
	}
	return fmt.Errorf("unknown AllowList unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *AllowListMutation) ResetEdge(name string) error {
	switch name {
	case allowlist.EdgeAllowlistItems:
		m.ResetAllowlistItems()
		return nil
	}
	return fmt.Errorf("unknown AllowList edge %s", name)
}

// AllowListItemMutation represents an operation that mutates the AllowListItem nodes in the graph.
type AllowListItemMutation struct {
	config
	op               Op
	typ              string
	id               *int
	created_at       *time.Time
	updated_at       *time.Time
	expires_at       *time.Time
	comment          *string
	value            *string
	start_ip         *int64
	addstart_ip      *int64
	end_ip           *int64
	addend_ip        *int64
	start_suffix     *int64
	addstart_suffix  *int64
	end_suffix       *int64
	addend_suffix    *int64
	ip_size          *int64
	addip_size       *int64
	clearedFields    map[string]struct{}
	allowlist        map[int]struct{}
	removedallowlist map[int]struct{}
	clearedallowlist bool
	done             bool
	oldValue         func(context.Context) (*AllowListItem, error)
	predicates       []predicate.AllowListItem
}

var _ ent.Mutation = (*AllowListItemMutation)(nil)

// allowlistitemOption allows management of the mutation configuration using functional options.
type allowlistitemOption func(*AllowListItemMutation)

// newAllowListItemMutation creates new mutation for the AllowListItem entity.
func newAllowListItemMutation(c config, op Op, opts ...allowlistitemOption) *AllowListItemMutation {
	m := &AllowListItemMutation{
		config:        c,
		op:            op,
		typ:           TypeAllowListItem,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withAllowListItemID sets the ID field of the mutation.
func withAllowListItemID(id int) allowlistitemOption {
	return func(m *AllowListItemMutation) {
		var (
			err   error
			once  sync.Once
			value *AllowListItem
		)
		m.oldValue = func(ctx context.Context) (*AllowListItem, error) {
			once.Do(func() {
				if m.done {
					err = errors.New("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().AllowListItem.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withAllowListItem sets the old AllowListItem of the mutation.
func withAllowListItem(node *AllowListItem) allowlistitemOption {
	return func(m *AllowListItemMutation) {
		m.oldValue = func(context.Context) (*AllowListItem, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m AllowListItemMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m AllowListItemMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, errors.New("ent: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *AllowListItemMutation) ID() (id int, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// IDs queries the database and returns the entity ids that match the mutation's predicate.
// That means, if the mutation is applied within a transaction with an isolation level such
// as sql.LevelSerializable, the returned ids match the ids of the rows that will be updated
// or updated by the mutation.
func (m *AllowListItemMutation) IDs(ctx context.Context) ([]int, error) {
	switch {
	case m.op.Is(OpUpdateOne | OpDeleteOne):
		id, exists := m.ID()
		if exists {
			return []int{id}, nil
		}
		fallthrough
	case m.op.Is(OpUpdate | OpDelete):
		return m.Client().AllowListItem.Query().Where(m.predicates...).IDs(ctx)
	default:
		return nil, fmt.Errorf("IDs is not allowed on %s operations", m.op)
	}
}

// SetCreatedAt sets the "created_at" field.
func (m *AllowListItemMutation) SetCreatedAt(t time.Time) {
	m.created_at = &t
}

// CreatedAt returns the value of the "created_at" field in the mutation.
func (m *AllowListItemMutation) CreatedAt() (r time.Time, exists bool) {
	v := m.created_at
	if v == nil {
		return
	}
	return *v, true
}

// OldCreatedAt returns the old "created_at" field's value of the AllowListItem entity.
// If the AllowListItem object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AllowListItemMutation) OldCreatedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldCreatedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldCreatedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldCreatedAt: %w", err)
	}
	return oldValue.CreatedAt, nil
}

// ResetCreatedAt resets all changes to the "created_at" field.
func (m *AllowListItemMutation) ResetCreatedAt() {
	m.created_at = nil
}

// SetUpdatedAt sets the "updated_at" field.
func (m *AllowListItemMutation) SetUpdatedAt(t time.Time) {
	m.updated_at = &t
}

// UpdatedAt returns the value of the "updated_at" field in the mutation.
func (m *AllowListItemMutation) UpdatedAt() (r time.Time, exists bool) {
	v := m.updated_at
	if v == nil {
		return
	}
	return *v, true
}

// OldUpdatedAt returns the old "updated_at" field's value of the AllowListItem entity.
// If the AllowListItem object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AllowListItemMutation) OldUpdatedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldUpdatedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldUpdatedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldUpdatedAt: %w", err)
	}
	return oldValue.UpdatedAt, nil
}

// ResetUpdatedAt resets all changes to the "updated_at" field.
func (m *AllowListItemMutation) ResetUpdatedAt() {
	m.updated_at = nil
}

// SetExpiresAt sets the "expires_at" field.
func (m *AllowListItemMutation) SetExpiresAt(t time.Time) {
	m.expires_at = &t
}

// ExpiresAt returns the value of the "expires_at" field in the mutation.
func (m *AllowListItemMutation) ExpiresAt() (r time.Time, exists bool) {
	v := m.expires_at
	if v == nil {
		return
	}
	return *v, true
}

// OldExpiresAt returns the old "expires_at" field's value of the AllowListItem entity.
// If the AllowListItem object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AllowListItemMutation) OldExpiresAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldExpiresAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldExpiresAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldExpiresAt: %w", err)
	}
	return oldValue.ExpiresAt, nil
}

// ClearExpiresAt clears the value of the "expires_at" field.
func (m *AllowListItemMutation) ClearExpiresAt() {
	m.expires_at = nil
	m.clearedFields[allowlistitem.FieldExpiresAt] = struct{}{}
}

// ExpiresAtCleared returns if the "expires_at" field was cleared in this mutation.
func (m *AllowListItemMutation) ExpiresAtCleared() bool {
	_, ok := m.clearedFields[allowlistitem.FieldExpiresAt]
	return ok
}

// ResetExpiresAt resets all changes to the "expires_at" field.
func (m *AllowListItemMutation) ResetExpiresAt() {
	m.expires_at = nil
	delete(m.clearedFields, allowlistitem.FieldExpiresAt)
}

// SetComment sets the "comment" field.
func (m *AllowListItemMutation) SetComment(s string) {
	m.comment = &s
}

// Comment returns the value of the "comment" field in the mutation.
func (m *AllowListItemMutation) Comment() (r string, exists bool) {
	v := m.comment
	if v == nil {
		return
	}
	return *v, true
}

// OldComment returns the old "comment" field's value of the AllowListItem entity.
// If the AllowListItem object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AllowListItemMutation) OldComment(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldComment is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldComment requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldComment: %w", err)
	}
	return oldValue.Comment, nil
}

// ClearComment clears the value of the "comment" field.
func (m *AllowListItemMutation) ClearComment() {
	m.comment = nil
	m.clearedFields[allowlistitem.FieldComment] = struct{}{}
}

// CommentCleared returns if the "comment" field was cleared in this mutation.
func (m *AllowListItemMutation) CommentCleared() bool {
	_, ok := m.clearedFields[allowlistitem.FieldComment]
	return ok
}

// ResetComment resets all changes to the "comment" field.
func (m *AllowListItemMutation) ResetComment() {
	m.comment = nil
	delete(m.clearedFields, allowlistitem.FieldComment)
}

// SetValue sets the "value" field.
func (m *AllowListItemMutation) SetValue(s string) {
	m.value = &s
}

// Value returns the value of the "value" field in the mutation.
func (m *AllowListItemMutation) Value() (r string, exists bool) {
	v := m.value
	if v == nil {
		return
	}
	return *v, true
}

// OldValue returns the old "value" field's value of the AllowListItem entity.
// If the AllowListItem object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AllowListItemMutation) OldValue(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldValue is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldValue requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldValue: %w", err)
	}
	return oldValue.Value, nil
}

// ResetValue resets all changes to the "value" field.
func (m *AllowListItemMutation) ResetValue() {
	m.value = nil
}

// SetStartIP sets the "start_ip" field.
func (m *AllowListItemMutation) SetStartIP(i int64) {
	m.start_ip = &i
	m.addstart_ip = nil
}

// StartIP returns the value of the "start_ip" field in the mutation.
func (m *AllowListItemMutation) StartIP() (r int64, exists bool) {
	v := m.start_ip
	if v == nil {
		return
	}
	return *v, true
}

// OldStartIP returns the old "start_ip" field's value of the AllowListItem entity.
// If the AllowListItem object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AllowListItemMutation) OldStartIP(ctx context.Context) (v int64, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldStartIP is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldStartIP requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldStartIP: %w", err)
	}
	return oldValue.StartIP, nil
}

// AddStartIP adds i to the "start_ip" field.
func (m *AllowListItemMutation) AddStartIP(i int64) {
	if m.addstart_ip != nil {
		*m.addstart_ip += i
	} else {
		m.addstart_ip = &i
	}
}

// AddedStartIP returns the value that was added to the "start_ip" field in this mutation.
func (m *AllowListItemMutation) AddedStartIP() (r int64, exists bool) {
	v := m.addstart_ip
	if v == nil {
		return
	}
	return *v, true
}

// ClearStartIP clears the value of the "start_ip" field.
func (m *AllowListItemMutation) ClearStartIP() {
	m.start_ip = nil
	m.addstart_ip = nil
	m.clearedFields[allowlistitem.FieldStartIP] = struct{}{}
}

// StartIPCleared returns if the "start_ip" field was cleared in this mutation.
func (m *AllowListItemMutation) StartIPCleared() bool {
	_, ok := m.clearedFields[allowlistitem.FieldStartIP]
	return ok
}

// ResetStartIP resets all changes to the "start_ip" field.
func (m *AllowListItemMutation) ResetStartIP() {
	m.start_ip = nil
	m.addstart_ip = nil
	delete(m.clearedFields, allowlistitem.FieldStartIP)
}

// SetEndIP sets the "end_ip" field.
func (m *AllowListItemMutation) SetEndIP(i int64) {
	m.end_ip = &i
	m.addend_ip = nil
}

// EndIP returns the value of the "end_ip" field in the mutation.
func (m *AllowListItemMutation) EndIP() (r int64, exists bool) {
	v := m.end_ip
	if v == nil {
		return
	}
	return *v, true
}

// OldEndIP returns the old "end_ip" field's value of the AllowListItem entity.
// If the AllowListItem object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AllowListItemMutation) OldEndIP(ctx context.Context) (v int64, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldEndIP is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldEndIP requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldEndIP: %w", err)
	}
	return oldValue.EndIP, nil
}

// AddEndIP adds i to the "end_ip" field.
func (m *AllowListItemMutation) AddEndIP(i int64) {
	if m.addend_ip != nil {
		*m.addend_ip += i
	} else {
		m.addend_ip = &i
	}
}

// AddedEndIP returns the value that was added to the "end_ip" field in this mutation.
func (m *AllowListItemMutation) AddedEndIP() (r int64, exists bool) {
	v := m.addend_ip
	if v == nil {
		return
	}
	return *v, true
}

// ClearEndIP clears the value of the "end_ip" field.
func (m *AllowListItemMutation) ClearEndIP() {
	m.end_ip = nil
	m.addend_ip = nil
	m.clearedFields[allowlistitem.FieldEndIP] = struct{}{}
}

// EndIPCleared returns if the "end_ip" field was cleared in this mutation.
func (m *AllowListItemMutation) EndIPCleared() bool {
	_, ok := m.clearedFields[allowlistitem.FieldEndIP]
	return ok
}

// ResetEndIP resets all changes to the "end_ip" field.
func (m *AllowListItemMutation) ResetEndIP() {
	m.end_ip = nil
	m.addend_ip = nil
	delete(m.clearedFields, allowlistitem.FieldEndIP)
}

// SetStartSuffix sets the "start_suffix" field.
func (m *AllowListItemMutation) SetStartSuffix(i int64) {
	m.start_suffix = &i
	m.addstart_suffix = nil
}

// StartSuffix returns the value of the "start_suffix" field in the mutation.
func (m *AllowListItemMutation) StartSuffix() (r int64, exists bool) {
	v := m.start_suffix
	if v == nil {
		return
	}
	return *v, true
}

// OldStartSuffix returns the old "start_suffix" field's value of the AllowListItem entity.
// If the AllowListItem object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AllowListItemMutation) OldStartSuffix(ctx context.Context) (v int64, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldStartSuffix is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldStartSuffix requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldStartSuffix: %w", err)
	}
	return oldValue.StartSuffix, nil
}

// AddStartSuffix adds i to the "start_suffix" field.
func (m *AllowListItemMutation) AddStartSuffix(i int64) {
	if m.addstart_suffix != nil {
		*m.addstart_suffix += i
	} else {
		m.addstart_suffix = &i
	}
}

// AddedStartSuffix returns the value that was added to the "start_suffix" field in this mutation.
func (m *AllowListItemMutation) AddedStartSuffix() (r int64, exists bool) {
	v := m.addstart_suffix
	if v == nil {
		return
	}
	return *v, true
}

// ClearStartSuffix clears the value of the "start_suffix" field.
func (m *AllowListItemMutation) ClearStartSuffix() {
	m.start_suffix = nil
	m.addstart_suffix = nil
	m.clearedFields[allowlistitem.FieldStartSuffix] = struct{}{}
}

// StartSuffixCleared returns if the "start_suffix" field was cleared in this mutation.
func (m *AllowListItemMutation) StartSuffixCleared() bool {
	_, ok := m.clearedFields[allowlistitem.FieldStartSuffix]
	return ok
}

// ResetStartSuffix resets all changes to the "start_suffix" field.
func (m *AllowListItemMutation) ResetStartSuffix() {
	m.start_suffix = nil
	m.addstart_suffix = nil
	delete(m.clearedFields, allowlistitem.FieldStartSuffix)
}

// SetEndSuffix sets the "end_suffix" field.
func (m *AllowListItemMutation) SetEndSuffix(i int64) {
	m.end_suffix = &i
	m.addend_suffix = nil
}

// EndSuffix returns the value of the "end_suffix" field in the mutation.
func (m *AllowListItemMutation) EndSuffix() (r int64, exists bool) {
	v := m.end_suffix
	if v == nil {
		return
	}
	return *v, true
}

// OldEndSuffix returns the old "end_suffix" field's value of the AllowListItem entity.
// If the AllowListItem object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AllowListItemMutation) OldEndSuffix(ctx context.Context) (v int64, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldEndSuffix is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldEndSuffix requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldEndSuffix: %w", err)
	}
	return oldValue.EndSuffix, nil
}

// AddEndSuffix adds i to the "end_suffix" field.
func (m *AllowListItemMutation) AddEndSuffix(i int64) {
	if m.addend_suffix != nil {
		*m.addend_suffix += i
	} else {
		m.addend_suffix = &i
	}
}

// AddedEndSuffix returns the value that was added to the "end_suffix" field in this mutation.
func (m *AllowListItemMutation) AddedEndSuffix() (r int64, exists bool) {
	v := m.addend_suffix
	if v == nil {
		return
	}
	return *v, true
}

// ClearEndSuffix clears the value of the "end_suffix" field.
func (m *AllowListItemMutation) ClearEndSuffix() {
	m.end_suffix = nil
	m.addend_suffix = nil
	m.clearedFields[allowlistitem.FieldEndSuffix] = struct{}{}
}

// EndSuffixCleared returns if the "end_suffix" field was cleared in this mutation.
func (m *AllowListItemMutation) EndSuffixCleared() bool {
	_, ok := m.clearedFields[allowlistitem.FieldEndSuffix]
	return ok
}

// ResetEndSuffix resets all changes to the "end_suffix" field.
func (m *AllowListItemMutation) ResetEndSuffix() {
	m.end_suffix = nil
	m.addend_suffix = nil
	delete(m.clearedFields, allowlistitem.FieldEndSuffix)
}

// SetIPSize sets the "ip_size" field.
func (m *AllowListItemMutation) SetIPSize(i int64) {
	m.ip_size = &i
	m.addip_size = nil
}

// IPSize returns the value of the "ip_size" field in the mutation.
func (m *AllowListItemMutation) IPSize() (r int64, exists bool) {
	v := m.ip_size
	if v == nil {
		return
	}
	return *v, true
}

// OldIPSize returns the old "ip_size" field's value of the AllowListItem entity.
// If the AllowListItem object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AllowListItemMutation) OldIPSize(ctx context.Context) (v int64, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldIPSize is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldIPSize requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldIPSize: %w", err)
	}
	return oldValue.IPSize, nil
}

// AddIPSize adds i to the "ip_size" field.
func (m *AllowListItemMutation) AddIPSize(i int64) {
	if m.addip_size != nil {
		*m.addip_size += i
	} else {
		m.addip_size = &i
	}
}

// AddedIPSize returns the value that was added to the "ip_size" field in this mutation.
func (m *AllowListItemMutation) AddedIPSize() (r int64, exists bool) {
	v := m.addip_size
	if v == nil {
		return
	}
	return *v, true
}

// ClearIPSize clears the value of the "ip_size" field.
func (m *AllowListItemMutation) ClearIPSize() {
	m.ip_size = nil
	m.addip_size = nil
	m.clearedFields[allowlistitem.FieldIPSize] = struct{}{}
}

// IPSizeCleared returns if the "ip_size" field was cleared in this mutation.
func (m *AllowListItemMutation) IPSizeCleared() bool {
	_, ok := m.clearedFields[allowlistitem.FieldIPSize]
	return ok
}

// ResetIPSize resets all changes to the "ip_size" field.
func (m *AllowListItemMutation) ResetIPSize() {
	m.ip_size = nil
	m.addip_size = nil
	delete(m.clearedFields, allowlistitem.FieldIPSize)
}

// AddAllowlistIDs adds the "allowlist" edge to the AllowList entity by ids.
func (m *AllowListItemMutation) AddAllowlistIDs(ids ...int) {
	if m.allowlist == nil {
		m.allowlist = make(map[int]struct{})
	}
	for i := range ids {
		m.allowlist[ids[i]] = struct{}{}
	}
}

// ClearAllowlist clears the "allowlist" edge to the AllowList entity.
func (m *AllowListItemMutation) ClearAllowlist() {
	m.clearedallowlist = true
}

// AllowlistCleared reports if the "allowlist" edge to the AllowList entity was cleared.
func (m *AllowListItemMutation) AllowlistCleared() bool {
	return m.clearedallowlist
}

// RemoveAllowlistIDs removes the "allowlist" edge to the AllowList entity by IDs.
func (m *AllowListItemMutation) RemoveAllowlistIDs(ids ...int) {
	if m.removedallowlist == nil {
		m.removedallowlist = make(map[int]struct{})
	}
	for i := range ids {
		delete(m.allowlist, ids[i])
		m.removedallowlist[ids[i]] = struct{}{}
	}
}

// RemovedAllowlist returns the removed IDs of the "allowlist" edge to the AllowList entity.
func (m *AllowListItemMutation) RemovedAllowlistIDs() (ids []int) {
	for id := range m.removedallowlist {
		ids = append(ids, id)
	}
	return
}

// AllowlistIDs returns the "allowlist" edge IDs in the mutation.
func (m *AllowListItemMutation) AllowlistIDs() (ids []int) {
	for id := range m.allowlist {
		ids = append(ids, id)
	}
	return
}

// ResetAllowlist resets all changes to the "allowlist" edge.
func (m *AllowListItemMutation) ResetAllowlist() {
	m.allowlist = nil
	m.clearedallowlist = false
	m.removedallowlist = nil
}

// Where appends a list predicates to the AllowListItemMutation builder.
func (m *AllowListItemMutation) Where(ps ...predicate.AllowListItem) {
	m.predicates = append(m.predicates, ps...)
}

// WhereP appends storage-level predicates to the AllowListItemMutation builder. Using this method,
// users can use type-assertion to append predicates that do not depend on any generated package.
func (m *AllowListItemMutation) WhereP(ps ...func(*sql.Selector)) {
	p := make([]predicate.AllowListItem, len(ps))
	for i := range ps {
		p[i] = ps[i]
	}
	m.Where(p...)
}

// Op returns the operation name.
func (m *AllowListItemMutation) Op() Op {
	return m.op
}

// SetOp allows setting the mutation operation.
func (m *AllowListItemMutation) SetOp(op Op) {
	m.op = op
}

// Type returns the node type of this mutation (AllowListItem).
func (m *AllowListItemMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *AllowListItemMutation) Fields() []string {
	fields := make([]string, 0, 10)
	if m.created_at != nil {
		fields = append(fields, allowlistitem.FieldCreatedAt)
	}
	if m.updated_at != nil {
		fields = append(fields, allowlistitem.FieldUpdatedAt)
	}
	if m.expires_at != nil {
		fields = append(fields, allowlistitem.FieldExpiresAt)
	}
	if m.comment != nil {
		fields = append(fields, allowlistitem.FieldComment)
	}
	if m.value != nil {
		fields = append(fields, allowlistitem.FieldValue)
	}
	if m.start_ip != nil {
		fields = append(fields, allowlistitem.FieldStartIP)
	}
	if m.end_ip != nil {
		fields = append(fields, allowlistitem.FieldEndIP)
	}
	if m.start_suffix != nil {
		fields = append(fields, allowlistitem.FieldStartSuffix)
	}
	if m.end_suffix != nil {
		fields = append(fields, allowlistitem.FieldEndSuffix)
	}
	if m.ip_size != nil {
		fields = append(fields, allowlistitem.FieldIPSize)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *AllowListItemMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case allowlistitem.FieldCreatedAt:
		return m.CreatedAt()
	case allowlistitem.FieldUpdatedAt:
		return m.UpdatedAt()
	case allowlistitem.FieldExpiresAt:
		return m.ExpiresAt()
	case allowlistitem.FieldComment:
		return m.Comment()
	case allowlistitem.FieldValue:
		return m.Value()
	case allowlistitem.FieldStartIP:
		return m.StartIP()
	case allowlistitem.FieldEndIP:
		return m.EndIP()
	case allowlistitem.FieldStartSuffix:
		return m.StartSuffix()
	case allowlistitem.FieldEndSuffix:
		return m.EndSuffix()
	case allowlistitem.FieldIPSize:
		return m.IPSize()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *AllowListItemMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case allowlistitem.FieldCreatedAt:
		return m.OldCreatedAt(ctx)
	case allowlistitem.FieldUpdatedAt:
		return m.OldUpdatedAt(ctx)
	case allowlistitem.FieldExpiresAt:
		return m.OldExpiresAt(ctx)
	case allowlistitem.FieldComment:
		return m.OldComment(ctx)
	case allowlistitem.FieldValue:
		return m.OldValue(ctx)
	case allowlistitem.FieldStartIP:
		return m.OldStartIP(ctx)
	case allowlistitem.FieldEndIP:
		return m.OldEndIP(ctx)
	case allowlistitem.FieldStartSuffix:
		return m.OldStartSuffix(ctx)
	case allowlistitem.FieldEndSuffix:
		return m.OldEndSuffix(ctx)
	case allowlistitem.FieldIPSize:
		return m.OldIPSize(ctx)
	}
	return nil, fmt.Errorf("unknown AllowListItem field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *AllowListItemMutation) SetField(name string, value ent.Value) error {
	switch name {
	case allowlistitem.FieldCreatedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetCreatedAt(v)
		return nil
	case allowlistitem.FieldUpdatedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetUpdatedAt(v)
		return nil
	case allowlistitem.FieldExpiresAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetExpiresAt(v)
		return nil
	case allowlistitem.FieldComment:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetComment(v)
		return nil
	case allowlistitem.FieldValue:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetValue(v)
		return nil
	case allowlistitem.FieldStartIP:
		v, ok := value.(int64)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetStartIP(v)
		return nil
	case allowlistitem.FieldEndIP:
		v, ok := value.(int64)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetEndIP(v)
		return nil
	case allowlistitem.FieldStartSuffix:
		v, ok := value.(int64)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetStartSuffix(v)
		return nil
	case allowlistitem.FieldEndSuffix:
		v, ok := value.(int64)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetEndSuffix(v)
		return nil
	case allowlistitem.FieldIPSize:
		v, ok := value.(int64)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetIPSize(v)
		return nil
	}
	return fmt.Errorf("unknown AllowListItem field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *AllowListItemMutation) AddedFields() []string {
	var fields []string
	if m.addstart_ip != nil {
		fields = append(fields, allowlistitem.FieldStartIP)
	}
	if m.addend_ip != nil {
		fields = append(fields, allowlistitem.FieldEndIP)
	}
	if m.addstart_suffix != nil {
		fields = append(fields, allowlistitem.FieldStartSuffix)
	}
	if m.addend_suffix != nil {
		fields = append(fields, allowlistitem.FieldEndSuffix)
	}
	if m.addip_size != nil {
		fields = append(fields, allowlistitem.FieldIPSize)
	}
	return fields
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *AllowListItemMutation) AddedField(name string) (ent.Value, bool) {
	switch name {
	case allowlistitem.FieldStartIP:
		return m.AddedStartIP()
	case allowlistitem.FieldEndIP:
		return m.AddedEndIP()
	case allowlistitem.FieldStartSuffix:
		return m.AddedStartSuffix()
	case allowlistitem.FieldEndSuffix:
		return m.AddedEndSuffix()
	case allowlistitem.FieldIPSize:
		return m.AddedIPSize()
	}
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *AllowListItemMutation) AddField(name string, value ent.Value) error {
	switch name {
	case allowlistitem.FieldStartIP:
		v, ok := value.(int64)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.AddStartIP(v)
		return nil
	case allowlistitem.FieldEndIP:
		v, ok := value.(int64)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.AddEndIP(v)
		return nil
	case allowlistitem.FieldStartSuffix:
		v, ok := value.(int64)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.AddStartSuffix(v)
		return nil
	case allowlistitem.FieldEndSuffix:
		v, ok := value.(int64)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.AddEndSuffix(v)
		return nil
	case allowlistitem.FieldIPSize:
		v, ok := value.(int64)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.AddIPSize(v)
		return nil
	}
	return fmt.Errorf("unknown AllowListItem numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *AllowListItemMutation) ClearedFields() []string {
	var fields []string
	if m.FieldCleared(allowlistitem.FieldExpiresAt) {
		fields = append(fields, allowlistitem.FieldExpiresAt)
	}
	if m.FieldCleared(allowlistitem.FieldComment) {
		fields = append(fields, allowlistitem.FieldComment)
	}
	if m.FieldCleared(allowlistitem.FieldStartIP) {
		fields = append(fields, allowlistitem.FieldStartIP)
	}
	if m.FieldCleared(allowlistitem.FieldEndIP) {
		fields = append(fields, allowlistitem.FieldEndIP)
	}
	if m.FieldCleared(allowlistitem.FieldStartSuffix) {
		fields = append(fields, allowlistitem.FieldStartSuffix)
	}
	if m.FieldCleared(allowlistitem.FieldEndSuffix) {
		fields = append(fields, allowlistitem.FieldEndSuffix)
	}
	if m.FieldCleared(allowlistitem.FieldIPSize) {
		fields = append(fields, allowlistitem.FieldIPSize)
	}
	return fields
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *AllowListItemMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *AllowListItemMutation) ClearField(name string) error {
	switch name {
	case allowlistitem.FieldExpiresAt:
		m.ClearExpiresAt()
		return nil
	case allowlistitem.FieldComment:
		m.ClearComment()
		return nil
	case allowlistitem.FieldStartIP:
		m.ClearStartIP()
		return nil
	case allowlistitem.FieldEndIP:
		m.ClearEndIP()
		return nil
	case allowlistitem.FieldStartSuffix:
		m.ClearStartSuffix()
		return nil
	case allowlistitem.FieldEndSuffix:
		m.ClearEndSuffix()
		return nil
	case allowlistitem.FieldIPSize:
		m.ClearIPSize()
		return nil
	}
	return fmt.Errorf("unknown AllowListItem nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *AllowListItemMutation) ResetField(name string) error {
	switch name {
	case allowlistitem.FieldCreatedAt:
		m.ResetCreatedAt()
		return nil
	case allowlistitem.FieldUpdatedAt:
		m.ResetUpdatedAt()
		return nil
	case allowlistitem.FieldExpiresAt:
		m.ResetExpiresAt()
		return nil
	case allowlistitem.FieldComment:
		m.ResetComment()
		return nil
	case allowlistitem.FieldValue:
		m.ResetValue()
		return nil
	case allowlistitem.FieldStartIP:
		m.ResetStartIP()
		return nil
	case allowlistitem.FieldEndIP:
		m.ResetEndIP()
		return nil
	case allowlistitem.FieldStartSuffix:
		m.ResetStartSuffix()
		return nil
	case allowlistitem.FieldEndSuffix:
		m.ResetEndSuffix()
		return nil
	case allowlistitem.FieldIPSize:
		m.ResetIPSize()
		return nil
	}
	return fmt.Errorf("unknown AllowListItem field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *AllowListItemMutation) AddedEdges() []string {
	edges := make([]string, 0, 1)
	if m.allowlist != nil {
		edges = append(edges, allowlistitem.EdgeAllowlist)
	}
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *AllowListItemMutation) AddedIDs(name string) []ent.Value {
	switch name {
	case allowlistitem.EdgeAllowlist:
		ids := make([]ent.Value, 0, len(m.allowlist))
		for id := range m.allowlist {
			ids = append(ids, id)
		}
		return ids
	}
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *AllowListItemMutation) RemovedEdges() []string {
	edges := make([]string, 0, 1)
	if m.removedallowlist != nil {
		edges = append(edges, allowlistitem.EdgeAllowlist)
	}
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *AllowListItemMutation) RemovedIDs(name string) []ent.Value {
	switch name {
	case allowlistitem.EdgeAllowlist:
		ids := make([]ent.Value, 0, len(m.removedallowlist))
		for id := range m.removedallowlist {
			ids = append(ids, id)
		}
		return ids
	}
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *AllowListItemMutation) ClearedEdges() []string {
	edges := make([]string, 0, 1)
	if m.clearedallowlist {
		edges = append(edges, allowlistitem.EdgeAllowlist)
	}
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *AllowListItemMutation) EdgeCleared(name string) bool {
	switch name {
	case allowlistitem.EdgeAllowlist:
		return m.clearedallowlist
	}
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *AllowListItemMutation) ClearEdge(name string) error {
	switch name {
	}
	return fmt.Errorf("unknown AllowListItem unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *AllowListItemMutation) ResetEdge(name string) error {
	switch name {
	case allowlistitem.EdgeAllowlist:
		m.ResetAllowlist()
		return nil
	}
	return fmt.Errorf("unknown AllowListItem edge %s", name)
}

// BouncerMutation represents an operation that mutates the Bouncer nodes in the graph.
type BouncerMutation struct {
	config
	op            Op
	typ           string
	id            *int
	created_at    *time.Time
	updated_at    *time.Time
	name          *string
	api_key       *string
	revoked       *bool
	ip_address    *string
	_type         *string
	version       *string
	last_pull     *time.Time
	auth_type     *string
	osname        *string
	osversion     *string
	featureflags  *string
	auto_created  *bool
	clearedFields map[string]struct{}
	done          bool
	oldValue      func(context.Context) (*Bouncer, error)
	predicates    []predicate.Bouncer
}

var _ ent.Mutation = (*BouncerMutation)(nil)

// bouncerOption allows management of the mutation configuration using functional options.
type bouncerOption func(*BouncerMutation)

// newBouncerMutation creates new mutation for the Bouncer entity.
func newBouncerMutation(c config, op Op, opts ...bouncerOption) *BouncerMutation {
	m := &BouncerMutation{
		config:        c,
		op:            op,
		typ:           TypeBouncer,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withBouncerID sets the ID field of the mutation.
func withBouncerID(id int) bouncerOption {
	return func(m *BouncerMutation) {
		var (
			err   error
			once  sync.Once
			value *Bouncer
		)
		m.oldValue = func(ctx context.Context) (*Bouncer, error) {
			once.Do(func() {
				if m.done {
					err = errors.New("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().Bouncer.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withBouncer sets the old Bouncer of the mutation.
func withBouncer(node *Bouncer) bouncerOption {
	return func(m *BouncerMutation) {
		m.oldValue = func(context.Context) (*Bouncer, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m BouncerMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m BouncerMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, errors.New("ent: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *BouncerMutation) ID() (id int, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// IDs queries the database and returns the entity ids that match the mutation's predicate.
// That means, if the mutation is applied within a transaction with an isolation level such
// as sql.LevelSerializable, the returned ids match the ids of the rows that will be updated
// or updated by the mutation.
func (m *BouncerMutation) IDs(ctx context.Context) ([]int, error) {
	switch {
	case m.op.Is(OpUpdateOne | OpDeleteOne):
		id, exists := m.ID()
		if exists {
			return []int{id}, nil
		}
		fallthrough
	case m.op.Is(OpUpdate | OpDelete):
		return m.Client().Bouncer.Query().Where(m.predicates...).IDs(ctx)
	default:
		return nil, fmt.Errorf("IDs is not allowed on %s operations", m.op)
	}
}

// SetCreatedAt sets the "created_at" field.
func (m *BouncerMutation) SetCreatedAt(t time.Time) {
	m.created_at = &t
}

// CreatedAt returns the value of the "created_at" field in the mutation.
func (m *BouncerMutation) CreatedAt() (r time.Time, exists bool) {
	v := m.created_at
	if v == nil {
		return
	}
	return *v, true
}

// OldCreatedAt returns the old "created_at" field's value of the Bouncer entity.
// If the Bouncer object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *BouncerMutation) OldCreatedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldCreatedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldCreatedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldCreatedAt: %w", err)
	}
	return oldValue.CreatedAt, nil
}

// ResetCreatedAt resets all changes to the "created_at" field.
func (m *BouncerMutation) ResetCreatedAt() {
	m.created_at = nil
}

// SetUpdatedAt sets the "updated_at" field.
func (m *BouncerMutation) SetUpdatedAt(t time.Time) {
	m.updated_at = &t
}

// UpdatedAt returns the value of the "updated_at" field in the mutation.
func (m *BouncerMutation) UpdatedAt() (r time.Time, exists bool) {
	v := m.updated_at
	if v == nil {
		return
	}
	return *v, true
}

// OldUpdatedAt returns the old "updated_at" field's value of the Bouncer entity.
// If the Bouncer object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *BouncerMutation) OldUpdatedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldUpdatedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldUpdatedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldUpdatedAt: %w", err)
	}
	return oldValue.UpdatedAt, nil
}

// ResetUpdatedAt resets all changes to the "updated_at" field.
func (m *BouncerMutation) ResetUpdatedAt() {
	m.updated_at = nil
}

// SetName sets the "name" field.
func (m *BouncerMutation) SetName(s string) {
	m.name = &s
}

// Name returns the value of the "name" field in the mutation.
func (m *BouncerMutation) Name() (r string, exists bool) {
	v := m.name
	if v == nil {
		return
	}
	return *v, true
}

// OldName returns the old "name" field's value of the Bouncer entity.
// If the Bouncer object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *BouncerMutation) OldName(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldName is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldName requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldName: %w", err)
	}
	return oldValue.Name, nil
}

// ResetName resets all changes to the "name" field.
func (m *BouncerMutation) ResetName() {
	m.name = nil
}

// SetAPIKey sets the "api_key" field.
func (m *BouncerMutation) SetAPIKey(s string) {
	m.api_key = &s
}

// APIKey returns the value of the "api_key" field in the mutation.
func (m *BouncerMutation) APIKey() (r string, exists bool) {
	v := m.api_key
	if v == nil {
		return
	}
	return *v, true
}

// OldAPIKey returns the old "api_key" field's value of the Bouncer entity.
// If the Bouncer object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *BouncerMutation) OldAPIKey(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldAPIKey is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldAPIKey requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldAPIKey: %w", err)
	}
	return oldValue.APIKey, nil
}

// ResetAPIKey resets all changes to the "api_key" field.
func (m *BouncerMutation) ResetAPIKey() {
	m.api_key = nil
}

// SetRevoked sets the "revoked" field.
func (m *BouncerMutation) SetRevoked(b bool) {
	m.revoked = &b
}

// Revoked returns the value of the "revoked" field in the mutation.
func (m *BouncerMutation) Revoked() (r bool, exists bool) {
	v := m.revoked
	if v == nil {
		return
	}
	return *v, true
}

// OldRevoked returns the old "revoked" field's value of the Bouncer entity.
// If the Bouncer object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *BouncerMutation) OldRevoked(ctx context.Context) (v bool, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldRevoked is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldRevoked requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldRevoked: %w", err)
	}
	return oldValue.Revoked, nil
}

// ResetRevoked resets all changes to the "revoked" field.
func (m *BouncerMutation) ResetRevoked() {
	m.revoked = nil
}

// SetIPAddress sets the "ip_address" field.
func (m *BouncerMutation) SetIPAddress(s string) {
	m.ip_address = &s
}

// IPAddress returns the value of the "ip_address" field in the mutation.
func (m *BouncerMutation) IPAddress() (r string, exists bool) {
	v := m.ip_address
	if v == nil {
		return
	}
	return *v, true
}

// OldIPAddress returns the old "ip_address" field's value of the Bouncer entity.
// If the Bouncer object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *BouncerMutation) OldIPAddress(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldIPAddress is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldIPAddress requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldIPAddress: %w", err)
	}
	return oldValue.IPAddress, nil
}

// ClearIPAddress clears the value of the "ip_address" field.
func (m *BouncerMutation) ClearIPAddress() {
	m.ip_address = nil
	m.clearedFields[bouncer.FieldIPAddress] = struct{}{}
}

// IPAddressCleared returns if the "ip_address" field was cleared in this mutation.
func (m *BouncerMutation) IPAddressCleared() bool {
	_, ok := m.clearedFields[bouncer.FieldIPAddress]
	return ok
}

// ResetIPAddress resets all changes to the "ip_address" field.
func (m *BouncerMutation) ResetIPAddress() {
	m.ip_address = nil
	delete(m.clearedFields, bouncer.FieldIPAddress)
}

// SetType sets the "type" field.
func (m *BouncerMutation) SetType(s string) {
	m._type = &s
}

// GetType returns the value of the "type" field in the mutation.
func (m *BouncerMutation) GetType() (r string, exists bool) {
	v := m._type
	if v == nil {
		return
	}
	return *v, true
}

// OldType returns the old "type" field's value of the Bouncer entity.
// If the Bouncer object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *BouncerMutation) OldType(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldType is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldType requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldType: %w", err)
	}
	return oldValue.Type, nil
}

// ClearType clears the value of the "type" field.
func (m *BouncerMutation) ClearType() {
	m._type = nil
	m.clearedFields[bouncer.FieldType] = struct{}{}
}

// TypeCleared returns if the "type" field was cleared in this mutation.
func (m *BouncerMutation) TypeCleared() bool {
	_, ok := m.clearedFields[bouncer.FieldType]
	return ok
}

// ResetType resets all changes to the "type" field.
func (m *BouncerMutation) ResetType() {
	m._type = nil
	delete(m.clearedFields, bouncer.FieldType)
}

// SetVersion sets the "version" field.
func (m *BouncerMutation) SetVersion(s string) {
	m.version = &s
}

// Version returns the value of the "version" field in the mutation.
func (m *BouncerMutation) Version() (r string, exists bool) {
	v := m.version
	if v == nil {
		return
	}
	return *v, true
}

// OldVersion returns the old "version" field's value of the Bouncer entity.
// If the Bouncer object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *BouncerMutation) OldVersion(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldVersion is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldVersion requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldVersion: %w", err)
	}
	return oldValue.Version, nil
}

// ClearVersion clears the value of the "version" field.
func (m *BouncerMutation) ClearVersion() {
	m.version = nil
	m.clearedFields[bouncer.FieldVersion] = struct{}{}
}

// VersionCleared returns if the "version" field was cleared in this mutation.
func (m *BouncerMutation) VersionCleared() bool {
	_, ok := m.clearedFields[bouncer.FieldVersion]
	return ok
}

// ResetVersion resets all changes to the "version" field.
func (m *BouncerMutation) ResetVersion() {
	m.version = nil
	delete(m.clearedFields, bouncer.FieldVersion)
}

// SetLastPull sets the "last_pull" field.
func (m *BouncerMutation) SetLastPull(t time.Time) {
	m.last_pull = &t
}

// LastPull returns the value of the "last_pull" field in the mutation.
func (m *BouncerMutation) LastPull() (r time.Time, exists bool) {
	v := m.last_pull
	if v == nil {
		return
	}
	return *v, true
}

// OldLastPull returns the old "last_pull" field's value of the Bouncer entity.
// If the Bouncer object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *BouncerMutation) OldLastPull(ctx context.Context) (v *time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldLastPull is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldLastPull requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldLastPull: %w", err)
	}
	return oldValue.LastPull, nil
}

// ClearLastPull clears the value of the "last_pull" field.
func (m *BouncerMutation) ClearLastPull() {
	m.last_pull = nil
	m.clearedFields[bouncer.FieldLastPull] = struct{}{}
}

// LastPullCleared returns if the "last_pull" field was cleared in this mutation.
func (m *BouncerMutation) LastPullCleared() bool {
	_, ok := m.clearedFields[bouncer.FieldLastPull]
	return ok
}

// ResetLastPull resets all changes to the "last_pull" field.
func (m *BouncerMutation) ResetLastPull() {
	m.last_pull = nil
	delete(m.clearedFields, bouncer.FieldLastPull)
}

// SetAuthType sets the "auth_type" field.
func (m *BouncerMutation) SetAuthType(s string) {
	m.auth_type = &s
}

// AuthType returns the value of the "auth_type" field in the mutation.
func (m *BouncerMutation) AuthType() (r string, exists bool) {
	v := m.auth_type
	if v == nil {
		return
	}
	return *v, true
}

// OldAuthType returns the old "auth_type" field's value of the Bouncer entity.
// If the Bouncer object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *BouncerMutation) OldAuthType(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldAuthType is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldAuthType requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldAuthType: %w", err)
	}
	return oldValue.AuthType, nil
}

// ResetAuthType resets all changes to the "auth_type" field.
func (m *BouncerMutation) ResetAuthType() {
	m.auth_type = nil
}

// SetOsname sets the "osname" field.
func (m *BouncerMutation) SetOsname(s string) {
	m.osname = &s
}

// Osname returns the value of the "osname" field in the mutation.
func (m *BouncerMutation) Osname() (r string, exists bool) {
	v := m.osname
	if v == nil {
		return
	}
	return *v, true
}

// OldOsname returns the old "osname" field's value of the Bouncer entity.
// If the Bouncer object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *BouncerMutation) OldOsname(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldOsname is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldOsname requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldOsname: %w", err)
	}
	return oldValue.Osname, nil
}

// ClearOsname clears the value of the "osname" field.
func (m *BouncerMutation) ClearOsname() {
	m.osname = nil
	m.clearedFields[bouncer.FieldOsname] = struct{}{}
}

// OsnameCleared returns if the "osname" field was cleared in this mutation.
func (m *BouncerMutation) OsnameCleared() bool {
	_, ok := m.clearedFields[bouncer.FieldOsname]
	return ok
}

// ResetOsname resets all changes to the "osname" field.
func (m *BouncerMutation) ResetOsname() {
	m.osname = nil
	delete(m.clearedFields, bouncer.FieldOsname)
}

// SetOsversion sets the "osversion" field.
func (m *BouncerMutation) SetOsversion(s string) {
	m.osversion = &s
}

// Osversion returns the value of the "osversion" field in the mutation.
func (m *BouncerMutation) Osversion() (r string, exists bool) {
	v := m.osversion
	if v == nil {
		return
	}
	return *v, true
}

// OldOsversion returns the old "osversion" field's value of the Bouncer entity.
// If the Bouncer object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *BouncerMutation) OldOsversion(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldOsversion is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldOsversion requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldOsversion: %w", err)
	}
	return oldValue.Osversion, nil
}

// ClearOsversion clears the value of the "osversion" field.
func (m *BouncerMutation) ClearOsversion() {
	m.osversion = nil
	m.clearedFields[bouncer.FieldOsversion] = struct{}{}
}

// OsversionCleared returns if the "osversion" field was cleared in this mutation.
func (m *BouncerMutation) OsversionCleared() bool {
	_, ok := m.clearedFields[bouncer.FieldOsversion]
	return ok
}

// ResetOsversion resets all changes to the "osversion" field.
func (m *BouncerMutation) ResetOsversion() {
	m.osversion = nil
	delete(m.clearedFields, bouncer.FieldOsversion)
}

// SetFeatureflags sets the "featureflags" field.
func (m *BouncerMutation) SetFeatureflags(s string) {
	m.featureflags = &s
}

// Featureflags returns the value of the "featureflags" field in the mutation.
func (m *BouncerMutation) Featureflags() (r string, exists bool) {
	v := m.featureflags
	if v == nil {
		return
	}
	return *v, true
}

// OldFeatureflags returns the old "featureflags" field's value of the Bouncer entity.
// If the Bouncer object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *BouncerMutation) OldFeatureflags(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldFeatureflags is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldFeatureflags requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldFeatureflags: %w", err)
	}
	return oldValue.Featureflags, nil
}

// ClearFeatureflags clears the value of the "featureflags" field.
func (m *BouncerMutation) ClearFeatureflags() {
	m.featureflags = nil
	m.clearedFields[bouncer.FieldFeatureflags] = struct{}{}
}

// FeatureflagsCleared returns if the "featureflags" field was cleared in this mutation.
func (m *BouncerMutation) FeatureflagsCleared() bool {
	_, ok := m.clearedFields[bouncer.FieldFeatureflags]
	return ok
}

// ResetFeatureflags resets all changes to the "featureflags" field.
func (m *BouncerMutation) ResetFeatureflags() {
	m.featureflags = nil
	delete(m.clearedFields, bouncer.FieldFeatureflags)
}

// SetAutoCreated sets the "auto_created" field.
func (m *BouncerMutation) SetAutoCreated(b bool) {
	m.auto_created = &b
}

// AutoCreated returns the value of the "auto_created" field in the mutation.
func (m *BouncerMutation) AutoCreated() (r bool, exists bool) {
	v := m.auto_created
	if v == nil {
		return
	}
	return *v, true
}

// OldAutoCreated returns the old "auto_created" field's value of the Bouncer entity.
// If the Bouncer object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *BouncerMutation) OldAutoCreated(ctx context.Context) (v bool, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldAutoCreated is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldAutoCreated requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldAutoCreated: %w", err)
	}
	return oldValue.AutoCreated, nil
}

// ResetAutoCreated resets all changes to the "auto_created" field.
func (m *BouncerMutation) ResetAutoCreated() {
	m.auto_created = nil
}

// Where appends a list predicates to the BouncerMutation builder.
func (m *BouncerMutation) Where(ps ...predicate.Bouncer) {
	m.predicates = append(m.predicates, ps...)
}

// WhereP appends storage-level predicates to the BouncerMutation builder. Using this method,
// users can use type-assertion to append predicates that do not depend on any generated package.
func (m *BouncerMutation) WhereP(ps ...func(*sql.Selector)) {
	p := make([]predicate.Bouncer, len(ps))
	for i := range ps {
		p[i] = ps[i]
	}
	m.Where(p...)
}

// Op returns the operation name.
func (m *BouncerMutation) Op() Op {
	return m.op
}

// SetOp allows setting the mutation operation.
func (m *BouncerMutation) SetOp(op Op) {
	m.op = op
}

// Type returns the node type of this mutation (Bouncer).
func (m *BouncerMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *BouncerMutation) Fields() []string {
	fields := make([]string, 0, 14)
	if m.created_at != nil {
		fields = append(fields, bouncer.FieldCreatedAt)
	}
	if m.updated_at != nil {
		fields = append(fields, bouncer.FieldUpdatedAt)
	}
	if m.name != nil {
		fields = append(fields, bouncer.FieldName)
	}
	if m.api_key != nil {
		fields = append(fields, bouncer.FieldAPIKey)
	}
	if m.revoked != nil {
		fields = append(fields, bouncer.FieldRevoked)
	}
	if m.ip_address != nil {
		fields = append(fields, bouncer.FieldIPAddress)
	}
	if m._type != nil {
		fields = append(fields, bouncer.FieldType)
	}
	if m.version != nil {
		fields = append(fields, bouncer.FieldVersion)
	}
	if m.last_pull != nil {
		fields = append(fields, bouncer.FieldLastPull)
	}
	if m.auth_type != nil {
		fields = append(fields, bouncer.FieldAuthType)
	}
	if m.osname != nil {
		fields = append(fields, bouncer.FieldOsname)
	}
	if m.osversion != nil {
		fields = append(fields, bouncer.FieldOsversion)
	}
	if m.featureflags != nil {
		fields = append(fields, bouncer.FieldFeatureflags)
	}
	if m.auto_created != nil {
		fields = append(fields, bouncer.FieldAutoCreated)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *BouncerMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case bouncer.FieldCreatedAt:
		return m.CreatedAt()
	case bouncer.FieldUpdatedAt:
		return m.UpdatedAt()
	case bouncer.FieldName:
		return m.Name()
	case bouncer.FieldAPIKey:
		return m.APIKey()
	case bouncer.FieldRevoked:
		return m.Revoked()
	case bouncer.FieldIPAddress:
		return m.IPAddress()
	case bouncer.FieldType:
		return m.GetType()
	case bouncer.FieldVersion:
		return m.Version()
	case bouncer.FieldLastPull:
		return m.LastPull()
	case bouncer.FieldAuthType:
		return m.AuthType()
	case bouncer.FieldOsname:
		return m.Osname()
	case bouncer.FieldOsversion:
		return m.Osversion()
	case bouncer.FieldFeatureflags:
		return m.Featureflags()
	case bouncer.FieldAutoCreated:
		return m.AutoCreated()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *BouncerMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case bouncer.FieldCreatedAt:
		return m.OldCreatedAt(ctx)
	case bouncer.FieldUpdatedAt:
		return m.OldUpdatedAt(ctx)
	case bouncer.FieldName:
		return m.OldName(ctx)
	case bouncer.FieldAPIKey:
		return m.OldAPIKey(ctx)
	case bouncer.FieldRevoked:
		return m.OldRevoked(ctx)
	case bouncer.FieldIPAddress:
		return m.OldIPAddress(ctx)
	case bouncer.FieldType:
		return m.OldType(ctx)
	case bouncer.FieldVersion:
		return m.OldVersion(ctx)
	case bouncer.FieldLastPull:
		return m.OldLastPull(ctx)
	case bouncer.FieldAuthType:
		return m.OldAuthType(ctx)
	case bouncer.FieldOsname:
		return m.OldOsname(ctx)
	case bouncer.FieldOsversion:
		return m.OldOsversion(ctx)
	case bouncer.FieldFeatureflags:
		return m.OldFeatureflags(ctx)
	case bouncer.FieldAutoCreated:
		return m.OldAutoCreated(ctx)
	}
	return nil, fmt.Errorf("unknown Bouncer field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *BouncerMutation) SetField(name string, value ent.Value) error {
	switch name {
	case bouncer.FieldCreatedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetCreatedAt(v)
		return nil
	case bouncer.FieldUpdatedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetUpdatedAt(v)
		return nil
	case bouncer.FieldName:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetName(v)
		return nil
	case bouncer.FieldAPIKey:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetAPIKey(v)
		return nil
	case bouncer.FieldRevoked:
		v, ok := value.(bool)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetRevoked(v)
		return nil
	case bouncer.FieldIPAddress:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetIPAddress(v)
		return nil
	case bouncer.FieldType:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetType(v)
		return nil
	case bouncer.FieldVersion:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetVersion(v)
		return nil
	case bouncer.FieldLastPull:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetLastPull(v)
		return nil
	case bouncer.FieldAuthType:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetAuthType(v)
		return nil
	case bouncer.FieldOsname:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetOsname(v)
		return nil
	case bouncer.FieldOsversion:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetOsversion(v)
		return nil
	case bouncer.FieldFeatureflags:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetFeatureflags(v)
		return nil
	case bouncer.FieldAutoCreated:
		v, ok := value.(bool)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetAutoCreated(v)
		return nil
	}
	return fmt.Errorf("unknown Bouncer field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *BouncerMutation) AddedFields() []string {
	return nil
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *BouncerMutation) AddedField(name string) (ent.Value, bool) {
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *BouncerMutation) AddField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown Bouncer numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *BouncerMutation) ClearedFields() []string {
	var fields []string
	if m.FieldCleared(bouncer.FieldIPAddress) {
		fields = append(fields, bouncer.FieldIPAddress)
	}
	if m.FieldCleared(bouncer.FieldType) {
		fields = append(fields, bouncer.FieldType)
	}
	if m.FieldCleared(bouncer.FieldVersion) {
		fields = append(fields, bouncer.FieldVersion)
	}
	if m.FieldCleared(bouncer.FieldLastPull) {
		fields = append(fields, bouncer.FieldLastPull)
	}
	if m.FieldCleared(bouncer.FieldOsname) {
		fields = append(fields, bouncer.FieldOsname)
	}
	if m.FieldCleared(bouncer.FieldOsversion) {
		fields = append(fields, bouncer.FieldOsversion)
	}
	if m.FieldCleared(bouncer.FieldFeatureflags) {
		fields = append(fields, bouncer.FieldFeatureflags)
	}
	return fields
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *BouncerMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *BouncerMutation) ClearField(name string) error {
	switch name {
	case bouncer.FieldIPAddress:
		m.ClearIPAddress()
		return nil
	case bouncer.FieldType:
		m.ClearType()
		return nil
	case bouncer.FieldVersion:
		m.ClearVersion()
		return nil
	case bouncer.FieldLastPull:
		m.ClearLastPull()
		return nil
	case bouncer.FieldOsname:
		m.ClearOsname()
		return nil
	case bouncer.FieldOsversion:
		m.ClearOsversion()
		return nil
	case bouncer.FieldFeatureflags:
		m.ClearFeatureflags()
		return nil
	}
	return fmt.Errorf("unknown Bouncer nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *BouncerMutation) ResetField(name string) error {
	switch name {
	case bouncer.FieldCreatedAt:
		m.ResetCreatedAt()
		return nil
	case bouncer.FieldUpdatedAt:
		m.ResetUpdatedAt()
		return nil
	case bouncer.FieldName:
		m.ResetName()
		return nil
	case bouncer.FieldAPIKey:
		m.ResetAPIKey()
		return nil
	case bouncer.FieldRevoked:
		m.ResetRevoked()
		return nil
	case bouncer.FieldIPAddress:
		m.ResetIPAddress()
		return nil
	case bouncer.FieldType:
		m.ResetType()
		return nil
	case bouncer.FieldVersion:
		m.ResetVersion()
		return nil
	case bouncer.FieldLastPull:
		m.ResetLastPull()
		return nil
	case bouncer.FieldAuthType:
		m.ResetAuthType()
		return nil
	case bouncer.FieldOsname:
		m.ResetOsname()
		return nil
	case bouncer.FieldOsversion:
		m.ResetOsversion()
		return nil
	case bouncer.FieldFeatureflags:
		m.ResetFeatureflags()
		return nil
	case bouncer.FieldAutoCreated:
		m.ResetAutoCreated()
		return nil
	}
	return fmt.Errorf("unknown Bouncer field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *BouncerMutation) AddedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *BouncerMutation) AddedIDs(name string) []ent.Value {
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *BouncerMutation) RemovedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *BouncerMutation) RemovedIDs(name string) []ent.Value {
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *BouncerMutation) ClearedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *BouncerMutation) EdgeCleared(name string) bool {
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *BouncerMutation) ClearEdge(name string) error {
	return fmt.Errorf("unknown Bouncer unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *BouncerMutation) ResetEdge(name string) error {
	return fmt.Errorf("unknown Bouncer edge %s", name)
}

// ConfigItemMutation represents an operation that mutates the ConfigItem nodes in the graph.
type ConfigItemMutation struct {
	config
	op            Op
	typ           string
	id            *int
	created_at    *time.Time
	updated_at    *time.Time
	name          *string
	value         *string
	clearedFields map[string]struct{}
	done          bool
	oldValue      func(context.Context) (*ConfigItem, error)
	predicates    []predicate.ConfigItem
}

var _ ent.Mutation = (*ConfigItemMutation)(nil)

// configitemOption allows management of the mutation configuration using functional options.
type configitemOption func(*ConfigItemMutation)

// newConfigItemMutation creates new mutation for the ConfigItem entity.
func newConfigItemMutation(c config, op Op, opts ...configitemOption) *ConfigItemMutation {
	m := &ConfigItemMutation{
		config:        c,
		op:            op,
		typ:           TypeConfigItem,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withConfigItemID sets the ID field of the mutation.
func withConfigItemID(id int) configitemOption {
	return func(m *ConfigItemMutation) {
		var (
			err   error
			once  sync.Once
			value *ConfigItem
		)
		m.oldValue = func(ctx context.Context) (*ConfigItem, error) {
			once.Do(func() {
				if m.done {
					err = errors.New("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().ConfigItem.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withConfigItem sets the old ConfigItem of the mutation.
func withConfigItem(node *ConfigItem) configitemOption {
	return func(m *ConfigItemMutation) {
		m.oldValue = func(context.Context) (*ConfigItem, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m ConfigItemMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m ConfigItemMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, errors.New("ent: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *ConfigItemMutation) ID() (id int, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// IDs queries the database and returns the entity ids that match the mutation's predicate.
// That means, if the mutation is applied within a transaction with an isolation level such
// as sql.LevelSerializable, the returned ids match the ids of the rows that will be updated
// or updated by the mutation.
func (m *ConfigItemMutation) IDs(ctx context.Context) ([]int, error) {
	switch {
	case m.op.Is(OpUpdateOne | OpDeleteOne):
		id, exists := m.ID()
		if exists {
			return []int{id}, nil
		}
		fallthrough
	case m.op.Is(OpUpdate | OpDelete):
		return m.Client().ConfigItem.Query().Where(m.predicates...).IDs(ctx)
	default:
		return nil, fmt.Errorf("IDs is not allowed on %s operations", m.op)
	}
}

// SetCreatedAt sets the "created_at" field.
func (m *ConfigItemMutation) SetCreatedAt(t time.Time) {
	m.created_at = &t
}

// CreatedAt returns the value of the "created_at" field in the mutation.
func (m *ConfigItemMutation) CreatedAt() (r time.Time, exists bool) {
	v := m.created_at
	if v == nil {
		return
	}
	return *v, true
}

// OldCreatedAt returns the old "created_at" field's value of the ConfigItem entity.
// If the ConfigItem object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *ConfigItemMutation) OldCreatedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldCreatedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldCreatedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldCreatedAt: %w", err)
	}
	return oldValue.CreatedAt, nil
}

// ResetCreatedAt resets all changes to the "created_at" field.
func (m *ConfigItemMutation) ResetCreatedAt() {
	m.created_at = nil
}

// SetUpdatedAt sets the "updated_at" field.
func (m *ConfigItemMutation) SetUpdatedAt(t time.Time) {
	m.updated_at = &t
}

// UpdatedAt returns the value of the "updated_at" field in the mutation.
func (m *ConfigItemMutation) UpdatedAt() (r time.Time, exists bool) {
	v := m.updated_at
	if v == nil {
		return
	}
	return *v, true
}

// OldUpdatedAt returns the old "updated_at" field's value of the ConfigItem entity.
// If the ConfigItem object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *ConfigItemMutation) OldUpdatedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldUpdatedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldUpdatedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldUpdatedAt: %w", err)
	}
	return oldValue.UpdatedAt, nil
}

// ResetUpdatedAt resets all changes to the "updated_at" field.
func (m *ConfigItemMutation) ResetUpdatedAt() {
	m.updated_at = nil
}

// SetName sets the "name" field.
func (m *ConfigItemMutation) SetName(s string) {
	m.name = &s
}

// Name returns the value of the "name" field in the mutation.
func (m *ConfigItemMutation) Name() (r string, exists bool) {
	v := m.name
	if v == nil {
		return
	}
	return *v, true
}

// OldName returns the old "name" field's value of the ConfigItem entity.
// If the ConfigItem object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *ConfigItemMutation) OldName(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldName is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldName requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldName: %w", err)
	}
	return oldValue.Name, nil
}

// ResetName resets all changes to the "name" field.
func (m *ConfigItemMutation) ResetName() {
	m.name = nil
}

// SetValue sets the "value" field.
func (m *ConfigItemMutation) SetValue(s string) {
	m.value = &s
}

// Value returns the value of the "value" field in the mutation.
func (m *ConfigItemMutation) Value() (r string, exists bool) {
	v := m.value
	if v == nil {
		return
	}
	return *v, true
}

// OldValue returns the old "value" field's value of the ConfigItem entity.
// If the ConfigItem object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *ConfigItemMutation) OldValue(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldValue is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldValue requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldValue: %w", err)
	}
	return oldValue.Value, nil
}

// ResetValue resets all changes to the "value" field.
func (m *ConfigItemMutation) ResetValue() {
	m.value = nil
}

// Where appends a list predicates to the ConfigItemMutation builder.
func (m *ConfigItemMutation) Where(ps ...predicate.ConfigItem) {
	m.predicates = append(m.predicates, ps...)
}

// WhereP appends storage-level predicates to the ConfigItemMutation builder. Using this method,
// users can use type-assertion to append predicates that do not depend on any generated package.
func (m *ConfigItemMutation) WhereP(ps ...func(*sql.Selector)) {
	p := make([]predicate.ConfigItem, len(ps))
	for i := range ps {
		p[i] = ps[i]
	}
	m.Where(p...)
}

// Op returns the operation name.
func (m *ConfigItemMutation) Op() Op {
	return m.op
}

// SetOp allows setting the mutation operation.
func (m *ConfigItemMutation) SetOp(op Op) {
	m.op = op
}

// Type returns the node type of this mutation (ConfigItem).
func (m *ConfigItemMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *ConfigItemMutation) Fields() []string {
	fields := make([]string, 0, 4)
	if m.created_at != nil {
		fields = append(fields, configitem.FieldCreatedAt)
	}
	if m.updated_at != nil {
		fields = append(fields, configitem.FieldUpdatedAt)
	}
	if m.name != nil {
		fields = append(fields, configitem.FieldName)
	}
	if m.value != nil {
		fields = append(fields, configitem.FieldValue)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *ConfigItemMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case configitem.FieldCreatedAt:
		return m.CreatedAt()
	case configitem.FieldUpdatedAt:
		return m.UpdatedAt()
	case configitem.FieldName:
		return m.Name()
	case configitem.FieldValue:
		return m.Value()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *ConfigItemMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case configitem.FieldCreatedAt:
		return m.OldCreatedAt(ctx)
	case configitem.FieldUpdatedAt:
		return m.OldUpdatedAt(ctx)
	case configitem.FieldName:
		return m.OldName(ctx)
	case configitem.FieldValue:
		return m.OldValue(ctx)
	}
	return nil, fmt.Errorf("unknown ConfigItem field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *ConfigItemMutation) SetField(name string, value ent.Value) error {
	switch name {
	case configitem.FieldCreatedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetCreatedAt(v)
		return nil
	case configitem.FieldUpdatedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetUpdatedAt(v)
		return nil
	case configitem.FieldName:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetName(v)
		return nil
	case configitem.FieldValue:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetValue(v)
		return nil
	}
	return fmt.Errorf("unknown ConfigItem field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *ConfigItemMutation) AddedFields() []string {
	return nil
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *ConfigItemMutation) AddedField(name string) (ent.Value, bool) {
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *ConfigItemMutation) AddField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown ConfigItem numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *ConfigItemMutation) ClearedFields() []string {
	return nil
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *ConfigItemMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *ConfigItemMutation) ClearField(name string) error {
	return fmt.Errorf("unknown ConfigItem nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *ConfigItemMutation) ResetField(name string) error {
	switch name {
	case configitem.FieldCreatedAt:
		m.ResetCreatedAt()
		return nil
	case configitem.FieldUpdatedAt:
		m.ResetUpdatedAt()
		return nil
	case configitem.FieldName:
		m.ResetName()
		return nil
	case configitem.FieldValue:
		m.ResetValue()
		return nil
	}
	return fmt.Errorf("unknown ConfigItem field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *ConfigItemMutation) AddedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *ConfigItemMutation) AddedIDs(name string) []ent.Value {
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *ConfigItemMutation) RemovedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *ConfigItemMutation) RemovedIDs(name string) []ent.Value {
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *ConfigItemMutation) ClearedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *ConfigItemMutation) EdgeCleared(name string) bool {
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *ConfigItemMutation) ClearEdge(name string) error {
	return fmt.Errorf("unknown ConfigItem unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *ConfigItemMutation) ResetEdge(name string) error {
	return fmt.Errorf("unknown ConfigItem edge %s", name)
}

// DecisionMutation represents an operation that mutates the Decision nodes in the graph.
type DecisionMutation struct {
	config
	op              Op
	typ             string
	id              *int
	created_at      *time.Time
	updated_at      *time.Time
	until           *time.Time
	scenario        *string
	_type           *string
	start_ip        *int64
	addstart_ip     *int64
	end_ip          *int64
	addend_ip       *int64
	start_suffix    *int64
	addstart_suffix *int64
	end_suffix      *int64
	addend_suffix   *int64
	ip_size         *int64
	addip_size      *int64
	scope           *string
	value           *string
	origin          *string
	simulated       *bool
	uuid            *string
	clearedFields   map[string]struct{}
	owner           *int
	clearedowner    bool
	done            bool
	oldValue        func(context.Context) (*Decision, error)
	predicates      []predicate.Decision
}

var _ ent.Mutation = (*DecisionMutation)(nil)

// decisionOption allows management of the mutation configuration using functional options.
type decisionOption func(*DecisionMutation)

// newDecisionMutation creates new mutation for the Decision entity.
func newDecisionMutation(c config, op Op, opts ...decisionOption) *DecisionMutation {
	m := &DecisionMutation{
		config:        c,
		op:            op,
		typ:           TypeDecision,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withDecisionID sets the ID field of the mutation.
func withDecisionID(id int) decisionOption {
	return func(m *DecisionMutation) {
		var (
			err   error
			once  sync.Once
			value *Decision
		)
		m.oldValue = func(ctx context.Context) (*Decision, error) {
			once.Do(func() {
				if m.done {
					err = errors.New("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().Decision.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withDecision sets the old Decision of the mutation.
func withDecision(node *Decision) decisionOption {
	return func(m *DecisionMutation) {
		m.oldValue = func(context.Context) (*Decision, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m DecisionMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m DecisionMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, errors.New("ent: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *DecisionMutation) ID() (id int, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// IDs queries the database and returns the entity ids that match the mutation's predicate.
// That means, if the mutation is applied within a transaction with an isolation level such
// as sql.LevelSerializable, the returned ids match the ids of the rows that will be updated
// or updated by the mutation.
func (m *DecisionMutation) IDs(ctx context.Context) ([]int, error) {
	switch {
	case m.op.Is(OpUpdateOne | OpDeleteOne):
		id, exists := m.ID()
		if exists {
			return []int{id}, nil
		}
		fallthrough
	case m.op.Is(OpUpdate | OpDelete):
		return m.Client().Decision.Query().Where(m.predicates...).IDs(ctx)
	default:
		return nil, fmt.Errorf("IDs is not allowed on %s operations", m.op)
	}
}

// SetCreatedAt sets the "created_at" field.
func (m *DecisionMutation) SetCreatedAt(t time.Time) {
	m.created_at = &t
}

// CreatedAt returns the value of the "created_at" field in the mutation.
func (m *DecisionMutation) CreatedAt() (r time.Time, exists bool) {
	v := m.created_at
	if v == nil {
		return
	}
	return *v, true
}

// OldCreatedAt returns the old "created_at" field's value of the Decision entity.
// If the Decision object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *DecisionMutation) OldCreatedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldCreatedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldCreatedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldCreatedAt: %w", err)
	}
	return oldValue.CreatedAt, nil
}

// ResetCreatedAt resets all changes to the "created_at" field.
func (m *DecisionMutation) ResetCreatedAt() {
	m.created_at = nil
}

// SetUpdatedAt sets the "updated_at" field.
func (m *DecisionMutation) SetUpdatedAt(t time.Time) {
	m.updated_at = &t
}

// UpdatedAt returns the value of the "updated_at" field in the mutation.
func (m *DecisionMutation) UpdatedAt() (r time.Time, exists bool) {
	v := m.updated_at
	if v == nil {
		return
	}
	return *v, true
}

// OldUpdatedAt returns the old "updated_at" field's value of the Decision entity.
// If the Decision object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *DecisionMutation) OldUpdatedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldUpdatedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldUpdatedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldUpdatedAt: %w", err)
	}
	return oldValue.UpdatedAt, nil
}

// ResetUpdatedAt resets all changes to the "updated_at" field.
func (m *DecisionMutation) ResetUpdatedAt() {
	m.updated_at = nil
}

// SetUntil sets the "until" field.
func (m *DecisionMutation) SetUntil(t time.Time) {
	m.until = &t
}

// Until returns the value of the "until" field in the mutation.
func (m *DecisionMutation) Until() (r time.Time, exists bool) {
	v := m.until
	if v == nil {
		return
	}
	return *v, true
}

// OldUntil returns the old "until" field's value of the Decision entity.
// If the Decision object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *DecisionMutation) OldUntil(ctx context.Context) (v *time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldUntil is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldUntil requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldUntil: %w", err)
	}
	return oldValue.Until, nil
}

// ClearUntil clears the value of the "until" field.
func (m *DecisionMutation) ClearUntil() {
	m.until = nil
	m.clearedFields[decision.FieldUntil] = struct{}{}
}

// UntilCleared returns if the "until" field was cleared in this mutation.
func (m *DecisionMutation) UntilCleared() bool {
	_, ok := m.clearedFields[decision.FieldUntil]
	return ok
}

// ResetUntil resets all changes to the "until" field.
func (m *DecisionMutation) ResetUntil() {
	m.until = nil
	delete(m.clearedFields, decision.FieldUntil)
}

// SetScenario sets the "scenario" field.
func (m *DecisionMutation) SetScenario(s string) {
	m.scenario = &s
}

// Scenario returns the value of the "scenario" field in the mutation.
func (m *DecisionMutation) Scenario() (r string, exists bool) {
	v := m.scenario
	if v == nil {
		return
	}
	return *v, true
}

// OldScenario returns the old "scenario" field's value of the Decision entity.
// If the Decision object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *DecisionMutation) OldScenario(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldScenario is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldScenario requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldScenario: %w", err)
	}
	return oldValue.Scenario, nil
}

// ResetScenario resets all changes to the "scenario" field.
func (m *DecisionMutation) ResetScenario() {
	m.scenario = nil
}

// SetType sets the "type" field.
func (m *DecisionMutation) SetType(s string) {
	m._type = &s
}

// GetType returns the value of the "type" field in the mutation.
func (m *DecisionMutation) GetType() (r string, exists bool) {
	v := m._type
	if v == nil {
		return
	}
	return *v, true
}

// OldType returns the old "type" field's value of the Decision entity.
// If the Decision object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *DecisionMutation) OldType(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldType is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldType requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldType: %w", err)
	}
	return oldValue.Type, nil
}

// ResetType resets all changes to the "type" field.
func (m *DecisionMutation) ResetType() {
	m._type = nil
}

// SetStartIP sets the "start_ip" field.
func (m *DecisionMutation) SetStartIP(i int64) {
	m.start_ip = &i
	m.addstart_ip = nil
}

// StartIP returns the value of the "start_ip" field in the mutation.
func (m *DecisionMutation) StartIP() (r int64, exists bool) {
	v := m.start_ip
	if v == nil {
		return
	}
	return *v, true
}

// OldStartIP returns the old "start_ip" field's value of the Decision entity.
// If the Decision object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *DecisionMutation) OldStartIP(ctx context.Context) (v int64, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldStartIP is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldStartIP requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldStartIP: %w", err)
	}
	return oldValue.StartIP, nil
}

// AddStartIP adds i to the "start_ip" field.
func (m *DecisionMutation) AddStartIP(i int64) {
	if m.addstart_ip != nil {
		*m.addstart_ip += i
	} else {
		m.addstart_ip = &i
	}
}

// AddedStartIP returns the value that was added to the "start_ip" field in this mutation.
func (m *DecisionMutation) AddedStartIP() (r int64, exists bool) {
	v := m.addstart_ip
	if v == nil {
		return
	}
	return *v, true
}

// ClearStartIP clears the value of the "start_ip" field.
func (m *DecisionMutation) ClearStartIP() {
	m.start_ip = nil
	m.addstart_ip = nil
	m.clearedFields[decision.FieldStartIP] = struct{}{}
}

// StartIPCleared returns if the "start_ip" field was cleared in this mutation.
func (m *DecisionMutation) StartIPCleared() bool {
	_, ok := m.clearedFields[decision.FieldStartIP]
	return ok
}

// ResetStartIP resets all changes to the "start_ip" field.
func (m *DecisionMutation) ResetStartIP() {
	m.start_ip = nil
	m.addstart_ip = nil
	delete(m.clearedFields, decision.FieldStartIP)
}

// SetEndIP sets the "end_ip" field.
func (m *DecisionMutation) SetEndIP(i int64) {
	m.end_ip = &i
	m.addend_ip = nil
}

// EndIP returns the value of the "end_ip" field in the mutation.
func (m *DecisionMutation) EndIP() (r int64, exists bool) {
	v := m.end_ip
	if v == nil {
		return
	}
	return *v, true
}

// OldEndIP returns the old "end_ip" field's value of the Decision entity.
// If the Decision object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *DecisionMutation) OldEndIP(ctx context.Context) (v int64, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldEndIP is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldEndIP requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldEndIP: %w", err)
	}
	return oldValue.EndIP, nil
}

// AddEndIP adds i to the "end_ip" field.
func (m *DecisionMutation) AddEndIP(i int64) {
	if m.addend_ip != nil {
		*m.addend_ip += i
	} else {
		m.addend_ip = &i
	}
}

// AddedEndIP returns the value that was added to the "end_ip" field in this mutation.
func (m *DecisionMutation) AddedEndIP() (r int64, exists bool) {
	v := m.addend_ip
	if v == nil {
		return
	}
	return *v, true
}

// ClearEndIP clears the value of the "end_ip" field.
func (m *DecisionMutation) ClearEndIP() {
	m.end_ip = nil
	m.addend_ip = nil
	m.clearedFields[decision.FieldEndIP] = struct{}{}
}

// EndIPCleared returns if the "end_ip" field was cleared in this mutation.
func (m *DecisionMutation) EndIPCleared() bool {
	_, ok := m.clearedFields[decision.FieldEndIP]
	return ok
}

// ResetEndIP resets all changes to the "end_ip" field.
func (m *DecisionMutation) ResetEndIP() {
	m.end_ip = nil
	m.addend_ip = nil
	delete(m.clearedFields, decision.FieldEndIP)
}

// SetStartSuffix sets the "start_suffix" field.
func (m *DecisionMutation) SetStartSuffix(i int64) {
	m.start_suffix = &i
	m.addstart_suffix = nil
}

// StartSuffix returns the value of the "start_suffix" field in the mutation.
func (m *DecisionMutation) StartSuffix() (r int64, exists bool) {
	v := m.start_suffix
	if v == nil {
		return
	}
	return *v, true
}

// OldStartSuffix returns the old "start_suffix" field's value of the Decision entity.
// If the Decision object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *DecisionMutation) OldStartSuffix(ctx context.Context) (v int64, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldStartSuffix is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldStartSuffix requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldStartSuffix: %w", err)
	}
	return oldValue.StartSuffix, nil
}

// AddStartSuffix adds i to the "start_suffix" field.
func (m *DecisionMutation) AddStartSuffix(i int64) {
	if m.addstart_suffix != nil {
		*m.addstart_suffix += i
	} else {
		m.addstart_suffix = &i
	}
}

// AddedStartSuffix returns the value that was added to the "start_suffix" field in this mutation.
func (m *DecisionMutation) AddedStartSuffix() (r int64, exists bool) {
	v := m.addstart_suffix
	if v == nil {
		return
	}
	return *v, true
}

// ClearStartSuffix clears the value of the "start_suffix" field.
func (m *DecisionMutation) ClearStartSuffix() {
	m.start_suffix = nil
	m.addstart_suffix = nil
	m.clearedFields[decision.FieldStartSuffix] = struct{}{}
}

// StartSuffixCleared returns if the "start_suffix" field was cleared in this mutation.
func (m *DecisionMutation) StartSuffixCleared() bool {
	_, ok := m.clearedFields[decision.FieldStartSuffix]
	return ok
}

// ResetStartSuffix resets all changes to the "start_suffix" field.
func (m *DecisionMutation) ResetStartSuffix() {
	m.start_suffix = nil
	m.addstart_suffix = nil
	delete(m.clearedFields, decision.FieldStartSuffix)
}

// SetEndSuffix sets the "end_suffix" field.
func (m *DecisionMutation) SetEndSuffix(i int64) {
	m.end_suffix = &i
	m.addend_suffix = nil
}

// EndSuffix returns the value of the "end_suffix" field in the mutation.
func (m *DecisionMutation) EndSuffix() (r int64, exists bool) {
	v := m.end_suffix
	if v == nil {
		return
	}
	return *v, true
}

// OldEndSuffix returns the old "end_suffix" field's value of the Decision entity.
// If the Decision object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *DecisionMutation) OldEndSuffix(ctx context.Context) (v int64, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldEndSuffix is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldEndSuffix requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldEndSuffix: %w", err)
	}
	return oldValue.EndSuffix, nil
}

// AddEndSuffix adds i to the "end_suffix" field.
func (m *DecisionMutation) AddEndSuffix(i int64) {
	if m.addend_suffix != nil {
		*m.addend_suffix += i
	} else {
		m.addend_suffix = &i
	}
}

// AddedEndSuffix returns the value that was added to the "end_suffix" field in this mutation.
func (m *DecisionMutation) AddedEndSuffix() (r int64, exists bool) {
	v := m.addend_suffix
	if v == nil {
		return
	}
	return *v, true
}

// ClearEndSuffix clears the value of the "end_suffix" field.
func (m *DecisionMutation) ClearEndSuffix() {
	m.end_suffix = nil
	m.addend_suffix = nil
	m.clearedFields[decision.FieldEndSuffix] = struct{}{}
}

// EndSuffixCleared returns if the "end_suffix" field was cleared in this mutation.
func (m *DecisionMutation) EndSuffixCleared() bool {
	_, ok := m.clearedFields[decision.FieldEndSuffix]
	return ok
}

// ResetEndSuffix resets all changes to the "end_suffix" field.
func (m *DecisionMutation) ResetEndSuffix() {
	m.end_suffix = nil
	m.addend_suffix = nil
	delete(m.clearedFields, decision.FieldEndSuffix)
}

// SetIPSize sets the "ip_size" field.
func (m *DecisionMutation) SetIPSize(i int64) {
	m.ip_size = &i
	m.addip_size = nil
}

// IPSize returns the value of the "ip_size" field in the mutation.
func (m *DecisionMutation) IPSize() (r int64, exists bool) {
	v := m.ip_size
	if v == nil {
		return
	}
	return *v, true
}

// OldIPSize returns the old "ip_size" field's value of the Decision entity.
// If the Decision object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *DecisionMutation) OldIPSize(ctx context.Context) (v int64, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldIPSize is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldIPSize requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldIPSize: %w", err)
	}
	return oldValue.IPSize, nil
}

// AddIPSize adds i to the "ip_size" field.
func (m *DecisionMutation) AddIPSize(i int64) {
	if m.addip_size != nil {
		*m.addip_size += i
	} else {
		m.addip_size = &i
	}
}

// AddedIPSize returns the value that was added to the "ip_size" field in this mutation.
func (m *DecisionMutation) AddedIPSize() (r int64, exists bool) {
	v := m.addip_size
	if v == nil {
		return
	}
	return *v, true
}

// ClearIPSize clears the value of the "ip_size" field.
func (m *DecisionMutation) ClearIPSize() {
	m.ip_size = nil
	m.addip_size = nil
	m.clearedFields[decision.FieldIPSize] = struct{}{}
}

// IPSizeCleared returns if the "ip_size" field was cleared in this mutation.
func (m *DecisionMutation) IPSizeCleared() bool {
	_, ok := m.clearedFields[decision.FieldIPSize]
	return ok
}

// ResetIPSize resets all changes to the "ip_size" field.
func (m *DecisionMutation) ResetIPSize() {
	m.ip_size = nil
	m.addip_size = nil
	delete(m.clearedFields, decision.FieldIPSize)
}

// SetScope sets the "scope" field.
func (m *DecisionMutation) SetScope(s string) {
	m.scope = &s
}

// Scope returns the value of the "scope" field in the mutation.
func (m *DecisionMutation) Scope() (r string, exists bool) {
	v := m.scope
	if v == nil {
		return
	}
	return *v, true
}

// OldScope returns the old "scope" field's value of the Decision entity.
// If the Decision object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *DecisionMutation) OldScope(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldScope is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldScope requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldScope: %w", err)
	}
	return oldValue.Scope, nil
}

// ResetScope resets all changes to the "scope" field.
func (m *DecisionMutation) ResetScope() {
	m.scope = nil
}

// SetValue sets the "value" field.
func (m *DecisionMutation) SetValue(s string) {
	m.value = &s
}

// Value returns the value of the "value" field in the mutation.
func (m *DecisionMutation) Value() (r string, exists bool) {
	v := m.value
	if v == nil {
		return
	}
	return *v, true
}

// OldValue returns the old "value" field's value of the Decision entity.
// If the Decision object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *DecisionMutation) OldValue(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldValue is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldValue requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldValue: %w", err)
	}
	return oldValue.Value, nil
}

// ResetValue resets all changes to the "value" field.
func (m *DecisionMutation) ResetValue() {
	m.value = nil
}

// SetOrigin sets the "origin" field.
func (m *DecisionMutation) SetOrigin(s string) {
	m.origin = &s
}

// Origin returns the value of the "origin" field in the mutation.
func (m *DecisionMutation) Origin() (r string, exists bool) {
	v := m.origin
	if v == nil {
		return
	}
	return *v, true
}

// OldOrigin returns the old "origin" field's value of the Decision entity.
// If the Decision object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *DecisionMutation) OldOrigin(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldOrigin is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldOrigin requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldOrigin: %w", err)
	}
	return oldValue.Origin, nil
}

// ResetOrigin resets all changes to the "origin" field.
func (m *DecisionMutation) ResetOrigin() {
	m.origin = nil
}

// SetSimulated sets the "simulated" field.
func (m *DecisionMutation) SetSimulated(b bool) {
	m.simulated = &b
}

// Simulated returns the value of the "simulated" field in the mutation.
func (m *DecisionMutation) Simulated() (r bool, exists bool) {
	v := m.simulated
	if v == nil {
		return
	}
	return *v, true
}

// OldSimulated returns the old "simulated" field's value of the Decision entity.
// If the Decision object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *DecisionMutation) OldSimulated(ctx context.Context) (v bool, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldSimulated is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldSimulated requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldSimulated: %w", err)
	}
	return oldValue.Simulated, nil
}

// ResetSimulated resets all changes to the "simulated" field.
func (m *DecisionMutation) ResetSimulated() {
	m.simulated = nil
}

// SetUUID sets the "uuid" field.
func (m *DecisionMutation) SetUUID(s string) {
	m.uuid = &s
}

// UUID returns the value of the "uuid" field in the mutation.
func (m *DecisionMutation) UUID() (r string, exists bool) {
	v := m.uuid
	if v == nil {
		return
	}
	return *v, true
}

// OldUUID returns the old "uuid" field's value of the Decision entity.
// If the Decision object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *DecisionMutation) OldUUID(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldUUID is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldUUID requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldUUID: %w", err)
	}
	return oldValue.UUID, nil
}

// ClearUUID clears the value of the "uuid" field.
func (m *DecisionMutation) ClearUUID() {
	m.uuid = nil
	m.clearedFields[decision.FieldUUID] = struct{}{}
}

// UUIDCleared returns if the "uuid" field was cleared in this mutation.
func (m *DecisionMutation) UUIDCleared() bool {
	_, ok := m.clearedFields[decision.FieldUUID]
	return ok
}

// ResetUUID resets all changes to the "uuid" field.
func (m *DecisionMutation) ResetUUID() {
	m.uuid = nil
	delete(m.clearedFields, decision.FieldUUID)
}

// SetAlertDecisions sets the "alert_decisions" field.
func (m *DecisionMutation) SetAlertDecisions(i int) {
	m.owner = &i
}

// AlertDecisions returns the value of the "alert_decisions" field in the mutation.
func (m *DecisionMutation) AlertDecisions() (r int, exists bool) {
	v := m.owner
	if v == nil {
		return
	}
	return *v, true
}

// OldAlertDecisions returns the old "alert_decisions" field's value of the Decision entity.
// If the Decision object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *DecisionMutation) OldAlertDecisions(ctx context.Context) (v int, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldAlertDecisions is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldAlertDecisions requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldAlertDecisions: %w", err)
	}
	return oldValue.AlertDecisions, nil
}

// ClearAlertDecisions clears the value of the "alert_decisions" field.
func (m *DecisionMutation) ClearAlertDecisions() {
	m.owner = nil
	m.clearedFields[decision.FieldAlertDecisions] = struct{}{}
}

// AlertDecisionsCleared returns if the "alert_decisions" field was cleared in this mutation.
func (m *DecisionMutation) AlertDecisionsCleared() bool {
	_, ok := m.clearedFields[decision.FieldAlertDecisions]
	return ok
}

// ResetAlertDecisions resets all changes to the "alert_decisions" field.
func (m *DecisionMutation) ResetAlertDecisions() {
	m.owner = nil
	delete(m.clearedFields, decision.FieldAlertDecisions)
}

// SetOwnerID sets the "owner" edge to the Alert entity by id.
func (m *DecisionMutation) SetOwnerID(id int) {
	m.owner = &id
}

// ClearOwner clears the "owner" edge to the Alert entity.
func (m *DecisionMutation) ClearOwner() {
	m.clearedowner = true
	m.clearedFields[decision.FieldAlertDecisions] = struct{}{}
}

// OwnerCleared reports if the "owner" edge to the Alert entity was cleared.
func (m *DecisionMutation) OwnerCleared() bool {
	return m.AlertDecisionsCleared() || m.clearedowner
}

// OwnerID returns the "owner" edge ID in the mutation.
func (m *DecisionMutation) OwnerID() (id int, exists bool) {
	if m.owner != nil {
		return *m.owner, true
	}
	return
}

// OwnerIDs returns the "owner" edge IDs in the mutation.
// Note that IDs always returns len(IDs) <= 1 for unique edges, and you should use
// OwnerID instead. It exists only for internal usage by the builders.
func (m *DecisionMutation) OwnerIDs() (ids []int) {
	if id := m.owner; id != nil {
		ids = append(ids, *id)
	}
	return
}

// ResetOwner resets all changes to the "owner" edge.
func (m *DecisionMutation) ResetOwner() {
	m.owner = nil
	m.clearedowner = false
}

// Where appends a list predicates to the DecisionMutation builder.
func (m *DecisionMutation) Where(ps ...predicate.Decision) {
	m.predicates = append(m.predicates, ps...)
}

// WhereP appends storage-level predicates to the DecisionMutation builder. Using this method,
// users can use type-assertion to append predicates that do not depend on any generated package.
func (m *DecisionMutation) WhereP(ps ...func(*sql.Selector)) {
	p := make([]predicate.Decision, len(ps))
	for i := range ps {
		p[i] = ps[i]
	}
	m.Where(p...)
}

// Op returns the operation name.
func (m *DecisionMutation) Op() Op {
	return m.op
}

// SetOp allows setting the mutation operation.
func (m *DecisionMutation) SetOp(op Op) {
	m.op = op
}

// Type returns the node type of this mutation (Decision).
func (m *DecisionMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *DecisionMutation) Fields() []string {
	fields := make([]string, 0, 16)
	if m.created_at != nil {
		fields = append(fields, decision.FieldCreatedAt)
	}
	if m.updated_at != nil {
		fields = append(fields, decision.FieldUpdatedAt)
	}
	if m.until != nil {
		fields = append(fields, decision.FieldUntil)
	}
	if m.scenario != nil {
		fields = append(fields, decision.FieldScenario)
	}
	if m._type != nil {
		fields = append(fields, decision.FieldType)
	}
	if m.start_ip != nil {
		fields = append(fields, decision.FieldStartIP)
	}
	if m.end_ip != nil {
		fields = append(fields, decision.FieldEndIP)
	}
	if m.start_suffix != nil {
		fields = append(fields, decision.FieldStartSuffix)
	}
	if m.end_suffix != nil {
		fields = append(fields, decision.FieldEndSuffix)
	}
	if m.ip_size != nil {
		fields = append(fields, decision.FieldIPSize)
	}
	if m.scope != nil {
		fields = append(fields, decision.FieldScope)
	}
	if m.value != nil {
		fields = append(fields, decision.FieldValue)
	}
	if m.origin != nil {
		fields = append(fields, decision.FieldOrigin)
	}
	if m.simulated != nil {
		fields = append(fields, decision.FieldSimulated)
	}
	if m.uuid != nil {
		fields = append(fields, decision.FieldUUID)
	}
	if m.owner != nil {
		fields = append(fields, decision.FieldAlertDecisions)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *DecisionMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case decision.FieldCreatedAt:
		return m.CreatedAt()
	case decision.FieldUpdatedAt:
		return m.UpdatedAt()
	case decision.FieldUntil:
		return m.Until()
	case decision.FieldScenario:
		return m.Scenario()
	case decision.FieldType:
		return m.GetType()
	case decision.FieldStartIP:
		return m.StartIP()
	case decision.FieldEndIP:
		return m.EndIP()
	case decision.FieldStartSuffix:
		return m.StartSuffix()
	case decision.FieldEndSuffix:
		return m.EndSuffix()
	case decision.FieldIPSize:
		return m.IPSize()
	case decision.FieldScope:
		return m.Scope()
	case decision.FieldValue:
		return m.Value()
	case decision.FieldOrigin:
		return m.Origin()
	case decision.FieldSimulated:
		return m.Simulated()
	case decision.FieldUUID:
		return m.UUID()
	case decision.FieldAlertDecisions:
		return m.AlertDecisions()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *DecisionMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case decision.FieldCreatedAt:
		return m.OldCreatedAt(ctx)
	case decision.FieldUpdatedAt:
		return m.OldUpdatedAt(ctx)
	case decision.FieldUntil:
		return m.OldUntil(ctx)
	case decision.FieldScenario:
		return m.OldScenario(ctx)
	case decision.FieldType:
		return m.OldType(ctx)
	case decision.FieldStartIP:
		return m.OldStartIP(ctx)
	case decision.FieldEndIP:
		return m.OldEndIP(ctx)
	case decision.FieldStartSuffix:
		return m.OldStartSuffix(ctx)
	case decision.FieldEndSuffix:
		return m.OldEndSuffix(ctx)
	case decision.FieldIPSize:
		return m.OldIPSize(ctx)
	case decision.FieldScope:
		return m.OldScope(ctx)
	case decision.FieldValue:
		return m.OldValue(ctx)
	case decision.FieldOrigin:
		return m.OldOrigin(ctx)
	case decision.FieldSimulated:
		return m.OldSimulated(ctx)
	case decision.FieldUUID:
		return m.OldUUID(ctx)
	case decision.FieldAlertDecisions:
		return m.OldAlertDecisions(ctx)
	}
	return nil, fmt.Errorf("unknown Decision field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *DecisionMutation) SetField(name string, value ent.Value) error {
	switch name {
	case decision.FieldCreatedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetCreatedAt(v)
		return nil
	case decision.FieldUpdatedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetUpdatedAt(v)
		return nil
	case decision.FieldUntil:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetUntil(v)
		return nil
	case decision.FieldScenario:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetScenario(v)
		return nil
	case decision.FieldType:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetType(v)
		return nil
	case decision.FieldStartIP:
		v, ok := value.(int64)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetStartIP(v)
		return nil
	case decision.FieldEndIP:
		v, ok := value.(int64)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetEndIP(v)
		return nil
	case decision.FieldStartSuffix:
		v, ok := value.(int64)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetStartSuffix(v)
		return nil
	case decision.FieldEndSuffix:
		v, ok := value.(int64)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetEndSuffix(v)
		return nil
	case decision.FieldIPSize:
		v, ok := value.(int64)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetIPSize(v)
		return nil
	case decision.FieldScope:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetScope(v)
		return nil
	case decision.FieldValue:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetValue(v)
		return nil
	case decision.FieldOrigin:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetOrigin(v)
		return nil
	case decision.FieldSimulated:
		v, ok := value.(bool)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetSimulated(v)
		return nil
	case decision.FieldUUID:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetUUID(v)
		return nil
	case decision.FieldAlertDecisions:
		v, ok := value.(int)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetAlertDecisions(v)
		return nil
	}
	return fmt.Errorf("unknown Decision field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *DecisionMutation) AddedFields() []string {
	var fields []string
	if m.addstart_ip != nil {
		fields = append(fields, decision.FieldStartIP)
	}
	if m.addend_ip != nil {
		fields = append(fields, decision.FieldEndIP)
	}
	if m.addstart_suffix != nil {
		fields = append(fields, decision.FieldStartSuffix)
	}
	if m.addend_suffix != nil {
		fields = append(fields, decision.FieldEndSuffix)
	}
	if m.addip_size != nil {
		fields = append(fields, decision.FieldIPSize)
	}
	return fields
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *DecisionMutation) AddedField(name string) (ent.Value, bool) {
	switch name {
	case decision.FieldStartIP:
		return m.AddedStartIP()
	case decision.FieldEndIP:
		return m.AddedEndIP()
	case decision.FieldStartSuffix:
		return m.AddedStartSuffix()
	case decision.FieldEndSuffix:
		return m.AddedEndSuffix()
	case decision.FieldIPSize:
		return m.AddedIPSize()
	}
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *DecisionMutation) AddField(name string, value ent.Value) error {
	switch name {
	case decision.FieldStartIP:
		v, ok := value.(int64)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.AddStartIP(v)
		return nil
	case decision.FieldEndIP:
		v, ok := value.(int64)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.AddEndIP(v)
		return nil
	case decision.FieldStartSuffix:
		v, ok := value.(int64)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.AddStartSuffix(v)
		return nil
	case decision.FieldEndSuffix:
		v, ok := value.(int64)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.AddEndSuffix(v)
		return nil
	case decision.FieldIPSize:
		v, ok := value.(int64)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.AddIPSize(v)
		return nil
	}
	return fmt.Errorf("unknown Decision numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *DecisionMutation) ClearedFields() []string {
	var fields []string
	if m.FieldCleared(decision.FieldUntil) {
		fields = append(fields, decision.FieldUntil)
	}
	if m.FieldCleared(decision.FieldStartIP) {
		fields = append(fields, decision.FieldStartIP)
	}
	if m.FieldCleared(decision.FieldEndIP) {
		fields = append(fields, decision.FieldEndIP)
	}
	if m.FieldCleared(decision.FieldStartSuffix) {
		fields = append(fields, decision.FieldStartSuffix)
	}
	if m.FieldCleared(decision.FieldEndSuffix) {
		fields = append(fields, decision.FieldEndSuffix)
	}
	if m.FieldCleared(decision.FieldIPSize) {
		fields = append(fields, decision.FieldIPSize)
	}
	if m.FieldCleared(decision.FieldUUID) {
		fields = append(fields, decision.FieldUUID)
	}
	if m.FieldCleared(decision.FieldAlertDecisions) {
		fields = append(fields, decision.FieldAlertDecisions)
	}
	return fields
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *DecisionMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *DecisionMutation) ClearField(name string) error {
	switch name {
	case decision.FieldUntil:
		m.ClearUntil()
		return nil
	case decision.FieldStartIP:
		m.ClearStartIP()
		return nil
	case decision.FieldEndIP:
		m.ClearEndIP()
		return nil
	case decision.FieldStartSuffix:
		m.ClearStartSuffix()
		return nil
	case decision.FieldEndSuffix:
		m.ClearEndSuffix()
		return nil
	case decision.FieldIPSize:
		m.ClearIPSize()
		return nil
	case decision.FieldUUID:
		m.ClearUUID()
		return nil
	case decision.FieldAlertDecisions:
		m.ClearAlertDecisions()
		return nil
	}
	return fmt.Errorf("unknown Decision nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *DecisionMutation) ResetField(name string) error {
	switch name {
	case decision.FieldCreatedAt:
		m.ResetCreatedAt()
		return nil
	case decision.FieldUpdatedAt:
		m.ResetUpdatedAt()
		return nil
	case decision.FieldUntil:
		m.ResetUntil()
		return nil
	case decision.FieldScenario:
		m.ResetScenario()
		return nil
	case decision.FieldType:
		m.ResetType()
		return nil
	case decision.FieldStartIP:
		m.ResetStartIP()
		return nil
	case decision.FieldEndIP:
		m.ResetEndIP()
		return nil
	case decision.FieldStartSuffix:
		m.ResetStartSuffix()
		return nil
	case decision.FieldEndSuffix:
		m.ResetEndSuffix()
		return nil
	case decision.FieldIPSize:
		m.ResetIPSize()
		return nil
	case decision.FieldScope:
		m.ResetScope()
		return nil
	case decision.FieldValue:
		m.ResetValue()
		return nil
	case decision.FieldOrigin:
		m.ResetOrigin()
		return nil
	case decision.FieldSimulated:
		m.ResetSimulated()
		return nil
	case decision.FieldUUID:
		m.ResetUUID()
		return nil
	case decision.FieldAlertDecisions:
		m.ResetAlertDecisions()
		return nil
	}
	return fmt.Errorf("unknown Decision field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *DecisionMutation) AddedEdges() []string {
	edges := make([]string, 0, 1)
	if m.owner != nil {
		edges = append(edges, decision.EdgeOwner)
	}
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *DecisionMutation) AddedIDs(name string) []ent.Value {
	switch name {
	case decision.EdgeOwner:
		if id := m.owner; id != nil {
			return []ent.Value{*id}
		}
	}
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *DecisionMutation) RemovedEdges() []string {
	edges := make([]string, 0, 1)
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *DecisionMutation) RemovedIDs(name string) []ent.Value {
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *DecisionMutation) ClearedEdges() []string {
	edges := make([]string, 0, 1)
	if m.clearedowner {
		edges = append(edges, decision.EdgeOwner)
	}
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *DecisionMutation) EdgeCleared(name string) bool {
	switch name {
	case decision.EdgeOwner:
		return m.clearedowner
	}
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *DecisionMutation) ClearEdge(name string) error {
	switch name {
	case decision.EdgeOwner:
		m.ClearOwner()
		return nil
	}
	return fmt.Errorf("unknown Decision unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *DecisionMutation) ResetEdge(name string) error {
	switch name {
	case decision.EdgeOwner:
		m.ResetOwner()
		return nil
	}
	return fmt.Errorf("unknown Decision edge %s", name)
}

// EventMutation represents an operation that mutates the Event nodes in the graph.
type EventMutation struct {
	config
	op            Op
	typ           string
	id            *int
	created_at    *time.Time
	updated_at    *time.Time
	time          *time.Time
	serialized    *string
	clearedFields map[string]struct{}
	owner         *int
	clearedowner  bool
	done          bool
	oldValue      func(context.Context) (*Event, error)
	predicates    []predicate.Event
}

var _ ent.Mutation = (*EventMutation)(nil)

// eventOption allows management of the mutation configuration using functional options.
type eventOption func(*EventMutation)

// newEventMutation creates new mutation for the Event entity.
func newEventMutation(c config, op Op, opts ...eventOption) *EventMutation {
	m := &EventMutation{
		config:        c,
		op:            op,
		typ:           TypeEvent,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withEventID sets the ID field of the mutation.
func withEventID(id int) eventOption {
	return func(m *EventMutation) {
		var (
			err   error
			once  sync.Once
			value *Event
		)
		m.oldValue = func(ctx context.Context) (*Event, error) {
			once.Do(func() {
				if m.done {
					err = errors.New("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().Event.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withEvent sets the old Event of the mutation.
func withEvent(node *Event) eventOption {
	return func(m *EventMutation) {
		m.oldValue = func(context.Context) (*Event, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m EventMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m EventMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, errors.New("ent: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *EventMutation) ID() (id int, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// IDs queries the database and returns the entity ids that match the mutation's predicate.
// That means, if the mutation is applied within a transaction with an isolation level such
// as sql.LevelSerializable, the returned ids match the ids of the rows that will be updated
// or updated by the mutation.
func (m *EventMutation) IDs(ctx context.Context) ([]int, error) {
	switch {
	case m.op.Is(OpUpdateOne | OpDeleteOne):
		id, exists := m.ID()
		if exists {
			return []int{id}, nil
		}
		fallthrough
	case m.op.Is(OpUpdate | OpDelete):
		return m.Client().Event.Query().Where(m.predicates...).IDs(ctx)
	default:
		return nil, fmt.Errorf("IDs is not allowed on %s operations", m.op)
	}
}

// SetCreatedAt sets the "created_at" field.
func (m *EventMutation) SetCreatedAt(t time.Time) {
	m.created_at = &t
}

// CreatedAt returns the value of the "created_at" field in the mutation.
func (m *EventMutation) CreatedAt() (r time.Time, exists bool) {
	v := m.created_at
	if v == nil {
		return
	}
	return *v, true
}

// OldCreatedAt returns the old "created_at" field's value of the Event entity.
// If the Event object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *EventMutation) OldCreatedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldCreatedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldCreatedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldCreatedAt: %w", err)
	}
	return oldValue.CreatedAt, nil
}

// ResetCreatedAt resets all changes to the "created_at" field.
func (m *EventMutation) ResetCreatedAt() {
	m.created_at = nil
}

// SetUpdatedAt sets the "updated_at" field.
func (m *EventMutation) SetUpdatedAt(t time.Time) {
	m.updated_at = &t
}

// UpdatedAt returns the value of the "updated_at" field in the mutation.
func (m *EventMutation) UpdatedAt() (r time.Time, exists bool) {
	v := m.updated_at
	if v == nil {
		return
	}
	return *v, true
}

// OldUpdatedAt returns the old "updated_at" field's value of the Event entity.
// If the Event object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *EventMutation) OldUpdatedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldUpdatedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldUpdatedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldUpdatedAt: %w", err)
	}
	return oldValue.UpdatedAt, nil
}

// ResetUpdatedAt resets all changes to the "updated_at" field.
func (m *EventMutation) ResetUpdatedAt() {
	m.updated_at = nil
}

// SetTime sets the "time" field.
func (m *EventMutation) SetTime(t time.Time) {
	m.time = &t
}

// Time returns the value of the "time" field in the mutation.
func (m *EventMutation) Time() (r time.Time, exists bool) {
	v := m.time
	if v == nil {
		return
	}
	return *v, true
}

// OldTime returns the old "time" field's value of the Event entity.
// If the Event object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *EventMutation) OldTime(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldTime is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldTime requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldTime: %w", err)
	}
	return oldValue.Time, nil
}

// ResetTime resets all changes to the "time" field.
func (m *EventMutation) ResetTime() {
	m.time = nil
}

// SetSerialized sets the "serialized" field.
func (m *EventMutation) SetSerialized(s string) {
	m.serialized = &s
}

// Serialized returns the value of the "serialized" field in the mutation.
func (m *EventMutation) Serialized() (r string, exists bool) {
	v := m.serialized
	if v == nil {
		return
	}
	return *v, true
}

// OldSerialized returns the old "serialized" field's value of the Event entity.
// If the Event object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *EventMutation) OldSerialized(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldSerialized is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldSerialized requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldSerialized: %w", err)
	}
	return oldValue.Serialized, nil
}

// ResetSerialized resets all changes to the "serialized" field.
func (m *EventMutation) ResetSerialized() {
	m.serialized = nil
}

// SetAlertEvents sets the "alert_events" field.
func (m *EventMutation) SetAlertEvents(i int) {
	m.owner = &i
}

// AlertEvents returns the value of the "alert_events" field in the mutation.
func (m *EventMutation) AlertEvents() (r int, exists bool) {
	v := m.owner
	if v == nil {
		return
	}
	return *v, true
}

// OldAlertEvents returns the old "alert_events" field's value of the Event entity.
// If the Event object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *EventMutation) OldAlertEvents(ctx context.Context) (v int, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldAlertEvents is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldAlertEvents requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldAlertEvents: %w", err)
	}
	return oldValue.AlertEvents, nil
}

// ClearAlertEvents clears the value of the "alert_events" field.
func (m *EventMutation) ClearAlertEvents() {
	m.owner = nil
	m.clearedFields[event.FieldAlertEvents] = struct{}{}
}

// AlertEventsCleared returns if the "alert_events" field was cleared in this mutation.
func (m *EventMutation) AlertEventsCleared() bool {
	_, ok := m.clearedFields[event.FieldAlertEvents]
	return ok
}

// ResetAlertEvents resets all changes to the "alert_events" field.
func (m *EventMutation) ResetAlertEvents() {
	m.owner = nil
	delete(m.clearedFields, event.FieldAlertEvents)
}

// SetOwnerID sets the "owner" edge to the Alert entity by id.
func (m *EventMutation) SetOwnerID(id int) {
	m.owner = &id
}

// ClearOwner clears the "owner" edge to the Alert entity.
func (m *EventMutation) ClearOwner() {
	m.clearedowner = true
	m.clearedFields[event.FieldAlertEvents] = struct{}{}
}

// OwnerCleared reports if the "owner" edge to the Alert entity was cleared.
func (m *EventMutation) OwnerCleared() bool {
	return m.AlertEventsCleared() || m.clearedowner
}

// OwnerID returns the "owner" edge ID in the mutation.
func (m *EventMutation) OwnerID() (id int, exists bool) {
	if m.owner != nil {
		return *m.owner, true
	}
	return
}

// OwnerIDs returns the "owner" edge IDs in the mutation.
// Note that IDs always returns len(IDs) <= 1 for unique edges, and you should use
// OwnerID instead. It exists only for internal usage by the builders.
func (m *EventMutation) OwnerIDs() (ids []int) {
	if id := m.owner; id != nil {
		ids = append(ids, *id)
	}
	return
}

// ResetOwner resets all changes to the "owner" edge.
func (m *EventMutation) ResetOwner() {
	m.owner = nil
	m.clearedowner = false
}

// Where appends a list predicates to the EventMutation builder.
func (m *EventMutation) Where(ps ...predicate.Event) {
	m.predicates = append(m.predicates, ps...)
}

// WhereP appends storage-level predicates to the EventMutation builder. Using this method,
// users can use type-assertion to append predicates that do not depend on any generated package.
func (m *EventMutation) WhereP(ps ...func(*sql.Selector)) {
	p := make([]predicate.Event, len(ps))
	for i := range ps {
		p[i] = ps[i]
	}
	m.Where(p...)
}

// Op returns the operation name.
func (m *EventMutation) Op() Op {
	return m.op
}

// SetOp allows setting the mutation operation.
func (m *EventMutation) SetOp(op Op) {
	m.op = op
}

// Type returns the node type of this mutation (Event).
func (m *EventMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *EventMutation) Fields() []string {
	fields := make([]string, 0, 5)
	if m.created_at != nil {
		fields = append(fields, event.FieldCreatedAt)
	}
	if m.updated_at != nil {
		fields = append(fields, event.FieldUpdatedAt)
	}
	if m.time != nil {
		fields = append(fields, event.FieldTime)
	}
	if m.serialized != nil {
		fields = append(fields, event.FieldSerialized)
	}
	if m.owner != nil {
		fields = append(fields, event.FieldAlertEvents)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *EventMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case event.FieldCreatedAt:
		return m.CreatedAt()
	case event.FieldUpdatedAt:
		return m.UpdatedAt()
	case event.FieldTime:
		return m.Time()
	case event.FieldSerialized:
		return m.Serialized()
	case event.FieldAlertEvents:
		return m.AlertEvents()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *EventMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case event.FieldCreatedAt:
		return m.OldCreatedAt(ctx)
	case event.FieldUpdatedAt:
		return m.OldUpdatedAt(ctx)
	case event.FieldTime:
		return m.OldTime(ctx)
	case event.FieldSerialized:
		return m.OldSerialized(ctx)
	case event.FieldAlertEvents:
		return m.OldAlertEvents(ctx)
	}
	return nil, fmt.Errorf("unknown Event field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *EventMutation) SetField(name string, value ent.Value) error {
	switch name {
	case event.FieldCreatedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetCreatedAt(v)
		return nil
	case event.FieldUpdatedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetUpdatedAt(v)
		return nil
	case event.FieldTime:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetTime(v)
		return nil
	case event.FieldSerialized:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetSerialized(v)
		return nil
	case event.FieldAlertEvents:
		v, ok := value.(int)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetAlertEvents(v)
		return nil
	}
	return fmt.Errorf("unknown Event field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *EventMutation) AddedFields() []string {
	var fields []string
	return fields
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *EventMutation) AddedField(name string) (ent.Value, bool) {
	switch name {
	}
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *EventMutation) AddField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown Event numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *EventMutation) ClearedFields() []string {
	var fields []string
	if m.FieldCleared(event.FieldAlertEvents) {
		fields = append(fields, event.FieldAlertEvents)
	}
	return fields
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *EventMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *EventMutation) ClearField(name string) error {
	switch name {
	case event.FieldAlertEvents:
		m.ClearAlertEvents()
		return nil
	}
	return fmt.Errorf("unknown Event nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *EventMutation) ResetField(name string) error {
	switch name {
	case event.FieldCreatedAt:
		m.ResetCreatedAt()
		return nil
	case event.FieldUpdatedAt:
		m.ResetUpdatedAt()
		return nil
	case event.FieldTime:
		m.ResetTime()
		return nil
	case event.FieldSerialized:
		m.ResetSerialized()
		return nil
	case event.FieldAlertEvents:
		m.ResetAlertEvents()
		return nil
	}
	return fmt.Errorf("unknown Event field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *EventMutation) AddedEdges() []string {
	edges := make([]string, 0, 1)
	if m.owner != nil {
		edges = append(edges, event.EdgeOwner)
	}
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *EventMutation) AddedIDs(name string) []ent.Value {
	switch name {
	case event.EdgeOwner:
		if id := m.owner; id != nil {
			return []ent.Value{*id}
		}
	}
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *EventMutation) RemovedEdges() []string {
	edges := make([]string, 0, 1)
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *EventMutation) RemovedIDs(name string) []ent.Value {
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *EventMutation) ClearedEdges() []string {
	edges := make([]string, 0, 1)
	if m.clearedowner {
		edges = append(edges, event.EdgeOwner)
	}
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *EventMutation) EdgeCleared(name string) bool {
	switch name {
	case event.EdgeOwner:
		return m.clearedowner
	}
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *EventMutation) ClearEdge(name string) error {
	switch name {
	case event.EdgeOwner:
		m.ClearOwner()
		return nil
	}
	return fmt.Errorf("unknown Event unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *EventMutation) ResetEdge(name string) error {
	switch name {
	case event.EdgeOwner:
		m.ResetOwner()
		return nil
	}
	return fmt.Errorf("unknown Event edge %s", name)
}

// LockMutation represents an operation that mutates the Lock nodes in the graph.
type LockMutation struct {
	config
	op            Op
	typ           string
	id            *int
	name          *string
	created_at    *time.Time
	clearedFields map[string]struct{}
	done          bool
	oldValue      func(context.Context) (*Lock, error)
	predicates    []predicate.Lock
}

var _ ent.Mutation = (*LockMutation)(nil)

// lockOption allows management of the mutation configuration using functional options.
type lockOption func(*LockMutation)

// newLockMutation creates new mutation for the Lock entity.
func newLockMutation(c config, op Op, opts ...lockOption) *LockMutation {
	m := &LockMutation{
		config:        c,
		op:            op,
		typ:           TypeLock,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withLockID sets the ID field of the mutation.
func withLockID(id int) lockOption {
	return func(m *LockMutation) {
		var (
			err   error
			once  sync.Once
			value *Lock
		)
		m.oldValue = func(ctx context.Context) (*Lock, error) {
			once.Do(func() {
				if m.done {
					err = errors.New("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().Lock.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withLock sets the old Lock of the mutation.
func withLock(node *Lock) lockOption {
	return func(m *LockMutation) {
		m.oldValue = func(context.Context) (*Lock, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m LockMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m LockMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, errors.New("ent: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *LockMutation) ID() (id int, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// IDs queries the database and returns the entity ids that match the mutation's predicate.
// That means, if the mutation is applied within a transaction with an isolation level such
// as sql.LevelSerializable, the returned ids match the ids of the rows that will be updated
// or updated by the mutation.
func (m *LockMutation) IDs(ctx context.Context) ([]int, error) {
	switch {
	case m.op.Is(OpUpdateOne | OpDeleteOne):
		id, exists := m.ID()
		if exists {
			return []int{id}, nil
		}
		fallthrough
	case m.op.Is(OpUpdate | OpDelete):
		return m.Client().Lock.Query().Where(m.predicates...).IDs(ctx)
	default:
		return nil, fmt.Errorf("IDs is not allowed on %s operations", m.op)
	}
}

// SetName sets the "name" field.
func (m *LockMutation) SetName(s string) {
	m.name = &s
}

// Name returns the value of the "name" field in the mutation.
func (m *LockMutation) Name() (r string, exists bool) {
	v := m.name
	if v == nil {
		return
	}
	return *v, true
}

// OldName returns the old "name" field's value of the Lock entity.
// If the Lock object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *LockMutation) OldName(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldName is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldName requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldName: %w", err)
	}
	return oldValue.Name, nil
}

// ResetName resets all changes to the "name" field.
func (m *LockMutation) ResetName() {
	m.name = nil
}

// SetCreatedAt sets the "created_at" field.
func (m *LockMutation) SetCreatedAt(t time.Time) {
	m.created_at = &t
}

// CreatedAt returns the value of the "created_at" field in the mutation.
func (m *LockMutation) CreatedAt() (r time.Time, exists bool) {
	v := m.created_at
	if v == nil {
		return
	}
	return *v, true
}

// OldCreatedAt returns the old "created_at" field's value of the Lock entity.
// If the Lock object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *LockMutation) OldCreatedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldCreatedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldCreatedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldCreatedAt: %w", err)
	}
	return oldValue.CreatedAt, nil
}

// ResetCreatedAt resets all changes to the "created_at" field.
func (m *LockMutation) ResetCreatedAt() {
	m.created_at = nil
}

// Where appends a list predicates to the LockMutation builder.
func (m *LockMutation) Where(ps ...predicate.Lock) {
	m.predicates = append(m.predicates, ps...)
}

// WhereP appends storage-level predicates to the LockMutation builder. Using this method,
// users can use type-assertion to append predicates that do not depend on any generated package.
func (m *LockMutation) WhereP(ps ...func(*sql.Selector)) {
	p := make([]predicate.Lock, len(ps))
	for i := range ps {
		p[i] = ps[i]
	}
	m.Where(p...)
}

// Op returns the operation name.
func (m *LockMutation) Op() Op {
	return m.op
}

// SetOp allows setting the mutation operation.
func (m *LockMutation) SetOp(op Op) {
	m.op = op
}

// Type returns the node type of this mutation (Lock).
func (m *LockMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *LockMutation) Fields() []string {
	fields := make([]string, 0, 2)
	if m.name != nil {
		fields = append(fields, lock.FieldName)
	}
	if m.created_at != nil {
		fields = append(fields, lock.FieldCreatedAt)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *LockMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case lock.FieldName:
		return m.Name()
	case lock.FieldCreatedAt:
		return m.CreatedAt()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *LockMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case lock.FieldName:
		return m.OldName(ctx)
	case lock.FieldCreatedAt:
		return m.OldCreatedAt(ctx)
	}
	return nil, fmt.Errorf("unknown Lock field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *LockMutation) SetField(name string, value ent.Value) error {
	switch name {
	case lock.FieldName:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetName(v)
		return nil
	case lock.FieldCreatedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetCreatedAt(v)
		return nil
	}
	return fmt.Errorf("unknown Lock field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *LockMutation) AddedFields() []string {
	return nil
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *LockMutation) AddedField(name string) (ent.Value, bool) {
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *LockMutation) AddField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown Lock numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *LockMutation) ClearedFields() []string {
	return nil
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *LockMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *LockMutation) ClearField(name string) error {
	return fmt.Errorf("unknown Lock nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *LockMutation) ResetField(name string) error {
	switch name {
	case lock.FieldName:
		m.ResetName()
		return nil
	case lock.FieldCreatedAt:
		m.ResetCreatedAt()
		return nil
	}
	return fmt.Errorf("unknown Lock field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *LockMutation) AddedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *LockMutation) AddedIDs(name string) []ent.Value {
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *LockMutation) RemovedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *LockMutation) RemovedIDs(name string) []ent.Value {
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *LockMutation) ClearedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *LockMutation) EdgeCleared(name string) bool {
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *LockMutation) ClearEdge(name string) error {
	return fmt.Errorf("unknown Lock unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *LockMutation) ResetEdge(name string) error {
	return fmt.Errorf("unknown Lock edge %s", name)
}

// MachineMutation represents an operation that mutates the Machine nodes in the graph.
type MachineMutation struct {
	config
	op             Op
	typ            string
	id             *int
	created_at     *time.Time
	updated_at     *time.Time
	last_push      *time.Time
	last_heartbeat *time.Time
	machineId      *string
	password       *string
	ipAddress      *string
	scenarios      *string
	version        *string
	isValidated    *bool
	auth_type      *string
	osname         *string
	osversion      *string
	featureflags   *string
	hubstate       *map[string][]schema.ItemState
	datasources    *map[string]int64
	clearedFields  map[string]struct{}
	alerts         map[int]struct{}
	removedalerts  map[int]struct{}
	clearedalerts  bool
	done           bool
	oldValue       func(context.Context) (*Machine, error)
	predicates     []predicate.Machine
}

var _ ent.Mutation = (*MachineMutation)(nil)

// machineOption allows management of the mutation configuration using functional options.
type machineOption func(*MachineMutation)

// newMachineMutation creates new mutation for the Machine entity.
func newMachineMutation(c config, op Op, opts ...machineOption) *MachineMutation {
	m := &MachineMutation{
		config:        c,
		op:            op,
		typ:           TypeMachine,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withMachineID sets the ID field of the mutation.
func withMachineID(id int) machineOption {
	return func(m *MachineMutation) {
		var (
			err   error
			once  sync.Once
			value *Machine
		)
		m.oldValue = func(ctx context.Context) (*Machine, error) {
			once.Do(func() {
				if m.done {
					err = errors.New("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().Machine.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withMachine sets the old Machine of the mutation.
func withMachine(node *Machine) machineOption {
	return func(m *MachineMutation) {
		m.oldValue = func(context.Context) (*Machine, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m MachineMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m MachineMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, errors.New("ent: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *MachineMutation) ID() (id int, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// IDs queries the database and returns the entity ids that match the mutation's predicate.
// That means, if the mutation is applied within a transaction with an isolation level such
// as sql.LevelSerializable, the returned ids match the ids of the rows that will be updated
// or updated by the mutation.
func (m *MachineMutation) IDs(ctx context.Context) ([]int, error) {
	switch {
	case m.op.Is(OpUpdateOne | OpDeleteOne):
		id, exists := m.ID()
		if exists {
			return []int{id}, nil
		}
		fallthrough
	case m.op.Is(OpUpdate | OpDelete):
		return m.Client().Machine.Query().Where(m.predicates...).IDs(ctx)
	default:
		return nil, fmt.Errorf("IDs is not allowed on %s operations", m.op)
	}
}

// SetCreatedAt sets the "created_at" field.
func (m *MachineMutation) SetCreatedAt(t time.Time) {
	m.created_at = &t
}

// CreatedAt returns the value of the "created_at" field in the mutation.
func (m *MachineMutation) CreatedAt() (r time.Time, exists bool) {
	v := m.created_at
	if v == nil {
		return
	}
	return *v, true
}

// OldCreatedAt returns the old "created_at" field's value of the Machine entity.
// If the Machine object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *MachineMutation) OldCreatedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldCreatedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldCreatedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldCreatedAt: %w", err)
	}
	return oldValue.CreatedAt, nil
}

// ResetCreatedAt resets all changes to the "created_at" field.
func (m *MachineMutation) ResetCreatedAt() {
	m.created_at = nil
}

// SetUpdatedAt sets the "updated_at" field.
func (m *MachineMutation) SetUpdatedAt(t time.Time) {
	m.updated_at = &t
}

// UpdatedAt returns the value of the "updated_at" field in the mutation.
func (m *MachineMutation) UpdatedAt() (r time.Time, exists bool) {
	v := m.updated_at
	if v == nil {
		return
	}
	return *v, true
}

// OldUpdatedAt returns the old "updated_at" field's value of the Machine entity.
// If the Machine object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *MachineMutation) OldUpdatedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldUpdatedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldUpdatedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldUpdatedAt: %w", err)
	}
	return oldValue.UpdatedAt, nil
}

// ResetUpdatedAt resets all changes to the "updated_at" field.
func (m *MachineMutation) ResetUpdatedAt() {
	m.updated_at = nil
}

// SetLastPush sets the "last_push" field.
func (m *MachineMutation) SetLastPush(t time.Time) {
	m.last_push = &t
}

// LastPush returns the value of the "last_push" field in the mutation.
func (m *MachineMutation) LastPush() (r time.Time, exists bool) {
	v := m.last_push
	if v == nil {
		return
	}
	return *v, true
}

// OldLastPush returns the old "last_push" field's value of the Machine entity.
// If the Machine object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *MachineMutation) OldLastPush(ctx context.Context) (v *time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldLastPush is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldLastPush requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldLastPush: %w", err)
	}
	return oldValue.LastPush, nil
}

// ClearLastPush clears the value of the "last_push" field.
func (m *MachineMutation) ClearLastPush() {
	m.last_push = nil
	m.clearedFields[machine.FieldLastPush] = struct{}{}
}

// LastPushCleared returns if the "last_push" field was cleared in this mutation.
func (m *MachineMutation) LastPushCleared() bool {
	_, ok := m.clearedFields[machine.FieldLastPush]
	return ok
}

// ResetLastPush resets all changes to the "last_push" field.
func (m *MachineMutation) ResetLastPush() {
	m.last_push = nil
	delete(m.clearedFields, machine.FieldLastPush)
}

// SetLastHeartbeat sets the "last_heartbeat" field.
func (m *MachineMutation) SetLastHeartbeat(t time.Time) {
	m.last_heartbeat = &t
}

// LastHeartbeat returns the value of the "last_heartbeat" field in the mutation.
func (m *MachineMutation) LastHeartbeat() (r time.Time, exists bool) {
	v := m.last_heartbeat
	if v == nil {
		return
	}
	return *v, true
}

// OldLastHeartbeat returns the old "last_heartbeat" field's value of the Machine entity.
// If the Machine object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *MachineMutation) OldLastHeartbeat(ctx context.Context) (v *time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldLastHeartbeat is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldLastHeartbeat requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldLastHeartbeat: %w", err)
	}
	return oldValue.LastHeartbeat, nil
}

// ClearLastHeartbeat clears the value of the "last_heartbeat" field.
func (m *MachineMutation) ClearLastHeartbeat() {
	m.last_heartbeat = nil
	m.clearedFields[machine.FieldLastHeartbeat] = struct{}{}
}

// LastHeartbeatCleared returns if the "last_heartbeat" field was cleared in this mutation.
func (m *MachineMutation) LastHeartbeatCleared() bool {
	_, ok := m.clearedFields[machine.FieldLastHeartbeat]
	return ok
}

// ResetLastHeartbeat resets all changes to the "last_heartbeat" field.
func (m *MachineMutation) ResetLastHeartbeat() {
	m.last_heartbeat = nil
	delete(m.clearedFields, machine.FieldLastHeartbeat)
}

// SetMachineId sets the "machineId" field.
func (m *MachineMutation) SetMachineId(s string) {
	m.machineId = &s
}

// MachineId returns the value of the "machineId" field in the mutation.
func (m *MachineMutation) MachineId() (r string, exists bool) {
	v := m.machineId
	if v == nil {
		return
	}
	return *v, true
}

// OldMachineId returns the old "machineId" field's value of the Machine entity.
// If the Machine object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *MachineMutation) OldMachineId(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldMachineId is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldMachineId requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldMachineId: %w", err)
	}
	return oldValue.MachineId, nil
}

// ResetMachineId resets all changes to the "machineId" field.
func (m *MachineMutation) ResetMachineId() {
	m.machineId = nil
}

// SetPassword sets the "password" field.
func (m *MachineMutation) SetPassword(s string) {
	m.password = &s
}

// Password returns the value of the "password" field in the mutation.
func (m *MachineMutation) Password() (r string, exists bool) {
	v := m.password
	if v == nil {
		return
	}
	return *v, true
}

// OldPassword returns the old "password" field's value of the Machine entity.
// If the Machine object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *MachineMutation) OldPassword(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldPassword is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldPassword requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldPassword: %w", err)
	}
	return oldValue.Password, nil
}

// ResetPassword resets all changes to the "password" field.
func (m *MachineMutation) ResetPassword() {
	m.password = nil
}

// SetIpAddress sets the "ipAddress" field.
func (m *MachineMutation) SetIpAddress(s string) {
	m.ipAddress = &s
}

// IpAddress returns the value of the "ipAddress" field in the mutation.
func (m *MachineMutation) IpAddress() (r string, exists bool) {
	v := m.ipAddress
	if v == nil {
		return
	}
	return *v, true
}

// OldIpAddress returns the old "ipAddress" field's value of the Machine entity.
// If the Machine object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *MachineMutation) OldIpAddress(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldIpAddress is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldIpAddress requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldIpAddress: %w", err)
	}
	return oldValue.IpAddress, nil
}

// ResetIpAddress resets all changes to the "ipAddress" field.
func (m *MachineMutation) ResetIpAddress() {
	m.ipAddress = nil
}

// SetScenarios sets the "scenarios" field.
func (m *MachineMutation) SetScenarios(s string) {
	m.scenarios = &s
}

// Scenarios returns the value of the "scenarios" field in the mutation.
func (m *MachineMutation) Scenarios() (r string, exists bool) {
	v := m.scenarios
	if v == nil {
		return
	}
	return *v, true
}

// OldScenarios returns the old "scenarios" field's value of the Machine entity.
// If the Machine object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *MachineMutation) OldScenarios(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldScenarios is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldScenarios requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldScenarios: %w", err)
	}
	return oldValue.Scenarios, nil
}

// ClearScenarios clears the value of the "scenarios" field.
func (m *MachineMutation) ClearScenarios() {
	m.scenarios = nil
	m.clearedFields[machine.FieldScenarios] = struct{}{}
}

// ScenariosCleared returns if the "scenarios" field was cleared in this mutation.
func (m *MachineMutation) ScenariosCleared() bool {
	_, ok := m.clearedFields[machine.FieldScenarios]
	return ok
}

// ResetScenarios resets all changes to the "scenarios" field.
func (m *MachineMutation) ResetScenarios() {
	m.scenarios = nil
	delete(m.clearedFields, machine.FieldScenarios)
}

// SetVersion sets the "version" field.
func (m *MachineMutation) SetVersion(s string) {
	m.version = &s
}

// Version returns the value of the "version" field in the mutation.
func (m *MachineMutation) Version() (r string, exists bool) {
	v := m.version
	if v == nil {
		return
	}
	return *v, true
}

// OldVersion returns the old "version" field's value of the Machine entity.
// If the Machine object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *MachineMutation) OldVersion(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldVersion is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldVersion requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldVersion: %w", err)
	}
	return oldValue.Version, nil
}

// ClearVersion clears the value of the "version" field.
func (m *MachineMutation) ClearVersion() {
	m.version = nil
	m.clearedFields[machine.FieldVersion] = struct{}{}
}

// VersionCleared returns if the "version" field was cleared in this mutation.
func (m *MachineMutation) VersionCleared() bool {
	_, ok := m.clearedFields[machine.FieldVersion]
	return ok
}

// ResetVersion resets all changes to the "version" field.
func (m *MachineMutation) ResetVersion() {
	m.version = nil
	delete(m.clearedFields, machine.FieldVersion)
}

// SetIsValidated sets the "isValidated" field.
func (m *MachineMutation) SetIsValidated(b bool) {
	m.isValidated = &b
}

// IsValidated returns the value of the "isValidated" field in the mutation.
func (m *MachineMutation) IsValidated() (r bool, exists bool) {
	v := m.isValidated
	if v == nil {
		return
	}
	return *v, true
}

// OldIsValidated returns the old "isValidated" field's value of the Machine entity.
// If the Machine object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *MachineMutation) OldIsValidated(ctx context.Context) (v bool, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldIsValidated is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldIsValidated requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldIsValidated: %w", err)
	}
	return oldValue.IsValidated, nil
}

// ResetIsValidated resets all changes to the "isValidated" field.
func (m *MachineMutation) ResetIsValidated() {
	m.isValidated = nil
}

// SetAuthType sets the "auth_type" field.
func (m *MachineMutation) SetAuthType(s string) {
	m.auth_type = &s
}

// AuthType returns the value of the "auth_type" field in the mutation.
func (m *MachineMutation) AuthType() (r string, exists bool) {
	v := m.auth_type
	if v == nil {
		return
	}
	return *v, true
}

// OldAuthType returns the old "auth_type" field's value of the Machine entity.
// If the Machine object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *MachineMutation) OldAuthType(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldAuthType is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldAuthType requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldAuthType: %w", err)
	}
	return oldValue.AuthType, nil
}

// ResetAuthType resets all changes to the "auth_type" field.
func (m *MachineMutation) ResetAuthType() {
	m.auth_type = nil
}

// SetOsname sets the "osname" field.
func (m *MachineMutation) SetOsname(s string) {
	m.osname = &s
}

// Osname returns the value of the "osname" field in the mutation.
func (m *MachineMutation) Osname() (r string, exists bool) {
	v := m.osname
	if v == nil {
		return
	}
	return *v, true
}

// OldOsname returns the old "osname" field's value of the Machine entity.
// If the Machine object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *MachineMutation) OldOsname(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldOsname is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldOsname requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldOsname: %w", err)
	}
	return oldValue.Osname, nil
}

// ClearOsname clears the value of the "osname" field.
func (m *MachineMutation) ClearOsname() {
	m.osname = nil
	m.clearedFields[machine.FieldOsname] = struct{}{}
}

// OsnameCleared returns if the "osname" field was cleared in this mutation.
func (m *MachineMutation) OsnameCleared() bool {
	_, ok := m.clearedFields[machine.FieldOsname]
	return ok
}

// ResetOsname resets all changes to the "osname" field.
func (m *MachineMutation) ResetOsname() {
	m.osname = nil
	delete(m.clearedFields, machine.FieldOsname)
}

// SetOsversion sets the "osversion" field.
func (m *MachineMutation) SetOsversion(s string) {
	m.osversion = &s
}

// Osversion returns the value of the "osversion" field in the mutation.
func (m *MachineMutation) Osversion() (r string, exists bool) {
	v := m.osversion
	if v == nil {
		return
	}
	return *v, true
}

// OldOsversion returns the old "osversion" field's value of the Machine entity.
// If the Machine object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *MachineMutation) OldOsversion(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldOsversion is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldOsversion requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldOsversion: %w", err)
	}
	return oldValue.Osversion, nil
}

// ClearOsversion clears the value of the "osversion" field.
func (m *MachineMutation) ClearOsversion() {
	m.osversion = nil
	m.clearedFields[machine.FieldOsversion] = struct{}{}
}

// OsversionCleared returns if the "osversion" field was cleared in this mutation.
func (m *MachineMutation) OsversionCleared() bool {
	_, ok := m.clearedFields[machine.FieldOsversion]
	return ok
}

// ResetOsversion resets all changes to the "osversion" field.
func (m *MachineMutation) ResetOsversion() {
	m.osversion = nil
	delete(m.clearedFields, machine.FieldOsversion)
}

// SetFeatureflags sets the "featureflags" field.
func (m *MachineMutation) SetFeatureflags(s string) {
	m.featureflags = &s
}

// Featureflags returns the value of the "featureflags" field in the mutation.
func (m *MachineMutation) Featureflags() (r string, exists bool) {
	v := m.featureflags
	if v == nil {
		return
	}
	return *v, true
}

// OldFeatureflags returns the old "featureflags" field's value of the Machine entity.
// If the Machine object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *MachineMutation) OldFeatureflags(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldFeatureflags is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldFeatureflags requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldFeatureflags: %w", err)
	}
	return oldValue.Featureflags, nil
}

// ClearFeatureflags clears the value of the "featureflags" field.
func (m *MachineMutation) ClearFeatureflags() {
	m.featureflags = nil
	m.clearedFields[machine.FieldFeatureflags] = struct{}{}
}

// FeatureflagsCleared returns if the "featureflags" field was cleared in this mutation.
func (m *MachineMutation) FeatureflagsCleared() bool {
	_, ok := m.clearedFields[machine.FieldFeatureflags]
	return ok
}

// ResetFeatureflags resets all changes to the "featureflags" field.
func (m *MachineMutation) ResetFeatureflags() {
	m.featureflags = nil
	delete(m.clearedFields, machine.FieldFeatureflags)
}

// SetHubstate sets the "hubstate" field.
func (m *MachineMutation) SetHubstate(ms map[string][]schema.ItemState) {
	m.hubstate = &ms
}

// Hubstate returns the value of the "hubstate" field in the mutation.
func (m *MachineMutation) Hubstate() (r map[string][]schema.ItemState, exists bool) {
	v := m.hubstate
	if v == nil {
		return
	}
	return *v, true
}

// OldHubstate returns the old "hubstate" field's value of the Machine entity.
// If the Machine object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *MachineMutation) OldHubstate(ctx context.Context) (v map[string][]schema.ItemState, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldHubstate is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldHubstate requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldHubstate: %w", err)
	}
	return oldValue.Hubstate, nil
}

// ClearHubstate clears the value of the "hubstate" field.
func (m *MachineMutation) ClearHubstate() {
	m.hubstate = nil
	m.clearedFields[machine.FieldHubstate] = struct{}{}
}

// HubstateCleared returns if the "hubstate" field was cleared in this mutation.
func (m *MachineMutation) HubstateCleared() bool {
	_, ok := m.clearedFields[machine.FieldHubstate]
	return ok
}

// ResetHubstate resets all changes to the "hubstate" field.
func (m *MachineMutation) ResetHubstate() {
	m.hubstate = nil
	delete(m.clearedFields, machine.FieldHubstate)
}

// SetDatasources sets the "datasources" field.
func (m *MachineMutation) SetDatasources(value map[string]int64) {
	m.datasources = &value
}

// Datasources returns the value of the "datasources" field in the mutation.
func (m *MachineMutation) Datasources() (r map[string]int64, exists bool) {
	v := m.datasources
	if v == nil {
		return
	}
	return *v, true
}

// OldDatasources returns the old "datasources" field's value of the Machine entity.
// If the Machine object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *MachineMutation) OldDatasources(ctx context.Context) (v map[string]int64, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldDatasources is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldDatasources requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldDatasources: %w", err)
	}
	return oldValue.Datasources, nil
}

// ClearDatasources clears the value of the "datasources" field.
func (m *MachineMutation) ClearDatasources() {
	m.datasources = nil
	m.clearedFields[machine.FieldDatasources] = struct{}{}
}

// DatasourcesCleared returns if the "datasources" field was cleared in this mutation.
func (m *MachineMutation) DatasourcesCleared() bool {
	_, ok := m.clearedFields[machine.FieldDatasources]
	return ok
}

// ResetDatasources resets all changes to the "datasources" field.
func (m *MachineMutation) ResetDatasources() {
	m.datasources = nil
	delete(m.clearedFields, machine.FieldDatasources)
}

// AddAlertIDs adds the "alerts" edge to the Alert entity by ids.
func (m *MachineMutation) AddAlertIDs(ids ...int) {
	if m.alerts == nil {
		m.alerts = make(map[int]struct{})
	}
	for i := range ids {
		m.alerts[ids[i]] = struct{}{}
	}
}

// ClearAlerts clears the "alerts" edge to the Alert entity.
func (m *MachineMutation) ClearAlerts() {
	m.clearedalerts = true
}

// AlertsCleared reports if the "alerts" edge to the Alert entity was cleared.
func (m *MachineMutation) AlertsCleared() bool {
	return m.clearedalerts
}

// RemoveAlertIDs removes the "alerts" edge to the Alert entity by IDs.
func (m *MachineMutation) RemoveAlertIDs(ids ...int) {
	if m.removedalerts == nil {
		m.removedalerts = make(map[int]struct{})
	}
	for i := range ids {
		delete(m.alerts, ids[i])
		m.removedalerts[ids[i]] = struct{}{}
	}
}

// RemovedAlerts returns the removed IDs of the "alerts" edge to the Alert entity.
func (m *MachineMutation) RemovedAlertsIDs() (ids []int) {
	for id := range m.removedalerts {
		ids = append(ids, id)
	}
	return
}

// AlertsIDs returns the "alerts" edge IDs in the mutation.
func (m *MachineMutation) AlertsIDs() (ids []int) {
	for id := range m.alerts {
		ids = append(ids, id)
	}
	return
}

// ResetAlerts resets all changes to the "alerts" edge.
func (m *MachineMutation) ResetAlerts() {
	m.alerts = nil
	m.clearedalerts = false
	m.removedalerts = nil
}

// Where appends a list predicates to the MachineMutation builder.
func (m *MachineMutation) Where(ps ...predicate.Machine) {
	m.predicates = append(m.predicates, ps...)
}

// WhereP appends storage-level predicates to the MachineMutation builder. Using this method,
// users can use type-assertion to append predicates that do not depend on any generated package.
func (m *MachineMutation) WhereP(ps ...func(*sql.Selector)) {
	p := make([]predicate.Machine, len(ps))
	for i := range ps {
		p[i] = ps[i]
	}
	m.Where(p...)
}

// Op returns the operation name.
func (m *MachineMutation) Op() Op {
	return m.op
}

// SetOp allows setting the mutation operation.
func (m *MachineMutation) SetOp(op Op) {
	m.op = op
}

// Type returns the node type of this mutation (Machine).
func (m *MachineMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *MachineMutation) Fields() []string {
	fields := make([]string, 0, 16)
	if m.created_at != nil {
		fields = append(fields, machine.FieldCreatedAt)
	}
	if m.updated_at != nil {
		fields = append(fields, machine.FieldUpdatedAt)
	}
	if m.last_push != nil {
		fields = append(fields, machine.FieldLastPush)
	}
	if m.last_heartbeat != nil {
		fields = append(fields, machine.FieldLastHeartbeat)
	}
	if m.machineId != nil {
		fields = append(fields, machine.FieldMachineId)
	}
	if m.password != nil {
		fields = append(fields, machine.FieldPassword)
	}
	if m.ipAddress != nil {
		fields = append(fields, machine.FieldIpAddress)
	}
	if m.scenarios != nil {
		fields = append(fields, machine.FieldScenarios)
	}
	if m.version != nil {
		fields = append(fields, machine.FieldVersion)
	}
	if m.isValidated != nil {
		fields = append(fields, machine.FieldIsValidated)
	}
	if m.auth_type != nil {
		fields = append(fields, machine.FieldAuthType)
	}
	if m.osname != nil {
		fields = append(fields, machine.FieldOsname)
	}
	if m.osversion != nil {
		fields = append(fields, machine.FieldOsversion)
	}
	if m.featureflags != nil {
		fields = append(fields, machine.FieldFeatureflags)
	}
	if m.hubstate != nil {
		fields = append(fields, machine.FieldHubstate)
	}
	if m.datasources != nil {
		fields = append(fields, machine.FieldDatasources)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *MachineMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case machine.FieldCreatedAt:
		return m.CreatedAt()
	case machine.FieldUpdatedAt:
		return m.UpdatedAt()
	case machine.FieldLastPush:
		return m.LastPush()
	case machine.FieldLastHeartbeat:
		return m.LastHeartbeat()
	case machine.FieldMachineId:
		return m.MachineId()
	case machine.FieldPassword:
		return m.Password()
	case machine.FieldIpAddress:
		return m.IpAddress()
	case machine.FieldScenarios:
		return m.Scenarios()
	case machine.FieldVersion:
		return m.Version()
	case machine.FieldIsValidated:
		return m.IsValidated()
	case machine.FieldAuthType:
		return m.AuthType()
	case machine.FieldOsname:
		return m.Osname()
	case machine.FieldOsversion:
		return m.Osversion()
	case machine.FieldFeatureflags:
		return m.Featureflags()
	case machine.FieldHubstate:
		return m.Hubstate()
	case machine.FieldDatasources:
		return m.Datasources()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *MachineMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case machine.FieldCreatedAt:
		return m.OldCreatedAt(ctx)
	case machine.FieldUpdatedAt:
		return m.OldUpdatedAt(ctx)
	case machine.FieldLastPush:
		return m.OldLastPush(ctx)
	case machine.FieldLastHeartbeat:
		return m.OldLastHeartbeat(ctx)
	case machine.FieldMachineId:
		return m.OldMachineId(ctx)
	case machine.FieldPassword:
		return m.OldPassword(ctx)
	case machine.FieldIpAddress:
		return m.OldIpAddress(ctx)
	case machine.FieldScenarios:
		return m.OldScenarios(ctx)
	case machine.FieldVersion:
		return m.OldVersion(ctx)
	case machine.FieldIsValidated:
		return m.OldIsValidated(ctx)
	case machine.FieldAuthType:
		return m.OldAuthType(ctx)
	case machine.FieldOsname:
		return m.OldOsname(ctx)
	case machine.FieldOsversion:
		return m.OldOsversion(ctx)
	case machine.FieldFeatureflags:
		return m.OldFeatureflags(ctx)
	case machine.FieldHubstate:
		return m.OldHubstate(ctx)
	case machine.FieldDatasources:
		return m.OldDatasources(ctx)
	}
	return nil, fmt.Errorf("unknown Machine field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *MachineMutation) SetField(name string, value ent.Value) error {
	switch name {
	case machine.FieldCreatedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetCreatedAt(v)
		return nil
	case machine.FieldUpdatedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetUpdatedAt(v)
		return nil
	case machine.FieldLastPush:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetLastPush(v)
		return nil
	case machine.FieldLastHeartbeat:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetLastHeartbeat(v)
		return nil
	case machine.FieldMachineId:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetMachineId(v)
		return nil
	case machine.FieldPassword:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetPassword(v)
		return nil
	case machine.FieldIpAddress:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetIpAddress(v)
		return nil
	case machine.FieldScenarios:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetScenarios(v)
		return nil
	case machine.FieldVersion:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetVersion(v)
		return nil
	case machine.FieldIsValidated:
		v, ok := value.(bool)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetIsValidated(v)
		return nil
	case machine.FieldAuthType:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetAuthType(v)
		return nil
	case machine.FieldOsname:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetOsname(v)
		return nil
	case machine.FieldOsversion:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetOsversion(v)
		return nil
	case machine.FieldFeatureflags:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetFeatureflags(v)
		return nil
	case machine.FieldHubstate:
		v, ok := value.(map[string][]schema.ItemState)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetHubstate(v)
		return nil
	case machine.FieldDatasources:
		v, ok := value.(map[string]int64)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetDatasources(v)
		return nil
	}
	return fmt.Errorf("unknown Machine field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *MachineMutation) AddedFields() []string {
	return nil
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *MachineMutation) AddedField(name string) (ent.Value, bool) {
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *MachineMutation) AddField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown Machine numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *MachineMutation) ClearedFields() []string {
	var fields []string
	if m.FieldCleared(machine.FieldLastPush) {
		fields = append(fields, machine.FieldLastPush)
	}
	if m.FieldCleared(machine.FieldLastHeartbeat) {
		fields = append(fields, machine.FieldLastHeartbeat)
	}
	if m.FieldCleared(machine.FieldScenarios) {
		fields = append(fields, machine.FieldScenarios)
	}
	if m.FieldCleared(machine.FieldVersion) {
		fields = append(fields, machine.FieldVersion)
	}
	if m.FieldCleared(machine.FieldOsname) {
		fields = append(fields, machine.FieldOsname)
	}
	if m.FieldCleared(machine.FieldOsversion) {
		fields = append(fields, machine.FieldOsversion)
	}
	if m.FieldCleared(machine.FieldFeatureflags) {
		fields = append(fields, machine.FieldFeatureflags)
	}
	if m.FieldCleared(machine.FieldHubstate) {
		fields = append(fields, machine.FieldHubstate)
	}
	if m.FieldCleared(machine.FieldDatasources) {
		fields = append(fields, machine.FieldDatasources)
	}
	return fields
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *MachineMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *MachineMutation) ClearField(name string) error {
	switch name {
	case machine.FieldLastPush:
		m.ClearLastPush()
		return nil
	case machine.FieldLastHeartbeat:
		m.ClearLastHeartbeat()
		return nil
	case machine.FieldScenarios:
		m.ClearScenarios()
		return nil
	case machine.FieldVersion:
		m.ClearVersion()
		return nil
	case machine.FieldOsname:
		m.ClearOsname()
		return nil
	case machine.FieldOsversion:
		m.ClearOsversion()
		return nil
	case machine.FieldFeatureflags:
		m.ClearFeatureflags()
		return nil
	case machine.FieldHubstate:
		m.ClearHubstate()
		return nil
	case machine.FieldDatasources:
		m.ClearDatasources()
		return nil
	}
	return fmt.Errorf("unknown Machine nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *MachineMutation) ResetField(name string) error {
	switch name {
	case machine.FieldCreatedAt:
		m.ResetCreatedAt()
		return nil
	case machine.FieldUpdatedAt:
		m.ResetUpdatedAt()
		return nil
	case machine.FieldLastPush:
		m.ResetLastPush()
		return nil
	case machine.FieldLastHeartbeat:
		m.ResetLastHeartbeat()
		return nil
	case machine.FieldMachineId:
		m.ResetMachineId()
		return nil
	case machine.FieldPassword:
		m.ResetPassword()
		return nil
	case machine.FieldIpAddress:
		m.ResetIpAddress()
		return nil
	case machine.FieldScenarios:
		m.ResetScenarios()
		return nil
	case machine.FieldVersion:
		m.ResetVersion()
		return nil
	case machine.FieldIsValidated:
		m.ResetIsValidated()
		return nil
	case machine.FieldAuthType:
		m.ResetAuthType()
		return nil
	case machine.FieldOsname:
		m.ResetOsname()
		return nil
	case machine.FieldOsversion:
		m.ResetOsversion()
		return nil
	case machine.FieldFeatureflags:
		m.ResetFeatureflags()
		return nil
	case machine.FieldHubstate:
		m.ResetHubstate()
		return nil
	case machine.FieldDatasources:
		m.ResetDatasources()
		return nil
	}
	return fmt.Errorf("unknown Machine field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *MachineMutation) AddedEdges() []string {
	edges := make([]string, 0, 1)
	if m.alerts != nil {
		edges = append(edges, machine.EdgeAlerts)
	}
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *MachineMutation) AddedIDs(name string) []ent.Value {
	switch name {
	case machine.EdgeAlerts:
		ids := make([]ent.Value, 0, len(m.alerts))
		for id := range m.alerts {
			ids = append(ids, id)
		}
		return ids
	}
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *MachineMutation) RemovedEdges() []string {
	edges := make([]string, 0, 1)
	if m.removedalerts != nil {
		edges = append(edges, machine.EdgeAlerts)
	}
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *MachineMutation) RemovedIDs(name string) []ent.Value {
	switch name {
	case machine.EdgeAlerts:
		ids := make([]ent.Value, 0, len(m.removedalerts))
		for id := range m.removedalerts {
			ids = append(ids, id)
		}
		return ids
	}
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *MachineMutation) ClearedEdges() []string {
	edges := make([]string, 0, 1)
	if m.clearedalerts {
		edges = append(edges, machine.EdgeAlerts)
	}
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *MachineMutation) EdgeCleared(name string) bool {
	switch name {
	case machine.EdgeAlerts:
		return m.clearedalerts
	}
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *MachineMutation) ClearEdge(name string) error {
	switch name {
	}
	return fmt.Errorf("unknown Machine unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *MachineMutation) ResetEdge(name string) error {
	switch name {
	case machine.EdgeAlerts:
		m.ResetAlerts()
		return nil
	}
	return fmt.Errorf("unknown Machine edge %s", name)
}

// MetaMutation represents an operation that mutates the Meta nodes in the graph.
type MetaMutation struct {
	config
	op            Op
	typ           string
	id            *int
	created_at    *time.Time
	updated_at    *time.Time
	key           *string
	value         *string
	clearedFields map[string]struct{}
	owner         *int
	clearedowner  bool
	done          bool
	oldValue      func(context.Context) (*Meta, error)
	predicates    []predicate.Meta
}

var _ ent.Mutation = (*MetaMutation)(nil)

// metaOption allows management of the mutation configuration using functional options.
type metaOption func(*MetaMutation)

// newMetaMutation creates new mutation for the Meta entity.
func newMetaMutation(c config, op Op, opts ...metaOption) *MetaMutation {
	m := &MetaMutation{
		config:        c,
		op:            op,
		typ:           TypeMeta,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withMetaID sets the ID field of the mutation.
func withMetaID(id int) metaOption {
	return func(m *MetaMutation) {
		var (
			err   error
			once  sync.Once
			value *Meta
		)
		m.oldValue = func(ctx context.Context) (*Meta, error) {
			once.Do(func() {
				if m.done {
					err = errors.New("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().Meta.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withMeta sets the old Meta of the mutation.
func withMeta(node *Meta) metaOption {
	return func(m *MetaMutation) {
		m.oldValue = func(context.Context) (*Meta, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m MetaMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m MetaMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, errors.New("ent: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *MetaMutation) ID() (id int, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// IDs queries the database and returns the entity ids that match the mutation's predicate.
// That means, if the mutation is applied within a transaction with an isolation level such
// as sql.LevelSerializable, the returned ids match the ids of the rows that will be updated
// or updated by the mutation.
func (m *MetaMutation) IDs(ctx context.Context) ([]int, error) {
	switch {
	case m.op.Is(OpUpdateOne | OpDeleteOne):
		id, exists := m.ID()
		if exists {
			return []int{id}, nil
		}
		fallthrough
	case m.op.Is(OpUpdate | OpDelete):
		return m.Client().Meta.Query().Where(m.predicates...).IDs(ctx)
	default:
		return nil, fmt.Errorf("IDs is not allowed on %s operations", m.op)
	}
}

// SetCreatedAt sets the "created_at" field.
func (m *MetaMutation) SetCreatedAt(t time.Time) {
	m.created_at = &t
}

// CreatedAt returns the value of the "created_at" field in the mutation.
func (m *MetaMutation) CreatedAt() (r time.Time, exists bool) {
	v := m.created_at
	if v == nil {
		return
	}
	return *v, true
}

// OldCreatedAt returns the old "created_at" field's value of the Meta entity.
// If the Meta object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *MetaMutation) OldCreatedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldCreatedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldCreatedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldCreatedAt: %w", err)
	}
	return oldValue.CreatedAt, nil
}

// ResetCreatedAt resets all changes to the "created_at" field.
func (m *MetaMutation) ResetCreatedAt() {
	m.created_at = nil
}

// SetUpdatedAt sets the "updated_at" field.
func (m *MetaMutation) SetUpdatedAt(t time.Time) {
	m.updated_at = &t
}

// UpdatedAt returns the value of the "updated_at" field in the mutation.
func (m *MetaMutation) UpdatedAt() (r time.Time, exists bool) {
	v := m.updated_at
	if v == nil {
		return
	}
	return *v, true
}

// OldUpdatedAt returns the old "updated_at" field's value of the Meta entity.
// If the Meta object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *MetaMutation) OldUpdatedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldUpdatedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldUpdatedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldUpdatedAt: %w", err)
	}
	return oldValue.UpdatedAt, nil
}

// ResetUpdatedAt resets all changes to the "updated_at" field.
func (m *MetaMutation) ResetUpdatedAt() {
	m.updated_at = nil
}

// SetKey sets the "key" field.
func (m *MetaMutation) SetKey(s string) {
	m.key = &s
}

// Key returns the value of the "key" field in the mutation.
func (m *MetaMutation) Key() (r string, exists bool) {
	v := m.key
	if v == nil {
		return
	}
	return *v, true
}

// OldKey returns the old "key" field's value of the Meta entity.
// If the Meta object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *MetaMutation) OldKey(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldKey is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldKey requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldKey: %w", err)
	}
	return oldValue.Key, nil
}

// ResetKey resets all changes to the "key" field.
func (m *MetaMutation) ResetKey() {
	m.key = nil
}

// SetValue sets the "value" field.
func (m *MetaMutation) SetValue(s string) {
	m.value = &s
}

// Value returns the value of the "value" field in the mutation.
func (m *MetaMutation) Value() (r string, exists bool) {
	v := m.value
	if v == nil {
		return
	}
	return *v, true
}

// OldValue returns the old "value" field's value of the Meta entity.
// If the Meta object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *MetaMutation) OldValue(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldValue is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldValue requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldValue: %w", err)
	}
	return oldValue.Value, nil
}

// ResetValue resets all changes to the "value" field.
func (m *MetaMutation) ResetValue() {
	m.value = nil
}

// SetAlertMetas sets the "alert_metas" field.
func (m *MetaMutation) SetAlertMetas(i int) {
	m.owner = &i
}

// AlertMetas returns the value of the "alert_metas" field in the mutation.
func (m *MetaMutation) AlertMetas() (r int, exists bool) {
	v := m.owner
	if v == nil {
		return
	}
	return *v, true
}

// OldAlertMetas returns the old "alert_metas" field's value of the Meta entity.
// If the Meta object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *MetaMutation) OldAlertMetas(ctx context.Context) (v int, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldAlertMetas is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldAlertMetas requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldAlertMetas: %w", err)
	}
	return oldValue.AlertMetas, nil
}

// ClearAlertMetas clears the value of the "alert_metas" field.
func (m *MetaMutation) ClearAlertMetas() {
	m.owner = nil
	m.clearedFields[meta.FieldAlertMetas] = struct{}{}
}

// AlertMetasCleared returns if the "alert_metas" field was cleared in this mutation.
func (m *MetaMutation) AlertMetasCleared() bool {
	_, ok := m.clearedFields[meta.FieldAlertMetas]
	return ok
}

// ResetAlertMetas resets all changes to the "alert_metas" field.
func (m *MetaMutation) ResetAlertMetas() {
	m.owner = nil
	delete(m.clearedFields, meta.FieldAlertMetas)
}

// SetOwnerID sets the "owner" edge to the Alert entity by id.
func (m *MetaMutation) SetOwnerID(id int) {
	m.owner = &id
}

// ClearOwner clears the "owner" edge to the Alert entity.
func (m *MetaMutation) ClearOwner() {
	m.clearedowner = true
	m.clearedFields[meta.FieldAlertMetas] = struct{}{}
}

// OwnerCleared reports if the "owner" edge to the Alert entity was cleared.
func (m *MetaMutation) OwnerCleared() bool {
	return m.AlertMetasCleared() || m.clearedowner
}

// OwnerID returns the "owner" edge ID in the mutation.
func (m *MetaMutation) OwnerID() (id int, exists bool) {
	if m.owner != nil {
		return *m.owner, true
	}
	return
}

// OwnerIDs returns the "owner" edge IDs in the mutation.
// Note that IDs always returns len(IDs) <= 1 for unique edges, and you should use
// OwnerID instead. It exists only for internal usage by the builders.
func (m *MetaMutation) OwnerIDs() (ids []int) {
	if id := m.owner; id != nil {
		ids = append(ids, *id)
	}
	return
}

// ResetOwner resets all changes to the "owner" edge.
func (m *MetaMutation) ResetOwner() {
	m.owner = nil
	m.clearedowner = false
}

// Where appends a list predicates to the MetaMutation builder.
func (m *MetaMutation) Where(ps ...predicate.Meta) {
	m.predicates = append(m.predicates, ps...)
}

// WhereP appends storage-level predicates to the MetaMutation builder. Using this method,
// users can use type-assertion to append predicates that do not depend on any generated package.
func (m *MetaMutation) WhereP(ps ...func(*sql.Selector)) {
	p := make([]predicate.Meta, len(ps))
	for i := range ps {
		p[i] = ps[i]
	}
	m.Where(p...)
}

// Op returns the operation name.
func (m *MetaMutation) Op() Op {
	return m.op
}

// SetOp allows setting the mutation operation.
func (m *MetaMutation) SetOp(op Op) {
	m.op = op
}

// Type returns the node type of this mutation (Meta).
func (m *MetaMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *MetaMutation) Fields() []string {
	fields := make([]string, 0, 5)
	if m.created_at != nil {
		fields = append(fields, meta.FieldCreatedAt)
	}
	if m.updated_at != nil {
		fields = append(fields, meta.FieldUpdatedAt)
	}
	if m.key != nil {
		fields = append(fields, meta.FieldKey)
	}
	if m.value != nil {
		fields = append(fields, meta.FieldValue)
	}
	if m.owner != nil {
		fields = append(fields, meta.FieldAlertMetas)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *MetaMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case meta.FieldCreatedAt:
		return m.CreatedAt()
	case meta.FieldUpdatedAt:
		return m.UpdatedAt()
	case meta.FieldKey:
		return m.Key()
	case meta.FieldValue:
		return m.Value()
	case meta.FieldAlertMetas:
		return m.AlertMetas()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *MetaMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case meta.FieldCreatedAt:
		return m.OldCreatedAt(ctx)
	case meta.FieldUpdatedAt:
		return m.OldUpdatedAt(ctx)
	case meta.FieldKey:
		return m.OldKey(ctx)
	case meta.FieldValue:
		return m.OldValue(ctx)
	case meta.FieldAlertMetas:
		return m.OldAlertMetas(ctx)
	}
	return nil, fmt.Errorf("unknown Meta field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *MetaMutation) SetField(name string, value ent.Value) error {
	switch name {
	case meta.FieldCreatedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetCreatedAt(v)
		return nil
	case meta.FieldUpdatedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetUpdatedAt(v)
		return nil
	case meta.FieldKey:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetKey(v)
		return nil
	case meta.FieldValue:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetValue(v)
		return nil
	case meta.FieldAlertMetas:
		v, ok := value.(int)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetAlertMetas(v)
		return nil
	}
	return fmt.Errorf("unknown Meta field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *MetaMutation) AddedFields() []string {
	var fields []string
	return fields
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *MetaMutation) AddedField(name string) (ent.Value, bool) {
	switch name {
	}
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *MetaMutation) AddField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown Meta numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *MetaMutation) ClearedFields() []string {
	var fields []string
	if m.FieldCleared(meta.FieldAlertMetas) {
		fields = append(fields, meta.FieldAlertMetas)
	}
	return fields
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *MetaMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *MetaMutation) ClearField(name string) error {
	switch name {
	case meta.FieldAlertMetas:
		m.ClearAlertMetas()
		return nil
	}
	return fmt.Errorf("unknown Meta nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *MetaMutation) ResetField(name string) error {
	switch name {
	case meta.FieldCreatedAt:
		m.ResetCreatedAt()
		return nil
	case meta.FieldUpdatedAt:
		m.ResetUpdatedAt()
		return nil
	case meta.FieldKey:
		m.ResetKey()
		return nil
	case meta.FieldValue:
		m.ResetValue()
		return nil
	case meta.FieldAlertMetas:
		m.ResetAlertMetas()
		return nil
	}
	return fmt.Errorf("unknown Meta field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *MetaMutation) AddedEdges() []string {
	edges := make([]string, 0, 1)
	if m.owner != nil {
		edges = append(edges, meta.EdgeOwner)
	}
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *MetaMutation) AddedIDs(name string) []ent.Value {
	switch name {
	case meta.EdgeOwner:
		if id := m.owner; id != nil {
			return []ent.Value{*id}
		}
	}
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *MetaMutation) RemovedEdges() []string {
	edges := make([]string, 0, 1)
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *MetaMutation) RemovedIDs(name string) []ent.Value {
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *MetaMutation) ClearedEdges() []string {
	edges := make([]string, 0, 1)
	if m.clearedowner {
		edges = append(edges, meta.EdgeOwner)
	}
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *MetaMutation) EdgeCleared(name string) bool {
	switch name {
	case meta.EdgeOwner:
		return m.clearedowner
	}
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *MetaMutation) ClearEdge(name string) error {
	switch name {
	case meta.EdgeOwner:
		m.ClearOwner()
		return nil
	}
	return fmt.Errorf("unknown Meta unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *MetaMutation) ResetEdge(name string) error {
	switch name {
	case meta.EdgeOwner:
		m.ResetOwner()
		return nil
	}
	return fmt.Errorf("unknown Meta edge %s", name)
}

// MetricMutation represents an operation that mutates the Metric nodes in the graph.
type MetricMutation struct {
	config
	op             Op
	typ            string
	id             *int
	generated_type *metric.GeneratedType
	generated_by   *string
	received_at    *time.Time
	pushed_at      *time.Time
	payload        *string
	clearedFields  map[string]struct{}
	done           bool
	oldValue       func(context.Context) (*Metric, error)
	predicates     []predicate.Metric
}

var _ ent.Mutation = (*MetricMutation)(nil)

// metricOption allows management of the mutation configuration using functional options.
type metricOption func(*MetricMutation)

// newMetricMutation creates new mutation for the Metric entity.
func newMetricMutation(c config, op Op, opts ...metricOption) *MetricMutation {
	m := &MetricMutation{
		config:        c,
		op:            op,
		typ:           TypeMetric,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withMetricID sets the ID field of the mutation.
func withMetricID(id int) metricOption {
	return func(m *MetricMutation) {
		var (
			err   error
			once  sync.Once
			value *Metric
		)
		m.oldValue = func(ctx context.Context) (*Metric, error) {
			once.Do(func() {
				if m.done {
					err = errors.New("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().Metric.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withMetric sets the old Metric of the mutation.
func withMetric(node *Metric) metricOption {
	return func(m *MetricMutation) {
		m.oldValue = func(context.Context) (*Metric, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m MetricMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m MetricMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, errors.New("ent: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *MetricMutation) ID() (id int, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// IDs queries the database and returns the entity ids that match the mutation's predicate.
// That means, if the mutation is applied within a transaction with an isolation level such
// as sql.LevelSerializable, the returned ids match the ids of the rows that will be updated
// or updated by the mutation.
func (m *MetricMutation) IDs(ctx context.Context) ([]int, error) {
	switch {
	case m.op.Is(OpUpdateOne | OpDeleteOne):
		id, exists := m.ID()
		if exists {
			return []int{id}, nil
		}
		fallthrough
	case m.op.Is(OpUpdate | OpDelete):
		return m.Client().Metric.Query().Where(m.predicates...).IDs(ctx)
	default:
		return nil, fmt.Errorf("IDs is not allowed on %s operations", m.op)
	}
}

// SetGeneratedType sets the "generated_type" field.
func (m *MetricMutation) SetGeneratedType(mt metric.GeneratedType) {
	m.generated_type = &mt
}

// GeneratedType returns the value of the "generated_type" field in the mutation.
func (m *MetricMutation) GeneratedType() (r metric.GeneratedType, exists bool) {
	v := m.generated_type
	if v == nil {
		return
	}
	return *v, true
}

// OldGeneratedType returns the old "generated_type" field's value of the Metric entity.
// If the Metric object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *MetricMutation) OldGeneratedType(ctx context.Context) (v metric.GeneratedType, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldGeneratedType is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldGeneratedType requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldGeneratedType: %w", err)
	}
	return oldValue.GeneratedType, nil
}

// ResetGeneratedType resets all changes to the "generated_type" field.
func (m *MetricMutation) ResetGeneratedType() {
	m.generated_type = nil
}

// SetGeneratedBy sets the "generated_by" field.
func (m *MetricMutation) SetGeneratedBy(s string) {
	m.generated_by = &s
}

// GeneratedBy returns the value of the "generated_by" field in the mutation.
func (m *MetricMutation) GeneratedBy() (r string, exists bool) {
	v := m.generated_by
	if v == nil {
		return
	}
	return *v, true
}

// OldGeneratedBy returns the old "generated_by" field's value of the Metric entity.
// If the Metric object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *MetricMutation) OldGeneratedBy(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldGeneratedBy is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldGeneratedBy requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldGeneratedBy: %w", err)
	}
	return oldValue.GeneratedBy, nil
}

// ResetGeneratedBy resets all changes to the "generated_by" field.
func (m *MetricMutation) ResetGeneratedBy() {
	m.generated_by = nil
}

// SetReceivedAt sets the "received_at" field.
func (m *MetricMutation) SetReceivedAt(t time.Time) {
	m.received_at = &t
}

// ReceivedAt returns the value of the "received_at" field in the mutation.
func (m *MetricMutation) ReceivedAt() (r time.Time, exists bool) {
	v := m.received_at
	if v == nil {
		return
	}
	return *v, true
}

// OldReceivedAt returns the old "received_at" field's value of the Metric entity.
// If the Metric object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *MetricMutation) OldReceivedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldReceivedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldReceivedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldReceivedAt: %w", err)
	}
	return oldValue.ReceivedAt, nil
}

// ResetReceivedAt resets all changes to the "received_at" field.
func (m *MetricMutation) ResetReceivedAt() {
	m.received_at = nil
}

// SetPushedAt sets the "pushed_at" field.
func (m *MetricMutation) SetPushedAt(t time.Time) {
	m.pushed_at = &t
}

// PushedAt returns the value of the "pushed_at" field in the mutation.
func (m *MetricMutation) PushedAt() (r time.Time, exists bool) {
	v := m.pushed_at
	if v == nil {
		return
	}
	return *v, true
}

// OldPushedAt returns the old "pushed_at" field's value of the Metric entity.
// If the Metric object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *MetricMutation) OldPushedAt(ctx context.Context) (v *time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldPushedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldPushedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldPushedAt: %w", err)
	}
	return oldValue.PushedAt, nil
}

// ClearPushedAt clears the value of the "pushed_at" field.
func (m *MetricMutation) ClearPushedAt() {
	m.pushed_at = nil
	m.clearedFields[metric.FieldPushedAt] = struct{}{}
}

// PushedAtCleared returns if the "pushed_at" field was cleared in this mutation.
func (m *MetricMutation) PushedAtCleared() bool {
	_, ok := m.clearedFields[metric.FieldPushedAt]
	return ok
}

// ResetPushedAt resets all changes to the "pushed_at" field.
func (m *MetricMutation) ResetPushedAt() {
	m.pushed_at = nil
	delete(m.clearedFields, metric.FieldPushedAt)
}

// SetPayload sets the "payload" field.
func (m *MetricMutation) SetPayload(s string) {
	m.payload = &s
}

// Payload returns the value of the "payload" field in the mutation.
func (m *MetricMutation) Payload() (r string, exists bool) {
	v := m.payload
	if v == nil {
		return
	}
	return *v, true
}

// OldPayload returns the old "payload" field's value of the Metric entity.
// If the Metric object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *MetricMutation) OldPayload(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldPayload is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldPayload requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldPayload: %w", err)
	}
	return oldValue.Payload, nil
}

// ResetPayload resets all changes to the "payload" field.
func (m *MetricMutation) ResetPayload() {
	m.payload = nil
}

// Where appends a list predicates to the MetricMutation builder.
func (m *MetricMutation) Where(ps ...predicate.Metric) {
	m.predicates = append(m.predicates, ps...)
}

// WhereP appends storage-level predicates to the MetricMutation builder. Using this method,
// users can use type-assertion to append predicates that do not depend on any generated package.
func (m *MetricMutation) WhereP(ps ...func(*sql.Selector)) {
	p := make([]predicate.Metric, len(ps))
	for i := range ps {
		p[i] = ps[i]
	}
	m.Where(p...)
}

// Op returns the operation name.
func (m *MetricMutation) Op() Op {
	return m.op
}

// SetOp allows setting the mutation operation.
func (m *MetricMutation) SetOp(op Op) {
	m.op = op
}

// Type returns the node type of this mutation (Metric).
func (m *MetricMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *MetricMutation) Fields() []string {
	fields := make([]string, 0, 5)
	if m.generated_type != nil {
		fields = append(fields, metric.FieldGeneratedType)
	}
	if m.generated_by != nil {
		fields = append(fields, metric.FieldGeneratedBy)
	}
	if m.received_at != nil {
		fields = append(fields, metric.FieldReceivedAt)
	}
	if m.pushed_at != nil {
		fields = append(fields, metric.FieldPushedAt)
	}
	if m.payload != nil {
		fields = append(fields, metric.FieldPayload)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *MetricMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case metric.FieldGeneratedType:
		return m.GeneratedType()
	case metric.FieldGeneratedBy:
		return m.GeneratedBy()
	case metric.FieldReceivedAt:
		return m.ReceivedAt()
	case metric.FieldPushedAt:
		return m.PushedAt()
	case metric.FieldPayload:
		return m.Payload()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *MetricMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case metric.FieldGeneratedType:
		return m.OldGeneratedType(ctx)
	case metric.FieldGeneratedBy:
		return m.OldGeneratedBy(ctx)
	case metric.FieldReceivedAt:
		return m.OldReceivedAt(ctx)
	case metric.FieldPushedAt:
		return m.OldPushedAt(ctx)
	case metric.FieldPayload:
		return m.OldPayload(ctx)
	}
	return nil, fmt.Errorf("unknown Metric field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *MetricMutation) SetField(name string, value ent.Value) error {
	switch name {
	case metric.FieldGeneratedType:
		v, ok := value.(metric.GeneratedType)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetGeneratedType(v)
		return nil
	case metric.FieldGeneratedBy:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetGeneratedBy(v)
		return nil
	case metric.FieldReceivedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetReceivedAt(v)
		return nil
	case metric.FieldPushedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetPushedAt(v)
		return nil
	case metric.FieldPayload:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetPayload(v)
		return nil
	}
	return fmt.Errorf("unknown Metric field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *MetricMutation) AddedFields() []string {
	return nil
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *MetricMutation) AddedField(name string) (ent.Value, bool) {
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *MetricMutation) AddField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown Metric numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *MetricMutation) ClearedFields() []string {
	var fields []string
	if m.FieldCleared(metric.FieldPushedAt) {
		fields = append(fields, metric.FieldPushedAt)
	}
	return fields
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *MetricMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *MetricMutation) ClearField(name string) error {
	switch name {
	case metric.FieldPushedAt:
		m.ClearPushedAt()
		return nil
	}
	return fmt.Errorf("unknown Metric nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *MetricMutation) ResetField(name string) error {
	switch name {
	case metric.FieldGeneratedType:
		m.ResetGeneratedType()
		return nil
	case metric.FieldGeneratedBy:
		m.ResetGeneratedBy()
		return nil
	case metric.FieldReceivedAt:
		m.ResetReceivedAt()
		return nil
	case metric.FieldPushedAt:
		m.ResetPushedAt()
		return nil
	case metric.FieldPayload:
		m.ResetPayload()
		return nil
	}
	return fmt.Errorf("unknown Metric field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *MetricMutation) AddedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *MetricMutation) AddedIDs(name string) []ent.Value {
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *MetricMutation) RemovedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *MetricMutation) RemovedIDs(name string) []ent.Value {
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *MetricMutation) ClearedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *MetricMutation) EdgeCleared(name string) bool {
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *MetricMutation) ClearEdge(name string) error {
	return fmt.Errorf("unknown Metric unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *MetricMutation) ResetEdge(name string) error {
	return fmt.Errorf("unknown Metric edge %s", name)
}
