// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// BaseMetrics BaseMetrics
//
// swagger:model BaseMetrics
type BaseMetrics struct {

	// feature flags (expected to be empty for remediation components)
	FeatureFlags []string `json:"feature_flags"`

	// metrics details
	Metrics []*DetailedMetrics `json:"metrics"`

	// os
	Os *OSversion `json:"os,omitempty"`

	// UTC timestamp of the startup of the software
	// Required: true
	UtcStartupTimestamp *int64 `json:"utc_startup_timestamp"`

	// version of the remediation component
	// Required: true
	// Max Length: 255
	Version *string `json:"version"`
}

// Validate validates this base metrics
func (m *BaseMetrics) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateMetrics(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOs(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUtcStartupTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVersion(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *BaseMetrics) validateMetrics(formats strfmt.Registry) error {
	if swag.IsZero(m.Metrics) { // not required
		return nil
	}

	for i := 0; i < len(m.Metrics); i++ {
		if swag.IsZero(m.Metrics[i]) { // not required
			continue
		}

		if m.Metrics[i] != nil {
			if err := m.Metrics[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("metrics" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("metrics" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *BaseMetrics) validateOs(formats strfmt.Registry) error {
	if swag.IsZero(m.Os) { // not required
		return nil
	}

	if m.Os != nil {
		if err := m.Os.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("os")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("os")
			}
			return err
		}
	}

	return nil
}

func (m *BaseMetrics) validateUtcStartupTimestamp(formats strfmt.Registry) error {

	if err := validate.Required("utc_startup_timestamp", "body", m.UtcStartupTimestamp); err != nil {
		return err
	}

	return nil
}

func (m *BaseMetrics) validateVersion(formats strfmt.Registry) error {

	if err := validate.Required("version", "body", m.Version); err != nil {
		return err
	}

	if err := validate.MaxLength("version", "body", *m.Version, 255); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this base metrics based on the context it is used
func (m *BaseMetrics) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateMetrics(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOs(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *BaseMetrics) contextValidateMetrics(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Metrics); i++ {

		if m.Metrics[i] != nil {

			if swag.IsZero(m.Metrics[i]) { // not required
				return nil
			}

			if err := m.Metrics[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("metrics" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("metrics" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *BaseMetrics) contextValidateOs(ctx context.Context, formats strfmt.Registry) error {

	if m.Os != nil {

		if swag.IsZero(m.Os) { // not required
			return nil
		}

		if err := m.Os.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("os")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("os")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *BaseMetrics) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *BaseMetrics) UnmarshalBinary(b []byte) error {
	var res BaseMetrics
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
