// Code generated by ent, DO NOT EDIT.

package ent

import (
	"context"
	"errors"
	"fmt"
	"time"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/crowdsecurity/crowdsec/pkg/database/ent/metric"
	"github.com/crowdsecurity/crowdsec/pkg/database/ent/predicate"
)

// MetricUpdate is the builder for updating Metric entities.
type MetricUpdate struct {
	config
	hooks    []Hook
	mutation *MetricMutation
}

// Where appends a list predicates to the MetricUpdate builder.
func (mu *MetricUpdate) Where(ps ...predicate.Metric) *MetricUpdate {
	mu.mutation.Where(ps...)
	return mu
}

// SetPushedAt sets the "pushed_at" field.
func (mu *MetricUpdate) SetPushedAt(t time.Time) *MetricUpdate {
	mu.mutation.SetPushedAt(t)
	return mu
}

// SetNillablePushedAt sets the "pushed_at" field if the given value is not nil.
func (mu *MetricUpdate) SetNillablePushedAt(t *time.Time) *MetricUpdate {
	if t != nil {
		mu.SetPushedAt(*t)
	}
	return mu
}

// ClearPushedAt clears the value of the "pushed_at" field.
func (mu *MetricUpdate) ClearPushedAt() *MetricUpdate {
	mu.mutation.ClearPushedAt()
	return mu
}

// Mutation returns the MetricMutation object of the builder.
func (mu *MetricUpdate) Mutation() *MetricMutation {
	return mu.mutation
}

// Save executes the query and returns the number of nodes affected by the update operation.
func (mu *MetricUpdate) Save(ctx context.Context) (int, error) {
	return withHooks(ctx, mu.sqlSave, mu.mutation, mu.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (mu *MetricUpdate) SaveX(ctx context.Context) int {
	affected, err := mu.Save(ctx)
	if err != nil {
		panic(err)
	}
	return affected
}

// Exec executes the query.
func (mu *MetricUpdate) Exec(ctx context.Context) error {
	_, err := mu.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (mu *MetricUpdate) ExecX(ctx context.Context) {
	if err := mu.Exec(ctx); err != nil {
		panic(err)
	}
}

func (mu *MetricUpdate) sqlSave(ctx context.Context) (n int, err error) {
	_spec := sqlgraph.NewUpdateSpec(metric.Table, metric.Columns, sqlgraph.NewFieldSpec(metric.FieldID, field.TypeInt))
	if ps := mu.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := mu.mutation.PushedAt(); ok {
		_spec.SetField(metric.FieldPushedAt, field.TypeTime, value)
	}
	if mu.mutation.PushedAtCleared() {
		_spec.ClearField(metric.FieldPushedAt, field.TypeTime)
	}
	if n, err = sqlgraph.UpdateNodes(ctx, mu.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{metric.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return 0, err
	}
	mu.mutation.done = true
	return n, nil
}

// MetricUpdateOne is the builder for updating a single Metric entity.
type MetricUpdateOne struct {
	config
	fields   []string
	hooks    []Hook
	mutation *MetricMutation
}

// SetPushedAt sets the "pushed_at" field.
func (muo *MetricUpdateOne) SetPushedAt(t time.Time) *MetricUpdateOne {
	muo.mutation.SetPushedAt(t)
	return muo
}

// SetNillablePushedAt sets the "pushed_at" field if the given value is not nil.
func (muo *MetricUpdateOne) SetNillablePushedAt(t *time.Time) *MetricUpdateOne {
	if t != nil {
		muo.SetPushedAt(*t)
	}
	return muo
}

// ClearPushedAt clears the value of the "pushed_at" field.
func (muo *MetricUpdateOne) ClearPushedAt() *MetricUpdateOne {
	muo.mutation.ClearPushedAt()
	return muo
}

// Mutation returns the MetricMutation object of the builder.
func (muo *MetricUpdateOne) Mutation() *MetricMutation {
	return muo.mutation
}

// Where appends a list predicates to the MetricUpdate builder.
func (muo *MetricUpdateOne) Where(ps ...predicate.Metric) *MetricUpdateOne {
	muo.mutation.Where(ps...)
	return muo
}

// Select allows selecting one or more fields (columns) of the returned entity.
// The default is selecting all fields defined in the entity schema.
func (muo *MetricUpdateOne) Select(field string, fields ...string) *MetricUpdateOne {
	muo.fields = append([]string{field}, fields...)
	return muo
}

// Save executes the query and returns the updated Metric entity.
func (muo *MetricUpdateOne) Save(ctx context.Context) (*Metric, error) {
	return withHooks(ctx, muo.sqlSave, muo.mutation, muo.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (muo *MetricUpdateOne) SaveX(ctx context.Context) *Metric {
	node, err := muo.Save(ctx)
	if err != nil {
		panic(err)
	}
	return node
}

// Exec executes the query on the entity.
func (muo *MetricUpdateOne) Exec(ctx context.Context) error {
	_, err := muo.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (muo *MetricUpdateOne) ExecX(ctx context.Context) {
	if err := muo.Exec(ctx); err != nil {
		panic(err)
	}
}

func (muo *MetricUpdateOne) sqlSave(ctx context.Context) (_node *Metric, err error) {
	_spec := sqlgraph.NewUpdateSpec(metric.Table, metric.Columns, sqlgraph.NewFieldSpec(metric.FieldID, field.TypeInt))
	id, ok := muo.mutation.ID()
	if !ok {
		return nil, &ValidationError{Name: "id", err: errors.New(`ent: missing "Metric.id" for update`)}
	}
	_spec.Node.ID.Value = id
	if fields := muo.fields; len(fields) > 0 {
		_spec.Node.Columns = make([]string, 0, len(fields))
		_spec.Node.Columns = append(_spec.Node.Columns, metric.FieldID)
		for _, f := range fields {
			if !metric.ValidColumn(f) {
				return nil, &ValidationError{Name: f, err: fmt.Errorf("ent: invalid field %q for query", f)}
			}
			if f != metric.FieldID {
				_spec.Node.Columns = append(_spec.Node.Columns, f)
			}
		}
	}
	if ps := muo.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := muo.mutation.PushedAt(); ok {
		_spec.SetField(metric.FieldPushedAt, field.TypeTime, value)
	}
	if muo.mutation.PushedAtCleared() {
		_spec.ClearField(metric.FieldPushedAt, field.TypeTime)
	}
	_node = &Metric{config: muo.config}
	_spec.Assign = _node.assignValues
	_spec.ScanValues = _node.scanValues
	if err = sqlgraph.UpdateNode(ctx, muo.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{metric.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	muo.mutation.done = true
	return _node, nil
}
