// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// WatcherAuthRequest WatcherAuthRequest
//
// swagger:model WatcherAuthRequest
type WatcherAuthRequest struct {

	// machine id
	// Required: true
	MachineID *string `json:"machine_id"`

	// password
	// Required: true
	// Format: password
	Password *strfmt.Password `json:"password"`

	// the list of scenarios enabled on the watcher
	Scenarios []string `json:"scenarios"`
}

// Validate validates this watcher auth request
func (m *WatcherAuthRequest) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateMachineID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePassword(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *WatcherAuthRequest) validateMachineID(formats strfmt.Registry) error {

	if err := validate.Required("machine_id", "body", m.MachineID); err != nil {
		return err
	}

	return nil
}

func (m *WatcherAuthRequest) validatePassword(formats strfmt.Registry) error {

	if err := validate.Required("password", "body", m.Password); err != nil {
		return err
	}

	if err := validate.FormatOf("password", "body", "password", m.Password.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this watcher auth request based on context it is used
func (m *WatcherAuthRequest) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *WatcherAuthRequest) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *WatcherAuthRequest) UnmarshalBinary(b []byte) error {
	var res WatcherAuthRequest
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
