// Copyright 2015 Citra Emulator Project
// Licensed under GPLv2 or any later version
// Refer to the license.txt file included.

#include "common/archives.h"
#include "core/hle/service/apt/apt_s.h"

namespace Service::APT {

APT_S::APT_S(std::shared_ptr<Module> apt)
    : Module::APTInterface(std::move(apt), "APT:S", MaxAPTSessions) {
    static const FunctionInfo functions[] = {
        // clang-format off
        {0x0001, &APT_S::GetLockHandle, "GetLockHandle"},
        {0x0002, &APT_S::Initialize, "Initialize"},
        {0x0003, &APT_S::Enable, "Enable"},
        {0x0004, &APT_S::Finalize, "Finalize"},
        {0x0005, &APT_S::GetAppletManInfo, "GetAppletManInfo"},
        {0x0006, &APT_S::GetAppletInfo, "GetAppletInfo"},
        {0x0007, nullptr, "GetLastSignaledAppletId"},
        {0x0008, &APT_S::CountRegisteredApplet, "CountRegisteredApplet"},
        {0x0009, &APT_S::IsRegistered, "IsRegistered"},
        {0x000A, &APT_S::GetAttribute, "GetAttribute"},
        {0x000B, &APT_S::InquireNotification, "InquireNotification"},
        {0x000C, &APT_S::SendParameter, "SendParameter"},
        {0x000D, &APT_S::ReceiveParameter, "ReceiveParameter"},
        {0x000E, &APT_S::GlanceParameter, "GlanceParameter"},
        {0x000F, &APT_S::CancelParameter, "CancelParameter"},
        {0x0010, nullptr, "DebugFunc"},
        {0x0011, nullptr, "MapProgramIdForDebug"},
        {0x0012, nullptr, "SetHomeMenuAppletIdForDebug"},
        {0x0013, nullptr, "GetPreparationState"},
        {0x0014, nullptr, "SetPreparationState"},
        {0x0015, &APT_S::PrepareToStartApplication, "PrepareToStartApplication"},
        {0x0016, &APT_S::PreloadLibraryApplet, "PreloadLibraryApplet"},
        {0x0017, &APT_S::FinishPreloadingLibraryApplet, "FinishPreloadingLibraryApplet"},
        {0x0018, &APT_S::PrepareToStartLibraryApplet, "PrepareToStartLibraryApplet"},
        {0x0019, &APT_S::PrepareToStartSystemApplet, "PrepareToStartSystemApplet"},
        {0x001A, &APT_S::PrepareToStartNewestHomeMenu, "PrepareToStartNewestHomeMenu"},
        {0x001B, &APT_S::StartApplication, "StartApplication"},
        {0x001C, &APT_S::WakeupApplication, "WakeupApplication"},
        {0x001D, &APT_S::CancelApplication, "CancelApplication"},
        {0x001E, &APT_S::StartLibraryApplet, "StartLibraryApplet"},
        {0x001F, &APT_S::StartSystemApplet, "StartSystemApplet"},
        {0x0020, nullptr, "StartNewestHomeMenu"},
        {0x0021, &APT_S::OrderToCloseApplication, "OrderToCloseApplication"},
        {0x0022, &APT_S::PrepareToCloseApplication, "PrepareToCloseApplication"},
        {0x0023, nullptr, "PrepareToJumpToApplication"},
        {0x0024, nullptr, "JumpToApplication"},
        {0x0025, &APT_S::PrepareToCloseLibraryApplet, "PrepareToCloseLibraryApplet"},
        {0x0026, &APT_S::PrepareToCloseSystemApplet, "PrepareToCloseSystemApplet"},
        {0x0027, &APT_S::CloseApplication, "CloseApplication"},
        {0x0028, &APT_S::CloseLibraryApplet, "CloseLibraryApplet"},
        {0x0029, &APT_S::CloseSystemApplet, "CloseSystemApplet"},
        {0x002A, &APT_S::OrderToCloseSystemApplet, "OrderToCloseSystemApplet"},
        {0x002B, &APT_S::PrepareToJumpToHomeMenu, "PrepareToJumpToHomeMenu"},
        {0x002C, &APT_S::JumpToHomeMenu, "JumpToHomeMenu"},
        {0x002D, &APT_S::PrepareToLeaveHomeMenu, "PrepareToLeaveHomeMenu"},
        {0x002E, &APT_S::LeaveHomeMenu, "LeaveHomeMenu"},
        {0x002F, nullptr, "PrepareToLeaveResidentApplet"},
        {0x0030, nullptr, "LeaveResidentApplet"},
        {0x0031, &APT_S::PrepareToDoApplicationJump, "PrepareToDoApplicationJump"},
        {0x0032, &APT_S::DoApplicationJump, "DoApplicationJump"},
        {0x0033, &APT_S::GetProgramIdOnApplicationJump, "GetProgramIdOnApplicationJump"},
        {0x0034, &APT_S::SendDeliverArg, "SendDeliverArg"},
        {0x0035, &APT_S::ReceiveDeliverArg, "ReceiveDeliverArg"},
        {0x0036, &APT_S::LoadSysMenuArg, "LoadSysMenuArg"},
        {0x0037, &APT_S::StoreSysMenuArg, "StoreSysMenuArg"},
        {0x0038, nullptr, "PreloadResidentApplet"},
        {0x0039, nullptr, "PrepareToStartResidentApplet"},
        {0x003A, nullptr, "StartResidentApplet"},
        {0x003B, &APT_S::CancelLibraryApplet, "CancelLibraryApplet"},
        {0x003C, &APT_S::SendDspSleep, "SendDspSleep"},
        {0x003D, &APT_S::SendDspWakeUp, "SendDspWakeUp"},
        {0x003E, &APT_S::ReplySleepQuery, "ReplySleepQuery"},
        {0x003F, &APT_S::ReplySleepNotificationComplete, "ReplySleepNotificationComplete"},
        {0x0040, &APT_S::SendCaptureBufferInfo, "SendCaptureBufferInfo"},
        {0x0041, &APT_S::ReceiveCaptureBufferInfo, "ReceiveCaptureBufferInfo"},
        {0x0042, nullptr, "SleepSystem"},
        {0x0043, &APT_S::NotifyToWait, "NotifyToWait"},
        {0x0044, &APT_S::GetSharedFont, "GetSharedFont"},
        {0x0045, &APT_S::GetWirelessRebootInfo, "GetWirelessRebootInfo"},
        {0x0046, &APT_S::Wrap, "Wrap"},
        {0x0047, &APT_S::Unwrap, "Unwrap"},
        {0x0048, &APT_S::GetProgramInfo, "GetProgramInfo"},
        {0x0049, &APT_S::Reboot, "Reboot"},
        {0x004A, &APT_S::GetCaptureInfo, "GetCaptureInfo"},
        {0x004B, &APT_S::AppletUtility, "AppletUtility"},
        {0x004C, nullptr, "SetFatalErrDispMode"},
        {0x004D, nullptr, "GetAppletProgramInfo"},
        {0x004E, &APT_S::HardwareResetAsync, "HardwareResetAsync"},
        {0x004F, &APT_S::SetAppCpuTimeLimit, "SetAppCpuTimeLimit"},
        {0x0050, &APT_S::GetAppCpuTimeLimit, "GetAppCpuTimeLimit"},
        {0x0051, &APT_S::GetStartupArgument, "GetStartupArgument"},
        {0x0052, nullptr, "Wrap1"},
        {0x0053, nullptr, "Unwrap1"},
        {0x0054, &APT_S::Unknown54, "Unknown54"},
        {0x0055, &APT_S::SetScreenCapturePostPermission, "SetScreenCapturePostPermission"},
        {0x0056, &APT_S::GetScreenCapturePostPermission, "GetScreenCapturePostPermission"},
        {0x0057, &APT_S::WakeupApplication2, "WakeupApplication2"},
        {0x0058, &APT_S::GetProgramId, "GetProgramId"},
        {0x0101, &APT_S::GetTargetPlatform, "GetTargetPlatform"},
        {0x0102, &APT_S::CheckNew3DS, "CheckNew3DS"},
        {0x0103, &APT_S::GetApplicationRunningMode, "GetApplicationRunningMode"},
        {0x0104, &APT_S::IsStandardMemoryLayout, "IsStandardMemoryLayout"},
        {0x0105, &APT_S::IsTitleAllowed, "IsTitleAllowed"},
        // clang-format on
    };
    RegisterHandlers(functions);
}

} // namespace Service::APT

SERIALIZE_EXPORT_IMPL(Service::APT::APT_S)
