// Copyright (c) 2023 Yawning Angel
//
// SPDX-License-Identifier: BSD-3-Clause

// Code generated by addchain. DO NOT EDIT.

package field

// Invert sets `z = 1/x` and returns `z`.  If `x == 0`, `z` is set to
// `0`.
func (z *Element) Invert(x *Element) *Element {
	// Inversion computation is derived from the addition chain:
	//
	//	_10     = 2*1
	//	_100    = 2*_10
	//	_101    = 1 + _100
	//	_111    = _10 + _101
	//	_1110   = 2*_111
	//	_111000 = _1110 << 2
	//	_111111 = _111 + _111000
	//	i13     = _111111 << 4 + _1110
	//	x12     = i13 << 2 + _111
	//	x22     = x12 << 10 + i13 + 1
	//	i29     = 2*x22
	//	i31     = i29 << 2
	//	i54     = i31 << 22 + i31
	//	i122    = (i54 << 20 + i29) << 46 + i54
	//	x223    = i122 << 110 + i122 + _111
	//	i269    = ((x223 << 23 + x22) << 7 + _101) << 3
	//	return    _101 + i269
	//
	// Operations: 255 squares 15 multiplies
	//
	// Generated by github.com/mmcloughlin/addchain v0.4.0.

	// Allocate Temporaries.
	var (
		t0 = NewElement()
		t1 = NewElement()
		t2 = NewElement()
		t3 = NewElement()
		t4 = NewElement()
		t5 = NewElement()
	)

	// Step 1: t0 = x^0x2
	t0.Square(x)

	// Step 2: t1 = x^0x4
	t1.Square(t0)

	// Step 3: t1 = x^0x5
	t1.Multiply(x, t1)

	// Step 4: t0 = x^0x7
	t0.Multiply(t0, t1)

	// Step 5: t2 = x^0xe
	t2.Square(t0)

	// Step 7: t3 = x^0x38
	t3.Pow2k(t2, 2)

	// Step 8: t3 = x^0x3f
	t3.Multiply(t0, t3)

	// Step 12: t3 = x^0x3f0
	t3.Pow2k(t3, 4)

	// Step 13: t2 = x^0x3fe
	t2.Multiply(t2, t3)

	// Step 15: t3 = x^0xff8
	t3.Pow2k(t2, 2)

	// Step 16: t3 = x^0xfff
	t3.Multiply(t0, t3)

	// Step 26: t3 = x^0x3ffc00
	t3.Pow2k(t3, 10)

	// Step 27: t2 = x^0x3ffffe
	t2.Multiply(t2, t3)

	// Step 28: t4 = x^0x3fffff
	t4.Multiply(x, t2)

	// Step 29: t2 = x^0x7ffffe
	t2.Square(t4)

	// Step 31: t3 = x^0x1fffff8
	t3.Pow2k(t2, 2)

	// Step 53: t5 = x^0x7ffffe000000
	t5.Pow2k(t3, 22)

	// Step 54: t3 = x^0x7ffffffffff8
	t3.Multiply(t3, t5)

	// Step 74: t5 = x^0x7ffffffffff800000
	t5.Pow2k(t3, 20)

	// Step 75: t2 = x^0x7fffffffffffffffe
	t2.Multiply(t2, t5)

	// Step 121: t2 = x^0x1ffffffffffffffff800000000000
	t2.Pow2k(t2, 46)

	// Step 122: t3 = x^0x1fffffffffffffffffffffffffff8
	t3.Multiply(t3, t2)

	// Step 232: t2 = x^0x7ffffffffffffffffffffffffffe0000000000000000000000000000
	t2.Pow2k(t3, 110)

	// Step 233: t3 = x^0x7ffffffffffffffffffffffffffffffffffffffffffffffffffffff8
	t3.Multiply(t3, t2)

	// Step 234: t0 = x^0x7fffffffffffffffffffffffffffffffffffffffffffffffffffffff
	t0.Multiply(t0, t3)

	// Step 257: t0 = x^0x3fffffffffffffffffffffffffffffffffffffffffffffffffffffff800000
	t0.Pow2k(t0, 23)

	// Step 258: t4 = x^0x3fffffffffffffffffffffffffffffffffffffffffffffffffffffffbfffff
	t4.Multiply(t4, t0)

	// Step 265: t4 = x^0x1fffffffffffffffffffffffffffffffffffffffffffffffffffffffdfffff80
	t4.Pow2k(t4, 7)

	// Step 266: t4 = x^0x1fffffffffffffffffffffffffffffffffffffffffffffffffffffffdfffff85
	t4.Multiply(t1, t4)

	// Step 269: t4 = x^0xfffffffffffffffffffffffffffffffffffffffffffffffffffffffefffffc28
	t4.Pow2k(t4, 3)

	// Step 270: z = x^0xfffffffffffffffffffffffffffffffffffffffffffffffffffffffefffffc2d
	z.Multiply(t1, t4)

	return z
}
