// Code generated by smithy-go-codegen DO NOT EDIT.

package cognitoidentityprovider

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/cognitoidentityprovider/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Some API operations in a user pool generate a challenge, like a prompt for an
// MFA code, for device authentication that bypasses MFA, or for a custom
// authentication challenge. An AdminRespondToAuthChallenge API request provides
// the answer to that challenge, like a code or a secure remote password (SRP). The
// parameters of a response to an authentication challenge vary with the type of
// challenge.
//
// For more information about custom authentication challenges, see [Custom authentication challenge Lambda triggers].
//
// This action might generate an SMS text message. Starting June 1, 2021, US
// telecom carriers require you to register an origination phone number before you
// can send SMS messages to US phone numbers. If you use SMS text messages in
// Amazon Cognito, you must register a phone number with [Amazon Pinpoint]. Amazon Cognito uses the
// registered number automatically. Otherwise, Amazon Cognito users who must
// receive SMS messages might not be able to sign up, activate their accounts, or
// sign in.
//
// If you have never used SMS text messages with Amazon Cognito or any other
// Amazon Web Services service, Amazon Simple Notification Service might place your
// account in the SMS sandbox. In [sandbox mode], you can send messages only to verified phone
// numbers. After you test your app while in the sandbox environment, you can move
// out of the sandbox and into production. For more information, see [SMS message settings for Amazon Cognito user pools]in the Amazon
// Cognito Developer Guide.
//
// Amazon Cognito evaluates Identity and Access Management (IAM) policies in
// requests for this API operation. For this operation, you must use IAM
// credentials to authorize requests, and you must grant yourself the corresponding
// IAM permission in a policy.
//
// # Learn more
//
// [Signing Amazon Web Services API Requests]
//
// [Using the Amazon Cognito user pools API and user pool endpoints]
//
// [SMS message settings for Amazon Cognito user pools]: https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html
// [Using the Amazon Cognito user pools API and user pool endpoints]: https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html
// [sandbox mode]: https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html
// [Custom authentication challenge Lambda triggers]: https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-challenge.html
// [Signing Amazon Web Services API Requests]: https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html
// [Amazon Pinpoint]: https://console.aws.amazon.com/pinpoint/home/
func (c *Client) AdminRespondToAuthChallenge(ctx context.Context, params *AdminRespondToAuthChallengeInput, optFns ...func(*Options)) (*AdminRespondToAuthChallengeOutput, error) {
	if params == nil {
		params = &AdminRespondToAuthChallengeInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "AdminRespondToAuthChallenge", params, optFns, c.addOperationAdminRespondToAuthChallengeMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*AdminRespondToAuthChallengeOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// The request to respond to the authentication challenge, as an administrator.
type AdminRespondToAuthChallengeInput struct {

	// The name of the challenge that you are responding to.
	//
	// Possible challenges include the following:
	//
	// All of the following challenges require USERNAME and, when the app client has a
	// client secret, SECRET_HASH in the parameters.
	//
	//   - WEB_AUTHN : Respond to the challenge with the results of a successful
	//   authentication with a WebAuthn authenticator, or passkey. Examples of WebAuthn
	//   authenticators include biometric devices and security keys.
	//
	//   - PASSWORD : Respond with USER_PASSWORD_AUTH parameters: USERNAME (required),
	//   PASSWORD (required), SECRET_HASH (required if the app client is configured
	//   with a client secret), DEVICE_KEY .
	//
	//   - PASSWORD_SRP : Respond with USER_SRP_AUTH parameters: USERNAME (required),
	//   SRP_A (required), SECRET_HASH (required if the app client is configured with a
	//   client secret), DEVICE_KEY .
	//
	//   - SELECT_CHALLENGE : Respond to the challenge with USERNAME and an ANSWER that
	//   matches one of the challenge types in the AvailableChallenges response
	//   parameter.
	//
	//   - SMS_MFA : Respond with an SMS_MFA_CODE that your user pool delivered in an
	//   SMS message.
	//
	//   - EMAIL_OTP : Respond with an EMAIL_OTP_CODE that your user pool delivered in
	//   an email message.
	//
	//   - PASSWORD_VERIFIER : Respond with PASSWORD_CLAIM_SIGNATURE ,
	//   PASSWORD_CLAIM_SECRET_BLOCK , and TIMESTAMP after client-side SRP calculations.
	//
	//   - CUSTOM_CHALLENGE : This is returned if your custom authentication flow
	//   determines that the user should pass another challenge before tokens are issued.
	//   The parameters of the challenge are determined by your Lambda function.
	//
	//   - DEVICE_SRP_AUTH : Respond with the initial parameters of device SRP
	//   authentication. For more information, see [Signing in with a device].
	//
	//   - DEVICE_PASSWORD_VERIFIER : Respond with PASSWORD_CLAIM_SIGNATURE ,
	//   PASSWORD_CLAIM_SECRET_BLOCK , and TIMESTAMP after client-side SRP
	//   calculations. For more information, see [Signing in with a device].
	//
	//   - NEW_PASSWORD_REQUIRED : For users who are required to change their passwords
	//   after successful first login. Respond to this challenge with NEW_PASSWORD and
	//   any required attributes that Amazon Cognito returned in the requiredAttributes
	//   parameter. You can also set values for attributes that aren't required by your
	//   user pool and that your app client can write.
	//
	// Amazon Cognito only returns this challenge for users who have temporary
	//   passwords. When you create passwordless users, you must provide values for all
	//   required attributes.
	//
	// In a NEW_PASSWORD_REQUIRED challenge response, you can't modify a required
	//   attribute that already has a value. In AdminRespondToAuthChallenge or
	//   RespondToAuthChallenge , set a value for any keys that Amazon Cognito returned
	//   in the requiredAttributes parameter, then use the AdminUpdateUserAttributes or
	//   UpdateUserAttributes API operation to modify the value of any additional
	//   attributes.
	//
	//   - MFA_SETUP : For users who are required to setup an MFA factor before they
	//   can sign in. The MFA types activated for the user pool will be listed in the
	//   challenge parameters MFAS_CAN_SETUP value.
	//
	// To set up time-based one-time password (TOTP) MFA, use the session returned in
	//   this challenge from InitiateAuth or AdminInitiateAuth as an input to
	//   AssociateSoftwareToken . Then, use the session returned by VerifySoftwareToken
	//   as an input to RespondToAuthChallenge or AdminRespondToAuthChallenge with
	//   challenge name MFA_SETUP to complete sign-in.
	//
	// To set up SMS or email MFA, collect a phone_number or email attribute for the
	//   user. Then restart the authentication flow with an InitiateAuth or
	//   AdminInitiateAuth request.
	//
	// [Signing in with a device]: https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-device-tracking.html#user-pools-remembered-devices-signing-in-with-a-device
	//
	// This member is required.
	ChallengeName types.ChallengeNameType

	// The ID of the app client where you initiated sign-in.
	//
	// This member is required.
	ClientId *string

	// The ID of the user pool where you want to respond to an authentication
	// challenge.
	//
	// This member is required.
	UserPoolId *string

	// Information that supports analytics outcomes with Amazon Pinpoint, including
	// the user's endpoint ID. The endpoint ID is a destination for Amazon Pinpoint
	// push notifications, for example a device identifier, email address, or phone
	// number.
	AnalyticsMetadata *types.AnalyticsMetadataType

	// The responses to the challenge that you received in the previous request. Each
	// challenge has its own required response parameters. The following examples are
	// partial JSON request bodies that highlight challenge-response parameters.
	//
	// You must provide a SECRET_HASH parameter in all challenge responses to an app
	// client that has a client secret. Include a DEVICE_KEY for device authentication.
	//
	// SELECT_CHALLENGE "ChallengeName": "SELECT_CHALLENGE", "ChallengeResponses": {
	// "USERNAME": "[username]", "ANSWER": "[Challenge name]"}
	//
	// Available challenges are PASSWORD , PASSWORD_SRP , EMAIL_OTP , SMS_OTP , and
	// WEB_AUTHN .
	//
	// Complete authentication in the SELECT_CHALLENGE response for PASSWORD ,
	// PASSWORD_SRP , and WEB_AUTHN :
	//
	//   - "ChallengeName": "SELECT_CHALLENGE", "ChallengeResponses": { "ANSWER":
	//   "WEB_AUTHN", "USERNAME": "[username]", "CREDENTIAL":
	//   "[AuthenticationResponseJSON]"}
	//
	// See [AuthenticationResponseJSON].
	//
	//   - "ChallengeName": "SELECT_CHALLENGE", "ChallengeResponses": { "ANSWER":
	//   "PASSWORD", "USERNAME": "[username]", "PASSWORD": "[password]"}
	//
	//   - "ChallengeName": "SELECT_CHALLENGE", "ChallengeResponses": { "ANSWER":
	//   "PASSWORD_SRP", "USERNAME": "[username]", "SRP_A": "[SRP_A]"}
	//
	// For SMS_OTP and EMAIL_OTP , respond with the username and answer. Your user pool
	// will send a code for the user to submit in the next challenge response.
	//
	//   - "ChallengeName": "SELECT_CHALLENGE", "ChallengeResponses": { "ANSWER":
	//   "SMS_OTP", "USERNAME": "[username]"}
	//
	//   - "ChallengeName": "SELECT_CHALLENGE", "ChallengeResponses": { "ANSWER":
	//   "EMAIL_OTP", "USERNAME": "[username]"}
	//
	// SMS_OTP "ChallengeName": "SMS_OTP", "ChallengeResponses": {"SMS_OTP_CODE":
	// "[code]", "USERNAME": "[username]"}
	//
	// EMAIL_OTP "ChallengeName": "EMAIL_OTP", "ChallengeResponses":
	// {"EMAIL_OTP_CODE": "[code]", "USERNAME": "[username]"}
	//
	// SMS_MFA "ChallengeName": "SMS_MFA", "ChallengeResponses": {"SMS_MFA_CODE":
	// "[code]", "USERNAME": "[username]"}
	//
	// PASSWORD_VERIFIER This challenge response is part of the SRP flow. Amazon
	// Cognito requires that your application respond to this challenge within a few
	// seconds. When the response time exceeds this period, your user pool returns a
	// NotAuthorizedException error.
	//
	//     "ChallengeName": "PASSWORD_VERIFIER", "ChallengeResponses":
	//     {"PASSWORD_CLAIM_SIGNATURE": "[claim_signature]", "PASSWORD_CLAIM_SECRET_BLOCK":
	//     "[secret_block]", "TIMESTAMP": [timestamp], "USERNAME": "[username]"}
	//
	// Add "DEVICE_KEY" when you sign in with a remembered device.
	//
	// CUSTOM_CHALLENGE "ChallengeName": "CUSTOM_CHALLENGE", "ChallengeResponses":
	// {"USERNAME": "[username]", "ANSWER": "[challenge_answer]"}
	//
	// Add "DEVICE_KEY" when you sign in with a remembered device.
	//
	// NEW_PASSWORD_REQUIRED "ChallengeName": "NEW_PASSWORD_REQUIRED",
	// "ChallengeResponses": {"NEW_PASSWORD": "[new_password]", "USERNAME":
	// "[username]"}
	//
	// To set any required attributes that InitiateAuth returned in an
	// requiredAttributes parameter, add "userAttributes.[attribute_name]":
	// "[attribute_value]" . This parameter can also set values for writable attributes
	// that aren't required by your user pool.
	//
	// In a NEW_PASSWORD_REQUIRED challenge response, you can't modify a required
	// attribute that already has a value. In AdminRespondToAuthChallenge or
	// RespondToAuthChallenge , set a value for any keys that Amazon Cognito returned
	// in the requiredAttributes parameter, then use the AdminUpdateUserAttributes or
	// UpdateUserAttributes API operation to modify the value of any additional
	// attributes.
	//
	// SOFTWARE_TOKEN_MFA "ChallengeName": "SOFTWARE_TOKEN_MFA", "ChallengeResponses":
	// {"USERNAME": "[username]", "SOFTWARE_TOKEN_MFA_CODE": [authenticator_code]}
	//
	// DEVICE_SRP_AUTH "ChallengeName": "DEVICE_SRP_AUTH", "ChallengeResponses":
	// {"USERNAME": "[username]", "DEVICE_KEY": "[device_key]", "SRP_A": "[srp_a]"}
	//
	// DEVICE_PASSWORD_VERIFIER "ChallengeName": "DEVICE_PASSWORD_VERIFIER",
	// "ChallengeResponses": {"DEVICE_KEY": "[device_key]", "PASSWORD_CLAIM_SIGNATURE":
	// "[claim_signature]", "PASSWORD_CLAIM_SECRET_BLOCK": "[secret_block]",
	// "TIMESTAMP": [timestamp], "USERNAME": "[username]"}
	//
	// MFA_SETUP "ChallengeName": "MFA_SETUP", "ChallengeResponses": {"USERNAME":
	// "[username]"}, "SESSION": "[Session ID from VerifySoftwareToken]"
	//
	// SELECT_MFA_TYPE "ChallengeName": "SELECT_MFA_TYPE", "ChallengeResponses":
	// {"USERNAME": "[username]", "ANSWER": "[SMS_MFA or SOFTWARE_TOKEN_MFA]"}
	//
	// For more information about SECRET_HASH , see [Computing secret hash values]. For information about DEVICE_KEY
	// , see [Working with user devices in your user pool].
	//
	// [Computing secret hash values]: https://docs.aws.amazon.com/cognito/latest/developerguide/signing-up-users-in-your-app.html#cognito-user-pools-computing-secret-hash
	// [AuthenticationResponseJSON]: https://www.w3.org/TR/WebAuthn-3/#dictdef-authenticationresponsejson
	// [Working with user devices in your user pool]: https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-device-tracking.html
	ChallengeResponses map[string]string

	// A map of custom key-value pairs that you can provide as input for any custom
	// workflows that this action triggers.
	//
	// You create custom workflows by assigning Lambda functions to user pool
	// triggers. When you use the AdminRespondToAuthChallenge API action, Amazon
	// Cognito invokes any functions that you have assigned to the following triggers:
	//
	//   - Pre sign-up
	//
	//   - custom message
	//
	//   - Post authentication
	//
	//   - User migration
	//
	//   - Pre token generation
	//
	//   - Define auth challenge
	//
	//   - Create auth challenge
	//
	//   - Verify auth challenge response
	//
	// When Amazon Cognito invokes any of these functions, it passes a JSON payload,
	// which the function receives as input. This payload contains a clientMetadata
	// attribute that provides the data that you assigned to the ClientMetadata
	// parameter in your AdminRespondToAuthChallenge request. In your function code in
	// Lambda, you can process the clientMetadata value to enhance your workflow for
	// your specific needs.
	//
	// For more information, see [Using Lambda triggers] in the Amazon Cognito Developer Guide.
	//
	// When you use the ClientMetadata parameter, note that Amazon Cognito won't do
	// the following:
	//
	//   - Store the ClientMetadata value. This data is available only to Lambda
	//   triggers that are assigned to a user pool to support custom workflows. If your
	//   user pool configuration doesn't include triggers, the ClientMetadata parameter
	//   serves no purpose.
	//
	//   - Validate the ClientMetadata value.
	//
	//   - Encrypt the ClientMetadata value. Don't send sensitive information in this
	//   parameter.
	//
	// [Using Lambda triggers]: https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html
	ClientMetadata map[string]string

	// Contextual data about your user session like the device fingerprint, IP
	// address, or location. Amazon Cognito threat protection evaluates the risk of an
	// authentication event based on the context that your app generates and passes to
	// Amazon Cognito when it makes API requests.
	//
	// For more information, see [Collecting data for threat protection in applications].
	//
	// [Collecting data for threat protection in applications]: https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-viewing-threat-protection-app.html
	ContextData *types.ContextDataType

	// The session identifier that maintains the state of authentication requests and
	// challenge responses. If an AdminInitiateAuth or AdminRespondToAuthChallenge API
	// request results in a determination that your application must pass another
	// challenge, Amazon Cognito returns a session with other challenge parameters.
	// Send this session identifier, unmodified, to the next
	// AdminRespondToAuthChallenge request.
	Session *string

	noSmithyDocumentSerde
}

// Responds to the authentication challenge, as an administrator.
type AdminRespondToAuthChallengeOutput struct {

	// The outcome of a successful authentication process. After your application has
	// passed all challenges, Amazon Cognito returns an AuthenticationResult with the
	// JSON web tokens (JWTs) that indicate successful sign-in.
	AuthenticationResult *types.AuthenticationResultType

	// The name of the next challenge that you must respond to.
	//
	// Possible challenges include the following:
	//
	// All of the following challenges require USERNAME and, when the app client has a
	// client secret, SECRET_HASH in the parameters.
	//
	//   - WEB_AUTHN : Respond to the challenge with the results of a successful
	//   authentication with a WebAuthn authenticator, or passkey. Examples of WebAuthn
	//   authenticators include biometric devices and security keys.
	//
	//   - PASSWORD : Respond with USER_PASSWORD_AUTH parameters: USERNAME (required),
	//   PASSWORD (required), SECRET_HASH (required if the app client is configured
	//   with a client secret), DEVICE_KEY .
	//
	//   - PASSWORD_SRP : Respond with USER_SRP_AUTH parameters: USERNAME (required),
	//   SRP_A (required), SECRET_HASH (required if the app client is configured with a
	//   client secret), DEVICE_KEY .
	//
	//   - SELECT_CHALLENGE : Respond to the challenge with USERNAME and an ANSWER that
	//   matches one of the challenge types in the AvailableChallenges response
	//   parameter.
	//
	//   - SMS_MFA : Respond with an SMS_MFA_CODE that your user pool delivered in an
	//   SMS message.
	//
	//   - EMAIL_OTP : Respond with an EMAIL_OTP_CODE that your user pool delivered in
	//   an email message.
	//
	//   - PASSWORD_VERIFIER : Respond with PASSWORD_CLAIM_SIGNATURE ,
	//   PASSWORD_CLAIM_SECRET_BLOCK , and TIMESTAMP after client-side SRP calculations.
	//
	//   - CUSTOM_CHALLENGE : This is returned if your custom authentication flow
	//   determines that the user should pass another challenge before tokens are issued.
	//   The parameters of the challenge are determined by your Lambda function.
	//
	//   - DEVICE_SRP_AUTH : Respond with the initial parameters of device SRP
	//   authentication. For more information, see [Signing in with a device].
	//
	//   - DEVICE_PASSWORD_VERIFIER : Respond with PASSWORD_CLAIM_SIGNATURE ,
	//   PASSWORD_CLAIM_SECRET_BLOCK , and TIMESTAMP after client-side SRP
	//   calculations. For more information, see [Signing in with a device].
	//
	//   - NEW_PASSWORD_REQUIRED : For users who are required to change their passwords
	//   after successful first login. Respond to this challenge with NEW_PASSWORD and
	//   any required attributes that Amazon Cognito returned in the requiredAttributes
	//   parameter. You can also set values for attributes that aren't required by your
	//   user pool and that your app client can write.
	//
	// Amazon Cognito only returns this challenge for users who have temporary
	//   passwords. When you create passwordless users, you must provide values for all
	//   required attributes.
	//
	// In a NEW_PASSWORD_REQUIRED challenge response, you can't modify a required
	//   attribute that already has a value. In AdminRespondToAuthChallenge or
	//   RespondToAuthChallenge , set a value for any keys that Amazon Cognito returned
	//   in the requiredAttributes parameter, then use the AdminUpdateUserAttributes or
	//   UpdateUserAttributes API operation to modify the value of any additional
	//   attributes.
	//
	//   - MFA_SETUP : For users who are required to setup an MFA factor before they
	//   can sign in. The MFA types activated for the user pool will be listed in the
	//   challenge parameters MFAS_CAN_SETUP value.
	//
	// To set up time-based one-time password (TOTP) MFA, use the session returned in
	//   this challenge from InitiateAuth or AdminInitiateAuth as an input to
	//   AssociateSoftwareToken . Then, use the session returned by VerifySoftwareToken
	//   as an input to RespondToAuthChallenge or AdminRespondToAuthChallenge with
	//   challenge name MFA_SETUP to complete sign-in.
	//
	// To set up SMS or email MFA, collect a phone_number or email attribute for the
	//   user. Then restart the authentication flow with an InitiateAuth or
	//   AdminInitiateAuth request.
	//
	// [Signing in with a device]: https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-device-tracking.html#user-pools-remembered-devices-signing-in-with-a-device
	ChallengeName types.ChallengeNameType

	// The parameters that define your response to the next challenge.
	ChallengeParameters map[string]string

	// The session identifier that maintains the state of authentication requests and
	// challenge responses. If an AdminInitiateAuth or AdminRespondToAuthChallenge API
	// request results in a determination that your application must pass another
	// challenge, Amazon Cognito returns a session with other challenge parameters.
	// Send this session identifier, unmodified, to the next
	// AdminRespondToAuthChallenge request.
	Session *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationAdminRespondToAuthChallengeMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpAdminRespondToAuthChallenge{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpAdminRespondToAuthChallenge{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "AdminRespondToAuthChallenge"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpAdminRespondToAuthChallengeValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opAdminRespondToAuthChallenge(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opAdminRespondToAuthChallenge(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "AdminRespondToAuthChallenge",
	}
}
