package adraw

import (
	"9fans.net/go/draw"
	"9fans.net/go/draw/frame"
)

var Display *draw.Display

var TagCols [frame.NCOL]*draw.Image

var TextCols [frame.NCOL]*draw.Image

var Button *draw.Image

var ColButton *draw.Image

var ModButton *draw.Image

var Button2Color *draw.Image

var Button3Color *draw.Image

func Init() {
	if TagCols[frame.BACK] == nil {
		// Blue
		TagCols[frame.BACK] = Display.AllocImageMix(draw.PaleBlueGreen, draw.White)
		TagCols[frame.HIGH], _ = Display.AllocImage(draw.Rect(0, 0, 1, 1), Display.ScreenImage.Pix, true, draw.PaleGreyGreen)
		TagCols[frame.BORD], _ = Display.AllocImage(draw.Rect(0, 0, 1, 1), Display.ScreenImage.Pix, true, draw.PurpleBlue)
		TagCols[frame.TEXT] = Display.Black
		TagCols[frame.HTEXT] = Display.Black

		// Yellow
		TextCols[frame.BACK] = Display.AllocImageMix(draw.PaleYellow, draw.White)
		TextCols[frame.HIGH], _ = Display.AllocImage(draw.Rect(0, 0, 1, 1), Display.ScreenImage.Pix, true, draw.DarkYellow)
		TextCols[frame.BORD], _ = Display.AllocImage(draw.Rect(0, 0, 1, 1), Display.ScreenImage.Pix, true, draw.YellowGreen)
		TextCols[frame.TEXT] = Display.Black
		TextCols[frame.HTEXT] = Display.Black
	}

	r := draw.Rect(0, 0, Scrollwid()+ButtonBorder(), Font.Height+1)
	if Button != nil && r == Button.R {
		return
	}

	if Button != nil {
		Button.Free()
		ModButton.Free()
		ColButton.Free()
	}

	Button, _ = Display.AllocImage(r, Display.ScreenImage.Pix, false, draw.NoFill)
	Button.Draw(r, TagCols[frame.BACK], nil, r.Min)
	r.Max.X -= ButtonBorder()
	Button.Border(r, ButtonBorder(), TagCols[frame.BORD], draw.ZP)

	r = Button.R
	ModButton, _ = Display.AllocImage(r, Display.ScreenImage.Pix, false, draw.NoFill)
	ModButton.Draw(r, TagCols[frame.BACK], nil, r.Min)
	r.Max.X -= ButtonBorder()
	ModButton.Border(r, ButtonBorder(), TagCols[frame.BORD], draw.ZP)
	r = r.Inset(ButtonBorder())
	tmp, _ := Display.AllocImage(draw.Rect(0, 0, 1, 1), Display.ScreenImage.Pix, true, draw.MedBlue)
	ModButton.Draw(r, tmp, nil, draw.ZP)
	tmp.Free()

	r = Button.R
	ColButton, _ = Display.AllocImage(r, Display.ScreenImage.Pix, false, draw.PurpleBlue)

	Button2Color, _ = Display.AllocImage(r, Display.ScreenImage.Pix, true, 0xAA0000FF)
	Button3Color, _ = Display.AllocImage(r, Display.ScreenImage.Pix, true, 0x006600FF)
}

var BoxCursor = draw.Cursor{
	Point: draw.Point{-7, -7},
	White: [...]uint8{
		0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
		0xFF, 0xFF, 0xF8, 0x1F, 0xF8, 0x1F, 0xF8, 0x1F,
		0xF8, 0x1F, 0xF8, 0x1F, 0xF8, 0x1F, 0xFF, 0xFF,
		0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	},
	Black: [...]uint8{
		0x00, 0x00, 0x7F, 0xFE, 0x7F, 0xFE, 0x7F, 0xFE,
		0x70, 0x0E, 0x70, 0x0E, 0x70, 0x0E, 0x70, 0x0E,
		0x70, 0x0E, 0x70, 0x0E, 0x70, 0x0E, 0x70, 0x0E,
		0x7F, 0xFE, 0x7F, 0xFE, 0x7F, 0xFE, 0x00, 0x00,
	},
}

var BoxCursor2 = draw.Cursor2{
	Point: draw.Point{-15, -15},
	White: [...]uint8{
		0xFF, 0xFF, 0xFF, 0xFF,
		0xFF, 0xFF, 0xFF, 0xFF,
		0xFF, 0xFF, 0xFF, 0xFF,
		0xFF, 0xFF, 0xFF, 0xFF,
		0xFF, 0xFF, 0xFF, 0xFF,
		0xFF, 0xFF, 0xFF, 0xFF,
		0xFF, 0xFF, 0xFF, 0xFF,
		0xFF, 0xFF, 0xFF, 0xFF,
		0xFF, 0xFF, 0xFF, 0xFF,
		0xFF, 0xFF, 0xFF, 0xFF,
		0xFF, 0xC0, 0x03, 0xFF,
		0xFF, 0xC0, 0x03, 0xFF,
		0xFF, 0xC0, 0x03, 0xFF,
		0xFF, 0xC0, 0x03, 0xFF,
		0xFF, 0xC0, 0x03, 0xFF,
		0xFF, 0xC0, 0x03, 0xFF,
		0xFF, 0xC0, 0x03, 0xFF,
		0xFF, 0xC0, 0x03, 0xFF,
		0xFF, 0xC0, 0x03, 0xFF,
		0xFF, 0xC0, 0x03, 0xFF,
		0xFF, 0xC0, 0x03, 0xFF,
		0xFF, 0xC0, 0x03, 0xFF,
		0xFF, 0xFF, 0xFF, 0xFF,
		0xFF, 0xFF, 0xFF, 0xFF,
		0xFF, 0xFF, 0xFF, 0xFF,
		0xFF, 0xFF, 0xFF, 0xFF,
		0xFF, 0xFF, 0xFF, 0xFF,
		0xFF, 0xFF, 0xFF, 0xFF,
		0xFF, 0xFF, 0xFF, 0xFF,
		0xFF, 0xFF, 0xFF, 0xFF,
		0xFF, 0xFF, 0xFF, 0xFF,
		0xFF, 0xFF, 0xFF, 0xFF,
	},
	Black: [...]uint8{
		0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00,
		0x3F, 0xFF, 0xFF, 0xFC,
		0x3F, 0xFF, 0xFF, 0xFC,
		0x3F, 0xFF, 0xFF, 0xFC,
		0x3F, 0xFF, 0xFF, 0xFC,
		0x3F, 0xFF, 0xFF, 0xFC,
		0x3F, 0xFF, 0xFF, 0xFC,
		0x3F, 0x00, 0x00, 0xFC,
		0x3F, 0x00, 0x00, 0xFC,
		0x3F, 0x00, 0x00, 0xFC,
		0x3F, 0x00, 0x00, 0xFC,
		0x3F, 0x00, 0x00, 0xFC,
		0x3F, 0x00, 0x00, 0xFC,
		0x3F, 0x00, 0x00, 0xFC,
		0x3F, 0x00, 0x00, 0xFC,
		0x3F, 0x00, 0x00, 0xFC,
		0x3F, 0x00, 0x00, 0xFC,
		0x3F, 0x00, 0x00, 0xFC,
		0x3F, 0x00, 0x00, 0xFC,
		0x3F, 0x00, 0x00, 0xFC,
		0x3F, 0x00, 0x00, 0xFC,
		0x3F, 0x00, 0x00, 0xFC,
		0x3F, 0x00, 0x00, 0xFC,
		0x3F, 0xFF, 0xFF, 0xFC,
		0x3F, 0xFF, 0xFF, 0xFC,
		0x3F, 0xFF, 0xFF, 0xFC,
		0x3F, 0xFF, 0xFF, 0xFC,
		0x3F, 0xFF, 0xFF, 0xFC,
		0x3F, 0xFF, 0xFF, 0xFC,
		0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00,
	},
}

func Scrollwid() int { return Display.Scale(12) }

func Scrollgap() int { return Display.Scale(4) }

func Margin() int { return Display.Scale(4) }

func Border() int { return Display.Scale(2) }

func ButtonBorder() int { return Display.Scale(2) }
