// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/aiplatform/v1beta1/ui_pipeline_spec.proto

package aiplatformpb

import (
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	structpb "google.golang.org/protobuf/types/known/structpb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The definition of a artifact type in MLMD.
type ArtifactTypeSchema struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Kind:
	//
	//	*ArtifactTypeSchema_SchemaTitle
	//	*ArtifactTypeSchema_SchemaUri
	//	*ArtifactTypeSchema_InstanceSchema
	Kind isArtifactTypeSchema_Kind `protobuf_oneof:"kind"`
	// The schema version of the artifact. If the value is not set, it defaults
	// to the latest version in the system.
	SchemaVersion string `protobuf:"bytes,4,opt,name=schema_version,json=schemaVersion,proto3" json:"schema_version,omitempty"`
}

func (x *ArtifactTypeSchema) Reset() {
	*x = ArtifactTypeSchema{}
	mi := &file_google_cloud_aiplatform_v1beta1_ui_pipeline_spec_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ArtifactTypeSchema) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ArtifactTypeSchema) ProtoMessage() {}

func (x *ArtifactTypeSchema) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_ui_pipeline_spec_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ArtifactTypeSchema.ProtoReflect.Descriptor instead.
func (*ArtifactTypeSchema) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_ui_pipeline_spec_proto_rawDescGZIP(), []int{0}
}

func (m *ArtifactTypeSchema) GetKind() isArtifactTypeSchema_Kind {
	if m != nil {
		return m.Kind
	}
	return nil
}

func (x *ArtifactTypeSchema) GetSchemaTitle() string {
	if x, ok := x.GetKind().(*ArtifactTypeSchema_SchemaTitle); ok {
		return x.SchemaTitle
	}
	return ""
}

// Deprecated: Marked as deprecated in google/cloud/aiplatform/v1beta1/ui_pipeline_spec.proto.
func (x *ArtifactTypeSchema) GetSchemaUri() string {
	if x, ok := x.GetKind().(*ArtifactTypeSchema_SchemaUri); ok {
		return x.SchemaUri
	}
	return ""
}

func (x *ArtifactTypeSchema) GetInstanceSchema() string {
	if x, ok := x.GetKind().(*ArtifactTypeSchema_InstanceSchema); ok {
		return x.InstanceSchema
	}
	return ""
}

func (x *ArtifactTypeSchema) GetSchemaVersion() string {
	if x != nil {
		return x.SchemaVersion
	}
	return ""
}

type isArtifactTypeSchema_Kind interface {
	isArtifactTypeSchema_Kind()
}

type ArtifactTypeSchema_SchemaTitle struct {
	// The name of the type. The format of the title must be:
	// `<namespace>.<title>`.
	// Examples:
	//   - `aiplatform.Model`
	//   - `acme.CustomModel`
	//
	// When this field is set, the type must be pre-registered in the MLMD
	// store.
	SchemaTitle string `protobuf:"bytes,1,opt,name=schema_title,json=schemaTitle,proto3,oneof"`
}

type ArtifactTypeSchema_SchemaUri struct {
	// Points to a YAML file stored on Cloud Storage describing the
	// format.
	// Deprecated. Use [PipelineArtifactTypeSchema.schema_title][] or
	// [PipelineArtifactTypeSchema.instance_schema][] instead.
	//
	// Deprecated: Marked as deprecated in google/cloud/aiplatform/v1beta1/ui_pipeline_spec.proto.
	SchemaUri string `protobuf:"bytes,2,opt,name=schema_uri,json=schemaUri,proto3,oneof"`
}

type ArtifactTypeSchema_InstanceSchema struct {
	// Contains a raw YAML string, describing the format of
	// the properties of the type.
	InstanceSchema string `protobuf:"bytes,3,opt,name=instance_schema,json=instanceSchema,proto3,oneof"`
}

func (*ArtifactTypeSchema_SchemaTitle) isArtifactTypeSchema_Kind() {}

func (*ArtifactTypeSchema_SchemaUri) isArtifactTypeSchema_Kind() {}

func (*ArtifactTypeSchema_InstanceSchema) isArtifactTypeSchema_Kind() {}

// The definition of a runtime artifact.
type RuntimeArtifact struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of an artifact.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The type of the artifact.
	Type *ArtifactTypeSchema `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
	// The URI of the artifact.
	Uri string `protobuf:"bytes,3,opt,name=uri,proto3" json:"uri,omitempty"`
	// The properties of the artifact.
	// Deprecated. Use
	// [RuntimeArtifact.metadata][google.cloud.aiplatform.v1beta1.RuntimeArtifact.metadata]
	// instead.
	//
	// Deprecated: Marked as deprecated in google/cloud/aiplatform/v1beta1/ui_pipeline_spec.proto.
	Properties map[string]*Value `protobuf:"bytes,4,rep,name=properties,proto3" json:"properties,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The custom properties of the artifact.
	// Deprecated. Use
	// [RuntimeArtifact.metadata][google.cloud.aiplatform.v1beta1.RuntimeArtifact.metadata]
	// instead.
	//
	// Deprecated: Marked as deprecated in google/cloud/aiplatform/v1beta1/ui_pipeline_spec.proto.
	CustomProperties map[string]*Value `protobuf:"bytes,5,rep,name=custom_properties,json=customProperties,proto3" json:"custom_properties,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Properties of the Artifact.
	Metadata *structpb.Struct `protobuf:"bytes,6,opt,name=metadata,proto3" json:"metadata,omitempty"`
}

func (x *RuntimeArtifact) Reset() {
	*x = RuntimeArtifact{}
	mi := &file_google_cloud_aiplatform_v1beta1_ui_pipeline_spec_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RuntimeArtifact) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RuntimeArtifact) ProtoMessage() {}

func (x *RuntimeArtifact) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_ui_pipeline_spec_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RuntimeArtifact.ProtoReflect.Descriptor instead.
func (*RuntimeArtifact) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_ui_pipeline_spec_proto_rawDescGZIP(), []int{1}
}

func (x *RuntimeArtifact) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *RuntimeArtifact) GetType() *ArtifactTypeSchema {
	if x != nil {
		return x.Type
	}
	return nil
}

func (x *RuntimeArtifact) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

// Deprecated: Marked as deprecated in google/cloud/aiplatform/v1beta1/ui_pipeline_spec.proto.
func (x *RuntimeArtifact) GetProperties() map[string]*Value {
	if x != nil {
		return x.Properties
	}
	return nil
}

// Deprecated: Marked as deprecated in google/cloud/aiplatform/v1beta1/ui_pipeline_spec.proto.
func (x *RuntimeArtifact) GetCustomProperties() map[string]*Value {
	if x != nil {
		return x.CustomProperties
	}
	return nil
}

func (x *RuntimeArtifact) GetMetadata() *structpb.Struct {
	if x != nil {
		return x.Metadata
	}
	return nil
}

var File_google_cloud_aiplatform_v1beta1_ui_pipeline_spec_proto protoreflect.FileDescriptor

var file_google_cloud_aiplatform_v1beta1_ui_pipeline_spec_proto_rawDesc = []byte{
	0x0a, 0x36, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x75, 0x69, 0x5f, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x73, 0x70,
	0x65, 0x63, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61,
	0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x22, 0xb8, 0x01, 0x0a, 0x12, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x54, 0x79, 0x70,
	0x65, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x23, 0x0a, 0x0c, 0x73, 0x63, 0x68, 0x65, 0x6d,
	0x61, 0x5f, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52,
	0x0b, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x54, 0x69, 0x74, 0x6c, 0x65, 0x12, 0x23, 0x0a, 0x0a,
	0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x02, 0x18, 0x01, 0x48, 0x00, 0x52, 0x09, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x55, 0x72,
	0x69, 0x12, 0x29, 0x0a, 0x0f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x73, 0x63,
	0x68, 0x65, 0x6d, 0x61, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0e, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x25, 0x0a, 0x0e,
	0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x42, 0x06, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x22, 0xe8, 0x04, 0x0a, 0x0f,
	0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x12,
	0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x47, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65,
	0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x10, 0x0a, 0x03,
	0x75, 0x72, 0x69, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x69, 0x12, 0x64,
	0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x41, 0x72, 0x74, 0x69,
	0x66, 0x61, 0x63, 0x74, 0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x69, 0x65, 0x73, 0x12, 0x77, 0x0a, 0x11, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x70,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63,
	0x74, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69,
	0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x02, 0x18, 0x01, 0x52, 0x10, 0x63, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x12, 0x33, 0x0a,
	0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x1a, 0x65, 0x0a, 0x0f, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x3c, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x6b, 0x0a, 0x15, 0x43, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x3c, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x42, 0xea, 0x01, 0x0a, 0x23, 0x63, 0x6f, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x42, 0x13,
	0x55, 0x69, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x70, 0x65, 0x63, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x43, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x70, 0x62, 0x3b, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x70, 0x62, 0xaa, 0x02, 0x1f, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x56, 0x31, 0x42, 0x65, 0x74, 0x61, 0x31, 0xca, 0x02, 0x1f, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x41, 0x49, 0x50, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x5c, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0xea, 0x02,
	0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a,
	0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_aiplatform_v1beta1_ui_pipeline_spec_proto_rawDescOnce sync.Once
	file_google_cloud_aiplatform_v1beta1_ui_pipeline_spec_proto_rawDescData = file_google_cloud_aiplatform_v1beta1_ui_pipeline_spec_proto_rawDesc
)

func file_google_cloud_aiplatform_v1beta1_ui_pipeline_spec_proto_rawDescGZIP() []byte {
	file_google_cloud_aiplatform_v1beta1_ui_pipeline_spec_proto_rawDescOnce.Do(func() {
		file_google_cloud_aiplatform_v1beta1_ui_pipeline_spec_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_aiplatform_v1beta1_ui_pipeline_spec_proto_rawDescData)
	})
	return file_google_cloud_aiplatform_v1beta1_ui_pipeline_spec_proto_rawDescData
}

var file_google_cloud_aiplatform_v1beta1_ui_pipeline_spec_proto_msgTypes = make([]protoimpl.MessageInfo, 4)
var file_google_cloud_aiplatform_v1beta1_ui_pipeline_spec_proto_goTypes = []any{
	(*ArtifactTypeSchema)(nil), // 0: google.cloud.aiplatform.v1beta1.ArtifactTypeSchema
	(*RuntimeArtifact)(nil),    // 1: google.cloud.aiplatform.v1beta1.RuntimeArtifact
	nil,                        // 2: google.cloud.aiplatform.v1beta1.RuntimeArtifact.PropertiesEntry
	nil,                        // 3: google.cloud.aiplatform.v1beta1.RuntimeArtifact.CustomPropertiesEntry
	(*structpb.Struct)(nil),    // 4: google.protobuf.Struct
	(*Value)(nil),              // 5: google.cloud.aiplatform.v1beta1.Value
}
var file_google_cloud_aiplatform_v1beta1_ui_pipeline_spec_proto_depIdxs = []int32{
	0, // 0: google.cloud.aiplatform.v1beta1.RuntimeArtifact.type:type_name -> google.cloud.aiplatform.v1beta1.ArtifactTypeSchema
	2, // 1: google.cloud.aiplatform.v1beta1.RuntimeArtifact.properties:type_name -> google.cloud.aiplatform.v1beta1.RuntimeArtifact.PropertiesEntry
	3, // 2: google.cloud.aiplatform.v1beta1.RuntimeArtifact.custom_properties:type_name -> google.cloud.aiplatform.v1beta1.RuntimeArtifact.CustomPropertiesEntry
	4, // 3: google.cloud.aiplatform.v1beta1.RuntimeArtifact.metadata:type_name -> google.protobuf.Struct
	5, // 4: google.cloud.aiplatform.v1beta1.RuntimeArtifact.PropertiesEntry.value:type_name -> google.cloud.aiplatform.v1beta1.Value
	5, // 5: google.cloud.aiplatform.v1beta1.RuntimeArtifact.CustomPropertiesEntry.value:type_name -> google.cloud.aiplatform.v1beta1.Value
	6, // [6:6] is the sub-list for method output_type
	6, // [6:6] is the sub-list for method input_type
	6, // [6:6] is the sub-list for extension type_name
	6, // [6:6] is the sub-list for extension extendee
	0, // [0:6] is the sub-list for field type_name
}

func init() { file_google_cloud_aiplatform_v1beta1_ui_pipeline_spec_proto_init() }
func file_google_cloud_aiplatform_v1beta1_ui_pipeline_spec_proto_init() {
	if File_google_cloud_aiplatform_v1beta1_ui_pipeline_spec_proto != nil {
		return
	}
	file_google_cloud_aiplatform_v1beta1_value_proto_init()
	file_google_cloud_aiplatform_v1beta1_ui_pipeline_spec_proto_msgTypes[0].OneofWrappers = []any{
		(*ArtifactTypeSchema_SchemaTitle)(nil),
		(*ArtifactTypeSchema_SchemaUri)(nil),
		(*ArtifactTypeSchema_InstanceSchema)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_aiplatform_v1beta1_ui_pipeline_spec_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   4,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_aiplatform_v1beta1_ui_pipeline_spec_proto_goTypes,
		DependencyIndexes: file_google_cloud_aiplatform_v1beta1_ui_pipeline_spec_proto_depIdxs,
		MessageInfos:      file_google_cloud_aiplatform_v1beta1_ui_pipeline_spec_proto_msgTypes,
	}.Build()
	File_google_cloud_aiplatform_v1beta1_ui_pipeline_spec_proto = out.File
	file_google_cloud_aiplatform_v1beta1_ui_pipeline_spec_proto_rawDesc = nil
	file_google_cloud_aiplatform_v1beta1_ui_pipeline_spec_proto_goTypes = nil
	file_google_cloud_aiplatform_v1beta1_ui_pipeline_spec_proto_depIdxs = nil
}
