// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/bigquery/biglake/v1alpha1/metastore.proto

package biglakepb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	MetastoreService_CreateCatalog_FullMethodName  = "/google.cloud.bigquery.biglake.v1alpha1.MetastoreService/CreateCatalog"
	MetastoreService_DeleteCatalog_FullMethodName  = "/google.cloud.bigquery.biglake.v1alpha1.MetastoreService/DeleteCatalog"
	MetastoreService_GetCatalog_FullMethodName     = "/google.cloud.bigquery.biglake.v1alpha1.MetastoreService/GetCatalog"
	MetastoreService_ListCatalogs_FullMethodName   = "/google.cloud.bigquery.biglake.v1alpha1.MetastoreService/ListCatalogs"
	MetastoreService_CreateDatabase_FullMethodName = "/google.cloud.bigquery.biglake.v1alpha1.MetastoreService/CreateDatabase"
	MetastoreService_DeleteDatabase_FullMethodName = "/google.cloud.bigquery.biglake.v1alpha1.MetastoreService/DeleteDatabase"
	MetastoreService_UpdateDatabase_FullMethodName = "/google.cloud.bigquery.biglake.v1alpha1.MetastoreService/UpdateDatabase"
	MetastoreService_GetDatabase_FullMethodName    = "/google.cloud.bigquery.biglake.v1alpha1.MetastoreService/GetDatabase"
	MetastoreService_ListDatabases_FullMethodName  = "/google.cloud.bigquery.biglake.v1alpha1.MetastoreService/ListDatabases"
	MetastoreService_CreateTable_FullMethodName    = "/google.cloud.bigquery.biglake.v1alpha1.MetastoreService/CreateTable"
	MetastoreService_DeleteTable_FullMethodName    = "/google.cloud.bigquery.biglake.v1alpha1.MetastoreService/DeleteTable"
	MetastoreService_UpdateTable_FullMethodName    = "/google.cloud.bigquery.biglake.v1alpha1.MetastoreService/UpdateTable"
	MetastoreService_RenameTable_FullMethodName    = "/google.cloud.bigquery.biglake.v1alpha1.MetastoreService/RenameTable"
	MetastoreService_GetTable_FullMethodName       = "/google.cloud.bigquery.biglake.v1alpha1.MetastoreService/GetTable"
	MetastoreService_ListTables_FullMethodName     = "/google.cloud.bigquery.biglake.v1alpha1.MetastoreService/ListTables"
	MetastoreService_CreateLock_FullMethodName     = "/google.cloud.bigquery.biglake.v1alpha1.MetastoreService/CreateLock"
	MetastoreService_DeleteLock_FullMethodName     = "/google.cloud.bigquery.biglake.v1alpha1.MetastoreService/DeleteLock"
	MetastoreService_CheckLock_FullMethodName      = "/google.cloud.bigquery.biglake.v1alpha1.MetastoreService/CheckLock"
	MetastoreService_ListLocks_FullMethodName      = "/google.cloud.bigquery.biglake.v1alpha1.MetastoreService/ListLocks"
)

// MetastoreServiceClient is the client API for MetastoreService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type MetastoreServiceClient interface {
	// Creates a new catalog.
	CreateCatalog(ctx context.Context, in *CreateCatalogRequest, opts ...grpc.CallOption) (*Catalog, error)
	// Deletes an existing catalog specified by the catalog ID.
	DeleteCatalog(ctx context.Context, in *DeleteCatalogRequest, opts ...grpc.CallOption) (*Catalog, error)
	// Gets the catalog specified by the resource name.
	GetCatalog(ctx context.Context, in *GetCatalogRequest, opts ...grpc.CallOption) (*Catalog, error)
	// List all catalogs in a specified project.
	ListCatalogs(ctx context.Context, in *ListCatalogsRequest, opts ...grpc.CallOption) (*ListCatalogsResponse, error)
	// Creates a new database.
	CreateDatabase(ctx context.Context, in *CreateDatabaseRequest, opts ...grpc.CallOption) (*Database, error)
	// Deletes an existing database specified by the database ID.
	DeleteDatabase(ctx context.Context, in *DeleteDatabaseRequest, opts ...grpc.CallOption) (*Database, error)
	// Updates an existing database specified by the database ID.
	UpdateDatabase(ctx context.Context, in *UpdateDatabaseRequest, opts ...grpc.CallOption) (*Database, error)
	// Gets the database specified by the resource name.
	GetDatabase(ctx context.Context, in *GetDatabaseRequest, opts ...grpc.CallOption) (*Database, error)
	// List all databases in a specified catalog.
	ListDatabases(ctx context.Context, in *ListDatabasesRequest, opts ...grpc.CallOption) (*ListDatabasesResponse, error)
	// Creates a new table.
	CreateTable(ctx context.Context, in *CreateTableRequest, opts ...grpc.CallOption) (*Table, error)
	// Deletes an existing table specified by the table ID.
	DeleteTable(ctx context.Context, in *DeleteTableRequest, opts ...grpc.CallOption) (*Table, error)
	// Updates an existing table specified by the table ID.
	UpdateTable(ctx context.Context, in *UpdateTableRequest, opts ...grpc.CallOption) (*Table, error)
	// Renames an existing table specified by the table ID.
	RenameTable(ctx context.Context, in *RenameTableRequest, opts ...grpc.CallOption) (*Table, error)
	// Gets the table specified by the resource name.
	GetTable(ctx context.Context, in *GetTableRequest, opts ...grpc.CallOption) (*Table, error)
	// List all tables in a specified database.
	ListTables(ctx context.Context, in *ListTablesRequest, opts ...grpc.CallOption) (*ListTablesResponse, error)
	// Creates a new lock.
	CreateLock(ctx context.Context, in *CreateLockRequest, opts ...grpc.CallOption) (*Lock, error)
	// Deletes an existing lock specified by the lock ID.
	DeleteLock(ctx context.Context, in *DeleteLockRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Checks the state of a lock specified by the lock ID.
	CheckLock(ctx context.Context, in *CheckLockRequest, opts ...grpc.CallOption) (*Lock, error)
	// List all locks in a specified database.
	ListLocks(ctx context.Context, in *ListLocksRequest, opts ...grpc.CallOption) (*ListLocksResponse, error)
}

type metastoreServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewMetastoreServiceClient(cc grpc.ClientConnInterface) MetastoreServiceClient {
	return &metastoreServiceClient{cc}
}

func (c *metastoreServiceClient) CreateCatalog(ctx context.Context, in *CreateCatalogRequest, opts ...grpc.CallOption) (*Catalog, error) {
	out := new(Catalog)
	err := c.cc.Invoke(ctx, MetastoreService_CreateCatalog_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metastoreServiceClient) DeleteCatalog(ctx context.Context, in *DeleteCatalogRequest, opts ...grpc.CallOption) (*Catalog, error) {
	out := new(Catalog)
	err := c.cc.Invoke(ctx, MetastoreService_DeleteCatalog_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metastoreServiceClient) GetCatalog(ctx context.Context, in *GetCatalogRequest, opts ...grpc.CallOption) (*Catalog, error) {
	out := new(Catalog)
	err := c.cc.Invoke(ctx, MetastoreService_GetCatalog_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metastoreServiceClient) ListCatalogs(ctx context.Context, in *ListCatalogsRequest, opts ...grpc.CallOption) (*ListCatalogsResponse, error) {
	out := new(ListCatalogsResponse)
	err := c.cc.Invoke(ctx, MetastoreService_ListCatalogs_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metastoreServiceClient) CreateDatabase(ctx context.Context, in *CreateDatabaseRequest, opts ...grpc.CallOption) (*Database, error) {
	out := new(Database)
	err := c.cc.Invoke(ctx, MetastoreService_CreateDatabase_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metastoreServiceClient) DeleteDatabase(ctx context.Context, in *DeleteDatabaseRequest, opts ...grpc.CallOption) (*Database, error) {
	out := new(Database)
	err := c.cc.Invoke(ctx, MetastoreService_DeleteDatabase_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metastoreServiceClient) UpdateDatabase(ctx context.Context, in *UpdateDatabaseRequest, opts ...grpc.CallOption) (*Database, error) {
	out := new(Database)
	err := c.cc.Invoke(ctx, MetastoreService_UpdateDatabase_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metastoreServiceClient) GetDatabase(ctx context.Context, in *GetDatabaseRequest, opts ...grpc.CallOption) (*Database, error) {
	out := new(Database)
	err := c.cc.Invoke(ctx, MetastoreService_GetDatabase_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metastoreServiceClient) ListDatabases(ctx context.Context, in *ListDatabasesRequest, opts ...grpc.CallOption) (*ListDatabasesResponse, error) {
	out := new(ListDatabasesResponse)
	err := c.cc.Invoke(ctx, MetastoreService_ListDatabases_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metastoreServiceClient) CreateTable(ctx context.Context, in *CreateTableRequest, opts ...grpc.CallOption) (*Table, error) {
	out := new(Table)
	err := c.cc.Invoke(ctx, MetastoreService_CreateTable_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metastoreServiceClient) DeleteTable(ctx context.Context, in *DeleteTableRequest, opts ...grpc.CallOption) (*Table, error) {
	out := new(Table)
	err := c.cc.Invoke(ctx, MetastoreService_DeleteTable_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metastoreServiceClient) UpdateTable(ctx context.Context, in *UpdateTableRequest, opts ...grpc.CallOption) (*Table, error) {
	out := new(Table)
	err := c.cc.Invoke(ctx, MetastoreService_UpdateTable_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metastoreServiceClient) RenameTable(ctx context.Context, in *RenameTableRequest, opts ...grpc.CallOption) (*Table, error) {
	out := new(Table)
	err := c.cc.Invoke(ctx, MetastoreService_RenameTable_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metastoreServiceClient) GetTable(ctx context.Context, in *GetTableRequest, opts ...grpc.CallOption) (*Table, error) {
	out := new(Table)
	err := c.cc.Invoke(ctx, MetastoreService_GetTable_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metastoreServiceClient) ListTables(ctx context.Context, in *ListTablesRequest, opts ...grpc.CallOption) (*ListTablesResponse, error) {
	out := new(ListTablesResponse)
	err := c.cc.Invoke(ctx, MetastoreService_ListTables_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metastoreServiceClient) CreateLock(ctx context.Context, in *CreateLockRequest, opts ...grpc.CallOption) (*Lock, error) {
	out := new(Lock)
	err := c.cc.Invoke(ctx, MetastoreService_CreateLock_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metastoreServiceClient) DeleteLock(ctx context.Context, in *DeleteLockRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, MetastoreService_DeleteLock_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metastoreServiceClient) CheckLock(ctx context.Context, in *CheckLockRequest, opts ...grpc.CallOption) (*Lock, error) {
	out := new(Lock)
	err := c.cc.Invoke(ctx, MetastoreService_CheckLock_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metastoreServiceClient) ListLocks(ctx context.Context, in *ListLocksRequest, opts ...grpc.CallOption) (*ListLocksResponse, error) {
	out := new(ListLocksResponse)
	err := c.cc.Invoke(ctx, MetastoreService_ListLocks_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// MetastoreServiceServer is the server API for MetastoreService service.
// All implementations should embed UnimplementedMetastoreServiceServer
// for forward compatibility
type MetastoreServiceServer interface {
	// Creates a new catalog.
	CreateCatalog(context.Context, *CreateCatalogRequest) (*Catalog, error)
	// Deletes an existing catalog specified by the catalog ID.
	DeleteCatalog(context.Context, *DeleteCatalogRequest) (*Catalog, error)
	// Gets the catalog specified by the resource name.
	GetCatalog(context.Context, *GetCatalogRequest) (*Catalog, error)
	// List all catalogs in a specified project.
	ListCatalogs(context.Context, *ListCatalogsRequest) (*ListCatalogsResponse, error)
	// Creates a new database.
	CreateDatabase(context.Context, *CreateDatabaseRequest) (*Database, error)
	// Deletes an existing database specified by the database ID.
	DeleteDatabase(context.Context, *DeleteDatabaseRequest) (*Database, error)
	// Updates an existing database specified by the database ID.
	UpdateDatabase(context.Context, *UpdateDatabaseRequest) (*Database, error)
	// Gets the database specified by the resource name.
	GetDatabase(context.Context, *GetDatabaseRequest) (*Database, error)
	// List all databases in a specified catalog.
	ListDatabases(context.Context, *ListDatabasesRequest) (*ListDatabasesResponse, error)
	// Creates a new table.
	CreateTable(context.Context, *CreateTableRequest) (*Table, error)
	// Deletes an existing table specified by the table ID.
	DeleteTable(context.Context, *DeleteTableRequest) (*Table, error)
	// Updates an existing table specified by the table ID.
	UpdateTable(context.Context, *UpdateTableRequest) (*Table, error)
	// Renames an existing table specified by the table ID.
	RenameTable(context.Context, *RenameTableRequest) (*Table, error)
	// Gets the table specified by the resource name.
	GetTable(context.Context, *GetTableRequest) (*Table, error)
	// List all tables in a specified database.
	ListTables(context.Context, *ListTablesRequest) (*ListTablesResponse, error)
	// Creates a new lock.
	CreateLock(context.Context, *CreateLockRequest) (*Lock, error)
	// Deletes an existing lock specified by the lock ID.
	DeleteLock(context.Context, *DeleteLockRequest) (*emptypb.Empty, error)
	// Checks the state of a lock specified by the lock ID.
	CheckLock(context.Context, *CheckLockRequest) (*Lock, error)
	// List all locks in a specified database.
	ListLocks(context.Context, *ListLocksRequest) (*ListLocksResponse, error)
}

// UnimplementedMetastoreServiceServer should be embedded to have forward compatible implementations.
type UnimplementedMetastoreServiceServer struct {
}

func (UnimplementedMetastoreServiceServer) CreateCatalog(context.Context, *CreateCatalogRequest) (*Catalog, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateCatalog not implemented")
}
func (UnimplementedMetastoreServiceServer) DeleteCatalog(context.Context, *DeleteCatalogRequest) (*Catalog, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteCatalog not implemented")
}
func (UnimplementedMetastoreServiceServer) GetCatalog(context.Context, *GetCatalogRequest) (*Catalog, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCatalog not implemented")
}
func (UnimplementedMetastoreServiceServer) ListCatalogs(context.Context, *ListCatalogsRequest) (*ListCatalogsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListCatalogs not implemented")
}
func (UnimplementedMetastoreServiceServer) CreateDatabase(context.Context, *CreateDatabaseRequest) (*Database, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateDatabase not implemented")
}
func (UnimplementedMetastoreServiceServer) DeleteDatabase(context.Context, *DeleteDatabaseRequest) (*Database, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteDatabase not implemented")
}
func (UnimplementedMetastoreServiceServer) UpdateDatabase(context.Context, *UpdateDatabaseRequest) (*Database, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateDatabase not implemented")
}
func (UnimplementedMetastoreServiceServer) GetDatabase(context.Context, *GetDatabaseRequest) (*Database, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDatabase not implemented")
}
func (UnimplementedMetastoreServiceServer) ListDatabases(context.Context, *ListDatabasesRequest) (*ListDatabasesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDatabases not implemented")
}
func (UnimplementedMetastoreServiceServer) CreateTable(context.Context, *CreateTableRequest) (*Table, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateTable not implemented")
}
func (UnimplementedMetastoreServiceServer) DeleteTable(context.Context, *DeleteTableRequest) (*Table, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteTable not implemented")
}
func (UnimplementedMetastoreServiceServer) UpdateTable(context.Context, *UpdateTableRequest) (*Table, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateTable not implemented")
}
func (UnimplementedMetastoreServiceServer) RenameTable(context.Context, *RenameTableRequest) (*Table, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RenameTable not implemented")
}
func (UnimplementedMetastoreServiceServer) GetTable(context.Context, *GetTableRequest) (*Table, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTable not implemented")
}
func (UnimplementedMetastoreServiceServer) ListTables(context.Context, *ListTablesRequest) (*ListTablesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTables not implemented")
}
func (UnimplementedMetastoreServiceServer) CreateLock(context.Context, *CreateLockRequest) (*Lock, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateLock not implemented")
}
func (UnimplementedMetastoreServiceServer) DeleteLock(context.Context, *DeleteLockRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteLock not implemented")
}
func (UnimplementedMetastoreServiceServer) CheckLock(context.Context, *CheckLockRequest) (*Lock, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CheckLock not implemented")
}
func (UnimplementedMetastoreServiceServer) ListLocks(context.Context, *ListLocksRequest) (*ListLocksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListLocks not implemented")
}

// UnsafeMetastoreServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to MetastoreServiceServer will
// result in compilation errors.
type UnsafeMetastoreServiceServer interface {
	mustEmbedUnimplementedMetastoreServiceServer()
}

func RegisterMetastoreServiceServer(s grpc.ServiceRegistrar, srv MetastoreServiceServer) {
	s.RegisterService(&MetastoreService_ServiceDesc, srv)
}

func _MetastoreService_CreateCatalog_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateCatalogRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetastoreServiceServer).CreateCatalog(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MetastoreService_CreateCatalog_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetastoreServiceServer).CreateCatalog(ctx, req.(*CreateCatalogRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetastoreService_DeleteCatalog_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteCatalogRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetastoreServiceServer).DeleteCatalog(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MetastoreService_DeleteCatalog_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetastoreServiceServer).DeleteCatalog(ctx, req.(*DeleteCatalogRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetastoreService_GetCatalog_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCatalogRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetastoreServiceServer).GetCatalog(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MetastoreService_GetCatalog_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetastoreServiceServer).GetCatalog(ctx, req.(*GetCatalogRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetastoreService_ListCatalogs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCatalogsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetastoreServiceServer).ListCatalogs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MetastoreService_ListCatalogs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetastoreServiceServer).ListCatalogs(ctx, req.(*ListCatalogsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetastoreService_CreateDatabase_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDatabaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetastoreServiceServer).CreateDatabase(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MetastoreService_CreateDatabase_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetastoreServiceServer).CreateDatabase(ctx, req.(*CreateDatabaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetastoreService_DeleteDatabase_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDatabaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetastoreServiceServer).DeleteDatabase(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MetastoreService_DeleteDatabase_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetastoreServiceServer).DeleteDatabase(ctx, req.(*DeleteDatabaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetastoreService_UpdateDatabase_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDatabaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetastoreServiceServer).UpdateDatabase(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MetastoreService_UpdateDatabase_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetastoreServiceServer).UpdateDatabase(ctx, req.(*UpdateDatabaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetastoreService_GetDatabase_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDatabaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetastoreServiceServer).GetDatabase(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MetastoreService_GetDatabase_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetastoreServiceServer).GetDatabase(ctx, req.(*GetDatabaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetastoreService_ListDatabases_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDatabasesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetastoreServiceServer).ListDatabases(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MetastoreService_ListDatabases_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetastoreServiceServer).ListDatabases(ctx, req.(*ListDatabasesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetastoreService_CreateTable_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTableRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetastoreServiceServer).CreateTable(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MetastoreService_CreateTable_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetastoreServiceServer).CreateTable(ctx, req.(*CreateTableRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetastoreService_DeleteTable_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTableRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetastoreServiceServer).DeleteTable(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MetastoreService_DeleteTable_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetastoreServiceServer).DeleteTable(ctx, req.(*DeleteTableRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetastoreService_UpdateTable_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateTableRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetastoreServiceServer).UpdateTable(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MetastoreService_UpdateTable_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetastoreServiceServer).UpdateTable(ctx, req.(*UpdateTableRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetastoreService_RenameTable_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RenameTableRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetastoreServiceServer).RenameTable(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MetastoreService_RenameTable_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetastoreServiceServer).RenameTable(ctx, req.(*RenameTableRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetastoreService_GetTable_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTableRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetastoreServiceServer).GetTable(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MetastoreService_GetTable_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetastoreServiceServer).GetTable(ctx, req.(*GetTableRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetastoreService_ListTables_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTablesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetastoreServiceServer).ListTables(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MetastoreService_ListTables_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetastoreServiceServer).ListTables(ctx, req.(*ListTablesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetastoreService_CreateLock_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateLockRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetastoreServiceServer).CreateLock(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MetastoreService_CreateLock_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetastoreServiceServer).CreateLock(ctx, req.(*CreateLockRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetastoreService_DeleteLock_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteLockRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetastoreServiceServer).DeleteLock(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MetastoreService_DeleteLock_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetastoreServiceServer).DeleteLock(ctx, req.(*DeleteLockRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetastoreService_CheckLock_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CheckLockRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetastoreServiceServer).CheckLock(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MetastoreService_CheckLock_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetastoreServiceServer).CheckLock(ctx, req.(*CheckLockRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetastoreService_ListLocks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListLocksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetastoreServiceServer).ListLocks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MetastoreService_ListLocks_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetastoreServiceServer).ListLocks(ctx, req.(*ListLocksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// MetastoreService_ServiceDesc is the grpc.ServiceDesc for MetastoreService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var MetastoreService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.bigquery.biglake.v1alpha1.MetastoreService",
	HandlerType: (*MetastoreServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateCatalog",
			Handler:    _MetastoreService_CreateCatalog_Handler,
		},
		{
			MethodName: "DeleteCatalog",
			Handler:    _MetastoreService_DeleteCatalog_Handler,
		},
		{
			MethodName: "GetCatalog",
			Handler:    _MetastoreService_GetCatalog_Handler,
		},
		{
			MethodName: "ListCatalogs",
			Handler:    _MetastoreService_ListCatalogs_Handler,
		},
		{
			MethodName: "CreateDatabase",
			Handler:    _MetastoreService_CreateDatabase_Handler,
		},
		{
			MethodName: "DeleteDatabase",
			Handler:    _MetastoreService_DeleteDatabase_Handler,
		},
		{
			MethodName: "UpdateDatabase",
			Handler:    _MetastoreService_UpdateDatabase_Handler,
		},
		{
			MethodName: "GetDatabase",
			Handler:    _MetastoreService_GetDatabase_Handler,
		},
		{
			MethodName: "ListDatabases",
			Handler:    _MetastoreService_ListDatabases_Handler,
		},
		{
			MethodName: "CreateTable",
			Handler:    _MetastoreService_CreateTable_Handler,
		},
		{
			MethodName: "DeleteTable",
			Handler:    _MetastoreService_DeleteTable_Handler,
		},
		{
			MethodName: "UpdateTable",
			Handler:    _MetastoreService_UpdateTable_Handler,
		},
		{
			MethodName: "RenameTable",
			Handler:    _MetastoreService_RenameTable_Handler,
		},
		{
			MethodName: "GetTable",
			Handler:    _MetastoreService_GetTable_Handler,
		},
		{
			MethodName: "ListTables",
			Handler:    _MetastoreService_ListTables_Handler,
		},
		{
			MethodName: "CreateLock",
			Handler:    _MetastoreService_CreateLock_Handler,
		},
		{
			MethodName: "DeleteLock",
			Handler:    _MetastoreService_DeleteLock_Handler,
		},
		{
			MethodName: "CheckLock",
			Handler:    _MetastoreService_CheckLock_Handler,
		},
		{
			MethodName: "ListLocks",
			Handler:    _MetastoreService_ListLocks_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/bigquery/biglake/v1alpha1/metastore.proto",
}
