// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/dataplex/v1/analyze.proto

package dataplexpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Query Engine Type of the SQL Script.
type Content_SqlScript_QueryEngine int32

const (
	// Value was unspecified.
	Content_SqlScript_QUERY_ENGINE_UNSPECIFIED Content_SqlScript_QueryEngine = 0
	// Spark SQL Query.
	Content_SqlScript_SPARK Content_SqlScript_QueryEngine = 2
)

// Enum value maps for Content_SqlScript_QueryEngine.
var (
	Content_SqlScript_QueryEngine_name = map[int32]string{
		0: "QUERY_ENGINE_UNSPECIFIED",
		2: "SPARK",
	}
	Content_SqlScript_QueryEngine_value = map[string]int32{
		"QUERY_ENGINE_UNSPECIFIED": 0,
		"SPARK":                    2,
	}
)

func (x Content_SqlScript_QueryEngine) Enum() *Content_SqlScript_QueryEngine {
	p := new(Content_SqlScript_QueryEngine)
	*p = x
	return p
}

func (x Content_SqlScript_QueryEngine) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Content_SqlScript_QueryEngine) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataplex_v1_analyze_proto_enumTypes[0].Descriptor()
}

func (Content_SqlScript_QueryEngine) Type() protoreflect.EnumType {
	return &file_google_cloud_dataplex_v1_analyze_proto_enumTypes[0]
}

func (x Content_SqlScript_QueryEngine) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Content_SqlScript_QueryEngine.Descriptor instead.
func (Content_SqlScript_QueryEngine) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_analyze_proto_rawDescGZIP(), []int{1, 0, 0}
}

// Kernel Type of the Jupyter notebook.
type Content_Notebook_KernelType int32

const (
	// Kernel Type unspecified.
	Content_Notebook_KERNEL_TYPE_UNSPECIFIED Content_Notebook_KernelType = 0
	// Python 3 Kernel.
	Content_Notebook_PYTHON3 Content_Notebook_KernelType = 1
)

// Enum value maps for Content_Notebook_KernelType.
var (
	Content_Notebook_KernelType_name = map[int32]string{
		0: "KERNEL_TYPE_UNSPECIFIED",
		1: "PYTHON3",
	}
	Content_Notebook_KernelType_value = map[string]int32{
		"KERNEL_TYPE_UNSPECIFIED": 0,
		"PYTHON3":                 1,
	}
)

func (x Content_Notebook_KernelType) Enum() *Content_Notebook_KernelType {
	p := new(Content_Notebook_KernelType)
	*p = x
	return p
}

func (x Content_Notebook_KernelType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Content_Notebook_KernelType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataplex_v1_analyze_proto_enumTypes[1].Descriptor()
}

func (Content_Notebook_KernelType) Type() protoreflect.EnumType {
	return &file_google_cloud_dataplex_v1_analyze_proto_enumTypes[1]
}

func (x Content_Notebook_KernelType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Content_Notebook_KernelType.Descriptor instead.
func (Content_Notebook_KernelType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_analyze_proto_rawDescGZIP(), []int{1, 1, 0}
}

// Environment represents a user-visible compute infrastructure for analytics
// within a lake.
type Environment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The relative resource name of the environment, of the form:
	// projects/{project_id}/locations/{location_id}/lakes/{lake_id}/environment/{environment_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. User friendly display name.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Output only. System generated globally unique ID for the environment. This
	// ID will be different if the environment is deleted and re-created with the
	// same name.
	Uid string `protobuf:"bytes,3,opt,name=uid,proto3" json:"uid,omitempty"`
	// Output only. Environment creation time.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time when the environment was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional. User defined labels for the environment.
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. Description of the environment.
	Description string `protobuf:"bytes,7,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. Current state of the environment.
	State State `protobuf:"varint,8,opt,name=state,proto3,enum=google.cloud.dataplex.v1.State" json:"state,omitempty"`
	// Required. Infrastructure specification for the Environment.
	InfrastructureSpec *Environment_InfrastructureSpec `protobuf:"bytes,100,opt,name=infrastructure_spec,json=infrastructureSpec,proto3" json:"infrastructure_spec,omitempty"`
	// Optional. Configuration for sessions created for this environment.
	SessionSpec *Environment_SessionSpec `protobuf:"bytes,101,opt,name=session_spec,json=sessionSpec,proto3" json:"session_spec,omitempty"`
	// Output only. Status of sessions created for this environment.
	SessionStatus *Environment_SessionStatus `protobuf:"bytes,102,opt,name=session_status,json=sessionStatus,proto3" json:"session_status,omitempty"`
	// Output only. URI Endpoints to access sessions associated with the
	// Environment.
	Endpoints *Environment_Endpoints `protobuf:"bytes,200,opt,name=endpoints,proto3" json:"endpoints,omitempty"`
}

func (x *Environment) Reset() {
	*x = Environment{}
	mi := &file_google_cloud_dataplex_v1_analyze_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Environment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Environment) ProtoMessage() {}

func (x *Environment) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_analyze_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Environment.ProtoReflect.Descriptor instead.
func (*Environment) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_analyze_proto_rawDescGZIP(), []int{0}
}

func (x *Environment) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Environment) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Environment) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *Environment) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Environment) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Environment) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Environment) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Environment) GetState() State {
	if x != nil {
		return x.State
	}
	return State_STATE_UNSPECIFIED
}

func (x *Environment) GetInfrastructureSpec() *Environment_InfrastructureSpec {
	if x != nil {
		return x.InfrastructureSpec
	}
	return nil
}

func (x *Environment) GetSessionSpec() *Environment_SessionSpec {
	if x != nil {
		return x.SessionSpec
	}
	return nil
}

func (x *Environment) GetSessionStatus() *Environment_SessionStatus {
	if x != nil {
		return x.SessionStatus
	}
	return nil
}

func (x *Environment) GetEndpoints() *Environment_Endpoints {
	if x != nil {
		return x.Endpoints
	}
	return nil
}

// Content represents a user-visible notebook or a sql script
type Content struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The relative resource name of the content, of the form:
	// projects/{project_id}/locations/{location_id}/lakes/{lake_id}/content/{content_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. System generated globally unique ID for the content. This ID
	// will be different if the content is deleted and re-created with the same
	// name.
	Uid string `protobuf:"bytes,2,opt,name=uid,proto3" json:"uid,omitempty"`
	// Required. The path for the Content file, represented as directory
	// structure. Unique within a lake. Limited to alphanumerics, hyphens,
	// underscores, dots and slashes.
	Path string `protobuf:"bytes,3,opt,name=path,proto3" json:"path,omitempty"`
	// Output only. Content creation time.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time when the content was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional. User defined labels for the content.
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. Description of the content.
	Description string `protobuf:"bytes,7,opt,name=description,proto3" json:"description,omitempty"`
	// Only returned in `GetContent` requests and not in `ListContent` request.
	//
	// Types that are assignable to Data:
	//
	//	*Content_DataText
	Data isContent_Data `protobuf_oneof:"data"`
	// Types of content
	//
	// Types that are assignable to Content:
	//
	//	*Content_SqlScript_
	//	*Content_Notebook_
	Content isContent_Content `protobuf_oneof:"content"`
}

func (x *Content) Reset() {
	*x = Content{}
	mi := &file_google_cloud_dataplex_v1_analyze_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Content) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Content) ProtoMessage() {}

func (x *Content) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_analyze_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Content.ProtoReflect.Descriptor instead.
func (*Content) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_analyze_proto_rawDescGZIP(), []int{1}
}

func (x *Content) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Content) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *Content) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *Content) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Content) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Content) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Content) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (m *Content) GetData() isContent_Data {
	if m != nil {
		return m.Data
	}
	return nil
}

func (x *Content) GetDataText() string {
	if x, ok := x.GetData().(*Content_DataText); ok {
		return x.DataText
	}
	return ""
}

func (m *Content) GetContent() isContent_Content {
	if m != nil {
		return m.Content
	}
	return nil
}

func (x *Content) GetSqlScript() *Content_SqlScript {
	if x, ok := x.GetContent().(*Content_SqlScript_); ok {
		return x.SqlScript
	}
	return nil
}

func (x *Content) GetNotebook() *Content_Notebook {
	if x, ok := x.GetContent().(*Content_Notebook_); ok {
		return x.Notebook
	}
	return nil
}

type isContent_Data interface {
	isContent_Data()
}

type Content_DataText struct {
	// Required. Content data in string format.
	DataText string `protobuf:"bytes,9,opt,name=data_text,json=dataText,proto3,oneof"`
}

func (*Content_DataText) isContent_Data() {}

type isContent_Content interface {
	isContent_Content()
}

type Content_SqlScript_ struct {
	// Sql Script related configurations.
	SqlScript *Content_SqlScript `protobuf:"bytes,100,opt,name=sql_script,json=sqlScript,proto3,oneof"`
}

type Content_Notebook_ struct {
	// Notebook related configurations.
	Notebook *Content_Notebook `protobuf:"bytes,101,opt,name=notebook,proto3,oneof"`
}

func (*Content_SqlScript_) isContent_Content() {}

func (*Content_Notebook_) isContent_Content() {}

// Represents an active analyze session running for a user.
type Session struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The relative resource name of the content, of the form:
	// projects/{project_id}/locations/{location_id}/lakes/{lake_id}/environment/{environment_id}/sessions/{session_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Email of user running the session.
	UserId string `protobuf:"bytes,2,opt,name=user_id,json=userId,proto3" json:"user_id,omitempty"`
	// Output only. Session start time.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. State of Session
	State State `protobuf:"varint,4,opt,name=state,proto3,enum=google.cloud.dataplex.v1.State" json:"state,omitempty"`
}

func (x *Session) Reset() {
	*x = Session{}
	mi := &file_google_cloud_dataplex_v1_analyze_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Session) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Session) ProtoMessage() {}

func (x *Session) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_analyze_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Session.ProtoReflect.Descriptor instead.
func (*Session) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_analyze_proto_rawDescGZIP(), []int{2}
}

func (x *Session) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Session) GetUserId() string {
	if x != nil {
		return x.UserId
	}
	return ""
}

func (x *Session) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Session) GetState() State {
	if x != nil {
		return x.State
	}
	return State_STATE_UNSPECIFIED
}

// Configuration for the underlying infrastructure used to run workloads.
type Environment_InfrastructureSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Hardware config
	//
	// Types that are assignable to Resources:
	//
	//	*Environment_InfrastructureSpec_Compute
	Resources isEnvironment_InfrastructureSpec_Resources `protobuf_oneof:"resources"`
	// Software config
	//
	// Types that are assignable to Runtime:
	//
	//	*Environment_InfrastructureSpec_OsImage
	Runtime isEnvironment_InfrastructureSpec_Runtime `protobuf_oneof:"runtime"`
}

func (x *Environment_InfrastructureSpec) Reset() {
	*x = Environment_InfrastructureSpec{}
	mi := &file_google_cloud_dataplex_v1_analyze_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Environment_InfrastructureSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Environment_InfrastructureSpec) ProtoMessage() {}

func (x *Environment_InfrastructureSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_analyze_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Environment_InfrastructureSpec.ProtoReflect.Descriptor instead.
func (*Environment_InfrastructureSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_analyze_proto_rawDescGZIP(), []int{0, 0}
}

func (m *Environment_InfrastructureSpec) GetResources() isEnvironment_InfrastructureSpec_Resources {
	if m != nil {
		return m.Resources
	}
	return nil
}

func (x *Environment_InfrastructureSpec) GetCompute() *Environment_InfrastructureSpec_ComputeResources {
	if x, ok := x.GetResources().(*Environment_InfrastructureSpec_Compute); ok {
		return x.Compute
	}
	return nil
}

func (m *Environment_InfrastructureSpec) GetRuntime() isEnvironment_InfrastructureSpec_Runtime {
	if m != nil {
		return m.Runtime
	}
	return nil
}

func (x *Environment_InfrastructureSpec) GetOsImage() *Environment_InfrastructureSpec_OsImageRuntime {
	if x, ok := x.GetRuntime().(*Environment_InfrastructureSpec_OsImage); ok {
		return x.OsImage
	}
	return nil
}

type isEnvironment_InfrastructureSpec_Resources interface {
	isEnvironment_InfrastructureSpec_Resources()
}

type Environment_InfrastructureSpec_Compute struct {
	// Optional. Compute resources needed for analyze interactive workloads.
	Compute *Environment_InfrastructureSpec_ComputeResources `protobuf:"bytes,50,opt,name=compute,proto3,oneof"`
}

func (*Environment_InfrastructureSpec_Compute) isEnvironment_InfrastructureSpec_Resources() {}

type isEnvironment_InfrastructureSpec_Runtime interface {
	isEnvironment_InfrastructureSpec_Runtime()
}

type Environment_InfrastructureSpec_OsImage struct {
	// Required. Software Runtime Configuration for analyze interactive
	// workloads.
	OsImage *Environment_InfrastructureSpec_OsImageRuntime `protobuf:"bytes,100,opt,name=os_image,json=osImage,proto3,oneof"`
}

func (*Environment_InfrastructureSpec_OsImage) isEnvironment_InfrastructureSpec_Runtime() {}

// Configuration for sessions created for this environment.
type Environment_SessionSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The idle time configuration of the session. The session will be
	// auto-terminated at the end of this period.
	MaxIdleDuration *durationpb.Duration `protobuf:"bytes,1,opt,name=max_idle_duration,json=maxIdleDuration,proto3" json:"max_idle_duration,omitempty"`
	// Optional. If True, this causes sessions to be pre-created and available
	// for faster startup to enable interactive exploration use-cases. This
	// defaults to False to avoid additional billed charges. These can only be
	// set to True for the environment with name set to "default", and with
	// default configuration.
	EnableFastStartup bool `protobuf:"varint,2,opt,name=enable_fast_startup,json=enableFastStartup,proto3" json:"enable_fast_startup,omitempty"`
}

func (x *Environment_SessionSpec) Reset() {
	*x = Environment_SessionSpec{}
	mi := &file_google_cloud_dataplex_v1_analyze_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Environment_SessionSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Environment_SessionSpec) ProtoMessage() {}

func (x *Environment_SessionSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_analyze_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Environment_SessionSpec.ProtoReflect.Descriptor instead.
func (*Environment_SessionSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_analyze_proto_rawDescGZIP(), []int{0, 1}
}

func (x *Environment_SessionSpec) GetMaxIdleDuration() *durationpb.Duration {
	if x != nil {
		return x.MaxIdleDuration
	}
	return nil
}

func (x *Environment_SessionSpec) GetEnableFastStartup() bool {
	if x != nil {
		return x.EnableFastStartup
	}
	return false
}

// Status of sessions created for this environment.
type Environment_SessionStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Queries over sessions to mark whether the environment is
	// currently active or not
	Active bool `protobuf:"varint,1,opt,name=active,proto3" json:"active,omitempty"`
}

func (x *Environment_SessionStatus) Reset() {
	*x = Environment_SessionStatus{}
	mi := &file_google_cloud_dataplex_v1_analyze_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Environment_SessionStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Environment_SessionStatus) ProtoMessage() {}

func (x *Environment_SessionStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_analyze_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Environment_SessionStatus.ProtoReflect.Descriptor instead.
func (*Environment_SessionStatus) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_analyze_proto_rawDescGZIP(), []int{0, 2}
}

func (x *Environment_SessionStatus) GetActive() bool {
	if x != nil {
		return x.Active
	}
	return false
}

// URI Endpoints to access sessions associated with the Environment.
type Environment_Endpoints struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. URI to serve notebook APIs
	Notebooks string `protobuf:"bytes,1,opt,name=notebooks,proto3" json:"notebooks,omitempty"`
	// Output only. URI to serve SQL APIs
	Sql string `protobuf:"bytes,2,opt,name=sql,proto3" json:"sql,omitempty"`
}

func (x *Environment_Endpoints) Reset() {
	*x = Environment_Endpoints{}
	mi := &file_google_cloud_dataplex_v1_analyze_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Environment_Endpoints) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Environment_Endpoints) ProtoMessage() {}

func (x *Environment_Endpoints) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_analyze_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Environment_Endpoints.ProtoReflect.Descriptor instead.
func (*Environment_Endpoints) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_analyze_proto_rawDescGZIP(), []int{0, 3}
}

func (x *Environment_Endpoints) GetNotebooks() string {
	if x != nil {
		return x.Notebooks
	}
	return ""
}

func (x *Environment_Endpoints) GetSql() string {
	if x != nil {
		return x.Sql
	}
	return ""
}

// Compute resources associated with the analyze interactive workloads.
type Environment_InfrastructureSpec_ComputeResources struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Size in GB of the disk. Default is 100 GB.
	DiskSizeGb int32 `protobuf:"varint,1,opt,name=disk_size_gb,json=diskSizeGb,proto3" json:"disk_size_gb,omitempty"`
	// Optional. Total number of nodes in the sessions created for this
	// environment.
	NodeCount int32 `protobuf:"varint,2,opt,name=node_count,json=nodeCount,proto3" json:"node_count,omitempty"`
	// Optional. Max configurable nodes.
	// If max_node_count > node_count, then auto-scaling is enabled.
	MaxNodeCount int32 `protobuf:"varint,3,opt,name=max_node_count,json=maxNodeCount,proto3" json:"max_node_count,omitempty"`
}

func (x *Environment_InfrastructureSpec_ComputeResources) Reset() {
	*x = Environment_InfrastructureSpec_ComputeResources{}
	mi := &file_google_cloud_dataplex_v1_analyze_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Environment_InfrastructureSpec_ComputeResources) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Environment_InfrastructureSpec_ComputeResources) ProtoMessage() {}

func (x *Environment_InfrastructureSpec_ComputeResources) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_analyze_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Environment_InfrastructureSpec_ComputeResources.ProtoReflect.Descriptor instead.
func (*Environment_InfrastructureSpec_ComputeResources) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_analyze_proto_rawDescGZIP(), []int{0, 0, 0}
}

func (x *Environment_InfrastructureSpec_ComputeResources) GetDiskSizeGb() int32 {
	if x != nil {
		return x.DiskSizeGb
	}
	return 0
}

func (x *Environment_InfrastructureSpec_ComputeResources) GetNodeCount() int32 {
	if x != nil {
		return x.NodeCount
	}
	return 0
}

func (x *Environment_InfrastructureSpec_ComputeResources) GetMaxNodeCount() int32 {
	if x != nil {
		return x.MaxNodeCount
	}
	return 0
}

// Software Runtime Configuration to run Analyze.
type Environment_InfrastructureSpec_OsImageRuntime struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Dataplex Image version.
	ImageVersion string `protobuf:"bytes,1,opt,name=image_version,json=imageVersion,proto3" json:"image_version,omitempty"`
	// Optional. List of Java jars to be included in the runtime environment.
	// Valid input includes Cloud Storage URIs to Jar binaries.
	// For example, gs://bucket-name/my/path/to/file.jar
	JavaLibraries []string `protobuf:"bytes,2,rep,name=java_libraries,json=javaLibraries,proto3" json:"java_libraries,omitempty"`
	// Optional. A list of python packages to be installed.
	// Valid formats include Cloud Storage URI to a PIP installable library.
	// For example, gs://bucket-name/my/path/to/lib.tar.gz
	PythonPackages []string `protobuf:"bytes,3,rep,name=python_packages,json=pythonPackages,proto3" json:"python_packages,omitempty"`
	// Optional. Spark properties to provide configuration for use in sessions
	// created for this environment. The properties to set on daemon config
	// files. Property keys are specified in `prefix:property` format. The
	// prefix must be "spark".
	Properties map[string]string `protobuf:"bytes,4,rep,name=properties,proto3" json:"properties,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *Environment_InfrastructureSpec_OsImageRuntime) Reset() {
	*x = Environment_InfrastructureSpec_OsImageRuntime{}
	mi := &file_google_cloud_dataplex_v1_analyze_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Environment_InfrastructureSpec_OsImageRuntime) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Environment_InfrastructureSpec_OsImageRuntime) ProtoMessage() {}

func (x *Environment_InfrastructureSpec_OsImageRuntime) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_analyze_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Environment_InfrastructureSpec_OsImageRuntime.ProtoReflect.Descriptor instead.
func (*Environment_InfrastructureSpec_OsImageRuntime) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_analyze_proto_rawDescGZIP(), []int{0, 0, 1}
}

func (x *Environment_InfrastructureSpec_OsImageRuntime) GetImageVersion() string {
	if x != nil {
		return x.ImageVersion
	}
	return ""
}

func (x *Environment_InfrastructureSpec_OsImageRuntime) GetJavaLibraries() []string {
	if x != nil {
		return x.JavaLibraries
	}
	return nil
}

func (x *Environment_InfrastructureSpec_OsImageRuntime) GetPythonPackages() []string {
	if x != nil {
		return x.PythonPackages
	}
	return nil
}

func (x *Environment_InfrastructureSpec_OsImageRuntime) GetProperties() map[string]string {
	if x != nil {
		return x.Properties
	}
	return nil
}

// Configuration for the Sql Script content.
type Content_SqlScript struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Query Engine to be used for the Sql Query.
	Engine Content_SqlScript_QueryEngine `protobuf:"varint,1,opt,name=engine,proto3,enum=google.cloud.dataplex.v1.Content_SqlScript_QueryEngine" json:"engine,omitempty"`
}

func (x *Content_SqlScript) Reset() {
	*x = Content_SqlScript{}
	mi := &file_google_cloud_dataplex_v1_analyze_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Content_SqlScript) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Content_SqlScript) ProtoMessage() {}

func (x *Content_SqlScript) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_analyze_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Content_SqlScript.ProtoReflect.Descriptor instead.
func (*Content_SqlScript) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_analyze_proto_rawDescGZIP(), []int{1, 0}
}

func (x *Content_SqlScript) GetEngine() Content_SqlScript_QueryEngine {
	if x != nil {
		return x.Engine
	}
	return Content_SqlScript_QUERY_ENGINE_UNSPECIFIED
}

// Configuration for Notebook content.
type Content_Notebook struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Kernel Type of the notebook.
	KernelType Content_Notebook_KernelType `protobuf:"varint,1,opt,name=kernel_type,json=kernelType,proto3,enum=google.cloud.dataplex.v1.Content_Notebook_KernelType" json:"kernel_type,omitempty"`
}

func (x *Content_Notebook) Reset() {
	*x = Content_Notebook{}
	mi := &file_google_cloud_dataplex_v1_analyze_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Content_Notebook) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Content_Notebook) ProtoMessage() {}

func (x *Content_Notebook) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_analyze_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Content_Notebook.ProtoReflect.Descriptor instead.
func (*Content_Notebook) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_analyze_proto_rawDescGZIP(), []int{1, 1}
}

func (x *Content_Notebook) GetKernelType() Content_Notebook_KernelType {
	if x != nil {
		return x.KernelType
	}
	return Content_Notebook_KERNEL_TYPE_UNSPECIFIED
}

var File_google_cloud_dataplex_v1_analyze_proto protoreflect.FileDescriptor

var file_google_cloud_dataplex_v1_analyze_proto_rawDesc = []byte{
	0x0a, 0x26, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2f, 0x76, 0x31, 0x2f, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x7a, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x18, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e,
	0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x28,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x61, 0x74,
	0x61, 0x70, 0x6c, 0x65, 0x78, 0x2f, 0x76, 0x31, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xe6, 0x0f, 0x0a, 0x0b, 0x45, 0x6e,
	0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x3f, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x25, 0x0a,
	0x23, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e,
	0x6d, 0x65, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69,
	0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x15, 0x0a, 0x03, 0x75, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x03, 0x75, 0x69, 0x64, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x4e, 0x0a,
	0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e,
	0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x25, 0x0a,
	0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3a, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x12, 0x6e, 0x0a, 0x13, 0x69, 0x6e, 0x66, 0x72, 0x61, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75,
	0x72, 0x65, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x64, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e,
	0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x49, 0x6e, 0x66, 0x72, 0x61, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74,
	0x75, 0x72, 0x65, 0x53, 0x70, 0x65, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x12, 0x69, 0x6e,
	0x66, 0x72, 0x61, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x53, 0x70, 0x65, 0x63,
	0x12, 0x59, 0x0a, 0x0c, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63,
	0x18, 0x65, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76,
	0x31, 0x2e, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x53, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b,
	0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x12, 0x5f, 0x0a, 0x0e, 0x73,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x66, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x45,
	0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x53, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x73,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x53, 0x0a, 0x09,
	0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x18, 0xc8, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x76, 0x69,
	0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74,
	0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74,
	0x73, 0x1a, 0xe2, 0x05, 0x0a, 0x12, 0x49, 0x6e, 0x66, 0x72, 0x61, 0x73, 0x74, 0x72, 0x75, 0x63,
	0x74, 0x75, 0x72, 0x65, 0x53, 0x70, 0x65, 0x63, 0x12, 0x6a, 0x0a, 0x07, 0x63, 0x6f, 0x6d, 0x70,
	0x75, 0x74, 0x65, 0x18, 0x32, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65,
	0x78, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74,
	0x2e, 0x49, 0x6e, 0x66, 0x72, 0x61, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x53,
	0x70, 0x65, 0x63, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x07, 0x63, 0x6f, 0x6d,
	0x70, 0x75, 0x74, 0x65, 0x12, 0x69, 0x0a, 0x08, 0x6f, 0x73, 0x5f, 0x69, 0x6d, 0x61, 0x67, 0x65,
	0x18, 0x64, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76,
	0x31, 0x2e, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x49, 0x6e,
	0x66, 0x72, 0x61, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x53, 0x70, 0x65, 0x63,
	0x2e, 0x4f, 0x73, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x48, 0x01, 0x52, 0x07, 0x6f, 0x73, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x1a,
	0x88, 0x01, 0x0a, 0x10, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x12, 0x25, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x5f, 0x67, 0x62, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0a, 0x64, 0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x47, 0x62, 0x12, 0x22, 0x0a, 0x0a, 0x6e,
	0x6f, 0x64, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x6e, 0x6f, 0x64, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12,
	0x29, 0x0a, 0x0e, 0x6d, 0x61, 0x78, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x6d, 0x61,
	0x78, 0x4e, 0x6f, 0x64, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x1a, 0xd1, 0x02, 0x0a, 0x0e, 0x4f,
	0x73, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x12, 0x28, 0x0a,
	0x0d, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x69, 0x6d, 0x61, 0x67, 0x65,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x2a, 0x0a, 0x0e, 0x6a, 0x61, 0x76, 0x61, 0x5f,
	0x6c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x69, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x6a, 0x61, 0x76, 0x61, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72,
	0x69, 0x65, 0x73, 0x12, 0x2c, 0x0a, 0x0f, 0x70, 0x79, 0x74, 0x68, 0x6f, 0x6e, 0x5f, 0x70, 0x61,
	0x63, 0x6b, 0x61, 0x67, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0e, 0x70, 0x79, 0x74, 0x68, 0x6f, 0x6e, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65,
	0x73, 0x12, 0x7c, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x18,
	0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x57, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31,
	0x2e, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x49, 0x6e, 0x66,
	0x72, 0x61, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x53, 0x70, 0x65, 0x63, 0x2e,
	0x4f, 0x73, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x50,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x1a,
	0x3d, 0x0a, 0x0f, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x42, 0x0b,
	0x0a, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x42, 0x09, 0x0a, 0x07, 0x72,
	0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x1a, 0x8e, 0x01, 0x0a, 0x0b, 0x53, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x12, 0x4a, 0x0a, 0x11, 0x6d, 0x61, 0x78, 0x5f, 0x69, 0x64,
	0x6c, 0x65, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0f, 0x6d, 0x61, 0x78, 0x49, 0x64, 0x6c, 0x65, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x33, 0x0a, 0x13, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x66, 0x61, 0x73,
	0x74, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x75, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x46, 0x61, 0x73, 0x74,
	0x53, 0x74, 0x61, 0x72, 0x74, 0x75, 0x70, 0x1a, 0x2c, 0x0a, 0x0d, 0x53, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x1b, 0x0a, 0x06, 0x61, 0x63, 0x74, 0x69,
	0x76, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x61,
	0x63, 0x74, 0x69, 0x76, 0x65, 0x1a, 0x45, 0x0a, 0x09, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e,
	0x74, 0x73, 0x12, 0x21, 0x0a, 0x09, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x6e, 0x6f, 0x74, 0x65,
	0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x12, 0x15, 0x0a, 0x03, 0x73, 0x71, 0x6c, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x03, 0x73, 0x71, 0x6c, 0x1a, 0x39, 0x0a, 0x0b,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x79, 0xea, 0x41, 0x76, 0x0a, 0x23, 0x64, 0x61,
	0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e,
	0x74, 0x12, 0x4f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6c, 0x61, 0x6b, 0x65, 0x73,
	0x2f, 0x7b, 0x6c, 0x61, 0x6b, 0x65, 0x7d, 0x2f, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d,
	0x65, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e,
	0x74, 0x7d, 0x22, 0xa3, 0x08, 0x0a, 0x07, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x3b,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41,
	0x03, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x15, 0x0a, 0x03, 0x75,
	0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x03, 0x75,
	0x69, 0x64, 0x12, 0x17, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x12, 0x40, 0x0a, 0x0b, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a,
	0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x4a, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x25, 0x0a, 0x0b, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x22, 0x0a, 0x09, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x74, 0x65, 0x78, 0x74, 0x18,
	0x09, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x48, 0x00, 0x52, 0x08, 0x64, 0x61,
	0x74, 0x61, 0x54, 0x65, 0x78, 0x74, 0x12, 0x4c, 0x0a, 0x0a, 0x73, 0x71, 0x6c, 0x5f, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x18, 0x64, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c,
	0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x53, 0x71,
	0x6c, 0x53, 0x63, 0x72, 0x69, 0x70, 0x74, 0x48, 0x01, 0x52, 0x09, 0x73, 0x71, 0x6c, 0x53, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x12, 0x48, 0x0a, 0x08, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b,
	0x18, 0x65, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x4e, 0x6f, 0x74, 0x65, 0x62, 0x6f,
	0x6f, 0x6b, 0x48, 0x01, 0x52, 0x08, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x1a, 0x99,
	0x01, 0x0a, 0x09, 0x53, 0x71, 0x6c, 0x53, 0x63, 0x72, 0x69, 0x70, 0x74, 0x12, 0x54, 0x0a, 0x06,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x37, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2e,
	0x53, 0x71, 0x6c, 0x53, 0x63, 0x72, 0x69, 0x70, 0x74, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x22, 0x36, 0x0a, 0x0b, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x12, 0x1c, 0x0a, 0x18, 0x51, 0x55, 0x45, 0x52, 0x59, 0x5f, 0x45, 0x4e, 0x47, 0x49, 0x4e,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x09, 0x0a, 0x05, 0x53, 0x50, 0x41, 0x52, 0x4b, 0x10, 0x02, 0x1a, 0x9f, 0x01, 0x0a, 0x08, 0x4e,
	0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x12, 0x5b, 0x0a, 0x0b, 0x6b, 0x65, 0x72, 0x6e, 0x65,
	0x6c, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x35, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2e,
	0x4e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x2e, 0x4b, 0x65, 0x72, 0x6e, 0x65, 0x6c, 0x54,
	0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x6b, 0x65, 0x72, 0x6e, 0x65, 0x6c,
	0x54, 0x79, 0x70, 0x65, 0x22, 0x36, 0x0a, 0x0a, 0x4b, 0x65, 0x72, 0x6e, 0x65, 0x6c, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x1b, 0x0a, 0x17, 0x4b, 0x45, 0x52, 0x4e, 0x45, 0x4c, 0x5f, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x0b, 0x0a, 0x07, 0x50, 0x59, 0x54, 0x48, 0x4f, 0x4e, 0x33, 0x10, 0x01, 0x1a, 0x39, 0x0a, 0x0b,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x6c, 0xea, 0x41, 0x69, 0x0a, 0x1f, 0x64, 0x61,
	0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x46, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6c, 0x61, 0x6b, 0x65, 0x73, 0x2f, 0x7b, 0x6c, 0x61,
	0x6b, 0x65, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2f, 0x7b, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x7d, 0x42, 0x06, 0x0a, 0x04, 0x64, 0x61, 0x74, 0x61, 0x42, 0x09, 0x0a,
	0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x22, 0xee, 0x02, 0x0a, 0x07, 0x53, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x12, 0x3b, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x64, 0x61, 0x74, 0x61,
	0x70, 0x6c, 0x65, 0x78, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x1c, 0x0a, 0x07, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x75, 0x73, 0x65, 0x72, 0x49, 0x64, 0x12,
	0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x3a, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x3a, 0x89, 0x01,
	0xea, 0x41, 0x85, 0x01, 0x0a, 0x1f, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x62, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6c,
	0x61, 0x6b, 0x65, 0x73, 0x2f, 0x7b, 0x6c, 0x61, 0x6b, 0x65, 0x7d, 0x2f, 0x65, 0x6e, 0x76, 0x69,
	0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f,
	0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x7d, 0x2f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x7b, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x7d, 0x42, 0x68, 0x0a, 0x1c, 0x63, 0x6f, 0x6d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x42, 0x0c, 0x41, 0x6e, 0x61, 0x6c, 0x79,
	0x7a, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x38, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x64, 0x61,
	0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x70, 0x62, 0x3b, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65,
	0x78, 0x70, 0x62, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_dataplex_v1_analyze_proto_rawDescOnce sync.Once
	file_google_cloud_dataplex_v1_analyze_proto_rawDescData = file_google_cloud_dataplex_v1_analyze_proto_rawDesc
)

func file_google_cloud_dataplex_v1_analyze_proto_rawDescGZIP() []byte {
	file_google_cloud_dataplex_v1_analyze_proto_rawDescOnce.Do(func() {
		file_google_cloud_dataplex_v1_analyze_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_dataplex_v1_analyze_proto_rawDescData)
	})
	return file_google_cloud_dataplex_v1_analyze_proto_rawDescData
}

var file_google_cloud_dataplex_v1_analyze_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_cloud_dataplex_v1_analyze_proto_msgTypes = make([]protoimpl.MessageInfo, 14)
var file_google_cloud_dataplex_v1_analyze_proto_goTypes = []any{
	(Content_SqlScript_QueryEngine)(0),     // 0: google.cloud.dataplex.v1.Content.SqlScript.QueryEngine
	(Content_Notebook_KernelType)(0),       // 1: google.cloud.dataplex.v1.Content.Notebook.KernelType
	(*Environment)(nil),                    // 2: google.cloud.dataplex.v1.Environment
	(*Content)(nil),                        // 3: google.cloud.dataplex.v1.Content
	(*Session)(nil),                        // 4: google.cloud.dataplex.v1.Session
	(*Environment_InfrastructureSpec)(nil), // 5: google.cloud.dataplex.v1.Environment.InfrastructureSpec
	(*Environment_SessionSpec)(nil),        // 6: google.cloud.dataplex.v1.Environment.SessionSpec
	(*Environment_SessionStatus)(nil),      // 7: google.cloud.dataplex.v1.Environment.SessionStatus
	(*Environment_Endpoints)(nil),          // 8: google.cloud.dataplex.v1.Environment.Endpoints
	nil,                                    // 9: google.cloud.dataplex.v1.Environment.LabelsEntry
	(*Environment_InfrastructureSpec_ComputeResources)(nil), // 10: google.cloud.dataplex.v1.Environment.InfrastructureSpec.ComputeResources
	(*Environment_InfrastructureSpec_OsImageRuntime)(nil),   // 11: google.cloud.dataplex.v1.Environment.InfrastructureSpec.OsImageRuntime
	nil,                           // 12: google.cloud.dataplex.v1.Environment.InfrastructureSpec.OsImageRuntime.PropertiesEntry
	(*Content_SqlScript)(nil),     // 13: google.cloud.dataplex.v1.Content.SqlScript
	(*Content_Notebook)(nil),      // 14: google.cloud.dataplex.v1.Content.Notebook
	nil,                           // 15: google.cloud.dataplex.v1.Content.LabelsEntry
	(*timestamppb.Timestamp)(nil), // 16: google.protobuf.Timestamp
	(State)(0),                    // 17: google.cloud.dataplex.v1.State
	(*durationpb.Duration)(nil),   // 18: google.protobuf.Duration
}
var file_google_cloud_dataplex_v1_analyze_proto_depIdxs = []int32{
	16, // 0: google.cloud.dataplex.v1.Environment.create_time:type_name -> google.protobuf.Timestamp
	16, // 1: google.cloud.dataplex.v1.Environment.update_time:type_name -> google.protobuf.Timestamp
	9,  // 2: google.cloud.dataplex.v1.Environment.labels:type_name -> google.cloud.dataplex.v1.Environment.LabelsEntry
	17, // 3: google.cloud.dataplex.v1.Environment.state:type_name -> google.cloud.dataplex.v1.State
	5,  // 4: google.cloud.dataplex.v1.Environment.infrastructure_spec:type_name -> google.cloud.dataplex.v1.Environment.InfrastructureSpec
	6,  // 5: google.cloud.dataplex.v1.Environment.session_spec:type_name -> google.cloud.dataplex.v1.Environment.SessionSpec
	7,  // 6: google.cloud.dataplex.v1.Environment.session_status:type_name -> google.cloud.dataplex.v1.Environment.SessionStatus
	8,  // 7: google.cloud.dataplex.v1.Environment.endpoints:type_name -> google.cloud.dataplex.v1.Environment.Endpoints
	16, // 8: google.cloud.dataplex.v1.Content.create_time:type_name -> google.protobuf.Timestamp
	16, // 9: google.cloud.dataplex.v1.Content.update_time:type_name -> google.protobuf.Timestamp
	15, // 10: google.cloud.dataplex.v1.Content.labels:type_name -> google.cloud.dataplex.v1.Content.LabelsEntry
	13, // 11: google.cloud.dataplex.v1.Content.sql_script:type_name -> google.cloud.dataplex.v1.Content.SqlScript
	14, // 12: google.cloud.dataplex.v1.Content.notebook:type_name -> google.cloud.dataplex.v1.Content.Notebook
	16, // 13: google.cloud.dataplex.v1.Session.create_time:type_name -> google.protobuf.Timestamp
	17, // 14: google.cloud.dataplex.v1.Session.state:type_name -> google.cloud.dataplex.v1.State
	10, // 15: google.cloud.dataplex.v1.Environment.InfrastructureSpec.compute:type_name -> google.cloud.dataplex.v1.Environment.InfrastructureSpec.ComputeResources
	11, // 16: google.cloud.dataplex.v1.Environment.InfrastructureSpec.os_image:type_name -> google.cloud.dataplex.v1.Environment.InfrastructureSpec.OsImageRuntime
	18, // 17: google.cloud.dataplex.v1.Environment.SessionSpec.max_idle_duration:type_name -> google.protobuf.Duration
	12, // 18: google.cloud.dataplex.v1.Environment.InfrastructureSpec.OsImageRuntime.properties:type_name -> google.cloud.dataplex.v1.Environment.InfrastructureSpec.OsImageRuntime.PropertiesEntry
	0,  // 19: google.cloud.dataplex.v1.Content.SqlScript.engine:type_name -> google.cloud.dataplex.v1.Content.SqlScript.QueryEngine
	1,  // 20: google.cloud.dataplex.v1.Content.Notebook.kernel_type:type_name -> google.cloud.dataplex.v1.Content.Notebook.KernelType
	21, // [21:21] is the sub-list for method output_type
	21, // [21:21] is the sub-list for method input_type
	21, // [21:21] is the sub-list for extension type_name
	21, // [21:21] is the sub-list for extension extendee
	0,  // [0:21] is the sub-list for field type_name
}

func init() { file_google_cloud_dataplex_v1_analyze_proto_init() }
func file_google_cloud_dataplex_v1_analyze_proto_init() {
	if File_google_cloud_dataplex_v1_analyze_proto != nil {
		return
	}
	file_google_cloud_dataplex_v1_resources_proto_init()
	file_google_cloud_dataplex_v1_analyze_proto_msgTypes[1].OneofWrappers = []any{
		(*Content_DataText)(nil),
		(*Content_SqlScript_)(nil),
		(*Content_Notebook_)(nil),
	}
	file_google_cloud_dataplex_v1_analyze_proto_msgTypes[3].OneofWrappers = []any{
		(*Environment_InfrastructureSpec_Compute)(nil),
		(*Environment_InfrastructureSpec_OsImage)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_dataplex_v1_analyze_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   14,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_dataplex_v1_analyze_proto_goTypes,
		DependencyIndexes: file_google_cloud_dataplex_v1_analyze_proto_depIdxs,
		EnumInfos:         file_google_cloud_dataplex_v1_analyze_proto_enumTypes,
		MessageInfos:      file_google_cloud_dataplex_v1_analyze_proto_msgTypes,
	}.Build()
	File_google_cloud_dataplex_v1_analyze_proto = out.File
	file_google_cloud_dataplex_v1_analyze_proto_rawDesc = nil
	file_google_cloud_dataplex_v1_analyze_proto_goTypes = nil
	file_google_cloud_dataplex_v1_analyze_proto_depIdxs = nil
}
