// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/dataproc/v1/batches.proto

package dataprocpb

import (
	context "context"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	BatchController_CreateBatch_FullMethodName = "/google.cloud.dataproc.v1.BatchController/CreateBatch"
	BatchController_GetBatch_FullMethodName    = "/google.cloud.dataproc.v1.BatchController/GetBatch"
	BatchController_ListBatches_FullMethodName = "/google.cloud.dataproc.v1.BatchController/ListBatches"
	BatchController_DeleteBatch_FullMethodName = "/google.cloud.dataproc.v1.BatchController/DeleteBatch"
)

// BatchControllerClient is the client API for BatchController service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type BatchControllerClient interface {
	// Creates a batch workload that executes asynchronously.
	CreateBatch(ctx context.Context, in *CreateBatchRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets the batch workload resource representation.
	GetBatch(ctx context.Context, in *GetBatchRequest, opts ...grpc.CallOption) (*Batch, error)
	// Lists batch workloads.
	ListBatches(ctx context.Context, in *ListBatchesRequest, opts ...grpc.CallOption) (*ListBatchesResponse, error)
	// Deletes the batch workload resource. If the batch is not in terminal state,
	// the delete fails and the response returns `FAILED_PRECONDITION`.
	DeleteBatch(ctx context.Context, in *DeleteBatchRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type batchControllerClient struct {
	cc grpc.ClientConnInterface
}

func NewBatchControllerClient(cc grpc.ClientConnInterface) BatchControllerClient {
	return &batchControllerClient{cc}
}

func (c *batchControllerClient) CreateBatch(ctx context.Context, in *CreateBatchRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, BatchController_CreateBatch_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *batchControllerClient) GetBatch(ctx context.Context, in *GetBatchRequest, opts ...grpc.CallOption) (*Batch, error) {
	out := new(Batch)
	err := c.cc.Invoke(ctx, BatchController_GetBatch_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *batchControllerClient) ListBatches(ctx context.Context, in *ListBatchesRequest, opts ...grpc.CallOption) (*ListBatchesResponse, error) {
	out := new(ListBatchesResponse)
	err := c.cc.Invoke(ctx, BatchController_ListBatches_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *batchControllerClient) DeleteBatch(ctx context.Context, in *DeleteBatchRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, BatchController_DeleteBatch_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// BatchControllerServer is the server API for BatchController service.
// All implementations should embed UnimplementedBatchControllerServer
// for forward compatibility
type BatchControllerServer interface {
	// Creates a batch workload that executes asynchronously.
	CreateBatch(context.Context, *CreateBatchRequest) (*longrunningpb.Operation, error)
	// Gets the batch workload resource representation.
	GetBatch(context.Context, *GetBatchRequest) (*Batch, error)
	// Lists batch workloads.
	ListBatches(context.Context, *ListBatchesRequest) (*ListBatchesResponse, error)
	// Deletes the batch workload resource. If the batch is not in terminal state,
	// the delete fails and the response returns `FAILED_PRECONDITION`.
	DeleteBatch(context.Context, *DeleteBatchRequest) (*emptypb.Empty, error)
}

// UnimplementedBatchControllerServer should be embedded to have forward compatible implementations.
type UnimplementedBatchControllerServer struct {
}

func (UnimplementedBatchControllerServer) CreateBatch(context.Context, *CreateBatchRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateBatch not implemented")
}
func (UnimplementedBatchControllerServer) GetBatch(context.Context, *GetBatchRequest) (*Batch, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetBatch not implemented")
}
func (UnimplementedBatchControllerServer) ListBatches(context.Context, *ListBatchesRequest) (*ListBatchesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListBatches not implemented")
}
func (UnimplementedBatchControllerServer) DeleteBatch(context.Context, *DeleteBatchRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteBatch not implemented")
}

// UnsafeBatchControllerServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to BatchControllerServer will
// result in compilation errors.
type UnsafeBatchControllerServer interface {
	mustEmbedUnimplementedBatchControllerServer()
}

func RegisterBatchControllerServer(s grpc.ServiceRegistrar, srv BatchControllerServer) {
	s.RegisterService(&BatchController_ServiceDesc, srv)
}

func _BatchController_CreateBatch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateBatchRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BatchControllerServer).CreateBatch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BatchController_CreateBatch_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BatchControllerServer).CreateBatch(ctx, req.(*CreateBatchRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BatchController_GetBatch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBatchRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BatchControllerServer).GetBatch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BatchController_GetBatch_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BatchControllerServer).GetBatch(ctx, req.(*GetBatchRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BatchController_ListBatches_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListBatchesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BatchControllerServer).ListBatches(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BatchController_ListBatches_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BatchControllerServer).ListBatches(ctx, req.(*ListBatchesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BatchController_DeleteBatch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteBatchRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BatchControllerServer).DeleteBatch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BatchController_DeleteBatch_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BatchControllerServer).DeleteBatch(ctx, req.(*DeleteBatchRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// BatchController_ServiceDesc is the grpc.ServiceDesc for BatchController service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var BatchController_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dataproc.v1.BatchController",
	HandlerType: (*BatchControllerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateBatch",
			Handler:    _BatchController_CreateBatch_Handler,
		},
		{
			MethodName: "GetBatch",
			Handler:    _BatchController_GetBatch_Handler,
		},
		{
			MethodName: "ListBatches",
			Handler:    _BatchController_ListBatches_Handler,
		},
		{
			MethodName: "DeleteBatch",
			Handler:    _BatchController_DeleteBatch_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dataproc/v1/batches.proto",
}
