// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/deploy/v1/cloud_deploy.proto

package deploypb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	CloudDeploy_ListDeliveryPipelines_FullMethodName  = "/google.cloud.deploy.v1.CloudDeploy/ListDeliveryPipelines"
	CloudDeploy_GetDeliveryPipeline_FullMethodName    = "/google.cloud.deploy.v1.CloudDeploy/GetDeliveryPipeline"
	CloudDeploy_CreateDeliveryPipeline_FullMethodName = "/google.cloud.deploy.v1.CloudDeploy/CreateDeliveryPipeline"
	CloudDeploy_UpdateDeliveryPipeline_FullMethodName = "/google.cloud.deploy.v1.CloudDeploy/UpdateDeliveryPipeline"
	CloudDeploy_DeleteDeliveryPipeline_FullMethodName = "/google.cloud.deploy.v1.CloudDeploy/DeleteDeliveryPipeline"
	CloudDeploy_ListTargets_FullMethodName            = "/google.cloud.deploy.v1.CloudDeploy/ListTargets"
	CloudDeploy_RollbackTarget_FullMethodName         = "/google.cloud.deploy.v1.CloudDeploy/RollbackTarget"
	CloudDeploy_GetTarget_FullMethodName              = "/google.cloud.deploy.v1.CloudDeploy/GetTarget"
	CloudDeploy_CreateTarget_FullMethodName           = "/google.cloud.deploy.v1.CloudDeploy/CreateTarget"
	CloudDeploy_UpdateTarget_FullMethodName           = "/google.cloud.deploy.v1.CloudDeploy/UpdateTarget"
	CloudDeploy_DeleteTarget_FullMethodName           = "/google.cloud.deploy.v1.CloudDeploy/DeleteTarget"
	CloudDeploy_ListCustomTargetTypes_FullMethodName  = "/google.cloud.deploy.v1.CloudDeploy/ListCustomTargetTypes"
	CloudDeploy_GetCustomTargetType_FullMethodName    = "/google.cloud.deploy.v1.CloudDeploy/GetCustomTargetType"
	CloudDeploy_CreateCustomTargetType_FullMethodName = "/google.cloud.deploy.v1.CloudDeploy/CreateCustomTargetType"
	CloudDeploy_UpdateCustomTargetType_FullMethodName = "/google.cloud.deploy.v1.CloudDeploy/UpdateCustomTargetType"
	CloudDeploy_DeleteCustomTargetType_FullMethodName = "/google.cloud.deploy.v1.CloudDeploy/DeleteCustomTargetType"
	CloudDeploy_ListReleases_FullMethodName           = "/google.cloud.deploy.v1.CloudDeploy/ListReleases"
	CloudDeploy_GetRelease_FullMethodName             = "/google.cloud.deploy.v1.CloudDeploy/GetRelease"
	CloudDeploy_CreateRelease_FullMethodName          = "/google.cloud.deploy.v1.CloudDeploy/CreateRelease"
	CloudDeploy_AbandonRelease_FullMethodName         = "/google.cloud.deploy.v1.CloudDeploy/AbandonRelease"
	CloudDeploy_CreateDeployPolicy_FullMethodName     = "/google.cloud.deploy.v1.CloudDeploy/CreateDeployPolicy"
	CloudDeploy_UpdateDeployPolicy_FullMethodName     = "/google.cloud.deploy.v1.CloudDeploy/UpdateDeployPolicy"
	CloudDeploy_DeleteDeployPolicy_FullMethodName     = "/google.cloud.deploy.v1.CloudDeploy/DeleteDeployPolicy"
	CloudDeploy_ListDeployPolicies_FullMethodName     = "/google.cloud.deploy.v1.CloudDeploy/ListDeployPolicies"
	CloudDeploy_GetDeployPolicy_FullMethodName        = "/google.cloud.deploy.v1.CloudDeploy/GetDeployPolicy"
	CloudDeploy_ApproveRollout_FullMethodName         = "/google.cloud.deploy.v1.CloudDeploy/ApproveRollout"
	CloudDeploy_AdvanceRollout_FullMethodName         = "/google.cloud.deploy.v1.CloudDeploy/AdvanceRollout"
	CloudDeploy_CancelRollout_FullMethodName          = "/google.cloud.deploy.v1.CloudDeploy/CancelRollout"
	CloudDeploy_ListRollouts_FullMethodName           = "/google.cloud.deploy.v1.CloudDeploy/ListRollouts"
	CloudDeploy_GetRollout_FullMethodName             = "/google.cloud.deploy.v1.CloudDeploy/GetRollout"
	CloudDeploy_CreateRollout_FullMethodName          = "/google.cloud.deploy.v1.CloudDeploy/CreateRollout"
	CloudDeploy_IgnoreJob_FullMethodName              = "/google.cloud.deploy.v1.CloudDeploy/IgnoreJob"
	CloudDeploy_RetryJob_FullMethodName               = "/google.cloud.deploy.v1.CloudDeploy/RetryJob"
	CloudDeploy_ListJobRuns_FullMethodName            = "/google.cloud.deploy.v1.CloudDeploy/ListJobRuns"
	CloudDeploy_GetJobRun_FullMethodName              = "/google.cloud.deploy.v1.CloudDeploy/GetJobRun"
	CloudDeploy_TerminateJobRun_FullMethodName        = "/google.cloud.deploy.v1.CloudDeploy/TerminateJobRun"
	CloudDeploy_GetConfig_FullMethodName              = "/google.cloud.deploy.v1.CloudDeploy/GetConfig"
	CloudDeploy_CreateAutomation_FullMethodName       = "/google.cloud.deploy.v1.CloudDeploy/CreateAutomation"
	CloudDeploy_UpdateAutomation_FullMethodName       = "/google.cloud.deploy.v1.CloudDeploy/UpdateAutomation"
	CloudDeploy_DeleteAutomation_FullMethodName       = "/google.cloud.deploy.v1.CloudDeploy/DeleteAutomation"
	CloudDeploy_GetAutomation_FullMethodName          = "/google.cloud.deploy.v1.CloudDeploy/GetAutomation"
	CloudDeploy_ListAutomations_FullMethodName        = "/google.cloud.deploy.v1.CloudDeploy/ListAutomations"
	CloudDeploy_GetAutomationRun_FullMethodName       = "/google.cloud.deploy.v1.CloudDeploy/GetAutomationRun"
	CloudDeploy_ListAutomationRuns_FullMethodName     = "/google.cloud.deploy.v1.CloudDeploy/ListAutomationRuns"
	CloudDeploy_CancelAutomationRun_FullMethodName    = "/google.cloud.deploy.v1.CloudDeploy/CancelAutomationRun"
)

// CloudDeployClient is the client API for CloudDeploy service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type CloudDeployClient interface {
	// Lists DeliveryPipelines in a given project and location.
	ListDeliveryPipelines(ctx context.Context, in *ListDeliveryPipelinesRequest, opts ...grpc.CallOption) (*ListDeliveryPipelinesResponse, error)
	// Gets details of a single DeliveryPipeline.
	GetDeliveryPipeline(ctx context.Context, in *GetDeliveryPipelineRequest, opts ...grpc.CallOption) (*DeliveryPipeline, error)
	// Creates a new DeliveryPipeline in a given project and location.
	CreateDeliveryPipeline(ctx context.Context, in *CreateDeliveryPipelineRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the parameters of a single DeliveryPipeline.
	UpdateDeliveryPipeline(ctx context.Context, in *UpdateDeliveryPipelineRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single DeliveryPipeline.
	DeleteDeliveryPipeline(ctx context.Context, in *DeleteDeliveryPipelineRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists Targets in a given project and location.
	ListTargets(ctx context.Context, in *ListTargetsRequest, opts ...grpc.CallOption) (*ListTargetsResponse, error)
	// Creates a `Rollout` to roll back the specified target.
	RollbackTarget(ctx context.Context, in *RollbackTargetRequest, opts ...grpc.CallOption) (*RollbackTargetResponse, error)
	// Gets details of a single Target.
	GetTarget(ctx context.Context, in *GetTargetRequest, opts ...grpc.CallOption) (*Target, error)
	// Creates a new Target in a given project and location.
	CreateTarget(ctx context.Context, in *CreateTargetRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the parameters of a single Target.
	UpdateTarget(ctx context.Context, in *UpdateTargetRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single Target.
	DeleteTarget(ctx context.Context, in *DeleteTargetRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists CustomTargetTypes in a given project and location.
	ListCustomTargetTypes(ctx context.Context, in *ListCustomTargetTypesRequest, opts ...grpc.CallOption) (*ListCustomTargetTypesResponse, error)
	// Gets details of a single CustomTargetType.
	GetCustomTargetType(ctx context.Context, in *GetCustomTargetTypeRequest, opts ...grpc.CallOption) (*CustomTargetType, error)
	// Creates a new CustomTargetType in a given project and location.
	CreateCustomTargetType(ctx context.Context, in *CreateCustomTargetTypeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates a single CustomTargetType.
	UpdateCustomTargetType(ctx context.Context, in *UpdateCustomTargetTypeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single CustomTargetType.
	DeleteCustomTargetType(ctx context.Context, in *DeleteCustomTargetTypeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists Releases in a given project and location.
	ListReleases(ctx context.Context, in *ListReleasesRequest, opts ...grpc.CallOption) (*ListReleasesResponse, error)
	// Gets details of a single Release.
	GetRelease(ctx context.Context, in *GetReleaseRequest, opts ...grpc.CallOption) (*Release, error)
	// Creates a new Release in a given project and location.
	CreateRelease(ctx context.Context, in *CreateReleaseRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Abandons a Release in the Delivery Pipeline.
	AbandonRelease(ctx context.Context, in *AbandonReleaseRequest, opts ...grpc.CallOption) (*AbandonReleaseResponse, error)
	// Creates a new DeployPolicy in a given project and location.
	CreateDeployPolicy(ctx context.Context, in *CreateDeployPolicyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the parameters of a single DeployPolicy.
	UpdateDeployPolicy(ctx context.Context, in *UpdateDeployPolicyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single DeployPolicy.
	DeleteDeployPolicy(ctx context.Context, in *DeleteDeployPolicyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists DeployPolicies in a given project and location.
	ListDeployPolicies(ctx context.Context, in *ListDeployPoliciesRequest, opts ...grpc.CallOption) (*ListDeployPoliciesResponse, error)
	// Gets details of a single DeployPolicy.
	GetDeployPolicy(ctx context.Context, in *GetDeployPolicyRequest, opts ...grpc.CallOption) (*DeployPolicy, error)
	// Approves a Rollout.
	ApproveRollout(ctx context.Context, in *ApproveRolloutRequest, opts ...grpc.CallOption) (*ApproveRolloutResponse, error)
	// Advances a Rollout in a given project and location.
	AdvanceRollout(ctx context.Context, in *AdvanceRolloutRequest, opts ...grpc.CallOption) (*AdvanceRolloutResponse, error)
	// Cancels a Rollout in a given project and location.
	CancelRollout(ctx context.Context, in *CancelRolloutRequest, opts ...grpc.CallOption) (*CancelRolloutResponse, error)
	// Lists Rollouts in a given project and location.
	ListRollouts(ctx context.Context, in *ListRolloutsRequest, opts ...grpc.CallOption) (*ListRolloutsResponse, error)
	// Gets details of a single Rollout.
	GetRollout(ctx context.Context, in *GetRolloutRequest, opts ...grpc.CallOption) (*Rollout, error)
	// Creates a new Rollout in a given project and location.
	CreateRollout(ctx context.Context, in *CreateRolloutRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Ignores the specified Job in a Rollout.
	IgnoreJob(ctx context.Context, in *IgnoreJobRequest, opts ...grpc.CallOption) (*IgnoreJobResponse, error)
	// Retries the specified Job in a Rollout.
	RetryJob(ctx context.Context, in *RetryJobRequest, opts ...grpc.CallOption) (*RetryJobResponse, error)
	// Lists JobRuns in a given project and location.
	ListJobRuns(ctx context.Context, in *ListJobRunsRequest, opts ...grpc.CallOption) (*ListJobRunsResponse, error)
	// Gets details of a single JobRun.
	GetJobRun(ctx context.Context, in *GetJobRunRequest, opts ...grpc.CallOption) (*JobRun, error)
	// Terminates a Job Run in a given project and location.
	TerminateJobRun(ctx context.Context, in *TerminateJobRunRequest, opts ...grpc.CallOption) (*TerminateJobRunResponse, error)
	// Gets the configuration for a location.
	GetConfig(ctx context.Context, in *GetConfigRequest, opts ...grpc.CallOption) (*Config, error)
	// Creates a new Automation in a given project and location.
	CreateAutomation(ctx context.Context, in *CreateAutomationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the parameters of a single Automation resource.
	UpdateAutomation(ctx context.Context, in *UpdateAutomationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single Automation resource.
	DeleteAutomation(ctx context.Context, in *DeleteAutomationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets details of a single Automation.
	GetAutomation(ctx context.Context, in *GetAutomationRequest, opts ...grpc.CallOption) (*Automation, error)
	// Lists Automations in a given project and location.
	ListAutomations(ctx context.Context, in *ListAutomationsRequest, opts ...grpc.CallOption) (*ListAutomationsResponse, error)
	// Gets details of a single AutomationRun.
	GetAutomationRun(ctx context.Context, in *GetAutomationRunRequest, opts ...grpc.CallOption) (*AutomationRun, error)
	// Lists AutomationRuns in a given project and location.
	ListAutomationRuns(ctx context.Context, in *ListAutomationRunsRequest, opts ...grpc.CallOption) (*ListAutomationRunsResponse, error)
	// Cancels an AutomationRun. The `state` of the `AutomationRun` after
	// cancelling is `CANCELLED`. `CancelAutomationRun` can be called on
	// AutomationRun in the state `IN_PROGRESS` and `PENDING`; AutomationRun
	// in a different state returns an `FAILED_PRECONDITION` error.
	CancelAutomationRun(ctx context.Context, in *CancelAutomationRunRequest, opts ...grpc.CallOption) (*CancelAutomationRunResponse, error)
}

type cloudDeployClient struct {
	cc grpc.ClientConnInterface
}

func NewCloudDeployClient(cc grpc.ClientConnInterface) CloudDeployClient {
	return &cloudDeployClient{cc}
}

func (c *cloudDeployClient) ListDeliveryPipelines(ctx context.Context, in *ListDeliveryPipelinesRequest, opts ...grpc.CallOption) (*ListDeliveryPipelinesResponse, error) {
	out := new(ListDeliveryPipelinesResponse)
	err := c.cc.Invoke(ctx, CloudDeploy_ListDeliveryPipelines_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) GetDeliveryPipeline(ctx context.Context, in *GetDeliveryPipelineRequest, opts ...grpc.CallOption) (*DeliveryPipeline, error) {
	out := new(DeliveryPipeline)
	err := c.cc.Invoke(ctx, CloudDeploy_GetDeliveryPipeline_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) CreateDeliveryPipeline(ctx context.Context, in *CreateDeliveryPipelineRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CloudDeploy_CreateDeliveryPipeline_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) UpdateDeliveryPipeline(ctx context.Context, in *UpdateDeliveryPipelineRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CloudDeploy_UpdateDeliveryPipeline_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) DeleteDeliveryPipeline(ctx context.Context, in *DeleteDeliveryPipelineRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CloudDeploy_DeleteDeliveryPipeline_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) ListTargets(ctx context.Context, in *ListTargetsRequest, opts ...grpc.CallOption) (*ListTargetsResponse, error) {
	out := new(ListTargetsResponse)
	err := c.cc.Invoke(ctx, CloudDeploy_ListTargets_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) RollbackTarget(ctx context.Context, in *RollbackTargetRequest, opts ...grpc.CallOption) (*RollbackTargetResponse, error) {
	out := new(RollbackTargetResponse)
	err := c.cc.Invoke(ctx, CloudDeploy_RollbackTarget_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) GetTarget(ctx context.Context, in *GetTargetRequest, opts ...grpc.CallOption) (*Target, error) {
	out := new(Target)
	err := c.cc.Invoke(ctx, CloudDeploy_GetTarget_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) CreateTarget(ctx context.Context, in *CreateTargetRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CloudDeploy_CreateTarget_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) UpdateTarget(ctx context.Context, in *UpdateTargetRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CloudDeploy_UpdateTarget_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) DeleteTarget(ctx context.Context, in *DeleteTargetRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CloudDeploy_DeleteTarget_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) ListCustomTargetTypes(ctx context.Context, in *ListCustomTargetTypesRequest, opts ...grpc.CallOption) (*ListCustomTargetTypesResponse, error) {
	out := new(ListCustomTargetTypesResponse)
	err := c.cc.Invoke(ctx, CloudDeploy_ListCustomTargetTypes_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) GetCustomTargetType(ctx context.Context, in *GetCustomTargetTypeRequest, opts ...grpc.CallOption) (*CustomTargetType, error) {
	out := new(CustomTargetType)
	err := c.cc.Invoke(ctx, CloudDeploy_GetCustomTargetType_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) CreateCustomTargetType(ctx context.Context, in *CreateCustomTargetTypeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CloudDeploy_CreateCustomTargetType_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) UpdateCustomTargetType(ctx context.Context, in *UpdateCustomTargetTypeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CloudDeploy_UpdateCustomTargetType_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) DeleteCustomTargetType(ctx context.Context, in *DeleteCustomTargetTypeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CloudDeploy_DeleteCustomTargetType_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) ListReleases(ctx context.Context, in *ListReleasesRequest, opts ...grpc.CallOption) (*ListReleasesResponse, error) {
	out := new(ListReleasesResponse)
	err := c.cc.Invoke(ctx, CloudDeploy_ListReleases_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) GetRelease(ctx context.Context, in *GetReleaseRequest, opts ...grpc.CallOption) (*Release, error) {
	out := new(Release)
	err := c.cc.Invoke(ctx, CloudDeploy_GetRelease_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) CreateRelease(ctx context.Context, in *CreateReleaseRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CloudDeploy_CreateRelease_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) AbandonRelease(ctx context.Context, in *AbandonReleaseRequest, opts ...grpc.CallOption) (*AbandonReleaseResponse, error) {
	out := new(AbandonReleaseResponse)
	err := c.cc.Invoke(ctx, CloudDeploy_AbandonRelease_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) CreateDeployPolicy(ctx context.Context, in *CreateDeployPolicyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CloudDeploy_CreateDeployPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) UpdateDeployPolicy(ctx context.Context, in *UpdateDeployPolicyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CloudDeploy_UpdateDeployPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) DeleteDeployPolicy(ctx context.Context, in *DeleteDeployPolicyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CloudDeploy_DeleteDeployPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) ListDeployPolicies(ctx context.Context, in *ListDeployPoliciesRequest, opts ...grpc.CallOption) (*ListDeployPoliciesResponse, error) {
	out := new(ListDeployPoliciesResponse)
	err := c.cc.Invoke(ctx, CloudDeploy_ListDeployPolicies_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) GetDeployPolicy(ctx context.Context, in *GetDeployPolicyRequest, opts ...grpc.CallOption) (*DeployPolicy, error) {
	out := new(DeployPolicy)
	err := c.cc.Invoke(ctx, CloudDeploy_GetDeployPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) ApproveRollout(ctx context.Context, in *ApproveRolloutRequest, opts ...grpc.CallOption) (*ApproveRolloutResponse, error) {
	out := new(ApproveRolloutResponse)
	err := c.cc.Invoke(ctx, CloudDeploy_ApproveRollout_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) AdvanceRollout(ctx context.Context, in *AdvanceRolloutRequest, opts ...grpc.CallOption) (*AdvanceRolloutResponse, error) {
	out := new(AdvanceRolloutResponse)
	err := c.cc.Invoke(ctx, CloudDeploy_AdvanceRollout_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) CancelRollout(ctx context.Context, in *CancelRolloutRequest, opts ...grpc.CallOption) (*CancelRolloutResponse, error) {
	out := new(CancelRolloutResponse)
	err := c.cc.Invoke(ctx, CloudDeploy_CancelRollout_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) ListRollouts(ctx context.Context, in *ListRolloutsRequest, opts ...grpc.CallOption) (*ListRolloutsResponse, error) {
	out := new(ListRolloutsResponse)
	err := c.cc.Invoke(ctx, CloudDeploy_ListRollouts_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) GetRollout(ctx context.Context, in *GetRolloutRequest, opts ...grpc.CallOption) (*Rollout, error) {
	out := new(Rollout)
	err := c.cc.Invoke(ctx, CloudDeploy_GetRollout_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) CreateRollout(ctx context.Context, in *CreateRolloutRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CloudDeploy_CreateRollout_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) IgnoreJob(ctx context.Context, in *IgnoreJobRequest, opts ...grpc.CallOption) (*IgnoreJobResponse, error) {
	out := new(IgnoreJobResponse)
	err := c.cc.Invoke(ctx, CloudDeploy_IgnoreJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) RetryJob(ctx context.Context, in *RetryJobRequest, opts ...grpc.CallOption) (*RetryJobResponse, error) {
	out := new(RetryJobResponse)
	err := c.cc.Invoke(ctx, CloudDeploy_RetryJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) ListJobRuns(ctx context.Context, in *ListJobRunsRequest, opts ...grpc.CallOption) (*ListJobRunsResponse, error) {
	out := new(ListJobRunsResponse)
	err := c.cc.Invoke(ctx, CloudDeploy_ListJobRuns_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) GetJobRun(ctx context.Context, in *GetJobRunRequest, opts ...grpc.CallOption) (*JobRun, error) {
	out := new(JobRun)
	err := c.cc.Invoke(ctx, CloudDeploy_GetJobRun_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) TerminateJobRun(ctx context.Context, in *TerminateJobRunRequest, opts ...grpc.CallOption) (*TerminateJobRunResponse, error) {
	out := new(TerminateJobRunResponse)
	err := c.cc.Invoke(ctx, CloudDeploy_TerminateJobRun_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) GetConfig(ctx context.Context, in *GetConfigRequest, opts ...grpc.CallOption) (*Config, error) {
	out := new(Config)
	err := c.cc.Invoke(ctx, CloudDeploy_GetConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) CreateAutomation(ctx context.Context, in *CreateAutomationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CloudDeploy_CreateAutomation_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) UpdateAutomation(ctx context.Context, in *UpdateAutomationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CloudDeploy_UpdateAutomation_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) DeleteAutomation(ctx context.Context, in *DeleteAutomationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CloudDeploy_DeleteAutomation_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) GetAutomation(ctx context.Context, in *GetAutomationRequest, opts ...grpc.CallOption) (*Automation, error) {
	out := new(Automation)
	err := c.cc.Invoke(ctx, CloudDeploy_GetAutomation_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) ListAutomations(ctx context.Context, in *ListAutomationsRequest, opts ...grpc.CallOption) (*ListAutomationsResponse, error) {
	out := new(ListAutomationsResponse)
	err := c.cc.Invoke(ctx, CloudDeploy_ListAutomations_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) GetAutomationRun(ctx context.Context, in *GetAutomationRunRequest, opts ...grpc.CallOption) (*AutomationRun, error) {
	out := new(AutomationRun)
	err := c.cc.Invoke(ctx, CloudDeploy_GetAutomationRun_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) ListAutomationRuns(ctx context.Context, in *ListAutomationRunsRequest, opts ...grpc.CallOption) (*ListAutomationRunsResponse, error) {
	out := new(ListAutomationRunsResponse)
	err := c.cc.Invoke(ctx, CloudDeploy_ListAutomationRuns_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) CancelAutomationRun(ctx context.Context, in *CancelAutomationRunRequest, opts ...grpc.CallOption) (*CancelAutomationRunResponse, error) {
	out := new(CancelAutomationRunResponse)
	err := c.cc.Invoke(ctx, CloudDeploy_CancelAutomationRun_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CloudDeployServer is the server API for CloudDeploy service.
// All implementations should embed UnimplementedCloudDeployServer
// for forward compatibility
type CloudDeployServer interface {
	// Lists DeliveryPipelines in a given project and location.
	ListDeliveryPipelines(context.Context, *ListDeliveryPipelinesRequest) (*ListDeliveryPipelinesResponse, error)
	// Gets details of a single DeliveryPipeline.
	GetDeliveryPipeline(context.Context, *GetDeliveryPipelineRequest) (*DeliveryPipeline, error)
	// Creates a new DeliveryPipeline in a given project and location.
	CreateDeliveryPipeline(context.Context, *CreateDeliveryPipelineRequest) (*longrunningpb.Operation, error)
	// Updates the parameters of a single DeliveryPipeline.
	UpdateDeliveryPipeline(context.Context, *UpdateDeliveryPipelineRequest) (*longrunningpb.Operation, error)
	// Deletes a single DeliveryPipeline.
	DeleteDeliveryPipeline(context.Context, *DeleteDeliveryPipelineRequest) (*longrunningpb.Operation, error)
	// Lists Targets in a given project and location.
	ListTargets(context.Context, *ListTargetsRequest) (*ListTargetsResponse, error)
	// Creates a `Rollout` to roll back the specified target.
	RollbackTarget(context.Context, *RollbackTargetRequest) (*RollbackTargetResponse, error)
	// Gets details of a single Target.
	GetTarget(context.Context, *GetTargetRequest) (*Target, error)
	// Creates a new Target in a given project and location.
	CreateTarget(context.Context, *CreateTargetRequest) (*longrunningpb.Operation, error)
	// Updates the parameters of a single Target.
	UpdateTarget(context.Context, *UpdateTargetRequest) (*longrunningpb.Operation, error)
	// Deletes a single Target.
	DeleteTarget(context.Context, *DeleteTargetRequest) (*longrunningpb.Operation, error)
	// Lists CustomTargetTypes in a given project and location.
	ListCustomTargetTypes(context.Context, *ListCustomTargetTypesRequest) (*ListCustomTargetTypesResponse, error)
	// Gets details of a single CustomTargetType.
	GetCustomTargetType(context.Context, *GetCustomTargetTypeRequest) (*CustomTargetType, error)
	// Creates a new CustomTargetType in a given project and location.
	CreateCustomTargetType(context.Context, *CreateCustomTargetTypeRequest) (*longrunningpb.Operation, error)
	// Updates a single CustomTargetType.
	UpdateCustomTargetType(context.Context, *UpdateCustomTargetTypeRequest) (*longrunningpb.Operation, error)
	// Deletes a single CustomTargetType.
	DeleteCustomTargetType(context.Context, *DeleteCustomTargetTypeRequest) (*longrunningpb.Operation, error)
	// Lists Releases in a given project and location.
	ListReleases(context.Context, *ListReleasesRequest) (*ListReleasesResponse, error)
	// Gets details of a single Release.
	GetRelease(context.Context, *GetReleaseRequest) (*Release, error)
	// Creates a new Release in a given project and location.
	CreateRelease(context.Context, *CreateReleaseRequest) (*longrunningpb.Operation, error)
	// Abandons a Release in the Delivery Pipeline.
	AbandonRelease(context.Context, *AbandonReleaseRequest) (*AbandonReleaseResponse, error)
	// Creates a new DeployPolicy in a given project and location.
	CreateDeployPolicy(context.Context, *CreateDeployPolicyRequest) (*longrunningpb.Operation, error)
	// Updates the parameters of a single DeployPolicy.
	UpdateDeployPolicy(context.Context, *UpdateDeployPolicyRequest) (*longrunningpb.Operation, error)
	// Deletes a single DeployPolicy.
	DeleteDeployPolicy(context.Context, *DeleteDeployPolicyRequest) (*longrunningpb.Operation, error)
	// Lists DeployPolicies in a given project and location.
	ListDeployPolicies(context.Context, *ListDeployPoliciesRequest) (*ListDeployPoliciesResponse, error)
	// Gets details of a single DeployPolicy.
	GetDeployPolicy(context.Context, *GetDeployPolicyRequest) (*DeployPolicy, error)
	// Approves a Rollout.
	ApproveRollout(context.Context, *ApproveRolloutRequest) (*ApproveRolloutResponse, error)
	// Advances a Rollout in a given project and location.
	AdvanceRollout(context.Context, *AdvanceRolloutRequest) (*AdvanceRolloutResponse, error)
	// Cancels a Rollout in a given project and location.
	CancelRollout(context.Context, *CancelRolloutRequest) (*CancelRolloutResponse, error)
	// Lists Rollouts in a given project and location.
	ListRollouts(context.Context, *ListRolloutsRequest) (*ListRolloutsResponse, error)
	// Gets details of a single Rollout.
	GetRollout(context.Context, *GetRolloutRequest) (*Rollout, error)
	// Creates a new Rollout in a given project and location.
	CreateRollout(context.Context, *CreateRolloutRequest) (*longrunningpb.Operation, error)
	// Ignores the specified Job in a Rollout.
	IgnoreJob(context.Context, *IgnoreJobRequest) (*IgnoreJobResponse, error)
	// Retries the specified Job in a Rollout.
	RetryJob(context.Context, *RetryJobRequest) (*RetryJobResponse, error)
	// Lists JobRuns in a given project and location.
	ListJobRuns(context.Context, *ListJobRunsRequest) (*ListJobRunsResponse, error)
	// Gets details of a single JobRun.
	GetJobRun(context.Context, *GetJobRunRequest) (*JobRun, error)
	// Terminates a Job Run in a given project and location.
	TerminateJobRun(context.Context, *TerminateJobRunRequest) (*TerminateJobRunResponse, error)
	// Gets the configuration for a location.
	GetConfig(context.Context, *GetConfigRequest) (*Config, error)
	// Creates a new Automation in a given project and location.
	CreateAutomation(context.Context, *CreateAutomationRequest) (*longrunningpb.Operation, error)
	// Updates the parameters of a single Automation resource.
	UpdateAutomation(context.Context, *UpdateAutomationRequest) (*longrunningpb.Operation, error)
	// Deletes a single Automation resource.
	DeleteAutomation(context.Context, *DeleteAutomationRequest) (*longrunningpb.Operation, error)
	// Gets details of a single Automation.
	GetAutomation(context.Context, *GetAutomationRequest) (*Automation, error)
	// Lists Automations in a given project and location.
	ListAutomations(context.Context, *ListAutomationsRequest) (*ListAutomationsResponse, error)
	// Gets details of a single AutomationRun.
	GetAutomationRun(context.Context, *GetAutomationRunRequest) (*AutomationRun, error)
	// Lists AutomationRuns in a given project and location.
	ListAutomationRuns(context.Context, *ListAutomationRunsRequest) (*ListAutomationRunsResponse, error)
	// Cancels an AutomationRun. The `state` of the `AutomationRun` after
	// cancelling is `CANCELLED`. `CancelAutomationRun` can be called on
	// AutomationRun in the state `IN_PROGRESS` and `PENDING`; AutomationRun
	// in a different state returns an `FAILED_PRECONDITION` error.
	CancelAutomationRun(context.Context, *CancelAutomationRunRequest) (*CancelAutomationRunResponse, error)
}

// UnimplementedCloudDeployServer should be embedded to have forward compatible implementations.
type UnimplementedCloudDeployServer struct {
}

func (UnimplementedCloudDeployServer) ListDeliveryPipelines(context.Context, *ListDeliveryPipelinesRequest) (*ListDeliveryPipelinesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDeliveryPipelines not implemented")
}
func (UnimplementedCloudDeployServer) GetDeliveryPipeline(context.Context, *GetDeliveryPipelineRequest) (*DeliveryPipeline, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDeliveryPipeline not implemented")
}
func (UnimplementedCloudDeployServer) CreateDeliveryPipeline(context.Context, *CreateDeliveryPipelineRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateDeliveryPipeline not implemented")
}
func (UnimplementedCloudDeployServer) UpdateDeliveryPipeline(context.Context, *UpdateDeliveryPipelineRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateDeliveryPipeline not implemented")
}
func (UnimplementedCloudDeployServer) DeleteDeliveryPipeline(context.Context, *DeleteDeliveryPipelineRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteDeliveryPipeline not implemented")
}
func (UnimplementedCloudDeployServer) ListTargets(context.Context, *ListTargetsRequest) (*ListTargetsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTargets not implemented")
}
func (UnimplementedCloudDeployServer) RollbackTarget(context.Context, *RollbackTargetRequest) (*RollbackTargetResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RollbackTarget not implemented")
}
func (UnimplementedCloudDeployServer) GetTarget(context.Context, *GetTargetRequest) (*Target, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTarget not implemented")
}
func (UnimplementedCloudDeployServer) CreateTarget(context.Context, *CreateTargetRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateTarget not implemented")
}
func (UnimplementedCloudDeployServer) UpdateTarget(context.Context, *UpdateTargetRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateTarget not implemented")
}
func (UnimplementedCloudDeployServer) DeleteTarget(context.Context, *DeleteTargetRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteTarget not implemented")
}
func (UnimplementedCloudDeployServer) ListCustomTargetTypes(context.Context, *ListCustomTargetTypesRequest) (*ListCustomTargetTypesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListCustomTargetTypes not implemented")
}
func (UnimplementedCloudDeployServer) GetCustomTargetType(context.Context, *GetCustomTargetTypeRequest) (*CustomTargetType, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCustomTargetType not implemented")
}
func (UnimplementedCloudDeployServer) CreateCustomTargetType(context.Context, *CreateCustomTargetTypeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateCustomTargetType not implemented")
}
func (UnimplementedCloudDeployServer) UpdateCustomTargetType(context.Context, *UpdateCustomTargetTypeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateCustomTargetType not implemented")
}
func (UnimplementedCloudDeployServer) DeleteCustomTargetType(context.Context, *DeleteCustomTargetTypeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteCustomTargetType not implemented")
}
func (UnimplementedCloudDeployServer) ListReleases(context.Context, *ListReleasesRequest) (*ListReleasesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListReleases not implemented")
}
func (UnimplementedCloudDeployServer) GetRelease(context.Context, *GetReleaseRequest) (*Release, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetRelease not implemented")
}
func (UnimplementedCloudDeployServer) CreateRelease(context.Context, *CreateReleaseRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateRelease not implemented")
}
func (UnimplementedCloudDeployServer) AbandonRelease(context.Context, *AbandonReleaseRequest) (*AbandonReleaseResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AbandonRelease not implemented")
}
func (UnimplementedCloudDeployServer) CreateDeployPolicy(context.Context, *CreateDeployPolicyRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateDeployPolicy not implemented")
}
func (UnimplementedCloudDeployServer) UpdateDeployPolicy(context.Context, *UpdateDeployPolicyRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateDeployPolicy not implemented")
}
func (UnimplementedCloudDeployServer) DeleteDeployPolicy(context.Context, *DeleteDeployPolicyRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteDeployPolicy not implemented")
}
func (UnimplementedCloudDeployServer) ListDeployPolicies(context.Context, *ListDeployPoliciesRequest) (*ListDeployPoliciesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDeployPolicies not implemented")
}
func (UnimplementedCloudDeployServer) GetDeployPolicy(context.Context, *GetDeployPolicyRequest) (*DeployPolicy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDeployPolicy not implemented")
}
func (UnimplementedCloudDeployServer) ApproveRollout(context.Context, *ApproveRolloutRequest) (*ApproveRolloutResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ApproveRollout not implemented")
}
func (UnimplementedCloudDeployServer) AdvanceRollout(context.Context, *AdvanceRolloutRequest) (*AdvanceRolloutResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AdvanceRollout not implemented")
}
func (UnimplementedCloudDeployServer) CancelRollout(context.Context, *CancelRolloutRequest) (*CancelRolloutResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CancelRollout not implemented")
}
func (UnimplementedCloudDeployServer) ListRollouts(context.Context, *ListRolloutsRequest) (*ListRolloutsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListRollouts not implemented")
}
func (UnimplementedCloudDeployServer) GetRollout(context.Context, *GetRolloutRequest) (*Rollout, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetRollout not implemented")
}
func (UnimplementedCloudDeployServer) CreateRollout(context.Context, *CreateRolloutRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateRollout not implemented")
}
func (UnimplementedCloudDeployServer) IgnoreJob(context.Context, *IgnoreJobRequest) (*IgnoreJobResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method IgnoreJob not implemented")
}
func (UnimplementedCloudDeployServer) RetryJob(context.Context, *RetryJobRequest) (*RetryJobResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RetryJob not implemented")
}
func (UnimplementedCloudDeployServer) ListJobRuns(context.Context, *ListJobRunsRequest) (*ListJobRunsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListJobRuns not implemented")
}
func (UnimplementedCloudDeployServer) GetJobRun(context.Context, *GetJobRunRequest) (*JobRun, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetJobRun not implemented")
}
func (UnimplementedCloudDeployServer) TerminateJobRun(context.Context, *TerminateJobRunRequest) (*TerminateJobRunResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TerminateJobRun not implemented")
}
func (UnimplementedCloudDeployServer) GetConfig(context.Context, *GetConfigRequest) (*Config, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetConfig not implemented")
}
func (UnimplementedCloudDeployServer) CreateAutomation(context.Context, *CreateAutomationRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateAutomation not implemented")
}
func (UnimplementedCloudDeployServer) UpdateAutomation(context.Context, *UpdateAutomationRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateAutomation not implemented")
}
func (UnimplementedCloudDeployServer) DeleteAutomation(context.Context, *DeleteAutomationRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAutomation not implemented")
}
func (UnimplementedCloudDeployServer) GetAutomation(context.Context, *GetAutomationRequest) (*Automation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAutomation not implemented")
}
func (UnimplementedCloudDeployServer) ListAutomations(context.Context, *ListAutomationsRequest) (*ListAutomationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAutomations not implemented")
}
func (UnimplementedCloudDeployServer) GetAutomationRun(context.Context, *GetAutomationRunRequest) (*AutomationRun, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAutomationRun not implemented")
}
func (UnimplementedCloudDeployServer) ListAutomationRuns(context.Context, *ListAutomationRunsRequest) (*ListAutomationRunsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAutomationRuns not implemented")
}
func (UnimplementedCloudDeployServer) CancelAutomationRun(context.Context, *CancelAutomationRunRequest) (*CancelAutomationRunResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CancelAutomationRun not implemented")
}

// UnsafeCloudDeployServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to CloudDeployServer will
// result in compilation errors.
type UnsafeCloudDeployServer interface {
	mustEmbedUnimplementedCloudDeployServer()
}

func RegisterCloudDeployServer(s grpc.ServiceRegistrar, srv CloudDeployServer) {
	s.RegisterService(&CloudDeploy_ServiceDesc, srv)
}

func _CloudDeploy_ListDeliveryPipelines_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDeliveryPipelinesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).ListDeliveryPipelines(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudDeploy_ListDeliveryPipelines_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).ListDeliveryPipelines(ctx, req.(*ListDeliveryPipelinesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_GetDeliveryPipeline_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDeliveryPipelineRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).GetDeliveryPipeline(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudDeploy_GetDeliveryPipeline_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).GetDeliveryPipeline(ctx, req.(*GetDeliveryPipelineRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_CreateDeliveryPipeline_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDeliveryPipelineRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).CreateDeliveryPipeline(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudDeploy_CreateDeliveryPipeline_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).CreateDeliveryPipeline(ctx, req.(*CreateDeliveryPipelineRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_UpdateDeliveryPipeline_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDeliveryPipelineRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).UpdateDeliveryPipeline(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudDeploy_UpdateDeliveryPipeline_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).UpdateDeliveryPipeline(ctx, req.(*UpdateDeliveryPipelineRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_DeleteDeliveryPipeline_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDeliveryPipelineRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).DeleteDeliveryPipeline(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudDeploy_DeleteDeliveryPipeline_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).DeleteDeliveryPipeline(ctx, req.(*DeleteDeliveryPipelineRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_ListTargets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTargetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).ListTargets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudDeploy_ListTargets_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).ListTargets(ctx, req.(*ListTargetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_RollbackTarget_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RollbackTargetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).RollbackTarget(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudDeploy_RollbackTarget_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).RollbackTarget(ctx, req.(*RollbackTargetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_GetTarget_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTargetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).GetTarget(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudDeploy_GetTarget_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).GetTarget(ctx, req.(*GetTargetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_CreateTarget_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTargetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).CreateTarget(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudDeploy_CreateTarget_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).CreateTarget(ctx, req.(*CreateTargetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_UpdateTarget_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateTargetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).UpdateTarget(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudDeploy_UpdateTarget_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).UpdateTarget(ctx, req.(*UpdateTargetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_DeleteTarget_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTargetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).DeleteTarget(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudDeploy_DeleteTarget_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).DeleteTarget(ctx, req.(*DeleteTargetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_ListCustomTargetTypes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCustomTargetTypesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).ListCustomTargetTypes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudDeploy_ListCustomTargetTypes_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).ListCustomTargetTypes(ctx, req.(*ListCustomTargetTypesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_GetCustomTargetType_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCustomTargetTypeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).GetCustomTargetType(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudDeploy_GetCustomTargetType_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).GetCustomTargetType(ctx, req.(*GetCustomTargetTypeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_CreateCustomTargetType_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateCustomTargetTypeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).CreateCustomTargetType(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudDeploy_CreateCustomTargetType_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).CreateCustomTargetType(ctx, req.(*CreateCustomTargetTypeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_UpdateCustomTargetType_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateCustomTargetTypeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).UpdateCustomTargetType(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudDeploy_UpdateCustomTargetType_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).UpdateCustomTargetType(ctx, req.(*UpdateCustomTargetTypeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_DeleteCustomTargetType_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteCustomTargetTypeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).DeleteCustomTargetType(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudDeploy_DeleteCustomTargetType_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).DeleteCustomTargetType(ctx, req.(*DeleteCustomTargetTypeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_ListReleases_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListReleasesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).ListReleases(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudDeploy_ListReleases_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).ListReleases(ctx, req.(*ListReleasesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_GetRelease_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetReleaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).GetRelease(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudDeploy_GetRelease_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).GetRelease(ctx, req.(*GetReleaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_CreateRelease_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateReleaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).CreateRelease(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudDeploy_CreateRelease_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).CreateRelease(ctx, req.(*CreateReleaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_AbandonRelease_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AbandonReleaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).AbandonRelease(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudDeploy_AbandonRelease_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).AbandonRelease(ctx, req.(*AbandonReleaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_CreateDeployPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDeployPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).CreateDeployPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudDeploy_CreateDeployPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).CreateDeployPolicy(ctx, req.(*CreateDeployPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_UpdateDeployPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDeployPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).UpdateDeployPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudDeploy_UpdateDeployPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).UpdateDeployPolicy(ctx, req.(*UpdateDeployPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_DeleteDeployPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDeployPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).DeleteDeployPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudDeploy_DeleteDeployPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).DeleteDeployPolicy(ctx, req.(*DeleteDeployPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_ListDeployPolicies_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDeployPoliciesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).ListDeployPolicies(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudDeploy_ListDeployPolicies_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).ListDeployPolicies(ctx, req.(*ListDeployPoliciesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_GetDeployPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDeployPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).GetDeployPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudDeploy_GetDeployPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).GetDeployPolicy(ctx, req.(*GetDeployPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_ApproveRollout_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ApproveRolloutRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).ApproveRollout(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudDeploy_ApproveRollout_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).ApproveRollout(ctx, req.(*ApproveRolloutRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_AdvanceRollout_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AdvanceRolloutRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).AdvanceRollout(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudDeploy_AdvanceRollout_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).AdvanceRollout(ctx, req.(*AdvanceRolloutRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_CancelRollout_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CancelRolloutRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).CancelRollout(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudDeploy_CancelRollout_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).CancelRollout(ctx, req.(*CancelRolloutRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_ListRollouts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListRolloutsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).ListRollouts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudDeploy_ListRollouts_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).ListRollouts(ctx, req.(*ListRolloutsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_GetRollout_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRolloutRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).GetRollout(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudDeploy_GetRollout_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).GetRollout(ctx, req.(*GetRolloutRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_CreateRollout_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateRolloutRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).CreateRollout(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudDeploy_CreateRollout_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).CreateRollout(ctx, req.(*CreateRolloutRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_IgnoreJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(IgnoreJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).IgnoreJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudDeploy_IgnoreJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).IgnoreJob(ctx, req.(*IgnoreJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_RetryJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RetryJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).RetryJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudDeploy_RetryJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).RetryJob(ctx, req.(*RetryJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_ListJobRuns_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListJobRunsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).ListJobRuns(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudDeploy_ListJobRuns_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).ListJobRuns(ctx, req.(*ListJobRunsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_GetJobRun_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetJobRunRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).GetJobRun(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudDeploy_GetJobRun_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).GetJobRun(ctx, req.(*GetJobRunRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_TerminateJobRun_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TerminateJobRunRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).TerminateJobRun(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudDeploy_TerminateJobRun_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).TerminateJobRun(ctx, req.(*TerminateJobRunRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_GetConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).GetConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudDeploy_GetConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).GetConfig(ctx, req.(*GetConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_CreateAutomation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAutomationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).CreateAutomation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudDeploy_CreateAutomation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).CreateAutomation(ctx, req.(*CreateAutomationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_UpdateAutomation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateAutomationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).UpdateAutomation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudDeploy_UpdateAutomation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).UpdateAutomation(ctx, req.(*UpdateAutomationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_DeleteAutomation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAutomationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).DeleteAutomation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudDeploy_DeleteAutomation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).DeleteAutomation(ctx, req.(*DeleteAutomationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_GetAutomation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAutomationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).GetAutomation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudDeploy_GetAutomation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).GetAutomation(ctx, req.(*GetAutomationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_ListAutomations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAutomationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).ListAutomations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudDeploy_ListAutomations_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).ListAutomations(ctx, req.(*ListAutomationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_GetAutomationRun_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAutomationRunRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).GetAutomationRun(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudDeploy_GetAutomationRun_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).GetAutomationRun(ctx, req.(*GetAutomationRunRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_ListAutomationRuns_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAutomationRunsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).ListAutomationRuns(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudDeploy_ListAutomationRuns_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).ListAutomationRuns(ctx, req.(*ListAutomationRunsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_CancelAutomationRun_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CancelAutomationRunRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).CancelAutomationRun(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudDeploy_CancelAutomationRun_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).CancelAutomationRun(ctx, req.(*CancelAutomationRunRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// CloudDeploy_ServiceDesc is the grpc.ServiceDesc for CloudDeploy service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var CloudDeploy_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.deploy.v1.CloudDeploy",
	HandlerType: (*CloudDeployServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListDeliveryPipelines",
			Handler:    _CloudDeploy_ListDeliveryPipelines_Handler,
		},
		{
			MethodName: "GetDeliveryPipeline",
			Handler:    _CloudDeploy_GetDeliveryPipeline_Handler,
		},
		{
			MethodName: "CreateDeliveryPipeline",
			Handler:    _CloudDeploy_CreateDeliveryPipeline_Handler,
		},
		{
			MethodName: "UpdateDeliveryPipeline",
			Handler:    _CloudDeploy_UpdateDeliveryPipeline_Handler,
		},
		{
			MethodName: "DeleteDeliveryPipeline",
			Handler:    _CloudDeploy_DeleteDeliveryPipeline_Handler,
		},
		{
			MethodName: "ListTargets",
			Handler:    _CloudDeploy_ListTargets_Handler,
		},
		{
			MethodName: "RollbackTarget",
			Handler:    _CloudDeploy_RollbackTarget_Handler,
		},
		{
			MethodName: "GetTarget",
			Handler:    _CloudDeploy_GetTarget_Handler,
		},
		{
			MethodName: "CreateTarget",
			Handler:    _CloudDeploy_CreateTarget_Handler,
		},
		{
			MethodName: "UpdateTarget",
			Handler:    _CloudDeploy_UpdateTarget_Handler,
		},
		{
			MethodName: "DeleteTarget",
			Handler:    _CloudDeploy_DeleteTarget_Handler,
		},
		{
			MethodName: "ListCustomTargetTypes",
			Handler:    _CloudDeploy_ListCustomTargetTypes_Handler,
		},
		{
			MethodName: "GetCustomTargetType",
			Handler:    _CloudDeploy_GetCustomTargetType_Handler,
		},
		{
			MethodName: "CreateCustomTargetType",
			Handler:    _CloudDeploy_CreateCustomTargetType_Handler,
		},
		{
			MethodName: "UpdateCustomTargetType",
			Handler:    _CloudDeploy_UpdateCustomTargetType_Handler,
		},
		{
			MethodName: "DeleteCustomTargetType",
			Handler:    _CloudDeploy_DeleteCustomTargetType_Handler,
		},
		{
			MethodName: "ListReleases",
			Handler:    _CloudDeploy_ListReleases_Handler,
		},
		{
			MethodName: "GetRelease",
			Handler:    _CloudDeploy_GetRelease_Handler,
		},
		{
			MethodName: "CreateRelease",
			Handler:    _CloudDeploy_CreateRelease_Handler,
		},
		{
			MethodName: "AbandonRelease",
			Handler:    _CloudDeploy_AbandonRelease_Handler,
		},
		{
			MethodName: "CreateDeployPolicy",
			Handler:    _CloudDeploy_CreateDeployPolicy_Handler,
		},
		{
			MethodName: "UpdateDeployPolicy",
			Handler:    _CloudDeploy_UpdateDeployPolicy_Handler,
		},
		{
			MethodName: "DeleteDeployPolicy",
			Handler:    _CloudDeploy_DeleteDeployPolicy_Handler,
		},
		{
			MethodName: "ListDeployPolicies",
			Handler:    _CloudDeploy_ListDeployPolicies_Handler,
		},
		{
			MethodName: "GetDeployPolicy",
			Handler:    _CloudDeploy_GetDeployPolicy_Handler,
		},
		{
			MethodName: "ApproveRollout",
			Handler:    _CloudDeploy_ApproveRollout_Handler,
		},
		{
			MethodName: "AdvanceRollout",
			Handler:    _CloudDeploy_AdvanceRollout_Handler,
		},
		{
			MethodName: "CancelRollout",
			Handler:    _CloudDeploy_CancelRollout_Handler,
		},
		{
			MethodName: "ListRollouts",
			Handler:    _CloudDeploy_ListRollouts_Handler,
		},
		{
			MethodName: "GetRollout",
			Handler:    _CloudDeploy_GetRollout_Handler,
		},
		{
			MethodName: "CreateRollout",
			Handler:    _CloudDeploy_CreateRollout_Handler,
		},
		{
			MethodName: "IgnoreJob",
			Handler:    _CloudDeploy_IgnoreJob_Handler,
		},
		{
			MethodName: "RetryJob",
			Handler:    _CloudDeploy_RetryJob_Handler,
		},
		{
			MethodName: "ListJobRuns",
			Handler:    _CloudDeploy_ListJobRuns_Handler,
		},
		{
			MethodName: "GetJobRun",
			Handler:    _CloudDeploy_GetJobRun_Handler,
		},
		{
			MethodName: "TerminateJobRun",
			Handler:    _CloudDeploy_TerminateJobRun_Handler,
		},
		{
			MethodName: "GetConfig",
			Handler:    _CloudDeploy_GetConfig_Handler,
		},
		{
			MethodName: "CreateAutomation",
			Handler:    _CloudDeploy_CreateAutomation_Handler,
		},
		{
			MethodName: "UpdateAutomation",
			Handler:    _CloudDeploy_UpdateAutomation_Handler,
		},
		{
			MethodName: "DeleteAutomation",
			Handler:    _CloudDeploy_DeleteAutomation_Handler,
		},
		{
			MethodName: "GetAutomation",
			Handler:    _CloudDeploy_GetAutomation_Handler,
		},
		{
			MethodName: "ListAutomations",
			Handler:    _CloudDeploy_ListAutomations_Handler,
		},
		{
			MethodName: "GetAutomationRun",
			Handler:    _CloudDeploy_GetAutomationRun_Handler,
		},
		{
			MethodName: "ListAutomationRuns",
			Handler:    _CloudDeploy_ListAutomationRuns_Handler,
		},
		{
			MethodName: "CancelAutomationRun",
			Handler:    _CloudDeploy_CancelAutomationRun_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/deploy/v1/cloud_deploy.proto",
}
