// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

package gkemulticloud

import (
	"context"
	"fmt"
	"log/slog"
	"math"
	"net/url"
	"time"

	gkemulticloudpb "cloud.google.com/go/gkemulticloud/apiv1/gkemulticloudpb"
	"cloud.google.com/go/longrunning"
	lroauto "cloud.google.com/go/longrunning/autogen"
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	gax "github.com/googleapis/gax-go/v2"
	"google.golang.org/api/iterator"
	"google.golang.org/api/option"
	"google.golang.org/api/option/internaloption"
	gtransport "google.golang.org/api/transport/grpc"
	"google.golang.org/grpc"
	"google.golang.org/grpc/codes"
	"google.golang.org/protobuf/proto"
)

var newAzureClustersClientHook clientHook

// AzureClustersCallOptions contains the retry settings for each method of AzureClustersClient.
type AzureClustersCallOptions struct {
	CreateAzureClient              []gax.CallOption
	GetAzureClient                 []gax.CallOption
	ListAzureClients               []gax.CallOption
	DeleteAzureClient              []gax.CallOption
	CreateAzureCluster             []gax.CallOption
	UpdateAzureCluster             []gax.CallOption
	GetAzureCluster                []gax.CallOption
	ListAzureClusters              []gax.CallOption
	DeleteAzureCluster             []gax.CallOption
	GenerateAzureClusterAgentToken []gax.CallOption
	GenerateAzureAccessToken       []gax.CallOption
	CreateAzureNodePool            []gax.CallOption
	UpdateAzureNodePool            []gax.CallOption
	GetAzureNodePool               []gax.CallOption
	ListAzureNodePools             []gax.CallOption
	DeleteAzureNodePool            []gax.CallOption
	GetAzureOpenIdConfig           []gax.CallOption
	GetAzureJsonWebKeys            []gax.CallOption
	GetAzureServerConfig           []gax.CallOption
	CancelOperation                []gax.CallOption
	DeleteOperation                []gax.CallOption
	GetOperation                   []gax.CallOption
	ListOperations                 []gax.CallOption
}

func defaultAzureClustersGRPCClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("gkemulticloud.googleapis.com:443"),
		internaloption.WithDefaultEndpointTemplate("gkemulticloud.UNIVERSE_DOMAIN:443"),
		internaloption.WithDefaultMTLSEndpoint("gkemulticloud.mtls.googleapis.com:443"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://gkemulticloud.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableJwtWithScope(),
		internaloption.EnableNewAuthLibrary(),
		option.WithGRPCDialOption(grpc.WithDefaultCallOptions(
			grpc.MaxCallRecvMsgSize(math.MaxInt32))),
	}
}

func defaultAzureClustersCallOptions() *AzureClustersCallOptions {
	return &AzureClustersCallOptions{
		CreateAzureClient: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetAzureClient: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		ListAzureClients: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		DeleteAzureClient: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreateAzureCluster: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateAzureCluster: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetAzureCluster: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		ListAzureClusters: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		DeleteAzureCluster: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GenerateAzureClusterAgentToken: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		GenerateAzureAccessToken: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		CreateAzureNodePool: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateAzureNodePool: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetAzureNodePool: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		ListAzureNodePools: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		DeleteAzureNodePool: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetAzureOpenIdConfig: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		GetAzureJsonWebKeys: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		GetAzureServerConfig: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		CancelOperation: []gax.CallOption{},
		DeleteOperation: []gax.CallOption{},
		GetOperation:    []gax.CallOption{},
		ListOperations:  []gax.CallOption{},
	}
}

// internalAzureClustersClient is an interface that defines the methods available from GKE Multi-Cloud API.
type internalAzureClustersClient interface {
	Close() error
	setGoogleClientInfo(...string)
	Connection() *grpc.ClientConn
	CreateAzureClient(context.Context, *gkemulticloudpb.CreateAzureClientRequest, ...gax.CallOption) (*CreateAzureClientOperation, error)
	CreateAzureClientOperation(name string) *CreateAzureClientOperation
	GetAzureClient(context.Context, *gkemulticloudpb.GetAzureClientRequest, ...gax.CallOption) (*gkemulticloudpb.AzureClient, error)
	ListAzureClients(context.Context, *gkemulticloudpb.ListAzureClientsRequest, ...gax.CallOption) *AzureClientIterator
	DeleteAzureClient(context.Context, *gkemulticloudpb.DeleteAzureClientRequest, ...gax.CallOption) (*DeleteAzureClientOperation, error)
	DeleteAzureClientOperation(name string) *DeleteAzureClientOperation
	CreateAzureCluster(context.Context, *gkemulticloudpb.CreateAzureClusterRequest, ...gax.CallOption) (*CreateAzureClusterOperation, error)
	CreateAzureClusterOperation(name string) *CreateAzureClusterOperation
	UpdateAzureCluster(context.Context, *gkemulticloudpb.UpdateAzureClusterRequest, ...gax.CallOption) (*UpdateAzureClusterOperation, error)
	UpdateAzureClusterOperation(name string) *UpdateAzureClusterOperation
	GetAzureCluster(context.Context, *gkemulticloudpb.GetAzureClusterRequest, ...gax.CallOption) (*gkemulticloudpb.AzureCluster, error)
	ListAzureClusters(context.Context, *gkemulticloudpb.ListAzureClustersRequest, ...gax.CallOption) *AzureClusterIterator
	DeleteAzureCluster(context.Context, *gkemulticloudpb.DeleteAzureClusterRequest, ...gax.CallOption) (*DeleteAzureClusterOperation, error)
	DeleteAzureClusterOperation(name string) *DeleteAzureClusterOperation
	GenerateAzureClusterAgentToken(context.Context, *gkemulticloudpb.GenerateAzureClusterAgentTokenRequest, ...gax.CallOption) (*gkemulticloudpb.GenerateAzureClusterAgentTokenResponse, error)
	GenerateAzureAccessToken(context.Context, *gkemulticloudpb.GenerateAzureAccessTokenRequest, ...gax.CallOption) (*gkemulticloudpb.GenerateAzureAccessTokenResponse, error)
	CreateAzureNodePool(context.Context, *gkemulticloudpb.CreateAzureNodePoolRequest, ...gax.CallOption) (*CreateAzureNodePoolOperation, error)
	CreateAzureNodePoolOperation(name string) *CreateAzureNodePoolOperation
	UpdateAzureNodePool(context.Context, *gkemulticloudpb.UpdateAzureNodePoolRequest, ...gax.CallOption) (*UpdateAzureNodePoolOperation, error)
	UpdateAzureNodePoolOperation(name string) *UpdateAzureNodePoolOperation
	GetAzureNodePool(context.Context, *gkemulticloudpb.GetAzureNodePoolRequest, ...gax.CallOption) (*gkemulticloudpb.AzureNodePool, error)
	ListAzureNodePools(context.Context, *gkemulticloudpb.ListAzureNodePoolsRequest, ...gax.CallOption) *AzureNodePoolIterator
	DeleteAzureNodePool(context.Context, *gkemulticloudpb.DeleteAzureNodePoolRequest, ...gax.CallOption) (*DeleteAzureNodePoolOperation, error)
	DeleteAzureNodePoolOperation(name string) *DeleteAzureNodePoolOperation
	GetAzureOpenIdConfig(context.Context, *gkemulticloudpb.GetAzureOpenIdConfigRequest, ...gax.CallOption) (*gkemulticloudpb.AzureOpenIdConfig, error)
	GetAzureJsonWebKeys(context.Context, *gkemulticloudpb.GetAzureJsonWebKeysRequest, ...gax.CallOption) (*gkemulticloudpb.AzureJsonWebKeys, error)
	GetAzureServerConfig(context.Context, *gkemulticloudpb.GetAzureServerConfigRequest, ...gax.CallOption) (*gkemulticloudpb.AzureServerConfig, error)
	CancelOperation(context.Context, *longrunningpb.CancelOperationRequest, ...gax.CallOption) error
	DeleteOperation(context.Context, *longrunningpb.DeleteOperationRequest, ...gax.CallOption) error
	GetOperation(context.Context, *longrunningpb.GetOperationRequest, ...gax.CallOption) (*longrunningpb.Operation, error)
	ListOperations(context.Context, *longrunningpb.ListOperationsRequest, ...gax.CallOption) *OperationIterator
}

// AzureClustersClient is a client for interacting with GKE Multi-Cloud API.
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
//
// The AzureClusters API provides a single centrally managed service
// to create and manage Anthos clusters that run on Azure infrastructure.
type AzureClustersClient struct {
	// The internal transport-dependent client.
	internalClient internalAzureClustersClient

	// The call options for this service.
	CallOptions *AzureClustersCallOptions

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient *lroauto.OperationsClient
}

// Wrapper methods routed to the internal client.

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *AzureClustersClient) Close() error {
	return c.internalClient.Close()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *AzureClustersClient) setGoogleClientInfo(keyval ...string) {
	c.internalClient.setGoogleClientInfo(keyval...)
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *AzureClustersClient) Connection() *grpc.ClientConn {
	return c.internalClient.Connection()
}

// CreateAzureClient creates a new AzureClient
// resource on a given Google Cloud project and region.
//
// AzureClient resources hold client authentication
// information needed by the Anthos Multicloud API to manage Azure resources
// on your Azure subscription on your behalf.
//
// If successful, the response contains a newly created
// Operation resource that can be
// described to track the status of the operation.
func (c *AzureClustersClient) CreateAzureClient(ctx context.Context, req *gkemulticloudpb.CreateAzureClientRequest, opts ...gax.CallOption) (*CreateAzureClientOperation, error) {
	return c.internalClient.CreateAzureClient(ctx, req, opts...)
}

// CreateAzureClientOperation returns a new CreateAzureClientOperation from a given name.
// The name must be that of a previously created CreateAzureClientOperation, possibly from a different process.
func (c *AzureClustersClient) CreateAzureClientOperation(name string) *CreateAzureClientOperation {
	return c.internalClient.CreateAzureClientOperation(name)
}

// GetAzureClient describes a specific
// AzureClient resource.
func (c *AzureClustersClient) GetAzureClient(ctx context.Context, req *gkemulticloudpb.GetAzureClientRequest, opts ...gax.CallOption) (*gkemulticloudpb.AzureClient, error) {
	return c.internalClient.GetAzureClient(ctx, req, opts...)
}

// ListAzureClients lists all AzureClient
// resources on a given Google Cloud project and region.
func (c *AzureClustersClient) ListAzureClients(ctx context.Context, req *gkemulticloudpb.ListAzureClientsRequest, opts ...gax.CallOption) *AzureClientIterator {
	return c.internalClient.ListAzureClients(ctx, req, opts...)
}

// DeleteAzureClient deletes a specific AzureClient
// resource.
//
// If the client is used by one or more clusters, deletion will
// fail and a FAILED_PRECONDITION error will be returned.
//
// If successful, the response contains a newly created
// Operation resource that can be
// described to track the status of the operation.
func (c *AzureClustersClient) DeleteAzureClient(ctx context.Context, req *gkemulticloudpb.DeleteAzureClientRequest, opts ...gax.CallOption) (*DeleteAzureClientOperation, error) {
	return c.internalClient.DeleteAzureClient(ctx, req, opts...)
}

// DeleteAzureClientOperation returns a new DeleteAzureClientOperation from a given name.
// The name must be that of a previously created DeleteAzureClientOperation, possibly from a different process.
func (c *AzureClustersClient) DeleteAzureClientOperation(name string) *DeleteAzureClientOperation {
	return c.internalClient.DeleteAzureClientOperation(name)
}

// CreateAzureCluster creates a new AzureCluster
// resource on a given Google Cloud Platform project and region.
//
// If successful, the response contains a newly created
// Operation resource that can be
// described to track the status of the operation.
func (c *AzureClustersClient) CreateAzureCluster(ctx context.Context, req *gkemulticloudpb.CreateAzureClusterRequest, opts ...gax.CallOption) (*CreateAzureClusterOperation, error) {
	return c.internalClient.CreateAzureCluster(ctx, req, opts...)
}

// CreateAzureClusterOperation returns a new CreateAzureClusterOperation from a given name.
// The name must be that of a previously created CreateAzureClusterOperation, possibly from a different process.
func (c *AzureClustersClient) CreateAzureClusterOperation(name string) *CreateAzureClusterOperation {
	return c.internalClient.CreateAzureClusterOperation(name)
}

// UpdateAzureCluster updates an AzureCluster.
func (c *AzureClustersClient) UpdateAzureCluster(ctx context.Context, req *gkemulticloudpb.UpdateAzureClusterRequest, opts ...gax.CallOption) (*UpdateAzureClusterOperation, error) {
	return c.internalClient.UpdateAzureCluster(ctx, req, opts...)
}

// UpdateAzureClusterOperation returns a new UpdateAzureClusterOperation from a given name.
// The name must be that of a previously created UpdateAzureClusterOperation, possibly from a different process.
func (c *AzureClustersClient) UpdateAzureClusterOperation(name string) *UpdateAzureClusterOperation {
	return c.internalClient.UpdateAzureClusterOperation(name)
}

// GetAzureCluster describes a specific
// AzureCluster resource.
func (c *AzureClustersClient) GetAzureCluster(ctx context.Context, req *gkemulticloudpb.GetAzureClusterRequest, opts ...gax.CallOption) (*gkemulticloudpb.AzureCluster, error) {
	return c.internalClient.GetAzureCluster(ctx, req, opts...)
}

// ListAzureClusters lists all AzureCluster
// resources on a given Google Cloud project and region.
func (c *AzureClustersClient) ListAzureClusters(ctx context.Context, req *gkemulticloudpb.ListAzureClustersRequest, opts ...gax.CallOption) *AzureClusterIterator {
	return c.internalClient.ListAzureClusters(ctx, req, opts...)
}

// DeleteAzureCluster deletes a specific
// AzureCluster resource.
//
// Fails if the cluster has one or more associated
// AzureNodePool resources.
//
// If successful, the response contains a newly created
// Operation resource that can be
// described to track the status of the operation.
func (c *AzureClustersClient) DeleteAzureCluster(ctx context.Context, req *gkemulticloudpb.DeleteAzureClusterRequest, opts ...gax.CallOption) (*DeleteAzureClusterOperation, error) {
	return c.internalClient.DeleteAzureCluster(ctx, req, opts...)
}

// DeleteAzureClusterOperation returns a new DeleteAzureClusterOperation from a given name.
// The name must be that of a previously created DeleteAzureClusterOperation, possibly from a different process.
func (c *AzureClustersClient) DeleteAzureClusterOperation(name string) *DeleteAzureClusterOperation {
	return c.internalClient.DeleteAzureClusterOperation(name)
}

// GenerateAzureClusterAgentToken generates an access token for a cluster agent.
func (c *AzureClustersClient) GenerateAzureClusterAgentToken(ctx context.Context, req *gkemulticloudpb.GenerateAzureClusterAgentTokenRequest, opts ...gax.CallOption) (*gkemulticloudpb.GenerateAzureClusterAgentTokenResponse, error) {
	return c.internalClient.GenerateAzureClusterAgentToken(ctx, req, opts...)
}

// GenerateAzureAccessToken generates a short-lived access token to authenticate to a given
// AzureCluster resource.
func (c *AzureClustersClient) GenerateAzureAccessToken(ctx context.Context, req *gkemulticloudpb.GenerateAzureAccessTokenRequest, opts ...gax.CallOption) (*gkemulticloudpb.GenerateAzureAccessTokenResponse, error) {
	return c.internalClient.GenerateAzureAccessToken(ctx, req, opts...)
}

// CreateAzureNodePool creates a new AzureNodePool,
// attached to a given
// AzureCluster.
//
// If successful, the response contains a newly created
// Operation resource that can be
// described to track the status of the operation.
func (c *AzureClustersClient) CreateAzureNodePool(ctx context.Context, req *gkemulticloudpb.CreateAzureNodePoolRequest, opts ...gax.CallOption) (*CreateAzureNodePoolOperation, error) {
	return c.internalClient.CreateAzureNodePool(ctx, req, opts...)
}

// CreateAzureNodePoolOperation returns a new CreateAzureNodePoolOperation from a given name.
// The name must be that of a previously created CreateAzureNodePoolOperation, possibly from a different process.
func (c *AzureClustersClient) CreateAzureNodePoolOperation(name string) *CreateAzureNodePoolOperation {
	return c.internalClient.CreateAzureNodePoolOperation(name)
}

// UpdateAzureNodePool updates an AzureNodePool.
func (c *AzureClustersClient) UpdateAzureNodePool(ctx context.Context, req *gkemulticloudpb.UpdateAzureNodePoolRequest, opts ...gax.CallOption) (*UpdateAzureNodePoolOperation, error) {
	return c.internalClient.UpdateAzureNodePool(ctx, req, opts...)
}

// UpdateAzureNodePoolOperation returns a new UpdateAzureNodePoolOperation from a given name.
// The name must be that of a previously created UpdateAzureNodePoolOperation, possibly from a different process.
func (c *AzureClustersClient) UpdateAzureNodePoolOperation(name string) *UpdateAzureNodePoolOperation {
	return c.internalClient.UpdateAzureNodePoolOperation(name)
}

// GetAzureNodePool describes a specific
// AzureNodePool resource.
func (c *AzureClustersClient) GetAzureNodePool(ctx context.Context, req *gkemulticloudpb.GetAzureNodePoolRequest, opts ...gax.CallOption) (*gkemulticloudpb.AzureNodePool, error) {
	return c.internalClient.GetAzureNodePool(ctx, req, opts...)
}

// ListAzureNodePools lists all AzureNodePool
// resources on a given
// AzureCluster.
func (c *AzureClustersClient) ListAzureNodePools(ctx context.Context, req *gkemulticloudpb.ListAzureNodePoolsRequest, opts ...gax.CallOption) *AzureNodePoolIterator {
	return c.internalClient.ListAzureNodePools(ctx, req, opts...)
}

// DeleteAzureNodePool deletes a specific
// AzureNodePool resource.
//
// If successful, the response contains a newly created
// Operation resource that can be
// described to track the status of the operation.
func (c *AzureClustersClient) DeleteAzureNodePool(ctx context.Context, req *gkemulticloudpb.DeleteAzureNodePoolRequest, opts ...gax.CallOption) (*DeleteAzureNodePoolOperation, error) {
	return c.internalClient.DeleteAzureNodePool(ctx, req, opts...)
}

// DeleteAzureNodePoolOperation returns a new DeleteAzureNodePoolOperation from a given name.
// The name must be that of a previously created DeleteAzureNodePoolOperation, possibly from a different process.
func (c *AzureClustersClient) DeleteAzureNodePoolOperation(name string) *DeleteAzureNodePoolOperation {
	return c.internalClient.DeleteAzureNodePoolOperation(name)
}

// GetAzureOpenIdConfig gets the OIDC discovery document for the cluster.
// See the
// OpenID Connect Discovery 1.0
// specification (at https://openid.net/specs/openid-connect-discovery-1_0.html)
// for details.
func (c *AzureClustersClient) GetAzureOpenIdConfig(ctx context.Context, req *gkemulticloudpb.GetAzureOpenIdConfigRequest, opts ...gax.CallOption) (*gkemulticloudpb.AzureOpenIdConfig, error) {
	return c.internalClient.GetAzureOpenIdConfig(ctx, req, opts...)
}

// GetAzureJsonWebKeys gets the public component of the cluster signing keys in
// JSON Web Key format.
func (c *AzureClustersClient) GetAzureJsonWebKeys(ctx context.Context, req *gkemulticloudpb.GetAzureJsonWebKeysRequest, opts ...gax.CallOption) (*gkemulticloudpb.AzureJsonWebKeys, error) {
	return c.internalClient.GetAzureJsonWebKeys(ctx, req, opts...)
}

// GetAzureServerConfig returns information, such as supported Azure regions and Kubernetes
// versions, on a given Google Cloud location.
func (c *AzureClustersClient) GetAzureServerConfig(ctx context.Context, req *gkemulticloudpb.GetAzureServerConfigRequest, opts ...gax.CallOption) (*gkemulticloudpb.AzureServerConfig, error) {
	return c.internalClient.GetAzureServerConfig(ctx, req, opts...)
}

// CancelOperation is a utility method from google.longrunning.Operations.
func (c *AzureClustersClient) CancelOperation(ctx context.Context, req *longrunningpb.CancelOperationRequest, opts ...gax.CallOption) error {
	return c.internalClient.CancelOperation(ctx, req, opts...)
}

// DeleteOperation is a utility method from google.longrunning.Operations.
func (c *AzureClustersClient) DeleteOperation(ctx context.Context, req *longrunningpb.DeleteOperationRequest, opts ...gax.CallOption) error {
	return c.internalClient.DeleteOperation(ctx, req, opts...)
}

// GetOperation is a utility method from google.longrunning.Operations.
func (c *AzureClustersClient) GetOperation(ctx context.Context, req *longrunningpb.GetOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	return c.internalClient.GetOperation(ctx, req, opts...)
}

// ListOperations is a utility method from google.longrunning.Operations.
func (c *AzureClustersClient) ListOperations(ctx context.Context, req *longrunningpb.ListOperationsRequest, opts ...gax.CallOption) *OperationIterator {
	return c.internalClient.ListOperations(ctx, req, opts...)
}

// azureClustersGRPCClient is a client for interacting with GKE Multi-Cloud API over gRPC transport.
//
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type azureClustersGRPCClient struct {
	// Connection pool of gRPC connections to the service.
	connPool gtransport.ConnPool

	// Points back to the CallOptions field of the containing AzureClustersClient
	CallOptions **AzureClustersCallOptions

	// The gRPC API client.
	azureClustersClient gkemulticloudpb.AzureClustersClient

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient **lroauto.OperationsClient

	operationsClient longrunningpb.OperationsClient

	// The x-goog-* metadata to be sent with each request.
	xGoogHeaders []string

	logger *slog.Logger
}

// NewAzureClustersClient creates a new azure clusters client based on gRPC.
// The returned client must be Closed when it is done being used to clean up its underlying connections.
//
// The AzureClusters API provides a single centrally managed service
// to create and manage Anthos clusters that run on Azure infrastructure.
func NewAzureClustersClient(ctx context.Context, opts ...option.ClientOption) (*AzureClustersClient, error) {
	clientOpts := defaultAzureClustersGRPCClientOptions()
	if newAzureClustersClientHook != nil {
		hookOpts, err := newAzureClustersClientHook(ctx, clientHookParams{})
		if err != nil {
			return nil, err
		}
		clientOpts = append(clientOpts, hookOpts...)
	}

	connPool, err := gtransport.DialPool(ctx, append(clientOpts, opts...)...)
	if err != nil {
		return nil, err
	}
	client := AzureClustersClient{CallOptions: defaultAzureClustersCallOptions()}

	c := &azureClustersGRPCClient{
		connPool:            connPool,
		azureClustersClient: gkemulticloudpb.NewAzureClustersClient(connPool),
		CallOptions:         &client.CallOptions,
		logger:              internaloption.GetLogger(opts),
		operationsClient:    longrunningpb.NewOperationsClient(connPool),
	}
	c.setGoogleClientInfo()

	client.internalClient = c

	client.LROClient, err = lroauto.NewOperationsClient(ctx, gtransport.WithConnPool(connPool))
	if err != nil {
		// This error "should not happen", since we are just reusing old connection pool
		// and never actually need to dial.
		// If this does happen, we could leak connp. However, we cannot close conn:
		// If the user invoked the constructor with option.WithGRPCConn,
		// we would close a connection that's still in use.
		// TODO: investigate error conditions.
		return nil, err
	}
	c.LROClient = &client.LROClient
	return &client, nil
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *azureClustersGRPCClient) Connection() *grpc.ClientConn {
	return c.connPool.Conn()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *azureClustersGRPCClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "grpc", grpc.Version)
	c.xGoogHeaders = []string{
		"x-goog-api-client", gax.XGoogHeader(kv...),
	}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *azureClustersGRPCClient) Close() error {
	return c.connPool.Close()
}

func (c *azureClustersGRPCClient) CreateAzureClient(ctx context.Context, req *gkemulticloudpb.CreateAzureClientRequest, opts ...gax.CallOption) (*CreateAzureClientOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateAzureClient[0:len((*c.CallOptions).CreateAzureClient):len((*c.CallOptions).CreateAzureClient)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.azureClustersClient.CreateAzureClient, req, settings.GRPC, c.logger, "CreateAzureClient")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateAzureClientOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *azureClustersGRPCClient) GetAzureClient(ctx context.Context, req *gkemulticloudpb.GetAzureClientRequest, opts ...gax.CallOption) (*gkemulticloudpb.AzureClient, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetAzureClient[0:len((*c.CallOptions).GetAzureClient):len((*c.CallOptions).GetAzureClient)], opts...)
	var resp *gkemulticloudpb.AzureClient
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.azureClustersClient.GetAzureClient, req, settings.GRPC, c.logger, "GetAzureClient")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *azureClustersGRPCClient) ListAzureClients(ctx context.Context, req *gkemulticloudpb.ListAzureClientsRequest, opts ...gax.CallOption) *AzureClientIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListAzureClients[0:len((*c.CallOptions).ListAzureClients):len((*c.CallOptions).ListAzureClients)], opts...)
	it := &AzureClientIterator{}
	req = proto.Clone(req).(*gkemulticloudpb.ListAzureClientsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*gkemulticloudpb.AzureClient, string, error) {
		resp := &gkemulticloudpb.ListAzureClientsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.azureClustersClient.ListAzureClients, req, settings.GRPC, c.logger, "ListAzureClients")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetAzureClients(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *azureClustersGRPCClient) DeleteAzureClient(ctx context.Context, req *gkemulticloudpb.DeleteAzureClientRequest, opts ...gax.CallOption) (*DeleteAzureClientOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteAzureClient[0:len((*c.CallOptions).DeleteAzureClient):len((*c.CallOptions).DeleteAzureClient)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.azureClustersClient.DeleteAzureClient, req, settings.GRPC, c.logger, "DeleteAzureClient")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteAzureClientOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *azureClustersGRPCClient) CreateAzureCluster(ctx context.Context, req *gkemulticloudpb.CreateAzureClusterRequest, opts ...gax.CallOption) (*CreateAzureClusterOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateAzureCluster[0:len((*c.CallOptions).CreateAzureCluster):len((*c.CallOptions).CreateAzureCluster)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.azureClustersClient.CreateAzureCluster, req, settings.GRPC, c.logger, "CreateAzureCluster")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateAzureClusterOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *azureClustersGRPCClient) UpdateAzureCluster(ctx context.Context, req *gkemulticloudpb.UpdateAzureClusterRequest, opts ...gax.CallOption) (*UpdateAzureClusterOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "azure_cluster.name", url.QueryEscape(req.GetAzureCluster().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateAzureCluster[0:len((*c.CallOptions).UpdateAzureCluster):len((*c.CallOptions).UpdateAzureCluster)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.azureClustersClient.UpdateAzureCluster, req, settings.GRPC, c.logger, "UpdateAzureCluster")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateAzureClusterOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *azureClustersGRPCClient) GetAzureCluster(ctx context.Context, req *gkemulticloudpb.GetAzureClusterRequest, opts ...gax.CallOption) (*gkemulticloudpb.AzureCluster, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetAzureCluster[0:len((*c.CallOptions).GetAzureCluster):len((*c.CallOptions).GetAzureCluster)], opts...)
	var resp *gkemulticloudpb.AzureCluster
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.azureClustersClient.GetAzureCluster, req, settings.GRPC, c.logger, "GetAzureCluster")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *azureClustersGRPCClient) ListAzureClusters(ctx context.Context, req *gkemulticloudpb.ListAzureClustersRequest, opts ...gax.CallOption) *AzureClusterIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListAzureClusters[0:len((*c.CallOptions).ListAzureClusters):len((*c.CallOptions).ListAzureClusters)], opts...)
	it := &AzureClusterIterator{}
	req = proto.Clone(req).(*gkemulticloudpb.ListAzureClustersRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*gkemulticloudpb.AzureCluster, string, error) {
		resp := &gkemulticloudpb.ListAzureClustersResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.azureClustersClient.ListAzureClusters, req, settings.GRPC, c.logger, "ListAzureClusters")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetAzureClusters(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *azureClustersGRPCClient) DeleteAzureCluster(ctx context.Context, req *gkemulticloudpb.DeleteAzureClusterRequest, opts ...gax.CallOption) (*DeleteAzureClusterOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteAzureCluster[0:len((*c.CallOptions).DeleteAzureCluster):len((*c.CallOptions).DeleteAzureCluster)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.azureClustersClient.DeleteAzureCluster, req, settings.GRPC, c.logger, "DeleteAzureCluster")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteAzureClusterOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *azureClustersGRPCClient) GenerateAzureClusterAgentToken(ctx context.Context, req *gkemulticloudpb.GenerateAzureClusterAgentTokenRequest, opts ...gax.CallOption) (*gkemulticloudpb.GenerateAzureClusterAgentTokenResponse, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "azure_cluster", url.QueryEscape(req.GetAzureCluster()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GenerateAzureClusterAgentToken[0:len((*c.CallOptions).GenerateAzureClusterAgentToken):len((*c.CallOptions).GenerateAzureClusterAgentToken)], opts...)
	var resp *gkemulticloudpb.GenerateAzureClusterAgentTokenResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.azureClustersClient.GenerateAzureClusterAgentToken, req, settings.GRPC, c.logger, "GenerateAzureClusterAgentToken")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *azureClustersGRPCClient) GenerateAzureAccessToken(ctx context.Context, req *gkemulticloudpb.GenerateAzureAccessTokenRequest, opts ...gax.CallOption) (*gkemulticloudpb.GenerateAzureAccessTokenResponse, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "azure_cluster", url.QueryEscape(req.GetAzureCluster()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GenerateAzureAccessToken[0:len((*c.CallOptions).GenerateAzureAccessToken):len((*c.CallOptions).GenerateAzureAccessToken)], opts...)
	var resp *gkemulticloudpb.GenerateAzureAccessTokenResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.azureClustersClient.GenerateAzureAccessToken, req, settings.GRPC, c.logger, "GenerateAzureAccessToken")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *azureClustersGRPCClient) CreateAzureNodePool(ctx context.Context, req *gkemulticloudpb.CreateAzureNodePoolRequest, opts ...gax.CallOption) (*CreateAzureNodePoolOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateAzureNodePool[0:len((*c.CallOptions).CreateAzureNodePool):len((*c.CallOptions).CreateAzureNodePool)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.azureClustersClient.CreateAzureNodePool, req, settings.GRPC, c.logger, "CreateAzureNodePool")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateAzureNodePoolOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *azureClustersGRPCClient) UpdateAzureNodePool(ctx context.Context, req *gkemulticloudpb.UpdateAzureNodePoolRequest, opts ...gax.CallOption) (*UpdateAzureNodePoolOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "azure_node_pool.name", url.QueryEscape(req.GetAzureNodePool().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateAzureNodePool[0:len((*c.CallOptions).UpdateAzureNodePool):len((*c.CallOptions).UpdateAzureNodePool)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.azureClustersClient.UpdateAzureNodePool, req, settings.GRPC, c.logger, "UpdateAzureNodePool")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateAzureNodePoolOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *azureClustersGRPCClient) GetAzureNodePool(ctx context.Context, req *gkemulticloudpb.GetAzureNodePoolRequest, opts ...gax.CallOption) (*gkemulticloudpb.AzureNodePool, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetAzureNodePool[0:len((*c.CallOptions).GetAzureNodePool):len((*c.CallOptions).GetAzureNodePool)], opts...)
	var resp *gkemulticloudpb.AzureNodePool
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.azureClustersClient.GetAzureNodePool, req, settings.GRPC, c.logger, "GetAzureNodePool")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *azureClustersGRPCClient) ListAzureNodePools(ctx context.Context, req *gkemulticloudpb.ListAzureNodePoolsRequest, opts ...gax.CallOption) *AzureNodePoolIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListAzureNodePools[0:len((*c.CallOptions).ListAzureNodePools):len((*c.CallOptions).ListAzureNodePools)], opts...)
	it := &AzureNodePoolIterator{}
	req = proto.Clone(req).(*gkemulticloudpb.ListAzureNodePoolsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*gkemulticloudpb.AzureNodePool, string, error) {
		resp := &gkemulticloudpb.ListAzureNodePoolsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.azureClustersClient.ListAzureNodePools, req, settings.GRPC, c.logger, "ListAzureNodePools")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetAzureNodePools(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *azureClustersGRPCClient) DeleteAzureNodePool(ctx context.Context, req *gkemulticloudpb.DeleteAzureNodePoolRequest, opts ...gax.CallOption) (*DeleteAzureNodePoolOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteAzureNodePool[0:len((*c.CallOptions).DeleteAzureNodePool):len((*c.CallOptions).DeleteAzureNodePool)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.azureClustersClient.DeleteAzureNodePool, req, settings.GRPC, c.logger, "DeleteAzureNodePool")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteAzureNodePoolOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *azureClustersGRPCClient) GetAzureOpenIdConfig(ctx context.Context, req *gkemulticloudpb.GetAzureOpenIdConfigRequest, opts ...gax.CallOption) (*gkemulticloudpb.AzureOpenIdConfig, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "azure_cluster", url.QueryEscape(req.GetAzureCluster()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetAzureOpenIdConfig[0:len((*c.CallOptions).GetAzureOpenIdConfig):len((*c.CallOptions).GetAzureOpenIdConfig)], opts...)
	var resp *gkemulticloudpb.AzureOpenIdConfig
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.azureClustersClient.GetAzureOpenIdConfig, req, settings.GRPC, c.logger, "GetAzureOpenIdConfig")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *azureClustersGRPCClient) GetAzureJsonWebKeys(ctx context.Context, req *gkemulticloudpb.GetAzureJsonWebKeysRequest, opts ...gax.CallOption) (*gkemulticloudpb.AzureJsonWebKeys, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "azure_cluster", url.QueryEscape(req.GetAzureCluster()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetAzureJsonWebKeys[0:len((*c.CallOptions).GetAzureJsonWebKeys):len((*c.CallOptions).GetAzureJsonWebKeys)], opts...)
	var resp *gkemulticloudpb.AzureJsonWebKeys
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.azureClustersClient.GetAzureJsonWebKeys, req, settings.GRPC, c.logger, "GetAzureJsonWebKeys")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *azureClustersGRPCClient) GetAzureServerConfig(ctx context.Context, req *gkemulticloudpb.GetAzureServerConfigRequest, opts ...gax.CallOption) (*gkemulticloudpb.AzureServerConfig, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetAzureServerConfig[0:len((*c.CallOptions).GetAzureServerConfig):len((*c.CallOptions).GetAzureServerConfig)], opts...)
	var resp *gkemulticloudpb.AzureServerConfig
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.azureClustersClient.GetAzureServerConfig, req, settings.GRPC, c.logger, "GetAzureServerConfig")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *azureClustersGRPCClient) CancelOperation(ctx context.Context, req *longrunningpb.CancelOperationRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CancelOperation[0:len((*c.CallOptions).CancelOperation):len((*c.CallOptions).CancelOperation)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = executeRPC(ctx, c.operationsClient.CancelOperation, req, settings.GRPC, c.logger, "CancelOperation")
		return err
	}, opts...)
	return err
}

func (c *azureClustersGRPCClient) DeleteOperation(ctx context.Context, req *longrunningpb.DeleteOperationRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteOperation[0:len((*c.CallOptions).DeleteOperation):len((*c.CallOptions).DeleteOperation)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = executeRPC(ctx, c.operationsClient.DeleteOperation, req, settings.GRPC, c.logger, "DeleteOperation")
		return err
	}, opts...)
	return err
}

func (c *azureClustersGRPCClient) GetOperation(ctx context.Context, req *longrunningpb.GetOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetOperation[0:len((*c.CallOptions).GetOperation):len((*c.CallOptions).GetOperation)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.operationsClient.GetOperation, req, settings.GRPC, c.logger, "GetOperation")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *azureClustersGRPCClient) ListOperations(ctx context.Context, req *longrunningpb.ListOperationsRequest, opts ...gax.CallOption) *OperationIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListOperations[0:len((*c.CallOptions).ListOperations):len((*c.CallOptions).ListOperations)], opts...)
	it := &OperationIterator{}
	req = proto.Clone(req).(*longrunningpb.ListOperationsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*longrunningpb.Operation, string, error) {
		resp := &longrunningpb.ListOperationsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.operationsClient.ListOperations, req, settings.GRPC, c.logger, "ListOperations")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetOperations(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// CreateAzureClientOperation returns a new CreateAzureClientOperation from a given name.
// The name must be that of a previously created CreateAzureClientOperation, possibly from a different process.
func (c *azureClustersGRPCClient) CreateAzureClientOperation(name string) *CreateAzureClientOperation {
	return &CreateAzureClientOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateAzureClusterOperation returns a new CreateAzureClusterOperation from a given name.
// The name must be that of a previously created CreateAzureClusterOperation, possibly from a different process.
func (c *azureClustersGRPCClient) CreateAzureClusterOperation(name string) *CreateAzureClusterOperation {
	return &CreateAzureClusterOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateAzureNodePoolOperation returns a new CreateAzureNodePoolOperation from a given name.
// The name must be that of a previously created CreateAzureNodePoolOperation, possibly from a different process.
func (c *azureClustersGRPCClient) CreateAzureNodePoolOperation(name string) *CreateAzureNodePoolOperation {
	return &CreateAzureNodePoolOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteAzureClientOperation returns a new DeleteAzureClientOperation from a given name.
// The name must be that of a previously created DeleteAzureClientOperation, possibly from a different process.
func (c *azureClustersGRPCClient) DeleteAzureClientOperation(name string) *DeleteAzureClientOperation {
	return &DeleteAzureClientOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteAzureClusterOperation returns a new DeleteAzureClusterOperation from a given name.
// The name must be that of a previously created DeleteAzureClusterOperation, possibly from a different process.
func (c *azureClustersGRPCClient) DeleteAzureClusterOperation(name string) *DeleteAzureClusterOperation {
	return &DeleteAzureClusterOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteAzureNodePoolOperation returns a new DeleteAzureNodePoolOperation from a given name.
// The name must be that of a previously created DeleteAzureNodePoolOperation, possibly from a different process.
func (c *azureClustersGRPCClient) DeleteAzureNodePoolOperation(name string) *DeleteAzureNodePoolOperation {
	return &DeleteAzureNodePoolOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpdateAzureClusterOperation returns a new UpdateAzureClusterOperation from a given name.
// The name must be that of a previously created UpdateAzureClusterOperation, possibly from a different process.
func (c *azureClustersGRPCClient) UpdateAzureClusterOperation(name string) *UpdateAzureClusterOperation {
	return &UpdateAzureClusterOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpdateAzureNodePoolOperation returns a new UpdateAzureNodePoolOperation from a given name.
// The name must be that of a previously created UpdateAzureNodePoolOperation, possibly from a different process.
func (c *azureClustersGRPCClient) UpdateAzureNodePoolOperation(name string) *UpdateAzureNodePoolOperation {
	return &UpdateAzureNodePoolOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}
